<!DOCTYPE html>
    <html lang="es">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Polizas cotables</title>
    </head>

    <body>

    <?php

    require_once "config.php";

    $separador=" ";

    //consulta para recuperar datos
    $sql="SELECT 
            b.rowid, 
            a.uuid, 
            date_format(a.fechacfdi,'%Y%m%d') AS fechacfdi,
            b.total_tva AS iva,
            b.localtax1 AS ieps,
            b.total_ht,
            b.total_ttc,
            b.ref,
            c.nom
        FROM
            llx_facture_extrafields a,
            llx_facture b,
            llx_societe c
        WHERE
            b.rowid=a.fk_object AND
            b.fk_soc=c.rowid AND
            a.fechacfdi BETWEEN '2023-02-01' AND '2023-03-01' AND 
            a.cfdi=1 AND
            a.uuid IS NOT NULL AND
            a.fechacancelacion IS NULL";

    $resultado = mysqli_query($con, $sql);
    //echo $sql."</br>";

    echo "<pre>";

    $consecutivo=0;

    while ($row = mysqli_fetch_assoc($resultado)) {

        $consecutivo ++;

        $fk_facture=$row['rowid'];
        $uuid=$row['uuid'];
        $fechacfdi=$row['fechacfdi'];
        $ieps=$row['ieps'];
        $total_ht=$row['total_ht'];
        $total_ttc=$row['total_ttc'];
        $ref=$row['ref'];
        $nom=$row['nom'];
        $nombre= utf8_decode($nom); 

            //consulta para lineas de factura
            $sql_line="SELECT total_ttc FROM llx_facturedet WHERE fk_facture=".$fk_facture;

            $resul_line = mysqli_query($con,$sql_line);


        echo str_pad("P",2," ");
        echo $separador;
        echo str_pad($fechacfdi, 8,"  ");
        echo $separador;
        echo str_pad("3000",4," ");
        echo $separador;
        echo str_pad($consecutivo, 9," ",STR_PAD_LEFT);
        echo $separador;
        echo ("1");
        echo $separador;
        echo str_pad(" ",10," ");
        echo $separador;
        echo str_pad($nom, 100,"  ");
        echo $separador;
        echo str_pad("07",3," ");
        echo $separador;
        echo ("0 0 ");
        echo "</br>";

        echo str_pad("AD",2," ");
        echo $separador;
        echo str_pad($uuid, 36," ");
        echo $separador;
        echo "</br>";

        echo str_pad("M",2," ");
        echo $separador;
        echo str_pad("10501270",30," ");
        echo $separador;
        echo str_pad("-F ".$ref,10," ");
        echo $separador;
        echo str_pad("0",1," ");
        echo $separador;
        echo str_pad($total_ttc, 20,"  ");
        echo $separador;
        echo str_pad(" ",10," ");
        echo str_pad("0.00", 20,"  ");  
        echo $separador;
        echo str_pad($nom, 100,"  ");
        echo "</br>";

        echo str_pad("AM",2," ");
        echo $separador;
        echo str_pad($uuid, 36," ");
        echo $separador;
        echo "</br>";

        //lineas
        while ($row_line = mysqli_fetch_assoc($resul_line)){

            $total_linea=$row_line['total_ttc'];

        echo str_pad("M",2," ");
        echo $separador;
        echo str_pad("40104102",30," ");
        echo $separador;
        echo str_pad("-F ".$ref,10," ");
        echo $separador;
        echo str_pad("1",1," ");
        echo $separador;
        echo str_pad($total_linea, 20,"  ");
        echo $separador;
        echo str_pad(" ",10," ");
        echo str_pad("0.00", 20,"  ");  
        echo $separador;
        echo str_pad($nom, 100,"  ");
        echo "</br>";

        echo str_pad("AM",2," ");
        echo $separador;
        echo str_pad($uuid, 36," ");
        echo $separador;
        echo "</br>";

        }

        //ieps
        echo str_pad("M",2," ");
        echo $separador;
        echo str_pad("20902000",30," ");
        echo $separador;
        echo str_pad("-F ".$ref,10," ");
        echo $separador;
        echo str_pad("1",1," ");
        echo $separador;
        echo str_pad($ieps, 20,"  ");
        echo $separador;
        echo str_pad(" ",10," ");
        echo str_pad("0.00", 20,"  ");  
        echo $separador;
        echo str_pad($nom, 100,"  ");
        echo "</br>";

        echo str_pad("AM",2," ");
        echo $separador;
        echo str_pad($uuid, 36," ");
        echo $separador;
        echo "</br>";

    }

    echo "</pre>";

    ?>

     </body>

 </html>