<?php
/* Copyright (C) 2021 SuperAdmin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/**
 * \file    core/triggers/interface_99_modCFDI_CFDITriggers.class.php
 * \ingroup cfdi
 * \brief   Example trigger.
 *
 * Put detailed description here.
 *
 * \remarks You can create other triggers by copying this one.
 * - File name should be either:
 *      - interface_99_modCFDI_MyTrigger.class.php
 *      - interface_99_all_MyTrigger.class.php
 * - The file must stay in core/triggers
 * - The class name must be InterfaceMytrigger
 * - The constructor method must be named InterfaceMytrigger
 * - The name property name must be MyTrigger
 */
dol_include_once('/cfdi/vendor/autoload.php');
//header('Content-Type: text/html; charset=UTF-8');

require_once DOL_DOCUMENT_ROOT.'/core/triggers/dolibarrtriggers.class.php';



### 14. FUNCIONES DEL MÓDULO ###################################################
        
    # 14.1 Función que integra los nodos al archivo .XML y forma la "Cadena original".
    function cargaAtt(&$nodo, $attr){
        global $xml, $cadena_original;
        $quitar = array('sello'=>1,'noCertificado'=>1,'certificado'=>1);
        foreach ($attr as $key => $val){
            $val = preg_replace('/\s\s+/', ' ', $val);
            $val = trim($val);
            if (strlen($val)>0){
                 $val = str_replace("|","/",$val);
                 $nodo->setAttribute($key,$val);
                 if (!isset($quitar[$key])) 
                   if (substr($key,0,3) != "xml" &&
                       substr($key,0,4) != "xsi:")
                    $cadena_original .= $val . "|";
                //echo "</br> Cadena: ".$cadena_original."</br>";
            }
         }
     }
     
     
    # 14.2 Función que integra los nodos al archivo .XML sin integrar a la "Cadena original". 
    function cargaAttSinIntACad(&$nodo, $attr){
        global $xml;
        $quitar = array('sello'=>1,'noCertificado'=>1,'certificado'=>1);
        foreach ($attr as $key => $val){
            $val = preg_replace('/\s\s+/', ' ', $val);
            $val = trim($val);
            if (strlen($val)>0){
                 $val = str_replace("|","/",$val);
                 $nodo->setAttribute($key,$val);
                 if (!isset($quitar[$key])) 
                   if (substr($key,0,3) != "xml" &&
                       substr($key,0,4) != "xsi:");
            }
         }
     }     

    
    # 14.3 Funciónes que da formato al "Importe total" como lo requiere el SAT para ser integrado al código QR.
     
    function ProcesImpTot($ImpTot){
        $ImpTot = number_format($ImpTot, 4); // <== Se agregó el 30 de abril de 2017.
        $ArrayImpTot = explode(".", $ImpTot);
        $NumEnt = $ArrayImpTot[0];
        $NumDec = ProcesDecFac($ArrayImpTot[1]);
        
        return $NumEnt.".".$NumDec;
    }
    
    function ProcesDecFac($Num){
        $FolDec = "";
        if ($Num < 10){$FolDec = "00000".$Num;}
        if ($Num > 9 and $Num < 100){$FolDec = $Num."0000";}
        if ($Num > 99 and $Num < 1000){$FolDec = $Num."000";}
        if ($Num > 999 and $Num < 10000){$FolDec = $Num."00";}
        if ($Num > 9999 and $Num < 100000){$FolDec = $Num."0";}
        return $FolDec;
    }        
    

   
    
    
    

        
    
    


   






/**
 *  Class of triggers for CFDI module
 */
class InterfaceCFDITriggers extends DolibarrTriggers
{
	/**
	 * Constructor
	 *
	 * @param DoliDB $db Database handler
	 */
	public function __construct($db)
	{
		$this->db = $db;

		$this->name = preg_replace('/^Interface/i', '', get_class($this));
		$this->family = "demo";
		$this->description = "CFDI triggers.";
		// 'development', 'experimental', 'dolibarr' or version
		$this->version = 'development';
		$this->picto = 'cfdi@cfdi';
	}

	/**
	 * Trigger name
	 *
	 * @return string Name of trigger file
	 */
	public function getName()
	{
		return $this->name;
	}

	/**
	 * Trigger description
	 *
	 * @return string Description of trigger file
	 */
	public function getDesc()
	{
		return $this->description;
	}




	/**
	 * Function called when a Dolibarrr business event is done.
	 * All functions "runTrigger" are triggered if file
	 * is inside directory core/triggers
	 *
	 * @param string 		$action 	Event action code
	 * @param CommonObject 	$object 	Object
	 * @param User 			$user 		Object user
	 * @param Translate 	$langs 		Object langs
	 * @param Conf 			$conf 		Object conf
	 * @return int              		<0 if KO, 0 if no triggered ran, >0 if OK
	 */
	public function runTrigger($action, $object, User $user, Translate $langs, Conf $conf)
	{
		if (empty($conf->cfdi) || empty($conf->cfdi->enabled)) {
			return 0; // If module is not enabled, we do nothing
		}

		// Put here code you want to execute when a Dolibarr business events occurs.
		// Data and type of action are stored into $object and $action

		// You can isolate code for each action in a separate method: this method should be named like the trigger in camelCase.
		// For example : COMPANY_CREATE => public function companyCreate($action, $object, User $user, Translate $langs, Conf $conf)
		$methodName = lcfirst(str_replace(' ', '', ucwords(str_replace('_', ' ', strtolower($action)))));
		$callback = array($this, $methodName);
		if (is_callable($callback)) {
			dol_syslog(
				"Trigger '".$this->name."' for action '$action' launched by ".__FILE__.". id=".$object->id
			);

			return call_user_func($callback, $action, $object, $user, $langs, $conf);
		};

		// Or you can execute some code here
		switch ($action) {
			// Users
			//case 'USER_CREATE':
			//case 'USER_MODIFY':
			//case 'USER_NEW_PASSWORD':
			//case 'USER_ENABLEDISABLE':
			//case 'USER_DELETE':

			// Actions
			//case 'ACTION_MODIFY':
			//case 'ACTION_CREATE':
			//case 'ACTION_DELETE':

			// Groups
			//case 'USERGROUP_CREATE':
			//case 'USERGROUP_MODIFY':
			//case 'USERGROUP_DELETE':

			// Companies
			//case 'COMPANY_CREATE':
			//case 'COMPANY_MODIFY':
			//case 'COMPANY_DELETE':

			// Contacts
			//case 'CONTACT_CREATE':
			//case 'CONTACT_MODIFY':
			//case 'CONTACT_DELETE':
			//case 'CONTACT_ENABLEDISABLE':

			// Products
			//case 'PRODUCT_CREATE':
			//case 'PRODUCT_MODIFY':
			//case 'PRODUCT_DELETE':
			//case 'PRODUCT_PRICE_MODIFY':
			//case 'PRODUCT_SET_MULTILANGS':
			//case 'PRODUCT_DEL_MULTILANGS':

			//Stock mouvement
			//case 'STOCK_MOVEMENT':

			//MYECMDIR
			//case 'MYECMDIR_CREATE':
			//case 'MYECMDIR_MODIFY':
			//case 'MYECMDIR_DELETE':

			// Customer orders
			//case 'ORDER_CREATE':
			//case 'ORDER_MODIFY':
			//case 'ORDER_VALIDATE':
			//case 'ORDER_DELETE':
			//case 'ORDER_CANCEL':
			//case 'ORDER_SENTBYMAIL':
			//case 'ORDER_CLASSIFY_BILLED':
			//case 'ORDER_SETDRAFT':
			//case 'LINEORDER_INSERT':
			//case 'LINEORDER_UPDATE':
			//case 'LINEORDER_DELETE':

			// Supplier orders
			//case 'ORDER_SUPPLIER_CREATE':
			//case 'ORDER_SUPPLIER_MODIFY':
			//case 'ORDER_SUPPLIER_VALIDATE':
			//case 'ORDER_SUPPLIER_DELETE':
			//case 'ORDER_SUPPLIER_APPROVE':
			//case 'ORDER_SUPPLIER_REFUSE':
			//case 'ORDER_SUPPLIER_CANCEL':
			//case 'ORDER_SUPPLIER_SENTBYMAIL':
			//case 'ORDER_SUPPLIER_DISPATCH':
			//case 'LINEORDER_SUPPLIER_DISPATCH':
			//case 'LINEORDER_SUPPLIER_CREATE':
			//case 'LINEORDER_SUPPLIER_UPDATE':
			//case 'LINEORDER_SUPPLIER_DELETE':

			// Proposals
			//case 'PROPAL_CREATE':
			//case 'PROPAL_MODIFY':
			//case 'PROPAL_VALIDATE':
			//case 'PROPAL_SENTBYMAIL':
			//case 'PROPAL_CLOSE_SIGNED':
			//case 'PROPAL_CLOSE_REFUSED':
			//case 'PROPAL_DELETE':
			//case 'LINEPROPAL_INSERT':
			//case 'LINEPROPAL_UPDATE':
			//case 'LINEPROPAL_DELETE':

			// SupplierProposal
			//case 'SUPPLIER_PROPOSAL_CREATE':
			//case 'SUPPLIER_PROPOSAL_MODIFY':
			//case 'SUPPLIER_PROPOSAL_VALIDATE':
			//case 'SUPPLIER_PROPOSAL_SENTBYMAIL':
			//case 'SUPPLIER_PROPOSAL_CLOSE_SIGNED':
			//case 'SUPPLIER_PROPOSAL_CLOSE_REFUSED':
			//case 'SUPPLIER_PROPOSAL_DELETE':
			//case 'LINESUPPLIER_PROPOSAL_INSERT':
			//case 'LINESUPPLIER_PROPOSAL_UPDATE':
			//case 'LINESUPPLIER_PROPOSAL_DELETE':

			// Contracts
			//case 'CONTRACT_CREATE':
			//case 'CONTRACT_MODIFY':
			//case 'CONTRACT_ACTIVATE':
			//case 'CONTRACT_CANCEL':
			//case 'CONTRACT_CLOSE':
			//case 'CONTRACT_DELETE':
			//case 'LINECONTRACT_INSERT':
			//case 'LINECONTRACT_UPDATE':
			//case 'LINECONTRACT_DELETE':

			// Bills
			//case 'BILL_CREATE':
			//case 'BILL_MODIFY':
			 case 'BILL_VALIDATE':

			 //echo "<h1>El tipo de factura es: ".$object -> type."</h1>";

			 //$fecha = date('d/m/Y H:m:s', $object->date);

             if ($object ->array_options['options_cfdi'] === "1" ){
             		//echo "<h1>Hola CFDI</h1>";

           // exit;
           // break;

             	$t_documento = "I";

				### Factura estandar
             	 if ($object -> type === "0"){

             	 	$t_documento = "I";

             	 	//echo "Hola"; 

             	 }                 


                   

                if ($object -> type === "1"){

                    	##############FACTURA DE REMPLASO

                global $db; 

                $sql = "SELECT uuid,llx_facture.ref FROM `llx_facture`, llx_facture_extrafields WHERE llx_facture.rowid = llx_facture_extrafields.fk_object and llx_facture.rowid = ".$object -> fk_facture_source;
                    $resql = $db->query($sql);
                    
                 $uuid_re="";
                    


                    if ($row=mysqli_fetch_array($resql)){
                        $uuid_re = $row['uuid'];
                         $ref = $row['ref'];
                       
                       //echo $uuid_re;

                        

                       

                    }  


                        $t_documento = "I";
                         $t_relacion = "04";

                      
                    }


                    if ($object -> type === "2"){
                     ############# NOTA DE CREDITO
                    global $db;  

                    $sql = "SELECT uuid,llx_facture.ref FROM `llx_facture`, llx_facture_extrafields WHERE llx_facture.rowid = llx_facture_extrafields.fk_object and llx_facture.rowid = ".$object -> fk_facture_source;
                    $resql = $db->query($sql);
                    
                    $uuid_re="";
                    


                    if ($row=mysqli_fetch_array($resql)){
                        $uuid_re = $row['uuid'];
                         $ref = $row['ref'];
                       
                      // echo $uuid_re;

                    }  

                        $t_documento = "E";
                        $t_relacion = "01";

                        //echo "</br>esto es una nota de credito - ".$t_documento;
                    }

                    if ($object -> type === "3"){

                    	####### Factura de anticipo


                       $t_documento = "I";

                        //echo "</br>esto es una Factura de Remplazo- ".$t_documento;
                    }

                    
                
                          #### muetra el objeto
                           /*echo '<pre>';
                            print_r($object);
                            echo '</pre>';*/ 
                            //creacion de cabecera



					

                     //$foliocfdi='LYE-0001';
					 $sql = "SELECT foliocfdi FROM `llx_facture_extrafields` WHERE foliocfdi IS NOT NULL ORDER BY tms DESC LIMIT 1";
                    $resql = $db->query($sql);
                    
                    $serie_facturacion = explode ("-", $object -> newref);
                    
                    


                    if ($row=mysqli_fetch_array($resql)){
                        $foliocfdi= $row['foliocfdi'];
                         
                    }  

                     $serie_facturacion_cfdi = explode ("-", $foliocfdi);
                     $serie_cfdi = $serie_facturacion_cfdi [0];
                     $folio_cfdi = number_format($serie_facturacion_cfdi [1])+1;

                     $folio_cfdi = str_pad( $folio_cfdi, 4, "0", STR_PAD_LEFT);

                     $foliocfdi= $serie_cfdi."-".$folio_cfdi;*/

########################################################################
    
                    $serie_facturacion = explode ("-", $object -> newref);
                    //$serie_facturacion = explode ("-", $foliocfdi);
                    $folio = $object -> newref;
                    $totalImpuestosTrasladadosIeps=0;
					$totalImpuestosTrasladadosIva=0;  
                    
                    if(($object -> array_options ['options_fechacfdi']) != ""){
                    	$fecha_fact = date('Y-m-d', $object -> array_options ['options_fechacfdi']);

                    } else{

                    	$fecha_fact = date('Y-m-d');

                    }
                    
                    //$fecha_fact = str_replace (" ", "T", $fecha_fact);                   
                    /*if ($object -> type ==0){
                         $tipoComprobante="I";
                        }*/


                   
    
                $header = array(               
    
                    'Serie' => $serie_facturacion [0],
                    'Folio' => number_format($serie_facturacion [1])+1,
                    'Fecha' => $fecha,                    
                    'TipoDeComprobante' => $t_documento,
                    'LugarExpedicion' => $conf ->global -> MAIN_INFO_SOCIETE_ZIP,                    
                    'FormaPago' => $object -> array_options ['options_formapago'],
                    //'CondicionesDePago' => $object -> cond_reglement_code,
                    'CondicionesDePago' =>"RECEP",
                    'MetodoPago' => $object -> array_options ['options_formapagocfdi'],
                    'Moneda' => $object -> multicurrency_code,                    
                    'Observaciones' =>$object -> array_options ['options_observaciones'],
                    'Sucursal' =>$object -> array_options ['options_sucursal'],
                    'Comentarios' =>$object -> array_options ['options_comentariosplantilla'],
                    
                );
                
             
    
                $emisor =array (
                    'RegimenFiscal' => $conf->global -> MAIN_INFO_SOCIETE_FORME_JURIDIQUE
    
                );
                

                #### muetra el objeto
                        /*  echo '<pre>';
                            print_r($header);
                            echo '</pre>'; 

                            echo '<pre>';
                            print_r($emisor);
                            echo '</pre>';*/
                         

             

                global $db;  


                    $sql = "SELECT * FROM `llx_societe` WHERE `llx_societe`.`rowid` = ".$object -> socid;
                    //echo $sql;
                    $resql = $db->query($sql);
                    
                    $rfc="";
                    $nombre="";
                    $cp_receptor="";
                    $regimen="";



                    if ($row=mysqli_fetch_array($resql)){
                        $rfc = $row['siren'];
                        $nombre = $row['nom'];
                        $cp_receptor = $row['zip'];
                        $regimen = $row['fk_forme_juridique'];
                       

                    }  


                $receptor =array(
                        
                    'Rfc' => $rfc,
                    'Nombre' =>$nombre,
                    'UsoCFDI' => $object ->array_options['options_usocfdi'],
                    'DomicilioFiscalReceptor' =>$cp_receptor,
                    'RegimenFiscalReceptor' =>$regimen
    
                );

                 /*echo '<pre>';
                print_r($receptor);
                echo '</pre>'; */
    
   

    ###############   productos
                foreach ($object -> lines as $linea_producto){
    
                    $producto = new Product ($this -> db);
                    $producto -> fetch ($linea_producto -> fk_product); 
		}
    
    ##########################
 dol_include_once('/cfdi/qrlib/qrlib.php');


### CÓDIGO FUENTE, FACTURACIÓN ELECTRÓNICA CFDI VERSIÓN 3.3 ACORDE A LOS REQUIRIMIENTOS DEL SAT, ANEXO 20.


### 1. CONFIGURACIÓN INICIAL ######################################################

    # 1.1 Configuración de zona horaria
    date_default_timezone_set('America/Mexico_City'); 


    $Fec1 = date("d/m/Y");
    $Fec2 = date("Y/m/d");
    $Hora = date("H:i:s");


    
    # 1.2 Muestra la zona horaria predeterminada del servidor (opcional a mostrar)
   /* echo '<div style="font-size: 10pt; color: #000099; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
    echo 'ZONA HORARIA PREDETERMINADA';
    echo '</div>';
    echo '<div style="font-size: 10pt; color: #000000; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
    echo date_default_timezone_get();
    echo '</div><br>';*/
 
### 2. ASIGNACIÓN DE VALORES A VARIABLES ###################################################
    $SendaPEMS  = (DOL_DOCUMENT_ROOT.'/custom/cfdi/archs_pem/');   // 2.1 Directorio en donde se encuentran los archivos *.cer.pem y *.key.pem (para efectos de demostración se utilizan los que proporciona el SAT para pruebas).
    $SendaCFDI  = (DOL_DOCUMENT_ROOT.'/custom/cfdi/archs_cfdi/');  // 2.2 Directorio en donde se almacenarán los archivos *.xml (CFDIs).
    //$SendaCFDI  = (DOL_DATA_ROOT.'/custom/facture/'.$serie_folio.'/');  // 2.2 Directorio en donde se almacenarán los archivos *.xml (CFDIs).
    $SendaGRAFS = (DOL_DOCUMENT_ROOT.'/custom/cfdi/archs_graf/');  // 2.3 Directorio en donde se almacenan los archivos .jpg (logo de la empresa) y .png (códigos bidimensionales).
    $SendaXSD   = (DOL_DOCUMENT_ROOT.'/custom/cfdi/archs_xsd/');   // 2.4 Directorio en donde se almacenan los archivos .xsd (esquemas de validación, especificaciones de campos del Anexo 20 del SAT);
    
    ####### 2.5 Datos de acceso del usuario (proporcionados por www.finkok.com) modo de integración (para pruebas) o producción.
    $username = "jbarranco@labelti.com";
    $password = "Labelti2021!"; 
    

    
### 3. DEFINICIÓN DE VARIABLES INICIALES ##########################################
    $noCertificado = "30001000000400002434";  // 3.1 Número de certificado.
    $file_cer      = "EKU9003173C9.cer.pem";  // 3.2 Nombre del archivo .cer.pem 
    $file_key      = "EKU9003173C9.key.pem";  // 3.3 Nombre del archivo .cer.key
    
###################################################################################
    
    
### 4. DATOS GENERALES DE LA FACTURA ################################################## 

	//$condicionesDePago = "";  
   
    $fact_serie        = $serie_facturacion [0];                             // 4.1 Número de serie.
    $fact_folio        = $serie_facturacion [1];             // 4.2 Número de folio (para efectos de demostración se asigna de manera aleatoria).
    $NoFac             = $fact_serie.$fact_folio;         // 4.3 Serie de la factura concatenado con el número de folio.
    $NoFac             = $folio;         // 4.3 Serie de la factura concatenado con el número de folio.   
    $fact_tipcompr     = $t_documento;                             // 4.4 Tipo de comprobante.
    ########################################### 4.0
    $fact_exportacion  = "01";                            // 4.5 Atributo requerido para expresar si el comprobante ampara una operación de exportación.
    ########################################## 
    $tasa_iva          = 16;                              // 4.5 Tasa del impuesto IVA.
    $subTotal          = 0;                               // 4.6 Subtotal, suma de los importes antes de descuentos e impuestos (se calculan mas abajo). 
    $descuento         = 0;                               // 4.7 Descuento (se calculan mas abajo).
    $IVA               = 0;                               // 4.8 IVA, suma de los impuestos (se calculan mas abajo).
    $total             = 0;                               // 4.9 Total, Subtotal - Descuentos + Impuestos (se calculan mas abajo). 
    //$fecha_fact        = date("Y-m-d")."T".date("H:i:s"); // 4.10 Fecha y hora de facturación.
    //$NumCtaPago        = "6473";                          // 4.11 Número de cuenta (sólo últimos 4 dígitos, opcional).
    $condicionesDePago = $header['CondicionesDePago'];                   // 4.12 Condiciones de pago.
    $formaDePago       = $header['FormaPago'];                            // 4.13 Forma de pago.
    $metodoDePago      = $header['MetodoPago'];                           // 4.14 Clave del método de pago. Consultar catálogos de métodos de pago del SAT.
    $TipoCambio        = 1;                               // 4.15 Tipo de cambio de la moneda.
    $LugarExpedicion   = $header['LugarExpedicion'];                         // 4.16 Lugar de expedición (código postal).
    $moneda            = $header['Moneda'];                           // 4.17 Moneda    
    $totalImpuestosRetenidos   = 0;                       // 4.18 Total de impuestos retenidos (se calculan mas abajo).
    $totalImpuestosTrasladados = 0;                       // 4.19 Total de impuestos trasladados (se calculan mas abajo).
    $sub = 0;
  // if( $condicionesDePago === ""){
   //	$condicionesDePago = "RECEP";  

   //}

    if($uuid_re != ""){
     $UUID_DelDocRel = $uuid_re;  // 4.20 UUID del documento relacionado.

 }
 
    
### 5. MUESTRA LA ZONA HORARIA PREDETERMINADA DEL SERVIDOR (OPCIONAL A MOSTRAR) ######
    /*echo '<div style="font-size: 10pt; color: #000099; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
    echo 'FECHA Y HORA DE SOLICITUD DE TIMBRADO';
    echo '</div>';
    echo '<div style="font-size: 10pt; color: #000000; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
    echo $fecha_fact; // 5.1 Se muestra solo para consultar y confirmar que sea la correcta.
    echo '</div><br>';  */ 

    
### 6. ARRAYS QUE CONTIENEN LOS ARTICULOS QUE FORMAN PARTE DE LA VENTA #####################

    ################################# productos
     $i=0;
                foreach ($object -> lines as $linea_producto){
    
                    $producto = new Product ($this -> db);
                    $producto -> fetch ($linea_producto -> fk_product);                                
    

                    $ArrayTraslado_TipoFactor [$i]='Tasa'; 
                    $Array_NoIdentificacion [$i]=$codigo_producto;                      
                    $cantidad=$linea_producto -> qty;
                    $Array_Cantidad [$i] = $cantidad;
                    if ($producto -> label != ""){ $nombre_producto=utf8_decode($producto -> label); }    
                    else{ $nombre_producto=utf8_decode($linea_producto -> desc); }

                   // echo $nombre_producto;

                    $Array_Descripcion [$i] = $nombre_producto." ".utf8_decode($linea_producto -> array_options ['options_observaproduct']); 
                     /*echo $Array_Descripcion [$i];
                     echo"</br>";
                     echo"</br>";

                     $labelproductservice = preg_replace('/(<img[^>]*src=")([^"]*)(&amp;)([^"]*")/', '\1\2&\4', $Array_Descripcion [$i], -1, $nbrep);

                     echo utf8_encode($labelproductservice);
                     echo"</br>";
                     echo"</br>";

                      echo convToOutputCharset($Array_Descripcion [$i]);
                       echo"</br>";
                     echo"</br>";*/

                     if($producto -> array_options ['options_umed'] != ""){$codigo_um=$producto -> array_options ['options_umed'];}
                    else if ($linea_producto -> array_options ['options_umed'] != "0"){$codigo_um=$linea_producto -> array_options ['options_umed'];}
                    else { echo $nombre_producto." <b>No cuenta con Codigo de unidad de medida del SAT</b></br>";   }
                    $Array_ClaveUnidad [$i] = $codigo_um;   
                    if($producto -> array_options ['options_claveprodserv'] != ""){$codigo_producto=$producto -> array_options ['options_claveprodserv'];}
                    else if($linea_producto -> array_options ['options_claveprodserv'] != ""){$codigo_producto=$linea_producto -> array_options ['options_claveprodserv'];}
                    else { echo $nombre_producto." <b>No cuenta con Codigo de Producto o Servicio del SAT</b></br>";   }
                   $Array_ClaveProdServ [$i]=$codigo_producto;     


                    if($codigo_um === "E48"){
                        $unidad="Servicio";
                    }
                     if($codigo_um === "H87"){
                        $unidad="Pieza";
                    }
                    if($codigo_um === "KT"){
                        $unidad="Kit";
                    }
                    $Array_Unidad [$i] = $unidad;


                    $precio_venta_f=$linea_producto -> multicurrency_subprice;


if($t_documento === "E"){
     $precio_venta_f = str_replace("-", "", $precio_venta_f);
 }
    
   
    $precio_venta_r=str_replace(",","",$precio_venta_f);//Reemplazo las comas
    $Array_ValorUnitario [$i]=$precio_venta_r;

    $Desc = $linea_producto -> remise_percent;

#######################
    $Desc_linea =  (($Desc * $precio_venta_r)/100)*$cantidad;
    $Array_Descuento[$i] = $Desc_linea;
    ##################################### 4.0
    $Array_ObjetoImp [$i]="02"; // Atributo requerido para expresar si el pago del documento relacionado es objeto o no de impuesto.
    #######################################
    $precio_total_f=$linea_producto -> multicurrency_total_ht;
    $descuento+=$Desc_linea;
    $sub+=($precio_venta_r*$cantidad);
    $total_linea=$linea_producto -> multicurrency_total_ttc;
    $total_linea_r=str_replace(",","",$total_linea);//Reemplazo las comas
    //$total+=$total_linea_r;//Sumador


######################
   


    //$precio_total_f=$precio_venta_r*$cantidad;   
    $precio_total_r=str_replace(",","",$precio_total_f);//Reemplazo las comas
    //$Array_Importe [$i]= $precio_total_r; 
     $Array_Importe [$i]=($precio_venta_r*$cantidad);    
    $ArrayTraslado_Base [$i] = $precio_total_r;
    


    /*$iva_="";    
    $iva_=$linea_producto -> multicurrency_total_tva;


    if($t_documento === "E"){
     $iva_ = str_replace("-", "", $iva_);
 }
    
    if( $iva_ !=""){$iva_f=$linea_producto -> multicurrency_total_tva;}
    else{ $iva_f=$linea_producto -> multicurrency_total_tva; }
    if($t_documento === "E"){
     $iva_f = str_replace("-", "", $iva_f);
 }

    $iva_r=str_replace(",","",$iva_f);//Reemplazo las comas */


############################### IEPS
    //$tasa=  number_format ($linea_producto -> tva_tx,0)*.01;
    //$iva_r=number_format ($precio_total_r*$tasa,2);

     if($linea_producto -> localtax1_tx > 0){

   	$ArrayTraslado_Impuesto[$i]='003';

   $tasa=  number_format ($linea_producto -> localtax1_tx,0)*.01;
   //$iva_r=number_format ($precio_total_r*$tasa,2);
   $iva_r=$precio_total_r*$tasa;
   $ArrayTraslado_Importe [$i] = $iva_r; 
   $ArrayTraslado_TasaOCuota[$i] = '0.080000';

   }else{

   	$ArrayTraslado_Impuesto[$i]='002';

   	$tasa=  number_format ($linea_producto -> tva_tx,0)*.01;
    //$iva_r=number_format ($precio_total_r*$tasa,2);
    $iva_r=$precio_total_r*$tasa;
   	$ArrayTraslado_Importe [$i] = $iva_r; 

   	if($linea_producto -> tva_tx == '16.000'){
   		$tasaIVA = "0.160000";
   	}else{
   		$tasaIVA = "0.000000";

   	}
    $ArrayTraslado_TasaOCuota[$i] = $tasaIVA ;

   }
   

####################################


    $ArrayTraslado_Importe [$i] = $iva_r;   
    $sumador_total+=$precio_total_r;//Sumador
    
   
            $i++;    

        
}

#############################################################################################################################

/*
echo "Descripcion <pre>";
print_r($Array_Descripcion);
echo "</pre>";


echo "Cantidad <pre>";
print_r($Array_Cantidad);
echo "</pre>";


echo " Precio Unitario <pre>";
print_r($Array_ValorUnitario);
echo "</pre>";

echo " Total <pre>";
print_r($Array_Importe);
echo "</pre>";

echo " Traslado Base <pre>";
print_r($Array_ValorUnitario);
echo "</pre>";


echo "Traslado Importe <pre>";
print_r($ArrayTraslado_Importe);
echo "</pre>";*/






    
    
 ### 7. ARRAYS QUE CONTIENEN LOS IMPUESTOS TRASLADADOS Y RETENIDOS POR CONCEPTO #############

    
    
    // Retenidos.
//    $ArrayRetencion_Base = ['0', '0', '0'];                // 7.6 Atributo requerido para señalar la base para el cálculo de la retención, la determinación de la base se realiza de acuerdo con las disposiciones fiscales vigentes. No se permiten valores negativos.
//    $ArrayRetencion_Impuesto = ['0', '0', '0'];            // 7.7 Atributo requerido para señalar la clave del tipo de impuesto retenido aplicable al concepto (consultar catálogos del SAT).
//    $ArrayRetencion_TipoFactor = ['Tasa', 'Tasa', 'Tasa']; // 7.8 Atributo requerido para señalar la clave del tipo de factor que se aplica a la base del impuesto (consultar catálogos del SAT).
//    $ArrayRetencion_TasaOCuota = ['0.10', '0.10', '0.10']; // 7.9 Atributo requerido para señalar la tasa o cuota del impuesto que se retiene para el presente concepto (consultar catálogos del SAT).
//    $ArrayRetencion_Importe = ['0', '0', '0'];             // 7.10 Atributo requerido para señalar el importe del impuesto retenido que aplica al concepto. No se permiten valores negativos.
    
    
### 8 DETERMINANDO TOTALES #####################################################
    
    $ArrayRetencion_Importe = [];
    
    // 8.1 Calculando subTotal.
    for ($i=0; $i<count($Array_Importe); $i++){
        
        $subTotal = $subTotal + $Array_Importe[$i];
        //echo $subTotal."</br>";
    }
    
    $subTotal = number_format($subTotal,2,'.',''); 
    
    // 8.2 Total impuestos trasladados.
    ########################### 4.0
    $base2 = 0;
    $SumaBases = 0;
    $SumaImportes = 0;

    #########################



    for ($i=0; $i<count($ArrayTraslado_Importe); $i++){
        $totalImpuestosTrasladados = $totalImpuestosTrasladados + $ArrayTraslado_Importe[$i];

       // echo "suma trasladado ".$totalImpuestosTrasladados."</br>";
    }


    ################################################### IEPS
 $iva0=0;
    for ($i=0; $i<count($ArrayTraslado_Importe); $i++){
       
        if($ArrayTraslado_Impuesto[$i]==="002"){
        	if($ArrayTraslado_TasaOCuota[$i] === "0.160000"){
        		 $totalImpuestosTrasladadosIva16 = $totalImpuestosTrasladadosIva16 + $ArrayTraslado_Importe[$i];
             //echo "Hola IVA";

        	}
        	if($ArrayTraslado_TasaOCuota[$i] === "0.000000"){
        		 $totalImpuestosTrasladadosIva0 = $totalImpuestosTrasladadosIva0 + $ArrayTraslado_Importe[$i];
             //echo "Hola IVA";

        		 $iva0=1;
        		
        	}
             $totalImpuestosTrasladadosIva = $totalImpuestosTrasladadosIva + $ArrayTraslado_Importe[$i];
             //echo "Hola IVA";
        }

        if($ArrayTraslado_Impuesto[$i]==="003"){
             $totalImpuestosTrasladadosIeps = $totalImpuestosTrasladadosIeps + $ArrayTraslado_Importe[$i];

            // echo "Hola Ieps ".$totalImpuestosTrasladadosIeps;

        }
       
    }

    #########################################################
    
    // 8.3 Total impuestos retenidos.
    for ($i=0; $i<count($ArrayRetencion_Importe); $i++){
        $totalImpuestosRetenidos = $totalImpuestosRetenidos + $ArrayRetencion_Importe[$i];
    }

    // 8.4 Calculando Total.
    //$total = $subTotal - $descuento + $totalImpuestosTrasladados - $totalImpuestosRetenidos;

    //$total=$object -> total_ttc;

   // $total =  number_format($sub - $descuento + $totalImpuestosTrasladados - $totalImpuestosRetenidos, 2);

    $total =  $sub - $descuento + $totalImpuestosTrasladados - $totalImpuestosRetenidos;




   // $total = $subTotal + $totalImpuestosTrasladados - $totalImpuestosRetenidos;

    //echo "</br>Total ".$total;
    
    
### 9. DATOS GENERALES DEL EMISOR #################################################  
    
    $emisor_rs = "ESCUELA KEMPER URGATE";  // 9.1 Nombre o Razón social.
    $emisor_rfc = "EKU9003173C9";  // 9.2 RFC (al momento de timbrar el SAT comprueba que el RFC se encuentre registrado y vigente en su base de datos)
    $emisor_ClaRegFis = "601"; // 9.3 Clave del Régimen fiscal.       
        
    
### 10. DATOS GENERALES DEL RECEPTOR (CLIENTE) #####################################
    
   //$RFC_Recep = "AAD990814BP7";                                                              // 10.1 RFC (al momento de timbrar el SAT 
    $RFC_Recep = $receptor['Rfc'];


    if ($RFC_Recep=== ""){
        echo "Error! El cliente no cuenta con RFC";
        echo "</br>";
        echo "</br>";
    }
                                                                  // 10.1 RFC (al momento de timbrar el SAT comprueba que el RFC se encuentre registrado y vigente en su base de datos).
    if (strlen($RFC_Recep)==12){$RFC_Recep = " ".$RFC_Recep; }else{$RFC_Recep = $RFC_Recep;}  // 10.2 Al RFC de personas morales se le antecede un espacio en blanco para que su longitud sea de 13 caracteres ya que estos son de longitud 12.
    $receptor_rfc = $RFC_Recep;                                                               // 10.3 RFC.
    //$receptor_rs  = "ASOCIACION DE AGRICULTORES";                       // 10.4 Nombre o razón social.
    $receptor_rs  = $receptor['Nombre'];                       // 10.4 Nombre o razón social.
    $UsoCFDI  = $receptor['UsoCFDI'];                       // 10.4 Nombre o razón social.
############################## 4.0
    $DomicilioFiscalReceptor = $receptor['DomicilioFiscalReceptor'];             // 10.5 Domicilio fiscal del Receptor (código postal).
    $RegimenFiscalReceptor = $receptor['RegimenFiscalReceptor'];                // 10.6 Régimen fiscal del receptor.
	//$UsoCFDI = "S01";
################################



############################################# 4.0 receptor fijo para tester


     //$RFC_Recep = "MASO451221PM4";                                                              // 10.1 RFC (al momento de timbrar el SAT comprueba que el RFC se encuentre registrado y vigente en su base de datos).
   // if (strlen($RFC_Recep)==12){$RFC_Recep = " ".$RFC_Recep; }else{$RFC_Recep = $RFC_Recep;}  // 10.2 Al RFC de personas morales se le antecede un espacio en blanco para que su longitud sea de 13 caracteres ya que estos son de longitud 12.
    //$receptor_rfc = $RFC_Recep;                                                               // 10.3 RFC.
    //$receptor_rs  = "MARIA OLIVIA MARTINEZ SAGAZ"; // 10.4 Nombre o razón social.
    /*$DomicilioFiscalReceptor = "80290";
    $RegimenFiscalReceptor = "616";
    $UsoCFDI = "S01";*/
######################################
### 11. CREACIÓN Y ALMACENAMIENTO DEL ARCHIVO .XML (CFDI) ANTES DE SER TIMBRADO ###################
    
    #== 11.1 Creación de la variable de tipo DOM, aquí se conforma el XML a timbrar posteriormente.
    $xml = new DOMdocument('1.0', 'UTF-8'); 
    $root = $xml->createElement("cfdi:Comprobante");
    $root = $xml->appendChild($root); 
     global $cadena_original;
    
    $cadena_original='||';
    $noatt=  array();
    
    #== 11.2 Se crea e inserta el primer nodo donde se declaran los namespaces ======
   

     
#################################### 4.0
         cargaAtt($root, array(
            "xsi:schemaLocation"=>"http://www.sat.gob.mx/cfd/4 http://www.sat.gob.mx/sitio_internet/cfd/4/cfdv40.xsd",
            "xmlns:cfdi"=>"http://www.sat.gob.mx/cfd/4",
            "xmlns:xs"=>"http://www.w3.org/2001/XMLSchema",
            "xmlns:xsi"=>"http://www.w3.org/2001/XMLSchema-instance"
        )
    );

####################################################
$mifecha= date('Y-m-d H:i:s'); 
$NuevaFecha = strtotime ( '-1 hour' , strtotime ($mifecha) ) ; 
$NuevaFecha = strtotime ( '-1 minute' , $NuevaFecha ) ; 
$NuevaFecha = strtotime ( '+0 second' , $NuevaFecha ) ; 
$NuevaHora = date ( 'H:i:s' , $NuevaFecha); 

//echo $fecha_fact."T". $NuevaHora;




    #== 11.3 Rutina de integración de nodos =========================================
    cargaAtt($root, array(
         
            "Version"=>"4.0",
            "Serie"=>$fact_serie,
            "Folio"=>$fact_folio,
            "Fecha"=>$fecha_fact."T". $NuevaHora,
            "FormaPago"=>$formaDePago,
            "NoCertificado"=>$noCertificado,
            "CondicionesDePago"=>$condicionesDePago,
            "SubTotal"=>$sub,
            "Descuento"=>number_format($descuento,2,'.',''),
            "Moneda"=>$moneda,
            "TipoCambio"=>$TipoCambio,
            //"Total"=>$total,
            "Total"=>number_format($total,2,'.',''),
            "TipoDeComprobante"=>$fact_tipcompr,
            "Exportacion"=>$fact_exportacion,
            "MetodoPago"=>$metodoDePago,
            "LugarExpedicion"=>$LugarExpedicion
        )
    );


    // Documentos relacionados =================================================
    
    //if($t_documento === "E"){
        if($UUID_DelDocRel != ""){
    

    $DocsRel = $xml->createElement("cfdi:CfdiRelacionados");
    $DocsRel = $root->appendChild($DocsRel);

    cargaAtt($DocsRel, array("TipoRelacion"=>$t_relacion));

    ####################################### corregir tipo de relacion 04 al ser de remplazo y o1 al ser NC
    
        $CFDIrel = $xml->createElement("cfdi:CfdiRelacionado");
        $CFDIrel = $DocsRel->appendChild($CFDIrel);

            cargaAtt($CFDIrel, array("UUID"=>$UUID_DelDocRel));

             }
    
    // =========================================================================
    

    
    
    $emisor = $xml->createElement("cfdi:Emisor");
    $emisor = $root->appendChild($emisor);
    cargaAtt($emisor, array("Rfc"=>$emisor_rfc,
                            "Nombre"=>$emisor_rs,
                            "RegimenFiscal"=>$emisor_ClaRegFis
                             )
                        );
    
    
    $receptor = $xml->createElement("cfdi:Receptor");
    $receptor = $root->appendChild($receptor);
   /* cargaAtt($receptor, array("Rfc"=>$receptor_rfc,
                    "Nombre"=>$receptor_rs,
                    "UsoCFDI"=>$uso
                )
            );*/

########## 4.0
            cargaAtt($receptor, array(
                    "Rfc"=>$receptor_rfc,
                    "Nombre"=>$receptor_rs,
                    "DomicilioFiscalReceptor"=>$DomicilioFiscalReceptor,
                    "RegimenFiscalReceptor"=>$RegimenFiscalReceptor,
                    "UsoCFDI"=>$UsoCFDI
                )
            );
####################  
    
    $conceptos = $xml->createElement("cfdi:Conceptos");
    $conceptos = $root->appendChild($conceptos);
    
    #== 11.4 Ciclo "for", recopilación de datos de artículos e integración de sus respectivos nodos =
    
    for ($i=0; $i<count($Array_Cantidad); $i++){

    	if ($ArrayTraslado_TipoFactor[$i]!=="Exento"){
    		if($ArrayTraslado_Impuesto[$i]==="002"){

    		if($ArrayTraslado_TasaOCuota[$i] === "0.160000"){
				$SumaBases_IVA = $SumaBases_IVA + $ArrayTraslado_Base[$i];
				$SumaBases_IVA16 = $SumaBases_IVA16 + $ArrayTraslado_Base[$i];
		
			} else if($ArrayTraslado_TasaOCuota[$i] === "0.000000"){
				$SumaBases_IVA = $SumaBases_IVA + $ArrayTraslado_Base[$i];
				$SumaBases_IVA0 = $SumaBases_IVA0 + $ArrayTraslado_Base[$i];

		}

    			

    		}
    		else if($ArrayTraslado_Impuesto[$i]==="003"){

    			$SumaBases_IEPS = $SumaBases_IEPS + $ArrayTraslado_Base[$i];

    		}

            $SumaBases = $SumaBases + $ArrayTraslado_Base[$i];
            $SumaImportes = $SumaImportes + $Array_Importe[$i];
        }

       	
        $concepto = $xml->createElement("cfdi:Concepto");
        $concepto = $conceptos->appendChild($concepto);

  		

        cargaAtt($concepto, array(
               "ClaveProdServ"=>$Array_ClaveProdServ[$i],
               "NoIdentificacion"=>$Array_NoIdentificacion[$i],
               "Cantidad"=>$Array_Cantidad[$i],
               "ClaveUnidad"=>$Array_ClaveUnidad[$i],
               "Unidad"=>$Array_Unidad[$i],
               "Descripcion"=>utf8_encode($Array_Descripcion[$i]),
               "ValorUnitario"=>number_format($Array_ValorUnitario[$i],2,'.',''),
               "Importe"=>number_format($Array_Importe[$i],2,'.',''),
               "Descuento"=>number_format($Array_Descuento[$i],2,'.',''),
               "ObjetoImp"=>$Array_ObjetoImp[$i]

            )
        );
    
        $impuestos = $xml->createElement("cfdi:Impuestos");
        $impuestos = $concepto->appendChild($impuestos);

            $Traslados = $xml->createElement("cfdi:Traslados");
            $Traslados = $impuestos->appendChild($Traslados);
            
                $Traslado = $xml->createElement("cfdi:Traslado");
                $Traslado = $Traslados->appendChild($Traslado);


                
                if ($ArrayTraslado_TipoFactor[$i]=="Exento"){
                    cargaAtt($Traslado, array(
                          "Base"=>number_format($ArrayTraslado_Base[$i],2,'.',''),
                           //"Impuesto"=>$ArrayTraslado_Impuesto[$i],
                           "Impuesto"=>'002',
                           //"TipoFactor"=>$ArrayTraslado_TipoFactor[$i]
                           "TipoFactor"=>'Exento'
                        ) 
                    );    
                }else{
                    cargaAtt($Traslado, array(
                           "Base"=>number_format($ArrayTraslado_Base[$i],2,'.',''),
                           "Impuesto"=>$ArrayTraslado_Impuesto[$i],
                           //"Impuesto"=>'002',
                           //"TipoFactor"=>$ArrayTraslado_TipoFactor[$i],
                            "TipoFactor"=>'Tasa',
                           "TasaOCuota"=>$ArrayTraslado_TasaOCuota[$i],
                           //"TasaOCuota"=>"0.160000",
                            //"TasaOCuota"=>"0.000000",
                            //"TasaOCuota"=>$tasaIVA,

                           "Importe"=>number_format($ArrayTraslado_Importe[$i],2,'.','')
                            //"Importe"=>$ArrayTraslado_Importe[$i]
                        ) 
                    );    

                    //echo "IVA:". number_format($ArrayTraslado_Importe[$i],2,'.','') ; 

                    //echo "</BR>IVA:". $ArrayTraslado_Importe[$i] ; 
                }  
                  
        
//            $Retenciones = $xml->createElement("cfdi:Retenciones");
//            $Retenciones = $impuestos->appendChild($Retenciones);
//            
//                $Retencion = $xml->createElement("cfdi:Retencion");
//                $Retencion = $Retenciones->appendChild($Retencion);
//                
//                    cargaAtt($Retencion, array(
//                           "Base"=>number_format($ArrayRetencion_Base[$i],2,'.',''),
//                           "Impuesto"=>$ArrayRetencion_Impuesto[$i],
//                           "TipoFactor"=>$ArrayRetencion_TipoFactor[$i],
//                           "TasaOCuota"=>$ArrayRetencion_TasaOCuota[$i],
//                           "Importe"=>number_format($ArrayRetencion_Importe[$i],2,'.','')
//                        ) 
//                    );
              
}

#== 11.5 Impuestos retenidos y trasladados ==========================================

$Impuestos = $xml->createElement("cfdi:Impuestos");
$Impuestos = $root->appendChild($Impuestos);

//    $Retenciones = $xml->createElement("cfdi:Retenciones");
//    $Retenciones = $Impuestos->appendChild($Retenciones);    
//
//        $Retencion = $xml->createElement("cfdi:Retencion");
//        $Retencion = $Retenciones->appendChild($Retencion);
//
//            cargaAtt($Retencion, array(
//                   "Impuesto"=>"002",
//                   "Importe"=>number_format($totalImpuestosRetenidos,2,'.','')
//                ) 
//            );
//
//            cargaAtt($Impuestos, array(
//                            "TotalImpuestosRetenidos"=>number_format($totalImpuestosRetenidos,2,'.','')
//                        )
//                    );
            
            
    $Traslados = $xml->createElement("cfdi:Traslados");
    $Traslados = $Impuestos->appendChild($Traslados);


         if($iva0===1){

         	//if($tasaIVA==='0.000000'){

        $Traslado = $xml->createElement("cfdi:Traslado");
        $Traslado = $Traslados->appendChild($Traslado);

            cargaAtt($Traslado, array(
            	   "Base"=>number_format($SumaBases_IVA0,2,'.',''),            	
                   "Impuesto"=>"002",
                   "TipoFactor"=>"Tasa",
                   "TasaOCuota"=>"0.000000",
                   "Importe"=>"0.00"
                ) 
            );  

        //} 

		}

         if($totalImpuestosTrasladadosIva16>0){

        $Traslado = $xml->createElement("cfdi:Traslado");
        $Traslado = $Traslados->appendChild($Traslado);

            cargaAtt($Traslado, array(
            	   "Base"=>number_format($SumaBases_IVA16,2,'.',''),            	
                   "Impuesto"=>"002",
                   "TipoFactor"=>"Tasa",
                   "TasaOCuota"=>"0.160000",
                   "Importe"=>number_format($totalImpuestosTrasladadosIva16,2,'.','')
                ) 
            ); 

        } 

		

        if($totalImpuestosTrasladadosIeps>0){

        $Traslado = $xml->createElement("cfdi:Traslado");
        $Traslado = $Traslados->appendChild($Traslado);

            cargaAtt($Traslado, array(
            	   "Base"=>number_format($SumaBases_IEPS,2,'.',''),
                   "Impuesto"=>"003",
                   "TipoFactor"=>"Tasa",
                   "TasaOCuota"=>"0.080000",
                   "Importe"=>number_format($totalImpuestosTrasladadosIeps,2,'.','')
                ) 
            ); 

        }     


            cargaAtt($Impuestos, array(
                    "TotalImpuestosTrasladados"=>number_format($totalImpuestosTrasladados,2,'.','')
                )
            );

                         
    $complemento = $xml->createElement("cfdi:Complemento");
    $complemento = $root->appendChild($complemento);

    
    #== 11.6 Termina de conformarse la "Cadena original" con doble ||
    $cadena_original .= "|";   
        
          // Descomentar si se desea obtener en archivo .TXT la Cadena Original.
       //$file = fopen($SendaCFDI."CadenaOriginal_Factura_".$NoFac.".txt", "w");
       // fwrite($file, $cadena_original . PHP_EOL);
      // fclose($file);
       //chmod($SendaCFDI."CadenaOriginal_Factura_".$NoFac.".txt", 0777);      
    
    #=== Muestra la cadena original (opcional a mostrar) =======================
    /*echo '<div style="font-size: 11pt; color: #000099; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
    echo 'CADENA ORIGINAL';
    echo '</div>';
    echo '<div style="font-size: 9pt; color: #000000; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
    echo $cadena_original;
    echo '</div><br>';*/

   
    
    
    # 11.7 PROCESO OPCIONAL, NO NECESARIO PARA TIMBRAR UN DOCUMENTO FISCAL #####
    #== Proceso para agregar una Addenda con datos del sistema local (estos datos son ignorados por el PAC al momento de timbrar el documento XML). 
    
//    // 11.17.1 Datos a integrar a la Addenda ===================================
//    $IdEmpresa        = "TX34JK83";
//    $UsuarioDeSistema = "ALEJANDRA OROSIO";
//    $Fecha            = date("d/m/Y");
//    $Hora             = date("H:i:s");
//    $TipDocOrigen     = "PEDIDO";
//    $FolioDocOrigen   = "A345";
//    $Observaciones    = "ESTE ES UN EJEMPLO DE TEXTO CORRESPONDIENTE A OBSERVACIONES CAPTURADAS POR EL USUARIO QUE SE INTEGRAN AL DOCUMENTO .XML DEL CFDI COMO UNA ADDENDA DEL SISTEMA LOCAL, NO ES REQUISITO PARA TIMBRAR UN CFDI VERSION 3.3";
//    
//    // 11.17.2 Integración del nodo "Addenda" al documento .XML ================
//    $Addenda = $xml->createElement("cfdi:Addenda");
//    $Addenda = $root->appendChild($Addenda);     
//    
//        $SisLoc = $xml->createElement("cfdi:SistemaLocal");
//        $SisLoc = $Addenda->appendChild($SisLoc);
//    
//        cargaAttSinIntACad($SisLoc, array(
//                "IdEmpresa"=>$IdEmpresa,
//                "UsuarioDeSistema"=>$UsuarioDeSistema,
//                "Fecha"=>$Fecha,
//                "Hora"=>$Hora,
//                "TipoDocOrigen"=>$TipDocOrigen,
//                "FolioDocOrigen"=>$FolioDocOrigen,
//                "Observaciones"=>$Observaciones
//            )
//        );
        
    ## Fin de la integración de la Addenda. ####################################
    
    
    #== 11.8 Proceso para obtener el sello digital del archivo .pem.key ========
    $keyid = openssl_get_privatekey(file_get_contents($SendaPEMS.$file_key));
    openssl_sign($cadena_original, $crypttext, $keyid, OPENSSL_ALGO_SHA256);
    openssl_free_key($keyid);
           
//    openssl_sign($datos, $firma, $private_key_pem, OPENSSL_ALGO_SHA256); // *****
    
        
    #== 11.9 Se convierte la cadena digital a Base 64 ==========================
    $sello = base64_encode($crypttext); // Firma.
    
    #=== Muestra el sello (opcional a mostrar) =================================
    /*echo '<div style="font-size: 11pt; color: #000099; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
    echo 'SELLO';
    echo '</div>';
    echo '<div style="font-size: 9pt; color: #000000; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
    echo $sello;
    echo '</div><br>'; */   
    
    #== 11.10 Proceso para extraer el certificado del sello digital ============
    $file = $SendaPEMS.$file_cer;      // Ruta al archivo
    $datos = file($file);
    $certificado = ""; 
    $carga=false;  
    for ($i=0; $i<sizeof($datos); $i++){
        if (strstr($datos[$i],"END CERTIFICATE")) $carga=false;
        if ($carga) $certificado .= trim($datos[$i]);

        if (strstr($datos[$i],"BEGIN CERTIFICATE")) $carga=true;
    } 
    
    #=== Muestra el certificado del sello digital (opcional a mostrar) =========
    /*echo '<div style="font-size: 11pt; color: #000099; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
    echo 'CERTIFICADO DEL SELLO DIGITAL';
    echo '</div>';
    echo '<div style="font-size: 9pt; color: #000000; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
    echo $certificado;
    echo '</div><br>';   */ 
    
    #== 11.12 Se continua con la integración de nodos ===========================   
    $root->setAttribute("Sello",$sello);
    $root->setAttribute("Certificado",$certificado);   # Certificado.
    
    
    #== Fin de la integración de nodos =========================================
    
    $NomArchCFDI = $SendaCFDI."PreCFDI-33_Factura_".$NoFac.".xml";
    
    
    #=== 11.12 Se guarda el archivo .XML antes de ser timbrado =======================
    $cfdi = $xml->saveXML();
    $xml->formatOutput = true;             
    $xml->save($NomArchCFDI); // Guarda el archivo .XML (sin timbrar) en el directorio predeterminado.
    unset($xml);
    
    #=== 11.13 Se dan permisos de escritura al archivo .xml. =========================
    chmod($NomArchCFDI, 0777); 
    
    
##### FIN DE LA CREACIÓN DEL ARCHIVO .XML ANTES DE SER TIMBRADO ####################################################   
    
    
    
    
### 12. PROCESO DE TIMBRADO ########################################################
    
    #=== Se muestra el .XML antes de ser timbrado (opcional a mostrar)==========
    /*echo '<div style="font-size: 11pt; color: #000099; font-family: Verdana, Arial, Helvetica, sans-serif;">';
    echo 'FACTURA .XML A TIMBRAR';
    echo '</div>';
    echo '<div style="font-size: 9pt; color: #000000; font-family: Verdana, Arial, Helvetica, sans-serif;">';
    echo htmlspecialchars($cfdi);
    echo '</div><br>';*/

    #== 12.1 Se crea una variable de tipo DOM y se le carga el CFDI =================================
    $xml2 = new DOMDocument();
    $xml2->loadXML($cfdi); 

    
    #== 12.2 Convirtiendo el contenido del CFDI a BASE 64 ======================
    $xml_cfdi_base64 = base64_encode($cfdi);

    
    #== Modo transición ========================================
//    $process  = curl_init('https://demo-transicion.finkok.com');
    
    #== 12.3 Datos de acceso al servidor de pruebas ============================
    $process  = curl_init('https://demo-facturacion.finkok.com/servicios/soap/stamp.wsdl');     
    
    #== 12.4 Datos de acceso al servidor de producción =========================
    # $process = curl_init('https://facturacion.finkok.com/servicios/soap/stamp.wsdl');    
    
    
#== 12.5 Creando el SOAP de envío ==============================================
    
$cfdixml = <<<XML
<?xml version="1.0" encoding="UTF-8"?> 
<SOAP-ENV:Envelope xmlns:ns0="http://schemas.xmlsoap.org/soap/envelope/"
    xmlns:ns1="http://facturacion.finkok.com/stamp"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/">
    <SOAP-ENV:Header/>
    <ns0:Body>
        <ns1:stamp>
            <ns1:xml>$xml_cfdi_base64</ns1:xml>
            <ns1:username>$username</ns1:username>
            <ns1:password>$password</ns1:password>
        </ns1:stamp>
    </ns0:Body>
</SOAP-ENV:Envelope>
XML;
  
    #== 12.6 Proceso para guardar los datos que se envían al servidor en un archivo .XML ========================
    $NomArchSoap = $SendaCFDI."DatosEnvio_Factura_".$NoFac.".xml";

        #== 12.6.1 Si el archivo ya se encuentra se elimina ===========================
        if (file_exists ($NomArchSoap)==true){
            unlink($NomArchSoap);
        }
    
        #== 12.6.2 Se crea el archivo .XML con el SOAP ================================
        $fp = fopen($NomArchSoap,"a");
        fwrite($fp, $cfdixml);
        fclose($fp);     
        chmod($NomArchSoap, 0777);
    
    
    #=== 12.7 Muestra el contenido del SOAP que se envía al servidor del PAC (REQUEST) =========================
    /*echo '<div style="font-size: 11pt; color: #000099; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
    echo 'CONTENIDO DEL SOAP QUE SE ENVIA AL SERVIDOR DEL PAC';
    echo '</div>';
    echo '<div style="font-size: 9pt; color: #000000; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
    echo htmlspecialchars($cfdixml);
    echo '</div><br>'; */   

    #== 12.8 Se envía el contenido del SOAP al servidor del PAC =====================
    curl_setopt($process, CURLOPT_HTTPHEADER, array('Content-Type: text/xml',' charset=utf-8'));
    curl_setopt($process, CURLOPT_POSTFIELDS, $cfdixml);  
    curl_setopt($process, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($process, CURLOPT_POST, true);
    curl_setopt($process, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($process, CURLOPT_SSL_VERIFYHOST, false);
    $RespServ = curl_exec($process);

    #== 12.9 Se muestra la respuesta del servidor del PAC (opcional a mostrar) ================
   /*echo '<div style="font-size: 11pt; color: #000099; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
    echo 'RESPUESTA DEL SERVIDOR DEL PAC';
    echo '</div>';
    echo '<div style="font-size: 9pt; color: #000000; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
    echo htmlspecialchars($RespServ);
    echo '</div><br>'; */  

   

    curl_close($process);    
    
## FIN DEL PROCESO DE TIMBRADO #################################################
    
    
    
    
## 13. PROCESOS POSTERIORES AL TIMBRADO ########################################
    
    #== 13.1 Se asigna la respuesta del servidor a una variable de tipo DOM ====
    $VarXML = new DOMDocument();
    $VarXML->loadXML($RespServ);

    #== 13.2 Se graba la respuesta del servidor a un archivo .xml
    $VarXML->save($SendaCFDI."RespServ_Factura_".$NoFac.".xml");
    chmod($SendaCFDI."RespServ_Factura_".$NoFac.".xml", 0777);

    //echo "<hr size=2 color=blue >";

    #== 13.3 Se asigna el contenido del tag "xml" a una variable ===============
    $RespServ = $VarXML->getElementsByTagName('xml');


    #== 13.4 Se obtiene el valor del nodo ======================================
    
    $valor_del_nodo = "";
    
    foreach($RespServ as $Nodo){
        $valor_del_nodo = $Nodo->nodeValue; 
    }

        
        #== Si el nodo contiene datos se realizan los siguientes procesos ======
        if($valor_del_nodo != ""){

            // unlink($SendaCFDI."xlst_".$NoFac.".xml"); <-- Puede ser descomentado para eliminar el archivo .XML sin timbrar.

            #== 13.5 Se muestra el .XML ya timbrado (CFDI V 3.2), opcional a mostrar =====
            /*echo '<div style="font-size: 11pt; color: #000099; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
            echo 'FACTURA .XML (CFDI) YA TIMBRADA';
            echo '</div>';
            echo '<div style="font-size: 9pt; color: #000000; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
            echo htmlspecialchars($Nodo->nodeValue);
            echo '</div><br>';*/            

            #=== 13.6 Guardando el CFDI en archivo .XML  ============================

            //$NomArchXML = "CFDI-33_Factura_".$NoFac.".xml";
           //$NomArchPDF = "CFDI-33_Factura_".$NoFac.".pdf";
            $NomArchXML = "CFDI_".$NoFac.".xml";
            $NomArchPDF = "CFDI_".$NoFac.".pdf";
            #######LYE
            //$NomArchXML = "CFDI_".$serie_cfdi."-".$folio_cfdi.".xml";            
           // $NomArchPDF = "CFDI_".$serie_cfdi."-".$folio_cfdi.".pdf";
            ############
           

            $xmlt = new DOMDocument();
            $xmlt->loadXML($valor_del_nodo);
            $xmlt->save($SendaCFDI.$NomArchXML); 
            chmod($SendaCFDI.$NomArchXML, 0777);
            

            #== 13.7 Procesos para extraer datos del Timbre Fiscal del CFDI =========
            $docXML = new DOMDocument();
            //$docXML->load($SendaCFDI."CFDI-33_Factura_".$NoFac.".xml");
            $docXML->load($SendaCFDI."CFDI_".$NoFac.".xml");
            ###########################################lye
             //$docXML->load($SendaCFDI."CFDI_".$serie_cfdi."-".$folio_cfdi.".xml");
            #################################################
            
            $params = $docXML->getElementsByTagName("Comprobante");
            foreach ($params as $param) {
                $VersionCFDI = $param->getAttribute("Version");
                $Total       = $param->getAttribute('Total');
                $Serie       = $param->getAttribute('Serie');
                $Folio       = $param->getAttribute('Folio');
            }            
            
            $SerieFolio = $Serie.$Folio;
            
            $comprobante = $docXML->getElementsByTagName("TimbreFiscalDigital");

            #== 13.8 Se obtienen contenidos de los atributos y se asignan a variables para ser mostrados =======
            foreach($comprobante as $timFis){
                $version_timbre = $timFis->getAttribute('Version');
                $sello_SAT      = $timFis->getAttribute('SelloSAT');
                $cert_SAT       = $timFis->getAttribute('NoCertificadoSAT'); 
                $sello_CFD      = $timFis->getAttribute('SelloCFD'); 
                $tim_fecha      = $timFis->getAttribute('FechaTimbrado'); 
                $tim_uuid       = $timFis->getAttribute('UUID'); 

              /*  echo '<div style="font-size: 14pt; line-height: 26px;">';
                    echo 'Serie y Folio: <span style="color: #A70202; font-weight: bold;">'.$SerieFolio.'</span><br>';
                    echo 'Versión de CFDI: <span style="color: #088A29;">'.$VersionCFDI.'</span><br>';
                    echo 'Versión de timbre: <span style="color: #088A29;">'.$version_timbre.'</span><br>';
                    echo 'Sello del SAT: <span style="color: #088A29">'.$sello_SAT.'</span><br>';
                    echo 'Certificado del SAT: <span style="color: #088A29">'.$cert_SAT.'</span><br>';
                    echo 'Sello del CFDI: <span style="color: #088A29">'.$sello_CFD.'</span><br>';
                    echo 'Fecha de timbrado: <span style="color: #088A29">'.$tim_fecha.'</span><br>';
                    echo 'Folio fiscal: <span style="color: #000099">'.$tim_uuid.'</span><br>';
                    echo 'Importe total: <span style="color: #000099;">'.$Total.'</span><br><br>';
                echo '</div>';*/
            }
         global $db;

      // $foliocfdi='LYE-0001';

        $sql = "UPDATE `llx_facture_extrafields` SET `uuid` = '".$tim_uuid."' WHERE `llx_facture_extrafields`.`fk_object` = '".$object -> id."'";

################################################### Folio LYE
         // $sql = "UPDATE `llx_facture_extrafields` SET `uuid` = '".$tim_uuid."',`foliocfdi` = '".$foliocfdi."' WHERE `llx_facture_extrafields`.`fk_object` = '".$object -> id."'";

###########################################################          
        $resql = $db->query($sql);
        //$num = $db->num_rows($resql);
            
            $params = $docXML->getElementsByTagName('Emisor');
            foreach ($params as $param) {
                $Emisor_RFC = $param->getAttribute('Rfc');
            }  
            
            $params = $docXML->getElementsByTagName('Receptor');
            foreach ($params as $param) {
                $Receptor_RFC = $param->getAttribute('Rfc');
            }              
            
            $params = $docXML->getElementsByTagName('Comprobante');
            foreach ($params as $param) {
                $total = $param->getAttribute('Total');
            }        
            
            #== 13.9 Se crea el archivo .PNG con codigo bidimensional =================================
            $filename = DOL_DOCUMENT_ROOT.'/custom/cfdi/archs_graf/Img_'.$tim_uuid.".png";
            $CadImpTot = ProcesImpTot($total);
            $Cadena = "https://verificacfdi.facturaelectronica.sat.gob.mx/default.aspx?re=".$Emisor_RFC."&rr=".$Receptor_RFC."&tt=".$CadImpTot."&id=".$tim_uuid;
            QRcode::png($Cadena, $filename, 'H', 3, 2);    
            chmod($filename, 0777); 
            
           /*echo '<div style="font-size: 11pt; color: #000099; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
            echo 'GRÁFICO "QR" RESULTANTE.';
            echo '</div>';
            echo '<img src="http://erp.test/custom/cfdi/archs_graf/Img_'.$tim_uuid.'.png" width="159" height="159" alt="Img_'.$tim_uuid.'.png" style="margin-right: 20px;" />'; */
            
            
            #== 13.10 Se crea código HTML para mostrar opciones al usuario.
            ?>
            
         
            
            <?php
             $folio = $object -> newref;
            // echo $serie_facturacion;

             $path = DOL_DATA_ROOT .'/facture/'.$folio;
			if (!file_exists($path)) {
			    mkdir($path, 0777, true);
			    //echo "Se creao la carpeta ".$path;
			    //echo "</br>";
			}

            if (copy(DOL_DOCUMENT_ROOT.'/custom/cfdi/archs_cfdi/'.$NomArchXML, DOL_DATA_ROOT .'/facture/'.$folio.'/'.$NomArchXML)) {
				   //echo 'Se ha copiado el archivo corretamente';
				}
				else {
				   //echo 'Se produjo un error al copiar el fichero';
				}


                global $db;

       

        $sql = "SELECT * FROM `llx_societe` WHERE `llx_societe`.`rowid` = '".$object -> socid."'";
        $resql = $db->query($sql);
        //$num = $db->num_rows($resql);
        $dom="";

        if ($row=mysqli_fetch_array($resql)){
            $dom = $row['address'];
            $dom = $dom." CP: ".$row['zip'];
            $dom = $dom." ".$row['town'];

        }

        //echo $dom;

        if($object -> fk_account != ""){

        $sql = "SELECT * FROM `llx_bank_account` WHERE `llx_bank_account`.`rowid` = ".$object -> fk_account;
        $resql = $db->query($sql);
        
        $bank_nombre="";
        $bank_cuenta="";
        $bank_clave="";
        $bank_titular="";


        if ($row=mysqli_fetch_array($resql)){
            $rfc = $row['siren'];
            $nombre = $row['nom'];

            $bank_nombre=$row['bank'];
            $bank_cuenta=$row['number'];
            $bank_clave=$row['iban_prefix'];
            $bank_titular=$row['proprio'];
           

        }  

        $bank_desc= "BANCA: ".$bank_nombre." CTA:".$bank_cuenta."  CLABE:".$bank_clave." TITULAR:".$bank_titular;

        //echo $bank_desc; 

    }

################################################# PDF 

$getdata = http_build_query(
array(
    'NomArchXML' => $NomArchXML,
    'NomArchPDF' => $NomArchPDF,
 	'folio'=>$folio,
 	'type'=>$t_documento
 )
);

$opts = array('http' =>
 array(
    'method'  => 'GET',
    'content' => $getdata
)
);

$context  = stream_context_create($opts);

file_get_contents('http://labelweek.com/dolibarrcayro/custom/cfdi/pdf.php??'.$getdata, false, $context);


            

          
        }else{
            
            #== 13.11 En caso de error de timbrado se muestran los detalles al usuario.
            
            $valorNod = "";
           
            
            $codigoError = $VarXML->getElementsByTagName('CodigoError');
           

            foreach($codigoError as $NodoStatus){
                $valorNod = $NodoStatus->nodeValue; 
            }  

            echo '<div style="font-size: 11pt; color: #000099; font-family: Verdana, Arial, Helvetica, sans-serif;">';
            echo 'CÓDIGO DE ERROR.';
            echo '</div>';
            echo '<div style="font-size: 14pt; color: #A70202; font-family: Verdana, Arial, Helvetica, sans-serif; " >';
            echo $valorNod;
            echo '</br>';



            $mensajeError = $VarXML->getElementsByTagName('MensajeIncidencia');
           

            foreach($mensajeError as $NodoStatus){
                $valorNod = $NodoStatus->nodeValue; 
            }  

            echo '<div style="font-size: 11pt; color: #000099; font-family: Verdana, Arial, Helvetica, sans-serif;">';
            echo 'CÓDIGO DE ERROR.';
            echo '</div>';
            
            echo $valorNod;
             
             echo '</div>';
            echo '</br>';
            echo '</br>';

             $valorNod = "";

            

             if (isset($errors)){
            
            
            ?>
            <div class="alert alert-danger" role="alert">
                
                    <strong>Error!</strong>
                    </br> 
                    <?php
                        foreach ($errors as $error) {
                                echo $error;
                                echo "</br>";
                            }
                        ?>
            </div>
            <?php
            }
           
            
          
            

           

            


            exit;
            break;
        }
        
##### FIN DE PROCEDIMIENTOS ####################################################   


      

           
}
        
    

          
        
    
         //exit;
       //break;
			//case 'BILL_UNVALIDATE':
			//case 'BILL_SENTBYMAIL':
			case 'BILL_CANCEL':

            if ($object ->array_options['options_motivocancelacion'] === "01" || $object ->array_options['options_motivocancelacion'] === "02" || $object ->array_options['options_motivocancelacion'] === "03" || $object ->array_options['options_motivocancelacion'] === "04" ){

            /*echo "<h1>Hola Cancelacion</h1>";

            echo "<pre>";
            print_r($object);
            echo "</pre>";*/

            header('Content-Type: text/html; charset=UTF-8');

/*echo '<div style="font-size: 12pt; color: #B40404; margin-bottom: 10px; margin-top: 8px; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
echo 'PROCESO DE TIMBRADO PARA "CANCELAR" CON ACEPTACIÓN.';
echo '</div>';   */


   ### 2. ASIGNACIÓN DE VALORES A VARIABLES ####################################

    $SendaPEMS  = (DOL_DOCUMENT_ROOT.'/custom/cfdi/archs_pem/jb/');   // 2.1 Directorio en donde se encuentran los archivos *.cer.pem y *.key.pem (para efectos de demostración se utilizan los que proporciona el SAT para pruebas).
    $SendaCFDI  = (DOL_DOCUMENT_ROOT.'/custom/cfdi/archs_cfdi/');  // 2.2 Directorio en donde se almacenarán los archivos *.xml (CFDIs).
    //$SendaCFDI  = (DOL_DATA_ROOT.'/custom/facture/'.$serie_folio.'/');  // 2.2 Directorio en donde se almacenarán los archivos *.xml (CFDIs).
    $SendaGRAFS = (DOL_DOCUMENT_ROOT.'/custom/cfdi/archs_graf/');  // 2.3 Directorio en donde se almacenan los archivos .jpg (logo de la empresa) y .png (códigos bidimensionales).
    $SendaXSD   = (DOL_DOCUMENT_ROOT.'/custom/cfdi/archs_xsd/');   // 2.4 Directorio en donde se almacenan los archivos .xsd (esquemas de validación, especificaciones de campos del Anexo 20 del SAT);
  /* $SendaPEMS  = "archs_pem/jb/";  // 2.1 Directorio en donde se encuentran los archivos *.cer.pem y *.key.pem
   $SendaCFDI  = "archs_cfdi/"; // 2.2 Directorio en donde se almacenarán los archivos *.xml
   $SendaGRAFS = "archs_graf/"; // 2.3 Directorio en donde se almacenan los archivos .jpg (logo de la empresa) y .png (códigos bidimensionales).
   $SendaXSD   = "archs_xsd/";  // 2.4 Directorio en donde se almacenan los archivos .xsd (esquemas de validación);
   $contenido_del_nodo_acuse = "";*/
   //$ValorUUID = "31C6E04D-F075-4427-A431-CDB1DECCC582";

    #== RFC del contribuyente (emisor) =========================================
     $taxpayer_id = "BASJ8712064H1";
//    $taxpayer_id = "AAD990814BP7";

   // Nombres de archivos.
   
   $NomArchCerPem     = "BASJ8712064H1.cer.pem"; 
   $NomArchKeyPem     = "BASJ8712064H1.key.pem"; 
   $NomArchKeyEncCert = "BASJ8712064H1.key.enc.pem";
      
      // Datos del CFDI a cancelar.
   //$UUID   = $_GET["UUID"];   // Folio fiscal del CFDI a cancelar.
   $UUID   = $object ->array_options['options_uuid'];   // Folio fiscal del CFDI a cancelar.
   $motivo = $object ->array_options['options_motivocancelacion'];

   if ($object ->array_options['options_motivocancelacion'] === "01"){
     $UUID_REM = $object ->array_options['options_foliosustitucion'];
   }else{ $UUID_REM = "";}
  
   //$UUID="CA2A5D20-E21B-4366-92F6-DAF807444B26";
   //$NoFac  = $_GET["NoFac"];  // No. de factura.
    $NoFac  = $object -> ref ;  // No. de factura.

   
   // Datos de acceso del usuario.
   //$username = $_GET["UserName"];
   //$password = $_GET["PassWord"];

    $username = "jbarranco@labelti.com";
    $password = "Labelti2021!";


    ### MUESTRA LOS DATOS DEL USUARIO QUE ESTÁ TIMBRANDO (OPCIONAL A MOSTRAR) ######
    /*echo '<div style="font-size: 10pt; color: #000000; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
    echo 'DATOS DEL USUARIO QUE ESTÁ TIMBRANDO.';
    echo '</div>';
    echo '<div style="font-size: 10pt; color: #000000; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
    echo 'USUARIO: <span style="color: #088A29; font-size: 11pt;">'.$username."</span><br>";
    echo 'PASSWORD: <span style="color: #088A29; font-size: 11pt;">'.$password."</span><br>";
    echo '</div><br>'; */      
   
    #== Obtener el certificado del archivo .cer.pem ============================
    $cer_path = $SendaPEMS.$NomArchCerPem;
    $cer_file = fopen($cer_path, "r");
    $cer_content = fread($cer_file, filesize($cer_path));


    #== Se muetra el certificado (opcional) ====================================
   /* echo '<div style="font-size: 11pt; color: #000099; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
    echo 'CERTIFICADO DEL ARCHIVO .CER';
    echo '</div>';
    echo '<div style="font-size: 9pt; color: #000000; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
    echo htmlspecialchars($cer_content);
    echo '</div><br>';*/


    #== Conviritien el contenido del certificado a BASE 64 y asignarlo a una variable ======
    $cer_content = base64_encode($cer_content);
    fclose($cer_file);


        #== Encriptar con DES3 =====================================================

        $ArchivoKeyPem = $SendaPEMS.$NomArchKeyPem; //<-- Archivo .key.pem SIN encriptar.
        $ArchivoKeyEncripPem = $SendaPEMS.$NomArchKeyEncCert; //<-- Archivo .key.pem ENCRIPTADO.

        //$Comando_Encriptar = "rsa -in '$ArchivoKeyPem' -des3 -out '$ArchivoKeyEncripPem' -passout pass:".$password;
        //echo$Comando_Encriptar;
        //exec('openssl '.$Comando_Encriptar, $arr, $status); //<-- Se ejecuta el comando para encriptar.

        $Comando_key_pem = "rsa -in ".$ArchivoKeyPem." -des3 -out ".$ArchivoKeyEncripPem." -passout pass:".$password;
    
    exec('openssl '.$Comando_key_pem, $arr, $status);
   

        if ($status==0){
            # Dar permisos de lectura y escritura (necesario en sistemas que se ejecuten en Linux).
            chmod($SendaPEMS.$NomArchKeyEncCert, 0777); //<-- Archivo encriptado resultante.

            /*echo '<div style="font-size: 11pt; color: #196B02; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
            echo '*** PROCESO DE ENCRIPTADO CORRECTO ***';
            echo '</div><br>';*/
        }else{
            /*echo '<div style="font-size: 11pt; color: #A70202; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
            echo '*** ERROR DE ENCRIPTACIÓN ***';
            echo '</div><br>';*/
        }
    
    
    #== Obtener contenido de archivo .key.pem ==================================
    $key_path = $SendaPEMS.$NomArchKeyEncCert;
    $key_file = fopen($key_path, "r");
    $key_content = fread($key_file, filesize($key_path));


    #== Se muetra el certificado (opcional) ====================================
   /* echo '<div style="font-size: 11pt; color: #000099; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
    echo 'CERTIFICADO DEL ARCHIVO .KEY';
    echo '</div>';
    echo '<div style="font-size: 9pt; color: #000000; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
    echo htmlspecialchars($key_content);
    echo '</div><br>';*/


    $key_content = base64_encode($key_content);
    fclose($key_file);
    


//== Creando el SOAP de envío ==================================================
$Cadena = <<<XML
<?xml version="1.0" encoding="UTF-8"?>
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:can="http://facturacion.finkok.com/cancel" xmlns:apps="apps.services.soap.core.views" xmlns:can1="http://facturacion.finkok.com/cancellation">
   <soapenv:Header/>
   <soapenv:Body>
      <can:cancel>
         <can:UUIDS>

            <apps:UUID UUID="$UUID"  FolioSustitucion="$UUID_REM" Motivo="$motivo"/>
        
         </can:UUIDS>
         <can:username>$username</can:username>
         <can:password>$password</can:password>
         <can:taxpayer_id>$taxpayer_id</can:taxpayer_id>
         <can:cer>$cer_content</can:cer>
         <can:key>$key_content</can:key>
         <can:store_pending>TRUE</can:store_pending>
      </can:cancel>
   </soapenv:Body>
</soapenv:Envelope>        
XML;

/*<apps:uuids>
               <can1:string>$UUID</can1:string>
            </apps:uuids>



01  Comprobante emitido con errores de relación
02  Comprobante emitido con errores sin relación
03  No se llevó acabo la operación
04  Operación nominativa relacionada en una factura global


            */


    #== Se muestra el contenido del SOAP de envío (opcional)====================================================
    /*echo '<div style="font-size: 11pt; color: #000099; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
    echo 'CONTENIDO DEL SOAP QUE SE ENVIA AL SERVIDOR DEL PAC';
    echo '</div>';
    echo '<div style="font-size: 9pt; color: #000000; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
    echo htmlspecialchars($Cadena);
    echo '</div><br>';*/

    if (file_exists ($SendaCFDI."soap_cancel_".$NoFac.".xml")==true){
        unlink($SendaCFDI."soap_cancel_".$NoFac.".xml");
    }    

    #=== Guardando el SOAP =====================================================
    $NomArchSoap = $SendaCFDI."soap_cancel_".$NoFac.".xml";

    $fp = fopen($NomArchSoap,"a");
    fwrite($fp, $Cadena);
    fclose($fp);

    #== Dando permisoso de lectura/escritura al archivo .XML del SOAP ==========
    chmod($NomArchSoap, 0777);

        ### URL PRUEBAS ########################################################
       #$process = curl_init('https://demo-facturacion.finkok.com/servicios/soap/cancel.wsdl');

        ### URL PRODUCCION #####################################################
        $process = curl_init('https://facturacion.finkok.com/servicios/soap/cancel.wsdl');

        curl_setopt($process, CURLOPT_HTTPHEADER, array('Content-Type: text/xml',' charset=utf-8'));
        curl_setopt($process, CURLOPT_POSTFIELDS,$Cadena);
        curl_setopt($process, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($process, CURLOPT_POST, true);
        curl_setopt($process, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($process, CURLOPT_SSL_VERIFYHOST, false);
        $RespServ = curl_exec($process);

       /*echo '<div style="font-size: 11pt; color: #000099; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
        echo 'RESPUESTA DEL SERVIDOR DEL PAC';
        echo '</div>';
        echo '<div style="font-size: 9pt; color: #000000; ; font-family: Verdana, Arial, Helvetica, sans-serif;">';
        echo htmlspecialchars($RespServ);
        echo '</div><br>';*/

        $err = 0;

        if (!$RespServ){
                  echo "<h1>Error: ".$RespServ."</h1><br>";
              return(curl_error($process));

            exit;
            break;
           }else{

                #### DATOS DEVUELTOS POR EL SERVIDOR DE FINKOK #################
                $domResp = new DOMDocument();
                $domResp->loadXML($RespServ);
                
                // Se guarda la respuesta del servidor
                $domResp->save($SendaCFDI."RespServ_Cancel_".$NoFac.".xml");
                chmod($SendaCFDI."RespServ_Cancel_".$NoFac.".xml", 0777);

                ################################################################

                $Fecha              = $domResp->getElementsByTagName("Fecha")->item(0)->nodeValue;
                $RfcEmisor          = $domResp->getElementsByTagName("RfcEmisor")->item(0)->nodeValue;
                $EstatusUUID        = $domResp->getElementsByTagName("EstatusUUID")->item(0)->nodeValue;
                $EstatusCancelacion = $domResp->getElementsByTagName("EstatusCancelacion")->item(0)->nodeValue;
                $UUID               = $domResp->getElementsByTagName("UUID")->item(0)->nodeValue;
                $CodEstatus         = $domResp->getElementsByTagName("CodEstatus")->item(0)->nodeValue;


            $folio = $object -> ref;
             //echo $serie_facturacion;
             // echo "</br>";


            $NomArchXML_cancel="RespServ_Cancel_".$folio.".xml";

           // echo $NomArchXML_cancel;

             $path = DOL_DATA_ROOT .'/facture/'.$folio;
            if (!file_exists($path)) {
                mkdir($path, 0777, true);
                //echo "Se creao la carpeta ".$path;
               // echo "</br>";
            }

            if (copy(DOL_DOCUMENT_ROOT.'/custom/cfdi/archs_cfdi/'.$NomArchXML_cancel, DOL_DATA_ROOT .'/facture/'.$folio.'/'.$NomArchXML_cancel)) {
                  // echo 'Se ha copiado el archivo corretamente';
                }
                else {
                  // echo 'Se produjo un error al copiar el fichero';
                }

                 global $db;  


                 /*

                    201 UUID Cancelado.
                    202 UUID Previamente Cancelado.
                    203 UUID no Encontrado.
                    204 UUID no Aplicable a Cancelación.
                    205 UUID no Existe o no lo ha Recibido el SAT.
                    301 XML mal formado.
                    302 Sello mal formado o inválido.
                    303 Sello no corresponde a emisor o caduco.
                    304 Certificado revocado o caduco.
                    305 La fecha de emisión no está dentro de la vigencia del CSD del emisor.
                    306 El certificado no es de tipo CSD.
                    307 El CFDI contiene un timbre previo.
                    308 Certificado no expedido por el SAT.

                 */    

                    if($EstatusUUID === "201" ){$EstatusUUID = $EstatusUUID." UUID Cancelado";}
                    if($EstatusUUID === "202" ){$EstatusUUID = $EstatusUUID." UUID Previamente Cancelado";}
                    if($EstatusUUID === "203" ){$EstatusUUID = $EstatusUUID." UUID no Encontrado";}
                    if($EstatusUUID === "204" ){$EstatusUUID = $EstatusUUID." UUID no Aplicable a Cancelación";}
                    if($EstatusUUID === "205" ){$EstatusUUID = $EstatusUUID." UUID no Existe o no lo ha Recibido el SAT";}
                    if($EstatusUUID === "301" ){$EstatusUUID = $EstatusUUID." XML mal formado";}
                    if($EstatusUUID === "302" ){$EstatusUUID = $EstatusUUID." Sello mal formado o inválido";}
                    if($EstatusUUID === "303" ){$EstatusUUID = $EstatusUUID." Sello no corresponde a emisor o caduco";}
                    if($EstatusUUID === "304" ){$EstatusUUID = $EstatusUUID." Certificado revocado o caduco";}
                    if($EstatusUUID === "305" ){$EstatusUUID = $EstatusUUID." La fecha de emisión no está dentro de la vigencia del CSD del emisor";}
                    if($EstatusUUID === "306" ){$EstatusUUID = $EstatusUUID." El certificado no es de tipo CSD";}
                    if($EstatusUUID === "307" ){$EstatusUUID = $EstatusUUID." El CFDI contiene un timbre previo";}
                    if($EstatusUUID === "308" ){$EstatusUUID = $EstatusUUID." Certificado no expedido por el SAT";}

                $sql = "UPDATE `llx_facture_extrafields` SET `estatusuuid` = '".$EstatusUUID."', `estatuscancelacion` = '".$EstatusCancelacion." ".$CodEstatus."',  `fechacancelacion` = '".$Fecha."' WHERE `llx_facture_extrafields`.`fk_object` = '".$object -> id."'";
                
                $resql = $db->query($sql);

                /*echo '<div style="font-size: 14pt; line-height: 30px; margin-bottom: 300px;">';
                echo '<span style=" color: #000099;">EstatusUUID:</span> <span style=" color: #A70202;">' . $EstatusUUID.'</span><br>';
                echo '<span style=" color: #000099;">EstatusCancelacion:</span> ' . $EstatusCancelacion.'<br>';
                echo '<span style=" color: #000099;">Fecha:</span> ' . $Fecha.'<br>';
                echo '<span style=" color: #000099;">RFC Emisor:</span> ' . $RfcEmisor.'<br>';
                echo '<span style=" color: #000099;">UUID:</span> ' . $UUID;
                 echo '<span style=" color: #000099;">CodEstatus:</span> ' . $CodEstatus;
                echo '</div>';*/
           }

        curl_close($process);

    }

        
        


          

			//case 'BILL_DELETE':
			//case 'BILL_PAYED':

			/*echo "<h1>Hola Pago</h1>";

            echo "<pre>";
            print_r($object);
            echo "</pre>";

           exit;
           break;*/

           
			
			//case 'LINEBILL_INSERT':


			/*echo "<h1>Hola LINEA</h1>";

            echo "<pre>";
            print_r($object);
            echo "</pre>";

           exit;
           break;*/


			 
			//case 'LINEBILL_UPDATE':
			//case 'LINEBILL_DELETE':

			//Supplier Bill
			//case 'BILL_SUPPLIER_CREATE':
			//case 'BILL_SUPPLIER_UPDATE':
			//case 'BILL_SUPPLIER_DELETE':
			//case 'BILL_SUPPLIER_PAYED':
			//case 'BILL_SUPPLIER_UNPAYED':
			//case 'BILL_SUPPLIER_VALIDATE':
			//case 'BILL_SUPPLIER_UNVALIDATE':
			//case 'LINEBILL_SUPPLIER_CREATE':
			//case 'LINEBILL_SUPPLIER_UPDATE':
			//case 'LINEBILL_SUPPLIER_DELETE':

			// Payments
			//case 'PAYMENT_CUSTOMER_CREATE':
			//case 'PAYMENT_SUPPLIER_CREATE':
			//case 'PAYMENT_ADD_TO_BANK':
			//case 'PAYMENT_DELETE':

			// Online
			//case 'PAYMENT_PAYBOX_OK':
			//case 'PAYMENT_PAYPAL_OK':
			//case 'PAYMENT_STRIPE_OK':

			// Donation
			//case 'DON_CREATE':
			//case 'DON_UPDATE':
			//case 'DON_DELETE':

			// Interventions
			//case 'FICHINTER_CREATE':
			//case 'FICHINTER_MODIFY':
			//case 'FICHINTER_VALIDATE':
			//case 'FICHINTER_DELETE':
			//case 'LINEFICHINTER_CREATE':
			//case 'LINEFICHINTER_UPDATE':
			//case 'LINEFICHINTER_DELETE':

			// Members
			//case 'MEMBER_CREATE':
			//case 'MEMBER_VALIDATE':
			//case 'MEMBER_SUBSCRIPTION':
			//case 'MEMBER_MODIFY':
			//case 'MEMBER_NEW_PASSWORD':
			//case 'MEMBER_RESILIATE':
			//case 'MEMBER_DELETE':

			// Categories
			//case 'CATEGORY_CREATE':
			//case 'CATEGORY_MODIFY':
			//case 'CATEGORY_DELETE':
			//case 'CATEGORY_SET_MULTILANGS':

			// Projects
			//case 'PROJECT_CREATE':
			//case 'PROJECT_MODIFY':
			//case 'PROJECT_DELETE':

			// Project tasks
			//case 'TASK_CREATE':
			//case 'TASK_MODIFY':
			//case 'TASK_DELETE':

			// Task time spent
			//case 'TASK_TIMESPENT_CREATE':
			//case 'TASK_TIMESPENT_MODIFY':
			//case 'TASK_TIMESPENT_DELETE':
			//case 'PROJECT_ADD_CONTACT':
			//case 'PROJECT_DELETE_CONTACT':
			//case 'PROJECT_DELETE_RESOURCE':

			// Shipping
			//case 'SHIPPING_CREATE':
			//case 'SHIPPING_MODIFY':
			//case 'SHIPPING_VALIDATE':
			//case 'SHIPPING_SENTBYMAIL':
			//case 'SHIPPING_BILLED':
			//case 'SHIPPING_CLOSED':
			//case 'SHIPPING_REOPEN':
			//case 'SHIPPING_DELETE':

			// and more...

			default:
				dol_syslog("Trigger '".$this->name."' for action '$action' launched by ".__FILE__.". id=".$object->id);
				break;
		}

		return 0;
	}
}
