-- MySQL or MariaDB dump via php with Dolibarr 19.0.0
--
-- Host: Localhost via UNIX socket    Database: dolibarr_migra
-- ------------------------------------------------------
-- Server version	5.5.5-10.3.39-MariaDB-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


--
-- Table structure for table `llx_accounting_account`
--
DROP TABLE IF EXISTS `llx_accounting_account`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_accounting_account` (
  `rowid` bigint(20) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT 1,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `fk_pcg_version` varchar(32) NOT NULL,
  `pcg_type` varchar(60) DEFAULT NULL,
  `account_number` varchar(32) NOT NULL,
  `account_parent` int(11) DEFAULT 0,
  `label` varchar(255) NOT NULL,
  `labelshort` varchar(255) DEFAULT NULL,
  `fk_accounting_category` int(11) DEFAULT 0,
  `fk_user_author` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  `active` tinyint(4) NOT NULL DEFAULT 1,
  `reconcilable` tinyint(4) NOT NULL DEFAULT 0,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_accounting_account` (`account_number`,`entity`,`fk_pcg_version`),
  KEY `idx_accounting_account_fk_pcg_version` (`fk_pcg_version`),
  KEY `idx_accounting_account_account_parent` (`account_parent`),
  CONSTRAINT `fk_accounting_account_fk_pcg_version` FOREIGN KEY (`fk_pcg_version`) REFERENCES `llx_accounting_system` (`pcg_version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `llx_accounting_account`
--
LOCK TABLES `llx_accounting_account` WRITE;
/*!40000 ALTER TABLE `llx_accounting_account` DISABLE KEYS */;
UNLOCK TABLES;




--
-- Table structure for table `llx_accounting_bookkeeping`
--
DROP TABLE IF EXISTS `llx_accounting_bookkeeping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_accounting_bookkeeping` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT 1,
  `piece_num` int(11) NOT NULL,
  `doc_date` date NOT NULL,
  `doc_type` varchar(30) NOT NULL,
  `doc_ref` varchar(300) NOT NULL,
  `fk_doc` int(11) NOT NULL,
  `fk_docdet` int(11) NOT NULL,
  `thirdparty_code` varchar(32) DEFAULT NULL,
  `subledger_account` varchar(32) DEFAULT NULL,
  `subledger_label` varchar(255) DEFAULT NULL,
  `numero_compte` varchar(32) NOT NULL,
  `label_compte` varchar(255) NOT NULL,
  `label_operation` varchar(255) DEFAULT NULL,
  `debit` double(24,8) NOT NULL,
  `credit` double(24,8) NOT NULL,
  `montant` double(24,8) DEFAULT NULL,
  `sens` varchar(1) DEFAULT NULL,
  `multicurrency_amount` double(24,8) DEFAULT NULL,
  `multicurrency_code` varchar(255) DEFAULT NULL,
  `lettering_code` varchar(255) DEFAULT NULL,
  `date_lettering` datetime DEFAULT NULL,
  `date_lim_reglement` datetime DEFAULT NULL,
  `fk_user_author` int(11) NOT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  `date_creation` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `fk_user` int(11) DEFAULT NULL,
  `code_journal` varchar(32) NOT NULL,
  `journal_label` varchar(255) DEFAULT NULL,
  `date_validated` datetime DEFAULT NULL,
  `date_export` datetime DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_accounting_bookkeeping_fk_doc` (`fk_doc`),
  KEY `idx_accounting_bookkeeping_fk_docdet` (`fk_docdet`),
  KEY `idx_accounting_bookkeeping_doc_date` (`doc_date`),
  KEY `idx_accounting_bookkeeping_numero_compte` (`numero_compte`,`entity`),
  KEY `idx_accounting_bookkeeping_code_journal` (`code_journal`,`entity`),
  KEY `idx_accounting_bookkeeping_piece_num` (`piece_num`,`entity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `llx_accounting_bookkeeping`
--
LOCK TABLES `llx_accounting_bookkeeping` WRITE;
/*!40000 ALTER TABLE `llx_accounting_bookkeeping` DISABLE KEYS */;
UNLOCK TABLES;




--
-- Table structure for table `llx_accounting_bookkeeping_tmp`
--
DROP TABLE IF EXISTS `llx_accounting_bookkeeping_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_accounting_bookkeeping_tmp` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT 1,
  `doc_date` date NOT NULL,
  `doc_type` varchar(30) NOT NULL,
  `doc_ref` varchar(300) NOT NULL,
  `fk_doc` int(11) NOT NULL,
  `fk_docdet` int(11) NOT NULL,
  `thirdparty_code` varchar(32) DEFAULT NULL,
  `subledger_account` varchar(32) DEFAULT NULL,
  `subledger_label` varchar(255) DEFAULT NULL,
  `numero_compte` varchar(32) DEFAULT NULL,
  `label_compte` varchar(255) NOT NULL,
  `label_operation` varchar(255) DEFAULT NULL,
  `debit` double(24,8) NOT NULL,
  `credit` double(24,8) NOT NULL,
  `montant` double(24,8) NOT NULL,
  `sens` varchar(1) DEFAULT NULL,
  `multicurrency_amount` double(24,8) DEFAULT NULL,
  `multicurrency_code` varchar(255) DEFAULT NULL,
  `lettering_code` varchar(255) DEFAULT NULL,
  `date_lettering` datetime DEFAULT NULL,
  `date_lim_reglement` datetime DEFAULT NULL,
  `fk_user_author` int(11) NOT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  `date_creation` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `fk_user` int(11) DEFAULT NULL,
  `code_journal` varchar(32) NOT NULL,
  `journal_label` varchar(255) DEFAULT NULL,
  `piece_num` int(11) NOT NULL,
  `date_validated` datetime DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_accounting_bookkeeping_tmp_doc_date` (`doc_date`),
  KEY `idx_accounting_bookkeeping_tmp_fk_docdet` (`fk_docdet`),
  KEY `idx_accounting_bookkeeping_tmp_numero_compte` (`numero_compte`),
  KEY `idx_accounting_bookkeeping_tmp_code_journal` (`code_journal`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `llx_accounting_bookkeeping_tmp`
--
LOCK TABLES `llx_accounting_bookkeeping_tmp` WRITE;
/*!40000 ALTER TABLE `llx_accounting_bookkeeping_tmp` DISABLE KEYS */;
UNLOCK TABLES;




--
-- Table structure for table `llx_accounting_fiscalyear`
--
DROP TABLE IF EXISTS `llx_accounting_fiscalyear`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_accounting_fiscalyear` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(128) NOT NULL,
  `date_start` date DEFAULT NULL,
  `date_end` date DEFAULT NULL,
  `statut` tinyint(4) NOT NULL DEFAULT 0,
  `entity` int(11) NOT NULL DEFAULT 1,
  `datec` datetime NOT NULL,
  `tms` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `fk_user_author` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `llx_accounting_fiscalyear`
--
LOCK TABLES `llx_accounting_fiscalyear` WRITE;
/*!40000 ALTER TABLE `llx_accounting_fiscalyear` DISABLE KEYS */;
UNLOCK TABLES;




--
-- Table structure for table `llx_accounting_groups_account`
--
DROP TABLE IF EXISTS `llx_accounting_groups_account`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_accounting_groups_account` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_accounting_account` int(11) NOT NULL,
  `fk_c_accounting_category` int(11) NOT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `llx_accounting_groups_account`
--
LOCK TABLES `llx_accounting_groups_account` WRITE;
/*!40000 ALTER TABLE `llx_accounting_groups_account` DISABLE KEYS */;
UNLOCK TABLES;




--
-- Table structure for table `llx_accounting_journal`
--
DROP TABLE IF EXISTS `llx_accounting_journal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_accounting_journal` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT 1,
  `code` varchar(32) NOT NULL,
  `label` varchar(128) NOT NULL,
  `nature` smallint(6) NOT NULL DEFAULT 1,
  `active` smallint(6) DEFAULT 0,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_accounting_journal_code` (`code`,`entity`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `llx_accounting_journal`
--
LOCK TABLES `llx_accounting_journal` WRITE;
/*!40000 ALTER TABLE `llx_accounting_journal` DISABLE KEYS */;
INSERT INTO llx_accounting_journal VALUES (1,1,'VT','ACCOUNTING_SELL_JOURNAL',2,1);
INSERT INTO llx_accounting_journal VALUES (2,1,'AC','ACCOUNTING_PURCHASE_JOURNAL',3,1);
INSERT INTO llx_accounting_journal VALUES (3,1,'BQ','FinanceJournal',4,1);
INSERT INTO llx_accounting_journal VALUES (4,1,'OD','ACCOUNTING_MISCELLANEOUS_JOURNAL',1,1);
INSERT INTO llx_accounting_journal VALUES (5,1,'AN','ACCOUNTING_HAS_NEW_JOURNAL',9,1);
INSERT INTO llx_accounting_journal VALUES (6,1,'ER','ExpenseReportsJournal',5,1);
INSERT INTO llx_accounting_journal VALUES (7,1,'INV','InventoryJournal',8,1);
UNLOCK TABLES;




--
-- Table structure for table `llx_accounting_system`
--
DROP TABLE IF EXISTS `llx_accounting_system`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_accounting_system` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_country` int(11) DEFAULT NULL,
  `pcg_version` varchar(32) NOT NULL,
  `label` varchar(128) NOT NULL,
  `active` smallint(6) DEFAULT 0,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_accounting_system_pcg_version` (`pcg_version`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `llx_accounting_system`
--
LOCK TABLES `llx_accounting_system` WRITE;
/*!40000 ALTER TABLE `llx_accounting_system` DISABLE KEYS */;
INSERT INTO llx_accounting_system VALUES (1,1,'PCG99-ABREGE','The simple accountancy french plan',1);
INSERT INTO llx_accounting_system VALUES (2,1,'PCG99-BASE','The base accountancy french plan',1);
INSERT INTO llx_accounting_system VALUES (3,1,'PCG14-DEV','The developed accountancy french plan 2014',1);
INSERT INTO llx_accounting_system VALUES (4,1,'PCG18-ASSOC','French foundation chart of accounts 2018',1);
INSERT INTO llx_accounting_system VALUES (5,1,'PCGAFR14-DEV','The developed farm accountancy french plan 2014',1);
INSERT INTO llx_accounting_system VALUES (6,2,'PCMN-BASE','The base accountancy belgium plan',1);
INSERT INTO llx_accounting_system VALUES (7,4,'PCG08-PYME','The PYME accountancy spanish plan',1);
INSERT INTO llx_accounting_system VALUES (8,5,'SKR03','Standardkontenrahmen SKR 03',1);
INSERT INTO llx_accounting_system VALUES (9,5,'SKR04','Standardkontenrahmen SKR 04',1);
INSERT INTO llx_accounting_system VALUES (10,6,'PCG_SUISSE','Switzerland plan',1);
INSERT INTO llx_accounting_system VALUES (11,7,'ENG-BASE','England plan',1);
INSERT INTO llx_accounting_system VALUES (12,10,'PCT','The Tunisia plan',1);
INSERT INTO llx_accounting_system VALUES (13,12,'PCG','The Moroccan chart of accounts',1);
INSERT INTO llx_accounting_system VALUES (14,13,'NSCF','Nouveau système comptable financier',1);
INSERT INTO llx_accounting_system VALUES (15,17,'NL-VERKORT','Verkort rekeningschema',1);
INSERT INTO llx_accounting_system VALUES (16,20,'BAS-K1-MINI','The Swedish mini chart of accounts',1);
INSERT INTO llx_accounting_system VALUES (17,41,'AT-BASE','Plan Austria',1);
INSERT INTO llx_accounting_system VALUES (18,67,'PC-MIPYME','The PYME accountancy Chile plan',1);
INSERT INTO llx_accounting_system VALUES (19,80,'DK-STD','Standardkontoplan fra SKAT',1);
INSERT INTO llx_accounting_system VALUES (20,84,'EC-SUPERCIAS','Plan de cuentas Ecuador',1);
INSERT INTO llx_accounting_system VALUES (21,140,'PCN-LUXEMBURG','Plan comptable normalisé Luxembourgeois',1);
INSERT INTO llx_accounting_system VALUES (22,188,'RO-BASE','Plan de conturi romanesc',1);
INSERT INTO llx_accounting_system VALUES (23,49,'SYSCOHADA-BJ','Plan comptable Ouest-Africain',1);
INSERT INTO llx_accounting_system VALUES (24,60,'SYSCOHADA-BF','Plan comptable Ouest-Africain',1);
INSERT INTO llx_accounting_system VALUES (25,73,'SYSCOHADA-CD','Plan comptable Ouest-Africain',1);
INSERT INTO llx_accounting_system VALUES (26,65,'SYSCOHADA-CF','Plan comptable Ouest-Africain',1);
INSERT INTO llx_accounting_system VALUES (27,72,'SYSCOHADA-CG','Plan comptable Ouest-Africain',1);
INSERT INTO llx_accounting_system VALUES (28,21,'SYSCOHADA-CI','Plan comptable Ouest-Africain',1);
INSERT INTO llx_accounting_system VALUES (29,24,'SYSCOHADA-CM','Plan comptable Ouest-Africain',1);
INSERT INTO llx_accounting_system VALUES (30,16,'SYSCOHADA-GA','Plan comptable Ouest-Africain',1);
INSERT INTO llx_accounting_system VALUES (31,87,'SYSCOHADA-GQ','Plan comptable Ouest-Africain',1);
INSERT INTO llx_accounting_system VALUES (32,71,'SYSCOHADA-KM','Plan comptable Ouest-Africain',1);
INSERT INTO llx_accounting_system VALUES (33,147,'SYSCOHADA-ML','Plan comptable Ouest-Africain',1);
INSERT INTO llx_accounting_system VALUES (34,168,'SYSCOHADA-NE','Plan comptable Ouest-Africain',1);
INSERT INTO llx_accounting_system VALUES (35,22,'SYSCOHADA-SN','Plan comptable Ouest-Africain',1);
INSERT INTO llx_accounting_system VALUES (36,66,'SYSCOHADA-TD','Plan comptable Ouest-Africain',1);
INSERT INTO llx_accounting_system VALUES (37,15,'SYSCOHADA-TG','Plan comptable Ouest-Africain',1);
INSERT INTO llx_accounting_system VALUES (38,11,'US-BASE','USA basic chart of accounts',1);
INSERT INTO llx_accounting_system VALUES (39,14,'CA-ENG-BASE','Canadian basic chart of accounts - English',1);
INSERT INTO llx_accounting_system VALUES (40,154,'SAT/24-2019','Catalogo y codigo agrupador fiscal del 2019',1);
INSERT INTO llx_accounting_system VALUES (41,140,'PCN2020-LUXEMBURG','Plan comptable normalisé 2020 Luxembourgeois',1);
UNLOCK TABLES;




--
-- Table structure for table `llx_actioncomm`
--
DROP TABLE IF EXISTS `llx_actioncomm`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_actioncomm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) NOT NULL,
  `ref_ext` varchar(255) DEFAULT NULL,
  `entity` int(11) NOT NULL DEFAULT 1,
  `datep` datetime DEFAULT NULL,
  `datep2` datetime DEFAULT NULL,
  `fk_action` int(11) DEFAULT NULL,
  `code` varchar(50) DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `fk_user_author` int(11) DEFAULT NULL,
  `fk_user_mod` int(11) DEFAULT NULL,
  `fk_project` int(11) DEFAULT NULL,
  `fk_soc` int(11) DEFAULT NULL,
  `fk_contact` int(11) DEFAULT NULL,
  `fk_parent` int(11) NOT NULL DEFAULT 0,
  `fk_user_action` int(11) DEFAULT NULL,
  `fk_user_done` int(11) DEFAULT NULL,
  `transparency` int(11) DEFAULT NULL,
  `priority` smallint(6) DEFAULT NULL,
  `visibility` varchar(12) DEFAULT 'default',
  `fulldayevent` smallint(6) NOT NULL DEFAULT 0,
  `percent` smallint(6) NOT NULL DEFAULT 0,
  `location` varchar(128) DEFAULT NULL,
  `durationp` double DEFAULT NULL,
  `label` varchar(255) NOT NULL,
  `note` mediumtext DEFAULT NULL,
  `calling_duration` int(11) DEFAULT NULL,
  `email_subject` varchar(255) DEFAULT NULL,
  `email_msgid` varchar(255) DEFAULT NULL,
  `email_from` varchar(255) DEFAULT NULL,
  `email_sender` varchar(255) DEFAULT NULL,
  `email_to` varchar(255) DEFAULT NULL,
  `email_tocc` varchar(255) DEFAULT NULL,
  `email_tobcc` varchar(255) DEFAULT NULL,
  `errors_to` varchar(255) DEFAULT NULL,
  `reply_to` varchar(255) DEFAULT NULL,
  `recurid` varchar(128) DEFAULT NULL,
  `recurrule` varchar(128) DEFAULT NULL,
  `recurdateend` datetime DEFAULT NULL,
  `num_vote` int(11) DEFAULT NULL,
  `event_paid` smallint(6) NOT NULL DEFAULT 0,
  `status` smallint(6) NOT NULL DEFAULT 0,
  `fk_element` int(11) DEFAULT NULL,
  `elementtype` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  `ip` varchar(250) DEFAULT NULL,
  `fk_bookcal_calendar` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_actioncomm_fk_soc` (`fk_soc`),
  KEY `idx_actioncomm_fk_contact` (`fk_contact`),
  KEY `idx_actioncomm_code` (`code`),
  KEY `idx_actioncomm_fk_element` (`fk_element`),
  KEY `idx_actioncomm_fk_user_action` (`fk_user_action`),
  KEY `idx_actioncomm_fk_project` (`fk_project`),
  KEY `idx_actioncomm_datep` (`datep`),
  KEY `idx_actioncomm_datep2` (`datep2`),
  KEY `idx_actioncomm_recurid` (`recurid`),
  KEY `idx_actioncomm_ref_ext` (`ref_ext`),
  KEY `idx_actioncomm_percent` (`percent`),
  KEY `idx_actioncomm_ref` (`ref`,`entity`),
  KEY `idx_actioncomm_entity` (`entity`)
) ENGINE=InnoDB AUTO_INCREMENT=70607 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `llx_actioncomm`
--
LOCK TABLES `llx_actioncomm` WRITE;
/*!40000 ALTER TABLE `llx_actioncomm` DISABLE KEYS */;
INSERT INTO llx_actioncomm VALUES (1,1,NULL,1,'2022-07-20 22:50:41','2022-07-20 22:50:41',40,'AC_COMPANY_CREATE','2022-07-20 22:50:41','2022-07-20 10:50:41',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero Publico en General creado','Autor: admin\nTercero Publico en General creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2,2,NULL,1,'2022-07-20 22:57:20','2022-07-20 22:57:20',40,'AC_BILL_VALIDATE','2022-07-20 22:57:20','2022-07-20 10:57:20',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2207-0001 validada','Autor: admin\nFactura FA2207-0001 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,1,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (3,3,NULL,1,'2022-07-20 23:27:55','2022-07-20 23:27:55',40,'AC_PRODUCT_MODIFY','2022-07-20 23:27:55','2022-07-20 11:27:55',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto TIMBRE_DE_FRESA_Granel modificado','Autor: admin\nProducto TIMBRE_DE_FRESA_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,200,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (4,4,NULL,1,'2022-07-21 14:23:43','2022-07-21 14:23:43',40,'AC_PRODUCT_MODIFY','2022-07-21 14:23:43','2022-07-21 02:23:43',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AVENA modificado','Autor: admin\nProducto AVENA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,203,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (5,5,NULL,1,'2022-07-21 16:29:40','2022-07-21 16:29:40',40,'AC_PRODUCT_CREATE','2022-07-21 16:29:40','2022-07-21 04:29:40',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto PIZCA_DE_CHOCOLATE creado','Autor: admin\nProducto PIZCA_DE_CHOCOLATE creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,278,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (6,6,NULL,1,'2022-07-21 16:35:29','2022-07-21 16:35:29',40,'AC_PRODUCT_CREATE','2022-07-21 16:35:29','2022-07-21 04:35:29',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEA_100G creado','Autor: admin\nProducto GRAGEA_100G creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,279,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (7,7,NULL,1,'2022-07-21 16:38:27','2022-07-21 16:38:27',40,'AC_PRODUCT_CREATE','2022-07-21 16:38:27','2022-07-21 04:38:27',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEA_400G creado','Autor: admin\nProducto GRAGEA_400G creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,280,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (8,8,NULL,1,'2022-07-21 16:56:03','2022-07-21 16:56:03',40,'AC_PRODUCT_CREATE','2022-07-21 16:56:03','2022-07-21 04:56:03',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto ARROZ_500G creado','Autor: admin\nProducto ARROZ_500G creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,281,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (9,9,NULL,1,'2022-07-21 16:57:18','2022-07-21 16:57:18',40,'AC_PRODUCT_CREATE','2022-07-21 16:57:18','2022-07-21 04:57:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto ARROZ_900G creado','Autor: admin\nProducto ARROZ_900G creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,282,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (10,10,NULL,1,'2022-07-21 17:39:55','2022-07-21 17:39:55',40,'AC_PRODUCT_MODIFY','2022-07-21 17:39:55','2022-07-21 05:39:55',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BARRAS_DE_COCO modificado','Autor: admin\nProducto BARRAS_DE_COCO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,214,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (11,11,NULL,1,'2022-07-21 17:43:35','2022-07-21 17:43:35',40,'AC_PRODUCT_MODIFY','2022-07-21 17:43:35','2022-07-21 05:43:35',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BARRAS_DE_COCO modificado','Autor: admin\nProducto BARRAS_DE_COCO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,214,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (12,12,NULL,1,'2022-07-21 17:49:09','2022-07-21 17:49:09',40,'AC_PRODUCT_CREATE','2022-07-21 17:49:09','2022-07-21 05:49:09',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Test creado','Autor: admin\nProducto Test creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,283,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (13,13,NULL,1,'2022-07-21 17:49:55','2022-07-21 17:49:55',40,'AC_PRODUCT_MODIFY','2022-07-21 17:49:55','2022-07-21 05:49:55',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Test modificado','Autor: admin\nProducto Test modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,283,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (14,14,NULL,1,'2022-07-21 17:51:15','2022-07-21 17:51:15',40,'AC_COMPANY_CREATE','2022-07-21 17:51:15','2022-07-21 05:51:15',1,NULL,NULL,2,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero JB creado','Autor: admin\nTercero JB creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (15,15,NULL,1,'2022-07-21 17:56:45','2022-07-21 17:56:45',40,'AC_COMPANY_CREATE','2022-07-21 17:56:45','2022-07-21 05:56:45',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero Producción creado','Autor: admin\nTercero Producción creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (16,16,NULL,1,'2022-07-21 18:00:28','2022-07-21 18:00:28',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-21 18:00:28','2022-07-21 06:00:28',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0001 validada','Autor: admin\nFactura SI2207-0001 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,2,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (17,17,NULL,1,'2022-07-21 18:00:40','2022-07-21 18:00:40',40,'AC_BILL_SUPPLIER_PAYED','2022-07-21 18:00:40','2022-07-21 06:00:40',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0001 pasada a pagada','Autor: admin\nFactura SI2207-0001 pasada a pagada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,2,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (18,18,NULL,1,'2022-07-21 18:10:53','2022-07-21 18:10:53',40,'AC_ORDER_VALIDATE','2022-07-21 18:10:53','2022-07-21 06:10:53',1,NULL,NULL,2,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2207-0001 validada','Autor: admin\nOrden CO2207-0001 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,1,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (19,19,NULL,1,'2022-07-21 18:11:10','2022-07-21 18:11:10',40,'AC_ORDER_CLASSIFY_BILLED','2022-07-21 18:11:10','2022-07-21 06:11:10',1,NULL,NULL,2,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2207-0001 clasificada como facturada','Autor: admin\nOrden CO2207-0001 clasificada como facturada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,1,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (20,20,NULL,1,'2022-07-21 18:11:24','2022-07-21 18:11:24',40,'AC_ORDER_CLOSE','2022-07-21 18:11:24','2022-07-21 06:11:24',1,NULL,NULL,2,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2207-0001 clasificado como entregado','Autor: admin\nOrden CO2207-0001 clasificado como entregado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,1,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (21,21,NULL,1,'2022-07-21 18:41:36','2022-07-21 18:41:36',40,'AC_PRODUCT_MODIFY','2022-07-21 18:41:36','2022-07-21 06:41:36',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto ACEITE_COMESTIBLE modificado','Autor: admin\nProducto ACEITE_COMESTIBLE modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,258,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (22,22,NULL,1,'2022-07-22 00:41:05','2022-07-22 00:41:05',40,'AC_COMPANY_MODIFY','2022-07-22 00:41:05','2022-07-21 12:41:05',1,NULL,NULL,2,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero JB modificado','Autor: admin\nTercero JB modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (23,23,NULL,1,'2022-07-22 00:58:13','2022-07-22 00:58:13',40,'AC_ORDER_VALIDATE','2022-07-22 00:58:13','2022-07-21 12:58:13',1,NULL,NULL,2,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2207-0001 validada','Autor: admin\nOrden CO2207-0001 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,1,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (24,24,NULL,1,'2022-07-22 17:30:11','2022-07-22 17:30:11',40,'AC_COMPANY_CREATE','2022-07-22 17:30:11','2022-07-22 05:30:11',1,NULL,NULL,4,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero Proveedor Temporal creado','Autor: admin\nTercero Proveedor Temporal creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (25,25,NULL,1,'2022-07-22 17:30:59','2022-07-22 17:30:59',40,'AC_COMPANY_MODIFY','2022-07-22 17:30:59','2022-07-22 05:30:59',1,NULL,NULL,4,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero Proveedor Temporal modificado','Autor: admin\nTercero Proveedor Temporal modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (26,26,NULL,1,'2022-07-22 17:32:15','2022-07-22 17:32:15',40,'AC_CONTACT_CREATE','2022-07-22 17:32:15','2022-07-22 05:32:15',1,NULL,NULL,4,1,0,1,NULL,0,0,'default',0,-1,'',NULL,'Contacto Julio Barranco creado','Autor: admin\nContacto Julio Barranco creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (27,27,NULL,1,'2022-07-22 17:32:51','2022-07-22 17:32:51',40,'AC_CONTACT_CREATE','2022-07-22 17:32:51','2022-07-22 05:32:51',1,NULL,NULL,4,2,0,1,NULL,0,0,'default',0,-1,'',NULL,'Contacto Omar Arroyo creado','Autor: admin\nContacto Omar Arroyo creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (28,28,NULL,1,'2022-07-22 17:42:29','2022-07-22 17:42:29',40,'AC_PRODUCT_CREATE','2022-07-22 17:42:29','2022-07-22 05:42:29',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto PruebaMP creado','Autor: admin\nProducto PruebaMP creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,284,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (29,29,NULL,1,'2022-07-22 17:43:07','2022-07-22 17:43:07',40,'AC_PRODUCT_MODIFY','2022-07-22 17:43:07','2022-07-22 05:43:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto PruebaMP modificado','Autor: admin\nProducto PruebaMP modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,284,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (30,30,NULL,1,'2022-07-22 17:47:03','2022-07-22 17:47:03',40,'AC_PRODUCT_MODIFY','2022-07-22 17:47:03','2022-07-22 05:47:03',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto PruebaMP modificado','Autor: admin\nProducto PruebaMP modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,284,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (31,31,NULL,1,'2022-07-22 17:52:21','2022-07-22 17:52:21',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-22 17:52:21','2022-07-22 05:52:21',1,NULL,NULL,4,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0002 validada','Autor: admin\nFactura SI2207-0002 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,3,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (32,32,NULL,1,'2022-07-22 17:56:42','2022-07-22 17:56:42',40,'AC_BILL_SUPPLIER_PAYED','2022-07-22 17:56:42','2022-07-22 05:56:42',1,NULL,NULL,4,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0002 pasada a pagada','Autor: admin\nFactura SI2207-0002 pasada a pagada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,3,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (33,33,NULL,1,'2022-07-22 18:06:54','2022-07-22 18:06:54',40,'AC_PRODUCT_MODIFY','2022-07-22 18:06:54','2022-07-22 06:06:54',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AGUA modificado','Autor: admin\nProducto AGUA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,241,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (34,34,NULL,1,'2022-07-25 14:04:24','2022-07-25 14:04:24',40,'AC_PRODUCT_MODIFY','2022-07-25 14:04:24','2022-07-25 02:04:24',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MINI_PIZCA_DE_CHOCOLATE modificado','Autor: admin\nProducto MINI_PIZCA_DE_CHOCOLATE modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,278,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (35,35,NULL,1,'2022-07-25 14:29:09','2022-07-25 14:29:09',40,'AC_PRODUCT_MODIFY','2022-07-25 14:29:09','2022-07-25 02:29:09',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MINI_PIZCA_DE_CHOCOLATE modificado','Autor: admin\nProducto MINI_PIZCA_DE_CHOCOLATE modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,278,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (36,36,NULL,1,'2022-07-25 14:29:58','2022-07-25 14:29:58',40,'AC_PRODUCT_MODIFY','2022-07-25 14:29:58','2022-07-25 02:29:58',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MINI_COCO modificado','Autor: admin\nProducto MINI_COCO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,206,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (37,37,NULL,1,'2022-07-25 14:30:08','2022-07-25 14:30:08',40,'AC_PRODUCT_MODIFY','2022-07-25 14:30:08','2022-07-25 02:30:08',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MINI_COCO modificado','Autor: admin\nProducto MINI_COCO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,206,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (38,38,NULL,1,'2022-07-25 14:30:31','2022-07-25 14:30:31',40,'AC_PRODUCT_MODIFY','2022-07-25 14:30:31','2022-07-25 02:30:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto OREJAS modificado','Autor: admin\nProducto OREJAS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,213,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (39,39,NULL,1,'2022-07-25 14:30:59','2022-07-25 14:30:59',40,'AC_PRODUCT_MODIFY','2022-07-25 14:30:59','2022-07-25 02:30:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto PIZCA_DE_CHOCOLATE modificado','Autor: admin\nProducto PIZCA_DE_CHOCOLATE modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,215,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (40,40,NULL,1,'2022-07-25 14:31:40','2022-07-25 14:31:40',40,'AC_PRODUCT_MODIFY','2022-07-25 14:31:40','2022-07-25 02:31:40',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GALLETA_DE_ARANDANO modificado','Autor: admin\nProducto GALLETA_DE_ARANDANO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,209,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (41,41,NULL,1,'2022-07-25 14:32:41','2022-07-25 14:32:41',40,'AC_PRODUCT_MODIFY','2022-07-25 14:32:41','2022-07-25 02:32:41',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AVENA_100G modificado','Autor: admin\nProducto AVENA_100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,219,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (42,42,NULL,1,'2022-07-25 17:08:47','2022-07-25 17:08:47',40,'AC_PROJECT_CREATE','2022-07-25 17:08:47','2022-07-25 05:08:47',1,NULL,1,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Proyecto PJ2207-0001 creado','Autor: admin\nProyecto PJ2207-0001 creado\nProyecto: PJ2207-0001',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (43,43,NULL,1,'2022-07-25 18:05:59','2022-07-25 18:05:59',40,'AC_PRODUCT_MODIFY','2022-07-25 18:05:59','2022-07-25 06:05:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AVENA_Granel modificado','Autor: admin\nProducto AVENA_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,186,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (44,44,NULL,1,'2022-07-25 18:06:03','2022-07-25 18:06:03',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-25 18:06:03','2022-07-25 06:06:03',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0003 validada','Autor: admin\nFactura SI2207-0003 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,5,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (45,45,NULL,1,'2022-07-25 18:08:20','2022-07-25 18:08:20',40,'AC_PRODUCT_MODIFY','2022-07-25 18:08:20','2022-07-25 06:08:20',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEA_Granel modificado','Autor: admin\nProducto GRAGEA_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,187,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (46,46,NULL,1,'2022-07-25 19:03:04','2022-07-25 19:03:04',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-25 19:03:04','2022-07-25 07:03:04',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0004 validada','Autor: admin\nFactura SI2207-0004 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,7,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (47,47,NULL,1,'2022-07-25 19:07:00','2022-07-25 19:07:00',40,'AC_BILL_SUPPLIER_DELETE','2022-07-25 19:07:00','2022-07-25 07:07:00',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura de proveedor eliminada','Autor: admin\nFactura de proveedor eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,8,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (48,48,NULL,1,'2022-07-25 19:09:04','2022-07-25 19:09:04',40,'AC_PRODUCT_MODIFY','2022-07-25 19:09:04','2022-07-25 07:09:04',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AVENA_100G modificado','Autor: admin\nProducto AVENA_100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,219,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (49,49,NULL,1,'2022-07-25 19:09:32','2022-07-25 19:09:32',40,'AC_PRODUCT_MODIFY','2022-07-25 19:09:32','2022-07-25 07:09:32',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AVENA_Granel modificado','Autor: admin\nProducto AVENA_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,186,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (50,50,NULL,1,'2022-07-25 19:09:48','2022-07-25 19:09:48',40,'AC_PRODUCT_MODIFY','2022-07-25 19:09:48','2022-07-25 07:09:48',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BARRA_DE_COCO_Granel modificado','Autor: admin\nProducto BARRA_DE_COCO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,197,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (51,51,NULL,1,'2022-07-25 20:08:02','2022-07-25 20:08:02',40,'AC_PRODUCT_MODIFY','2022-07-25 20:08:02','2022-07-25 08:08:02',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BISAGRA_SEVILLANO modificado','Autor: admin\nProducto BISAGRA_SEVILLANO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,218,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (52,52,NULL,1,'2022-07-25 20:08:55','2022-07-25 20:08:55',40,'AC_PRODUCT_MODIFY','2022-07-25 20:08:55','2022-07-25 08:08:55',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BISAGRA_SURTIDA modificado','Autor: admin\nProducto BISAGRA_SURTIDA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,216,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (53,53,NULL,1,'2022-07-25 20:09:17','2022-07-25 20:09:17',40,'AC_PRODUCT_MODIFY','2022-07-25 20:09:17','2022-07-25 08:09:17',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BISAGRA_SUSPIRO modificado','Autor: admin\nProducto BISAGRA_SUSPIRO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,217,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (54,54,NULL,1,'2022-07-25 20:09:56','2022-07-25 20:09:56',40,'AC_PRODUCT_MODIFY','2022-07-25 20:09:56','2022-07-25 08:09:56',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BOTANA_MIXTA modificado','Autor: admin\nProducto BOTANA_MIXTA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,225,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (55,55,NULL,1,'2022-07-25 20:10:35','2022-07-25 20:10:35',40,'AC_PRODUCT_MODIFY','2022-07-25 20:10:35','2022-07-25 08:10:35',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CACAHUATE_CASCARA modificado','Autor: admin\nProducto CACAHUATE_CASCARA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,224,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (56,56,NULL,1,'2022-07-25 20:11:00','2022-07-25 20:11:00',40,'AC_PRODUCT_MODIFY','2022-07-25 20:11:00','2022-07-25 08:11:00',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CACAHUATE_DE_FRESA_Granel modificado','Autor: admin\nProducto CACAHUATE_DE_FRESA_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,192,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (57,57,NULL,1,'2022-07-25 20:11:50','2022-07-25 20:11:50',40,'AC_PRODUCT_MODIFY','2022-07-25 20:11:50','2022-07-25 08:11:50',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CACAHUATE_JAPONES modificado','Autor: admin\nProducto CACAHUATE_JAPONES modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,226,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (58,58,NULL,1,'2022-07-25 20:12:56','2022-07-25 20:12:56',40,'AC_PRODUCT_MODIFY','2022-07-25 20:12:56','2022-07-25 08:12:56',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CHICHARRON_BOTANERO modificado','Autor: admin\nProducto CHICHARRON_BOTANERO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,221,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (59,59,NULL,1,'2022-07-25 20:13:14','2022-07-25 20:13:14',40,'AC_PRODUCT_MODIFY','2022-07-25 20:13:14','2022-07-25 08:13:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CHURRO_DE_MAIZ modificado','Autor: admin\nProducto CHURRO_DE_MAIZ modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,222,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (60,60,NULL,1,'2022-07-25 20:13:39','2022-07-25 20:13:39',40,'AC_PRODUCT_MODIFY','2022-07-25 20:13:39','2022-07-25 08:13:39',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto EMILIAS modificado','Autor: admin\nProducto EMILIAS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,204,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (61,61,NULL,1,'2022-07-25 20:14:04','2022-07-25 20:14:04',40,'AC_PRODUCT_MODIFY','2022-07-25 20:14:04','2022-07-25 08:14:04',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GALLETA_DE_ARANDANO_Granel modificado','Autor: admin\nProducto GALLETA_DE_ARANDANO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,201,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (62,62,NULL,1,'2022-07-25 20:14:43','2022-07-25 20:14:43',40,'AC_PRODUCT_MODIFY','2022-07-25 20:14:43','2022-07-25 08:14:43',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEA_500G modificado','Autor: admin\nProducto GRAGEA_500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,205,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (63,63,NULL,1,'2022-07-25 20:15:13','2022-07-25 20:15:13',40,'AC_PRODUCT_MODIFY','2022-07-25 20:15:13','2022-07-25 08:15:13',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEA_CHOCOLATE modificado','Autor: admin\nProducto GRAGEA_CHOCOLATE modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,207,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (64,64,NULL,1,'2022-07-25 20:15:26','2022-07-25 20:15:26',40,'AC_PRODUCT_MODIFY','2022-07-25 20:15:26','2022-07-25 08:15:26',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEA_DE_CHOCOLATE_ESTANDAR modificado','Autor: admin\nProducto GRAGEA_DE_CHOCOLATE_ESTANDAR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,262,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (65,65,NULL,1,'2022-07-25 20:16:56','2022-07-25 20:16:56',40,'AC_PRODUCT_MODIFY','2022-07-25 20:16:56','2022-07-25 08:16:56',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GTA_AJONJOLI_Y_LINAZA modificado','Autor: admin\nProducto GTA_AJONJOLI_Y_LINAZA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,208,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (66,66,NULL,1,'2022-07-25 20:17:20','2022-07-25 20:17:20',40,'AC_PRODUCT_MODIFY','2022-07-25 20:17:20','2022-07-25 08:17:20',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GTAS._DE_VAINILLA_FLOR_DE_CAYRO modificado','Autor: admin\nProducto GTAS._DE_VAINILLA_FLOR_DE_CAYRO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,212,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (67,67,NULL,1,'2022-07-25 20:17:59','2022-07-25 20:17:59',40,'AC_PRODUCT_MODIFY','2022-07-25 20:17:59','2022-07-25 08:17:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GTAS._DE_VAINILLA_FLOR_DE_CAYRO_Granel modificado','Autor: admin\nProducto GTAS._DE_VAINILLA_FLOR_DE_CAYRO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,190,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (68,68,NULL,1,'2022-07-25 20:18:19','2022-07-25 20:18:19',40,'AC_PRODUCT_MODIFY','2022-07-25 20:18:19','2022-07-25 08:18:19',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GTAS._MARMOLEADAS_AZUCARADAS modificado','Autor: admin\nProducto GTAS._MARMOLEADAS_AZUCARADAS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,210,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (69,69,NULL,1,'2022-07-25 20:18:40','2022-07-25 20:18:40',40,'AC_PRODUCT_MODIFY','2022-07-25 20:18:40','2022-07-25 08:18:40',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GTAS._MARMOLEADAS_AZUCARADAS_Granel modificado','Autor: admin\nProducto GTAS._MARMOLEADAS_AZUCARADAS_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,189,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (70,70,NULL,1,'2022-07-25 20:19:00','2022-07-25 20:19:00',40,'AC_PRODUCT_MODIFY','2022-07-25 20:19:00','2022-07-25 08:19:00',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEA_Granel modificado','Autor: admin\nProducto GRAGEA_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,187,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (71,71,NULL,1,'2022-07-25 20:19:21','2022-07-25 20:19:21',40,'AC_PRODUCT_MODIFY','2022-07-25 20:19:21','2022-07-25 08:19:21',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GTAS._NUEZ_CON_GLAS modificado','Autor: admin\nProducto GTAS._NUEZ_CON_GLAS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,211,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (72,72,NULL,1,'2022-07-25 20:19:35','2022-07-25 20:19:35',40,'AC_PRODUCT_MODIFY','2022-07-25 20:19:35','2022-07-25 08:19:35',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GTAS._NUEZ_CON_GLAS_Granel modificado','Autor: admin\nProducto GTAS._NUEZ_CON_GLAS_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,188,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (73,73,NULL,1,'2022-07-25 20:20:49','2022-07-25 20:20:49',40,'AC_PRODUCT_MODIFY','2022-07-25 20:20:49','2022-07-25 08:20:49',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GTAS._NUEZ_CON_GLAS_Granel modificado','Autor: admin\nProducto GTAS._NUEZ_CON_GLAS_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,188,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (74,74,NULL,1,'2022-07-25 20:21:14','2022-07-25 20:21:14',40,'AC_PRODUCT_MODIFY','2022-07-25 20:21:14','2022-07-25 08:21:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MINI_COCO_Granel modificado','Autor: admin\nProducto MINI_COCO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,195,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (75,75,NULL,1,'2022-07-25 20:21:52','2022-07-25 20:21:52',40,'AC_PRODUCT_MODIFY','2022-07-25 20:21:52','2022-07-25 08:21:52',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MINI_COCO modificado','Autor: admin\nProducto MINI_COCO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,206,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (76,76,NULL,1,'2022-07-25 20:23:11','2022-07-25 20:23:11',40,'AC_PRODUCT_MODIFY','2022-07-25 20:23:11','2022-07-25 08:23:11',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEA_CHOCOLATE_Granel modificado','Autor: admin\nProducto GRAGEA_CHOCOLATE_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,193,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (77,77,NULL,1,'2022-07-25 20:23:34','2022-07-25 20:23:34',40,'AC_PRODUCT_MODIFY','2022-07-25 20:23:34','2022-07-25 08:23:34',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto TARTA_FRESA modificado','Autor: admin\nProducto TARTA_FRESA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,230,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (78,78,NULL,1,'2022-07-25 20:23:44','2022-07-25 20:23:44',40,'AC_PRODUCT_MODIFY','2022-07-25 20:23:44','2022-07-25 08:23:44',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto TARTA_FRESA modificado','Autor: admin\nProducto TARTA_FRESA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,230,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (79,79,NULL,1,'2022-07-25 20:23:59','2022-07-25 20:23:59',40,'AC_PRODUCT_MODIFY','2022-07-25 20:23:59','2022-07-25 08:23:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto TARTA_PINA modificado','Autor: admin\nProducto TARTA_PINA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,229,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (80,80,NULL,1,'2022-07-25 20:24:43','2022-07-25 20:24:43',40,'AC_PRODUCT_MODIFY','2022-07-25 20:24:43','2022-07-25 08:24:43',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto SEVILLANO_Granel modificado','Autor: admin\nProducto SEVILLANO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,198,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (81,81,NULL,1,'2022-07-25 20:25:14','2022-07-25 20:25:14',40,'AC_PRODUCT_MODIFY','2022-07-25 20:25:14','2022-07-25 08:25:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto TIMBRE_DE_FRESA_Granel modificado','Autor: admin\nProducto TIMBRE_DE_FRESA_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,200,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (82,82,NULL,1,'2022-07-25 20:25:54','2022-07-25 20:25:54',40,'AC_PRODUCT_MODIFY','2022-07-25 20:25:54','2022-07-25 08:25:54',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto OREJAS_Granel modificado','Autor: admin\nProducto OREJAS_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,194,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (83,83,NULL,1,'2022-07-25 20:26:40','2022-07-25 20:26:40',40,'AC_PRODUCT_MODIFY','2022-07-25 20:26:40','2022-07-25 08:26:40',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BARRA_DE_COCO_Granel modificado','Autor: admin\nProducto BARRA_DE_COCO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,197,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (84,84,NULL,1,'2022-07-25 20:27:54','2022-07-25 20:27:54',40,'AC_PRODUCT_MODIFY','2022-07-25 20:27:54','2022-07-25 08:27:54',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto SUSPIRO_Granel modificado','Autor: admin\nProducto SUSPIRO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,191,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (85,85,NULL,1,'2022-07-25 20:29:05','2022-07-25 20:29:05',40,'AC_PRODUCT_MODIFY','2022-07-25 20:29:05','2022-07-25 08:29:05',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CACAHUATE_TOSTADO modificado','Autor: admin\nProducto CACAHUATE_TOSTADO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,227,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (86,86,NULL,1,'2022-07-25 21:20:47','2022-07-25 21:20:47',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-25 21:20:47','2022-07-25 09:20:47',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0005 validada','Autor: admin\nFactura SI2207-0005 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,9,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (87,87,NULL,1,'2022-07-25 21:24:55','2022-07-25 21:24:55',40,'AC_PRODUCT_CREATE','2022-07-25 21:24:55','2022-07-25 09:24:55',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto PROMO_1 creado','Autor: admin\nProducto PROMO_1 creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,285,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (88,88,NULL,1,'2022-07-25 21:25:58','2022-07-25 21:25:58',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-25 21:25:58','2022-07-25 09:25:58',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0006 validada','Autor: admin\nFactura SI2207-0006 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,10,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (89,89,NULL,1,'2022-07-25 22:10:28','2022-07-25 22:10:28',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-25 22:10:28','2022-07-25 10:10:28',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0007 validada','Autor: admin\nFactura SI2207-0007 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,11,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (90,90,NULL,1,'2022-07-25 22:18:49','2022-07-25 22:18:49',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-25 22:18:49','2022-07-25 10:18:49',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0008 validada','Autor: admin\nFactura SI2207-0008 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,12,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (91,91,NULL,1,'2022-07-25 22:43:00','2022-07-25 22:43:00',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-25 22:43:00','2022-07-25 10:43:00',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0009 validada','Autor: admin\nFactura SI2207-0009 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (92,92,NULL,1,'2022-07-25 23:03:48','2022-07-25 23:03:48',40,'AC_PRODUCT_MODIFY','2022-07-25 23:03:48','2022-07-25 11:03:48',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AVENA_500g modificado','Autor: admin\nProducto AVENA_500g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,203,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (93,93,NULL,1,'2022-07-25 23:03:57','2022-07-25 23:03:57',40,'AC_PRODUCT_MODIFY','2022-07-25 23:03:57','2022-07-25 11:03:57',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AVENA_500g modificado','Autor: admin\nProducto AVENA_500g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,203,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (94,94,NULL,1,'2022-07-25 23:05:59','2022-07-25 23:05:59',40,'AC_PRODUCT_MODIFY','2022-07-25 23:05:59','2022-07-25 11:05:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AVENA_500g modificado','Autor: admin\nProducto AVENA_500g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,203,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (95,95,NULL,1,'2022-07-25 23:06:14','2022-07-25 23:06:14',40,'AC_PRODUCT_MODIFY','2022-07-25 23:06:14','2022-07-25 11:06:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AVENA_500g modificado','Autor: admin\nProducto AVENA_500g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,203,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (96,96,NULL,1,'2022-07-25 23:07:23','2022-07-25 23:07:23',40,'AC_PRODUCT_MODIFY','2022-07-25 23:07:23','2022-07-25 11:07:23',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AVENA_500g modificado','Autor: admin\nProducto AVENA_500g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,203,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (97,97,NULL,1,'2022-07-25 23:10:03','2022-07-25 23:10:03',40,'AC_PRODUCT_MODIFY','2022-07-25 23:10:03','2022-07-25 11:10:03',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AVENA_500g modificado','Autor: admin\nProducto AVENA_500g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,203,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (98,98,NULL,1,'2022-07-25 23:11:48','2022-07-25 23:11:48',40,'AC_PRODUCT_MODIFY','2022-07-25 23:11:48','2022-07-25 11:11:48',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AVENA_500g modificado','Autor: admin\nProducto AVENA_500g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,203,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (99,99,NULL,1,'2022-07-25 23:13:01','2022-07-25 23:13:01',40,'AC_PRODUCT_MODIFY','2022-07-25 23:13:01','2022-07-25 11:13:01',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AVENA_500g modificado','Autor: admin\nProducto AVENA_500g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,203,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (100,100,NULL,1,'2022-07-25 23:15:38','2022-07-25 23:15:38',40,'AC_PRODUCT_MODIFY','2022-07-25 23:15:38','2022-07-25 11:15:38',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AVENA_100G modificado','Autor: admin\nProducto AVENA_100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,219,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (101,101,NULL,1,'2022-07-25 23:16:57','2022-07-25 23:16:57',40,'AC_PRODUCT_MODIFY','2022-07-25 23:16:57','2022-07-25 11:16:57',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AVENA_GRANEL modificado','Autor: admin\nProducto AVENA_GRANEL modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,186,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (102,102,NULL,1,'2022-07-25 23:20:09','2022-07-25 23:20:09',40,'AC_PRODUCT_MODIFY','2022-07-25 23:20:09','2022-07-25 11:20:09',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AVENA_GRANEL modificado','Autor: admin\nProducto AVENA_GRANEL modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,186,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (103,103,NULL,1,'2022-07-25 23:21:55','2022-07-25 23:21:55',40,'AC_PRODUCT_MODIFY','2022-07-25 23:21:55','2022-07-25 11:21:55',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BARRAS_DE_COCO modificado','Autor: admin\nProducto BARRAS_DE_COCO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,214,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (104,104,NULL,1,'2022-07-25 23:23:15','2022-07-25 23:23:15',40,'AC_PRODUCT_MODIFY','2022-07-25 23:23:15','2022-07-25 11:23:15',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BARRA_DE_COCO_Granel modificado','Autor: admin\nProducto BARRA_DE_COCO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,197,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (105,105,NULL,1,'2022-07-25 23:25:09','2022-07-25 23:25:09',40,'AC_PRODUCT_MODIFY','2022-07-25 23:25:09','2022-07-25 11:25:09',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BARRA_DE_COCO_400g modificado','Autor: admin\nProducto BARRA_DE_COCO_400g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,214,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (106,106,NULL,1,'2022-07-25 23:26:08','2022-07-25 23:26:08',40,'AC_PRODUCT_MODIFY','2022-07-25 23:26:08','2022-07-25 11:26:08',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEA_100G modificado','Autor: admin\nProducto GRAGEA_100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,279,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (107,107,NULL,1,'2022-07-25 23:26:35','2022-07-25 23:26:35',40,'AC_PRODUCT_MODIFY','2022-07-25 23:26:35','2022-07-25 11:26:35',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEA_400G modificado','Autor: admin\nProducto GRAGEA_400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,280,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (108,108,NULL,1,'2022-07-25 23:28:27','2022-07-25 23:28:27',40,'AC_PRODUCT_MODIFY','2022-07-25 23:28:27','2022-07-25 11:28:27',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEA_500G modificado','Autor: admin\nProducto GRAGEA_500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,205,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (109,109,NULL,1,'2022-07-25 23:56:10','2022-07-25 23:56:10',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-25 23:56:10','2022-07-25 11:56:10',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0010 validada','Autor: admin\nFactura SI2207-0010 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,14,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (110,110,NULL,1,'2022-07-26 00:01:19','2022-07-26 00:01:19',40,'AC_BILL_VALIDATE','2022-07-26 00:01:19','2022-07-25 12:01:19',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2207-0002 validada','Autor: admin\nFactura FA2207-0002 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,2,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (111,111,NULL,1,'2022-07-26 17:29:16','2022-07-26 17:29:16',40,'AC_BILL_VALIDATE','2022-07-26 17:29:16','2022-07-26 05:29:16',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2207-0003 validada','Autor: admin\nFactura FA2207-0003 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,3,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (112,112,NULL,1,'2022-07-26 17:29:28','2022-07-26 17:29:28',40,'AC_BILL_PAYED','2022-07-26 17:29:28','2022-07-26 05:29:28',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2207-0003 pasada a pagada','Autor: admin\nFactura FA2207-0003 pasada a pagada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,3,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (113,113,NULL,1,'2022-07-26 17:30:57','2022-07-26 17:30:57',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-26 17:30:57','2022-07-26 05:30:57',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0011 validada','Autor: admin\nFactura SI2207-0011 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,15,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (114,114,NULL,1,'2022-07-26 17:54:24','2022-07-26 17:54:24',40,'AC_BILL_UNVALIDATE','2022-07-26 17:54:24','2022-07-26 05:54:24',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura FA2207-0002 al estado de borrador','Autor: admin\nRegresar factura FA2207-0002 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,2,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (115,115,NULL,1,'2022-07-26 17:54:35','2022-07-26 17:54:35',40,'AC_BILL_VALIDATE','2022-07-26 17:54:35','2022-07-26 05:54:35',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2207-0002 validada','Autor: admin\nFactura FA2207-0002 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,2,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (116,116,NULL,1,'2022-07-26 17:58:59','2022-07-26 17:58:59',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-26 17:58:59','2022-07-26 05:58:59',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0012 validada','Autor: admin\nFactura SI2207-0012 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,17,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (117,117,NULL,1,'2022-07-26 18:18:32','2022-07-26 18:18:32',40,'AC_BILL_VALIDATE','2022-07-26 18:18:32','2022-07-26 06:18:32',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2207-0004 validada','Autor: admin\nFactura FA2207-0004 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,4,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (118,118,NULL,1,'2022-07-26 20:35:50','2022-07-26 20:35:50',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-26 20:35:50','2022-07-26 08:35:50',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0013 validada','Autor: admin\nFactura SI2207-0013 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,18,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (119,119,NULL,1,'2022-07-26 20:38:03','2022-07-26 20:38:03',40,'AC_BILL_SUPPLIER_DELETE','2022-07-26 20:38:03','2022-07-26 08:38:03',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura de proveedor eliminada','Autor: admin\nFactura de proveedor eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,18,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (120,120,NULL,1,'2022-07-26 20:39:11','2022-07-26 20:39:11',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-26 20:39:11','2022-07-26 08:39:11',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0013 validada','Autor: admin\nFactura SI2207-0013 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,19,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (121,121,NULL,1,'2022-07-26 20:56:57','2022-07-26 20:56:57',40,'AC_BILL_SUPPLIER_DELETE','2022-07-26 20:56:57','2022-07-26 08:56:57',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura de proveedor eliminada','Autor: admin\nFactura de proveedor eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,19,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (122,122,NULL,1,'2022-07-26 22:20:09','2022-07-26 22:20:09',40,'AC_BILL_VALIDATE','2022-07-26 22:20:09','2022-07-26 10:20:09',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2207-0005 validada','Autor: admin\nFactura FA2207-0005 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,5,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (123,123,NULL,1,'2022-07-26 22:20:23','2022-07-26 22:20:23',40,'AC_BILL_SUPPLIER_DELETE','2022-07-26 22:20:23','2022-07-26 10:20:23',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura de proveedor eliminada','Autor: admin\nFactura de proveedor eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,20,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (124,124,NULL,1,'2022-07-26 22:21:25','2022-07-26 22:21:25',40,'AC_PRODUCT_CREATE','2022-07-26 22:21:25','2022-07-26 10:21:25',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto PROMO_2 creado','Autor: admin\nProducto PROMO_2 creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,286,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (125,125,NULL,1,'2022-07-26 22:23:03','2022-07-26 22:23:03',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-26 22:23:03','2022-07-26 10:23:03',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0013 validada','Autor: admin\nFactura SI2207-0013 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,21,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (126,126,NULL,1,'2022-07-26 22:50:39','2022-07-26 22:50:39',40,'AC_PRODUCT_MODIFY','2022-07-26 22:50:39','2022-07-26 10:50:39',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AVENA_100G modificado','Autor: admin\nProducto AVENA_100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,219,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (127,127,NULL,1,'2022-07-26 22:51:12','2022-07-26 22:51:12',40,'AC_PRODUCT_MODIFY','2022-07-26 22:51:12','2022-07-26 10:51:12',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AVENA_500g modificado','Autor: admin\nProducto AVENA_500g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,203,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (128,128,NULL,1,'2022-07-26 22:51:33','2022-07-26 22:51:33',40,'AC_PRODUCT_MODIFY','2022-07-26 22:51:33','2022-07-26 10:51:33',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AVENA_GRANEL modificado','Autor: admin\nProducto AVENA_GRANEL modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,186,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (129,129,NULL,1,'2022-07-26 22:51:53','2022-07-26 22:51:53',40,'AC_PRODUCT_MODIFY','2022-07-26 22:51:53','2022-07-26 10:51:53',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto EMILIAS modificado','Autor: admin\nProducto EMILIAS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,204,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (130,130,NULL,1,'2022-07-26 22:52:03','2022-07-26 22:52:03',40,'AC_PRODUCT_MODIFY','2022-07-26 22:52:03','2022-07-26 10:52:03',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto EMILIAS modificado','Autor: admin\nProducto EMILIAS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,204,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (131,131,NULL,1,'2022-07-26 22:52:47','2022-07-26 22:52:47',40,'AC_PRODUCT_MODIFY','2022-07-26 22:52:47','2022-07-26 10:52:47',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AVENA_Y_ARANDANO modificado','Autor: admin\nProducto AVENA_Y_ARANDANO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,209,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (132,132,NULL,1,'2022-07-26 22:53:12','2022-07-26 22:53:12',40,'AC_PRODUCT_MODIFY','2022-07-26 22:53:12','2022-07-26 10:53:12',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEA_100G modificado','Autor: admin\nProducto GRAGEA_100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,279,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (133,133,NULL,1,'2022-07-26 22:54:41','2022-07-26 22:54:41',40,'AC_PRODUCT_MODIFY','2022-07-26 22:54:41','2022-07-26 10:54:41',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEA_CHOCOLATE_Granel modificado','Autor: admin\nProducto GRAGEA_CHOCOLATE_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,193,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (134,134,NULL,1,'2022-07-26 22:55:23','2022-07-26 22:55:23',40,'AC_PRODUCT_MODIFY','2022-07-26 22:55:23','2022-07-26 10:55:23',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BARRA_DE_COCO_400g modificado','Autor: admin\nProducto BARRA_DE_COCO_400g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,214,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (135,135,NULL,1,'2022-07-26 22:56:09','2022-07-26 22:56:09',40,'AC_PRODUCT_MODIFY','2022-07-26 22:56:09','2022-07-26 10:56:09',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BISAGRA_SEVILLANO modificado','Autor: admin\nProducto BISAGRA_SEVILLANO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,218,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (136,136,NULL,1,'2022-07-26 22:56:33','2022-07-26 22:56:33',40,'AC_PRODUCT_MODIFY','2022-07-26 22:56:33','2022-07-26 10:56:33',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEA_CHOCOLATE modificado','Autor: admin\nProducto GRAGEA_CHOCOLATE modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,207,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (137,137,NULL,1,'2022-07-26 22:57:11','2022-07-26 22:57:11',40,'AC_PRODUCT_MODIFY','2022-07-26 22:57:11','2022-07-26 10:57:11',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BARRA_DE_COCO_Granel modificado','Autor: admin\nProducto BARRA_DE_COCO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,197,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (138,138,NULL,1,'2022-07-26 22:58:12','2022-07-26 22:58:12',40,'AC_PRODUCT_MODIFY','2022-07-26 22:58:12','2022-07-26 10:58:12',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEA_Granel modificado','Autor: admin\nProducto GRAGEA_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,187,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (139,139,NULL,1,'2022-07-26 22:58:53','2022-07-26 22:58:53',40,'AC_PRODUCT_MODIFY','2022-07-26 22:58:53','2022-07-26 10:58:54',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto FLOR_DE_CAYRO modificado','Autor: admin\nProducto FLOR_DE_CAYRO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,212,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (140,140,NULL,1,'2022-07-26 22:59:33','2022-07-26 22:59:33',40,'AC_PRODUCT_MODIFY','2022-07-26 22:59:33','2022-07-26 10:59:33',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto VAINILLA_FLOR_DE_CAYRO_Granel modificado','Autor: admin\nProducto VAINILLA_FLOR_DE_CAYRO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,190,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (141,141,NULL,1,'2022-07-26 23:00:03','2022-07-26 23:00:03',40,'AC_PRODUCT_MODIFY','2022-07-26 23:00:03','2022-07-26 11:00:03',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MARMOLEADAS_AZUCARADAS modificado','Autor: admin\nProducto MARMOLEADAS_AZUCARADAS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,210,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (142,142,NULL,1,'2022-07-26 23:00:42','2022-07-26 23:00:42',40,'AC_PRODUCT_MODIFY','2022-07-26 23:00:42','2022-07-26 11:00:42',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MARMOLEADAS_AZUCARADAS_Granel modificado','Autor: admin\nProducto MARMOLEADAS_AZUCARADAS_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,189,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (143,143,NULL,1,'2022-07-26 23:05:18','2022-07-26 23:05:18',40,'AC_PRODUCT_MODIFY','2022-07-26 23:05:18','2022-07-26 11:05:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEAGRANEL modificado','Autor: admin\nProducto GRAGEAGRANEL modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,187,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (144,144,NULL,1,'2022-07-26 23:08:38','2022-07-26 23:08:38',40,'AC_PRODUCT_MODIFY','2022-07-26 23:08:38','2022-07-26 11:08:38',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BP modificado','Autor: admin\nProducto BP modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,207,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (145,145,NULL,1,'2022-07-26 23:26:11','2022-07-26 23:26:11',40,'AC_BILL_VALIDATE','2022-07-26 23:26:11','2022-07-26 11:26:11',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2207-0006 validada','Autor: admin\nFactura FA2207-0006 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,6,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (146,146,NULL,1,'2022-07-26 23:29:54','2022-07-26 23:29:54',40,'AC_BILL_VALIDATE','2022-07-26 23:29:54','2022-07-26 11:29:54',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2207-0007 validada','Autor: admin\nFactura FA2207-0007 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,7,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (147,147,NULL,1,'2022-07-26 23:50:28','2022-07-26 23:50:28',40,'AC_PRODUCT_MODIFY','2022-07-26 23:50:28','2022-07-26 11:50:28',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEA_400G modificado','Autor: admin\nProducto GRAGEA_400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,280,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (148,148,NULL,1,'2022-07-27 01:27:44','2022-07-27 01:27:44',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-27 01:27:44','2022-07-26 13:27:44',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0014 validada','Autor: admin\nFactura SI2207-0014 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,22,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (149,149,NULL,1,'2022-07-27 01:51:38','2022-07-27 01:51:38',40,'AC_BILL_VALIDATE','2022-07-27 01:51:38','2022-07-26 13:51:38',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2207-0008 validada','Autor: admin\nFactura FA2207-0008 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,8,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (150,150,NULL,1,'2022-07-27 02:01:01','2022-07-27 02:01:01',40,'AC_BILL_VALIDATE','2022-07-27 02:01:02','2022-07-26 14:01:02',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2207-0009 validada','Autor: admin\nFactura FA2207-0009 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,9,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (151,151,NULL,1,'2022-07-27 02:01:08','2022-07-27 02:01:08',40,'AC_BILL_DELETE','2022-07-27 02:01:08','2022-07-26 14:01:08',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura eliminada','Autor: admin\nFactura eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,9,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (152,152,NULL,1,'2022-07-27 03:01:22','2022-07-27 03:01:22',40,'AC_PRODUCT_CREATE','2022-07-27 03:01:22','2022-07-26 15:01:22',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBBOBGRA500 creado','Autor: admin\nProducto CBBOBGRA500 creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,287,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (153,153,NULL,1,'2022-07-27 03:02:04','2022-07-27 03:02:04',40,'AC_PRODUCT_CREATE','2022-07-27 03:02:04','2022-07-26 15:02:04',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJA4GRAGEA creado','Autor: admin\nProducto CBCAJA4GRAGEA creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,288,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (154,154,NULL,1,'2022-07-27 03:02:23','2022-07-27 03:02:23',40,'AC_PRODUCT_MODIFY','2022-07-27 03:02:23','2022-07-26 15:02:23',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJA4GRAGEA modificado','Autor: admin\nProducto CBCAJA4GRAGEA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,288,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (155,155,NULL,1,'2022-07-27 03:07:59','2022-07-27 03:07:59',40,'AC_PRODUCT_MODIFY','2022-07-27 03:07:59','2022-07-26 15:07:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJA4GRAGEA modificado','Autor: admin\nProducto CBCAJA4GRAGEA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,288,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (156,156,NULL,1,'2022-07-27 03:09:34','2022-07-27 03:09:34',40,'AC_PRODUCT_MODIFY','2022-07-27 03:09:34','2022-07-26 15:09:34',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBBOBGRA500 modificado','Autor: admin\nProducto CBBOBGRA500 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,287,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (157,157,NULL,1,'2022-07-27 03:12:28','2022-07-27 03:12:28',40,'AC_PRODUCT_MODIFY','2022-07-27 03:12:28','2022-07-26 15:12:28',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJA4GRAGEA modificado','Autor: admin\nProducto CBCAJA4GRAGEA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,288,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (158,158,NULL,1,'2022-07-27 03:13:20','2022-07-27 03:13:20',40,'AC_PRODUCT_CREATE','2022-07-27 03:13:20','2022-07-26 15:13:20',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJA6GRAGEA creado','Autor: admin\nProducto CBCAJA6GRAGEA creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,289,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (159,159,NULL,1,'2022-07-27 03:15:07','2022-07-27 03:15:07',40,'AC_PRODUCT_CREATE','2022-07-27 03:15:07','2022-07-26 15:15:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAAVECONARA350GRS creado','Autor: admin\nProducto CBCAJAAVECONARA350GRS creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,290,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (160,160,NULL,1,'2022-07-27 03:15:29','2022-07-27 03:15:29',40,'AC_PRODUCT_CREATE','2022-07-27 03:15:29','2022-07-26 15:15:29',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAAVENA100GRS creado','Autor: admin\nProducto CBCAJAAVENA100GRS creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,291,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (161,161,NULL,1,'2022-07-27 03:15:51','2022-07-27 03:15:51',40,'AC_PRODUCT_CREATE','2022-07-27 03:15:51','2022-07-26 15:15:51',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAAVENA500GRS creado','Autor: admin\nProducto CBCAJAAVENA500GRS creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,292,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (162,162,NULL,1,'2022-07-27 03:16:17','2022-07-27 03:16:17',40,'AC_PRODUCT_CREATE','2022-07-27 03:16:17','2022-07-26 15:16:17',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJABARRASDECOCO400GRS creado','Autor: admin\nProducto CBCAJABARRASDECOCO400GRS creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,293,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (163,163,NULL,1,'2022-07-27 03:16:36','2022-07-27 03:16:36',40,'AC_PRODUCT_CREATE','2022-07-27 03:16:36','2022-07-26 15:16:36',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAGRAGEA100GRS creado','Autor: admin\nProducto CBCAJAGRAGEA100GRS creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,294,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (164,164,NULL,1,'2022-07-27 03:16:56','2022-07-27 03:16:56',40,'AC_PRODUCT_CREATE','2022-07-27 03:16:56','2022-07-26 15:16:56',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAGRAGEA500GRS creado','Autor: admin\nProducto CBCAJAGRAGEA500GRS creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,295,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (165,165,NULL,1,'2022-07-27 03:17:15','2022-07-27 03:17:15',40,'AC_PRODUCT_CREATE','2022-07-27 03:17:15','2022-07-26 15:17:15',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJALINAZA400GRS creado','Autor: admin\nProducto CBCAJALINAZA400GRS creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,296,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (166,166,NULL,1,'2022-07-27 03:17:35','2022-07-27 03:17:35',40,'AC_PRODUCT_CREATE','2022-07-27 03:17:35','2022-07-26 15:17:35',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJALISA4KG creado','Autor: admin\nProducto CBCAJALISA4KG creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,297,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (167,167,NULL,1,'2022-07-27 03:18:11','2022-07-27 03:18:11',40,'AC_PRODUCT_CREATE','2022-07-27 03:18:11','2022-07-26 15:18:11',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJALISA8KG creado','Autor: admin\nProducto CBCAJALISA8KG creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,298,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (168,168,NULL,1,'2022-07-27 03:18:29','2022-07-27 03:18:29',40,'AC_PRODUCT_CREATE','2022-07-27 03:18:29','2022-07-26 15:18:29',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJALOGO creado','Autor: admin\nProducto CBCAJALOGO creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,299,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (169,169,NULL,1,'2022-07-27 03:19:02','2022-07-27 03:19:02',40,'AC_PRODUCT_CREATE','2022-07-27 03:19:02','2022-07-26 15:19:02',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJALOGOGRAL creado','Autor: admin\nProducto CBCAJALOGOGRAL creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,300,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (170,170,NULL,1,'2022-07-27 03:19:19','2022-07-27 03:19:19',40,'AC_PRODUCT_CREATE','2022-07-27 03:19:19','2022-07-26 15:19:19',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAMINICOCO500GRS creado','Autor: admin\nProducto CBCAJAMINICOCO500GRS creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,301,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (171,171,NULL,1,'2022-07-27 03:19:38','2022-07-27 03:19:38',40,'AC_PRODUCT_CREATE','2022-07-27 03:19:38','2022-07-26 15:19:38',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAMINIPIZCA creado','Autor: admin\nProducto CBCAJAMINIPIZCA creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,302,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (172,172,NULL,1,'2022-07-27 03:20:00','2022-07-27 03:20:00',40,'AC_PRODUCT_CREATE','2022-07-27 03:20:00','2022-07-26 15:20:00',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAMOLIENDA100GRS creado','Autor: admin\nProducto CBCAJAMOLIENDA100GRS creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,303,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (173,173,NULL,1,'2022-07-27 03:23:09','2022-07-27 03:23:09',40,'AC_PRODUCT_CREATE','2022-07-27 03:23:09','2022-07-26 15:23:09',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAMOLIENDALB creado','Autor: admin\nProducto CBCAJAMOLIENDALB creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,304,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (174,174,NULL,1,'2022-07-27 03:23:31','2022-07-27 03:23:31',40,'AC_PRODUCT_CREATE','2022-07-27 03:23:31','2022-07-26 15:23:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAOREJAS200GRS creado','Autor: admin\nProducto CBCAJAOREJAS200GRS creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,305,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (175,175,NULL,1,'2022-07-27 03:23:57','2022-07-27 03:23:57',40,'AC_PRODUCT_CREATE','2022-07-27 03:23:57','2022-07-26 15:23:57',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAVAINILLAFLOR336GRS creado','Autor: admin\nProducto CBCAJAVAINILLAFLOR336GRS creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,306,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (176,176,NULL,1,'2022-07-27 03:25:54','2022-07-27 03:25:54',40,'AC_PRODUCT_CREATE','2022-07-27 03:25:54','2022-07-26 15:25:54',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBISFLOR creado','Autor: admin\nProducto CBISFLOR creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,307,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (177,177,NULL,1,'2022-07-27 03:26:42','2022-07-27 03:26:42',40,'AC_PRODUCT_CREATE','2022-07-27 03:26:42','2022-07-26 15:26:42',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBISSURT creado','Autor: admin\nProducto CBISSURT creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,308,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (178,178,NULL,1,'2022-07-27 03:27:45','2022-07-27 03:27:45',40,'AC_PRODUCT_CREATE','2022-07-27 03:27:45','2022-07-26 15:27:45',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBISSUSYSEV creado','Autor: admin\nProducto CBISSUSYSEV creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,309,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (179,179,NULL,1,'2022-07-27 03:28:54','2022-07-27 03:28:54',40,'AC_PRODUCT_CREATE','2022-07-27 03:28:54','2022-07-26 15:28:54',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBOL7090 creado','Autor: admin\nProducto CBOL7090 creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,310,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (180,180,NULL,1,'2022-07-27 03:29:26','2022-07-27 03:29:26',40,'AC_PRODUCT_CREATE','2022-07-27 03:29:26','2022-07-26 15:29:26',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPAVE100 creado','Autor: admin\nProducto CBPAVE100 creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,311,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (181,181,NULL,1,'2022-07-27 03:29:48','2022-07-27 03:29:48',40,'AC_PRODUCT_CREATE','2022-07-27 03:29:48','2022-07-26 15:29:48',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPEMILIAS creado','Autor: admin\nProducto CBPEMILIAS creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,312,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (182,182,NULL,1,'2022-07-27 03:30:14','2022-07-27 03:30:14',40,'AC_PRODUCT_CREATE','2022-07-27 03:30:14','2022-07-26 15:30:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGAAVE creado','Autor: admin\nProducto CBPGAAVE creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,313,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (183,183,NULL,1,'2022-07-27 03:30:48','2022-07-27 03:30:48',40,'AC_PRODUCT_CREATE','2022-07-27 03:30:48','2022-07-26 15:30:48',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGABACO creado','Autor: admin\nProducto CBPGABACO creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,314,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (184,184,NULL,1,'2022-07-27 03:31:19','2022-07-27 03:31:19',40,'AC_PRODUCT_CREATE','2022-07-27 03:31:19','2022-07-26 15:31:19',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGACGRA creado','Autor: admin\nProducto CBPGACGRA creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,315,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (185,185,NULL,1,'2022-07-27 03:32:05','2022-07-27 03:32:05',40,'AC_PRODUCT_CREATE','2022-07-27 03:32:05','2022-07-26 15:32:05',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGACGRA400G creado','Autor: admin\nProducto CBPGACGRA400G creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,316,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (186,186,NULL,1,'2022-07-27 03:32:43','2022-07-27 03:32:43',40,'AC_PRODUCT_CREATE','2022-07-27 03:32:43','2022-07-26 15:32:43',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGACLINYAJON creado','Autor: admin\nProducto CBPGACLINYAJON creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,317,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (187,187,NULL,1,'2022-07-27 03:33:07','2022-07-27 03:33:07',40,'AC_PRODUCT_CREATE','2022-07-27 03:33:07','2022-07-26 15:33:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGADAVE creado','Autor: admin\nProducto CBPGADAVE creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,318,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (188,188,NULL,1,'2022-07-27 03:33:45','2022-07-27 03:33:45',40,'AC_PRODUCT_CREATE','2022-07-27 03:33:45','2022-07-26 15:33:45',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGADCO creado','Autor: admin\nProducto CBPGADCO creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,319,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (189,189,NULL,1,'2022-07-27 03:34:11','2022-07-27 03:34:11',40,'AC_PRODUCT_CREATE','2022-07-27 03:34:11','2022-07-26 15:34:11',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGAFLO creado','Autor: admin\nProducto CBPGAFLO creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,320,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (190,190,NULL,1,'2022-07-27 03:34:47','2022-07-27 03:34:47',40,'AC_PRODUCT_CREATE','2022-07-27 03:34:47','2022-07-26 15:34:47',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGAGRACH creado','Autor: admin\nProducto CBPGAGRACH creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,321,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (191,191,NULL,1,'2022-07-27 03:35:14','2022-07-27 03:35:14',40,'AC_PRODUCT_CREATE','2022-07-27 03:35:14','2022-07-26 15:35:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGAMARM creado','Autor: admin\nProducto CBPGAMARM creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,322,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (192,192,NULL,1,'2022-07-27 03:35:37','2022-07-27 03:35:37',40,'AC_PRODUCT_CREATE','2022-07-27 03:35:37','2022-07-26 15:35:37',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGAMINC creado','Autor: admin\nProducto CBPGAMINC creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,323,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (193,193,NULL,1,'2022-07-27 03:36:30','2022-07-27 03:36:30',40,'AC_PRODUCT_CREATE','2022-07-27 03:36:30','2022-07-26 15:36:30',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGAMINIPIZCA creado','Autor: admin\nProducto CBPGAMINIPIZCA creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,324,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (194,194,NULL,1,'2022-07-27 03:37:05','2022-07-27 03:37:05',40,'AC_PRODUCT_CREATE','2022-07-27 03:37:05','2022-07-26 15:37:05',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGANUEZ creado','Autor: admin\nProducto CBPGANUEZ creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,325,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (195,195,NULL,1,'2022-07-27 03:37:30','2022-07-27 03:37:30',40,'AC_PRODUCT_CREATE','2022-07-27 03:37:30','2022-07-26 15:37:30',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGAORE creado','Autor: admin\nProducto CBPGAORE creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,326,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (196,196,NULL,1,'2022-07-27 03:38:14','2022-07-27 03:38:14',40,'AC_PRODUCT_CREATE','2022-07-27 03:38:14','2022-07-26 15:38:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGAPIZCH creado','Autor: admin\nProducto CBPGAPIZCH creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,327,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (197,197,NULL,1,'2022-07-27 03:38:38','2022-07-27 03:38:38',40,'AC_PRODUCT_CREATE','2022-07-27 03:38:38','2022-07-26 15:38:38',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGRA100 creado','Autor: admin\nProducto CBPGRA100 creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,328,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (198,198,NULL,1,'2022-07-27 03:39:04','2022-07-27 03:39:04',40,'AC_PRODUCT_CREATE','2022-07-27 03:39:04','2022-07-26 15:39:04',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CCAFEJAGRAGEA100GRS creado','Autor: admin\nProducto CCAFEJAGRAGEA100GRS creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,329,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (199,199,NULL,1,'2022-07-27 03:39:28','2022-07-27 03:39:28',40,'AC_PRODUCT_CREATE','2022-07-27 03:39:28','2022-07-26 15:39:28',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CCINTA001 creado','Autor: admin\nProducto CCINTA001 creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,330,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (200,200,NULL,1,'2022-07-27 03:39:53','2022-07-27 03:39:53',40,'AC_PRODUCT_CREATE','2022-07-27 03:39:53','2022-07-26 15:39:53',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CCINTA002 creado','Autor: admin\nProducto CCINTA002 creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,331,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (201,201,NULL,1,'2022-07-27 03:40:11','2022-07-27 03:40:11',40,'AC_PRODUCT_CREATE','2022-07-27 03:40:11','2022-07-26 15:40:11',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CETIEMI creado','Autor: admin\nProducto CETIEMI creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,332,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (202,202,NULL,1,'2022-07-27 03:40:20','2022-07-27 03:40:20',40,'AC_PRODUCT_MODIFY','2022-07-27 03:40:20','2022-07-26 15:40:20',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CETIEMI modificado','Autor: admin\nProducto CETIEMI modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,332,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (203,203,NULL,1,'2022-07-27 03:40:49','2022-07-27 03:40:49',40,'AC_PRODUCT_CREATE','2022-07-27 03:40:49','2022-07-26 15:40:49',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CETIFLE creado','Autor: admin\nProducto CETIFLE creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,333,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (204,204,NULL,1,'2022-07-27 03:41:14','2022-07-27 03:41:14',40,'AC_PRODUCT_CREATE','2022-07-27 03:41:14','2022-07-26 15:41:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CETISUR creado','Autor: admin\nProducto CETISUR creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,334,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (205,205,NULL,1,'2022-07-27 04:03:04','2022-07-27 04:03:04',40,'AC_PRODUCT_CREATE','2022-07-27 04:03:04','2022-07-26 16:03:04',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Prueba creado','Autor: admin\nProducto Prueba creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,335,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (206,206,NULL,1,'2022-07-27 15:54:22','2022-07-27 15:54:22',40,'AC_BILL_VALIDATE','2022-07-27 15:54:22','2022-07-27 03:54:22',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2207-0009 validada','Autor: admin\nFactura FA2207-0009 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,10,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (207,207,NULL,1,'2022-07-27 17:47:05','2022-07-27 17:47:05',40,'AC_PRODUCT_MODIFY','2022-07-27 17:47:05','2022-07-27 05:47:05',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJA4GRAGEA modificado','Autor: admin\nProducto CBCAJA4GRAGEA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,288,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (208,208,NULL,1,'2022-07-27 19:17:50','2022-07-27 19:17:50',40,'AC_ORDER_VALIDATE','2022-07-27 19:17:50','2022-07-27 07:17:50',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2207-0002 validada','Autor: admin\nOrden CO2207-0002 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,3,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (209,209,NULL,1,'2022-07-27 22:59:15','2022-07-27 22:59:15',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-27 22:59:15','2022-07-27 10:59:15',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0015 validada','Autor: admin\nFactura SI2207-0015 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,23,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (210,210,NULL,1,'2022-07-27 23:05:30','2022-07-27 23:05:30',40,'AC_ORDER_VALIDATE','2022-07-27 23:05:30','2022-07-27 11:05:30',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2207-0003 validada','Autor: admin\nOrden CO2207-0003 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,4,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (211,211,NULL,1,'2022-07-28 01:46:30','2022-07-28 01:46:30',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-28 01:46:30','2022-07-27 13:46:30',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0016 validada','Autor: admin\nFactura SI2207-0016 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,24,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (212,212,NULL,1,'2022-07-28 02:04:23','2022-07-28 02:04:23',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-28 02:04:23','2022-07-27 14:04:23',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0017 validada','Autor: admin\nFactura SI2207-0017 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,25,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (213,213,NULL,1,'2022-07-28 02:22:54','2022-07-28 02:22:54',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-28 02:22:54','2022-07-27 14:22:54',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0018 validada','Autor: admin\nFactura SI2207-0018 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,26,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (214,214,NULL,1,'2022-07-28 17:43:15','2022-07-28 17:43:15',40,'AC_PRODUCT_MODIFY','2022-07-28 17:43:15','2022-07-28 05:43:15',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR100G modificado','Autor: admin\nProducto BPGR100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,279,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (215,215,NULL,1,'2022-07-28 17:50:32','2022-07-28 17:50:32',40,'AC_PRODUCT_MODIFY','2022-07-28 17:50:32','2022-07-28 05:50:32',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPARROZ500G modificado','Autor: admin\nProducto BPARROZ500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,281,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (216,216,NULL,1,'2022-07-28 17:51:08','2022-07-28 17:51:08',40,'AC_PRODUCT_MODIFY','2022-07-28 17:51:08','2022-07-28 05:51:08',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPARROZ900G modificado','Autor: admin\nProducto BPARROZ900G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,282,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (217,217,NULL,1,'2022-07-28 17:52:35','2022-07-28 17:52:35',40,'AC_PRODUCT_MODIFY','2022-07-28 17:52:35','2022-07-28 05:52:35',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BISUR700G modificado','Autor: admin\nProducto BISUR700G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,216,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (218,218,NULL,1,'2022-07-28 17:53:21','2022-07-28 17:53:21',40,'AC_PRODUCT_MODIFY','2022-07-28 17:53:21','2022-07-28 05:53:21',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BISUS600G modificado','Autor: admin\nProducto BISUS600G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,217,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (219,219,NULL,1,'2022-07-28 17:54:29','2022-07-28 17:54:29',40,'AC_PRODUCT_MODIFY','2022-07-28 17:54:29','2022-07-28 05:54:29',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR100G modificado','Autor: admin\nProducto BPGR100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,279,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (220,220,NULL,1,'2022-07-28 17:57:25','2022-07-28 17:57:25',40,'AC_PRODUCT_MODIFY','2022-07-28 17:57:25','2022-07-28 05:57:25',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPMA400G modificado','Autor: admin\nProducto BPMA400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,210,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (221,221,NULL,1,'2022-07-28 17:58:30','2022-07-28 17:58:30',40,'AC_PRODUCT_MODIFY','2022-07-28 17:58:30','2022-07-28 05:58:30',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPFL336G modificado','Autor: admin\nProducto BPFL336G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,212,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (222,222,NULL,1,'2022-07-28 17:59:49','2022-07-28 17:59:49',40,'AC_PRODUCT_MODIFY','2022-07-28 17:59:49','2022-07-28 05:59:49',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR500G modificado','Autor: admin\nProducto BPGR500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,205,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (223,223,NULL,1,'2022-07-28 18:01:20','2022-07-28 18:01:20',40,'AC_PRODUCT_MODIFY','2022-07-28 18:01:20','2022-07-28 06:01:20',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CECINAL40G modificado','Autor: admin\nProducto CECINAL40G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,231,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (224,224,NULL,1,'2022-07-28 18:02:27','2022-07-28 18:02:27',40,'AC_PRODUCT_MODIFY','2022-07-28 18:02:27','2022-07-28 06:02:27',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPNU400G modificado','Autor: admin\nProducto BPNU400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,211,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (225,225,NULL,1,'2022-07-28 18:03:23','2022-07-28 18:03:23',40,'AC_PRODUCT_MODIFY','2022-07-28 18:03:23','2022-07-28 06:03:23',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPPIZ100G modificado','Autor: admin\nProducto BPPIZ100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,278,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (226,226,NULL,1,'2022-07-28 18:04:02','2022-07-28 18:04:02',40,'AC_PRODUCT_MODIFY','2022-07-28 18:04:02','2022-07-28 06:04:02',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPMI500G modificado','Autor: admin\nProducto BPMI500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,206,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (227,227,NULL,1,'2022-07-28 18:05:33','2022-07-28 18:05:33',40,'AC_PRODUCT_MODIFY','2022-07-28 18:05:33','2022-07-28 06:05:33',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPMI500G modificado','Autor: admin\nProducto BPMI500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,206,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (228,228,NULL,1,'2022-07-28 18:13:36','2022-07-28 18:13:36',40,'AC_PRODUCT_MODIFY','2022-07-28 18:13:36','2022-07-28 06:13:36',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPAVE500G modificado','Autor: admin\nProducto BPAVE500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,203,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (229,229,NULL,1,'2022-07-28 18:14:50','2022-07-28 18:14:50',40,'AC_PRODUCT_MODIFY','2022-07-28 18:14:50','2022-07-28 06:14:50',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPLYA400G modificado','Autor: admin\nProducto BPLYA400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,208,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (230,230,NULL,1,'2022-07-28 18:23:55','2022-07-28 18:23:55',40,'AC_PRODUCT_MODIFY','2022-07-28 18:23:55','2022-07-28 06:23:55',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BNPPIZ336G modificado','Autor: admin\nProducto BNPPIZ336G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,215,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (231,231,NULL,1,'2022-07-28 18:25:52','2022-07-28 18:25:52',40,'AC_PRODUCT_CREATE','2022-07-28 18:25:52','2022-07-28 06:25:52',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CECINA creado','Autor: admin\nProducto CECINA creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,336,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (232,232,NULL,1,'2022-07-28 18:26:07','2022-07-28 18:26:07',40,'AC_PRODUCT_MODIFY','2022-07-28 18:26:07','2022-07-28 06:26:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CECINA modificado','Autor: admin\nProducto CECINA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,336,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (233,233,NULL,1,'2022-07-28 18:26:24','2022-07-28 18:26:24',40,'AC_PRODUCT_MODIFY','2022-07-28 18:26:24','2022-07-28 06:26:24',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CECINA modificado','Autor: admin\nProducto CECINA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,336,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (234,234,NULL,1,'2022-07-28 18:39:07','2022-07-28 18:39:07',40,'AC_PRODUCT_MODIFY','2022-07-28 18:39:07','2022-07-28 06:39:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGCH400G modificado','Autor: admin\nProducto BPGCH400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,280,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (235,235,NULL,1,'2022-07-28 18:47:47','2022-07-28 18:47:47',40,'AC_PRODUCT_MODIFY','2022-07-28 18:47:47','2022-07-28 06:47:47',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CECINAA40G modificado','Autor: admin\nProducto CECINAA40G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,232,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (236,236,NULL,1,'2022-07-28 18:53:07','2022-07-28 18:53:07',40,'AC_PRODUCT_MODIFY','2022-07-28 18:53:07','2022-07-28 06:53:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CECINAH40G modificado','Autor: admin\nProducto CECINAH40G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,233,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (237,237,NULL,1,'2022-07-28 18:53:07','2022-07-28 18:53:07',40,'AC_PRODUCT_MODIFY','2022-07-28 18:53:07','2022-07-28 06:53:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CECINAH40G modificado','Autor: admin\nProducto CECINAH40G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,233,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (238,238,NULL,1,'2022-07-28 18:54:08','2022-07-28 18:54:08',40,'AC_PRODUCT_MODIFY','2022-07-28 18:54:08','2022-07-28 06:54:08',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPOR200G modificado','Autor: admin\nProducto BPOR200G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,213,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (239,239,NULL,1,'2022-07-28 18:55:53','2022-07-28 18:55:53',40,'AC_PRODUCT_MODIFY','2022-07-28 18:55:54','2022-07-28 06:55:54',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPAVE100G modificado','Autor: admin\nProducto BPAVE100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,219,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (240,240,NULL,1,'2022-07-28 18:56:56','2022-07-28 18:56:56',40,'AC_PRODUCT_MODIFY','2022-07-28 18:56:56','2022-07-28 06:56:56',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPAA350G modificado','Autor: admin\nProducto BPAA350G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,209,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (241,241,NULL,1,'2022-07-28 18:59:08','2022-07-28 18:59:08',40,'AC_PRODUCT_CREATE','2022-07-28 18:59:08','2022-07-28 06:59:08',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTPF100G creado','Autor: admin\nProducto BTPF100G creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,337,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (242,242,NULL,1,'2022-07-28 18:59:23','2022-07-28 18:59:23',40,'AC_PRODUCT_MODIFY','2022-07-28 18:59:23','2022-07-28 06:59:23',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTPF100G modificado','Autor: admin\nProducto BTPF100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,337,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (243,243,NULL,1,'2022-07-28 19:00:31','2022-07-28 19:00:31',40,'AC_PRODUCT_MODIFY','2022-07-28 19:00:31','2022-07-28 07:00:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTCHB100G modificado','Autor: admin\nProducto BTCHB100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,221,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (244,244,NULL,1,'2022-07-28 19:02:04','2022-07-28 19:02:04',40,'AC_PRODUCT_MODIFY','2022-07-28 19:02:04','2022-07-28 07:02:04',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTCHM100G modificado','Autor: admin\nProducto BTCHM100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,222,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (245,245,NULL,1,'2022-07-28 19:03:28','2022-07-28 19:03:28',40,'AC_PRODUCT_MODIFY','2022-07-28 19:03:28','2022-07-28 07:03:28',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTCFSCH90G modificado','Autor: admin\nProducto BTCFSCH90G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,223,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (246,246,NULL,1,'2022-07-28 19:03:45','2022-07-28 19:03:45',40,'AC_PRODUCT_MODIFY','2022-07-28 19:03:45','2022-07-28 07:03:45',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTCFSCH90G modificado','Autor: admin\nProducto BTCFSCH90G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,223,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (247,247,NULL,1,'2022-07-28 19:04:47','2022-07-28 19:04:47',40,'AC_PRODUCT_MODIFY','2022-07-28 19:04:47','2022-07-28 07:04:47',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTCFC90G modificado','Autor: admin\nProducto BTCFC90G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,224,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (248,248,NULL,1,'2022-07-28 19:05:59','2022-07-28 19:05:59',40,'AC_PRODUCT_MODIFY','2022-07-28 19:05:59','2022-07-28 07:05:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTBM80G modificado','Autor: admin\nProducto BTBM80G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,225,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (249,249,NULL,1,'2022-07-28 19:06:57','2022-07-28 19:06:57',40,'AC_PRODUCT_MODIFY','2022-07-28 19:06:57','2022-07-28 07:06:57',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTCT80G modificado','Autor: admin\nProducto BTCT80G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,227,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (250,250,NULL,1,'2022-07-28 19:09:18','2022-07-28 19:09:18',40,'AC_PRODUCT_MODIFY','2022-07-28 19:09:18','2022-07-28 07:09:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPTDF84G modificado','Autor: admin\nProducto BPTDF84G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,230,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (251,251,NULL,1,'2022-07-28 19:10:16','2022-07-28 19:10:16',40,'AC_PRODUCT_MODIFY','2022-07-28 19:10:16','2022-07-28 07:10:16',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPTDP84G modificado','Autor: admin\nProducto BPTDP84G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,229,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (252,252,NULL,1,'2022-07-28 19:14:46','2022-07-28 19:14:46',40,'AC_PRODUCT_CREATE','2022-07-28 19:14:46','2022-07-28 07:14:46',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR400G creado','Autor: admin\nProducto BPGR400G creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,338,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (253,253,NULL,1,'2022-07-28 19:16:24','2022-07-28 19:16:24',40,'AC_PRODUCT_MODIFY','2022-07-28 19:16:24','2022-07-28 07:16:24',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPCEP14GR modificado','Autor: admin\nProducto BPCEP14GR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,235,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (254,254,NULL,1,'2022-07-28 19:17:32','2022-07-28 19:17:32',40,'AC_PRODUCT_MODIFY','2022-07-28 19:17:32','2022-07-28 07:17:32',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPELO11GR modificado','Autor: admin\nProducto BPELO11GR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,236,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (255,255,NULL,1,'2022-07-28 19:17:52','2022-07-28 19:17:52',40,'AC_PRODUCT_MODIFY','2022-07-28 19:17:52','2022-07-28 07:17:52',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPCEP14GR modificado','Autor: admin\nProducto BPCEP14GR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,235,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (256,256,NULL,1,'2022-07-28 19:18:46','2022-07-28 19:18:46',40,'AC_PRODUCT_MODIFY','2022-07-28 19:18:46','2022-07-28 07:18:46',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPMAN11GR modificado','Autor: admin\nProducto BPMAN11GR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,234,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (257,257,NULL,1,'2022-07-28 19:19:44','2022-07-28 19:19:44',40,'AC_PRODUCT_MODIFY','2022-07-28 19:19:44','2022-07-28 07:19:44',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTBM80G modificado','Autor: admin\nProducto BTBM80G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,225,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (258,258,NULL,1,'2022-07-28 19:20:06','2022-07-28 19:20:06',40,'AC_PRODUCT_MODIFY','2022-07-28 19:20:06','2022-07-28 07:20:06',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPARROZ900G modificado','Autor: admin\nProducto BPARROZ900G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,282,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (259,259,NULL,1,'2022-07-28 19:20:24','2022-07-28 19:20:24',40,'AC_PRODUCT_MODIFY','2022-07-28 19:20:24','2022-07-28 07:20:24',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPAA350G modificado','Autor: admin\nProducto BPAA350G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,209,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (260,260,NULL,1,'2022-07-28 19:20:41','2022-07-28 19:20:41',40,'AC_PRODUCT_MODIFY','2022-07-28 19:20:41','2022-07-28 07:20:41',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPELO11GR modificado','Autor: admin\nProducto BPELO11GR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,236,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (261,261,NULL,1,'2022-07-28 19:21:01','2022-07-28 19:21:01',40,'AC_PRODUCT_MODIFY','2022-07-28 19:21:01','2022-07-28 07:21:01',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTCHM100G modificado','Autor: admin\nProducto BTCHM100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,222,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (262,262,NULL,1,'2022-07-28 19:22:05','2022-07-28 19:22:05',40,'AC_PRODUCT_MODIFY','2022-07-28 19:22:05','2022-07-28 07:22:05',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPSAN11GR modificado','Autor: admin\nProducto BPSAN11GR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,237,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (263,263,NULL,1,'2022-07-28 19:23:36','2022-07-28 19:23:36',40,'AC_PRODUCT_MODIFY','2022-07-28 19:23:36','2022-07-28 07:23:36',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MI40G modificado','Autor: admin\nProducto MI40G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,228,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (264,264,NULL,1,'2022-07-28 21:45:06','2022-07-28 21:45:06',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-28 21:45:06','2022-07-28 09:45:06',1,NULL,NULL,4,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0019 validada','Autor: admin\nFactura SI2207-0019 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,27,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (265,265,NULL,1,'2022-07-28 22:09:37','2022-07-28 22:09:37',40,'AC_PRODUCT_MODIFY','2022-07-28 22:09:37','2022-07-28 10:09:37',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BARRA_DE_COCO_400g modificado','Autor: admin\nProducto BARRA_DE_COCO_400g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,214,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (266,266,NULL,1,'2022-07-28 22:10:15','2022-07-28 22:10:15',40,'AC_PRODUCT_MODIFY','2022-07-28 22:10:15','2022-07-28 10:10:15',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BNPPIZ336G modificado','Autor: admin\nProducto BNPPIZ336G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,215,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (267,267,NULL,1,'2022-07-28 22:10:48','2022-07-28 22:10:48',40,'AC_PRODUCT_MODIFY','2022-07-28 22:10:48','2022-07-28 10:10:48',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPAVE500G modificado','Autor: admin\nProducto BPAVE500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,203,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (268,268,NULL,1,'2022-07-28 22:11:39','2022-07-28 22:11:39',40,'AC_PRODUCT_MODIFY','2022-07-28 22:11:39','2022-07-28 10:11:39',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGCH400G modificado','Autor: admin\nProducto BPGCH400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,280,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (269,269,NULL,1,'2022-07-28 22:12:01','2022-07-28 22:12:01',40,'AC_PRODUCT_MODIFY','2022-07-28 22:12:01','2022-07-28 10:12:01',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR500G modificado','Autor: admin\nProducto BPGR500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,205,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (270,270,NULL,1,'2022-07-28 22:53:13','2022-07-28 22:53:13',40,'AC_ORDER_VALIDATE','2022-07-28 22:53:13','2022-07-28 10:53:13',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2207-0004 validada','Autor: admin\nOrden CO2207-0004 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,6,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (271,271,NULL,1,'2022-07-28 23:00:26','2022-07-28 23:00:26',40,'AC_ORDER_VALIDATE','2022-07-28 23:00:26','2022-07-28 11:00:26',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2207-0005 validada','Autor: admin\nOrden CO2207-0005 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,7,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (272,272,NULL,1,'2022-07-28 23:07:14','2022-07-28 23:07:14',40,'AC_ORDER_VALIDATE','2022-07-28 23:07:14','2022-07-28 11:07:14',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2207-0006 validada','Autor: admin\nOrden CO2207-0006 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,8,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (273,273,NULL,1,'2022-07-28 23:14:53','2022-07-28 23:14:53',40,'AC_ORDER_VALIDATE','2022-07-28 23:14:53','2022-07-28 11:14:53',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2207-0007 validada','Autor: admin\nOrden CO2207-0007 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,9,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (274,274,NULL,1,'2022-07-28 23:17:56','2022-07-28 23:17:56',40,'AC_ORDER_VALIDATE','2022-07-28 23:17:56','2022-07-28 11:17:56',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2207-0008 validada','Autor: admin\nOrden CO2207-0008 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,10,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (275,275,NULL,1,'2022-07-29 18:04:06','2022-07-29 18:04:06',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-29 18:04:06','2022-07-29 06:04:06',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0020 validada','Autor: admin\nFactura SI2207-0020 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,28,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (276,276,NULL,1,'2022-07-29 18:09:00','2022-07-29 18:09:00',40,'AC_PRODUCT_MODIFY','2022-07-29 18:09:00','2022-07-29 06:09:00',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MOLIENDA_Granel modificado','Autor: admin\nProducto MOLIENDA_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,202,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (277,277,NULL,1,'2022-07-29 18:17:09','2022-07-29 18:17:09',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-29 18:17:09','2022-07-29 06:17:09',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0021 validada','Autor: admin\nFactura SI2207-0021 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,29,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (278,278,NULL,1,'2022-07-29 18:27:04','2022-07-29 18:27:04',40,'AC_ORDER_VALIDATE','2022-07-29 18:27:04','2022-07-29 06:27:04',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2207-0009 validada','Autor: admin\nOrden CO2207-0009 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,11,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (279,279,NULL,1,'2022-07-29 18:32:05','2022-07-29 18:32:05',40,'AC_ORDER_VALIDATE','2022-07-29 18:32:05','2022-07-29 06:32:05',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2207-0010 validada','Autor: admin\nOrden CO2207-0010 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,12,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (280,280,NULL,1,'2022-07-29 18:50:26','2022-07-29 18:50:26',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-29 18:50:26','2022-07-29 06:50:26',1,NULL,NULL,2,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0022 validada','Autor: admin\nFactura SI2207-0022 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,30,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (281,281,NULL,1,'2022-07-29 19:00:08','2022-07-29 19:00:08',40,'AC_USER_CREATE','2022-07-29 19:00:08','2022-07-29 07:00:08',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro  creado','Autor: admin\nRegistro  creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,2,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (282,282,NULL,1,'2022-07-29 19:00:15','2022-07-29 19:00:15',40,'AC_USER_MODIFY','2022-07-29 19:00:15','2022-07-29 07:00:15',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 2 modificado','Autor: admin\nRegistro 2 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,2,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (283,283,NULL,1,'2022-07-29 19:01:03','2022-07-29 19:01:03',40,'AC_USER_CREATE','2022-07-29 19:01:03','2022-07-29 07:01:03',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro  creado','Autor: admin\nRegistro  creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,3,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (284,284,NULL,1,'2022-07-29 19:01:08','2022-07-29 19:01:08',40,'AC_USER_MODIFY','2022-07-29 19:01:08','2022-07-29 07:01:08',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 3 modificado','Autor: admin\nRegistro 3 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,3,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (285,285,NULL,1,'2022-07-29 19:03:54','2022-07-29 19:03:54',40,'AC_USER_CREATE','2022-07-29 19:03:54','2022-07-29 07:03:54',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro  creado','Autor: admin\nRegistro  creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,4,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (286,286,NULL,1,'2022-07-29 19:08:08','2022-07-29 19:08:08',40,'AC_USER_MODIFY','2022-07-29 19:08:08','2022-07-29 07:08:08',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 4 modificado','Autor: admin\nRegistro 4 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,4,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (287,287,NULL,1,'2022-07-29 19:10:59','2022-07-29 19:10:59',40,'AC_USER_CREATE','2022-07-29 19:10:59','2022-07-29 07:10:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro  creado','Autor: admin\nRegistro  creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,5,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (288,288,NULL,1,'2022-07-29 19:12:24','2022-07-29 19:12:24',40,'AC_USER_CREATE','2022-07-29 19:12:24','2022-07-29 07:12:24',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro  creado','Autor: admin\nRegistro  creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,6,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (289,289,NULL,1,'2022-07-29 19:12:29','2022-07-29 19:12:29',40,'AC_USER_MODIFY','2022-07-29 19:12:29','2022-07-29 07:12:29',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 6 modificado','Autor: admin\nRegistro 6 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,6,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (290,290,NULL,1,'2022-07-29 19:13:03','2022-07-29 19:13:03',40,'AC_USER_MODIFY','2022-07-29 19:13:03','2022-07-29 07:13:03',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 2 modificado','Autor: admin\nRegistro 2 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,2,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (291,291,NULL,1,'2022-07-29 19:13:20','2022-07-29 19:13:20',40,'AC_USER_MODIFY','2022-07-29 19:13:20','2022-07-29 07:13:20',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 4 modificado','Autor: admin\nRegistro 4 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,4,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (292,292,NULL,1,'2022-07-29 19:13:26','2022-07-29 19:13:26',40,'AC_USER_MODIFY','2022-07-29 19:13:26','2022-07-29 07:13:26',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 5 modificado','Autor: admin\nRegistro 5 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,5,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (293,293,NULL,1,'2022-07-29 19:13:28','2022-07-29 19:13:28',40,'AC_USER_MODIFY','2022-07-29 19:13:28','2022-07-29 07:13:28',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 5 modificado','Autor: admin\nRegistro 5 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,5,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (294,294,NULL,1,'2022-07-29 19:14:25','2022-07-29 19:14:25',40,'AC_USER_CREATE','2022-07-29 19:14:25','2022-07-29 07:14:25',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro  creado','Autor: admin\nRegistro  creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,7,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (295,295,NULL,1,'2022-07-29 19:14:30','2022-07-29 19:14:30',40,'AC_USER_MODIFY','2022-07-29 19:14:30','2022-07-29 07:14:30',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 7 modificado','Autor: admin\nRegistro 7 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,7,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (296,296,NULL,1,'2022-07-29 19:15:02','2022-07-29 19:15:02',40,'AC_USER_MODIFY','2022-07-29 19:15:02','2022-07-29 07:15:02',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 7 modificado','Autor: admin\nRegistro 7 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,7,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (297,297,NULL,1,'2022-07-29 19:16:44','2022-07-29 19:16:44',40,'AC_USER_CREATE','2022-07-29 19:16:44','2022-07-29 07:16:44',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro  creado','Autor: admin\nRegistro  creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,8,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (298,298,NULL,1,'2022-07-29 19:19:01','2022-07-29 19:19:01',40,'AC_USER_CREATE','2022-07-29 19:19:01','2022-07-29 07:19:01',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro  creado','Autor: admin\nRegistro  creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,9,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (299,299,NULL,1,'2022-07-29 19:19:10','2022-07-29 19:19:10',40,'AC_USER_MODIFY','2022-07-29 19:19:10','2022-07-29 07:19:10',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 9 modificado','Autor: admin\nRegistro 9 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,9,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (300,300,NULL,1,'2022-07-29 21:29:06','2022-07-29 21:29:06',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-29 21:29:06','2022-07-29 09:29:06',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0023 validada','Autor: admin\nFactura SI2207-0023 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,31,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (301,301,NULL,1,'2022-07-29 22:14:45','2022-07-29 22:14:45',40,'AC_BILL_SUPPLIER_DELETE','2022-07-29 22:14:45','2022-07-29 10:14:45',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura de proveedor eliminada','Autor: admin\nFactura de proveedor eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,31,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (302,302,NULL,1,'2022-07-29 22:23:33','2022-07-29 22:23:33',40,'AC_BILL_SUPPLIER_DELETE','2022-07-29 22:23:33','2022-07-29 10:23:33',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura de proveedor eliminada','Autor: admin\nFactura de proveedor eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,32,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (303,303,NULL,1,'2022-07-29 22:31:46','2022-07-29 22:31:46',40,'AC_BILL_SUPPLIER_DELETE','2022-07-29 22:31:46','2022-07-29 10:31:46',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura de proveedor eliminada','Autor: admin\nFactura de proveedor eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,33,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (304,304,NULL,1,'2022-07-29 23:28:14','2022-07-29 23:28:14',40,'AC_PRODUCT_MODIFY','2022-07-29 23:28:14','2022-07-29 11:28:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJA6GRAGEA modificado','Autor: admin\nProducto CBCAJA6GRAGEA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,289,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (305,305,NULL,1,'2022-07-29 23:28:24','2022-07-29 23:28:24',40,'AC_PRODUCT_MODIFY','2022-07-29 23:28:24','2022-07-29 11:28:24',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAAVECONARA350GRS modificado','Autor: admin\nProducto CBCAJAAVECONARA350GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,290,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (306,306,NULL,1,'2022-07-29 23:28:34','2022-07-29 23:28:34',40,'AC_PRODUCT_MODIFY','2022-07-29 23:28:34','2022-07-29 11:28:34',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAAVENA100GRS modificado','Autor: admin\nProducto CBCAJAAVENA100GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,291,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (307,307,NULL,1,'2022-07-29 23:28:44','2022-07-29 23:28:44',40,'AC_PRODUCT_MODIFY','2022-07-29 23:28:44','2022-07-29 11:28:44',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAAVENA500GRS modificado','Autor: admin\nProducto CBCAJAAVENA500GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,292,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (308,308,NULL,1,'2022-07-29 23:29:06','2022-07-29 23:29:06',40,'AC_PRODUCT_MODIFY','2022-07-29 23:29:06','2022-07-29 11:29:06',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJABARRASDECOCO400GRS modificado','Autor: admin\nProducto CBCAJABARRASDECOCO400GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,293,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (309,309,NULL,1,'2022-07-29 23:29:14','2022-07-29 23:29:14',40,'AC_PRODUCT_MODIFY','2022-07-29 23:29:14','2022-07-29 11:29:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJABARRASDECOCO400GRS modificado','Autor: admin\nProducto CBCAJABARRASDECOCO400GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,293,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (310,310,NULL,1,'2022-07-29 23:29:28','2022-07-29 23:29:28',40,'AC_PRODUCT_MODIFY','2022-07-29 23:29:28','2022-07-29 11:29:28',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAGRAGEA100GRS modificado','Autor: admin\nProducto CBCAJAGRAGEA100GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,294,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (311,311,NULL,1,'2022-07-29 23:29:42','2022-07-29 23:29:42',40,'AC_PRODUCT_MODIFY','2022-07-29 23:29:42','2022-07-29 11:29:42',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAGRAGEA500GRS modificado','Autor: admin\nProducto CBCAJAGRAGEA500GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,295,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (312,312,NULL,1,'2022-07-29 23:29:57','2022-07-29 23:29:57',40,'AC_PRODUCT_MODIFY','2022-07-29 23:29:57','2022-07-29 11:29:57',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJALINAZA400GRS modificado','Autor: admin\nProducto CBCAJALINAZA400GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,296,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (313,313,NULL,1,'2022-07-29 23:30:19','2022-07-29 23:30:19',40,'AC_PRODUCT_MODIFY','2022-07-29 23:30:19','2022-07-29 11:30:19',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJALISA4KG modificado','Autor: admin\nProducto CBCAJALISA4KG modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,297,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (314,314,NULL,1,'2022-07-29 23:30:33','2022-07-29 23:30:33',40,'AC_PRODUCT_MODIFY','2022-07-29 23:30:33','2022-07-29 11:30:33',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJALISA8KG modificado','Autor: admin\nProducto CBCAJALISA8KG modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,298,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (315,315,NULL,1,'2022-07-29 23:31:01','2022-07-29 23:31:01',40,'AC_PRODUCT_MODIFY','2022-07-29 23:31:01','2022-07-29 11:31:01',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJALOGO modificado','Autor: admin\nProducto CBCAJALOGO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,299,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (316,316,NULL,1,'2022-07-29 23:31:16','2022-07-29 23:31:16',40,'AC_PRODUCT_MODIFY','2022-07-29 23:31:16','2022-07-29 11:31:16',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJALOGOGRAL modificado','Autor: admin\nProducto CBCAJALOGOGRAL modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,300,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (317,317,NULL,1,'2022-07-29 23:32:13','2022-07-29 23:32:13',40,'AC_PRODUCT_MODIFY','2022-07-29 23:32:13','2022-07-29 11:32:13',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAMINICOCO500GRS modificado','Autor: admin\nProducto CBCAJAMINICOCO500GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,301,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (318,318,NULL,1,'2022-07-29 23:32:30','2022-07-29 23:32:30',40,'AC_PRODUCT_MODIFY','2022-07-29 23:32:30','2022-07-29 11:32:30',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAMINIPIZCA modificado','Autor: admin\nProducto CBCAJAMINIPIZCA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,302,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (319,319,NULL,1,'2022-07-29 23:32:47','2022-07-29 23:32:47',40,'AC_PRODUCT_MODIFY','2022-07-29 23:32:47','2022-07-29 11:32:47',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAMOLIENDA100GRS modificado','Autor: admin\nProducto CBCAJAMOLIENDA100GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,303,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (320,320,NULL,1,'2022-07-29 23:33:11','2022-07-29 23:33:11',40,'AC_PRODUCT_MODIFY','2022-07-29 23:33:11','2022-07-29 11:33:11',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAMOLIENDALB modificado','Autor: admin\nProducto CBCAJAMOLIENDALB modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,304,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (321,321,NULL,1,'2022-07-29 23:33:25','2022-07-29 23:33:25',40,'AC_PRODUCT_MODIFY','2022-07-29 23:33:25','2022-07-29 11:33:25',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAOREJAS200GRS modificado','Autor: admin\nProducto CBCAJAOREJAS200GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,305,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (322,322,NULL,1,'2022-07-29 23:33:45','2022-07-29 23:33:45',40,'AC_PRODUCT_MODIFY','2022-07-29 23:33:45','2022-07-29 11:33:45',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAVAINILLAFLOR336GRS modificado','Autor: admin\nProducto CBCAJAVAINILLAFLOR336GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,306,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (323,323,NULL,1,'2022-07-29 23:34:09','2022-07-29 23:34:09',40,'AC_PRODUCT_MODIFY','2022-07-29 23:34:09','2022-07-29 11:34:09',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBISFLOR modificado','Autor: admin\nProducto CBISFLOR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,307,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (324,324,NULL,1,'2022-07-29 23:34:28','2022-07-29 23:34:28',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-29 23:34:28','2022-07-29 11:34:28',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0023 validada','Autor: admin\nFactura SI2207-0023 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,34,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (325,325,NULL,1,'2022-07-29 23:34:31','2022-07-29 23:34:31',40,'AC_PRODUCT_MODIFY','2022-07-29 23:34:31','2022-07-29 11:34:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBISSURT modificado','Autor: admin\nProducto CBISSURT modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,308,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (326,326,NULL,1,'2022-07-29 23:34:46','2022-07-29 23:34:46',40,'AC_PRODUCT_MODIFY','2022-07-29 23:34:46','2022-07-29 11:34:46',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBISSUSYSEV modificado','Autor: admin\nProducto CBISSUSYSEV modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,309,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (327,327,NULL,1,'2022-07-29 23:35:15','2022-07-29 23:35:15',40,'AC_PRODUCT_MODIFY','2022-07-29 23:35:15','2022-07-29 11:35:15',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBOL7090 modificado','Autor: admin\nProducto CBOL7090 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,310,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (328,328,NULL,1,'2022-07-29 23:39:03','2022-07-29 23:39:03',40,'AC_PRODUCT_MODIFY','2022-07-29 23:39:03','2022-07-29 11:39:03',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPAVE100 modificado','Autor: admin\nProducto CBPAVE100 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,311,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (329,329,NULL,1,'2022-07-30 14:49:55','2022-07-30 14:49:55',40,'AC_BILL_SUPPLIER_DELETE','2022-07-30 14:49:55','2022-07-30 02:49:55',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura de proveedor eliminada','Autor: admin\nFactura de proveedor eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,37,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (330,330,NULL,1,'2022-07-30 14:51:07','2022-07-30 14:51:07',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-30 14:51:07','2022-07-30 02:51:07',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0024 validada','Autor: admin\nFactura SI2207-0024 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,38,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (331,331,NULL,1,'2022-07-30 14:57:32','2022-07-30 14:57:32',40,'AC_BILL_SUPPLIER_DELETE','2022-07-30 14:57:32','2022-07-30 02:57:32',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura de proveedor eliminada','Autor: admin\nFactura de proveedor eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,39,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (332,332,NULL,1,'2022-07-30 15:03:40','2022-07-30 15:03:40',40,'AC_PRODUCT_MODIFY','2022-07-30 15:03:40','2022-07-30 03:03:40',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BNPPIZ336G modificado','Autor: admin\nProducto BNPPIZ336G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,215,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (333,333,NULL,1,'2022-07-30 15:04:29','2022-07-30 15:04:29',40,'AC_PRODUCT_MODIFY','2022-07-30 15:04:29','2022-07-30 03:04:29',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BARRA_DE_COCO_400g modificado','Autor: admin\nProducto BARRA_DE_COCO_400g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,214,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (334,334,NULL,1,'2022-07-30 15:05:26','2022-07-30 15:05:26',40,'AC_PRODUCT_MODIFY','2022-07-30 15:05:26','2022-07-30 03:05:26',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPAVE500G modificado','Autor: admin\nProducto BPAVE500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,203,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (335,335,NULL,1,'2022-07-30 15:07:34','2022-07-30 15:07:34',40,'AC_PRODUCT_MODIFY','2022-07-30 15:07:34','2022-07-30 03:07:34',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGCH400G modificado','Autor: admin\nProducto BPGCH400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,280,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (336,336,NULL,1,'2022-07-30 15:08:16','2022-07-30 15:08:16',40,'AC_PRODUCT_MODIFY','2022-07-30 15:08:16','2022-07-30 03:08:16',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR500G modificado','Autor: admin\nProducto BPGR500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,205,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (337,337,NULL,1,'2022-07-30 15:10:13','2022-07-30 15:10:13',40,'AC_PRODUCT_MODIFY','2022-07-30 15:10:13','2022-07-30 03:10:13',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPLYA400G modificado','Autor: admin\nProducto BPLYA400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,208,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (338,338,NULL,1,'2022-07-30 15:11:20','2022-07-30 15:11:20',40,'AC_PRODUCT_MODIFY','2022-07-30 15:11:20','2022-07-30 03:11:20',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPPIZ100G modificado','Autor: admin\nProducto BPPIZ100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,278,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (339,339,NULL,1,'2022-07-30 16:23:36','2022-07-30 16:23:36',40,'AC_PRODUCT_MODIFY','2022-07-30 16:23:36','2022-07-30 04:23:36',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAVAINILLAFLOR336GRS modificado','Autor: admin\nProducto CBCAJAVAINILLAFLOR336GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,306,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (340,340,NULL,1,'2022-07-30 16:25:03','2022-07-30 16:25:03',40,'AC_PRODUCT_MODIFY','2022-07-30 16:25:03','2022-07-30 04:25:03',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto ACEITE_COMESTIBLE modificado','Autor: admin\nProducto ACEITE_COMESTIBLE modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,258,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (341,341,NULL,1,'2022-07-30 16:25:23','2022-07-30 16:25:23',40,'AC_PRODUCT_MODIFY','2022-07-30 16:25:23','2022-07-30 04:25:23',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AGUA modificado','Autor: admin\nProducto AGUA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,241,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (342,342,NULL,1,'2022-07-30 16:25:59','2022-07-30 16:25:59',40,'AC_PRODUCT_MODIFY','2022-07-30 16:25:59','2022-07-30 04:25:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AJONJOLI modificado','Autor: admin\nProducto AJONJOLI modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,263,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (343,343,NULL,1,'2022-07-30 16:26:18','2022-07-30 16:26:18',40,'AC_PRODUCT_MODIFY','2022-07-30 16:26:18','2022-07-30 04:26:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto ALBUMINA_NATURAL_PASTEURIZADA_Y_DESHIDRATADA modificado','Autor: admin\nProducto ALBUMINA_NATURAL_PASTEURIZADA_Y_DESHIDRATADA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,271,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (344,344,NULL,1,'2022-07-30 16:26:34','2022-07-30 16:26:34',40,'AC_PRODUCT_MODIFY','2022-07-30 16:26:34','2022-07-30 04:26:34',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto ALMIDON_DE_MAIZ modificado','Autor: admin\nProducto ALMIDON_DE_MAIZ modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,243,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (345,345,NULL,1,'2022-07-30 16:27:02','2022-07-30 16:27:02',40,'AC_PRODUCT_MODIFY','2022-07-30 16:27:02','2022-07-30 04:27:02',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AGUA modificado','Autor: admin\nProducto AGUA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,241,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (346,346,NULL,1,'2022-07-30 16:27:36','2022-07-30 16:27:36',40,'AC_PRODUCT_MODIFY','2022-07-30 16:27:36','2022-07-30 04:27:36',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto ARANDANOS_SECOS modificado','Autor: admin\nProducto ARANDANOS_SECOS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,253,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (347,347,NULL,1,'2022-07-30 16:27:52','2022-07-30 16:27:52',40,'AC_PRODUCT_MODIFY','2022-07-30 16:27:52','2022-07-30 04:27:52',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AVENA_EN_HOJUELA modificado','Autor: admin\nProducto AVENA_EN_HOJUELA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,250,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (348,348,NULL,1,'2022-07-30 16:28:39','2022-07-30 16:28:39',40,'AC_PRODUCT_MODIFY','2022-07-30 16:28:39','2022-07-30 04:28:39',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AVENA_GRANEL modificado','Autor: admin\nProducto AVENA_GRANEL modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,186,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (349,349,NULL,1,'2022-07-30 16:29:01','2022-07-30 16:29:01',40,'AC_PRODUCT_MODIFY','2022-07-30 16:29:01','2022-07-30 04:29:01',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AVENA_GRANEL modificado','Autor: admin\nProducto AVENA_GRANEL modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,186,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (350,350,NULL,1,'2022-07-30 16:29:19','2022-07-30 16:29:19',40,'AC_PRODUCT_MODIFY','2022-07-30 16:29:19','2022-07-30 04:29:19',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AZUCAR_ESTANDAR modificado','Autor: admin\nProducto AZUCAR_ESTANDAR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,238,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (351,351,NULL,1,'2022-07-30 16:30:00','2022-07-30 16:30:00',40,'AC_PRODUCT_MODIFY','2022-07-30 16:30:00','2022-07-30 04:30:00',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BP_BARRA_DE_COCO_400g modificado','Autor: admin\nProducto BP_BARRA_DE_COCO_400g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,214,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (352,352,NULL,1,'2022-07-30 18:54:39','2022-07-30 18:54:39',40,'AC_PRODUCT_MODIFY','2022-07-30 18:54:39','2022-07-30 06:54:39',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto ESTA_NO modificado','Autor: admin\nProducto ESTA_NO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,207,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (353,353,NULL,1,'2022-07-30 18:58:38','2022-07-30 18:58:38',40,'AC_ORDER_VALIDATE','2022-07-30 18:58:38','2022-07-30 06:58:38',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2207-0011 validada','Autor: admin\nOrden CO2207-0011 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,14,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (354,354,NULL,1,'2022-07-30 20:38:39','2022-07-30 20:38:39',40,'AC_PRODUCT_MODIFY','2022-07-30 20:38:39','2022-07-30 08:38:39',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AZUCAR_GLAS_ESTANDAR modificado','Autor: admin\nProducto AZUCAR_GLAS_ESTANDAR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,267,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (355,355,NULL,1,'2022-07-30 20:40:06','2022-07-30 20:40:06',40,'AC_PRODUCT_MODIFY','2022-07-30 20:40:06','2022-07-30 08:40:06',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BARRA_DE_COCO_Granel modificado','Autor: admin\nProducto BARRA_DE_COCO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,197,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (356,356,NULL,1,'2022-07-30 20:40:42','2022-07-30 20:40:42',40,'AC_PRODUCT_MODIFY','2022-07-30 20:40:42','2022-07-30 08:40:42',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BICARBONATO_DE_SODIO modificado','Autor: admin\nProducto BICARBONATO_DE_SODIO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,244,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (357,357,NULL,1,'2022-07-30 20:41:13','2022-07-30 20:41:13',40,'AC_PRODUCT_MODIFY','2022-07-30 20:41:13','2022-07-30 08:41:13',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BISAGRA_SEVILLANO modificado','Autor: admin\nProducto BISAGRA_SEVILLANO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,218,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (358,358,NULL,1,'2022-07-30 20:41:48','2022-07-30 20:41:48',40,'AC_PRODUCT_MODIFY','2022-07-30 20:41:48','2022-07-30 08:41:48',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPNU400G modificado','Autor: admin\nProducto BPNU400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,211,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (359,359,NULL,1,'2022-07-30 20:42:03','2022-07-30 20:42:03',40,'AC_PRODUCT_MODIFY','2022-07-30 20:42:03','2022-07-30 08:42:03',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPPIZ100G modificado','Autor: admin\nProducto BPPIZ100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,278,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (360,360,NULL,1,'2022-07-30 20:42:41','2022-07-30 20:42:41',40,'AC_PRODUCT_MODIFY','2022-07-30 20:42:41','2022-07-30 08:42:41',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CACAHUATE_DE_FRESA_Granel modificado','Autor: admin\nProducto CACAHUATE_DE_FRESA_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,192,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (361,361,NULL,1,'2022-07-30 20:42:57','2022-07-30 20:42:57',40,'AC_PRODUCT_MODIFY','2022-07-30 20:42:57','2022-07-30 08:42:57',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CACAHUATE_JAPONES modificado','Autor: admin\nProducto CACAHUATE_JAPONES modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,226,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (362,362,NULL,1,'2022-07-30 20:43:13','2022-07-30 20:43:13',40,'AC_PRODUCT_MODIFY','2022-07-30 20:43:13','2022-07-30 08:43:13',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CANELA modificado','Autor: admin\nProducto CANELA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,245,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (363,363,NULL,1,'2022-07-30 20:43:37','2022-07-30 20:43:37',40,'AC_PRODUCT_MODIFY','2022-07-30 20:43:37','2022-07-30 08:43:37',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBBOBGRA500 modificado','Autor: admin\nProducto CBBOBGRA500 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,287,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (364,364,NULL,1,'2022-07-30 20:44:07','2022-07-30 20:44:07',40,'AC_PRODUCT_MODIFY','2022-07-30 20:44:07','2022-07-30 08:44:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJA6GRAGEA modificado','Autor: admin\nProducto CBCAJA6GRAGEA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,289,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (365,365,NULL,1,'2022-07-30 20:44:27','2022-07-30 20:44:27',40,'AC_PRODUCT_MODIFY','2022-07-30 20:44:27','2022-07-30 08:44:27',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAAVECONARA350GRS modificado','Autor: admin\nProducto CBCAJAAVECONARA350GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,290,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (366,366,NULL,1,'2022-07-30 20:44:43','2022-07-30 20:44:43',40,'AC_PRODUCT_MODIFY','2022-07-30 20:44:43','2022-07-30 08:44:43',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAAVENA100GRS modificado','Autor: admin\nProducto CBCAJAAVENA100GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,291,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (367,367,NULL,1,'2022-07-30 20:44:56','2022-07-30 20:44:56',40,'AC_PRODUCT_MODIFY','2022-07-30 20:44:56','2022-07-30 08:44:56',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAAVENA500GRS modificado','Autor: admin\nProducto CBCAJAAVENA500GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,292,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (368,368,NULL,1,'2022-07-30 20:45:08','2022-07-30 20:45:08',40,'AC_PRODUCT_MODIFY','2022-07-30 20:45:08','2022-07-30 08:45:08',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJABARRASDECOCO400GRS modificado','Autor: admin\nProducto CBCAJABARRASDECOCO400GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,293,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (369,369,NULL,1,'2022-07-30 20:45:18','2022-07-30 20:45:18',40,'AC_PRODUCT_MODIFY','2022-07-30 20:45:18','2022-07-30 08:45:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAGRAGEA100GRS modificado','Autor: admin\nProducto CBCAJAGRAGEA100GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,294,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (370,370,NULL,1,'2022-07-30 20:45:31','2022-07-30 20:45:31',40,'AC_PRODUCT_MODIFY','2022-07-30 20:45:31','2022-07-30 08:45:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAGRAGEA500GRS modificado','Autor: admin\nProducto CBCAJAGRAGEA500GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,295,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (371,371,NULL,1,'2022-07-30 20:45:49','2022-07-30 20:45:49',40,'AC_PRODUCT_MODIFY','2022-07-30 20:45:49','2022-07-30 08:45:49',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJALINAZA400GRS modificado','Autor: admin\nProducto CBCAJALINAZA400GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,296,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (372,372,NULL,1,'2022-07-30 20:46:23','2022-07-30 20:46:23',40,'AC_PRODUCT_MODIFY','2022-07-30 20:46:23','2022-07-30 08:46:23',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJALISA4KG modificado','Autor: admin\nProducto CBCAJALISA4KG modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,297,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (373,373,NULL,1,'2022-07-30 20:46:34','2022-07-30 20:46:34',40,'AC_PRODUCT_MODIFY','2022-07-30 20:46:34','2022-07-30 08:46:34',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJALISA8KG modificado','Autor: admin\nProducto CBCAJALISA8KG modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,298,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (374,374,NULL,1,'2022-07-30 20:46:48','2022-07-30 20:46:48',40,'AC_PRODUCT_MODIFY','2022-07-30 20:46:48','2022-07-30 08:46:48',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJALOGO modificado','Autor: admin\nProducto CBCAJALOGO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,299,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (375,375,NULL,1,'2022-07-30 20:47:03','2022-07-30 20:47:03',40,'AC_PRODUCT_MODIFY','2022-07-30 20:47:03','2022-07-30 08:47:03',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJALOGOGRAL modificado','Autor: admin\nProducto CBCAJALOGOGRAL modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,300,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (376,376,NULL,1,'2022-07-30 20:47:15','2022-07-30 20:47:15',40,'AC_PRODUCT_MODIFY','2022-07-30 20:47:15','2022-07-30 08:47:15',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAMINICOCO500GRS modificado','Autor: admin\nProducto CBCAJAMINICOCO500GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,301,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (377,377,NULL,1,'2022-07-30 20:47:29','2022-07-30 20:47:29',40,'AC_PRODUCT_MODIFY','2022-07-30 20:47:29','2022-07-30 08:47:29',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAMINIPIZCA modificado','Autor: admin\nProducto CBCAJAMINIPIZCA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,302,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (378,378,NULL,1,'2022-07-30 20:47:50','2022-07-30 20:47:50',40,'AC_PRODUCT_MODIFY','2022-07-30 20:47:50','2022-07-30 08:47:50',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAMOLIENDA100GRS modificado','Autor: admin\nProducto CBCAJAMOLIENDA100GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,303,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (379,379,NULL,1,'2022-07-30 20:48:36','2022-07-30 20:48:36',40,'AC_PRODUCT_MODIFY','2022-07-30 20:48:36','2022-07-30 08:48:36',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAGRAGEA100GRS modificado','Autor: admin\nProducto CBCAJAGRAGEA100GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,294,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (380,380,NULL,1,'2022-07-30 20:48:44','2022-07-30 20:48:44',40,'AC_PRODUCT_MODIFY','2022-07-30 20:48:44','2022-07-30 08:48:44',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAGRAGEA500GRS modificado','Autor: admin\nProducto CBCAJAGRAGEA500GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,295,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (381,381,NULL,1,'2022-07-30 20:48:57','2022-07-30 20:48:57',40,'AC_PRODUCT_MODIFY','2022-07-30 20:48:57','2022-07-30 08:48:57',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAMINICOCO500GRS modificado','Autor: admin\nProducto CBCAJAMINICOCO500GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,301,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (382,382,NULL,1,'2022-07-30 20:49:05','2022-07-30 20:49:05',40,'AC_PRODUCT_MODIFY','2022-07-30 20:49:05','2022-07-30 08:49:05',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAMINIPIZCA modificado','Autor: admin\nProducto CBCAJAMINIPIZCA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,302,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (383,383,NULL,1,'2022-07-30 20:49:14','2022-07-30 20:49:14',40,'AC_PRODUCT_MODIFY','2022-07-30 20:49:14','2022-07-30 08:49:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAMOLIENDA100GRS modificado','Autor: admin\nProducto CBCAJAMOLIENDA100GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,303,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (384,384,NULL,1,'2022-07-30 20:49:22','2022-07-30 20:49:22',40,'AC_PRODUCT_MODIFY','2022-07-30 20:49:22','2022-07-30 08:49:22',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAMOLIENDALB modificado','Autor: admin\nProducto CBCAJAMOLIENDALB modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,304,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (385,385,NULL,1,'2022-07-30 20:49:35','2022-07-30 20:49:35',40,'AC_PRODUCT_MODIFY','2022-07-30 20:49:35','2022-07-30 08:49:35',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAOREJAS200GRS modificado','Autor: admin\nProducto CBCAJAOREJAS200GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,305,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (386,386,NULL,1,'2022-07-30 20:49:55','2022-07-30 20:49:55',40,'AC_PRODUCT_MODIFY','2022-07-30 20:49:55','2022-07-30 08:49:55',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAMOLIENDALB modificado','Autor: admin\nProducto CBCAJAMOLIENDALB modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,304,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (387,387,NULL,1,'2022-07-30 20:50:09','2022-07-30 20:50:09',40,'AC_PRODUCT_MODIFY','2022-07-30 20:50:09','2022-07-30 08:50:09',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAOREJAS200GRS modificado','Autor: admin\nProducto CBCAJAOREJAS200GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,305,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (388,388,NULL,1,'2022-07-30 20:50:21','2022-07-30 20:50:21',40,'AC_PRODUCT_MODIFY','2022-07-30 20:50:21','2022-07-30 08:50:21',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAVAINILLAFLOR336GRS modificado','Autor: admin\nProducto CBCAJAVAINILLAFLOR336GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,306,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (389,389,NULL,1,'2022-07-30 20:50:33','2022-07-30 20:50:33',40,'AC_PRODUCT_MODIFY','2022-07-30 20:50:33','2022-07-30 08:50:33',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBISFLOR modificado','Autor: admin\nProducto CBISFLOR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,307,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (390,390,NULL,1,'2022-07-30 20:50:47','2022-07-30 20:50:47',40,'AC_PRODUCT_MODIFY','2022-07-30 20:50:47','2022-07-30 08:50:47',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBISSURT modificado','Autor: admin\nProducto CBISSURT modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,308,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (391,391,NULL,1,'2022-07-30 20:50:58','2022-07-30 20:50:58',40,'AC_PRODUCT_MODIFY','2022-07-30 20:50:58','2022-07-30 08:50:58',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBISSUSYSEV modificado','Autor: admin\nProducto CBISSUSYSEV modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,309,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (392,392,NULL,1,'2022-07-30 20:51:15','2022-07-30 20:51:15',40,'AC_PRODUCT_MODIFY','2022-07-30 20:51:15','2022-07-30 08:51:15',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBOL7090 modificado','Autor: admin\nProducto CBOL7090 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,310,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (393,393,NULL,1,'2022-07-30 20:51:26','2022-07-30 20:51:26',40,'AC_PRODUCT_MODIFY','2022-07-30 20:51:26','2022-07-30 08:51:26',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPAVE100 modificado','Autor: admin\nProducto CBPAVE100 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,311,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (394,394,NULL,1,'2022-07-30 20:52:17','2022-07-30 20:52:17',40,'AC_PRODUCT_MODIFY','2022-07-30 20:52:17','2022-07-30 08:52:17',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPEMILIAS modificado','Autor: admin\nProducto CBPEMILIAS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,312,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (395,395,NULL,1,'2022-07-30 20:52:34','2022-07-30 20:52:34',40,'AC_PRODUCT_MODIFY','2022-07-30 20:52:34','2022-07-30 08:52:34',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGAAVE modificado','Autor: admin\nProducto CBPGAAVE modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,313,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (396,396,NULL,1,'2022-07-30 20:53:00','2022-07-30 20:53:00',40,'AC_PRODUCT_MODIFY','2022-07-30 20:53:00','2022-07-30 08:53:00',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGABACO modificado','Autor: admin\nProducto CBPGABACO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,314,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (397,397,NULL,1,'2022-07-30 20:53:39','2022-07-30 20:53:39',40,'AC_PRODUCT_MODIFY','2022-07-30 20:53:39','2022-07-30 08:53:39',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGACGRA modificado','Autor: admin\nProducto CBPGACGRA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,315,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (398,398,NULL,1,'2022-07-30 20:54:05','2022-07-30 20:54:05',40,'AC_PRODUCT_MODIFY','2022-07-30 20:54:05','2022-07-30 08:54:05',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGACGRA400G modificado','Autor: admin\nProducto CBPGACGRA400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,316,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (399,399,NULL,1,'2022-07-30 20:54:28','2022-07-30 20:54:28',40,'AC_PRODUCT_MODIFY','2022-07-30 20:54:28','2022-07-30 08:54:28',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGACLINYAJON modificado','Autor: admin\nProducto CBPGACLINYAJON modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,317,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (400,400,NULL,1,'2022-07-30 20:54:53','2022-07-30 20:54:53',40,'AC_PRODUCT_MODIFY','2022-07-30 20:54:53','2022-07-30 08:54:53',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGADAVE modificado','Autor: admin\nProducto CBPGADAVE modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,318,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (401,401,NULL,1,'2022-07-30 20:55:12','2022-07-30 20:55:12',40,'AC_PRODUCT_MODIFY','2022-07-30 20:55:12','2022-07-30 08:55:12',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGADCO modificado','Autor: admin\nProducto CBPGADCO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,319,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (402,402,NULL,1,'2022-07-30 20:55:25','2022-07-30 20:55:25',40,'AC_PRODUCT_MODIFY','2022-07-30 20:55:25','2022-07-30 08:55:25',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGAFLO modificado','Autor: admin\nProducto CBPGAFLO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,320,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (403,403,NULL,1,'2022-07-30 20:55:42','2022-07-30 20:55:42',40,'AC_PRODUCT_MODIFY','2022-07-30 20:55:42','2022-07-30 08:55:42',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGAGRACH modificado','Autor: admin\nProducto CBPGAGRACH modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,321,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (404,404,NULL,1,'2022-07-30 20:56:08','2022-07-30 20:56:08',40,'AC_PRODUCT_MODIFY','2022-07-30 20:56:08','2022-07-30 08:56:08',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGAMARM modificado','Autor: admin\nProducto CBPGAMARM modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,322,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (405,405,NULL,1,'2022-07-30 20:56:23','2022-07-30 20:56:23',40,'AC_PRODUCT_MODIFY','2022-07-30 20:56:23','2022-07-30 08:56:23',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGAMINC modificado','Autor: admin\nProducto CBPGAMINC modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,323,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (406,406,NULL,1,'2022-07-30 20:56:31','2022-07-30 20:56:31',40,'AC_PRODUCT_MODIFY','2022-07-30 20:56:31','2022-07-30 08:56:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGAMINC modificado','Autor: admin\nProducto CBPGAMINC modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,323,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (407,407,NULL,1,'2022-07-30 20:56:53','2022-07-30 20:56:53',40,'AC_PRODUCT_MODIFY','2022-07-30 20:56:53','2022-07-30 08:56:53',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGAMINIPIZCA modificado','Autor: admin\nProducto CBPGAMINIPIZCA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,324,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (408,408,NULL,1,'2022-07-30 20:57:59','2022-07-30 20:57:59',40,'AC_PRODUCT_MODIFY','2022-07-30 20:57:59','2022-07-30 08:57:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGANUEZ modificado','Autor: admin\nProducto CBPGANUEZ modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,325,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (409,409,NULL,1,'2022-07-30 20:58:19','2022-07-30 20:58:19',40,'AC_PRODUCT_MODIFY','2022-07-30 20:58:19','2022-07-30 08:58:19',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGAORE modificado','Autor: admin\nProducto CBPGAORE modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,326,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (410,410,NULL,1,'2022-07-30 20:58:44','2022-07-30 20:58:44',40,'AC_PRODUCT_MODIFY','2022-07-30 20:58:44','2022-07-30 08:58:44',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGAPIZCH modificado','Autor: admin\nProducto CBPGAPIZCH modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,327,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (411,411,NULL,1,'2022-07-30 20:59:10','2022-07-30 20:59:10',40,'AC_PRODUCT_MODIFY','2022-07-30 20:59:10','2022-07-30 08:59:10',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGRA100 modificado','Autor: admin\nProducto CBPGRA100 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,328,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (412,412,NULL,1,'2022-07-30 20:59:30','2022-07-30 20:59:30',40,'AC_PRODUCT_MODIFY','2022-07-30 20:59:30','2022-07-30 08:59:30',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CCAFEJAGRAGEA100GRS modificado','Autor: admin\nProducto CCAFEJAGRAGEA100GRS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,329,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (413,413,NULL,1,'2022-07-30 20:59:47','2022-07-30 20:59:47',40,'AC_PRODUCT_MODIFY','2022-07-30 20:59:47','2022-07-30 08:59:47',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CCINTA001 modificado','Autor: admin\nProducto CCINTA001 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,330,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (414,414,NULL,1,'2022-07-30 21:00:10','2022-07-30 21:00:10',40,'AC_PRODUCT_MODIFY','2022-07-30 21:00:10','2022-07-30 09:00:10',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CCINTA002 modificado','Autor: admin\nProducto CCINTA002 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,331,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (415,415,NULL,1,'2022-07-30 21:00:59','2022-07-30 21:00:59',40,'AC_PRODUCT_MODIFY','2022-07-30 21:00:59','2022-07-30 09:00:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CETIEMI modificado','Autor: admin\nProducto CETIEMI modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,332,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (416,416,NULL,1,'2022-07-30 21:01:19','2022-07-30 21:01:19',40,'AC_PRODUCT_MODIFY','2022-07-30 21:01:19','2022-07-30 09:01:19',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CETIFLE modificado','Autor: admin\nProducto CETIFLE modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,333,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (417,417,NULL,1,'2022-07-30 21:02:05','2022-07-30 21:02:05',40,'AC_PRODUCT_MODIFY','2022-07-30 21:02:05','2022-07-30 09:02:05',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CETISUR modificado','Autor: admin\nProducto CETISUR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,334,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (418,418,NULL,1,'2022-07-30 21:02:24','2022-07-30 21:02:24',40,'AC_PRODUCT_MODIFY','2022-07-30 21:02:24','2022-07-30 09:02:24',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CHISPAS_DE_CHOCOLATE modificado','Autor: admin\nProducto CHISPAS_DE_CHOCOLATE modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,266,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (419,419,NULL,1,'2022-07-30 21:02:44','2022-07-30 21:02:44',40,'AC_PRODUCT_MODIFY','2022-07-30 21:02:44','2022-07-30 09:02:44',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto COCO_RALLADO modificado','Autor: admin\nProducto COCO_RALLADO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,255,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (420,420,NULL,1,'2022-07-30 21:02:58','2022-07-30 21:02:58',40,'AC_PRODUCT_MODIFY','2022-07-30 21:02:58','2022-07-30 09:02:58',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto COLORANTE_ARTIFICIAL_PARA_ALIMENTOS_AMARILLO_HUEVO_PREPARADO modificado','Autor: admin\nProducto COLORANTE_ARTIFICIAL_PARA_ALIMENTOS_AMARILLO_HUEVO_PREPARADO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,269,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (421,421,NULL,1,'2022-07-30 21:03:20','2022-07-30 21:03:20',40,'AC_PRODUCT_MODIFY','2022-07-30 21:03:20','2022-07-30 09:03:20',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CONCENTRADO_ARTIFICIAL_SABOR_VAINILLA modificado','Autor: admin\nProducto CONCENTRADO_ARTIFICIAL_SABOR_VAINILLA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,242,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (422,422,NULL,1,'2022-07-30 21:03:52','2022-07-30 21:03:52',40,'AC_PRODUCT_MODIFY','2022-07-30 21:03:52','2022-07-30 09:03:52',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BP_EMILIAS modificado','Autor: admin\nProducto BP_EMILIAS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,204,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (423,423,NULL,1,'2022-07-30 21:05:15','2022-07-30 21:05:15',40,'AC_PRODUCT_MODIFY','2022-07-30 21:05:15','2022-07-30 09:05:15',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CACAHUATE_DE_FRESA_Granel modificado','Autor: admin\nProducto CACAHUATE_DE_FRESA_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,192,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (424,424,NULL,1,'2022-07-30 21:06:08','2022-07-30 21:06:08',40,'AC_PRODUCT_MODIFY','2022-07-30 21:06:08','2022-07-30 09:06:08',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AZUCAR_REFINADA modificado','Autor: admin\nProducto AZUCAR_REFINADA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,273,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (425,425,NULL,1,'2022-07-30 21:10:18','2022-07-30 21:10:18',40,'AC_PRODUCT_MODIFY','2022-07-30 21:10:18','2022-07-30 09:10:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto COCOA_FINA modificado','Autor: admin\nProducto COCOA_FINA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,275,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (426,426,NULL,1,'2022-07-30 21:10:41','2022-07-30 21:10:41',40,'AC_PRODUCT_MODIFY','2022-07-30 21:10:41','2022-07-30 09:10:41',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CONCENTRADO_ARTIFICIAL_SABOR_NARANJA modificado','Autor: admin\nProducto CONCENTRADO_ARTIFICIAL_SABOR_NARANJA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,276,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (427,427,NULL,1,'2022-07-30 21:12:32','2022-07-30 21:12:32',40,'AC_PRODUCT_MODIFY','2022-07-30 21:12:32','2022-07-30 09:12:32',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBOL7090 modificado','Autor: admin\nProducto CBOL7090 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,310,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (428,428,NULL,1,'2022-07-30 21:12:50','2022-07-30 21:12:50',40,'AC_PRODUCT_MODIFY','2022-07-30 21:12:50','2022-07-30 09:12:50',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGAAVE modificado','Autor: admin\nProducto CBPGAAVE modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,313,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (429,429,NULL,1,'2022-07-30 21:13:56','2022-07-30 21:13:56',40,'AC_PRODUCT_MODIFY','2022-07-30 21:13:56','2022-07-30 09:13:56',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GALLETA_DE_ARANDANO_Granel modificado','Autor: admin\nProducto GALLETA_DE_ARANDANO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,201,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (430,430,NULL,1,'2022-07-30 21:14:16','2022-07-30 21:14:16',40,'AC_PRODUCT_MODIFY','2022-07-30 21:14:16','2022-07-30 09:14:16',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEA_DE_COLORES_ESTANDAR modificado','Autor: admin\nProducto GRAGEA_DE_COLORES_ESTANDAR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,259,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (431,431,NULL,1,'2022-07-30 21:14:57','2022-07-30 21:14:57',40,'AC_PRODUCT_MODIFY','2022-07-30 21:14:57','2022-07-30 09:14:57',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GTAS._NUEZ_CON_GLAS_Granel modificado','Autor: admin\nProducto GTAS._NUEZ_CON_GLAS_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,188,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (432,432,NULL,1,'2022-07-30 21:15:15','2022-07-30 21:15:15',40,'AC_PRODUCT_MODIFY','2022-07-30 21:15:15','2022-07-30 09:15:15',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto HARINA_DE_TRIGO_EXTRA_FINA modificado','Autor: admin\nProducto HARINA_DE_TRIGO_EXTRA_FINA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,251,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (433,433,NULL,1,'2022-07-30 21:15:46','2022-07-30 21:15:46',40,'AC_PRODUCT_MODIFY','2022-07-30 21:15:46','2022-07-30 09:15:46',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto HUEVO_ENTERO_PASTEURIZADO_Y_DESHIDRATADO modificado','Autor: admin\nProducto HUEVO_ENTERO_PASTEURIZADO_Y_DESHIDRATADO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,246,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (434,434,NULL,1,'2022-07-30 21:16:18','2022-07-30 21:16:18',40,'AC_PRODUCT_MODIFY','2022-07-30 21:16:18','2022-07-30 09:16:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto INTEGRAL_Granel modificado','Autor: admin\nProducto INTEGRAL_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,196,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (435,435,NULL,1,'2022-07-30 21:16:42','2022-07-30 21:16:42',40,'AC_PRODUCT_MODIFY','2022-07-30 21:16:42','2022-07-30 09:16:42',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto JARABE_DE_MAIZ_DE_ALTA_FRUCTOSA_55_% modificado','Autor: admin\nProducto JARABE_DE_MAIZ_DE_ALTA_FRUCTOSA_55_% modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,249,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (436,436,NULL,1,'2022-07-30 21:17:04','2022-07-30 21:17:04',40,'AC_PRODUCT_MODIFY','2022-07-30 21:17:04','2022-07-30 09:17:04',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto LINAZA modificado','Autor: admin\nProducto LINAZA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,264,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (437,437,NULL,1,'2022-07-30 21:17:20','2022-07-30 21:17:20',40,'AC_PRODUCT_MODIFY','2022-07-30 21:17:20','2022-07-30 09:17:20',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MANTECA_DE_PALMA modificado','Autor: admin\nProducto MANTECA_DE_PALMA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,260,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (438,438,NULL,1,'2022-07-30 21:17:31','2022-07-30 21:17:31',40,'AC_PRODUCT_MODIFY','2022-07-30 21:17:31','2022-07-30 09:17:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MARGARINA_HOJALDRE modificado','Autor: admin\nProducto MARGARINA_HOJALDRE modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,277,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (439,439,NULL,1,'2022-07-30 21:18:00','2022-07-30 21:18:00',40,'AC_PRODUCT_MODIFY','2022-07-30 21:18:00','2022-07-30 09:18:00',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MARMOLEADAS_AZUCARADAS_Granel modificado','Autor: admin\nProducto MARMOLEADAS_AZUCARADAS_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,189,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (440,440,NULL,1,'2022-07-30 21:20:31','2022-07-30 21:20:31',40,'AC_PRODUCT_MODIFY','2022-07-30 21:20:31','2022-07-30 09:20:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto ESTA_NO modificado','Autor: admin\nProducto ESTA_NO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,207,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (441,441,NULL,1,'2022-07-30 21:21:42','2022-07-30 21:21:42',40,'AC_PRODUCT_MODIFY','2022-07-30 21:21:42','2022-07-30 09:21:42',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEAGRANEL modificado','Autor: admin\nProducto GRAGEAGRANEL modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,187,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (442,442,NULL,1,'2022-07-30 21:23:33','2022-07-30 21:23:33',40,'AC_PRODUCT_MODIFY','2022-07-30 21:23:33','2022-07-30 09:23:33',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto POLVO_DE_HORNEAR modificado','Autor: admin\nProducto POLVO_DE_HORNEAR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,247,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (443,443,NULL,1,'2022-07-30 21:24:00','2022-07-30 21:24:00',40,'AC_PRODUCT_MODIFY','2022-07-30 21:24:00','2022-07-30 09:24:00',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto PROMO_1 modificado','Autor: admin\nProducto PROMO_1 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,285,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (444,444,NULL,1,'2022-07-30 21:24:28','2022-07-30 21:24:28',40,'AC_PRODUCT_MODIFY','2022-07-30 21:24:28','2022-07-30 09:24:28',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto PROMO_2 modificado','Autor: admin\nProducto PROMO_2 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,286,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (445,445,NULL,1,'2022-07-30 21:25:01','2022-07-30 21:25:01',40,'AC_PRODUCT_MODIFY','2022-07-30 21:25:01','2022-07-30 09:25:01',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto PURE_DE_FRESA modificado','Autor: admin\nProducto PURE_DE_FRESA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,272,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (446,446,NULL,1,'2022-07-30 21:25:21','2022-07-30 21:25:21',40,'AC_PRODUCT_MODIFY','2022-07-30 21:25:21','2022-07-30 09:25:21',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto SABORIZANTE_ARTIFICIAL_ARANDANO modificado','Autor: admin\nProducto SABORIZANTE_ARTIFICIAL_ARANDANO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,252,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (447,447,NULL,1,'2022-07-30 21:25:37','2022-07-30 21:25:37',40,'AC_PRODUCT_MODIFY','2022-07-30 21:25:37','2022-07-30 09:25:37',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto SAL_REFINADA_YODADA modificado','Autor: admin\nProducto SAL_REFINADA_YODADA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,248,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (448,448,NULL,1,'2022-07-30 21:25:54','2022-07-30 21:25:54',40,'AC_PRODUCT_MODIFY','2022-07-30 21:25:54','2022-07-30 09:25:54',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto SEVILLANO_Granel modificado','Autor: admin\nProducto SEVILLANO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,198,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (449,449,NULL,1,'2022-07-30 21:26:33','2022-07-30 21:26:33',40,'AC_PRODUCT_MODIFY','2022-07-30 21:26:33','2022-07-30 09:26:33',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto SUSPIRO_Granel modificado','Autor: admin\nProducto SUSPIRO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,191,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (450,450,NULL,1,'2022-07-30 21:26:43','2022-07-30 21:26:43',40,'AC_PRODUCT_MODIFY','2022-07-30 21:26:43','2022-07-30 09:26:43',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto SUSPIRO_Granel modificado','Autor: admin\nProducto SUSPIRO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,191,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (451,451,NULL,1,'2022-07-30 21:26:52','2022-07-30 21:26:52',40,'AC_PRODUCT_MODIFY','2022-07-30 21:26:52','2022-07-30 09:26:52',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto SUSPIRO_Granel modificado','Autor: admin\nProducto SUSPIRO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,191,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (452,452,NULL,1,'2022-07-30 21:27:23','2022-07-30 21:27:23',40,'AC_PRODUCT_MODIFY','2022-07-30 21:27:23','2022-07-30 09:27:23',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto TIMBRE_DE_FRESA_Granel modificado','Autor: admin\nProducto TIMBRE_DE_FRESA_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,200,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (453,453,NULL,1,'2022-07-30 21:27:57','2022-07-30 21:27:57',40,'AC_PRODUCT_MODIFY','2022-07-30 21:27:57','2022-07-30 09:27:57',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto VAINILLA_FLOR_DE_CAYRO_Granel modificado','Autor: admin\nProducto VAINILLA_FLOR_DE_CAYRO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,190,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (454,454,NULL,1,'2022-07-30 21:28:38','2022-07-30 21:28:38',40,'AC_PRODUCT_MODIFY','2022-07-30 21:28:38','2022-07-30 09:28:38',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEA_CHOCOLATE_Granel modificado','Autor: admin\nProducto GRAGEA_CHOCOLATE_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,193,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (455,455,NULL,1,'2022-07-30 21:29:02','2022-07-30 21:29:02',40,'AC_PRODUCT_MODIFY','2022-07-30 21:29:02','2022-07-30 09:29:02',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEA_DE_CHOCOLATE_ESTANDAR modificado','Autor: admin\nProducto GRAGEA_DE_CHOCOLATE_ESTANDAR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,262,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (456,456,NULL,1,'2022-07-30 21:29:19','2022-07-30 21:29:19',40,'AC_PRODUCT_MODIFY','2022-07-30 21:29:19','2022-07-30 09:29:19',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto HARINA_DE_TRIGO_INTEGRAL modificado','Autor: admin\nProducto HARINA_DE_TRIGO_INTEGRAL modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,265,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (457,457,NULL,1,'2022-07-30 21:29:35','2022-07-30 21:29:35',40,'AC_PRODUCT_MODIFY','2022-07-30 21:29:35','2022-07-30 09:29:35',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MANTECA_OLEOFINOS modificado','Autor: admin\nProducto MANTECA_OLEOFINOS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,239,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (458,458,NULL,1,'2022-07-30 21:29:48','2022-07-30 21:29:48',40,'AC_PRODUCT_MODIFY','2022-07-30 21:29:48','2022-07-30 09:29:48',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MARGARINA_MULTIUSOS modificado','Autor: admin\nProducto MARGARINA_MULTIUSOS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,240,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (459,459,NULL,1,'2022-07-30 21:30:11','2022-07-30 21:30:11',40,'AC_PRODUCT_MODIFY','2022-07-30 21:30:11','2022-07-30 09:30:11',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MASA_PARA_MARMOLEADAS_CAFE modificado','Autor: admin\nProducto MASA_PARA_MARMOLEADAS_CAFE modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,274,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (460,460,NULL,1,'2022-07-30 21:34:08','2022-07-30 21:34:08',40,'AC_PRODUCT_MODIFY','2022-07-30 21:34:08','2022-07-30 09:34:08',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MASA_PARA_MARMOLEADAS_CAFE modificado','Autor: admin\nProducto MASA_PARA_MARMOLEADAS_CAFE modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,274,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (461,461,NULL,1,'2022-07-30 21:34:54','2022-07-30 21:34:54',40,'AC_PRODUCT_MODIFY','2022-07-30 21:34:54','2022-07-30 09:34:54',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MINI_COCO_Granel modificado','Autor: admin\nProducto MINI_COCO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,195,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (462,462,NULL,1,'2022-07-30 21:35:19','2022-07-30 21:35:19',40,'AC_PRODUCT_MODIFY','2022-07-30 21:35:19','2022-07-30 09:35:19',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MOLIENDA_Granel modificado','Autor: admin\nProducto MOLIENDA_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,202,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (463,463,NULL,1,'2022-07-30 21:35:39','2022-07-30 21:35:39',40,'AC_PRODUCT_MODIFY','2022-07-30 21:35:39','2022-07-30 09:35:39',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto NUEZ_EN_GRANILLO modificado','Autor: admin\nProducto NUEZ_EN_GRANILLO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,256,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (464,464,NULL,1,'2022-07-30 21:36:04','2022-07-30 21:36:04',40,'AC_PRODUCT_MODIFY','2022-07-30 21:36:04','2022-07-30 09:36:04',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto OREJAS_Granel modificado','Autor: admin\nProducto OREJAS_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,194,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (465,465,NULL,1,'2022-07-30 21:36:17','2022-07-30 21:36:17',40,'AC_PRODUCT_MODIFY','2022-07-30 21:36:17','2022-07-30 09:36:17',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto PAPA_FRITA_NATURAL modificado','Autor: admin\nProducto PAPA_FRITA_NATURAL modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,220,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (466,466,NULL,1,'2022-07-30 21:36:35','2022-07-30 21:36:35',40,'AC_PRODUCT_MODIFY','2022-07-30 21:36:35','2022-07-30 09:36:35',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto PIZCA_DE_CHOCOLATE_Granel modificado','Autor: admin\nProducto PIZCA_DE_CHOCOLATE_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,199,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (467,467,NULL,1,'2022-07-30 21:37:07','2022-07-30 21:37:07',40,'AC_PRODUCT_MODIFY','2022-07-30 21:37:07','2022-07-30 09:37:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto PIZCA_DE_CHOCOLATE_Granel modificado','Autor: admin\nProducto PIZCA_DE_CHOCOLATE_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,199,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (468,468,NULL,1,'2022-07-30 21:37:29','2022-07-30 21:37:29',40,'AC_PRODUCT_MODIFY','2022-07-30 21:37:29','2022-07-30 09:37:29',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto POLVO_DE_HORNEAR_PURATOS modificado','Autor: admin\nProducto POLVO_DE_HORNEAR_PURATOS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,261,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (469,469,NULL,1,'2022-07-30 21:37:52','2022-07-30 21:37:52',40,'AC_PRODUCT_MODIFY','2022-07-30 21:37:52','2022-07-30 09:37:52',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto SABORIZANTE_ARTIFICIAL_COCO modificado','Autor: admin\nProducto SABORIZANTE_ARTIFICIAL_COCO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,254,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (470,470,NULL,1,'2022-07-30 21:38:46','2022-07-30 21:38:46',40,'AC_PRODUCT_MODIFY','2022-07-30 21:38:46','2022-07-30 09:38:46',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto SABORIZANTE_ARTIFICIAL_DE_VAINILLA modificado','Autor: admin\nProducto SABORIZANTE_ARTIFICIAL_DE_VAINILLA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,270,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (471,471,NULL,1,'2022-07-30 21:39:15','2022-07-30 21:39:15',40,'AC_PRODUCT_MODIFY','2022-07-30 21:39:15','2022-07-30 09:39:15',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto SABORIZANTE_ARTIFICIAL_FRESA modificado','Autor: admin\nProducto SABORIZANTE_ARTIFICIAL_FRESA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,257,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (472,472,NULL,1,'2022-07-30 21:39:41','2022-07-30 21:39:41',40,'AC_PRODUCT_MODIFY','2022-07-30 21:39:41','2022-07-30 09:39:41',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MANTECA_RANCHERA_ESPECIAL modificado','Autor: admin\nProducto MANTECA_RANCHERA_ESPECIAL modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,268,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (473,473,NULL,1,'2022-07-30 21:41:42','2022-07-30 21:41:42',40,'AC_PRODUCT_MODIFY','2022-07-30 21:41:42','2022-07-30 09:41:42',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto SEVILLANO_Granel modificado','Autor: admin\nProducto SEVILLANO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,198,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (474,474,NULL,1,'2022-07-30 21:52:27','2022-07-30 21:52:27',40,'AC_PRODUCT_CREATE','2022-07-30 21:52:27','2022-07-30 09:52:27',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CETISUS creado','Autor: admin\nProducto CETISUS creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,339,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (475,475,NULL,1,'2022-07-30 21:53:28','2022-07-30 21:53:28',40,'AC_PRODUCT_CREATE','2022-07-30 21:53:28','2022-07-30 09:53:28',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CSILICATO creado','Autor: admin\nProducto CSILICATO creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,340,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (476,476,NULL,1,'2022-07-30 21:53:37','2022-07-30 21:53:37',40,'AC_PRODUCT_MODIFY','2022-07-30 21:53:37','2022-07-30 09:53:37',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CSILICATO modificado','Autor: admin\nProducto CSILICATO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,340,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (477,477,NULL,1,'2022-07-30 21:53:59','2022-07-30 21:53:59',40,'AC_PRODUCT_MODIFY','2022-07-30 21:53:59','2022-07-30 09:53:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPACEITECO modificado','Autor: admin\nProducto MPACEITECO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,258,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (478,478,NULL,1,'2022-07-30 21:54:20','2022-07-30 21:54:20',40,'AC_PRODUCT_MODIFY','2022-07-30 21:54:20','2022-07-30 09:54:20',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPAJONJOLI modificado','Autor: admin\nProducto MPAJONJOLI modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,263,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (479,479,NULL,1,'2022-07-30 21:54:48','2022-07-30 21:54:48',40,'AC_PRODUCT_MODIFY','2022-07-30 21:54:48','2022-07-30 09:54:48',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPALBUMINA modificado','Autor: admin\nProducto MPALBUMINA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,271,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (480,480,NULL,1,'2022-07-30 21:55:19','2022-07-30 21:55:19',40,'AC_PRODUCT_MODIFY','2022-07-30 21:55:19','2022-07-30 09:55:19',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPALMIDON modificado','Autor: admin\nProducto MPALMIDON modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,243,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (481,481,NULL,1,'2022-07-30 21:55:41','2022-07-30 21:55:41',40,'AC_PRODUCT_MODIFY','2022-07-30 21:55:41','2022-07-30 09:55:41',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPARANDANOS modificado','Autor: admin\nProducto MPARANDANOS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,253,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (482,482,NULL,1,'2022-07-30 21:56:04','2022-07-30 21:56:04',40,'AC_PRODUCT_MODIFY','2022-07-30 21:56:04','2022-07-30 09:56:04',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPAVENA modificado','Autor: admin\nProducto MPAVENA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,250,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (483,483,NULL,1,'2022-07-30 21:56:28','2022-07-30 21:56:28',40,'AC_PRODUCT_MODIFY','2022-07-30 21:56:28','2022-07-30 09:56:28',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPAZUCAR modificado','Autor: admin\nProducto MPAZUCAR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,273,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (484,484,NULL,1,'2022-07-30 21:56:54','2022-07-30 21:56:54',40,'AC_PRODUCT_MODIFY','2022-07-30 21:56:54','2022-07-30 09:56:54',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPAZUCARGLAS modificado','Autor: admin\nProducto MPAZUCARGLAS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,267,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (485,485,NULL,1,'2022-07-30 21:57:31','2022-07-30 21:57:31',40,'AC_PRODUCT_MODIFY','2022-07-30 21:57:31','2022-07-30 09:57:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPAZUCARSTD modificado','Autor: admin\nProducto MPAZUCARSTD modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,238,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (486,486,NULL,1,'2022-07-30 21:57:50','2022-07-30 21:57:50',40,'AC_PRODUCT_MODIFY','2022-07-30 21:57:50','2022-07-30 09:57:50',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPBICARBONATO modificado','Autor: admin\nProducto MPBICARBONATO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,244,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (487,487,NULL,1,'2022-07-30 21:58:11','2022-07-30 21:58:11',40,'AC_PRODUCT_MODIFY','2022-07-30 21:58:11','2022-07-30 09:58:11',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPCANE modificado','Autor: admin\nProducto MPCANE modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,245,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (488,488,NULL,1,'2022-07-30 21:58:35','2022-07-30 21:58:35',40,'AC_PRODUCT_MODIFY','2022-07-30 21:58:35','2022-07-30 09:58:35',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPCHISPAS modificado','Autor: admin\nProducto MPCHISPAS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,266,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (489,489,NULL,1,'2022-07-30 21:59:04','2022-07-30 21:59:04',40,'AC_PRODUCT_MODIFY','2022-07-30 21:59:04','2022-07-30 09:59:04',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPCOCO modificado','Autor: admin\nProducto MPCOCO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,255,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (490,490,NULL,1,'2022-07-30 21:59:24','2022-07-30 21:59:24',40,'AC_PRODUCT_MODIFY','2022-07-30 21:59:24','2022-07-30 09:59:24',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPCOCOA modificado','Autor: admin\nProducto MPCOCOA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,275,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (491,491,NULL,1,'2022-07-30 21:59:50','2022-07-30 21:59:50',40,'AC_PRODUCT_MODIFY','2022-07-30 21:59:50','2022-07-30 09:59:50',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPCOLORAMARILLO modificado','Autor: admin\nProducto MPCOLORAMARILLO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,269,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (492,492,NULL,1,'2022-07-30 22:00:22','2022-07-30 22:00:22',40,'AC_PRODUCT_MODIFY','2022-07-30 22:00:22','2022-07-30 10:00:22',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPCONNARANJA modificado','Autor: admin\nProducto MPCONNARANJA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,276,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (493,493,NULL,1,'2022-07-30 22:00:47','2022-07-30 22:00:47',40,'AC_PRODUCT_MODIFY','2022-07-30 22:00:47','2022-07-30 10:00:47',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPCONVAINILLA modificado','Autor: admin\nProducto MPCONVAINILLA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,242,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (494,494,NULL,1,'2022-07-30 22:01:32','2022-07-30 22:01:32',40,'AC_PRODUCT_MODIFY','2022-07-30 22:01:32','2022-07-30 10:01:32',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPFRUCTOSA modificado','Autor: admin\nProducto MPFRUCTOSA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,249,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (495,495,NULL,1,'2022-07-30 22:02:02','2022-07-30 22:02:02',40,'AC_PRODUCT_MODIFY','2022-07-30 22:02:02','2022-07-30 10:02:02',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPGRAGEACHOC modificado','Autor: admin\nProducto MPGRAGEACHOC modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,262,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (496,496,NULL,1,'2022-07-30 22:02:25','2022-07-30 22:02:25',40,'AC_PRODUCT_MODIFY','2022-07-30 22:02:25','2022-07-30 10:02:25',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPGRAGEACOLORES modificado','Autor: admin\nProducto MPGRAGEACOLORES modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,259,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (497,497,NULL,1,'2022-07-30 22:03:10','2022-07-30 22:03:10',40,'AC_PRODUCT_MODIFY','2022-07-30 22:03:10','2022-07-30 10:03:10',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPHARINA modificado','Autor: admin\nProducto MPHARINA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,251,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (498,498,NULL,1,'2022-07-30 22:03:29','2022-07-30 22:03:29',40,'AC_PRODUCT_MODIFY','2022-07-30 22:03:29','2022-07-30 10:03:29',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPHARINAINTEGRAL modificado','Autor: admin\nProducto MPHARINAINTEGRAL modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,265,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (499,499,NULL,1,'2022-07-30 22:03:53','2022-07-30 22:03:53',40,'AC_PRODUCT_MODIFY','2022-07-30 22:03:53','2022-07-30 10:03:53',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPHUEVO modificado','Autor: admin\nProducto MPHUEVO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,246,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (500,500,NULL,1,'2022-07-30 22:04:19','2022-07-30 22:04:19',40,'AC_PRODUCT_MODIFY','2022-07-30 22:04:19','2022-07-30 10:04:19',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPLINAZA modificado','Autor: admin\nProducto MPLINAZA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,264,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (501,501,NULL,1,'2022-07-30 22:04:37','2022-07-30 22:04:37',40,'AC_PRODUCT_MODIFY','2022-07-30 22:04:37','2022-07-30 10:04:37',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPMANOLEO modificado','Autor: admin\nProducto MPMANOLEO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,239,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (502,502,NULL,1,'2022-07-30 22:05:23','2022-07-30 22:05:23',40,'AC_PRODUCT_MODIFY','2022-07-30 22:05:23','2022-07-30 10:05:23',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPMANPAL modificado','Autor: admin\nProducto MPMANPAL modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,260,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (503,503,NULL,1,'2022-07-30 22:05:53','2022-07-30 22:05:53',40,'AC_PRODUCT_MODIFY','2022-07-30 22:05:53','2022-07-30 10:05:53',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPMANTESP modificado','Autor: admin\nProducto MPMANTESP modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,268,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (504,504,NULL,1,'2022-07-30 22:06:14','2022-07-30 22:06:14',40,'AC_PRODUCT_MODIFY','2022-07-30 22:06:14','2022-07-30 10:06:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPMARGAHOJAL modificado','Autor: admin\nProducto MPMARGAHOJAL modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,277,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (505,505,NULL,1,'2022-07-30 22:06:44','2022-07-30 22:06:44',40,'AC_PRODUCT_MODIFY','2022-07-30 22:06:44','2022-07-30 10:06:44',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPMARGAMUL modificado','Autor: admin\nProducto MPMARGAMUL modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,240,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (506,506,NULL,1,'2022-07-30 22:07:04','2022-07-30 22:07:04',40,'AC_PRODUCT_MODIFY','2022-07-30 22:07:04','2022-07-30 10:07:04',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPNUEZ modificado','Autor: admin\nProducto MPNUEZ modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,256,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (507,507,NULL,1,'2022-07-30 22:07:32','2022-07-30 22:07:32',40,'AC_PRODUCT_MODIFY','2022-07-30 22:07:32','2022-07-30 10:07:32',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPPOLVOHOR modificado','Autor: admin\nProducto MPPOLVOHOR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,247,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (508,508,NULL,1,'2022-07-30 22:07:57','2022-07-30 22:07:57',40,'AC_PRODUCT_MODIFY','2022-07-30 22:07:57','2022-07-30 10:07:57',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPPOLVOHORPUR modificado','Autor: admin\nProducto MPPOLVOHORPUR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,261,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (509,509,NULL,1,'2022-07-30 22:08:15','2022-07-30 22:08:15',40,'AC_PRODUCT_MODIFY','2022-07-30 22:08:15','2022-07-30 10:08:15',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPPUREFR modificado','Autor: admin\nProducto MPPUREFR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,272,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (510,510,NULL,1,'2022-07-30 22:08:35','2022-07-30 22:08:35',40,'AC_PRODUCT_MODIFY','2022-07-30 22:08:35','2022-07-30 10:08:35',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPSABARANDANO modificado','Autor: admin\nProducto MPSABARANDANO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,252,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (511,511,NULL,1,'2022-07-30 22:09:05','2022-07-30 22:09:05',40,'AC_PRODUCT_MODIFY','2022-07-30 22:09:05','2022-07-30 10:09:05',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPSABCOCO modificado','Autor: admin\nProducto MPSABCOCO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,254,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (512,512,NULL,1,'2022-07-30 22:09:24','2022-07-30 22:09:24',40,'AC_PRODUCT_MODIFY','2022-07-30 22:09:24','2022-07-30 10:09:24',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPSABFRESA modificado','Autor: admin\nProducto MPSABFRESA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,257,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (513,513,NULL,1,'2022-07-30 22:09:47','2022-07-30 22:09:47',40,'AC_PRODUCT_MODIFY','2022-07-30 22:09:47','2022-07-30 10:09:47',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPSABVAINILLA modificado','Autor: admin\nProducto MPSABVAINILLA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,270,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (514,514,NULL,1,'2022-07-30 22:10:07','2022-07-30 22:10:07',40,'AC_PRODUCT_MODIFY','2022-07-30 22:10:07','2022-07-30 10:10:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MPSAL modificado','Autor: admin\nProducto MPSAL modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,248,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (515,515,NULL,1,'2022-07-30 22:11:26','2022-07-30 22:11:26',40,'AC_PRODUCT_CREATE','2022-07-30 22:11:26','2022-07-30 10:11:26',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAREAV creado','Autor: admin\nProducto CBCAJAREAV creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,341,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (516,516,NULL,1,'2022-07-30 22:12:10','2022-07-30 22:12:10',40,'AC_PRODUCT_CREATE','2022-07-30 22:12:10','2022-07-30 10:12:10',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAREAR creado','Autor: admin\nProducto CBCAJAREAR creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,342,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (517,517,NULL,1,'2022-07-30 22:14:22','2022-07-30 22:14:22',40,'AC_PRODUCT_CREATE','2022-07-30 22:14:22','2022-07-30 10:14:22',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAREBA creado','Autor: admin\nProducto CBCAJAREBA creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,343,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (518,518,NULL,1,'2022-07-30 22:14:59','2022-07-30 22:14:59',40,'AC_PRODUCT_CREATE','2022-07-30 22:14:59','2022-07-30 10:14:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAREGR creado','Autor: admin\nProducto CBCAJAREGR creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,344,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (519,519,NULL,1,'2022-07-30 22:15:34','2022-07-30 22:15:34',40,'AC_PRODUCT_CREATE','2022-07-30 22:15:34','2022-07-30 10:15:34',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAREGR4 creado','Autor: admin\nProducto CBCAJAREGR4 creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,345,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (520,520,NULL,1,'2022-07-30 22:16:01','2022-07-30 22:16:01',40,'AC_PRODUCT_CREATE','2022-07-30 22:16:01','2022-07-30 10:16:01',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAREGR6 creado','Autor: admin\nProducto CBCAJAREGR6 creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,346,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (521,521,NULL,1,'2022-07-30 22:16:40','2022-07-30 22:16:40',40,'AC_PRODUCT_CREATE','2022-07-30 22:16:40','2022-07-30 10:16:40',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJARELIN creado','Autor: admin\nProducto CBCAJARELIN creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,347,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (522,522,NULL,1,'2022-07-30 22:17:32','2022-07-30 22:17:32',40,'AC_PRODUCT_CREATE','2022-07-30 22:17:32','2022-07-30 10:17:32',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJARELOGOG creado','Autor: admin\nProducto CBCAJARELOGOG creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,348,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (523,523,NULL,1,'2022-07-30 22:18:05','2022-07-30 22:18:05',40,'AC_PRODUCT_CREATE','2022-07-30 22:18:05','2022-07-30 10:18:05',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJARELOGO creado','Autor: admin\nProducto CBCAJARELOGO creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,349,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (524,524,NULL,1,'2022-07-30 22:19:11','2022-07-30 22:19:11',40,'AC_PRODUCT_CREATE','2022-07-30 22:19:11','2022-07-30 10:19:11',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAREMI creado','Autor: admin\nProducto CBCAJAREMI creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,350,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (525,525,NULL,1,'2022-07-30 22:19:49','2022-07-30 22:19:49',40,'AC_PRODUCT_CREATE','2022-07-30 22:19:49','2022-07-30 10:19:49',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAREOR creado','Autor: admin\nProducto CBCAJAREOR creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,351,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (526,526,NULL,1,'2022-07-30 22:20:32','2022-07-30 22:20:32',40,'AC_PRODUCT_CREATE','2022-07-30 22:20:32','2022-07-30 10:20:32',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBCAJAREVA creado','Autor: admin\nProducto CBCAJAREVA creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,352,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (527,527,NULL,1,'2022-07-31 04:02:51','2022-07-31 04:02:51',40,'AC_PRODUCT_CREATE','2022-07-31 04:02:51','2022-07-30 16:02:51',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CDECFLOR creado','Autor: admin\nProducto CDECFLOR creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,353,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (528,528,NULL,1,'2022-07-31 04:03:24','2022-07-31 04:03:24',40,'AC_PRODUCT_CREATE','2022-07-31 04:03:24','2022-07-30 16:03:24',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CDECOREJA creado','Autor: admin\nProducto CDECOREJA creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,354,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (529,529,NULL,1,'2022-07-31 04:04:01','2022-07-31 04:04:01',40,'AC_PRODUCT_CREATE','2022-07-31 04:04:01','2022-07-30 16:04:01',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto ESQUINERO creado','Autor: admin\nProducto ESQUINERO creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,355,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (530,530,NULL,1,'2022-07-31 04:04:11','2022-07-31 04:04:11',40,'AC_PRODUCT_MODIFY','2022-07-31 04:04:11','2022-07-30 16:04:11',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto ESQUINERO modificado','Autor: admin\nProducto ESQUINERO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,355,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (531,531,NULL,1,'2022-07-31 04:05:05','2022-07-31 04:05:05',40,'AC_PRODUCT_CREATE','2022-07-31 04:05:05','2022-07-30 16:05:05',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CETIFLEOPEN creado','Autor: admin\nProducto CETIFLEOPEN creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,356,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (532,532,NULL,1,'2022-07-31 04:07:18','2022-07-31 04:07:18',40,'AC_PRODUCT_CREATE','2022-07-31 04:07:18','2022-07-30 16:07:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CETIBLANCA creado','Autor: admin\nProducto CETIBLANCA creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,357,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (533,533,NULL,1,'2022-07-31 04:07:55','2022-07-31 04:07:55',40,'AC_PRODUCT_CREATE','2022-07-31 04:07:55','2022-07-30 16:07:55',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBROLLOVIT creado','Autor: admin\nProducto CBROLLOVIT creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,358,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (534,534,NULL,1,'2022-07-31 04:08:29','2022-07-31 04:08:29',40,'AC_PRODUCT_CREATE','2022-07-31 04:08:29','2022-07-30 16:08:29',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CETIEXCESO creado','Autor: admin\nProducto CETIEXCESO creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,359,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (535,535,NULL,1,'2022-07-31 04:09:31','2022-07-31 04:09:31',40,'AC_PRODUCT_CREATE','2022-07-31 04:09:31','2022-07-30 16:09:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CROETIOPEN creado','Autor: admin\nProducto CROETIOPEN creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,360,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (536,536,NULL,1,'2022-07-31 04:12:02','2022-07-31 04:12:02',40,'AC_PRODUCT_CREATE','2022-07-31 04:12:02','2022-07-30 16:12:02',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CTIRADEAVE100 creado','Autor: admin\nProducto CTIRADEAVE100 creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,361,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (537,537,NULL,1,'2022-07-31 04:12:41','2022-07-31 04:12:41',40,'AC_PRODUCT_CREATE','2022-07-31 04:12:41','2022-07-30 16:12:41',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CTIRAEMI creado','Autor: admin\nProducto CTIRAEMI creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,362,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (538,538,NULL,1,'2022-07-31 04:12:55','2022-07-31 04:12:55',40,'AC_PRODUCT_MODIFY','2022-07-31 04:12:55','2022-07-30 16:12:55',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CTIRAEMI modificado','Autor: admin\nProducto CTIRAEMI modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,362,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (539,539,NULL,1,'2022-07-31 04:13:22','2022-07-31 04:13:22',40,'AC_PRODUCT_CREATE','2022-07-31 04:13:22','2022-07-30 16:13:22',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CTIRAGRA100 creado','Autor: admin\nProducto CTIRAGRA100 creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,363,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (540,540,NULL,1,'2022-07-31 04:13:57','2022-07-31 04:13:57',40,'AC_PRODUCT_CREATE','2022-07-31 04:13:57','2022-07-30 16:13:57',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CTIRAPIZ creado','Autor: admin\nProducto CTIRAPIZ creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,364,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (541,541,NULL,1,'2022-07-31 04:15:52','2022-07-31 04:15:52',40,'AC_COMPANY_CREATE','2022-07-31 04:15:52','2022-07-30 16:15:52',1,NULL,NULL,5,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero ALMIDONES MEXICANOS S.A. DE C.V. creado','Autor: admin\nTercero ALMIDONES MEXICANOS S.A. DE C.V. creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (542,542,NULL,1,'2022-07-31 04:16:18','2022-07-31 04:16:18',40,'AC_COMPANY_CREATE','2022-07-31 04:16:18','2022-07-30 16:16:18',1,NULL,NULL,6,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero ARMANDO MENA GONZALEZ creado','Autor: admin\nTercero ARMANDO MENA GONZALEZ creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (543,543,NULL,1,'2022-07-31 04:16:46','2022-07-31 04:16:46',40,'AC_COMPANY_CREATE','2022-07-31 04:16:46','2022-07-30 16:16:46',1,NULL,NULL,7,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero AVIGM SA DE CV. creado','Autor: admin\nTercero AVIGM SA DE CV. creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (544,544,NULL,1,'2022-07-31 04:17:07','2022-07-31 04:17:07',40,'AC_COMPANY_CREATE','2022-07-31 04:17:07','2022-07-30 16:17:07',1,NULL,NULL,8,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero BERNARDO BARRAGAN REGLA creado','Autor: admin\nTercero BERNARDO BARRAGAN REGLA creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (545,545,NULL,1,'2022-07-31 04:17:38','2022-07-31 04:17:38',40,'AC_COMPANY_CREATE','2022-07-31 04:17:38','2022-07-30 16:17:38',1,NULL,NULL,9,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero DESHIDRATADOS DE COCO IMPERIAL DE ARMERIA, S. DE P.R. DE R.L creado','Autor: admin\nTercero DESHIDRATADOS DE COCO IMPERIAL DE ARMERIA, S. DE P.R. DE R.L creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (546,546,NULL,1,'2022-07-31 04:17:59','2022-07-31 04:17:59',40,'AC_COMPANY_CREATE','2022-07-31 04:17:59','2022-07-30 16:17:59',1,NULL,NULL,10,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero COMERCIAL INDUSTRIAL ACTIVO S.A. DE C.V. creado','Autor: admin\nTercero COMERCIAL INDUSTRIAL ACTIVO S.A. DE C.V. creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (547,547,NULL,1,'2022-07-31 04:18:18','2022-07-31 04:18:18',40,'AC_COMPANY_CREATE','2022-07-31 04:18:18','2022-07-30 16:18:18',1,NULL,NULL,11,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero OFELIA ANTON SOTOMAYOR creado','Autor: admin\nTercero OFELIA ANTON SOTOMAYOR creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (548,548,NULL,1,'2022-07-31 04:19:17','2022-07-31 04:19:17',40,'AC_COMPANY_CREATE','2022-07-31 04:19:17','2022-07-30 16:19:17',1,NULL,NULL,12,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero INDUSTRIAL CONFIMAX SA DE CV. creado','Autor: admin\nTercero INDUSTRIAL CONFIMAX SA DE CV. creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (549,549,NULL,1,'2022-07-31 04:19:33','2022-07-31 04:19:33',40,'AC_COMPANY_CREATE','2022-07-31 04:19:33','2022-07-30 16:19:33',1,NULL,NULL,13,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero Confimer Mago, S.A. de C.V. creado','Autor: admin\nTercero Confimer Mago, S.A. de C.V. creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (550,550,NULL,1,'2022-07-31 04:19:56','2022-07-31 04:19:56',40,'AC_COMPANY_CREATE','2022-07-31 04:19:56','2022-07-30 16:19:56',1,NULL,NULL,14,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero COMERCIALIZADORA DE CARTON Y DISEÑOS SA. DE CV. creado','Autor: admin\nTercero COMERCIALIZADORA DE CARTON Y DISEÑOS SA. DE CV. creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (551,551,NULL,1,'2022-07-31 04:20:22','2022-07-31 04:20:22',40,'AC_COMPANY_CREATE','2022-07-31 04:20:22','2022-07-30 16:20:22',1,NULL,NULL,15,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero GRUPO ECCE FLEXO S.A. DE C.V. creado','Autor: admin\nTercero GRUPO ECCE FLEXO S.A. DE C.V. creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (552,552,NULL,1,'2022-07-31 04:20:37','2022-07-31 04:20:37',40,'AC_COMPANY_CREATE','2022-07-31 04:20:37','2022-07-30 16:20:37',1,NULL,NULL,16,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero FRAGA MEX SA DE CV creado','Autor: admin\nTercero FRAGA MEX SA DE CV creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (553,553,NULL,1,'2022-07-31 04:20:57','2022-07-31 04:20:57',40,'AC_COMPANY_CREATE','2022-07-31 04:20:57','2022-07-30 16:20:57',1,NULL,NULL,17,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero GIANT BOX creado','Autor: admin\nTercero GIANT BOX creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (554,554,NULL,1,'2022-07-31 04:21:20','2022-07-31 04:21:20',40,'AC_COMPANY_CREATE','2022-07-31 04:21:20','2022-07-30 16:21:20',1,NULL,NULL,18,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero Gelatinas de Calidad, S.A. de C.V. creado','Autor: admin\nTercero Gelatinas de Calidad, S.A. de C.V. creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (555,555,NULL,1,'2022-07-31 04:21:54','2022-07-31 04:21:54',40,'AC_COMPANY_CREATE','2022-07-31 04:21:54','2022-07-30 16:21:54',1,NULL,NULL,19,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero GENESIS ETIQUETAS,SA DE CV creado','Autor: admin\nTercero GENESIS ETIQUETAS,SA DE CV creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (556,556,NULL,1,'2022-07-31 04:22:15','2022-07-31 04:22:15',40,'AC_COMPANY_CREATE','2022-07-31 04:22:15','2022-07-30 16:22:15',1,NULL,NULL,20,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero GRUPO KASTO MOLINOS SA DE CV creado','Autor: admin\nTercero GRUPO KASTO MOLINOS SA DE CV creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (557,557,NULL,1,'2022-07-31 04:22:41','2022-07-31 04:22:41',40,'AC_COMPANY_CREATE','2022-07-31 04:22:41','2022-07-30 16:22:41',1,NULL,NULL,21,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero GRUPO INDUSTRIAL VIDA S.A DE C.V creado','Autor: admin\nTercero GRUPO INDUSTRIAL VIDA S.A DE C.V creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (558,558,NULL,1,'2022-07-31 04:22:55','2022-07-31 04:22:55',40,'AC_COMPANY_CREATE','2022-07-31 04:22:55','2022-07-30 16:22:55',1,NULL,NULL,22,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero Grupo Premier de Occidente, S.A. de C.V. creado','Autor: admin\nTercero Grupo Premier de Occidente, S.A. de C.V. creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (559,559,NULL,1,'2022-07-31 04:23:18','2022-07-31 04:23:18',40,'AC_COMPANY_CREATE','2022-07-31 04:23:18','2022-07-30 16:23:18',1,NULL,NULL,23,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero Industrializadora de Mantecas, S.A. de C.V. creado','Autor: admin\nTercero Industrializadora de Mantecas, S.A. de C.V. creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (560,560,NULL,1,'2022-07-31 04:23:33','2022-07-31 04:23:33',40,'AC_COMPANY_CREATE','2022-07-31 04:23:33','2022-07-30 16:23:33',1,NULL,NULL,24,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero industrias navarro ulloa creado','Autor: admin\nTercero industrias navarro ulloa creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (562,562,NULL,1,'2022-07-31 04:24:08','2022-07-31 04:24:08',40,'AC_COMPANY_CREATE','2022-07-31 04:24:08','2022-07-30 16:24:08',1,NULL,NULL,26,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero INDUSTRIALIZADORA OLEOFINOS, S.A. DE C.V. creado','Autor: admin\nTercero INDUSTRIALIZADORA OLEOFINOS, S.A. DE C.V. creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (563,563,NULL,1,'2022-07-31 04:24:28','2022-07-31 04:24:28',40,'AC_COMPANY_CREATE','2022-07-31 04:24:28','2022-07-30 16:24:28',1,NULL,NULL,27,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero OSCAR GONZALEZ GARCIA creado','Autor: admin\nTercero OSCAR GONZALEZ GARCIA creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (564,564,NULL,1,'2022-07-31 04:24:53','2022-07-31 04:24:53',40,'AC_COMPANY_CREATE','2022-07-31 04:24:53','2022-07-30 16:24:53',1,NULL,NULL,28,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero JOSE GUADALUPE HERRERA GOMEZ creado','Autor: admin\nTercero JOSE GUADALUPE HERRERA GOMEZ creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (565,565,NULL,1,'2022-07-31 04:25:15','2022-07-31 04:25:15',40,'AC_COMPANY_CREATE','2022-07-31 04:25:15','2022-07-30 16:25:15',1,NULL,NULL,29,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero Puratos de México, S.A. de C.V. creado','Autor: admin\nTercero Puratos de México, S.A. de C.V. creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (566,566,NULL,1,'2022-07-31 04:25:34','2022-07-31 04:25:34',40,'AC_COMPANY_CREATE','2022-07-31 04:25:34','2022-07-30 16:25:34',1,NULL,NULL,30,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero ROTOTEC, SA DE CV creado','Autor: admin\nTercero ROTOTEC, SA DE CV creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (567,567,NULL,1,'2022-07-31 04:25:58','2022-07-31 04:25:58',40,'AC_COMPANY_CREATE','2022-07-31 04:25:58','2022-07-30 16:25:58',1,NULL,NULL,31,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero COMERCIALIZADORA ROTTY, S, DE RL, DE CV. creado','Autor: admin\nTercero COMERCIALIZADORA ROTTY, S, DE RL, DE CV. creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (568,568,NULL,1,'2022-07-31 04:26:12','2022-07-31 04:26:12',40,'AC_COMPANY_CREATE','2022-07-31 04:26:12','2022-07-30 16:26:12',1,NULL,NULL,32,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero SANCHEZ CHAVEZ LEON creado','Autor: admin\nTercero SANCHEZ CHAVEZ LEON creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (569,569,NULL,1,'2022-07-31 04:26:25','2022-07-31 04:26:25',40,'AC_COMPANY_CREATE','2022-07-31 04:26:25','2022-07-30 16:26:25',1,NULL,NULL,33,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero SILICATOS DE OCCIDENTE S.A DE C.V. creado','Autor: admin\nTercero SILICATOS DE OCCIDENTE S.A DE C.V. creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (570,570,NULL,1,'2022-07-31 04:26:56','2022-07-31 04:26:56',40,'AC_COMPANY_CREATE','2022-07-31 04:26:56','2022-07-30 16:26:56',1,NULL,NULL,34,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero SANTO TORIBIO CHILES SECOS.SA DE C.V. creado','Autor: admin\nTercero SANTO TORIBIO CHILES SECOS.SA DE C.V. creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (571,571,NULL,1,'2022-07-31 04:27:18','2022-07-31 04:27:18',40,'AC_COMPANY_CREATE','2022-07-31 04:27:18','2022-07-30 16:27:18',1,NULL,NULL,35,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero Nueva Wal Mart de México. S. de R.L. de C.V. creado','Autor: admin\nTercero Nueva Wal Mart de México. S. de R.L. de C.V. creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (572,572,NULL,1,'2022-07-31 04:28:14','2022-07-31 04:28:14',40,'AC_PRODUCT_MODIFY','2022-07-31 04:28:14','2022-07-30 16:28:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CDECFLOR modificado','Autor: admin\nProducto CDECFLOR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,353,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (573,573,NULL,1,'2022-07-31 04:30:35','2022-07-31 04:30:35',40,'AC_PRODUCT_MODIFY','2022-07-31 04:30:35','2022-07-30 16:30:35',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBROLLOVIT modificado','Autor: admin\nProducto CBROLLOVIT modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,358,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (574,574,NULL,1,'2022-07-31 04:30:55','2022-07-31 04:30:55',40,'AC_PRODUCT_MODIFY','2022-07-31 04:30:55','2022-07-30 16:30:55',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CDECOREJA modificado','Autor: admin\nProducto CDECOREJA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,354,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (575,575,NULL,1,'2022-07-31 04:31:28','2022-07-31 04:31:28',40,'AC_PRODUCT_MODIFY','2022-07-31 04:31:28','2022-07-30 16:31:28',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CECINAH40G modificado','Autor: admin\nProducto CECINAH40G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,233,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (576,576,NULL,1,'2022-07-31 04:31:53','2022-07-31 04:31:53',40,'AC_PRODUCT_MODIFY','2022-07-31 04:31:53','2022-07-30 16:31:53',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CECINAL40G modificado','Autor: admin\nProducto CECINAL40G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,231,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (577,577,NULL,1,'2022-07-31 04:32:12','2022-07-31 04:32:12',40,'AC_PRODUCT_MODIFY','2022-07-31 04:32:12','2022-07-30 16:32:12',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CETIEXCESO modificado','Autor: admin\nProducto CETIEXCESO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,359,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (578,578,NULL,1,'2022-07-31 04:32:37','2022-07-31 04:32:37',40,'AC_PRODUCT_MODIFY','2022-07-31 04:32:37','2022-07-30 16:32:37',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CROETIOPEN modificado','Autor: admin\nProducto CROETIOPEN modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,360,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (579,579,NULL,1,'2022-07-31 04:32:50','2022-07-31 04:32:50',40,'AC_PRODUCT_MODIFY','2022-07-31 04:32:50','2022-07-30 16:32:50',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CTIRADEAVE100 modificado','Autor: admin\nProducto CTIRADEAVE100 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,361,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (580,580,NULL,1,'2022-07-31 04:33:22','2022-07-31 04:33:22',40,'AC_PRODUCT_MODIFY','2022-07-31 04:33:22','2022-07-30 16:33:22',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CTIRAPIZ modificado','Autor: admin\nProducto CTIRAPIZ modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,364,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (581,581,NULL,1,'2022-07-31 04:33:34','2022-07-31 04:33:34',40,'AC_PRODUCT_MODIFY','2022-07-31 04:33:34','2022-07-30 16:33:34',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto ESQUINERO modificado','Autor: admin\nProducto ESQUINERO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,355,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (582,582,NULL,1,'2022-07-31 04:34:44','2022-07-31 04:34:44',40,'AC_PRODUCT_MODIFY','2022-07-31 04:34:44','2022-07-30 16:34:44',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CETIBLANCA modificado','Autor: admin\nProducto CETIBLANCA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,357,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (583,583,NULL,1,'2022-07-31 04:37:18','2022-07-31 04:37:18',40,'AC_PRODUCT_MODIFY','2022-07-31 04:37:18','2022-07-30 16:37:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MASA_PARA_MARMOLEADAS_CAFE modificado','Autor: admin\nProducto MASA_PARA_MARMOLEADAS_CAFE modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,274,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (584,584,NULL,1,'2022-07-31 04:45:22','2022-07-31 04:45:22',40,'AC_ORDER_SUPPLIER_VALIDATE','2022-07-31 04:45:22','2022-07-30 16:45:22',1,NULL,NULL,2,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden PO2207-0001 validada','Autor: admin\nOrden PO2207-0001 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,1,'order_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (585,585,NULL,1,'2022-07-31 04:45:23','2022-07-31 04:45:23',40,'AC_ORDER_SUPPLIER_APPROVE','2022-07-31 04:45:23','2022-07-30 16:45:23',1,NULL,NULL,2,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden PO2207-0001 aprovada','Autor: admin\nOrden PO2207-0001 aprovada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,1,'order_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (586,586,NULL,1,'2022-07-31 04:46:00','2022-07-31 04:46:00',40,'AC_ORDER_SUPPLIER_CLASSIFY_BILLED','2022-07-31 04:46:00','2022-07-30 16:46:00',1,NULL,NULL,2,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Pedido a proveedor PO2207-0001 clasificado como facturado','Autor: admin\nPedido a proveedor PO2207-0001 clasificado como facturado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,1,'order_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (587,587,NULL,1,'2022-07-31 04:46:00','2022-07-31 04:46:00',40,'AC_BILL_SUPPLIER_VALIDATE','2022-07-31 04:46:00','2022-07-30 16:46:00',1,NULL,NULL,2,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2207-0025 validada','Autor: admin\nFactura SI2207-0025 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,41,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (588,588,NULL,1,'2022-07-31 04:48:09','2022-07-31 04:48:09',40,'AC_PRODUCT_MODIFY','2022-07-31 04:48:09','2022-07-30 16:48:09',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MASA_PARA_MARMOLEADAS_CAFE modificado','Autor: admin\nProducto MASA_PARA_MARMOLEADAS_CAFE modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,274,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (589,589,NULL,1,'2022-07-31 04:54:10','2022-07-31 04:54:10',40,'AC_PRODUCT_MODIFY','2022-07-31 04:54:10','2022-07-30 16:54:10',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CTIRADEAVE100 modificado','Autor: admin\nProducto CTIRADEAVE100 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,361,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (590,590,NULL,1,'2022-07-31 04:55:00','2022-07-31 04:55:00',40,'AC_PRODUCT_MODIFY','2022-07-31 04:55:00','2022-07-30 16:55:00',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CTIRAEMI modificado','Autor: admin\nProducto CTIRAEMI modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,362,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (591,591,NULL,1,'2022-07-31 04:55:46','2022-07-31 04:55:46',40,'AC_PRODUCT_MODIFY','2022-07-31 04:55:46','2022-07-30 16:55:46',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CTIRAGRA100 modificado','Autor: admin\nProducto CTIRAGRA100 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,363,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (592,592,NULL,1,'2022-07-31 04:56:38','2022-07-31 04:56:38',40,'AC_PRODUCT_MODIFY','2022-07-31 04:56:38','2022-07-30 16:56:38',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CTIRAPIZ modificado','Autor: admin\nProducto CTIRAPIZ modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,364,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (593,593,NULL,1,'2022-08-01 18:53:42','2022-08-01 18:53:42',40,'AC_COMPANY_MODIFY','2022-08-01 18:53:42','2022-08-01 06:53:42',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero Publico en General modificado','Autor: admin\nTercero Publico en General modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (594,594,NULL,1,'2022-08-01 18:57:50','2022-08-01 18:57:50',40,'AC_COMPANY_MODIFY','2022-08-01 18:57:50','2022-08-01 06:57:50',1,NULL,NULL,2,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero JB modificado','Autor: admin\nTercero JB modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (595,595,NULL,1,'2022-08-01 19:00:46','2022-08-01 19:00:46',40,'AC_COMPANY_MODIFY','2022-08-01 19:00:46','2022-08-01 07:00:46',1,NULL,NULL,2,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero JB modificado','Autor: admin\nTercero JB modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (596,596,NULL,1,'2022-08-01 19:02:07','2022-08-01 19:02:07',40,'AC_COMPANY_MODIFY','2022-08-01 19:02:07','2022-08-01 07:02:07',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero Publico en General modificado','Autor: admin\nTercero Publico en General modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (597,597,NULL,1,'2022-08-01 19:03:20','2022-08-01 19:03:20',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-01 19:03:20','2022-08-01 07:03:20',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0026 validada','Autor: admin\nFactura SI2208-0026 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,42,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (598,598,NULL,1,'2022-08-01 19:09:35','2022-08-01 19:09:35',40,'AC_ORDER_VALIDATE','2022-08-01 19:09:35','2022-08-01 07:09:35',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0012 validada','Autor: admin\nOrden CO2208-0012 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,15,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (599,599,NULL,1,'2022-08-02 12:52:30','2022-08-02 12:52:30',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-02 12:52:30','2022-08-02 00:52:30',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0027 validada','Autor: admin\nFactura SI2208-0027 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,44,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (600,600,NULL,1,'2022-08-02 15:14:30','2022-08-02 15:14:30',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-02 15:14:30','2022-08-02 03:14:30',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0028 validada','Autor: admin\nFactura SI2208-0028 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,45,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (601,601,NULL,1,'2022-08-02 15:21:40','2022-08-02 15:21:40',40,'AC_ORDER_VALIDATE','2022-08-02 15:21:40','2022-08-02 03:21:40',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0013 validada','Autor: admin\nOrden CO2208-0013 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,16,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (602,602,NULL,1,'2022-08-02 17:01:16','2022-08-02 17:01:16',40,'AC_PRODUCT_MODIFY','2022-08-02 17:01:16','2022-08-02 05:01:16',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BARRA_DE_COCO_Granel modificado','Autor: admin\nProducto BARRA_DE_COCO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,197,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (603,603,NULL,1,'2022-08-02 17:03:06','2022-08-02 17:03:06',40,'AC_PRODUCT_MODIFY','2022-08-02 17:03:06','2022-08-02 05:03:06',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BARRA_DE_COCO_Granel modificado','Autor: admin\nProducto BARRA_DE_COCO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,197,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (604,604,NULL,1,'2022-08-02 17:03:29','2022-08-02 17:03:29',40,'AC_PRODUCT_MODIFY','2022-08-02 17:03:29','2022-08-02 05:03:29',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BARRA_DE_COCO_Granel modificado','Autor: admin\nProducto BARRA_DE_COCO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,197,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (605,605,NULL,1,'2022-08-02 18:21:28','2022-08-02 18:21:28',40,'AC_USER_CREATE','2022-08-02 18:21:28','2022-08-02 06:21:28',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro  creado','Autor: admin\nRegistro  creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,10,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (606,606,NULL,1,'2022-08-02 18:22:01','2022-08-02 18:22:01',40,'AC_USER_MODIFY','2022-08-02 18:22:01','2022-08-02 06:22:01',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 10 modificado','Autor: admin\nRegistro 10 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,10,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (607,607,NULL,1,'2022-08-02 18:22:09','2022-08-02 18:22:09',40,'AC_USER_MODIFY','2022-08-02 18:22:09','2022-08-02 06:22:09',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 10 modificado','Autor: admin\nRegistro 10 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,10,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (608,608,NULL,1,'2022-08-02 18:40:52','2022-08-02 18:40:52',40,'AC_ORDER_VALIDATE','2022-08-02 18:40:52','2022-08-02 06:40:52',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0014 validada','Autor: admin\nOrden CO2208-0014 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,17,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (609,609,NULL,1,'2022-08-02 18:43:50','2022-08-02 18:43:50',40,'AC_ORDER_VALIDATE','2022-08-02 18:43:50','2022-08-02 06:43:50',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0015 validada','Autor: admin\nOrden CO2208-0015 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,18,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (610,610,NULL,1,'2022-08-02 18:49:31','2022-08-02 18:49:31',40,'AC_ORDER_VALIDATE','2022-08-02 18:49:31','2022-08-02 06:49:31',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0016 validada','Autor: admin\nOrden CO2208-0016 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,19,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (611,611,NULL,1,'2022-08-02 18:55:40','2022-08-02 18:55:40',40,'AC_ORDER_VALIDATE','2022-08-02 18:55:40','2022-08-02 06:55:40',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0017 validada','Autor: admin\nOrden CO2208-0017 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,20,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (612,612,NULL,1,'2022-08-02 18:57:49','2022-08-02 18:57:49',40,'AC_ORDER_VALIDATE','2022-08-02 18:57:49','2022-08-02 06:57:49',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0018 validada','Autor: admin\nOrden CO2208-0018 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,22,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (613,613,NULL,1,'2022-08-02 19:03:11','2022-08-02 19:03:11',40,'AC_ORDER_VALIDATE','2022-08-02 19:03:11','2022-08-02 07:03:11',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0019 validada','Autor: admin\nOrden CO2208-0019 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,21,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (614,614,NULL,1,'2022-08-02 19:05:56','2022-08-02 19:05:56',40,'AC_ORDER_VALIDATE','2022-08-02 19:05:56','2022-08-02 07:05:56',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0020 validada','Autor: admin\nOrden CO2208-0020 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,23,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (615,615,NULL,1,'2022-08-02 19:07:15','2022-08-02 19:07:15',40,'AC_ORDER_VALIDATE','2022-08-02 19:07:15','2022-08-02 07:07:15',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0021 validada','Autor: admin\nOrden CO2208-0021 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,24,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (616,616,NULL,1,'2022-08-02 19:08:24','2022-08-02 19:08:24',40,'AC_ORDER_VALIDATE','2022-08-02 19:08:24','2022-08-02 07:08:24',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0022 validada','Autor: admin\nOrden CO2208-0022 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,25,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (617,617,NULL,1,'2022-08-02 19:47:55','2022-08-02 19:47:55',40,'AC_USER_MODIFY','2022-08-02 19:47:55','2022-08-02 07:47:55',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 10 modificado','Autor: admin\nRegistro 10 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,10,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (618,618,NULL,1,'2022-08-02 19:47:58','2022-08-02 19:47:58',40,'AC_USER_MODIFY','2022-08-02 19:47:58','2022-08-02 07:47:58',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 10 modificado','Autor: admin\nRegistro 10 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,10,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (619,619,NULL,1,'2022-08-02 19:48:07','2022-08-02 19:48:07',40,'AC_USER_MODIFY','2022-08-02 19:48:07','2022-08-02 07:48:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 10 modificado','Autor: admin\nRegistro 10 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,10,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (620,620,NULL,1,'2022-08-02 19:48:09','2022-08-02 19:48:09',40,'AC_USER_MODIFY','2022-08-02 19:48:09','2022-08-02 07:48:09',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 10 modificado','Autor: admin\nRegistro 10 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,10,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (621,621,NULL,1,'2022-08-02 19:56:00','2022-08-02 19:56:00',40,'AC_USER_MODIFY','2022-08-02 19:56:00','2022-08-02 07:56:00',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 10 modificado','Autor: admin\nRegistro 10 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,10,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (622,622,NULL,1,'2022-08-02 19:56:03','2022-08-02 19:56:03',40,'AC_USER_MODIFY','2022-08-02 19:56:03','2022-08-02 07:56:03',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 10 modificado','Autor: admin\nRegistro 10 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,10,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (623,623,NULL,1,'2022-08-02 19:56:05','2022-08-02 19:56:05',40,'AC_USER_MODIFY','2022-08-02 19:56:05','2022-08-02 07:56:05',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 10 modificado','Autor: admin\nRegistro 10 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,10,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (624,624,NULL,1,'2022-08-02 19:56:24','2022-08-02 19:56:24',40,'AC_USER_MODIFY','2022-08-02 19:56:24','2022-08-02 07:56:24',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 10 modificado','Autor: admin\nRegistro 10 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,10,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (625,625,NULL,1,'2022-08-02 19:56:36','2022-08-02 19:56:36',40,'AC_USER_MODIFY','2022-08-02 19:56:36','2022-08-02 07:56:36',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 8 modificado','Autor: admin\nRegistro 8 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,8,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (626,626,NULL,1,'2022-08-02 19:56:41','2022-08-02 19:56:41',40,'AC_USER_MODIFY','2022-08-02 19:56:41','2022-08-02 07:56:41',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 8 modificado','Autor: admin\nRegistro 8 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,8,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (627,627,NULL,1,'2022-08-02 19:57:08','2022-08-02 19:57:08',40,'AC_USER_MODIFY','2022-08-02 19:57:08','2022-08-02 07:57:08',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 8 modificado','Autor: admin\nRegistro 8 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,8,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (628,628,NULL,1,'2022-08-02 19:57:10','2022-08-02 19:57:10',40,'AC_USER_MODIFY','2022-08-02 19:57:10','2022-08-02 07:57:10',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 8 modificado','Autor: admin\nRegistro 8 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,8,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (629,629,NULL,1,'2022-08-02 19:57:13','2022-08-02 19:57:13',40,'AC_USER_MODIFY','2022-08-02 19:57:13','2022-08-02 07:57:13',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 8 modificado','Autor: admin\nRegistro 8 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,8,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (630,630,NULL,1,'2022-08-02 19:57:36','2022-08-02 19:57:36',40,'AC_USER_MODIFY','2022-08-02 19:57:36','2022-08-02 07:57:36',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 7 modificado','Autor: admin\nRegistro 7 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,7,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (631,631,NULL,1,'2022-08-02 19:57:39','2022-08-02 19:57:39',40,'AC_USER_MODIFY','2022-08-02 19:57:39','2022-08-02 07:57:39',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 7 modificado','Autor: admin\nRegistro 7 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,7,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (632,632,NULL,1,'2022-08-02 19:57:42','2022-08-02 19:57:42',40,'AC_USER_MODIFY','2022-08-02 19:57:42','2022-08-02 07:57:42',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 7 modificado','Autor: admin\nRegistro 7 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,7,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (633,633,NULL,1,'2022-08-02 19:57:54','2022-08-02 19:57:54',40,'AC_USER_MODIFY','2022-08-02 19:57:54','2022-08-02 07:57:54',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 6 modificado','Autor: admin\nRegistro 6 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,6,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (634,634,NULL,1,'2022-08-02 19:57:56','2022-08-02 19:57:56',40,'AC_USER_MODIFY','2022-08-02 19:57:56','2022-08-02 07:57:56',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 6 modificado','Autor: admin\nRegistro 6 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,6,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (635,635,NULL,1,'2022-08-02 19:58:01','2022-08-02 19:58:01',40,'AC_USER_MODIFY','2022-08-02 19:58:01','2022-08-02 07:58:01',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 6 modificado','Autor: admin\nRegistro 6 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,6,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (636,636,NULL,1,'2022-08-02 19:58:12','2022-08-02 19:58:12',40,'AC_USER_MODIFY','2022-08-02 19:58:12','2022-08-02 07:58:12',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 5 modificado','Autor: admin\nRegistro 5 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,5,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (637,637,NULL,1,'2022-08-02 19:58:14','2022-08-02 19:58:14',40,'AC_USER_MODIFY','2022-08-02 19:58:14','2022-08-02 07:58:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 5 modificado','Autor: admin\nRegistro 5 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,5,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (638,638,NULL,1,'2022-08-02 19:58:16','2022-08-02 19:58:16',40,'AC_USER_MODIFY','2022-08-02 19:58:16','2022-08-02 07:58:16',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 5 modificado','Autor: admin\nRegistro 5 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,5,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (639,639,NULL,1,'2022-08-02 19:58:31','2022-08-02 19:58:31',40,'AC_USER_MODIFY','2022-08-02 19:58:31','2022-08-02 07:58:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 4 modificado','Autor: admin\nRegistro 4 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,4,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (640,640,NULL,1,'2022-08-02 19:58:33','2022-08-02 19:58:33',40,'AC_USER_MODIFY','2022-08-02 19:58:33','2022-08-02 07:58:33',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 4 modificado','Autor: admin\nRegistro 4 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,4,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (641,641,NULL,1,'2022-08-02 19:58:34','2022-08-02 19:58:34',40,'AC_USER_MODIFY','2022-08-02 19:58:34','2022-08-02 07:58:34',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 4 modificado','Autor: admin\nRegistro 4 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,4,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (642,642,NULL,1,'2022-08-02 19:58:36','2022-08-02 19:58:36',40,'AC_USER_MODIFY','2022-08-02 19:58:36','2022-08-02 07:58:36',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 4 modificado','Autor: admin\nRegistro 4 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,4,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (643,643,NULL,1,'2022-08-02 19:58:37','2022-08-02 19:58:37',40,'AC_USER_MODIFY','2022-08-02 19:58:37','2022-08-02 07:58:37',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 4 modificado','Autor: admin\nRegistro 4 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,4,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (644,644,NULL,1,'2022-08-02 19:59:32','2022-08-02 19:59:32',40,'AC_USER_MODIFY','2022-08-02 19:59:32','2022-08-02 07:59:32',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 4 modificado','Autor: admin\nRegistro 4 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,4,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (645,645,NULL,1,'2022-08-02 19:59:51','2022-08-02 19:59:51',40,'AC_USER_MODIFY','2022-08-02 19:59:51','2022-08-02 07:59:51',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 3 modificado','Autor: admin\nRegistro 3 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,3,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (646,646,NULL,1,'2022-08-02 19:59:53','2022-08-02 19:59:53',40,'AC_USER_MODIFY','2022-08-02 19:59:53','2022-08-02 07:59:53',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 3 modificado','Autor: admin\nRegistro 3 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,3,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (647,647,NULL,1,'2022-08-02 19:59:55','2022-08-02 19:59:55',40,'AC_USER_MODIFY','2022-08-02 19:59:55','2022-08-02 07:59:55',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 3 modificado','Autor: admin\nRegistro 3 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,3,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (648,648,NULL,1,'2022-08-02 20:00:55','2022-08-02 20:00:55',40,'AC_USER_MODIFY','2022-08-02 20:00:55','2022-08-02 08:00:55',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 8 modificado','Autor: admin\nRegistro 8 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,8,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (649,649,NULL,1,'2022-08-02 20:05:42','2022-08-02 20:05:42',40,'AC_USER_MODIFY','2022-08-02 20:05:42','2022-08-02 08:05:42',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 7 modificado','Autor: admin\nRegistro 7 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,7,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (650,650,NULL,1,'2022-08-02 20:05:52','2022-08-02 20:05:52',40,'AC_USER_MODIFY','2022-08-02 20:05:52','2022-08-02 08:05:52',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 6 modificado','Autor: admin\nRegistro 6 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,6,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (651,651,NULL,1,'2022-08-02 20:06:03','2022-08-02 20:06:03',40,'AC_USER_MODIFY','2022-08-02 20:06:03','2022-08-02 08:06:03',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 5 modificado','Autor: admin\nRegistro 5 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,5,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (652,652,NULL,1,'2022-08-02 20:06:19','2022-08-02 20:06:19',40,'AC_USER_MODIFY','2022-08-02 20:06:19','2022-08-02 08:06:19',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 4 modificado','Autor: admin\nRegistro 4 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,4,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (653,653,NULL,1,'2022-08-02 20:06:41','2022-08-02 20:06:41',40,'AC_USER_MODIFY','2022-08-02 20:06:41','2022-08-02 08:06:41',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 3 modificado','Autor: admin\nRegistro 3 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,3,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (654,654,NULL,1,'2022-08-02 21:18:35','2022-08-02 21:18:35',40,'AC_ORDER_DELETE','2022-08-02 21:18:35','2022-08-02 09:18:35',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro (PROV27) eliminado','Autor: admin\nRegistro (PROV27) eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,27,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (655,655,NULL,1,'2022-08-02 22:19:33','2022-08-02 22:19:33',40,'AC_COMPANY_MODIFY','2022-08-02 22:19:33','2022-08-02 10:19:33',1,NULL,NULL,2,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero JB modificado','Autor: admin\nTercero JB modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (656,656,NULL,1,'2022-08-02 23:58:29','2022-08-02 23:58:29',40,'AC_ORDER_VALIDATE','2022-08-02 23:58:29','2022-08-02 11:58:29',1,NULL,NULL,13824,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0023 validada','Autor: admin\nOrden CO2208-0023 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,28,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (657,657,NULL,1,'2022-08-03 01:55:06','2022-08-03 01:55:06',40,'AC_ORDER_VALIDATE','2022-08-03 01:55:06','2022-08-02 13:55:06',1,NULL,NULL,14336,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0024 validada','Autor: admin\nOrden CO2208-0024 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,30,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (658,658,NULL,1,'2022-08-03 02:00:31','2022-08-03 02:00:31',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-03 02:00:31','2022-08-02 14:00:31',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0029 validada','Autor: admin\nFactura SI2208-0029 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,46,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (659,659,NULL,1,'2022-08-03 12:20:47','2022-08-03 12:20:47',40,'AC_BILL_SUPPLIER_DELETE','2022-08-03 12:20:47','2022-08-03 00:20:47',1,NULL,NULL,4,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura de proveedor eliminada','Autor: admin\nFactura de proveedor eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,49,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (660,660,NULL,1,'2022-08-03 13:02:39','2022-08-03 13:02:39',40,'AC_PRODUCT_MODIFY','2022-08-03 13:02:39','2022-08-03 01:02:39',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPNU400G modificado','Autor: admin\nProducto BPNU400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,211,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (661,661,NULL,1,'2022-08-03 13:03:53','2022-08-03 13:03:53',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-03 13:03:53','2022-08-03 01:03:53',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0030 validada','Autor: admin\nFactura SI2208-0030 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,50,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (662,662,NULL,1,'2022-08-03 13:09:45','2022-08-03 13:09:45',40,'AC_ORDER_VALIDATE','2022-08-03 13:09:45','2022-08-03 01:09:45',1,NULL,NULL,14336,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0025 validada','Autor: admin\nOrden CO2208-0025 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,31,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (663,663,NULL,1,'2022-08-03 19:24:36','2022-08-03 19:24:36',40,'AC_PRODUCT_CREATE','2022-08-03 19:24:36','2022-08-03 07:24:36',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MASA_PARA_GRAJEA creado','Autor: admin\nProducto MASA_PARA_GRAJEA creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,365,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (664,664,NULL,1,'2022-08-03 20:21:31','2022-08-03 20:21:31',40,'AC_ORDER_VALIDATE','2022-08-03 20:21:31','2022-08-03 08:21:31',1,NULL,NULL,14336,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0026 validada','Autor: admin\nOrden CO2208-0026 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,32,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (665,665,NULL,1,'2022-08-03 20:26:40','2022-08-03 20:26:40',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-03 20:26:40','2022-08-03 08:26:40',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0031 validada','Autor: admin\nFactura SI2208-0031 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,51,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (666,666,NULL,1,'2022-08-03 20:28:04','2022-08-03 20:28:04',40,'AC_PRODUCT_CREATE','2022-08-03 20:28:04','2022-08-03 08:28:04',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MASA_PARA_AVENA creado','Autor: admin\nProducto MASA_PARA_AVENA creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,366,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (667,667,NULL,1,'2022-08-03 20:34:58','2022-08-03 20:34:58',40,'AC_PRODUCT_CREATE','2022-08-03 20:34:58','2022-08-03 08:34:58',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MASA_PARA_AVENA_Y_ARANDANO creado','Autor: admin\nProducto MASA_PARA_AVENA_Y_ARANDANO creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,367,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (668,668,NULL,1,'2022-08-03 20:45:25','2022-08-03 20:45:25',40,'AC_PRODUCT_CREATE','2022-08-03 20:45:25','2022-08-03 08:45:25',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MASA_PARA_BARRAS_DE_COCO creado','Autor: admin\nProducto MASA_PARA_BARRAS_DE_COCO creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,368,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (669,669,NULL,1,'2022-08-03 20:50:22','2022-08-03 20:50:22',40,'AC_PRODUCT_CREATE','2022-08-03 20:50:22','2022-08-03 08:50:22',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MASA_PARA_EMILIAS creado','Autor: admin\nProducto MASA_PARA_EMILIAS creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,369,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (670,670,NULL,1,'2022-08-03 21:01:43','2022-08-03 21:01:43',40,'AC_PRODUCT_CREATE','2022-08-03 21:01:43','2022-08-03 09:01:43',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MASA_PARA_GRAGEA_MOLIENDA creado','Autor: admin\nProducto MASA_PARA_GRAGEA_MOLIENDA creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,370,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (671,671,NULL,1,'2022-08-03 21:08:01','2022-08-03 21:08:01',40,'AC_PRODUCT_CREATE','2022-08-03 21:08:01','2022-08-03 09:08:01',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MASA_PARA_GRAGEA_DE_CHOCOLATE creado','Autor: admin\nProducto MASA_PARA_GRAGEA_DE_CHOCOLATE creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,371,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (672,672,NULL,1,'2022-08-03 21:37:14','2022-08-03 21:37:14',40,'AC_PRODUCT_CREATE','2022-08-03 21:37:14','2022-08-03 09:37:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MASA_PARA_LINAZA_Y_AJONJOLI creado','Autor: admin\nProducto MASA_PARA_LINAZA_Y_AJONJOLI creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,372,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (673,673,NULL,1,'2022-08-03 22:07:49','2022-08-03 22:07:49',40,'AC_PRODUCT_CREATE','2022-08-03 22:07:49','2022-08-03 10:07:49',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MASA_PARA_MINI_COCO creado','Autor: admin\nProducto MASA_PARA_MINI_COCO creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,373,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (674,674,NULL,1,'2022-08-03 22:14:12','2022-08-03 22:14:12',40,'AC_PRODUCT_CREATE','2022-08-03 22:14:12','2022-08-03 10:14:12',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MASA_PARA_PIZCAS_DE_CHOCOLATE creado','Autor: admin\nProducto MASA_PARA_PIZCAS_DE_CHOCOLATE creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,374,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (675,675,NULL,1,'2022-08-03 22:18:09','2022-08-03 22:18:09',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-03 22:18:09','2022-08-03 10:18:09',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0032 validada','Autor: admin\nFactura SI2208-0032 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,52,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (676,676,NULL,1,'2022-08-03 22:18:15','2022-08-03 22:18:15',40,'AC_PRODUCT_CREATE','2022-08-03 22:18:15','2022-08-03 10:18:15',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MASA_PARA_NUEZ_GLAS creado','Autor: admin\nProducto MASA_PARA_NUEZ_GLAS creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,375,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (677,677,NULL,1,'2022-08-03 22:23:28','2022-08-03 22:23:28',40,'AC_PRODUCT_CREATE','2022-08-03 22:23:28','2022-08-03 10:23:28',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MASA_PARA_FLOR__CACAHUATE__LENGUA creado','Autor: admin\nProducto MASA_PARA_FLOR__CACAHUATE__LENGUA creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,376,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (678,678,NULL,1,'2022-08-03 22:34:18','2022-08-03 22:34:18',40,'AC_PRODUCT_CREATE','2022-08-03 22:34:18','2022-08-03 10:34:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto COLORANTE_ARTIFICIAL_PARA_ALIMENTOS_AMARILLO_HUEVO_PREPARADO creado','Autor: admin\nProducto COLORANTE_ARTIFICIAL_PARA_ALIMENTOS_AMARILLO_HUEVO_PREPARADO creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,377,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (679,679,NULL,1,'2022-08-03 22:46:26','2022-08-03 22:46:26',40,'AC_PRODUCT_CREATE','2022-08-03 22:46:26','2022-08-03 10:46:26',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MASA_PARA_MARMOLEADAS_BLANCA creado','Autor: admin\nProducto MASA_PARA_MARMOLEADAS_BLANCA creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,378,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (680,680,NULL,1,'2022-08-03 22:55:38','2022-08-03 22:55:38',40,'AC_PRODUCT_CREATE','2022-08-03 22:55:38','2022-08-03 10:55:38',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MASA_PARA_NARANJA creado','Autor: admin\nProducto MASA_PARA_NARANJA creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,379,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (681,681,NULL,1,'2022-08-04 00:53:42','2022-08-04 00:53:42',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-04 00:53:42','2022-08-03 12:53:42',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0033 validada','Autor: admin\nFactura SI2208-0033 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,53,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (682,682,NULL,1,'2022-08-04 01:01:06','2022-08-04 01:01:06',40,'AC_ORDER_VALIDATE','2022-08-04 01:01:06','2022-08-03 13:01:06',1,NULL,NULL,14336,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0027 validada','Autor: admin\nOrden CO2208-0027 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,33,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (683,683,NULL,1,'2022-08-04 01:54:03','2022-08-04 01:54:03',40,'AC_ORDER_VALIDATE','2022-08-04 01:54:03','2022-08-03 13:54:03',1,NULL,NULL,12959,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0028 validada','Autor: admin\nOrden CO2208-0028 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,34,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (684,684,NULL,1,'2022-08-04 13:08:01','2022-08-04 13:08:01',40,'AC_BILL_SUPPLIER_UNVALIDATE','2022-08-04 13:08:01','2022-08-04 01:08:01',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura SI2208-0032 al estado de borrador','Autor: admin\nRegresar factura SI2208-0032 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,52,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (685,685,NULL,1,'2022-08-04 13:12:07','2022-08-04 13:12:07',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-04 13:12:07','2022-08-04 01:12:07',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0032 validada','Autor: admin\nFactura SI2208-0032 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,52,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (686,686,NULL,1,'2022-08-04 13:26:29','2022-08-04 13:26:29',40,'AC_BILL_SUPPLIER_UNVALIDATE','2022-08-04 13:26:29','2022-08-04 01:26:29',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura SI2208-0030 al estado de borrador','Autor: admin\nRegresar factura SI2208-0030 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,50,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (687,687,NULL,1,'2022-08-04 13:26:47','2022-08-04 13:26:47',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-04 13:26:47','2022-08-04 01:26:47',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0030 validada','Autor: admin\nFactura SI2208-0030 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,50,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (688,688,NULL,1,'2022-08-04 14:28:55','2022-08-04 14:28:55',40,'AC_ORDER_VALIDATE','2022-08-04 14:28:55','2022-08-04 02:28:55',1,NULL,NULL,14336,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0029 validada','Autor: admin\nOrden CO2208-0029 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,35,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (689,689,NULL,1,'2022-08-04 15:53:01','2022-08-04 15:53:01',40,'AC_PRODUCT_CREATE','2022-08-04 15:53:01','2022-08-04 03:53:01',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MASA_PARA_OREJAS creado','Autor: admin\nProducto MASA_PARA_OREJAS creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,380,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (690,690,NULL,1,'2022-08-04 15:56:15','2022-08-04 15:56:15',40,'AC_PRODUCT_CREATE','2022-08-04 15:56:15','2022-08-04 03:56:15',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MASA_PARA_SEVILLANO creado','Autor: admin\nProducto MASA_PARA_SEVILLANO creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,381,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (691,691,NULL,1,'2022-08-04 15:57:39','2022-08-04 15:57:39',40,'AC_PRODUCT_CREATE','2022-08-04 15:57:39','2022-08-04 03:57:39',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MASA_PARA_SUSPIRO creado','Autor: admin\nProducto MASA_PARA_SUSPIRO creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,382,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (692,692,NULL,1,'2022-08-04 16:18:18','2022-08-04 16:18:18',40,'AC_PRODUCT_CREATE','2022-08-04 16:18:18','2022-08-04 04:18:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MASA_PARA_TIMBRES creado','Autor: admin\nProducto MASA_PARA_TIMBRES creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,383,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (693,693,NULL,1,'2022-08-04 16:23:42','2022-08-04 16:23:42',40,'AC_PRODUCT_CREATE','2022-08-04 16:23:42','2022-08-04 04:23:42',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MASA_PARA_COCO creado','Autor: admin\nProducto MASA_PARA_COCO creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,384,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (694,694,NULL,1,'2022-08-04 16:40:13','2022-08-04 16:40:13',40,'AC_PRODUCT_CREATE','2022-08-04 16:40:13','2022-08-04 04:40:13',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_de_Avena_B.P._500_g creado','Autor: admin\nProducto Galletas_de_Avena_B.P._500_g creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,385,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (695,695,NULL,1,'2022-08-04 16:42:28','2022-08-04 16:42:28',40,'AC_PRODUCT_CREATE','2022-08-04 16:42:28','2022-08-04 04:42:28',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CAJA_AVENA_CAP._16_BP._CON_500_grs._C_U. creado','Autor: admin\nProducto CAJA_AVENA_CAP._16_BP._CON_500_grs._C_U. creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,386,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (696,696,NULL,1,'2022-08-04 16:43:59','2022-08-04 16:43:59',40,'AC_PRODUCT_CREATE','2022-08-04 16:43:59','2022-08-04 04:43:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_de_Avena_8_kg creado','Autor: admin\nProducto Galletas_de_Avena_8_kg creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,387,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (697,697,NULL,1,'2022-08-04 16:44:49','2022-08-04 16:44:49',40,'AC_PRODUCT_CREATE','2022-08-04 16:44:49','2022-08-04 04:44:49',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto ROLLO_PARA_ETIQUETA_TINTA creado','Autor: admin\nProducto ROLLO_PARA_ETIQUETA_TINTA creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,388,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (698,698,NULL,1,'2022-08-04 16:46:10','2022-08-04 16:46:10',40,'AC_PRODUCT_CREATE','2022-08-04 16:46:10','2022-08-04 04:46:10',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_de_Avena_B.P._100_g creado','Autor: admin\nProducto Galletas_de_Avena_B.P._100_g creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,389,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (699,699,NULL,1,'2022-08-04 16:47:26','2022-08-04 16:47:26',40,'AC_PRODUCT_CREATE','2022-08-04 16:47:26','2022-08-04 04:47:26',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto ETIQUETA_IMPRESA_PARA_LA_CAJA creado','Autor: admin\nProducto ETIQUETA_IMPRESA_PARA_LA_CAJA creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,390,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (700,700,NULL,1,'2022-08-04 16:48:27','2022-08-04 16:48:27',40,'AC_PRODUCT_CREATE','2022-08-04 16:48:27','2022-08-04 04:48:27',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_de_Avena_y_Arandano_350_g creado','Autor: admin\nProducto Galletas_de_Avena_y_Arandano_350_g creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,391,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (701,701,NULL,1,'2022-08-04 16:49:58','2022-08-04 16:49:58',40,'AC_PRODUCT_CREATE','2022-08-04 16:49:58','2022-08-04 04:49:58',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto B.P._IMP._GALLETAS_DE_AVENA_Y_ARANDANO_350_g. creado','Autor: admin\nProducto B.P._IMP._GALLETAS_DE_AVENA_Y_ARANDANO_350_g. creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,392,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (702,702,NULL,1,'2022-08-04 16:52:27','2022-08-04 16:52:27',40,'AC_PRODUCT_CREATE','2022-08-04 16:52:27','2022-08-04 04:52:27',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_de_Avena_y_Arandano_8_kg creado','Autor: admin\nProducto Galletas_de_Avena_y_Arandano_8_kg creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,393,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (703,703,NULL,1,'2022-08-04 17:01:55','2022-08-04 17:01:55',40,'AC_PRODUCT_CREATE','2022-08-04 17:01:55','2022-08-04 05:01:55',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Barras_de_Coco_B.P._400_g creado','Autor: admin\nProducto Barras_de_Coco_B.P._400_g creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,394,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (704,704,NULL,1,'2022-08-04 17:03:42','2022-08-04 17:03:42',40,'AC_PRODUCT_CREATE','2022-08-04 17:03:42','2022-08-04 05:03:42',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Barras_de_Coco_Granel_4_Kg creado','Autor: admin\nProducto Barras_de_Coco_Granel_4_Kg creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,395,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (705,705,NULL,1,'2022-08-04 17:06:12','2022-08-04 17:06:12',40,'AC_PRODUCT_CREATE','2022-08-04 17:06:12','2022-08-04 05:06:12',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_Emilias_B.P._80_g creado','Autor: admin\nProducto Galletas_Emilias_B.P._80_g creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,396,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (706,706,NULL,1,'2022-08-04 17:07:26','2022-08-04 17:07:26',40,'AC_PRODUCT_CREATE','2022-08-04 17:07:26','2022-08-04 05:07:26',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto ETIQUETAS_EMILIAS creado','Autor: admin\nProducto ETIQUETAS_EMILIAS creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,397,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (707,707,NULL,1,'2022-08-04 17:11:07','2022-08-04 17:11:07',40,'AC_PRODUCT_CREATE','2022-08-04 17:11:07','2022-08-04 05:11:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_con_Gragea_B.P._500_g creado','Autor: admin\nProducto Galletas_con_Gragea_B.P._500_g creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,398,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (708,708,NULL,1,'2022-08-04 17:16:46','2022-08-04 17:16:46',40,'AC_PRODUCT_CREATE','2022-08-04 17:16:46','2022-08-04 05:16:46',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_con_Gragea_8_kg creado','Autor: admin\nProducto Galletas_con_Gragea_8_kg creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,399,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (709,709,NULL,1,'2022-08-04 17:20:28','2022-08-04 17:20:28',40,'AC_PRODUCT_CREATE','2022-08-04 17:20:28','2022-08-04 05:20:28',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_con_Gragea_B.P._100_g creado','Autor: admin\nProducto Galletas_con_Gragea_B.P._100_g creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,400,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (710,710,NULL,1,'2022-08-04 17:22:30','2022-08-04 17:22:30',40,'AC_PRODUCT_CREATE','2022-08-04 17:22:30','2022-08-04 05:22:30',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_con_Gragea_B.P._100_g_OXXO creado','Autor: admin\nProducto Galletas_con_Gragea_B.P._100_g_OXXO creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,401,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (711,711,NULL,1,'2022-08-04 17:23:53','2022-08-04 17:23:53',40,'AC_PRODUCT_CREATE','2022-08-04 17:23:53','2022-08-04 05:23:53',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_con_Gragea_B.P._400_g creado','Autor: admin\nProducto Galletas_con_Gragea_B.P._400_g creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,402,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (712,712,NULL,1,'2022-08-04 17:25:02','2022-08-04 17:25:02',40,'AC_PRODUCT_CREATE','2022-08-04 17:25:02','2022-08-04 05:25:02',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CAJA_GRAGEA_CAP._20_BP._CON_400_grs.C_U. creado','Autor: admin\nProducto CAJA_GRAGEA_CAP._20_BP._CON_400_grs.C_U. creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,403,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (713,713,NULL,1,'2022-08-04 17:27:31','2022-08-04 17:27:31',40,'AC_BOM_DELETE','2022-08-04 17:27:31','2022-08-04 05:27:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales eliminada','Autor: admin\nLista de materiales eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,34,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (714,714,NULL,1,'2022-08-04 17:27:57','2022-08-04 17:27:57',40,'AC_PRODUCT_CREATE','2022-08-04 17:27:57','2022-08-04 05:27:57',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_Grageas__454g_(1lb)_C_20__Cookies__MX._LA_MOLIENDA creado','Autor: admin\nProducto Galletas_Grageas__454g_(1lb)_C_20__Cookies__MX._LA_MOLIENDA creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,404,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (715,715,NULL,1,'2022-08-04 17:28:45','2022-08-04 17:28:45',40,'AC_PRODUCT_CREATE','2022-08-04 17:28:45','2022-08-04 05:28:45',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto B.P._IMP._GALLETAS_CON_GRAGEA_MOLIENDA creado','Autor: admin\nProducto B.P._IMP._GALLETAS_CON_GRAGEA_MOLIENDA creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,405,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (716,716,NULL,1,'2022-08-04 17:29:31','2022-08-04 17:29:31',40,'AC_PRODUCT_CREATE','2022-08-04 17:29:31','2022-08-04 05:29:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CINTA_CIERRA_BOLSAS_ROJA creado','Autor: admin\nProducto CINTA_CIERRA_BOLSAS_ROJA creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,406,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (717,717,NULL,1,'2022-08-04 17:30:27','2022-08-04 17:30:27',40,'AC_PRODUCT_CREATE','2022-08-04 17:30:27','2022-08-04 05:30:27',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto TARIMA_ESTUFADA creado','Autor: admin\nProducto TARIMA_ESTUFADA creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,407,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (718,718,NULL,1,'2022-08-04 17:35:42','2022-08-04 17:35:42',40,'AC_PRODUCT_CREATE','2022-08-04 17:35:42','2022-08-04 05:35:42',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_Grageas__100g_(3.5_OZ)_C_48__Cookies__MX._LA_MOLIENDA creado','Autor: admin\nProducto Galletas_Grageas__100g_(3.5_OZ)_C_48__Cookies__MX._LA_MOLIENDA creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,408,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (719,719,NULL,1,'2022-08-04 17:36:36','2022-08-04 17:36:36',40,'AC_PRODUCT_CREATE','2022-08-04 17:36:36','2022-08-04 05:36:36',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto B.P._IMP._GALLETAS_CON_GRAGEA_MOLIENDA_100g creado','Autor: admin\nProducto B.P._IMP._GALLETAS_CON_GRAGEA_MOLIENDA_100g creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,409,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (720,720,NULL,1,'2022-08-04 17:39:37','2022-08-04 17:39:37',40,'AC_PRODUCT_CREATE','2022-08-04 17:39:37','2022-08-04 05:39:37',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_con_Gragea_de_Chocolate_B.P._400_g creado','Autor: admin\nProducto Galletas_con_Gragea_de_Chocolate_B.P._400_g creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,410,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (721,721,NULL,1,'2022-08-04 17:40:55','2022-08-04 17:40:55',40,'AC_PRODUCT_CREATE','2022-08-04 17:40:55','2022-08-04 05:40:55',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_con_Gragea_de_Chocolate_8_kg creado','Autor: admin\nProducto Galletas_con_Gragea_de_Chocolate_8_kg creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,411,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (722,722,NULL,1,'2022-08-04 17:42:29','2022-08-04 17:42:29',40,'AC_PRODUCT_CREATE','2022-08-04 17:42:29','2022-08-04 05:42:29',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_Linaza_y_Ajonjoli_B.P._400_g creado','Autor: admin\nProducto Galletas_Linaza_y_Ajonjoli_B.P._400_g creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,412,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (723,723,NULL,1,'2022-08-04 17:44:35','2022-08-04 17:44:35',40,'AC_PRODUCT_CREATE','2022-08-04 17:44:35','2022-08-04 05:44:35',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_Linaza_y_Ajonjoli_8_kg creado','Autor: admin\nProducto Galletas_Linaza_y_Ajonjoli_8_kg creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,413,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (724,724,NULL,1,'2022-08-04 17:45:48','2022-08-04 17:45:48',40,'AC_PRODUCT_CREATE','2022-08-04 17:45:48','2022-08-04 05:45:48',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_Mini_Coco_B.P._500_g creado','Autor: admin\nProducto Galletas_Mini_Coco_B.P._500_g creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,414,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (725,725,NULL,1,'2022-08-04 17:47:07','2022-08-04 17:47:07',40,'AC_PRODUCT_CREATE','2022-08-04 17:47:07','2022-08-04 05:47:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_Mini_Coco_8_kg creado','Autor: admin\nProducto Galletas_Mini_Coco_8_kg creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,415,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (726,726,NULL,1,'2022-08-04 17:48:10','2022-08-04 17:48:10',40,'AC_PRODUCT_CREATE','2022-08-04 17:48:10','2022-08-04 05:48:10',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_Mini_Pizcas_de_Chocolate_B.P._100_g creado','Autor: admin\nProducto Galletas_Mini_Pizcas_de_Chocolate_B.P._100_g creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,416,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (727,727,NULL,1,'2022-08-04 17:59:12','2022-08-04 17:59:12',40,'AC_PRODUCT_CREATE','2022-08-04 17:59:12','2022-08-04 05:59:12',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto B.P._IMP._GALLETAS_MINI_PIZCAS_DE_CHOCOLATE_100_G creado','Autor: admin\nProducto B.P._IMP._GALLETAS_MINI_PIZCAS_DE_CHOCOLATE_100_G creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,417,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (728,728,NULL,1,'2022-08-04 18:01:52','2022-08-04 18:01:52',40,'AC_PRODUCT_CREATE','2022-08-04 18:01:52','2022-08-04 06:01:52',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_con_Pizcas_de_Chocolate_B.P._336_g creado','Autor: admin\nProducto Galletas_con_Pizcas_de_Chocolate_B.P._336_g creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,418,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (729,729,NULL,1,'2022-08-04 18:02:38','2022-08-04 18:02:38',40,'AC_BOM_DELETE','2022-08-04 18:02:38','2022-08-04 06:02:38',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales eliminada','Autor: admin\nLista de materiales eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,43,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (730,730,NULL,1,'2022-08-04 18:03:28','2022-08-04 18:03:28',40,'AC_PRODUCT_CREATE','2022-08-04 18:03:28','2022-08-04 06:03:28',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_Pizcas_con_chocolate_8_kg creado','Autor: admin\nProducto Galletas_Pizcas_con_chocolate_8_kg creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,419,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (731,731,NULL,1,'2022-08-04 18:05:12','2022-08-04 18:05:12',40,'AC_PRODUCT_CREATE','2022-08-04 18:05:12','2022-08-04 06:05:12',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_de_Nuez_con_Glas_B.P._400_g creado','Autor: admin\nProducto Galletas_de_Nuez_con_Glas_B.P._400_g creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,420,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (732,732,NULL,1,'2022-08-04 18:05:54','2022-08-04 18:05:54',40,'AC_PRODUCT_CREATE','2022-08-04 18:05:54','2022-08-04 06:05:54',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_de_Nuez_con_Glas_5_kg creado','Autor: admin\nProducto Galletas_de_Nuez_con_Glas_5_kg creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,421,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (733,733,NULL,1,'2022-08-04 18:07:09','2022-08-04 18:07:09',40,'AC_PRODUCT_CREATE','2022-08-04 18:07:09','2022-08-04 06:07:09',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_de_Vainilla_Flor_de_Cayro_B.P._336_g creado','Autor: admin\nProducto Galletas_de_Vainilla_Flor_de_Cayro_B.P._336_g creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,422,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (734,734,NULL,1,'2022-08-04 18:08:44','2022-08-04 18:08:44',40,'AC_PRODUCT_CREATE','2022-08-04 18:08:44','2022-08-04 06:08:44',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_de_Vainilla_Flor_de_Cayro_4_kg creado','Autor: admin\nProducto Galletas_de_Vainilla_Flor_de_Cayro_4_kg creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,423,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (735,735,NULL,1,'2022-08-04 18:09:56','2022-08-04 18:09:56',40,'AC_PRODUCT_CREATE','2022-08-04 18:09:56','2022-08-04 06:09:56',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Cacahuates_con_Fresa_Caja_granel_4_kg creado','Autor: admin\nProducto Cacahuates_con_Fresa_Caja_granel_4_kg creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,424,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (736,736,NULL,1,'2022-08-04 18:10:56','2022-08-04 18:10:56',40,'AC_PRODUCT_CREATE','2022-08-04 18:10:56','2022-08-04 06:10:56',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Lenguas_Azucaradas_Caja_granel_4_kg creado','Autor: admin\nProducto Lenguas_Azucaradas_Caja_granel_4_kg creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,425,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (737,737,NULL,1,'2022-08-04 18:13:34','2022-08-04 18:13:34',40,'AC_PRODUCT_CREATE','2022-08-04 18:13:34','2022-08-04 06:13:34',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_Marmoleadas_Azucaradas_B.P._400_g creado','Autor: admin\nProducto Galletas_Marmoleadas_Azucaradas_B.P._400_g creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,426,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (738,738,NULL,1,'2022-08-04 18:14:41','2022-08-04 18:14:41',40,'AC_PRODUCT_CREATE','2022-08-04 18:14:41','2022-08-04 06:14:41',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_Marmoleadas_Azucaradas_Caja_granel_4_kg creado','Autor: admin\nProducto Galletas_Marmoleadas_Azucaradas_Caja_granel_4_kg creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,427,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (739,739,NULL,1,'2022-08-04 18:15:43','2022-08-04 18:15:43',40,'AC_PRODUCT_CREATE','2022-08-04 18:15:43','2022-08-04 06:15:43',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_Polvoron_de_Naranja_4_kg creado','Autor: admin\nProducto Galletas_Polvoron_de_Naranja_4_kg creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,428,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (740,740,NULL,1,'2022-08-04 18:16:42','2022-08-04 18:16:42',40,'AC_PRODUCT_CREATE','2022-08-04 18:16:42','2022-08-04 06:16:42',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Orejas_B.P._200_g creado','Autor: admin\nProducto Orejas_B.P._200_g creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,429,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (741,741,NULL,1,'2022-08-04 18:17:58','2022-08-04 18:17:58',40,'AC_PRODUCT_CREATE','2022-08-04 18:17:58','2022-08-04 06:17:58',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Orejas_5_kg creado','Autor: admin\nProducto Orejas_5_kg creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,430,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (742,742,NULL,1,'2022-08-04 18:19:00','2022-08-04 18:19:00',40,'AC_PRODUCT_CREATE','2022-08-04 18:19:00','2022-08-04 06:19:00',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Polvorones_Sevillanos_40_galletas_(Aprox._600_g) creado','Autor: admin\nProducto Polvorones_Sevillanos_40_galletas_(Aprox._600_g) creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,431,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (743,743,NULL,1,'2022-08-04 18:20:15','2022-08-04 18:20:15',40,'AC_PRODUCT_CREATE','2022-08-04 18:20:15','2022-08-04 06:20:15',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Sevillano_4_kg creado','Autor: admin\nProducto Sevillano_4_kg creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,432,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (744,744,NULL,1,'2022-08-04 18:22:07','2022-08-04 18:22:07',40,'AC_PRODUCT_CREATE','2022-08-04 18:22:07','2022-08-04 06:22:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Suspiros_Blister_40_galletas_(Aprox._600_g) creado','Autor: admin\nProducto Suspiros_Blister_40_galletas_(Aprox._600_g) creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,433,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (745,745,NULL,1,'2022-08-04 18:23:45','2022-08-04 18:23:45',40,'AC_PRODUCT_CREATE','2022-08-04 18:23:45','2022-08-04 06:23:45',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Suspiros_4_kg creado','Autor: admin\nProducto Suspiros_4_kg creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,434,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (746,746,NULL,1,'2022-08-04 18:26:54','2022-08-04 18:26:54',40,'AC_PRODUCT_CREATE','2022-08-04 18:26:54','2022-08-04 06:26:54',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_Timbres_de_Fresa_4_kg creado','Autor: admin\nProducto Galletas_Timbres_de_Fresa_4_kg creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,435,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (747,747,NULL,1,'2022-08-04 18:29:25','2022-08-04 18:29:25',40,'AC_PRODUCT_CREATE','2022-08-04 18:29:25','2022-08-04 06:29:25',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galleta_Surtida_Blister_50_galletas_(Aprox._700_g) creado','Autor: admin\nProducto Galleta_Surtida_Blister_50_galletas_(Aprox._700_g) creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,436,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (748,748,NULL,1,'2022-08-04 19:22:41','2022-08-04 19:22:41',40,'AC_BILL_UNVALIDATE','2022-08-04 19:22:41','2022-08-04 07:22:41',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura FA2207-0004 al estado de borrador','Autor: admin\nRegresar factura FA2207-0004 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,4,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (749,749,NULL,1,'2022-08-04 19:23:50','2022-08-04 19:23:50',40,'AC_PRODUCT_DELETE','2022-08-04 19:23:50','2022-08-04 07:23:50',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto ESTA_NO eliminado','Autor: admin\nProducto ESTA_NO eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,207,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (750,750,NULL,1,'2022-08-04 19:39:43','2022-08-04 19:39:43',40,'AC_ORDER_VALIDATE','2022-08-04 19:39:43','2022-08-04 07:39:43',1,NULL,NULL,14336,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0030 validada','Autor: admin\nOrden CO2208-0030 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,36,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (751,751,NULL,1,'2022-08-04 19:43:03','2022-08-04 19:43:03',40,'AC_BOM_VALIDATE','2022-08-04 19:43:03','2022-08-04 07:43:03',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,1,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (752,752,NULL,1,'2022-08-04 19:43:11','2022-08-04 19:43:11',40,'AC_BOM_VALIDATE','2022-08-04 19:43:11','2022-08-04 07:43:11',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,2,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (753,753,NULL,1,'2022-08-04 19:43:22','2022-08-04 19:43:22',40,'AC_BOM_VALIDATE','2022-08-04 19:43:22','2022-08-04 07:43:22',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,3,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (754,754,NULL,1,'2022-08-04 19:43:30','2022-08-04 19:43:30',40,'AC_BOM_VALIDATE','2022-08-04 19:43:30','2022-08-04 07:43:30',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,4,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (755,755,NULL,1,'2022-08-04 19:44:00','2022-08-04 19:44:00',40,'AC_BOM_VALIDATE','2022-08-04 19:44:00','2022-08-04 07:44:00',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,5,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (756,756,NULL,1,'2022-08-04 19:44:14','2022-08-04 19:44:14',40,'AC_BOM_VALIDATE','2022-08-04 19:44:14','2022-08-04 07:44:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,6,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (757,757,NULL,1,'2022-08-04 19:44:25','2022-08-04 19:44:25',40,'AC_BOM_VALIDATE','2022-08-04 19:44:25','2022-08-04 07:44:25',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,7,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (758,758,NULL,1,'2022-08-04 19:47:36','2022-08-04 19:47:36',40,'AC_ORDER_VALIDATE','2022-08-04 19:47:36','2022-08-04 07:47:36',1,NULL,NULL,14336,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0031 validada','Autor: admin\nOrden CO2208-0031 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,37,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (759,759,NULL,1,'2022-08-04 19:52:14','2022-08-04 19:52:14',40,'AC_ORDER_VALIDATE','2022-08-04 19:52:14','2022-08-04 07:52:14',1,NULL,NULL,12928,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0032 validada','Autor: admin\nOrden CO2208-0032 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,38,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (760,760,NULL,1,'2022-08-04 20:55:44','2022-08-04 20:55:44',40,'AC_BOM_VALIDATE','2022-08-04 20:55:44','2022-08-04 08:55:44',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,59,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (761,761,NULL,1,'2022-08-04 20:58:00','2022-08-04 20:58:00',40,'AC_BOM_DELETE','2022-08-04 20:58:00','2022-08-04 08:58:00',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales eliminada','Autor: admin\nLista de materiales eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,64,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (762,762,NULL,1,'2022-08-04 21:01:26','2022-08-04 21:01:26',40,'AC_BOM_VALIDATE','2022-08-04 21:01:26','2022-08-04 09:01:26',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,57,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (763,763,NULL,1,'2022-08-04 21:01:54','2022-08-04 21:01:54',40,'AC_BOM_DELETE','2022-08-04 21:01:54','2022-08-04 09:01:54',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales eliminada','Autor: admin\nLista de materiales eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,63,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (764,764,NULL,1,'2022-08-04 21:02:59','2022-08-04 21:02:59',40,'AC_BOM_VALIDATE','2022-08-04 21:02:59','2022-08-04 09:02:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,48,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (765,765,NULL,1,'2022-08-04 21:04:31','2022-08-04 21:04:31',40,'AC_BOM_VALIDATE','2022-08-04 21:04:31','2022-08-04 09:04:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,62,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (766,766,NULL,1,'2022-08-04 21:21:27','2022-08-04 21:21:27',40,'AC_BOM_VALIDATE','2022-08-04 21:21:27','2022-08-04 09:21:27',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,61,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (767,767,NULL,1,'2022-08-04 21:49:51','2022-08-04 21:49:51',40,'AC_BOM_VALIDATE','2022-08-04 21:49:51','2022-08-04 09:49:51',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,58,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (768,768,NULL,1,'2022-08-04 21:51:26','2022-08-04 21:51:26',40,'AC_BOM_VALIDATE','2022-08-04 21:51:26','2022-08-04 09:51:26',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,56,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (769,769,NULL,1,'2022-08-04 21:52:01','2022-08-04 21:52:01',40,'AC_BOM_UNVALIDATE','2022-08-04 21:52:01','2022-08-04 09:52:01',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,56,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (770,770,NULL,1,'2022-08-04 21:52:06','2022-08-04 21:52:06',40,'AC_BOM_VALIDATE','2022-08-04 21:52:06','2022-08-04 09:52:06',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,56,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (771,771,NULL,1,'2022-08-04 21:54:59','2022-08-04 21:54:59',40,'AC_BOM_VALIDATE','2022-08-04 21:54:59','2022-08-04 09:54:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,55,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (772,772,NULL,1,'2022-08-04 21:56:12','2022-08-04 21:56:12',40,'AC_BOM_VALIDATE','2022-08-04 21:56:12','2022-08-04 09:56:12',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,54,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (773,773,NULL,1,'2022-08-04 22:00:52','2022-08-04 22:00:52',40,'AC_BOM_VALIDATE','2022-08-04 22:00:52','2022-08-04 10:00:52',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,53,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (774,774,NULL,1,'2022-08-04 22:02:08','2022-08-04 22:02:08',40,'AC_BOM_VALIDATE','2022-08-04 22:02:08','2022-08-04 10:02:08',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,52,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (775,775,NULL,1,'2022-08-04 22:03:18','2022-08-04 22:03:18',40,'AC_BOM_VALIDATE','2022-08-04 22:03:18','2022-08-04 10:03:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,51,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (776,776,NULL,1,'2022-08-04 22:06:52','2022-08-04 22:06:52',40,'AC_BOM_VALIDATE','2022-08-04 22:06:52','2022-08-04 10:06:52',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,49,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (777,777,NULL,1,'2022-08-04 22:08:51','2022-08-04 22:08:51',40,'AC_BOM_VALIDATE','2022-08-04 22:08:51','2022-08-04 10:08:51',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,47,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (778,778,NULL,1,'2022-08-04 22:09:45','2022-08-04 22:09:45',40,'AC_BOM_VALIDATE','2022-08-04 22:09:45','2022-08-04 10:09:45',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,46,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (779,779,NULL,1,'2022-08-04 22:11:28','2022-08-04 22:11:28',40,'AC_BOM_VALIDATE','2022-08-04 22:11:28','2022-08-04 10:11:28',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,45,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (780,780,NULL,1,'2022-08-04 22:12:31','2022-08-04 22:12:31',40,'AC_BOM_VALIDATE','2022-08-04 22:12:31','2022-08-04 10:12:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,44,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (781,781,NULL,1,'2022-08-04 22:15:59','2022-08-04 22:15:59',40,'AC_BOM_VALIDATE','2022-08-04 22:15:59','2022-08-04 10:15:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,42,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (782,782,NULL,1,'2022-08-04 22:17:04','2022-08-04 22:17:04',40,'AC_BOM_VALIDATE','2022-08-04 22:17:04','2022-08-04 10:17:04',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,41,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (783,783,NULL,1,'2022-08-04 22:17:56','2022-08-04 22:17:56',40,'AC_BOM_VALIDATE','2022-08-04 22:17:56','2022-08-04 10:17:56',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,40,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (784,784,NULL,1,'2022-08-04 22:19:47','2022-08-04 22:19:47',40,'AC_BOM_VALIDATE','2022-08-04 22:19:47','2022-08-04 10:19:47',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,39,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (785,785,NULL,1,'2022-08-04 22:21:24','2022-08-04 22:21:24',40,'AC_BOM_VALIDATE','2022-08-04 22:21:24','2022-08-04 10:21:24',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,38,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (786,786,NULL,1,'2022-08-04 22:22:24','2022-08-04 22:22:24',40,'AC_BOM_VALIDATE','2022-08-04 22:22:24','2022-08-04 10:22:24',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,37,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (787,787,NULL,1,'2022-08-04 22:27:20','2022-08-04 22:27:20',40,'AC_BOM_VALIDATE','2022-08-04 22:27:20','2022-08-04 10:27:20',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,35,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (788,788,NULL,1,'2022-08-04 22:28:22','2022-08-04 22:28:22',40,'AC_BOM_VALIDATE','2022-08-04 22:28:22','2022-08-04 10:28:22',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,33,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (789,789,NULL,1,'2022-08-04 22:30:03','2022-08-04 22:30:03',40,'AC_BOM_VALIDATE','2022-08-04 22:30:03','2022-08-04 10:30:03',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,32,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (790,790,NULL,1,'2022-08-04 22:31:01','2022-08-04 22:31:01',40,'AC_BOM_VALIDATE','2022-08-04 22:31:01','2022-08-04 10:31:01',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,31,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (791,791,NULL,1,'2022-08-04 22:40:55','2022-08-04 22:40:55',40,'AC_BOM_VALIDATE','2022-08-04 22:40:55','2022-08-04 10:40:55',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,30,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (792,792,NULL,1,'2022-08-04 22:42:07','2022-08-04 22:42:07',40,'AC_BOM_VALIDATE','2022-08-04 22:42:07','2022-08-04 10:42:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,29,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (793,793,NULL,1,'2022-08-04 22:45:09','2022-08-04 22:45:09',40,'AC_BOM_VALIDATE','2022-08-04 22:45:09','2022-08-04 10:45:09',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,27,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (794,794,NULL,1,'2022-08-04 22:45:58','2022-08-04 22:45:58',40,'AC_BOM_VALIDATE','2022-08-04 22:45:58','2022-08-04 10:45:58',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,26,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (795,795,NULL,1,'2022-08-04 22:47:15','2022-08-04 22:47:15',40,'AC_BOM_VALIDATE','2022-08-04 22:47:15','2022-08-04 10:47:15',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,25,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (796,796,NULL,1,'2022-08-04 22:48:11','2022-08-04 22:48:11',40,'AC_BOM_VALIDATE','2022-08-04 22:48:11','2022-08-04 10:48:11',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,24,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (797,797,NULL,1,'2022-08-04 22:51:08','2022-08-04 22:51:08',40,'AC_BOM_VALIDATE','2022-08-04 22:51:08','2022-08-04 10:51:08',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,23,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (798,798,NULL,1,'2022-08-04 22:53:18','2022-08-04 22:53:18',40,'AC_BOM_VALIDATE','2022-08-04 22:53:18','2022-08-04 10:53:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,22,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (799,799,NULL,1,'2022-08-04 22:54:33','2022-08-04 22:54:33',40,'AC_BOM_VALIDATE','2022-08-04 22:54:33','2022-08-04 10:54:33',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,21,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (800,800,NULL,1,'2022-08-04 22:55:19','2022-08-04 22:55:19',40,'AC_BOM_DELETE','2022-08-04 22:55:19','2022-08-04 10:55:19',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales eliminada','Autor: admin\nLista de materiales eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,50,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (801,801,NULL,1,'2022-08-04 22:57:43','2022-08-04 22:57:43',40,'AC_BOM_VALIDATE','2022-08-04 22:57:43','2022-08-04 10:57:43',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,65,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (802,802,NULL,1,'2022-08-04 22:57:48','2022-08-04 22:57:48',40,'AC_BOM_UNVALIDATE','2022-08-04 22:57:48','2022-08-04 10:57:48',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,65,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (803,803,NULL,1,'2022-08-04 22:58:01','2022-08-04 22:58:01',40,'AC_BOM_VALIDATE','2022-08-04 22:58:01','2022-08-04 10:58:01',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,65,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (804,804,NULL,1,'2022-08-04 23:00:34','2022-08-04 23:00:34',40,'AC_PRODUCT_CREATE','2022-08-04 23:00:34','2022-08-04 11:00:34',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto B.P._IMP._GALLETAS_LINAZA_Y_AJONJOLI creado','Autor: admin\nProducto B.P._IMP._GALLETAS_LINAZA_Y_AJONJOLI creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,437,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (805,805,NULL,1,'2022-08-04 23:01:16','2022-08-04 23:01:16',40,'AC_BOM_VALIDATE','2022-08-04 23:01:16','2022-08-04 11:01:16',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,66,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (806,806,NULL,1,'2022-08-04 23:59:01','2022-08-04 23:59:01',40,'AC_ORDER_VALIDATE','2022-08-04 23:59:01','2022-08-04 11:59:01',1,NULL,NULL,14336,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0033 validada','Autor: admin\nOrden CO2208-0033 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,39,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (807,807,NULL,1,'2022-08-05 00:06:30','2022-08-05 00:06:30',40,'AC_ORDER_VALIDATE','2022-08-05 00:06:30','2022-08-04 12:06:30',1,NULL,NULL,14336,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0034 validada','Autor: admin\nOrden CO2208-0034 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,40,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (808,808,NULL,1,'2022-08-05 00:07:38','2022-08-05 00:07:38',40,'AC_ORDER_VALIDATE','2022-08-05 00:07:38','2022-08-04 12:07:38',1,NULL,NULL,14336,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0035 validada','Autor: admin\nOrden CO2208-0035 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,41,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (809,809,NULL,1,'2022-08-05 00:09:51','2022-08-05 00:09:51',40,'AC_ORDER_VALIDATE','2022-08-05 00:09:51','2022-08-04 12:09:51',1,NULL,NULL,14336,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0036 validada','Autor: admin\nOrden CO2208-0036 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,42,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (810,810,NULL,1,'2022-08-05 00:10:34','2022-08-05 00:10:34',40,'AC_ORDER_VALIDATE','2022-08-05 00:10:34','2022-08-04 12:10:34',1,NULL,NULL,14336,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0037 validada','Autor: admin\nOrden CO2208-0037 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,43,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (811,811,NULL,1,'2022-08-05 00:13:04','2022-08-05 00:13:04',40,'AC_ORDER_VALIDATE','2022-08-05 00:13:04','2022-08-04 12:13:04',1,NULL,NULL,14336,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0038 validada','Autor: admin\nOrden CO2208-0038 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,44,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (812,812,NULL,1,'2022-08-05 00:58:54','2022-08-05 00:58:54',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-05 00:58:54','2022-08-04 12:58:54',1,NULL,NULL,3,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0034 validada','Autor: admin\nFactura SI2208-0034 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,54,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (813,813,NULL,1,'2022-08-05 01:22:05','2022-08-05 01:22:05',40,'AC_ORDER_VALIDATE','2022-08-05 01:22:05','2022-08-04 13:22:05',1,NULL,NULL,14336,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0039 validada','Autor: admin\nOrden CO2208-0039 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,45,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (814,814,NULL,1,'2022-08-05 01:26:35','2022-08-05 01:26:35',40,'AC_ORDER_VALIDATE','2022-08-05 01:26:35','2022-08-04 13:26:35',1,NULL,NULL,14336,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0040 validada','Autor: admin\nOrden CO2208-0040 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,46,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (815,815,NULL,1,'2022-08-05 11:59:23','2022-08-05 11:59:23',40,'AC_ORDER_VALIDATE','2022-08-05 11:59:23','2022-08-04 23:59:23',1,NULL,NULL,14336,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0041 validada','Autor: admin\nOrden CO2208-0041 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,47,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (816,816,NULL,1,'2022-08-05 19:40:34','2022-08-05 19:40:34',40,'AC_ORDER_VALIDATE','2022-08-05 19:40:34','2022-08-05 07:40:34',1,NULL,NULL,14336,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0041 validada','Autor: admin\nOrden CO2208-0041 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,47,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (817,817,NULL,1,'2022-08-05 19:48:07','2022-08-05 19:48:07',40,'AC_USER_NEW_PASSWORD','2022-08-05 19:48:07','2022-08-05 07:48:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'PASSWORDInDolibarr','Autor: admin\nPASSWORDInDolibarr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,6,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (818,818,NULL,1,'2022-08-05 19:48:07','2022-08-05 19:48:07',40,'AC_USER_MODIFY','2022-08-05 19:48:07','2022-08-05 07:48:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 6 modificado','Autor: admin\nRegistro 6 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,6,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (819,819,NULL,1,'2022-08-05 19:49:18','2022-08-05 19:49:18',40,'AC_USER_NEW_PASSWORD','2022-08-05 19:49:18','2022-08-05 07:49:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'PASSWORDInDolibarr','Autor: admin\nPASSWORDInDolibarr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,6,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (820,820,NULL,1,'2022-08-05 19:49:18','2022-08-05 19:49:18',40,'AC_USER_MODIFY','2022-08-05 19:49:18','2022-08-05 07:49:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 6 modificado','Autor: admin\nRegistro 6 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,6,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (821,821,NULL,1,'2022-08-05 20:07:07','2022-08-05 20:07:07',40,'AC_PRODUCT_MODIFY','2022-08-05 20:07:07','2022-08-05 08:07:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CBPGADCO modificado','Autor: admin\nProducto CBPGADCO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,319,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (822,822,NULL,1,'2022-08-05 20:07:48','2022-08-05 20:07:48',40,'AC_PRODUCT_DELETE','2022-08-05 20:07:48','2022-08-05 08:07:48',6,NULL,NULL,NULL,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Producto Barras_de_Coco_B.P._400_g eliminado','Autor: egarcia\nProducto Barras_de_Coco_B.P._400_g eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,394,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (823,823,NULL,1,'2022-08-05 20:10:01','2022-08-05 20:10:01',40,'AC_PRODUCT_DELETE','2022-08-05 20:10:01','2022-08-05 08:10:01',6,NULL,NULL,NULL,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Producto Barras_de_Coco_Granel_4_Kg eliminado','Autor: egarcia\nProducto Barras_de_Coco_Granel_4_Kg eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,395,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (824,824,NULL,1,'2022-08-05 20:19:56','2022-08-05 20:19:56',40,'AC_ORDER_VALIDATE','2022-08-05 20:19:56','2022-08-05 08:19:56',1,NULL,NULL,14336,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0042 validada','Autor: admin\nOrden CO2208-0042 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,48,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (825,825,NULL,1,'2022-08-05 20:55:54','2022-08-05 20:55:54',40,'AC_ORDER_VALIDATE','2022-08-05 20:55:54','2022-08-05 08:55:54',1,NULL,NULL,14336,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0043 validada','Autor: admin\nOrden CO2208-0043 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,49,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (826,826,NULL,1,'2022-08-05 20:58:27','2022-08-05 20:58:27',40,'AC_USER_NEW_PASSWORD','2022-08-05 20:58:27','2022-08-05 08:58:27',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'PASSWORDInDolibarr','Autor: admin\nPASSWORDInDolibarr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,1,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (827,827,NULL,1,'2022-08-05 20:58:27','2022-08-05 20:58:27',40,'AC_USER_MODIFY','2022-08-05 20:58:27','2022-08-05 08:58:27',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 1 modificado','Autor: admin\nRegistro 1 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,1,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (828,828,NULL,1,'2022-08-05 21:05:02','2022-08-05 21:05:02',40,'AC_USER_NEW_PASSWORD','2022-08-05 21:05:02','2022-08-05 09:05:02',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'PASSWORDInDolibarr','Autor: admin\nPASSWORDInDolibarr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,4,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (829,829,NULL,1,'2022-08-05 21:05:02','2022-08-05 21:05:02',40,'AC_USER_MODIFY','2022-08-05 21:05:02','2022-08-05 09:05:02',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 4 modificado','Autor: admin\nRegistro 4 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,4,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (830,830,NULL,1,'2022-08-05 21:05:51','2022-08-05 21:05:51',40,'AC_USER_NEW_PASSWORD','2022-08-05 21:05:51','2022-08-05 09:05:51',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'PASSWORDInDolibarr','Autor: admin\nPASSWORDInDolibarr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,5,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (831,831,NULL,1,'2022-08-05 21:05:51','2022-08-05 21:05:51',40,'AC_USER_MODIFY','2022-08-05 21:05:51','2022-08-05 09:05:51',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 5 modificado','Autor: admin\nRegistro 5 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,5,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (832,832,NULL,1,'2022-08-06 13:49:35','2022-08-06 13:49:35',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-06 13:49:35','2022-08-06 01:49:35',5,NULL,NULL,28,NULL,0,5,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0035 validada','Autor: zgomez\nFactura SI2208-0035 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,55,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (833,833,NULL,1,'2022-08-06 19:54:17','2022-08-06 19:54:17',40,'AC_PRODUCT_MODIFY','2022-08-06 19:54:17','2022-08-06 07:54:17',6,NULL,NULL,NULL,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Producto ESTA_NO_B.P._IMP._GALLETAS_DE_AVENA_Y_ARANDANO_350_g. modificado','Autor: egarcia\nProducto ESTA_NO_B.P._IMP._GALLETAS_DE_AVENA_Y_ARANDANO_350_g. modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,392,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (834,834,NULL,1,'2022-08-06 20:56:42','2022-08-06 20:56:42',40,'AC_ORDER_VALIDATE','2022-08-06 20:56:42','2022-08-06 08:56:42',6,NULL,NULL,13785,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0044 validada','Autor: egarcia\nOrden CO2208-0044 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,50,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (835,835,NULL,1,'2022-08-06 23:01:29','2022-08-06 23:01:29',40,'AC_ORDER_VALIDATE','2022-08-06 23:01:29','2022-08-06 11:01:29',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0045 validada','Autor: egarcia\nOrden CO2208-0045 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,51,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (836,836,NULL,1,'2022-08-06 23:08:21','2022-08-06 23:08:21',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-06 23:08:21','2022-08-06 11:08:21',6,NULL,NULL,3,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0036 validada','Autor: egarcia\nFactura SI2208-0036 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,56,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (837,837,NULL,1,'2022-08-07 01:36:02','2022-08-07 01:36:02',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-07 01:36:02','2022-08-06 13:36:02',6,NULL,NULL,3,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0037 validada','Autor: egarcia\nFactura SI2208-0037 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,57,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (838,838,NULL,1,'2022-08-08 13:39:07','2022-08-08 13:39:07',40,'AC_ORDER_VALIDATE','2022-08-08 13:39:07','2022-08-08 01:39:07',4,NULL,NULL,1,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0046 validada','Autor: yrodriguez\nOrden CO2208-0046 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,53,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (839,839,NULL,1,'2022-08-08 13:48:15','2022-08-08 13:48:15',40,'AC_ORDER_VALIDATE','2022-08-08 13:48:15','2022-08-08 01:48:15',4,NULL,NULL,14336,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0047 validada','Autor: yrodriguez\nOrden CO2208-0047 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,54,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (840,840,NULL,1,'2022-08-08 14:13:26','2022-08-08 14:13:26',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-08 14:13:26','2022-08-08 02:13:26',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0038 validada','Autor: yrodriguez\nFactura SI2208-0038 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,58,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (841,841,NULL,1,'2022-08-08 14:16:34','2022-08-08 14:16:34',40,'AC_ORDER_VALIDATE','2022-08-08 14:16:34','2022-08-08 02:16:34',4,NULL,NULL,14336,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0048 validada','Autor: yrodriguez\nOrden CO2208-0048 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,55,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (842,842,NULL,1,'2022-08-08 16:38:14','2022-08-08 16:38:14',40,'AC_USER_MODIFY','2022-08-08 16:38:14','2022-08-08 04:38:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 4 modificado','Autor: admin\nRegistro 4 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,4,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (843,843,NULL,1,'2022-08-08 16:42:01','2022-08-08 16:42:01',40,'AC_USER_MODIFY','2022-08-08 16:42:01','2022-08-08 04:42:01',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 5 modificado','Autor: admin\nRegistro 5 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,5,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (844,844,NULL,1,'2022-08-08 16:42:32','2022-08-08 16:42:32',40,'AC_USER_MODIFY','2022-08-08 16:42:32','2022-08-08 04:42:32',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 6 modificado','Autor: admin\nRegistro 6 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,6,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (845,845,NULL,1,'2022-08-08 18:27:50','2022-08-08 18:27:50',40,'AC_ORDER_VALIDATE','2022-08-08 18:27:50','2022-08-08 06:27:50',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0049 validada','Autor: egarcia\nOrden CO2208-0049 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,56,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (846,846,NULL,1,'2022-08-08 20:21:38','2022-08-08 20:21:38',40,'AC_ORDER_VALIDATE','2022-08-08 20:21:38','2022-08-08 08:21:38',4,NULL,NULL,14336,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0050 validada','Autor: yrodriguez\nOrden CO2208-0050 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,57,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (847,847,NULL,1,'2022-08-08 20:23:10','2022-08-08 20:23:10',40,'AC_ORDER_VALIDATE','2022-08-08 20:23:10','2022-08-08 08:23:10',4,NULL,NULL,13126,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0051 validada','Autor: yrodriguez\nOrden CO2208-0051 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,58,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (848,848,NULL,1,'2022-08-09 00:57:01','2022-08-09 00:57:01',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-09 00:57:01','2022-08-08 12:57:01',6,NULL,NULL,3,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0039 validada','Autor: egarcia\nFactura SI2208-0039 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,59,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (849,849,NULL,1,'2022-08-09 01:29:06','2022-08-09 01:29:06',40,'AC_ORDER_VALIDATE','2022-08-09 01:29:06','2022-08-08 13:29:06',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0052 validada','Autor: egarcia\nOrden CO2208-0052 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,59,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (850,850,NULL,1,'2022-08-09 18:47:38','2022-08-09 18:47:38',40,'AC_ORDER_VALIDATE','2022-08-09 18:47:38','2022-08-09 06:47:38',5,NULL,NULL,14336,NULL,0,5,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0053 validada','Autor: zgomez\nOrden CO2208-0053 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,60,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (851,851,NULL,1,'2022-08-09 18:51:07','2022-08-09 18:51:07',40,'AC_ORDER_VALIDATE','2022-08-09 18:51:07','2022-08-09 06:51:07',5,NULL,NULL,14336,NULL,0,5,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0054 validada','Autor: zgomez\nOrden CO2208-0054 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,61,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (852,852,NULL,1,'2022-08-09 19:02:58','2022-08-09 19:02:58',40,'AC_ORDER_VALIDATE','2022-08-09 19:02:58','2022-08-09 07:02:58',5,NULL,NULL,14336,NULL,0,5,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0055 validada','Autor: zgomez\nOrden CO2208-0055 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,62,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (853,853,NULL,1,'2022-08-09 19:05:48','2022-08-09 19:05:48',40,'AC_ORDER_VALIDATE','2022-08-09 19:05:48','2022-08-09 07:05:48',5,NULL,NULL,14336,NULL,0,5,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0056 validada','Autor: zgomez\nOrden CO2208-0056 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,64,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (854,854,NULL,1,'2022-08-09 19:07:32','2022-08-09 19:07:32',40,'AC_ORDER_VALIDATE','2022-08-09 19:07:32','2022-08-09 07:07:32',5,NULL,NULL,14336,NULL,0,5,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0057 validada','Autor: zgomez\nOrden CO2208-0057 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,63,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (855,855,NULL,1,'2022-08-09 19:11:44','2022-08-09 19:11:44',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-09 19:11:44','2022-08-09 07:11:44',5,NULL,NULL,3,NULL,0,5,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0040 validada','Autor: zgomez\nFactura SI2208-0040 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,60,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (856,856,NULL,1,'2022-08-09 19:14:41','2022-08-09 19:14:41',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-09 19:14:41','2022-08-09 07:14:41',5,NULL,NULL,3,NULL,0,5,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0041 validada','Autor: zgomez\nFactura SI2208-0041 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,62,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (857,857,NULL,1,'2022-08-09 22:35:42','2022-08-09 22:35:42',40,'AC_ORDER_VALIDATE','2022-08-09 22:35:42','2022-08-09 10:35:42',6,NULL,NULL,11789,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0058 validada','Autor: egarcia\nOrden CO2208-0058 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,65,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (858,858,NULL,1,'2022-08-09 22:43:27','2022-08-09 22:43:27',40,'AC_ORDER_VALIDATE','2022-08-09 22:43:27','2022-08-09 10:43:27',6,NULL,NULL,12416,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0059 validada','Autor: egarcia\nOrden CO2208-0059 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,66,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (859,859,NULL,1,'2022-08-09 22:49:45','2022-08-09 22:49:45',40,'AC_ORDER_VALIDATE','2022-08-09 22:49:45','2022-08-09 10:49:45',6,NULL,NULL,10921,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0060 validada','Autor: egarcia\nOrden CO2208-0060 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,67,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (860,860,NULL,1,'2022-08-10 00:16:25','2022-08-10 00:16:25',40,'AC_ORDER_VALIDATE','2022-08-10 00:16:25','2022-08-09 12:16:25',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0061 validada','Autor: egarcia\nOrden CO2208-0061 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,68,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (861,861,NULL,1,'2022-08-10 00:23:28','2022-08-10 00:23:28',40,'AC_ORDER_VALIDATE','2022-08-10 00:23:28','2022-08-09 12:23:28',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0062 validada','Autor: egarcia\nOrden CO2208-0062 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,69,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (862,862,NULL,1,'2022-08-10 00:46:31','2022-08-10 00:46:31',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-10 00:46:31','2022-08-09 12:46:31',6,NULL,NULL,3,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0042 validada','Autor: egarcia\nFactura SI2208-0042 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,63,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (863,863,NULL,1,'2022-08-10 00:53:46','2022-08-10 00:53:46',40,'AC_ORDER_VALIDATE','2022-08-10 00:53:46','2022-08-09 12:53:46',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0063 validada','Autor: egarcia\nOrden CO2208-0063 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,70,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (864,864,NULL,1,'2022-08-10 17:35:01','2022-08-10 17:35:01',40,'AC_ORDER_VALIDATE','2022-08-10 17:35:01','2022-08-10 05:35:01',4,NULL,NULL,13209,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0064 validada','Autor: yrodriguez\nOrden CO2208-0064 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,71,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (865,865,NULL,1,'2022-08-10 19:50:31','2022-08-10 19:50:31',40,'AC_ORDER_VALIDATE','2022-08-10 19:50:31','2022-08-10 07:50:31',6,NULL,NULL,12660,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0065 validada','Autor: egarcia\nOrden CO2208-0065 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,72,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (866,866,NULL,1,'2022-08-10 20:18:05','2022-08-10 20:18:05',40,'AC_ORDER_VALIDATE','2022-08-10 20:18:05','2022-08-10 08:18:05',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0066 validada','Autor: egarcia\nOrden CO2208-0066 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,73,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (867,867,NULL,1,'2022-08-10 20:21:51','2022-08-10 20:21:51',40,'AC_ORDER_VALIDATE','2022-08-10 20:21:51','2022-08-10 08:21:51',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0067 validada','Autor: egarcia\nOrden CO2208-0067 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,74,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (868,868,NULL,1,'2022-08-11 00:46:56','2022-08-11 00:46:56',40,'AC_ORDER_VALIDATE','2022-08-11 00:46:56','2022-08-10 12:46:56',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0068 validada','Autor: egarcia\nOrden CO2208-0068 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,75,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (869,869,NULL,1,'2022-08-11 01:28:10','2022-08-11 01:28:10',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-11 01:28:10','2022-08-10 13:28:10',6,NULL,NULL,3,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0043 validada','Autor: egarcia\nFactura SI2208-0043 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,64,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (870,870,NULL,1,'2022-08-11 18:36:42','2022-08-11 18:36:42',40,'AC_BOM_UNVALIDATE','2022-08-11 18:36:42','2022-08-11 06:36:42',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,29,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (871,871,NULL,1,'2022-08-11 18:56:26','2022-08-11 18:56:26',40,'AC_ORDER_VALIDATE','2022-08-11 18:56:26','2022-08-11 06:56:26',4,NULL,NULL,12959,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0069 validada','Autor: yrodriguez\nOrden CO2208-0069 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,76,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (872,872,NULL,1,'2022-08-11 19:05:57','2022-08-11 19:05:57',40,'AC_ORDER_VALIDATE','2022-08-11 19:05:57','2022-08-11 07:05:57',4,NULL,NULL,14336,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0070 validada','Autor: yrodriguez\nOrden CO2208-0070 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,77,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (873,873,NULL,1,'2022-08-11 19:12:24','2022-08-11 19:12:24',40,'AC_PRODUCT_MODIFY','2022-08-11 19:12:24','2022-08-11 07:12:24',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_con_Gragea_B.P._500_g modificado','Autor: admin\nProducto Galletas_con_Gragea_B.P._500_g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,398,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (874,874,NULL,1,'2022-08-11 19:13:01','2022-08-11 19:13:01',40,'AC_ORDER_VALIDATE','2022-08-11 19:13:01','2022-08-11 07:13:01',4,NULL,NULL,14336,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0071 validada','Autor: yrodriguez\nOrden CO2208-0071 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,78,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (875,875,NULL,1,'2022-08-11 19:13:59','2022-08-11 19:13:59',40,'AC_PRODUCT_MODIFY','2022-08-11 19:13:59','2022-08-11 07:13:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_con_Gragea_B.P._500_g modificado','Autor: admin\nProducto Galletas_con_Gragea_B.P._500_g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,398,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (876,876,NULL,1,'2022-08-11 19:37:42','2022-08-11 19:37:42',40,'AC_PRODUCT_MODIFY','2022-08-11 19:37:42','2022-08-11 07:37:42',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_con_Gragea_B.P._500_g modificado','Autor: admin\nProducto Galletas_con_Gragea_B.P._500_g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,398,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (877,877,NULL,1,'2022-08-11 19:46:23','2022-08-11 19:46:23',40,'AC_PRODUCT_MODIFY','2022-08-11 19:46:23','2022-08-11 07:46:23',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_de_Avena_B.P._500_g modificado','Autor: admin\nProducto Galletas_de_Avena_B.P._500_g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,385,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (878,878,NULL,1,'2022-08-11 19:46:59','2022-08-11 19:46:59',40,'AC_ORDER_VALIDATE','2022-08-11 19:46:59','2022-08-11 07:46:59',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0072 validada','Autor: egarcia\nOrden CO2208-0072 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,79,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (879,879,NULL,1,'2022-08-11 19:50:59','2022-08-11 19:50:59',40,'AC_PRODUCT_MODIFY','2022-08-11 19:50:59','2022-08-11 07:50:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_de_Avena_B.P._500_g modificado','Autor: admin\nProducto Galletas_de_Avena_B.P._500_g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,385,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (880,880,NULL,1,'2022-08-11 19:52:23','2022-08-11 19:52:23',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-11 19:52:23','2022-08-11 07:52:23',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0044 validada','Autor: yrodriguez\nFactura SI2208-0044 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,65,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (881,881,NULL,1,'2022-08-11 19:55:24','2022-08-11 19:55:24',40,'AC_PRODUCT_MODIFY','2022-08-11 19:55:24','2022-08-11 07:55:24',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_Mini_Coco_B.P._500_g modificado','Autor: admin\nProducto Galletas_Mini_Coco_B.P._500_g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,414,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (882,882,NULL,1,'2022-08-11 19:57:35','2022-08-11 19:57:35',40,'AC_PRODUCT_MODIFY','2022-08-11 19:57:35','2022-08-11 07:57:35',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_Mini_Coco_B.P._500_g modificado','Autor: admin\nProducto Galletas_Mini_Coco_B.P._500_g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,414,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (883,883,NULL,1,'2022-08-11 20:02:02','2022-08-11 20:02:02',40,'AC_PRODUCT_MODIFY','2022-08-11 20:02:02','2022-08-11 08:02:02',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_con_Gragea_de_Chocolate_B.P._400_g modificado','Autor: admin\nProducto Galletas_con_Gragea_de_Chocolate_B.P._400_g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,410,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (884,884,NULL,1,'2022-08-11 20:04:16','2022-08-11 20:04:16',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-11 20:04:16','2022-08-11 08:04:16',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0045 validada','Autor: yrodriguez\nFactura SI2208-0045 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,66,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (885,885,NULL,1,'2022-08-11 20:08:31','2022-08-11 20:08:31',40,'AC_PRODUCT_MODIFY','2022-08-11 20:08:31','2022-08-11 08:08:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_con_Gragea_de_Chocolate_B.P._400_g modificado','Autor: admin\nProducto Galletas_con_Gragea_de_Chocolate_B.P._400_g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,410,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (886,886,NULL,1,'2022-08-11 20:11:35','2022-08-11 20:11:35',40,'AC_PRODUCT_MODIFY','2022-08-11 20:11:35','2022-08-11 08:11:35',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MASA_PARA_BARRAS_DE_COCO modificado','Autor: admin\nProducto MASA_PARA_BARRAS_DE_COCO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,368,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (887,887,NULL,1,'2022-08-11 20:12:29','2022-08-11 20:12:29',40,'AC_PRODUCT_MODIFY','2022-08-11 20:12:29','2022-08-11 08:12:29',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MASA_PARA_BARRAS_DE_COCO modificado','Autor: admin\nProducto MASA_PARA_BARRAS_DE_COCO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,368,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (888,888,NULL,1,'2022-08-11 20:14:39','2022-08-11 20:14:39',40,'AC_PRODUCT_MODIFY','2022-08-11 20:14:39','2022-08-11 08:14:39',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MASA_PARA_BARRAS_DE_COCO modificado','Autor: admin\nProducto MASA_PARA_BARRAS_DE_COCO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,368,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (889,889,NULL,1,'2022-08-11 20:18:03','2022-08-11 20:18:03',40,'AC_PRODUCT_MODIFY','2022-08-11 20:18:03','2022-08-11 08:18:03',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_con_Gragea_B.P._400_g modificado','Autor: admin\nProducto Galletas_con_Gragea_B.P._400_g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,402,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (890,890,NULL,1,'2022-08-11 20:32:39','2022-08-11 20:32:39',40,'AC_BOM_UNVALIDATE','2022-08-11 20:32:39','2022-08-11 08:32:39',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,21,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (891,891,NULL,1,'2022-08-11 20:39:46','2022-08-11 20:39:46',40,'AC_BOM_UNVALIDATE','2022-08-11 20:39:46','2022-08-11 08:39:46',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,22,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (892,892,NULL,1,'2022-08-11 20:44:11','2022-08-11 20:44:11',40,'AC_BOM_UNVALIDATE','2022-08-11 20:44:11','2022-08-11 08:44:11',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,23,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (893,893,NULL,1,'2022-08-11 20:46:12','2022-08-11 20:46:12',40,'AC_BOM_UNVALIDATE','2022-08-11 20:46:12','2022-08-11 08:46:12',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,25,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (894,894,NULL,1,'2022-08-11 20:47:42','2022-08-11 20:47:42',40,'AC_BOM_UNVALIDATE','2022-08-11 20:47:42','2022-08-11 08:47:42',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,26,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (895,895,NULL,1,'2022-08-11 20:49:00','2022-08-11 20:49:00',40,'AC_BOM_UNVALIDATE','2022-08-11 20:49:00','2022-08-11 08:49:00',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,27,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (896,896,NULL,1,'2022-08-11 20:57:13','2022-08-11 20:57:13',40,'AC_BOM_UNVALIDATE','2022-08-11 20:57:13','2022-08-11 08:57:13',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,31,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (897,897,NULL,1,'2022-08-11 21:37:25','2022-08-11 21:37:25',40,'AC_BOM_UNVALIDATE','2022-08-11 21:37:25','2022-08-11 09:37:25',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,32,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (898,898,NULL,1,'2022-08-11 21:38:24','2022-08-11 21:38:24',40,'AC_BOM_UNVALIDATE','2022-08-11 21:38:24','2022-08-11 09:38:24',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,33,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (899,899,NULL,1,'2022-08-11 21:40:21','2022-08-11 21:40:21',40,'AC_BOM_UNVALIDATE','2022-08-11 21:40:21','2022-08-11 09:40:21',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,35,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (900,900,NULL,1,'2022-08-11 21:43:22','2022-08-11 21:43:22',40,'AC_BOM_UNVALIDATE','2022-08-11 21:43:22','2022-08-11 09:43:22',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,37,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (901,901,NULL,1,'2022-08-11 21:49:43','2022-08-11 21:49:43',40,'AC_BOM_UNVALIDATE','2022-08-11 21:49:43','2022-08-11 09:49:43',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,39,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (902,902,NULL,1,'2022-08-11 21:51:07','2022-08-11 21:51:07',40,'AC_BOM_UNVALIDATE','2022-08-11 21:51:07','2022-08-11 09:51:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,40,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (903,903,NULL,1,'2022-08-11 21:51:36','2022-08-11 21:51:36',40,'AC_ORDER_VALIDATE','2022-08-11 21:51:36','2022-08-11 09:51:36',4,NULL,NULL,12314,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0073 validada','Autor: yrodriguez\nOrden CO2208-0073 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,80,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (904,904,NULL,1,'2022-08-11 21:54:34','2022-08-11 21:54:34',40,'AC_BOM_UNVALIDATE','2022-08-11 21:54:34','2022-08-11 09:54:34',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,44,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (905,905,NULL,1,'2022-08-11 21:57:03','2022-08-11 21:57:03',40,'AC_BOM_UNVALIDATE','2022-08-11 21:57:03','2022-08-11 09:57:03',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,46,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (906,906,NULL,1,'2022-08-11 21:57:59','2022-08-11 21:57:59',40,'AC_BOM_UNVALIDATE','2022-08-11 21:57:59','2022-08-11 09:57:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,48,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (907,907,NULL,1,'2022-08-11 21:59:11','2022-08-11 21:59:11',40,'AC_BOM_UNVALIDATE','2022-08-11 21:59:11','2022-08-11 09:59:11',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,52,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (908,908,NULL,1,'2022-08-11 21:59:56','2022-08-11 21:59:56',40,'AC_BOM_VALIDATE','2022-08-11 21:59:56','2022-08-11 09:59:56',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,52,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (909,909,NULL,1,'2022-08-11 22:00:43','2022-08-11 22:00:43',40,'AC_BOM_UNVALIDATE','2022-08-11 22:00:43','2022-08-11 10:00:43',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,55,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (910,910,NULL,1,'2022-08-11 22:01:18','2022-08-11 22:01:18',40,'AC_BOM_VALIDATE','2022-08-11 22:01:18','2022-08-11 10:01:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,55,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (911,911,NULL,1,'2022-08-11 22:06:00','2022-08-11 22:06:00',40,'AC_BOM_UNVALIDATE','2022-08-11 22:06:00','2022-08-11 10:06:00',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,66,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (912,912,NULL,1,'2022-08-11 22:06:27','2022-08-11 22:06:27',40,'AC_BOM_VALIDATE','2022-08-11 22:06:27','2022-08-11 10:06:27',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,66,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (913,913,NULL,1,'2022-08-11 22:08:51','2022-08-11 22:08:51',40,'AC_PRODUCT_DELETE','2022-08-11 22:08:51','2022-08-11 10:08:51',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_de_Avena_B.P._500_g eliminado','Autor: admin\nProducto Galletas_de_Avena_B.P._500_g eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,385,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (914,914,NULL,1,'2022-08-11 22:09:19','2022-08-11 22:09:19',40,'AC_PRODUCT_DELETE','2022-08-11 22:09:19','2022-08-11 10:09:19',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_de_Avena_B.P._100_g eliminado','Autor: admin\nProducto Galletas_de_Avena_B.P._100_g eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,389,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (915,915,NULL,1,'2022-08-11 22:09:34','2022-08-11 22:09:34',40,'AC_PRODUCT_DELETE','2022-08-11 22:09:34','2022-08-11 10:09:34',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_de_Avena_y_Arandano_350_g eliminado','Autor: admin\nProducto Galletas_de_Avena_y_Arandano_350_g eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,391,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (916,916,NULL,1,'2022-08-11 22:13:24','2022-08-11 22:13:24',40,'AC_ORDER_VALIDATE','2022-08-11 22:13:24','2022-08-11 10:13:24',6,NULL,NULL,13799,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0074 validada','Autor: egarcia\nOrden CO2208-0074 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,81,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (917,917,NULL,1,'2022-08-11 22:15:59','2022-08-11 22:15:59',40,'AC_PRODUCT_DELETE','2022-08-11 22:15:59','2022-08-11 10:15:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_con_Gragea_B.P._500_g eliminado','Autor: admin\nProducto Galletas_con_Gragea_B.P._500_g eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,398,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (918,918,NULL,1,'2022-08-11 22:16:45','2022-08-11 22:16:45',40,'AC_ORDER_VALIDATE','2022-08-11 22:16:45','2022-08-11 10:16:45',6,NULL,NULL,13798,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0075 validada','Autor: egarcia\nOrden CO2208-0075 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,82,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (919,919,NULL,1,'2022-08-11 22:30:50','2022-08-11 22:30:50',40,'AC_PRODUCT_DELETE','2022-08-11 22:30:50','2022-08-11 10:30:50',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_con_Gragea_B.P._400_g eliminado','Autor: admin\nProducto Galletas_con_Gragea_B.P._400_g eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,402,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (920,920,NULL,1,'2022-08-11 22:31:31','2022-08-11 22:31:31',40,'AC_PRODUCT_DELETE','2022-08-11 22:31:31','2022-08-11 10:31:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_con_Gragea_B.P._100_g eliminado','Autor: admin\nProducto Galletas_con_Gragea_B.P._100_g eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,400,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (921,921,NULL,1,'2022-08-11 22:31:57','2022-08-11 22:31:57',40,'AC_PRODUCT_DELETE','2022-08-11 22:31:57','2022-08-11 10:31:57',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_con_Gragea_B.P._100_g_OXXO eliminado','Autor: admin\nProducto Galletas_con_Gragea_B.P._100_g_OXXO eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,401,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (922,922,NULL,1,'2022-08-11 22:56:17','2022-08-11 22:56:17',40,'AC_PRODUCT_DELETE','2022-08-11 22:56:17','2022-08-11 10:56:17',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_Mini_Coco_B.P._500_g eliminado','Autor: admin\nProducto Galletas_Mini_Coco_B.P._500_g eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,414,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (923,923,NULL,1,'2022-08-11 22:58:17','2022-08-11 22:58:17',40,'AC_BOM_VALIDATE','2022-08-11 22:58:17','2022-08-11 10:58:17',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,44,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (924,924,NULL,1,'2022-08-11 22:59:24','2022-08-11 22:59:24',40,'AC_PRODUCT_DELETE','2022-08-11 22:59:24','2022-08-11 10:59:24',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_de_Nuez_con_Glas_B.P._400_g eliminado','Autor: admin\nProducto Galletas_de_Nuez_con_Glas_B.P._400_g eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,420,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (925,925,NULL,1,'2022-08-11 22:59:31','2022-08-11 22:59:31',40,'AC_BOM_VALIDATE','2022-08-11 22:59:31','2022-08-11 10:59:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,46,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (926,926,NULL,1,'2022-08-11 23:08:38','2022-08-11 23:08:38',40,'AC_PRODUCT_DELETE','2022-08-11 23:08:38','2022-08-11 11:08:38',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_de_Vainilla_Flor_de_Cayro_B.P._336_g eliminado','Autor: admin\nProducto Galletas_de_Vainilla_Flor_de_Cayro_B.P._336_g eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,422,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (927,927,NULL,1,'2022-08-11 23:10:00','2022-08-11 23:10:00',40,'AC_PRODUCT_DELETE','2022-08-11 23:10:00','2022-08-11 11:10:00',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_Marmoleadas_Azucaradas_B.P._400_g eliminado','Autor: admin\nProducto Galletas_Marmoleadas_Azucaradas_B.P._400_g eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,426,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (928,928,NULL,1,'2022-08-11 23:13:12','2022-08-11 23:13:12',40,'AC_PRODUCT_DELETE','2022-08-11 23:13:12','2022-08-11 11:13:12',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Orejas_B.P._200_g eliminado','Autor: admin\nProducto Orejas_B.P._200_g eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,429,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (929,929,NULL,1,'2022-08-11 23:14:29','2022-08-11 23:14:29',40,'AC_PRODUCT_DELETE','2022-08-11 23:14:29','2022-08-11 11:14:29',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_Linaza_y_Ajonjoli_B.P._400_g eliminado','Autor: admin\nProducto Galletas_Linaza_y_Ajonjoli_B.P._400_g eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,412,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (930,930,NULL,1,'2022-08-11 23:16:13','2022-08-11 23:16:13',40,'AC_BOM_VALIDATE','2022-08-11 23:16:13','2022-08-11 11:16:13',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,21,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (931,931,NULL,1,'2022-08-11 23:16:31','2022-08-11 23:16:31',40,'AC_BOM_VALIDATE','2022-08-11 23:16:31','2022-08-11 11:16:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,26,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (932,932,NULL,1,'2022-08-11 23:16:55','2022-08-11 23:16:55',40,'AC_BOM_VALIDATE','2022-08-11 23:16:55','2022-08-11 11:16:55',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,31,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (933,933,NULL,1,'2022-08-11 23:17:07','2022-08-11 23:17:07',40,'AC_BOM_VALIDATE','2022-08-11 23:17:07','2022-08-11 11:17:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,32,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (934,934,NULL,1,'2022-08-11 23:17:17','2022-08-11 23:17:17',40,'AC_BOM_VALIDATE','2022-08-11 23:17:17','2022-08-11 11:17:17',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,33,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (935,935,NULL,1,'2022-08-11 23:17:41','2022-08-11 23:17:41',40,'AC_BOM_VALIDATE','2022-08-11 23:17:41','2022-08-11 11:17:41',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,36,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (936,936,NULL,1,'2022-08-11 23:18:05','2022-08-11 23:18:05',40,'AC_BOM_VALIDATE','2022-08-11 23:18:05','2022-08-11 11:18:05',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,37,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (937,937,NULL,1,'2022-08-11 23:18:17','2022-08-11 23:18:17',40,'AC_BOM_VALIDATE','2022-08-11 23:18:17','2022-08-11 11:18:17',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,40,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (938,938,NULL,1,'2022-08-11 23:18:31','2022-08-11 23:18:31',40,'AC_BOM_VALIDATE','2022-08-11 23:18:31','2022-08-11 11:18:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,48,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (939,939,NULL,1,'2022-08-11 23:18:46','2022-08-11 23:18:46',40,'AC_BOM_VALIDATE','2022-08-11 23:18:46','2022-08-11 11:18:46',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,8,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (940,940,NULL,1,'2022-08-11 23:18:56','2022-08-11 23:18:56',40,'AC_BOM_VALIDATE','2022-08-11 23:18:56','2022-08-11 11:18:56',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,9,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (941,941,NULL,1,'2022-08-11 23:19:06','2022-08-11 23:19:06',40,'AC_BOM_VALIDATE','2022-08-11 23:19:06','2022-08-11 11:19:06',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,10,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (942,942,NULL,1,'2022-08-11 23:19:18','2022-08-11 23:19:18',40,'AC_BOM_VALIDATE','2022-08-11 23:19:18','2022-08-11 11:19:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,11,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (943,943,NULL,1,'2022-08-11 23:19:29','2022-08-11 23:19:29',40,'AC_BOM_VALIDATE','2022-08-11 23:19:29','2022-08-11 11:19:29',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,12,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (944,944,NULL,1,'2022-08-11 23:19:38','2022-08-11 23:19:38',40,'AC_BOM_VALIDATE','2022-08-11 23:19:38','2022-08-11 11:19:38',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (945,945,NULL,1,'2022-08-11 23:20:27','2022-08-11 23:20:27',40,'AC_BOM_VALIDATE','2022-08-11 23:20:27','2022-08-11 11:20:27',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,14,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (946,946,NULL,1,'2022-08-11 23:20:38','2022-08-11 23:20:38',40,'AC_BOM_VALIDATE','2022-08-11 23:20:38','2022-08-11 11:20:38',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,15,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (947,947,NULL,1,'2022-08-11 23:20:48','2022-08-11 23:20:48',40,'AC_BOM_VALIDATE','2022-08-11 23:20:48','2022-08-11 11:20:48',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,16,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (948,948,NULL,1,'2022-08-11 23:20:56','2022-08-11 23:20:56',40,'AC_BOM_VALIDATE','2022-08-11 23:20:56','2022-08-11 11:20:56',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,17,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (949,949,NULL,1,'2022-08-11 23:21:04','2022-08-11 23:21:04',40,'AC_BOM_VALIDATE','2022-08-11 23:21:04','2022-08-11 11:21:04',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,18,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (950,950,NULL,1,'2022-08-11 23:21:15','2022-08-11 23:21:15',40,'AC_BOM_VALIDATE','2022-08-11 23:21:15','2022-08-11 11:21:15',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,19,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (951,951,NULL,1,'2022-08-11 23:21:25','2022-08-11 23:21:25',40,'AC_BOM_VALIDATE','2022-08-11 23:21:25','2022-08-11 11:21:25',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,20,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (952,952,NULL,1,'2022-08-11 23:21:38','2022-08-11 23:21:38',40,'AC_BOM_VALIDATE','2022-08-11 23:21:38','2022-08-11 11:21:38',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,29,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (953,953,NULL,1,'2022-08-11 23:21:52','2022-08-11 23:21:52',40,'AC_BOM_VALIDATE','2022-08-11 23:21:52','2022-08-11 11:21:52',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,23,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (954,954,NULL,1,'2022-08-11 23:22:13','2022-08-11 23:22:13',40,'AC_BOM_UNVALIDATE','2022-08-11 23:22:13','2022-08-11 11:22:13',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,41,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (955,955,NULL,1,'2022-08-11 23:22:35','2022-08-11 23:22:35',40,'AC_BOM_UNVALIDATE','2022-08-11 23:22:35','2022-08-11 11:22:35',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,30,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (956,956,NULL,1,'2022-08-11 23:22:48','2022-08-11 23:22:48',40,'AC_BOM_UNVALIDATE','2022-08-11 23:22:48','2022-08-11 11:22:48',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,38,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (957,957,NULL,1,'2022-08-11 23:22:58','2022-08-11 23:22:58',40,'AC_BOM_UNVALIDATE','2022-08-11 23:22:58','2022-08-11 11:22:58',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,45,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (958,958,NULL,1,'2022-08-11 23:23:07','2022-08-11 23:23:07',40,'AC_BOM_UNVALIDATE','2022-08-11 23:23:07','2022-08-11 11:23:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,47,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (959,959,NULL,1,'2022-08-11 23:23:26','2022-08-11 23:23:26',40,'AC_BOM_UNVALIDATE','2022-08-11 23:23:26','2022-08-11 11:23:26',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,49,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (960,960,NULL,1,'2022-08-11 23:23:28','2022-08-11 23:23:28',40,'AC_BOM_UNVALIDATE','2022-08-11 23:23:28','2022-08-11 11:23:28',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,51,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (961,961,NULL,1,'2022-08-11 23:23:32','2022-08-11 23:23:32',40,'AC_BOM_UNVALIDATE','2022-08-11 23:23:32','2022-08-11 11:23:32',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,54,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (962,962,NULL,1,'2022-08-11 23:23:53','2022-08-11 23:23:53',40,'AC_BOM_UNVALIDATE','2022-08-11 23:23:53','2022-08-11 11:23:53',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,56,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (963,963,NULL,1,'2022-08-11 23:23:55','2022-08-11 23:23:55',40,'AC_BOM_UNVALIDATE','2022-08-11 23:23:55','2022-08-11 11:23:55',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,58,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (964,964,NULL,1,'2022-08-11 23:23:58','2022-08-11 23:23:58',40,'AC_BOM_UNVALIDATE','2022-08-11 23:23:58','2022-08-11 11:23:58',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,65,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (965,965,NULL,1,'2022-08-11 23:24:10','2022-08-11 23:24:10',40,'AC_BOM_UNVALIDATE','2022-08-11 23:24:10','2022-08-11 11:24:10',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,61,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (966,966,NULL,1,'2022-08-12 00:07:57','2022-08-12 00:07:57',40,'AC_ORDER_VALIDATE','2022-08-12 00:07:57','2022-08-11 12:07:57',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0076 validada','Autor: egarcia\nOrden CO2208-0076 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,83,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (967,967,NULL,1,'2022-08-12 00:09:59','2022-08-12 00:09:59',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-12 00:09:59','2022-08-11 12:09:59',6,NULL,NULL,3,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0046 validada','Autor: egarcia\nFactura SI2208-0046 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,68,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (968,968,NULL,1,'2022-08-12 14:56:26','2022-08-12 14:56:26',40,'AC_PRODUCT_MODIFY','2022-08-12 14:56:26','2022-08-12 02:56:26',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR500G modificado','Autor: admin\nProducto BPGR500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,205,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (969,969,NULL,1,'2022-08-12 15:22:23','2022-08-12 15:22:23',40,'AC_PRODUCT_MODIFY','2022-08-12 15:22:23','2022-08-12 03:22:23',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR500G modificado','Autor: admin\nProducto BPGR500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,205,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (970,970,NULL,1,'2022-08-12 15:23:47','2022-08-12 15:23:47',40,'AC_PRODUCT_MODIFY','2022-08-12 15:23:47','2022-08-12 03:23:47',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPAVE500G modificado','Autor: admin\nProducto BPAVE500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,203,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (971,971,NULL,1,'2022-08-12 15:25:34','2022-08-12 15:25:34',40,'AC_PRODUCT_MODIFY','2022-08-12 15:25:34','2022-08-12 03:25:34',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPMI500G modificado','Autor: admin\nProducto BPMI500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,206,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (972,972,NULL,1,'2022-08-12 15:30:14','2022-08-12 15:30:14',40,'AC_PRODUCT_MODIFY','2022-08-12 15:30:14','2022-08-12 03:30:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGCH400G modificado','Autor: admin\nProducto BPGCH400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,280,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (973,973,NULL,1,'2022-08-12 15:32:19','2022-08-12 15:32:19',40,'AC_PRODUCT_MODIFY','2022-08-12 15:32:19','2022-08-12 03:32:19',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR400G modificado','Autor: admin\nProducto BPGR400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,338,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (974,974,NULL,1,'2022-08-12 15:33:09','2022-08-12 15:33:09',40,'AC_PRODUCT_MODIFY','2022-08-12 15:33:09','2022-08-12 03:33:09',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPLYA400G modificado','Autor: admin\nProducto BPLYA400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,208,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (975,975,NULL,1,'2022-08-12 15:35:07','2022-08-12 15:35:07',40,'AC_PRODUCT_MODIFY','2022-08-12 15:35:07','2022-08-12 03:35:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPMA400G modificado','Autor: admin\nProducto BPMA400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,210,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (976,976,NULL,1,'2022-08-12 15:36:09','2022-08-12 15:36:09',40,'AC_PRODUCT_MODIFY','2022-08-12 15:36:09','2022-08-12 03:36:09',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPNU400G modificado','Autor: admin\nProducto BPNU400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,211,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (977,977,NULL,1,'2022-08-12 15:36:52','2022-08-12 15:36:52',40,'AC_PRODUCT_MODIFY','2022-08-12 15:36:52','2022-08-12 03:36:52',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPAA350G modificado','Autor: admin\nProducto BPAA350G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,209,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (978,978,NULL,1,'2022-08-12 15:38:14','2022-08-12 15:38:14',40,'AC_PRODUCT_MODIFY','2022-08-12 15:38:14','2022-08-12 03:38:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPFL336G modificado','Autor: admin\nProducto BPFL336G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,212,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (979,979,NULL,1,'2022-08-12 15:38:49','2022-08-12 15:38:49',40,'AC_PRODUCT_MODIFY','2022-08-12 15:38:49','2022-08-12 03:38:49',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BNPPIZ336G modificado','Autor: admin\nProducto BNPPIZ336G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,215,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (980,980,NULL,1,'2022-08-12 15:39:38','2022-08-12 15:39:38',40,'AC_PRODUCT_MODIFY','2022-08-12 15:39:38','2022-08-12 03:39:38',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPOR200G modificado','Autor: admin\nProducto BPOR200G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,213,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (981,981,NULL,1,'2022-08-12 15:40:48','2022-08-12 15:40:48',40,'AC_PRODUCT_MODIFY','2022-08-12 15:40:48','2022-08-12 03:40:48',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR100G modificado','Autor: admin\nProducto BPGR100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,279,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (982,982,NULL,1,'2022-08-12 15:41:55','2022-08-12 15:41:55',40,'AC_PRODUCT_MODIFY','2022-08-12 15:41:55','2022-08-12 03:41:55',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPAVE100G modificado','Autor: admin\nProducto BPAVE100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,219,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (983,983,NULL,1,'2022-08-12 15:42:31','2022-08-12 15:42:31',40,'AC_PRODUCT_MODIFY','2022-08-12 15:42:31','2022-08-12 03:42:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPPIZ100G modificado','Autor: admin\nProducto BPPIZ100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,278,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (984,984,NULL,1,'2022-08-12 15:43:17','2022-08-12 15:43:17',40,'AC_PRODUCT_MODIFY','2022-08-12 15:43:17','2022-08-12 03:43:17',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPTDF84G modificado','Autor: admin\nProducto BPTDF84G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,230,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (985,985,NULL,1,'2022-08-12 15:44:24','2022-08-12 15:44:24',40,'AC_PRODUCT_MODIFY','2022-08-12 15:44:24','2022-08-12 03:44:24',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPTDP84G modificado','Autor: admin\nProducto BPTDP84G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,229,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (986,986,NULL,1,'2022-08-12 15:45:27','2022-08-12 15:45:27',40,'AC_PRODUCT_MODIFY','2022-08-12 15:45:27','2022-08-12 03:45:27',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BISUR700G modificado','Autor: admin\nProducto BISUR700G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,216,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (987,987,NULL,1,'2022-08-12 15:46:16','2022-08-12 15:46:16',40,'AC_PRODUCT_MODIFY','2022-08-12 15:46:16','2022-08-12 03:46:16',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BISUS600G modificado','Autor: admin\nProducto BISUS600G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,217,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (988,988,NULL,1,'2022-08-12 15:50:11','2022-08-12 15:50:11',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-12 15:50:11','2022-08-12 03:50:11',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0047 validada','Autor: yrodriguez\nFactura SI2208-0047 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,69,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (989,989,NULL,1,'2022-08-12 15:57:39','2022-08-12 15:57:39',40,'AC_ORDER_VALIDATE','2022-08-12 15:57:39','2022-08-12 03:57:39',4,NULL,NULL,14336,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0077 validada','Autor: yrodriguez\nOrden CO2208-0077 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,84,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (990,990,NULL,1,'2022-08-12 15:59:31','2022-08-12 15:59:31',40,'AC_PRODUCT_MODIFY','2022-08-12 15:59:31','2022-08-12 03:59:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTPF100G modificado','Autor: admin\nProducto BTPF100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,337,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (991,991,NULL,1,'2022-08-12 15:59:58','2022-08-12 15:59:58',40,'AC_PRODUCT_MODIFY','2022-08-12 15:59:58','2022-08-12 03:59:58',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTCHB100G modificado','Autor: admin\nProducto BTCHB100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,221,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (992,992,NULL,1,'2022-08-12 16:01:13','2022-08-12 16:01:13',40,'AC_PRODUCT_MODIFY','2022-08-12 16:01:13','2022-08-12 04:01:13',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTCHM100G modificado','Autor: admin\nProducto BTCHM100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,222,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (993,993,NULL,1,'2022-08-12 16:01:31','2022-08-12 16:01:31',40,'AC_PRODUCT_MODIFY','2022-08-12 16:01:31','2022-08-12 04:01:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTCHM100G modificado','Autor: admin\nProducto BTCHM100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,222,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (994,994,NULL,1,'2022-08-12 16:02:35','2022-08-12 16:02:35',40,'AC_PRODUCT_MODIFY','2022-08-12 16:02:35','2022-08-12 04:02:35',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTCFSCH90G modificado','Autor: admin\nProducto BTCFSCH90G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,223,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (995,995,NULL,1,'2022-08-12 16:03:12','2022-08-12 16:03:12',40,'AC_PRODUCT_MODIFY','2022-08-12 16:03:12','2022-08-12 04:03:12',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTCFC90G modificado','Autor: admin\nProducto BTCFC90G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,224,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (996,996,NULL,1,'2022-08-12 16:03:38','2022-08-12 16:03:38',40,'AC_PRODUCT_MODIFY','2022-08-12 16:03:38','2022-08-12 04:03:38',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTBM80G modificado','Autor: admin\nProducto BTBM80G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,225,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (997,997,NULL,1,'2022-08-12 16:04:55','2022-08-12 16:04:55',40,'AC_PRODUCT_MODIFY','2022-08-12 16:04:55','2022-08-12 04:04:55',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTCT80G modificado','Autor: admin\nProducto BTCT80G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,227,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (998,998,NULL,1,'2022-08-12 16:05:30','2022-08-12 16:05:30',40,'AC_PRODUCT_MODIFY','2022-08-12 16:05:30','2022-08-12 04:05:30',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MI40G modificado','Autor: admin\nProducto MI40G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,228,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (999,999,NULL,1,'2022-08-12 16:10:39','2022-08-12 16:10:39',40,'AC_PRODUCT_MODIFY','2022-08-12 16:10:39','2022-08-12 04:10:39',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CECINAA40G modificado','Autor: admin\nProducto CECINAA40G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,232,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1000,1000,NULL,1,'2022-08-12 16:11:05','2022-08-12 16:11:05',40,'AC_PRODUCT_MODIFY','2022-08-12 16:11:05','2022-08-12 04:11:05',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CECINAH40G modificado','Autor: admin\nProducto CECINAH40G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,233,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1001,1001,NULL,1,'2022-08-12 16:11:45','2022-08-12 16:11:45',40,'AC_PRODUCT_MODIFY','2022-08-12 16:11:45','2022-08-12 04:11:45',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CECINA modificado','Autor: admin\nProducto CECINA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,336,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1002,1002,NULL,1,'2022-08-12 16:12:55','2022-08-12 16:12:55',40,'AC_PRODUCT_MODIFY','2022-08-12 16:12:55','2022-08-12 04:12:55',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPARROZ500G modificado','Autor: admin\nProducto BPARROZ500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,281,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1003,1003,NULL,1,'2022-08-12 16:14:32','2022-08-12 16:14:32',40,'AC_PRODUCT_MODIFY','2022-08-12 16:14:32','2022-08-12 04:14:32',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPSAN11GR modificado','Autor: admin\nProducto BPSAN11GR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,237,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1004,1004,NULL,1,'2022-08-12 16:14:49','2022-08-12 16:14:49',40,'AC_PRODUCT_MODIFY','2022-08-12 16:14:49','2022-08-12 04:14:49',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPSAN11GR modificado','Autor: admin\nProducto BPSAN11GR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,237,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1005,1005,NULL,1,'2022-08-12 16:22:12','2022-08-12 16:22:12',40,'AC_PRODUCT_MODIFY','2022-08-12 16:22:12','2022-08-12 04:22:12',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPMAN11GR modificado','Autor: admin\nProducto BPMAN11GR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,234,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1006,1006,NULL,1,'2022-08-12 16:22:33','2022-08-12 16:22:33',40,'AC_PRODUCT_MODIFY','2022-08-12 16:22:33','2022-08-12 04:22:33',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPMAN11GR modificado','Autor: admin\nProducto BPMAN11GR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,234,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1007,1007,NULL,1,'2022-08-12 16:24:18','2022-08-12 16:24:18',40,'AC_PRODUCT_MODIFY','2022-08-12 16:24:18','2022-08-12 04:24:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPELO11GR modificado','Autor: admin\nProducto BPELO11GR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,236,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1008,1008,NULL,1,'2022-08-12 16:24:31','2022-08-12 16:24:31',40,'AC_PRODUCT_MODIFY','2022-08-12 16:24:31','2022-08-12 04:24:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPELO11GR modificado','Autor: admin\nProducto BPELO11GR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,236,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1009,1009,NULL,1,'2022-08-12 19:05:34','2022-08-12 19:05:34',40,'AC_ORDER_VALIDATE','2022-08-12 19:05:34','2022-08-12 07:05:34',4,NULL,NULL,13420,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0078 validada','Autor: yrodriguez\nOrden CO2208-0078 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,85,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1010,1010,NULL,1,'2022-08-12 19:14:19','2022-08-12 19:14:19',40,'AC_ORDER_VALIDATE','2022-08-12 19:14:19','2022-08-12 07:14:19',4,NULL,NULL,13420,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0078 validada','Autor: yrodriguez\nOrden CO2208-0078 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,85,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1011,1011,NULL,1,'2022-08-12 19:25:42','2022-08-12 19:25:42',40,'AC_ORDER_VALIDATE','2022-08-12 19:25:42','2022-08-12 07:25:42',4,NULL,NULL,14336,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0079 validada','Autor: yrodriguez\nOrden CO2208-0079 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,86,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1012,1012,NULL,1,'2022-08-12 19:47:17','2022-08-12 19:47:17',40,'AC_ORDER_VALIDATE','2022-08-12 19:47:17','2022-08-12 07:47:17',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0080 validada','Autor: egarcia\nOrden CO2208-0080 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,87,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1013,1013,NULL,1,'2022-08-12 21:01:41','2022-08-12 21:01:41',40,'AC_ORDER_VALIDATE','2022-08-12 21:01:41','2022-08-12 09:01:41',4,NULL,NULL,14336,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0079 validada','Autor: yrodriguez\nOrden CO2208-0079 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,86,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1014,1014,NULL,1,'2022-08-12 21:45:22','2022-08-12 21:45:22',40,'AC_ORDER_VALIDATE','2022-08-12 21:45:22','2022-08-12 09:45:22',4,NULL,NULL,14336,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0081 validada','Autor: yrodriguez\nOrden CO2208-0081 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,88,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1015,1015,NULL,1,'2022-08-12 21:49:58','2022-08-12 21:49:58',40,'AC_ORDER_VALIDATE','2022-08-12 21:49:58','2022-08-12 09:49:58',4,NULL,NULL,14336,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0082 validada','Autor: yrodriguez\nOrden CO2208-0082 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,89,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1016,1016,NULL,1,'2022-08-12 21:53:52','2022-08-12 21:53:52',40,'AC_ORDER_VALIDATE','2022-08-12 21:53:52','2022-08-12 09:53:52',4,NULL,NULL,14336,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0083 validada','Autor: yrodriguez\nOrden CO2208-0083 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,90,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1017,1017,NULL,1,'2022-08-12 21:57:28','2022-08-12 21:57:28',40,'AC_PRODUCT_MODIFY','2022-08-12 21:57:28','2022-08-12 09:57:28',4,NULL,NULL,NULL,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Producto doble_producto modificado','Autor: yrodriguez\nProducto doble_producto modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,220,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1018,1018,NULL,1,'2022-08-12 22:51:51','2022-08-12 22:51:51',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-12 22:51:51','2022-08-12 10:51:51',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0048 validada','Autor: yrodriguez\nFactura SI2208-0048 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,70,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1019,1019,NULL,1,'2022-08-12 23:03:58','2022-08-12 23:03:58',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-12 23:03:58','2022-08-12 11:03:58',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0049 validada','Autor: yrodriguez\nFactura SI2208-0049 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,71,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1020,1020,NULL,1,'2022-08-13 00:09:06','2022-08-13 00:09:06',40,'AC_ORDER_VALIDATE','2022-08-13 00:09:06','2022-08-12 12:09:06',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0084 validada','Autor: egarcia\nOrden CO2208-0084 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,91,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1021,1021,NULL,1,'2022-08-13 00:11:24','2022-08-13 00:11:24',40,'AC_ORDER_VALIDATE','2022-08-13 00:11:24','2022-08-12 12:11:24',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0085 validada','Autor: egarcia\nOrden CO2208-0085 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,92,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1022,1022,NULL,1,'2022-08-13 18:22:21','2022-08-13 18:22:21',40,'AC_ORDER_VALIDATE','2022-08-13 18:22:21','2022-08-13 06:22:21',4,NULL,NULL,14336,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0086 validada','Autor: yrodriguez\nOrden CO2208-0086 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,93,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1023,1023,NULL,1,'2022-08-13 18:44:30','2022-08-13 18:44:30',40,'AC_ORDER_VALIDATE','2022-08-13 18:44:30','2022-08-13 06:44:30',4,NULL,NULL,13528,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0087 validada','Autor: yrodriguez\nOrden CO2208-0087 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,94,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1024,1024,NULL,1,'2022-08-13 18:47:42','2022-08-13 18:47:42',40,'AC_ORDER_VALIDATE','2022-08-13 18:47:42','2022-08-13 06:47:42',4,NULL,NULL,14336,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0079 validada','Autor: yrodriguez\nOrden CO2208-0079 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,86,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1025,1025,NULL,1,'2022-08-13 18:49:36','2022-08-13 18:49:36',40,'AC_ORDER_VALIDATE','2022-08-13 18:49:36','2022-08-13 06:49:36',4,NULL,NULL,13528,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0088 validada','Autor: yrodriguez\nOrden CO2208-0088 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,95,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1026,1026,NULL,1,'2022-08-13 21:32:09','2022-08-13 21:32:09',40,'AC_ORDER_VALIDATE','2022-08-13 21:32:09','2022-08-13 09:32:09',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0089 validada','Autor: egarcia\nOrden CO2208-0089 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,96,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1027,1027,NULL,1,'2022-08-13 22:04:05','2022-08-13 22:04:05',40,'AC_ORDER_VALIDATE','2022-08-13 22:04:05','2022-08-13 10:04:05',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0090 validada','Autor: egarcia\nOrden CO2208-0090 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,97,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1028,1028,NULL,1,'2022-08-15 16:28:09','2022-08-15 16:28:09',40,'AC_PRODUCT_DELETE','2022-08-15 16:28:09','2022-08-15 04:28:09',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_con_Pizcas_de_Chocolate_B.P._336_g eliminado','Autor: admin\nProducto Galletas_con_Pizcas_de_Chocolate_B.P._336_g eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,418,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1029,1029,NULL,1,'2022-08-15 17:43:05','2022-08-15 17:43:05',40,'AC_BOM_UNVALIDATE','2022-08-15 17:43:05','2022-08-15 05:43:05',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,21,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1030,1030,NULL,1,'2022-08-15 17:46:27','2022-08-15 17:46:27',40,'AC_BOM_UNVALIDATE','2022-08-15 17:46:27','2022-08-15 05:46:27',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,23,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1031,1031,NULL,1,'2022-08-15 18:00:18','2022-08-15 18:00:18',40,'AC_BOM_UNVALIDATE','2022-08-15 18:00:18','2022-08-15 06:00:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,33,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1032,1032,NULL,1,'2022-08-15 18:59:51','2022-08-15 18:59:51',40,'AC_BOM_UNVALIDATE','2022-08-15 18:59:51','2022-08-15 06:59:51',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,36,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1033,1033,NULL,1,'2022-08-15 19:02:58','2022-08-15 19:02:58',40,'AC_BOM_UNVALIDATE','2022-08-15 19:02:58','2022-08-15 07:02:58',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,37,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1034,1034,NULL,1,'2022-08-15 19:03:50','2022-08-15 19:03:50',40,'AC_COMPANY_MODIFY','2022-08-15 19:03:50','2022-08-15 07:03:50',1,NULL,NULL,1,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Tercero Publico en General modificado','Autor: admin\nTercero Publico en General modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1035,1035,NULL,1,'2022-08-15 19:05:31','2022-08-15 19:05:31',40,'AC_BOM_UNVALIDATE','2022-08-15 19:05:31','2022-08-15 07:05:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,40,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1036,1036,NULL,1,'2022-08-15 19:08:21','2022-08-15 19:08:21',40,'AC_BOM_UNVALIDATE','2022-08-15 19:08:21','2022-08-15 07:08:21',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,42,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1037,1037,NULL,1,'2022-08-15 19:10:08','2022-08-15 19:10:08',40,'AC_PRODUCT_DELETE','2022-08-15 19:10:08','2022-08-15 07:10:08',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto B.P._IMP._GALLETAS_MINI_PIZCAS_DE_CHOCOLATE_100_G eliminado','Autor: admin\nProducto B.P._IMP._GALLETAS_MINI_PIZCAS_DE_CHOCOLATE_100_G eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,417,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1038,1038,NULL,1,'2022-08-15 20:05:40','2022-08-15 20:05:40',40,'AC_ORDER_VALIDATE','2022-08-15 20:05:40','2022-08-15 08:05:40',6,NULL,NULL,13786,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0091 validada','Autor: egarcia\nOrden CO2208-0091 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,98,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1039,1039,NULL,1,'2022-08-15 20:30:09','2022-08-15 20:30:09',40,'AC_USER_CREATE','2022-08-15 20:30:09','2022-08-15 08:30:09',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro  creado','Autor: admin\nRegistro  creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,11,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1040,1040,NULL,1,'2022-08-15 20:30:09','2022-08-15 20:30:09',40,'AC_USER_NEW_PASSWORD','2022-08-15 20:30:09','2022-08-15 08:30:09',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'PASSWORDInDolibarr','Autor: admin\nPASSWORDInDolibarr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,11,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1041,1041,NULL,1,'2022-08-15 20:30:40','2022-08-15 20:30:40',40,'AC_USER_MODIFY','2022-08-15 20:30:40','2022-08-15 08:30:40',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 11 modificado','Autor: admin\nRegistro 11 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,11,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1042,1042,NULL,1,'2022-08-15 20:42:25','2022-08-15 20:42:25',40,'AC_BOM_UNVALIDATE','2022-08-15 20:42:25','2022-08-15 08:42:25',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,59,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1043,1043,NULL,1,'2022-08-15 20:47:31','2022-08-15 20:47:31',40,'AC_BOM_UNVALIDATE','2022-08-15 20:47:31','2022-08-15 08:47:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,62,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1044,1044,NULL,1,'2022-08-15 20:48:49','2022-08-15 20:48:49',40,'AC_BILL_VALIDATE','2022-08-15 20:48:49','2022-08-15 08:48:49',1,NULL,NULL,13812,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0010 validada','Autor: admin\nFactura FA2208-0010 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,11,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1045,1045,NULL,1,'2022-08-15 20:57:39','2022-08-15 20:57:39',40,'AC_BOM_UNVALIDATE','2022-08-15 20:57:39','2022-08-15 08:57:39',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,26,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1046,1046,NULL,1,'2022-08-15 21:54:29','2022-08-15 21:54:29',40,'AC_PRODUCT_DELETE','2022-08-15 21:54:29','2022-08-15 09:54:29',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto B.P._IMP._GALLETAS_CON_GRAGEA_MOLIENDA_100g eliminado','Autor: admin\nProducto B.P._IMP._GALLETAS_CON_GRAGEA_MOLIENDA_100g eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,409,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1047,1047,NULL,1,'2022-08-15 21:56:09','2022-08-15 21:56:09',40,'AC_PRODUCT_DELETE','2022-08-15 21:56:09','2022-08-15 09:56:09',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_Grageas__100g_(3.5_OZ)_C_48__Cookies__MX._LA_MOLIENDA eliminado','Autor: admin\nProducto Galletas_Grageas__100g_(3.5_OZ)_C_48__Cookies__MX._LA_MOLIENDA eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,408,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1048,1048,NULL,1,'2022-08-15 21:56:38','2022-08-15 21:56:38',40,'AC_PRODUCT_DELETE','2022-08-15 21:56:38','2022-08-15 09:56:38',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_con_Gragea_de_Chocolate_B.P._400_g eliminado','Autor: admin\nProducto Galletas_con_Gragea_de_Chocolate_B.P._400_g eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,410,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1049,1049,NULL,1,'2022-08-15 21:59:59','2022-08-15 21:59:59',40,'AC_PRODUCT_DELETE','2022-08-15 21:59:59','2022-08-15 09:59:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galletas_Mini_Pizcas_de_Chocolate_B.P._100_g eliminado','Autor: admin\nProducto Galletas_Mini_Pizcas_de_Chocolate_B.P._100_g eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,416,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1050,1050,NULL,1,'2022-08-15 22:07:43','2022-08-15 22:07:43',40,'AC_PRODUCT_DELETE','2022-08-15 22:07:43','2022-08-15 10:07:43',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Suspiros_Blister_40_galletas_(Aprox._600_g) eliminado','Autor: admin\nProducto Suspiros_Blister_40_galletas_(Aprox._600_g) eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,433,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1051,1051,NULL,1,'2022-08-15 22:08:25','2022-08-15 22:08:25',40,'AC_PRODUCT_DELETE','2022-08-15 22:08:25','2022-08-15 10:08:25',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Galleta_Surtida_Blister_50_galletas_(Aprox._700_g) eliminado','Autor: admin\nProducto Galleta_Surtida_Blister_50_galletas_(Aprox._700_g) eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,436,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1052,1052,NULL,1,'2022-08-15 22:20:37','2022-08-15 22:20:37',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-15 22:20:37','2022-08-15 10:20:37',6,NULL,NULL,3,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0050 validada','Autor: egarcia\nFactura SI2208-0050 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,72,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1053,1053,NULL,1,'2022-08-15 22:22:53','2022-08-15 22:22:53',40,'AC_PRODUCT_DELETE','2022-08-15 22:22:53','2022-08-15 10:22:53',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CAJA_AVENA_CAP._16_BP._CON_500_grs._C_U. eliminado','Autor: admin\nProducto CAJA_AVENA_CAP._16_BP._CON_500_grs._C_U. eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,386,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1054,1054,NULL,1,'2022-08-15 22:24:12','2022-08-15 22:24:12',40,'AC_ORDER_VALIDATE','2022-08-15 22:24:12','2022-08-15 10:24:12',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0092 validada','Autor: egarcia\nOrden CO2208-0092 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,99,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1055,1055,NULL,1,'2022-08-15 22:26:37','2022-08-15 22:26:37',40,'AC_ORDER_VALIDATE','2022-08-15 22:26:37','2022-08-15 10:26:37',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0093 validada','Autor: egarcia\nOrden CO2208-0093 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,100,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1056,1056,NULL,1,'2022-08-15 22:27:46','2022-08-15 22:27:46',40,'AC_BOM_UNVALIDATE','2022-08-15 22:27:46','2022-08-15 10:27:46',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,19,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1057,1057,NULL,1,'2022-08-15 22:28:28','2022-08-15 22:28:28',40,'AC_BOM_VALIDATE','2022-08-15 22:28:28','2022-08-15 10:28:28',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,19,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1058,1058,NULL,1,'2022-08-15 22:28:47','2022-08-15 22:28:47',40,'AC_BOM_UNVALIDATE','2022-08-15 22:28:47','2022-08-15 10:28:47',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,18,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1059,1059,NULL,1,'2022-08-15 22:29:11','2022-08-15 22:29:11',40,'AC_BOM_VALIDATE','2022-08-15 22:29:11','2022-08-15 10:29:11',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,18,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1060,1060,NULL,1,'2022-08-15 22:29:29','2022-08-15 22:29:29',40,'AC_BOM_UNVALIDATE','2022-08-15 22:29:29','2022-08-15 10:29:29',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,16,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1061,1061,NULL,1,'2022-08-15 22:30:14','2022-08-15 22:30:14',40,'AC_BOM_VALIDATE','2022-08-15 22:30:14','2022-08-15 10:30:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,16,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1062,1062,NULL,1,'2022-08-15 22:30:27','2022-08-15 22:30:27',40,'AC_BOM_UNVALIDATE','2022-08-15 22:30:27','2022-08-15 10:30:27',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,15,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1063,1063,NULL,1,'2022-08-15 22:31:05','2022-08-15 22:31:05',40,'AC_BOM_VALIDATE','2022-08-15 22:31:05','2022-08-15 10:31:05',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,15,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1064,1064,NULL,1,'2022-08-15 22:31:22','2022-08-15 22:31:22',40,'AC_BOM_UNVALIDATE','2022-08-15 22:31:22','2022-08-15 10:31:22',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,12,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1065,1065,NULL,1,'2022-08-15 22:32:00','2022-08-15 22:32:00',40,'AC_BOM_VALIDATE','2022-08-15 22:32:00','2022-08-15 10:32:00',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,12,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1066,1066,NULL,1,'2022-08-15 22:32:27','2022-08-15 22:32:27',40,'AC_PRODUCT_DELETE','2022-08-15 22:32:27','2022-08-15 10:32:27',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto COLORANTE_ARTIFICIAL_PARA_ALIMENTOS_AMARILLO_HUEVO_PREPARADO eliminado','Autor: admin\nProducto COLORANTE_ARTIFICIAL_PARA_ALIMENTOS_AMARILLO_HUEVO_PREPARADO eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,377,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1067,1067,NULL,1,'2022-08-15 22:36:48','2022-08-15 22:36:48',40,'AC_PRODUCT_DELETE','2022-08-15 22:36:48','2022-08-15 10:36:48',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto ETIQUETAS_EMILIAS eliminado','Autor: admin\nProducto ETIQUETAS_EMILIAS eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,397,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1068,1068,NULL,1,'2022-08-15 22:56:57','2022-08-15 22:56:57',40,'AC_PRODUCT_MODIFY','2022-08-15 22:56:57','2022-08-15 10:56:57',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR500G modificado','Autor: admin\nProducto BPGR500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,205,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1069,1069,NULL,1,'2022-08-15 22:57:52','2022-08-15 22:57:52',40,'AC_PRODUCT_MODIFY','2022-08-15 22:57:52','2022-08-15 10:57:52',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPAVE500G modificado','Autor: admin\nProducto BPAVE500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,203,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1070,1070,NULL,1,'2022-08-15 22:58:33','2022-08-15 22:58:33',40,'AC_PRODUCT_MODIFY','2022-08-15 22:58:33','2022-08-15 10:58:33',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPMI500G modificado','Autor: admin\nProducto BPMI500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,206,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1071,1071,NULL,1,'2022-08-15 22:59:14','2022-08-15 22:59:14',40,'AC_PRODUCT_MODIFY','2022-08-15 22:59:14','2022-08-15 10:59:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGCH400G modificado','Autor: admin\nProducto BPGCH400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,280,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1072,1072,NULL,1,'2022-08-16 00:04:57','2022-08-16 00:04:57',40,'AC_ORDER_VALIDATE','2022-08-16 00:04:57','2022-08-15 12:04:57',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0094 validada','Autor: egarcia\nOrden CO2208-0094 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,101,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1073,1073,NULL,1,'2022-08-16 01:12:24','2022-08-16 01:12:24',40,'AC_ORDER_VALIDATE','2022-08-16 01:12:24','2022-08-15 13:12:24',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0095 validada','Autor: egarcia\nOrden CO2208-0095 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,102,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1074,1074,NULL,1,'2022-08-16 15:29:12','2022-08-16 15:29:12',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-16 15:29:12','2022-08-16 03:29:12',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0051 validada','Autor: yrodriguez\nFactura SI2208-0051 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,73,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1075,1075,NULL,1,'2022-08-16 17:02:46','2022-08-16 17:02:46',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-16 17:02:46','2022-08-16 05:02:46',4,NULL,NULL,4,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0052 validada','Autor: yrodriguez\nFactura SI2208-0052 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,74,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1076,1076,NULL,1,'2022-08-16 17:38:35','2022-08-16 17:38:35',40,'AC_BILL_SUPPLIER_UNVALIDATE','2022-08-16 17:38:35','2022-08-16 05:38:35',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura SI2208-0051 al estado de borrador','Autor: yrodriguez\nRegresar factura SI2208-0051 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,73,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1077,1077,NULL,1,'2022-08-16 17:38:41','2022-08-16 17:38:41',40,'AC_BILL_SUPPLIER_DELETE','2022-08-16 17:38:41','2022-08-16 05:38:41',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura de proveedor eliminada','Autor: yrodriguez\nFactura de proveedor eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,73,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1078,1078,NULL,1,'2022-08-16 20:35:30','2022-08-16 20:35:30',40,'AC_ORDER_VALIDATE','2022-08-16 20:35:30','2022-08-16 08:35:30',4,NULL,NULL,14336,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0096 validada','Autor: yrodriguez\nOrden CO2208-0096 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,103,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1079,1079,NULL,1,'2022-08-16 21:24:03','2022-08-16 21:24:03',40,'AC_BOM_UNVALIDATE','2022-08-16 21:24:03','2022-08-16 09:24:03',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,24,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1080,1080,NULL,1,'2022-08-16 22:58:50','2022-08-16 22:58:50',40,'AC_ORDER_VALIDATE','2022-08-16 22:58:50','2022-08-16 10:58:50',6,NULL,NULL,12416,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0097 validada','Autor: egarcia\nOrden CO2208-0097 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,104,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1081,1081,NULL,1,'2022-08-16 23:11:37','2022-08-16 23:11:37',40,'AC_ORDER_VALIDATE','2022-08-16 23:11:37','2022-08-16 11:11:37',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0098 validada','Autor: egarcia\nOrden CO2208-0098 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,105,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1082,1082,NULL,1,'2022-08-16 23:28:47','2022-08-16 23:28:47',40,'AC_ORDER_VALIDATE','2022-08-16 23:28:47','2022-08-16 11:28:47',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0099 validada','Autor: egarcia\nOrden CO2208-0099 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,106,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1083,1083,NULL,1,'2022-08-16 23:30:52','2022-08-16 23:30:52',40,'AC_ORDER_VALIDATE','2022-08-16 23:30:52','2022-08-16 11:30:52',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0100 validada','Autor: egarcia\nOrden CO2208-0100 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,107,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1084,1084,NULL,1,'2022-08-17 01:16:45','2022-08-17 01:16:45',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-17 01:16:45','2022-08-16 13:16:45',6,NULL,NULL,3,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0053 validada','Autor: egarcia\nFactura SI2208-0053 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,75,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1085,1085,NULL,1,'2022-08-17 12:29:46','2022-08-17 12:29:46',40,'AC_BILL_VALIDATE','2022-08-17 12:29:46','2022-08-17 00:29:46',4,NULL,NULL,12201,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0011 validada','Autor: yrodriguez\nFactura FA2208-0011 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,12,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1086,1086,NULL,1,'2022-08-17 12:35:02','2022-08-17 12:35:02',40,'AC_BILL_VALIDATE','2022-08-17 12:35:02','2022-08-17 00:35:02',4,NULL,NULL,12201,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0012 validada','Autor: yrodriguez\nFactura FA2208-0012 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1087,1087,NULL,1,'2022-08-17 12:50:24','2022-08-17 12:50:24',40,'AC_ORDER_VALIDATE','2022-08-17 12:50:24','2022-08-17 00:50:24',4,NULL,NULL,12201,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0101 validada','Autor: yrodriguez\nOrden CO2208-0101 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,108,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1088,1088,NULL,1,'2022-08-17 12:57:00','2022-08-17 12:57:00',40,'AC_ORDER_VALIDATE','2022-08-17 12:57:00','2022-08-17 00:57:00',4,NULL,NULL,12201,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0102 validada','Autor: yrodriguez\nOrden CO2208-0102 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,109,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1089,1089,NULL,1,'2022-08-17 13:00:17','2022-08-17 13:00:17',40,'AC_ORDER_VALIDATE','2022-08-17 13:00:17','2022-08-17 01:00:17',4,NULL,NULL,12201,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0103 validada','Autor: yrodriguez\nOrden CO2208-0103 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,110,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1090,1090,NULL,1,'2022-08-17 13:02:10','2022-08-17 13:02:10',40,'AC_ORDER_VALIDATE','2022-08-17 13:02:10','2022-08-17 01:02:10',4,NULL,NULL,12697,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0104 validada','Autor: yrodriguez\nOrden CO2208-0104 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,111,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1091,1091,NULL,1,'2022-08-17 13:02:26','2022-08-17 13:02:26',40,'AC_ORDER_DELETE','2022-08-17 13:02:26','2022-08-17 01:02:26',4,NULL,NULL,12697,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Registro CO2208-0104 eliminado','Autor: yrodriguez\nRegistro CO2208-0104 eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,111,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1092,1092,NULL,1,'2022-08-17 13:04:06','2022-08-17 13:04:06',40,'AC_ORDER_DELETE','2022-08-17 13:04:06','2022-08-17 01:04:06',4,NULL,NULL,12697,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Registro (PROV112) eliminado','Autor: yrodriguez\nRegistro (PROV112) eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,112,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1093,1093,NULL,1,'2022-08-17 13:06:46','2022-08-17 13:06:46',40,'AC_BILL_VALIDATE','2022-08-17 13:06:46','2022-08-17 01:06:46',4,NULL,NULL,12697,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0013 validada','Autor: yrodriguez\nFactura FA2208-0013 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,14,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1094,1094,NULL,1,'2022-08-17 13:08:35','2022-08-17 13:08:35',40,'AC_BILL_VALIDATE','2022-08-17 13:08:35','2022-08-17 01:08:35',4,NULL,NULL,12367,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0014 validada','Autor: yrodriguez\nFactura FA2208-0014 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,15,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1095,1095,NULL,1,'2022-08-17 13:17:30','2022-08-17 13:17:30',40,'AC_BILL_VALIDATE','2022-08-17 13:17:30','2022-08-17 01:17:30',4,NULL,NULL,13642,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0015 validada','Autor: yrodriguez\nFactura FA2208-0015 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,16,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1096,1096,NULL,1,'2022-08-17 13:24:16','2022-08-17 13:24:16',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-17 13:24:16','2022-08-17 01:24:16',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0054 validada','Autor: yrodriguez\nFactura SI2208-0054 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,77,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1097,1097,NULL,1,'2022-08-17 13:35:29','2022-08-17 13:35:29',40,'AC_BILL_SUPPLIER_UNVALIDATE','2022-08-17 13:35:29','2022-08-17 01:35:29',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura SI2208-0054 al estado de borrador','Autor: yrodriguez\nRegresar factura SI2208-0054 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,77,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1098,1098,NULL,1,'2022-08-17 13:36:12','2022-08-17 13:36:12',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-17 13:36:12','2022-08-17 01:36:12',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0054 validada','Autor: yrodriguez\nFactura SI2208-0054 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,77,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1099,1099,NULL,1,'2022-08-17 14:30:40','2022-08-17 14:30:40',40,'AC_ORDER_VALIDATE','2022-08-17 14:30:40','2022-08-17 02:30:40',4,NULL,NULL,12201,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0102 validada','Autor: yrodriguez\nOrden CO2208-0102 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,109,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1100,1100,NULL,1,'2022-08-17 14:32:33','2022-08-17 14:32:33',40,'AC_BILL_DELETE','2022-08-17 14:32:33','2022-08-17 02:32:33',4,NULL,NULL,12201,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura eliminada','Autor: yrodriguez\nFactura eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,17,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1101,1101,NULL,1,'2022-08-17 14:40:58','2022-08-17 14:40:58',40,'AC_BILL_VALIDATE','2022-08-17 14:40:58','2022-08-17 02:40:58',4,NULL,NULL,12201,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0016 validada','Autor: yrodriguez\nFactura FA2208-0016 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,18,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1102,1102,NULL,1,'2022-08-17 14:41:33','2022-08-17 14:41:33',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-17 14:41:33','2022-08-17 02:41:33',4,NULL,NULL,4,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0055 validada','Autor: yrodriguez\nFactura SI2208-0055 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,78,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1103,1103,NULL,1,'2022-08-17 15:00:34','2022-08-17 15:00:34',40,'AC_BILL_SUPPLIER_UNVALIDATE','2022-08-17 15:00:34','2022-08-17 03:00:34',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura SI2208-0054 al estado de borrador','Autor: yrodriguez\nRegresar factura SI2208-0054 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,77,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1104,1104,NULL,1,'2022-08-17 15:00:54','2022-08-17 15:00:54',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-17 15:00:54','2022-08-17 03:00:54',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0054 validada','Autor: yrodriguez\nFactura SI2208-0054 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,77,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1105,1105,NULL,1,'2022-08-17 20:45:03','2022-08-17 20:45:03',40,'AC_ORDER_VALIDATE','2022-08-17 20:45:03','2022-08-17 08:45:03',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Orden CO2208-0104 validada','Autor: egarcia\nOrden CO2208-0104 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,113,'order',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1106,1106,NULL,1,'2022-08-17 22:03:23','2022-08-17 22:03:23',40,'AC_BILL_VALIDATE','2022-08-17 22:03:23','2022-08-17 10:03:23',6,NULL,NULL,10879,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0017 validada','Autor: egarcia\nFactura FA2208-0017 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,19,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1107,1107,NULL,1,'2022-08-17 22:04:26','2022-08-17 22:04:26',40,'AC_BILL_VALIDATE','2022-08-17 22:04:26','2022-08-17 10:04:26',6,NULL,NULL,10872,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0018 validada','Autor: egarcia\nFactura FA2208-0018 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,20,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1108,1108,NULL,1,'2022-08-18 01:14:22','2022-08-18 01:14:22',40,'AC_BILL_VALIDATE','2022-08-18 01:14:22','2022-08-17 13:14:22',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0019 validada','Autor: egarcia\nFactura FA2208-0019 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,21,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1109,1109,NULL,1,'2022-08-18 01:19:46','2022-08-18 01:19:46',40,'AC_BILL_SUPPLIER_DELETE','2022-08-18 01:19:46','2022-08-17 13:19:46',6,NULL,NULL,1,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura de proveedor eliminada','Autor: egarcia\nFactura de proveedor eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,79,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1110,1110,NULL,1,'2022-08-18 01:22:28','2022-08-18 01:22:28',40,'AC_BILL_VALIDATE','2022-08-18 01:22:28','2022-08-17 13:22:28',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0020 validada','Autor: egarcia\nFactura FA2208-0020 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,22,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1111,1111,NULL,1,'2022-08-18 01:25:00','2022-08-18 01:25:00',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-18 01:25:00','2022-08-17 13:25:00',6,NULL,NULL,3,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0056 validada','Autor: egarcia\nFactura SI2208-0056 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,80,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1112,1112,NULL,1,'2022-08-18 14:20:11','2022-08-18 14:20:11',40,'AC_BILL_VALIDATE','2022-08-18 14:20:11','2022-08-18 02:20:11',4,NULL,NULL,14336,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0021 validada','Autor: yrodriguez\nFactura FA2208-0021 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,23,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1113,1113,NULL,1,'2022-08-18 17:24:40','2022-08-18 17:24:40',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-18 17:24:40','2022-08-18 05:24:40',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0057 validada','Autor: yrodriguez\nFactura SI2208-0057 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,81,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1114,1114,NULL,1,'2022-08-18 17:26:09','2022-08-18 17:26:09',40,'AC_BILL_VALIDATE','2022-08-18 17:26:09','2022-08-18 05:26:09',4,NULL,NULL,13209,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0022 validada','Autor: yrodriguez\nFactura FA2208-0022 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,24,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1115,1115,NULL,1,'2022-08-18 17:26:59','2022-08-18 17:26:59',40,'AC_BILL_VALIDATE','2022-08-18 17:26:59','2022-08-18 05:26:59',4,NULL,NULL,14336,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0023 validada','Autor: yrodriguez\nFactura FA2208-0023 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,25,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1116,1116,NULL,1,'2022-08-18 17:34:03','2022-08-18 17:34:03',40,'AC_PRODUCT_MODIFY','2022-08-18 17:34:03','2022-08-18 05:34:03',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTCFSCH90G modificado','Autor: admin\nProducto BTCFSCH90G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,223,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1117,1117,NULL,1,'2022-08-18 17:34:40','2022-08-18 17:34:40',40,'AC_PRODUCT_MODIFY','2022-08-18 17:34:40','2022-08-18 05:34:40',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPTDF84G modificado','Autor: admin\nProducto BPTDF84G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,230,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1118,1118,NULL,1,'2022-08-18 17:34:51','2022-08-18 17:34:51',40,'AC_PRODUCT_MODIFY','2022-08-18 17:34:51','2022-08-18 05:34:51',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPSAN11GR modificado','Autor: admin\nProducto BPSAN11GR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,237,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1119,1119,NULL,1,'2022-08-18 17:35:03','2022-08-18 17:35:03',40,'AC_PRODUCT_MODIFY','2022-08-18 17:35:03','2022-08-18 05:35:03',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPPIZ100G modificado','Autor: admin\nProducto BPPIZ100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,278,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1120,1120,NULL,1,'2022-08-18 17:35:14','2022-08-18 17:35:14',40,'AC_PRODUCT_MODIFY','2022-08-18 17:35:14','2022-08-18 05:35:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPOR200G modificado','Autor: admin\nProducto BPOR200G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,213,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1121,1121,NULL,1,'2022-08-18 17:35:27','2022-08-18 17:35:27',40,'AC_PRODUCT_MODIFY','2022-08-18 17:35:27','2022-08-18 05:35:27',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPNU400G modificado','Autor: admin\nProducto BPNU400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,211,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1122,1122,NULL,1,'2022-08-18 17:36:48','2022-08-18 17:36:48',40,'AC_PRODUCT_MODIFY','2022-08-18 17:36:48','2022-08-18 05:36:48',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BISUR700G modificado','Autor: admin\nProducto BISUR700G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,216,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1123,1123,NULL,1,'2022-08-18 17:36:56','2022-08-18 17:36:56',40,'AC_PRODUCT_MODIFY','2022-08-18 17:36:56','2022-08-18 05:36:56',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BISUS600G modificado','Autor: admin\nProducto BISUS600G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,217,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1124,1124,NULL,1,'2022-08-18 17:37:41','2022-08-18 17:37:41',40,'AC_PRODUCT_MODIFY','2022-08-18 17:37:41','2022-08-18 05:37:41',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPAA350G modificado','Autor: admin\nProducto BPAA350G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,209,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1125,1125,NULL,1,'2022-08-18 17:37:54','2022-08-18 17:37:54',40,'AC_PRODUCT_MODIFY','2022-08-18 17:37:54','2022-08-18 05:37:54',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPARROZ500G modificado','Autor: admin\nProducto BPARROZ500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,281,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1126,1126,NULL,1,'2022-08-18 17:38:29','2022-08-18 17:38:29',40,'AC_PRODUCT_MODIFY','2022-08-18 17:38:29','2022-08-18 05:38:29',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPAVE100G modificado','Autor: admin\nProducto BPAVE100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,219,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1127,1127,NULL,1,'2022-08-18 17:38:41','2022-08-18 17:38:41',40,'AC_PRODUCT_MODIFY','2022-08-18 17:38:41','2022-08-18 05:38:41',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPELO11GR modificado','Autor: admin\nProducto BPELO11GR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,236,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1128,1128,NULL,1,'2022-08-18 17:38:49','2022-08-18 17:38:49',40,'AC_PRODUCT_MODIFY','2022-08-18 17:38:49','2022-08-18 05:38:49',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPFL336G modificado','Autor: admin\nProducto BPFL336G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,212,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1129,1129,NULL,1,'2022-08-18 17:39:02','2022-08-18 17:39:02',40,'AC_PRODUCT_MODIFY','2022-08-18 17:39:02','2022-08-18 05:39:02',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR100G modificado','Autor: admin\nProducto BPGR100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,279,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1130,1130,NULL,1,'2022-08-18 17:39:12','2022-08-18 17:39:12',40,'AC_PRODUCT_MODIFY','2022-08-18 17:39:12','2022-08-18 05:39:12',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR400G modificado','Autor: admin\nProducto BPGR400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,338,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1131,1131,NULL,1,'2022-08-18 17:40:04','2022-08-18 17:40:04',40,'AC_PRODUCT_MODIFY','2022-08-18 17:40:04','2022-08-18 05:40:04',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPLYA400G modificado','Autor: admin\nProducto BPLYA400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,208,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1132,1132,NULL,1,'2022-08-18 17:40:14','2022-08-18 17:40:14',40,'AC_PRODUCT_MODIFY','2022-08-18 17:40:14','2022-08-18 05:40:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPMA400G modificado','Autor: admin\nProducto BPMA400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,210,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1133,1133,NULL,1,'2022-08-18 17:40:27','2022-08-18 17:40:27',40,'AC_PRODUCT_MODIFY','2022-08-18 17:40:27','2022-08-18 05:40:27',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPMAN11GR modificado','Autor: admin\nProducto BPMAN11GR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,234,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1134,1134,NULL,1,'2022-08-18 17:41:04','2022-08-18 17:41:04',40,'AC_PRODUCT_MODIFY','2022-08-18 17:41:04','2022-08-18 05:41:04',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPTDP84G modificado','Autor: admin\nProducto BPTDP84G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,229,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1135,1135,NULL,1,'2022-08-18 17:42:42','2022-08-18 17:42:42',40,'AC_PRODUCT_MODIFY','2022-08-18 17:42:42','2022-08-18 05:42:42',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTBM80G modificado','Autor: admin\nProducto BTBM80G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,225,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1136,1136,NULL,1,'2022-08-18 17:42:53','2022-08-18 17:42:53',40,'AC_PRODUCT_MODIFY','2022-08-18 17:42:53','2022-08-18 05:42:53',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTCFC90G modificado','Autor: admin\nProducto BTCFC90G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,224,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1137,1137,NULL,1,'2022-08-18 17:43:08','2022-08-18 17:43:08',40,'AC_PRODUCT_MODIFY','2022-08-18 17:43:08','2022-08-18 05:43:08',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTCHB100G modificado','Autor: admin\nProducto BTCHB100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,221,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1138,1138,NULL,1,'2022-08-18 17:46:45','2022-08-18 17:46:45',40,'AC_PRODUCT_MODIFY','2022-08-18 17:46:45','2022-08-18 05:46:45',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTCHM100G modificado','Autor: admin\nProducto BTCHM100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,222,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1139,1139,NULL,1,'2022-08-18 17:47:04','2022-08-18 17:47:04',40,'AC_PRODUCT_MODIFY','2022-08-18 17:47:04','2022-08-18 05:47:04',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTCT80G modificado','Autor: admin\nProducto BTCT80G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,227,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1140,1140,NULL,1,'2022-08-18 17:47:14','2022-08-18 17:47:14',40,'AC_PRODUCT_MODIFY','2022-08-18 17:47:14','2022-08-18 05:47:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTPF100G modificado','Autor: admin\nProducto BTPF100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,337,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1141,1141,NULL,1,'2022-08-18 17:47:34','2022-08-18 17:47:34',40,'AC_PRODUCT_MODIFY','2022-08-18 17:47:34','2022-08-18 05:47:34',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CECINA modificado','Autor: admin\nProducto CECINA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,336,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1142,1142,NULL,1,'2022-08-18 17:47:47','2022-08-18 17:47:47',40,'AC_PRODUCT_MODIFY','2022-08-18 17:47:47','2022-08-18 05:47:47',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CECINAA40G modificado','Autor: admin\nProducto CECINAA40G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,232,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1143,1143,NULL,1,'2022-08-18 17:47:57','2022-08-18 17:47:57',40,'AC_PRODUCT_MODIFY','2022-08-18 17:47:57','2022-08-18 05:47:57',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CECINAH40G modificado','Autor: admin\nProducto CECINAH40G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,233,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1144,1144,NULL,1,'2022-08-18 17:52:13','2022-08-18 17:52:13',40,'AC_BILL_VALIDATE','2022-08-18 17:52:13','2022-08-18 05:52:13',4,NULL,NULL,12914,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0024 validada','Autor: yrodriguez\nFactura FA2208-0024 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,26,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1145,1145,NULL,1,'2022-08-18 17:52:33','2022-08-18 17:52:33',40,'AC_PRODUCT_MODIFY','2022-08-18 17:52:33','2022-08-18 05:52:33',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BNPPIZ336G modificado','Autor: admin\nProducto BNPPIZ336G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,215,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1146,1146,NULL,1,'2022-08-18 17:56:38','2022-08-18 17:56:38',40,'AC_BILL_VALIDATE','2022-08-18 17:56:38','2022-08-18 05:56:38',4,NULL,NULL,14336,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0025 validada','Autor: yrodriguez\nFactura FA2208-0025 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,27,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1147,1147,NULL,1,'2022-08-18 17:56:52','2022-08-18 17:56:52',40,'AC_PRODUCT_MODIFY','2022-08-18 17:56:52','2022-08-18 05:56:52',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MI40G modificado','Autor: admin\nProducto MI40G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,228,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1148,1148,NULL,1,'2022-08-18 18:06:07','2022-08-18 18:06:07',40,'AC_BILL_VALIDATE','2022-08-18 18:06:07','2022-08-18 06:06:07',4,NULL,NULL,14336,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0026 validada','Autor: yrodriguez\nFactura FA2208-0026 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,28,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1149,1149,NULL,1,'2022-08-18 18:15:45','2022-08-18 18:15:45',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-18 18:15:45','2022-08-18 06:15:45',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0058 validada','Autor: yrodriguez\nFactura SI2208-0058 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,82,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1150,1150,NULL,1,'2022-08-18 18:19:08','2022-08-18 18:19:08',40,'AC_BILL_VALIDATE','2022-08-18 18:19:08','2022-08-18 06:19:08',4,NULL,NULL,13433,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0027 validada','Autor: yrodriguez\nFactura FA2208-0027 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,29,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1151,1151,NULL,1,'2022-08-18 18:22:55','2022-08-18 18:22:55',40,'AC_BILL_VALIDATE','2022-08-18 18:22:55','2022-08-18 06:22:55',4,NULL,NULL,12201,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0028 validada','Autor: yrodriguez\nFactura FA2208-0028 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,31,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1152,1152,NULL,1,'2022-08-18 18:25:33','2022-08-18 18:25:33',40,'AC_BILL_VALIDATE','2022-08-18 18:25:33','2022-08-18 06:25:33',4,NULL,NULL,12201,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0029 validada','Autor: yrodriguez\nFactura FA2208-0029 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,32,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1153,1153,NULL,1,'2022-08-18 18:51:17','2022-08-18 18:51:17',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-18 18:51:17','2022-08-18 06:51:17',4,NULL,NULL,28,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0059 validada','Autor: yrodriguez\nFactura SI2208-0059 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,83,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1154,1154,NULL,1,'2022-08-18 19:02:44','2022-08-18 19:02:44',40,'AC_PRODUCT_MODIFY','2022-08-18 19:02:44','2022-08-18 07:02:44',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AGUA modificado','Autor: admin\nProducto AGUA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,241,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1155,1155,NULL,1,'2022-08-18 19:02:49','2022-08-18 19:02:49',40,'AC_PRODUCT_MODIFY','2022-08-18 19:02:49','2022-08-18 07:02:49',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto AGUA modificado','Autor: admin\nProducto AGUA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,241,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1156,1156,NULL,1,'2022-08-18 19:09:03','2022-08-18 19:09:03',40,'AC_PRODUCT_MODIFY','2022-08-18 19:09:03','2022-08-18 07:09:03',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BARRA_DE_COCO_Granel modificado','Autor: admin\nProducto BARRA_DE_COCO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,197,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1157,1157,NULL,1,'2022-08-18 19:09:12','2022-08-18 19:09:12',40,'AC_PRODUCT_MODIFY','2022-08-18 19:09:12','2022-08-18 07:09:12',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BARRA_DE_COCO_Granel modificado','Autor: admin\nProducto BARRA_DE_COCO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,197,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1158,1158,NULL,1,'2022-08-18 21:49:11','2022-08-18 21:49:11',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-18 21:49:11','2022-08-18 09:49:11',6,NULL,NULL,3,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0060 validada','Autor: egarcia\nFactura SI2208-0060 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,84,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1159,1159,NULL,1,'2022-08-18 21:57:07','2022-08-18 21:57:07',40,'AC_BOM_UNVALIDATE','2022-08-18 21:57:07','2022-08-18 09:57:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,16,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1160,1160,NULL,1,'2022-08-18 23:13:13','2022-08-18 23:13:13',40,'AC_BILL_VALIDATE','2022-08-18 23:13:13','2022-08-18 11:13:13',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0030 validada','Autor: egarcia\nFactura FA2208-0030 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,33,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1161,1161,NULL,1,'2022-08-19 00:56:31','2022-08-19 00:56:31',40,'AC_BILL_VALIDATE','2022-08-19 00:56:31','2022-08-18 12:56:31',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0031 validada','Autor: egarcia\nFactura FA2208-0031 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,34,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1162,1162,NULL,1,'2022-08-19 12:20:13','2022-08-19 12:20:13',40,'AC_BILL_SUPPLIER_UNVALIDATE','2022-08-19 12:20:13','2022-08-19 00:20:13',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura SI2208-0060 al estado de borrador','Autor: yrodriguez\nRegresar factura SI2208-0060 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,84,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1163,1163,NULL,1,'2022-08-19 12:24:21','2022-08-19 12:24:21',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-19 12:24:21','2022-08-19 00:24:21',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0060 validada','Autor: yrodriguez\nFactura SI2208-0060 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,84,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1164,1164,NULL,1,'2022-08-19 12:32:48','2022-08-19 12:32:48',40,'AC_BILL_SUPPLIER_UNVALIDATE','2022-08-19 12:32:48','2022-08-19 00:32:48',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura SI2208-0060 al estado de borrador','Autor: yrodriguez\nRegresar factura SI2208-0060 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,84,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1165,1165,NULL,1,'2022-08-19 12:33:18','2022-08-19 12:33:18',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-19 12:33:18','2022-08-19 00:33:18',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0060 validada','Autor: yrodriguez\nFactura SI2208-0060 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,84,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1166,1166,NULL,1,'2022-08-19 13:54:49','2022-08-19 13:54:49',40,'AC_PRODUCT_MODIFY','2022-08-19 13:54:49','2022-08-19 01:54:49',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto SUSPIRO_Granel modificado','Autor: admin\nProducto SUSPIRO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,191,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1167,1167,NULL,1,'2022-08-19 14:03:05','2022-08-19 14:03:05',40,'AC_PRODUCT_MODIFY','2022-08-19 14:03:05','2022-08-19 02:03:05',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto SUSPIRO_Granel modificado','Autor: admin\nProducto SUSPIRO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,191,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1168,1168,NULL,1,'2022-08-19 14:21:45','2022-08-19 14:21:45',40,'AC_PRODUCT_MODIFY','2022-08-19 14:21:45','2022-08-19 02:21:45',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPNU400G modificado','Autor: admin\nProducto BPNU400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,211,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1169,1169,NULL,1,'2022-08-19 14:21:52','2022-08-19 14:21:52',40,'AC_PRODUCT_MODIFY','2022-08-19 14:21:52','2022-08-19 02:21:52',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPNU400G modificado','Autor: admin\nProducto BPNU400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,211,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1170,1170,NULL,1,'2022-08-19 14:27:40','2022-08-19 14:27:40',40,'AC_PRODUCT_MODIFY','2022-08-19 14:27:40','2022-08-19 02:27:40',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Test modificado','Autor: admin\nProducto Test modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,283,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1171,1171,NULL,1,'2022-08-19 14:28:25','2022-08-19 14:28:25',40,'AC_PRODUCT_MODIFY','2022-08-19 14:28:25','2022-08-19 02:28:25',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Test modificado','Autor: admin\nProducto Test modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,283,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1172,1172,NULL,1,'2022-08-19 14:28:52','2022-08-19 14:28:52',40,'AC_PRODUCT_MODIFY','2022-08-19 14:28:52','2022-08-19 02:28:52',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Test modificado','Autor: admin\nProducto Test modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,283,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1173,1173,NULL,1,'2022-08-19 14:29:24','2022-08-19 14:29:24',40,'AC_PRODUCT_MODIFY','2022-08-19 14:29:24','2022-08-19 02:29:24',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Test modificado','Autor: admin\nProducto Test modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,283,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1174,1174,NULL,1,'2022-08-19 14:29:51','2022-08-19 14:29:51',40,'AC_PRODUCT_MODIFY','2022-08-19 14:29:51','2022-08-19 02:29:51',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto Test modificado','Autor: admin\nProducto Test modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,283,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1175,1175,NULL,1,'2022-08-19 14:46:39','2022-08-19 14:46:39',40,'AC_BILL_VALIDATE','2022-08-19 14:46:39','2022-08-19 02:46:39',4,NULL,NULL,14336,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0032 validada','Autor: yrodriguez\nFactura FA2208-0032 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,35,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1176,1176,NULL,1,'2022-08-19 18:55:42','2022-08-19 18:55:42',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-19 18:55:42','2022-08-19 06:55:42',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0061 validada','Autor: yrodriguez\nFactura SI2208-0061 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,85,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1177,1177,NULL,1,'2022-08-19 19:00:02','2022-08-19 19:00:02',40,'AC_BILL_VALIDATE','2022-08-19 19:00:02','2022-08-19 07:00:02',4,NULL,NULL,14336,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0033 validada','Autor: yrodriguez\nFactura FA2208-0033 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,36,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1178,1178,NULL,1,'2022-08-19 19:00:49','2022-08-19 19:00:49',40,'AC_BILL_VALIDATE','2022-08-19 19:00:49','2022-08-19 07:00:49',4,NULL,NULL,13342,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0034 validada','Autor: yrodriguez\nFactura FA2208-0034 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,37,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1179,1179,NULL,1,'2022-08-19 19:01:51','2022-08-19 19:01:51',40,'AC_BILL_VALIDATE','2022-08-19 19:01:51','2022-08-19 07:01:51',4,NULL,NULL,12697,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0035 validada','Autor: yrodriguez\nFactura FA2208-0035 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,38,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1180,1180,NULL,1,'2022-08-19 19:02:48','2022-08-19 19:02:48',40,'AC_BILL_VALIDATE','2022-08-19 19:02:48','2022-08-19 07:02:48',4,NULL,NULL,13591,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0036 validada','Autor: yrodriguez\nFactura FA2208-0036 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,39,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1181,1181,NULL,1,'2022-08-19 19:06:03','2022-08-19 19:06:03',40,'AC_BILL_VALIDATE','2022-08-19 19:06:03','2022-08-19 07:06:03',4,NULL,NULL,14336,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0037 validada','Autor: yrodriguez\nFactura FA2208-0037 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,40,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1182,1182,NULL,1,'2022-08-19 19:49:49','2022-08-19 19:49:49',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-19 19:49:49','2022-08-19 07:49:49',4,NULL,NULL,4,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0062 validada','Autor: yrodriguez\nFactura SI2208-0062 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,86,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1183,1183,NULL,1,'2022-08-19 21:15:34','2022-08-19 21:15:34',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-19 21:15:34','2022-08-19 09:15:34',6,NULL,NULL,3,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0063 validada','Autor: egarcia\nFactura SI2208-0063 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,87,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1184,1184,NULL,1,'2022-08-19 21:18:49','2022-08-19 21:18:49',40,'AC_BILL_VALIDATE','2022-08-19 21:18:49','2022-08-19 09:18:49',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0038 validada','Autor: egarcia\nFactura FA2208-0038 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,41,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1185,1185,NULL,1,'2022-08-20 01:08:13','2022-08-20 01:08:13',40,'AC_BILL_VALIDATE','2022-08-20 01:08:13','2022-08-19 13:08:13',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0039 validada','Autor: egarcia\nFactura FA2208-0039 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,44,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1186,1186,NULL,1,'2022-08-20 02:05:45','2022-08-20 02:05:45',40,'AC_BILL_VALIDATE','2022-08-20 02:05:45','2022-08-19 14:05:45',11,NULL,NULL,10838,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0040 validada','Autor: gdealba\nFactura FA2208-0040 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,45,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1187,1187,NULL,1,'2022-08-20 02:11:26','2022-08-20 02:11:26',40,'AC_BILL_UNVALIDATE','2022-08-20 02:11:26','2022-08-19 14:11:26',11,NULL,NULL,10838,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura FA2208-0040 al estado de borrador','Autor: gdealba\nRegresar factura FA2208-0040 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,45,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1188,1188,NULL,1,'2022-08-20 02:11:55','2022-08-20 02:11:55',40,'AC_BILL_VALIDATE','2022-08-20 02:11:55','2022-08-19 14:11:55',11,NULL,NULL,10838,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0040 validada','Autor: gdealba\nFactura FA2208-0040 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,45,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1189,1189,NULL,1,'2022-08-20 02:12:10','2022-08-20 02:12:10',40,'AC_BILL_UNVALIDATE','2022-08-20 02:12:10','2022-08-19 14:12:10',11,NULL,NULL,10838,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura FA2208-0040 al estado de borrador','Autor: gdealba\nRegresar factura FA2208-0040 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,45,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1190,1190,NULL,1,'2022-08-20 02:12:58','2022-08-20 02:12:58',40,'AC_BILL_VALIDATE','2022-08-20 02:12:58','2022-08-19 14:12:58',11,NULL,NULL,10838,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0040 validada','Autor: gdealba\nFactura FA2208-0040 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,45,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1191,1191,NULL,1,'2022-08-20 02:23:19','2022-08-20 02:23:19',40,'AC_BILL_VALIDATE','2022-08-20 02:23:19','2022-08-19 14:23:19',11,NULL,NULL,10906,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0041 validada','Autor: gdealba\nFactura FA2208-0041 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,46,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1192,1192,NULL,1,'2022-08-20 15:52:49','2022-08-20 15:52:49',40,'AC_BILL_VALIDATE','2022-08-20 15:52:49','2022-08-20 03:52:49',4,NULL,NULL,13591,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0042 validada','Autor: yrodriguez\nFactura FA2208-0042 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,47,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1193,1193,NULL,1,'2022-08-20 15:53:14','2022-08-20 15:53:14',40,'AC_BILL_SUPPLIER_UNVALIDATE','2022-08-20 15:53:14','2022-08-20 03:53:14',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura SI2208-0063 al estado de borrador','Autor: yrodriguez\nRegresar factura SI2208-0063 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,87,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1194,1194,NULL,1,'2022-08-20 15:53:50','2022-08-20 15:53:50',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-20 15:53:50','2022-08-20 03:53:50',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0063 validada','Autor: yrodriguez\nFactura SI2208-0063 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,87,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1195,1195,NULL,1,'2022-08-20 16:02:23','2022-08-20 16:02:23',40,'AC_PRODUCT_MODIFY','2022-08-20 16:02:23','2022-08-20 04:02:23',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CACAHUATE_JAPONES modificado','Autor: admin\nProducto CACAHUATE_JAPONES modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,226,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1196,1196,NULL,1,'2022-08-20 17:37:44','2022-08-20 17:37:44',40,'AC_BILL_VALIDATE','2022-08-20 17:37:44','2022-08-20 05:37:44',4,NULL,NULL,14336,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0043 validada','Autor: yrodriguez\nFactura FA2208-0043 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,48,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1197,1197,NULL,1,'2022-08-20 17:41:46','2022-08-20 17:41:46',40,'AC_BILL_DELETE','2022-08-20 17:41:46','2022-08-20 05:41:46',4,NULL,NULL,14336,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura eliminada','Autor: yrodriguez\nFactura eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,48,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1198,1198,NULL,1,'2022-08-20 18:45:29','2022-08-20 18:45:29',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-20 18:45:29','2022-08-20 06:45:29',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0064 validada','Autor: yrodriguez\nFactura SI2208-0064 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,88,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1199,1199,NULL,1,'2022-08-20 19:11:43','2022-08-20 19:11:43',40,'AC_BILL_VALIDATE','2022-08-20 19:11:43','2022-08-20 07:11:43',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0043 validada','Autor: egarcia\nFactura FA2208-0043 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,49,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1200,1200,NULL,1,'2022-08-20 19:28:07','2022-08-20 19:28:07',40,'AC_BILL_VALIDATE','2022-08-20 19:28:07','2022-08-20 07:28:08',4,NULL,NULL,13591,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0044 validada','Autor: yrodriguez\nFactura FA2208-0044 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,50,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1201,1201,NULL,1,'2022-08-20 20:29:54','2022-08-20 20:29:54',40,'AC_BILL_VALIDATE','2022-08-20 20:29:54','2022-08-20 08:29:54',11,NULL,NULL,10907,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0045 validada','Autor: gdealba\nFactura FA2208-0045 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,51,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1202,1202,NULL,1,'2022-08-20 20:31:09','2022-08-20 20:31:09',40,'AC_BILL_VALIDATE','2022-08-20 20:31:09','2022-08-20 08:31:09',11,NULL,NULL,10914,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0046 validada','Autor: gdealba\nFactura FA2208-0046 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,52,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1203,1203,NULL,1,'2022-08-20 20:32:37','2022-08-20 20:32:37',40,'AC_BILL_VALIDATE','2022-08-20 20:32:37','2022-08-20 08:32:37',11,NULL,NULL,10914,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0047 validada','Autor: gdealba\nFactura FA2208-0047 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,53,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1204,1204,NULL,1,'2022-08-20 20:34:08','2022-08-20 20:34:08',40,'AC_BILL_VALIDATE','2022-08-20 20:34:08','2022-08-20 08:34:08',11,NULL,NULL,11041,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0048 validada','Autor: gdealba\nFactura FA2208-0048 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,54,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1205,1205,NULL,1,'2022-08-20 20:35:38','2022-08-20 20:35:38',40,'AC_BILL_VALIDATE','2022-08-20 20:35:38','2022-08-20 08:35:38',11,NULL,NULL,11072,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0049 validada','Autor: gdealba\nFactura FA2208-0049 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,55,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1206,1206,NULL,1,'2022-08-20 20:40:33','2022-08-20 20:40:33',40,'AC_BILL_VALIDATE','2022-08-20 20:40:33','2022-08-20 08:40:33',11,NULL,NULL,11079,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0050 validada','Autor: gdealba\nFactura FA2208-0050 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,56,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1207,1207,NULL,1,'2022-08-20 20:41:55','2022-08-20 20:41:55',40,'AC_BILL_VALIDATE','2022-08-20 20:41:55','2022-08-20 08:41:55',11,NULL,NULL,11646,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0051 validada','Autor: gdealba\nFactura FA2208-0051 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,57,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1208,1208,NULL,1,'2022-08-20 20:42:45','2022-08-20 20:42:45',40,'AC_BILL_VALIDATE','2022-08-20 20:42:45','2022-08-20 08:42:45',11,NULL,NULL,11656,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0052 validada','Autor: gdealba\nFactura FA2208-0052 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,58,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1209,1209,NULL,1,'2022-08-20 20:44:39','2022-08-20 20:44:39',40,'AC_BILL_VALIDATE','2022-08-20 20:44:39','2022-08-20 08:44:39',11,NULL,NULL,11657,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0053 validada','Autor: gdealba\nFactura FA2208-0053 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,59,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1210,1210,NULL,1,'2022-08-20 20:45:49','2022-08-20 20:45:49',40,'AC_BILL_VALIDATE','2022-08-20 20:45:49','2022-08-20 08:45:49',11,NULL,NULL,12081,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0054 validada','Autor: gdealba\nFactura FA2208-0054 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,60,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1211,1211,NULL,1,'2022-08-20 20:47:58','2022-08-20 20:47:58',40,'AC_BILL_VALIDATE','2022-08-20 20:47:58','2022-08-20 08:47:58',11,NULL,NULL,12081,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0055 validada','Autor: gdealba\nFactura FA2208-0055 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,61,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1212,1212,NULL,1,'2022-08-20 21:02:37','2022-08-20 21:02:37',40,'AC_BILL_UNVALIDATE','2022-08-20 21:02:37','2022-08-20 09:02:37',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura FA2208-0043 al estado de borrador','Autor: egarcia\nRegresar factura FA2208-0043 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,49,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1213,1213,NULL,1,'2022-08-20 21:02:49','2022-08-20 21:02:49',40,'AC_BILL_VALIDATE','2022-08-20 21:02:49','2022-08-20 09:02:49',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0043 validada','Autor: egarcia\nFactura FA2208-0043 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,49,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1214,1214,NULL,1,'2022-08-20 21:03:16','2022-08-20 21:03:16',40,'AC_BILL_UNVALIDATE','2022-08-20 21:03:16','2022-08-20 09:03:16',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura FA2208-0043 al estado de borrador','Autor: egarcia\nRegresar factura FA2208-0043 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,49,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1215,1215,NULL,1,'2022-08-20 21:03:36','2022-08-20 21:03:36',40,'AC_BILL_VALIDATE','2022-08-20 21:03:36','2022-08-20 09:03:36',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0043 validada','Autor: egarcia\nFactura FA2208-0043 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,49,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1216,1216,NULL,1,'2022-08-20 21:07:18','2022-08-20 21:07:18',40,'AC_BILL_VALIDATE','2022-08-20 21:07:18','2022-08-20 09:07:18',11,NULL,NULL,12158,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0056 validada','Autor: gdealba\nFactura FA2208-0056 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,62,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1217,1217,NULL,1,'2022-08-20 21:12:01','2022-08-20 21:12:01',40,'AC_BILL_VALIDATE','2022-08-20 21:12:01','2022-08-20 09:12:01',11,NULL,NULL,12199,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0057 validada','Autor: gdealba\nFactura FA2208-0057 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,63,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1218,1218,NULL,1,'2022-08-20 21:14:54','2022-08-20 21:14:54',40,'AC_BILL_VALIDATE','2022-08-20 21:14:54','2022-08-20 09:14:54',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0058 validada','Autor: gdealba\nFactura FA2208-0058 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,64,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1219,1219,NULL,1,'2022-08-20 21:15:42','2022-08-20 21:15:42',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-20 21:15:42','2022-08-20 09:15:42',6,NULL,NULL,3,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0065 validada','Autor: egarcia\nFactura SI2208-0065 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,89,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1220,1220,NULL,1,'2022-08-20 21:16:17','2022-08-20 21:16:17',40,'AC_BILL_VALIDATE','2022-08-20 21:16:17','2022-08-20 09:16:17',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0059 validada','Autor: gdealba\nFactura FA2208-0059 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,65,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1221,1221,NULL,1,'2022-08-20 21:18:23','2022-08-20 21:18:23',40,'AC_BILL_VALIDATE','2022-08-20 21:18:23','2022-08-20 09:18:23',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0060 validada','Autor: gdealba\nFactura FA2208-0060 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,67,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1222,1222,NULL,1,'2022-08-20 21:20:03','2022-08-20 21:20:03',40,'AC_BILL_VALIDATE','2022-08-20 21:20:03','2022-08-20 09:20:03',11,NULL,NULL,12199,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0061 validada','Autor: gdealba\nFactura FA2208-0061 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,68,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1223,1223,NULL,1,'2022-08-20 21:21:11','2022-08-20 21:21:11',40,'AC_BILL_VALIDATE','2022-08-20 21:21:11','2022-08-20 09:21:11',11,NULL,NULL,12348,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0062 validada','Autor: gdealba\nFactura FA2208-0062 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,69,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1224,1224,NULL,1,'2022-08-20 21:22:06','2022-08-20 21:22:06',40,'AC_BILL_VALIDATE','2022-08-20 21:22:06','2022-08-20 09:22:06',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0063 validada','Autor: egarcia\nFactura FA2208-0063 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,66,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1225,1225,NULL,1,'2022-08-20 21:22:18','2022-08-20 21:22:18',40,'AC_BILL_VALIDATE','2022-08-20 21:22:18','2022-08-20 09:22:18',11,NULL,NULL,12593,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0064 validada','Autor: gdealba\nFactura FA2208-0064 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,70,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1226,1226,NULL,1,'2022-08-20 21:23:34','2022-08-20 21:23:34',40,'AC_BILL_VALIDATE','2022-08-20 21:23:34','2022-08-20 09:23:34',11,NULL,NULL,12882,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0065 validada','Autor: gdealba\nFactura FA2208-0065 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,71,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1227,1227,NULL,1,'2022-08-20 21:26:43','2022-08-20 21:26:43',40,'AC_BILL_VALIDATE','2022-08-20 21:26:43','2022-08-20 09:26:43',11,NULL,NULL,12889,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0066 validada','Autor: gdealba\nFactura FA2208-0066 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,72,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1228,1228,NULL,1,'2022-08-20 21:29:03','2022-08-20 21:29:03',40,'AC_BILL_VALIDATE','2022-08-20 21:29:03','2022-08-20 09:29:03',11,NULL,NULL,12889,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0067 validada','Autor: gdealba\nFactura FA2208-0067 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,73,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1229,1229,NULL,1,'2022-08-20 21:32:33','2022-08-20 21:32:33',40,'AC_PRODUCT_MODIFY','2022-08-20 21:32:33','2022-08-20 09:32:33',4,NULL,NULL,NULL,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Producto AVENA_GRANEL modificado','Autor: yrodriguez\nProducto AVENA_GRANEL modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,186,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1230,1230,NULL,1,'2022-08-20 21:33:17','2022-08-20 21:33:17',40,'AC_BILL_VALIDATE','2022-08-20 21:33:17','2022-08-20 09:33:17',11,NULL,NULL,13128,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0068 validada','Autor: gdealba\nFactura FA2208-0068 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,74,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1231,1231,NULL,1,'2022-08-20 21:36:07','2022-08-20 21:36:07',40,'AC_BILL_VALIDATE','2022-08-20 21:36:07','2022-08-20 09:36:07',11,NULL,NULL,13132,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0069 validada','Autor: gdealba\nFactura FA2208-0069 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,75,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1232,1232,NULL,1,'2022-08-20 21:37:28','2022-08-20 21:37:28',40,'AC_BILL_VALIDATE','2022-08-20 21:37:28','2022-08-20 09:37:28',11,NULL,NULL,13630,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0070 validada','Autor: gdealba\nFactura FA2208-0070 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,76,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1233,1233,NULL,1,'2022-08-20 21:40:14','2022-08-20 21:40:14',40,'AC_BILL_VALIDATE','2022-08-20 21:40:14','2022-08-20 09:40:14',11,NULL,NULL,13631,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0071 validada','Autor: gdealba\nFactura FA2208-0071 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,77,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1234,1234,NULL,1,'2022-08-20 21:44:40','2022-08-20 21:44:40',40,'AC_BILL_VALIDATE','2022-08-20 21:44:40','2022-08-20 09:44:40',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0072 validada','Autor: egarcia\nFactura FA2208-0072 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,79,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1235,1235,NULL,1,'2022-08-20 21:49:25','2022-08-20 21:49:25',40,'AC_BILL_DELETE','2022-08-20 21:49:25','2022-08-20 09:49:25',11,NULL,NULL,13632,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura eliminada','Autor: gdealba\nFactura eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,78,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1236,1236,NULL,1,'2022-08-20 22:36:39','2022-08-20 22:36:39',40,'AC_PRODUCT_MODIFY','2022-08-20 22:36:39','2022-08-20 10:36:39',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTCFSCH90G modificado','Autor: admin\nProducto BTCFSCH90G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,223,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1237,1237,NULL,1,'2022-08-20 22:37:18','2022-08-20 22:37:18',40,'AC_BILL_DELETE','2022-08-20 22:37:18','2022-08-20 10:37:18',11,NULL,NULL,13632,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura eliminada','Autor: gdealba\nFactura eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,80,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1238,1238,NULL,1,'2022-08-20 22:38:59','2022-08-20 22:38:59',40,'AC_USER_MODIFY','2022-08-20 22:38:59','2022-08-20 10:38:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 11 modificado','Autor: admin\nRegistro 11 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,11,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1239,1239,NULL,1,'2022-08-20 22:41:44','2022-08-20 22:41:44',40,'AC_BILL_VALIDATE','2022-08-20 22:41:44','2022-08-20 10:41:44',11,NULL,NULL,13632,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0073 validada','Autor: gdealba\nFactura FA2208-0073 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,81,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1240,1240,NULL,1,'2022-08-20 22:42:24','2022-08-20 22:42:24',40,'AC_BILL_VALIDATE','2022-08-20 22:42:24','2022-08-20 10:42:24',11,NULL,NULL,13632,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0074 validada','Autor: gdealba\nFactura FA2208-0074 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,82,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1241,1241,NULL,1,'2022-08-20 22:45:03','2022-08-20 22:45:03',40,'AC_BILL_VALIDATE','2022-08-20 22:45:03','2022-08-20 10:45:03',11,NULL,NULL,13633,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0075 validada','Autor: gdealba\nFactura FA2208-0075 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,83,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1242,1242,NULL,1,'2022-08-20 22:46:44','2022-08-20 22:46:44',40,'AC_BILL_VALIDATE','2022-08-20 22:46:44','2022-08-20 10:46:44',11,NULL,NULL,13634,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0076 validada','Autor: gdealba\nFactura FA2208-0076 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,84,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1243,1243,NULL,1,'2022-08-20 22:48:36','2022-08-20 22:48:36',40,'AC_BILL_VALIDATE','2022-08-20 22:48:36','2022-08-20 10:48:36',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0077 validada','Autor: gdealba\nFactura FA2208-0077 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,85,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1244,1244,NULL,1,'2022-08-20 22:49:20','2022-08-20 22:49:20',40,'AC_BILL_VALIDATE','2022-08-20 22:49:20','2022-08-20 10:49:20',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0078 validada','Autor: gdealba\nFactura FA2208-0078 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,86,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1245,1245,NULL,1,'2022-08-20 22:53:43','2022-08-20 22:53:43',40,'AC_BILL_VALIDATE','2022-08-20 22:53:43','2022-08-20 10:53:43',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0079 validada','Autor: gdealba\nFactura FA2208-0079 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,87,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1246,1246,NULL,1,'2022-08-20 22:54:46','2022-08-20 22:54:46',40,'AC_BILL_VALIDATE','2022-08-20 22:54:46','2022-08-20 10:54:46',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0080 validada','Autor: gdealba\nFactura FA2208-0080 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,88,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1247,1247,NULL,1,'2022-08-20 22:55:53','2022-08-20 22:55:53',40,'AC_PRODUCT_MODIFY','2022-08-20 22:55:53','2022-08-20 10:55:53',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CACAHUATE_JAPONES modificado','Autor: admin\nProducto CACAHUATE_JAPONES modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,226,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1248,1248,NULL,1,'2022-08-20 22:56:47','2022-08-20 22:56:47',40,'AC_BILL_VALIDATE','2022-08-20 22:56:47','2022-08-20 10:56:47',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0081 validada','Autor: gdealba\nFactura FA2208-0081 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,89,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1249,1249,NULL,1,'2022-08-20 22:57:34','2022-08-20 22:57:34',40,'AC_BILL_VALIDATE','2022-08-20 22:57:34','2022-08-20 10:57:34',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0082 validada','Autor: gdealba\nFactura FA2208-0082 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,90,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1250,1250,NULL,1,'2022-08-20 22:57:47','2022-08-20 22:57:47',40,'AC_PRODUCT_MODIFY','2022-08-20 22:57:47','2022-08-20 10:57:47',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BP_BARRA_DE_COCO_400g modificado','Autor: admin\nProducto BP_BARRA_DE_COCO_400g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,214,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1251,1251,NULL,1,'2022-08-20 23:03:10','2022-08-20 23:03:10',40,'AC_BILL_VALIDATE','2022-08-20 23:03:10','2022-08-20 11:03:10',11,NULL,NULL,13991,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0083 validada','Autor: gdealba\nFactura FA2208-0083 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,91,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1252,1252,NULL,1,'2022-08-20 23:12:54','2022-08-20 23:12:54',40,'AC_BILL_UNVALIDATE','2022-08-20 23:12:54','2022-08-20 11:12:54',11,NULL,NULL,13991,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura FA2208-0083 al estado de borrador','Autor: gdealba\nRegresar factura FA2208-0083 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,91,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1253,1253,NULL,1,'2022-08-20 23:21:01','2022-08-20 23:21:01',40,'AC_BILL_VALIDATE','2022-08-20 23:21:01','2022-08-20 11:21:01',11,NULL,NULL,14171,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0084 validada','Autor: gdealba\nFactura FA2208-0084 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,92,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1254,1254,NULL,1,'2022-08-20 23:24:40','2022-08-20 23:24:40',40,'AC_BILL_VALIDATE','2022-08-20 23:24:40','2022-08-20 11:24:40',11,NULL,NULL,14161,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0085 validada','Autor: gdealba\nFactura FA2208-0085 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,93,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1255,1255,NULL,1,'2022-08-20 23:25:47','2022-08-20 23:25:47',40,'AC_BILL_UNVALIDATE','2022-08-20 23:25:47','2022-08-20 11:25:47',11,NULL,NULL,14161,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura FA2208-0085 al estado de borrador','Autor: gdealba\nRegresar factura FA2208-0085 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,93,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1256,1256,NULL,1,'2022-08-20 23:26:09','2022-08-20 23:26:09',40,'AC_BILL_VALIDATE','2022-08-20 23:26:09','2022-08-20 11:26:09',11,NULL,NULL,14161,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0085 validada','Autor: gdealba\nFactura FA2208-0085 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,93,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1257,1257,NULL,1,'2022-08-21 00:30:17','2022-08-21 00:30:17',40,'AC_BILL_VALIDATE','2022-08-21 00:30:17','2022-08-20 12:30:17',11,NULL,NULL,10943,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0086 validada','Autor: gdealba\nFactura FA2208-0086 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,94,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1258,1258,NULL,1,'2022-08-21 00:31:47','2022-08-21 00:31:47',40,'AC_BILL_VALIDATE','2022-08-21 00:31:47','2022-08-20 12:31:47',11,NULL,NULL,13645,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0087 validada','Autor: gdealba\nFactura FA2208-0087 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,95,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1259,1259,NULL,1,'2022-08-21 00:33:17','2022-08-21 00:33:17',40,'AC_BILL_VALIDATE','2022-08-21 00:33:17','2022-08-20 12:33:17',11,NULL,NULL,13645,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0088 validada','Autor: gdealba\nFactura FA2208-0088 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,96,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1260,1260,NULL,1,'2022-08-21 00:35:25','2022-08-21 00:35:25',40,'AC_BILL_VALIDATE','2022-08-21 00:35:25','2022-08-20 12:35:25',11,NULL,NULL,11628,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0089 validada','Autor: gdealba\nFactura FA2208-0089 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,97,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1261,1261,NULL,1,'2022-08-21 00:36:34','2022-08-21 00:36:34',40,'AC_BILL_VALIDATE','2022-08-21 00:36:34','2022-08-20 12:36:34',11,NULL,NULL,11801,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0090 validada','Autor: gdealba\nFactura FA2208-0090 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,98,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1262,1262,NULL,1,'2022-08-21 00:37:50','2022-08-21 00:37:50',40,'AC_BILL_VALIDATE','2022-08-21 00:37:50','2022-08-20 12:37:50',11,NULL,NULL,11827,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0091 validada','Autor: gdealba\nFactura FA2208-0091 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,99,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1263,1263,NULL,1,'2022-08-21 00:39:03','2022-08-21 00:39:03',40,'AC_BILL_VALIDATE','2022-08-21 00:39:03','2022-08-20 12:39:03',11,NULL,NULL,11839,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0092 validada','Autor: gdealba\nFactura FA2208-0092 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,100,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1264,1264,NULL,1,'2022-08-22 15:22:03','2022-08-22 15:22:03',40,'AC_BILL_VALIDATE','2022-08-22 15:22:03','2022-08-22 03:22:03',6,NULL,NULL,13209,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0093 validada','Autor: egarcia\nFactura FA2208-0093 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,101,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1265,1265,NULL,1,'2022-08-22 15:22:42','2022-08-22 15:22:42',40,'AC_BILL_VALIDATE','2022-08-22 15:22:42','2022-08-22 03:22:42',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0094 validada','Autor: egarcia\nFactura FA2208-0094 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,102,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1266,1266,NULL,1,'2022-08-22 15:57:59','2022-08-22 15:57:59',40,'AC_BOM_VALIDATE','2022-08-22 15:57:59','2022-08-22 03:57:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,71,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1267,1267,NULL,1,'2022-08-22 15:58:04','2022-08-22 15:58:04',40,'AC_BOM_UNVALIDATE','2022-08-22 15:58:04','2022-08-22 03:58:04',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,71,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1268,1268,NULL,1,'2022-08-22 16:07:17','2022-08-22 16:07:17',40,'AC_BOM_UNVALIDATE','2022-08-22 16:07:17','2022-08-22 04:07:17',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,1,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1269,1269,NULL,1,'2022-08-22 16:07:41','2022-08-22 16:07:41',40,'AC_BOM_VALIDATE','2022-08-22 16:07:41','2022-08-22 04:07:41',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,1,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1270,1270,NULL,1,'2022-08-22 17:22:37','2022-08-22 17:22:37',40,'AC_BOM_VALIDATE','2022-08-22 17:22:37','2022-08-22 05:22:37',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,42,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1271,1271,NULL,1,'2022-08-22 17:22:43','2022-08-22 17:22:43',40,'AC_BOM_UNVALIDATE','2022-08-22 17:22:43','2022-08-22 05:22:43',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,42,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1272,1272,NULL,1,'2022-08-22 19:21:53','2022-08-22 19:21:53',40,'AC_BILL_VALIDATE','2022-08-22 19:21:53','2022-08-22 07:21:53',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0095 validada','Autor: egarcia\nFactura FA2208-0095 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,103,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1273,1273,NULL,1,'2022-08-22 19:39:20','2022-08-22 19:39:20',40,'AC_PRODUCT_MODIFY','2022-08-22 19:39:20','2022-08-22 07:39:20',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEAGRANEL modificado','Autor: admin\nProducto GRAGEAGRANEL modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,187,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1274,1274,NULL,1,'2022-08-22 19:41:07','2022-08-22 19:41:07',40,'AC_PRODUCT_MODIFY','2022-08-22 19:41:07','2022-08-22 07:41:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEA_CHOCOLATE_Granel modificado','Autor: admin\nProducto GRAGEA_CHOCOLATE_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,193,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1275,1275,NULL,1,'2022-08-22 19:41:42','2022-08-22 19:41:42',40,'AC_PRODUCT_MODIFY','2022-08-22 19:41:42','2022-08-22 07:41:42',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEA_CHOCOLATE_Granel modificado','Autor: admin\nProducto GRAGEA_CHOCOLATE_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,193,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1276,1276,NULL,1,'2022-08-22 19:42:16','2022-08-22 19:42:16',40,'AC_PRODUCT_MODIFY','2022-08-22 19:42:16','2022-08-22 07:42:16',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BARRA_DE_COCO_Granel modificado','Autor: admin\nProducto BARRA_DE_COCO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,197,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1277,1277,NULL,1,'2022-08-22 19:42:34','2022-08-22 19:42:34',40,'AC_PRODUCT_MODIFY','2022-08-22 19:42:34','2022-08-22 07:42:34',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BARRA_DE_COCO_Granel modificado','Autor: admin\nProducto BARRA_DE_COCO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,197,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1278,1278,NULL,1,'2022-08-22 19:42:43','2022-08-22 19:42:43',40,'AC_PRODUCT_MODIFY','2022-08-22 19:42:43','2022-08-22 07:42:43',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BARRA_DE_COCO_Granel modificado','Autor: admin\nProducto BARRA_DE_COCO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,197,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1279,1279,NULL,1,'2022-08-22 19:43:30','2022-08-22 19:43:30',40,'AC_PRODUCT_MODIFY','2022-08-22 19:43:30','2022-08-22 07:43:30',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto VAINILLA_FLOR_DE_CAYRO_Granel modificado','Autor: admin\nProducto VAINILLA_FLOR_DE_CAYRO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,190,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1280,1280,NULL,1,'2022-08-22 19:44:19','2022-08-22 19:44:19',40,'AC_PRODUCT_MODIFY','2022-08-22 19:44:19','2022-08-22 07:44:19',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto VAINILLA_FLOR_DE_CAYRO_Granel modificado','Autor: admin\nProducto VAINILLA_FLOR_DE_CAYRO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,190,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1281,1281,NULL,1,'2022-08-22 19:45:23','2022-08-22 19:45:23',40,'AC_PRODUCT_MODIFY','2022-08-22 19:45:23','2022-08-22 07:45:23',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MARMOLEADAS_AZUCARADAS_Granel modificado','Autor: admin\nProducto MARMOLEADAS_AZUCARADAS_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,189,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1282,1282,NULL,1,'2022-08-22 19:45:44','2022-08-22 19:45:44',40,'AC_PRODUCT_MODIFY','2022-08-22 19:45:44','2022-08-22 07:45:44',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MARMOLEADAS_AZUCARADAS_Granel modificado','Autor: admin\nProducto MARMOLEADAS_AZUCARADAS_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,189,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1283,1283,NULL,1,'2022-08-22 19:46:18','2022-08-22 19:46:18',40,'AC_PRODUCT_MODIFY','2022-08-22 19:46:18','2022-08-22 07:46:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GTAS._NUEZ_CON_GLAS_Granel modificado','Autor: admin\nProducto GTAS._NUEZ_CON_GLAS_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,188,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1284,1284,NULL,1,'2022-08-22 19:46:30','2022-08-22 19:46:30',40,'AC_PRODUCT_MODIFY','2022-08-22 19:46:30','2022-08-22 07:46:30',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GTAS._NUEZ_CON_GLAS_Granel modificado','Autor: admin\nProducto GTAS._NUEZ_CON_GLAS_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,188,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1285,1285,NULL,1,'2022-08-22 19:46:59','2022-08-22 19:46:59',40,'AC_PRODUCT_MODIFY','2022-08-22 19:46:59','2022-08-22 07:46:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto OREJAS_Granel modificado','Autor: admin\nProducto OREJAS_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,194,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1286,1286,NULL,1,'2022-08-22 19:47:07','2022-08-22 19:47:07',40,'AC_PRODUCT_MODIFY','2022-08-22 19:47:07','2022-08-22 07:47:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto OREJAS_Granel modificado','Autor: admin\nProducto OREJAS_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,194,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1287,1287,NULL,1,'2022-08-22 19:47:47','2022-08-22 19:47:47',40,'AC_PRODUCT_MODIFY','2022-08-22 19:47:47','2022-08-22 07:47:47',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto SUSPIRO_Granel modificado','Autor: admin\nProducto SUSPIRO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,191,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1288,1288,NULL,1,'2022-08-22 19:48:02','2022-08-22 19:48:02',40,'AC_PRODUCT_MODIFY','2022-08-22 19:48:02','2022-08-22 07:48:02',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto SUSPIRO_Granel modificado','Autor: admin\nProducto SUSPIRO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,191,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1289,1289,NULL,1,'2022-08-22 19:48:59','2022-08-22 19:48:59',40,'AC_PRODUCT_MODIFY','2022-08-22 19:48:59','2022-08-22 07:48:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPAVE500G modificado','Autor: admin\nProducto BPAVE500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,203,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1290,1290,NULL,1,'2022-08-22 19:49:28','2022-08-22 19:49:28',40,'AC_PRODUCT_MODIFY','2022-08-22 19:49:28','2022-08-22 07:49:28',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPAVE100G modificado','Autor: admin\nProducto BPAVE100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,219,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1291,1291,NULL,1,'2022-08-22 19:50:03','2022-08-22 19:50:03',40,'AC_PRODUCT_MODIFY','2022-08-22 19:50:03','2022-08-22 07:50:03',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPAA350G modificado','Autor: admin\nProducto BPAA350G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,209,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1292,1292,NULL,1,'2022-08-22 19:51:00','2022-08-22 19:51:00',40,'AC_PRODUCT_MODIFY','2022-08-22 19:51:00','2022-08-22 07:51:00',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR500G modificado','Autor: admin\nProducto BPGR500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,205,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1293,1293,NULL,1,'2022-08-22 19:51:33','2022-08-22 19:51:33',40,'AC_PRODUCT_MODIFY','2022-08-22 19:51:33','2022-08-22 07:51:33',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR100G modificado','Autor: admin\nProducto BPGR100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,279,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1294,1294,NULL,1,'2022-08-22 19:51:38','2022-08-22 19:51:38',40,'AC_PRODUCT_MODIFY','2022-08-22 19:51:38','2022-08-22 07:51:38',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR100G modificado','Autor: admin\nProducto BPGR100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,279,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1295,1295,NULL,1,'2022-08-22 19:52:42','2022-08-22 19:52:42',40,'AC_PRODUCT_MODIFY','2022-08-22 19:52:42','2022-08-22 07:52:42',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR400G modificado','Autor: admin\nProducto BPGR400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,338,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1296,1296,NULL,1,'2022-08-22 19:52:47','2022-08-22 19:52:47',40,'AC_PRODUCT_MODIFY','2022-08-22 19:52:47','2022-08-22 07:52:47',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR400G modificado','Autor: admin\nProducto BPGR400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,338,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1297,1297,NULL,1,'2022-08-22 19:53:04','2022-08-22 19:53:04',40,'AC_PRODUCT_MODIFY','2022-08-22 19:53:04','2022-08-22 07:53:04',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR400G modificado','Autor: admin\nProducto BPGR400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,338,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1298,1298,NULL,1,'2022-08-22 19:53:48','2022-08-22 19:53:48',40,'AC_PRODUCT_MODIFY','2022-08-22 19:53:48','2022-08-22 07:53:48',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGCH400G modificado','Autor: admin\nProducto BPGCH400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,280,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1299,1299,NULL,1,'2022-08-22 19:53:53','2022-08-22 19:53:53',40,'AC_PRODUCT_MODIFY','2022-08-22 19:53:53','2022-08-22 07:53:53',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGCH400G modificado','Autor: admin\nProducto BPGCH400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,280,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1300,1300,NULL,1,'2022-08-22 19:56:45','2022-08-22 19:56:45',40,'AC_PRODUCT_MODIFY','2022-08-22 19:56:45','2022-08-22 07:56:45',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPLYA400G modificado','Autor: admin\nProducto BPLYA400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,208,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1301,1301,NULL,1,'2022-08-22 19:58:54','2022-08-22 19:58:54',40,'AC_PRODUCT_MODIFY','2022-08-22 19:58:54','2022-08-22 07:58:54',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPMI500G modificado','Autor: admin\nProducto BPMI500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,206,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1302,1302,NULL,1,'2022-08-22 20:01:41','2022-08-22 20:01:41',40,'AC_PRODUCT_MODIFY','2022-08-22 20:01:41','2022-08-22 08:01:41',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BNPPIZ336G modificado','Autor: admin\nProducto BNPPIZ336G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,215,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1303,1303,NULL,1,'2022-08-22 20:02:29','2022-08-22 20:02:29',40,'AC_PRODUCT_MODIFY','2022-08-22 20:02:29','2022-08-22 08:02:29',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPPIZ100G modificado','Autor: admin\nProducto BPPIZ100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,278,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1304,1304,NULL,1,'2022-08-22 20:02:36','2022-08-22 20:02:36',40,'AC_PRODUCT_MODIFY','2022-08-22 20:02:36','2022-08-22 08:02:36',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPPIZ100G modificado','Autor: admin\nProducto BPPIZ100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,278,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1305,1305,NULL,1,'2022-08-22 20:08:31','2022-08-22 20:08:31',40,'AC_PRODUCT_MODIFY','2022-08-22 20:08:31','2022-08-22 08:08:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BP_BARRA_DE_COCO_400g modificado','Autor: admin\nProducto BP_BARRA_DE_COCO_400g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,214,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1306,1306,NULL,1,'2022-08-22 20:09:18','2022-08-22 20:09:18',40,'AC_PRODUCT_MODIFY','2022-08-22 20:09:18','2022-08-22 08:09:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPFL336G modificado','Autor: admin\nProducto BPFL336G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,212,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1307,1307,NULL,1,'2022-08-22 20:10:02','2022-08-22 20:10:02',40,'AC_PRODUCT_MODIFY','2022-08-22 20:10:02','2022-08-22 08:10:03',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPMA400G modificado','Autor: admin\nProducto BPMA400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,210,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1308,1308,NULL,1,'2022-08-22 20:10:47','2022-08-22 20:10:47',40,'AC_PRODUCT_MODIFY','2022-08-22 20:10:47','2022-08-22 08:10:47',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPNU400G modificado','Autor: admin\nProducto BPNU400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,211,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1309,1309,NULL,1,'2022-08-22 20:10:55','2022-08-22 20:10:55',40,'AC_PRODUCT_MODIFY','2022-08-22 20:10:55','2022-08-22 08:10:55',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPNU400G modificado','Autor: admin\nProducto BPNU400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,211,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1310,1310,NULL,1,'2022-08-22 20:11:30','2022-08-22 20:11:30',40,'AC_PRODUCT_MODIFY','2022-08-22 20:11:30','2022-08-22 08:11:30',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPOR200G modificado','Autor: admin\nProducto BPOR200G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,213,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1311,1311,NULL,1,'2022-08-22 20:12:11','2022-08-22 20:12:11',40,'AC_PRODUCT_MODIFY','2022-08-22 20:12:11','2022-08-22 08:12:11',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BISAGRA_SEVILLANO modificado','Autor: admin\nProducto BISAGRA_SEVILLANO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,218,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1312,1312,NULL,1,'2022-08-22 20:13:20','2022-08-22 20:13:20',40,'AC_PRODUCT_MODIFY','2022-08-22 20:13:20','2022-08-22 08:13:20',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BISUS600G modificado','Autor: admin\nProducto BISUS600G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,217,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1313,1313,NULL,1,'2022-08-22 20:13:59','2022-08-22 20:13:59',40,'AC_PRODUCT_MODIFY','2022-08-22 20:13:59','2022-08-22 08:13:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPTDP84G modificado','Autor: admin\nProducto BPTDP84G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,229,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1314,1314,NULL,1,'2022-08-22 20:14:28','2022-08-22 20:14:28',40,'AC_PRODUCT_MODIFY','2022-08-22 20:14:28','2022-08-22 08:14:28',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPTDF84G modificado','Autor: admin\nProducto BPTDF84G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,230,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1315,1315,NULL,1,'2022-08-22 21:07:33','2022-08-22 21:07:33',40,'AC_BILL_VALIDATE','2022-08-22 21:07:33','2022-08-22 09:07:33',11,NULL,NULL,11945,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0096 validada','Autor: gdealba\nFactura FA2208-0096 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,104,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1316,1316,NULL,1,'2022-08-22 21:09:13','2022-08-22 21:09:13',40,'AC_BILL_VALIDATE','2022-08-22 21:09:13','2022-08-22 09:09:13',11,NULL,NULL,12273,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0097 validada','Autor: gdealba\nFactura FA2208-0097 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,105,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1317,1317,NULL,1,'2022-08-22 21:10:55','2022-08-22 21:10:55',40,'AC_BILL_VALIDATE','2022-08-22 21:10:55','2022-08-22 09:10:55',11,NULL,NULL,12449,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0098 validada','Autor: gdealba\nFactura FA2208-0098 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,106,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1318,1318,NULL,1,'2022-08-22 21:12:56','2022-08-22 21:12:56',40,'AC_BILL_VALIDATE','2022-08-22 21:12:56','2022-08-22 09:12:56',11,NULL,NULL,12765,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0099 validada','Autor: gdealba\nFactura FA2208-0099 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,107,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1319,1319,NULL,1,'2022-08-22 21:16:47','2022-08-22 21:16:47',40,'AC_BILL_VALIDATE','2022-08-22 21:16:47','2022-08-22 09:16:47',11,NULL,NULL,13646,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0100 validada','Autor: gdealba\nFactura FA2208-0100 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,108,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1320,1320,NULL,1,'2022-08-22 21:19:12','2022-08-22 21:19:12',40,'AC_BILL_VALIDATE','2022-08-22 21:19:12','2022-08-22 09:19:12',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0101 validada','Autor: gdealba\nFactura FA2208-0101 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,109,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1321,1321,NULL,1,'2022-08-22 21:19:49','2022-08-22 21:19:49',40,'AC_BILL_VALIDATE','2022-08-22 21:19:49','2022-08-22 09:19:49',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0102 validada','Autor: gdealba\nFactura FA2208-0102 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,110,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1322,1322,NULL,1,'2022-08-22 21:23:47','2022-08-22 21:23:47',40,'AC_BILL_VALIDATE','2022-08-22 21:23:47','2022-08-22 09:23:47',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0103 validada','Autor: gdealba\nFactura FA2208-0103 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,111,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1323,1323,NULL,1,'2022-08-22 21:24:33','2022-08-22 21:24:33',40,'AC_BILL_VALIDATE','2022-08-22 21:24:33','2022-08-22 09:24:33',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0104 validada','Autor: gdealba\nFactura FA2208-0104 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,112,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1324,1324,NULL,1,'2022-08-22 21:28:51','2022-08-22 21:28:51',40,'AC_BILL_VALIDATE','2022-08-22 21:28:51','2022-08-22 09:28:51',11,NULL,NULL,13866,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0105 validada','Autor: gdealba\nFactura FA2208-0105 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,113,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1325,1325,NULL,1,'2022-08-22 23:23:39','2022-08-22 23:23:39',40,'AC_BILL_VALIDATE','2022-08-22 23:23:39','2022-08-22 11:23:39',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0106 validada','Autor: egarcia\nFactura FA2208-0106 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,114,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1326,1326,NULL,1,'2022-08-22 23:30:26','2022-08-22 23:30:26',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-22 23:30:26','2022-08-22 11:30:26',6,NULL,NULL,3,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0066 validada','Autor: egarcia\nFactura SI2208-0066 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,90,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1327,1327,NULL,1,'2022-08-22 23:32:52','2022-08-22 23:32:52',40,'AC_BILL_VALIDATE','2022-08-22 23:32:52','2022-08-22 11:32:52',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0107 validada','Autor: egarcia\nFactura FA2208-0107 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,115,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1328,1328,NULL,1,'2022-08-22 23:46:27','2022-08-22 23:46:27',40,'AC_BILL_VALIDATE','2022-08-22 23:46:27','2022-08-22 11:46:27',11,NULL,NULL,14154,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0108 validada','Autor: gdealba\nFactura FA2208-0108 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,116,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1329,1329,NULL,1,'2022-08-22 23:48:53','2022-08-22 23:48:53',40,'AC_BILL_VALIDATE','2022-08-22 23:48:53','2022-08-22 11:48:53',11,NULL,NULL,14155,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0109 validada','Autor: gdealba\nFactura FA2208-0109 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,117,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1330,1330,NULL,1,'2022-08-22 23:51:31','2022-08-22 23:51:31',40,'AC_BILL_VALIDATE','2022-08-22 23:51:31','2022-08-22 11:51:31',11,NULL,NULL,14153,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0110 validada','Autor: gdealba\nFactura FA2208-0110 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,118,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1331,1331,NULL,1,'2022-08-23 00:08:10','2022-08-23 00:08:10',40,'AC_BILL_VALIDATE','2022-08-23 00:08:10','2022-08-22 12:08:10',11,NULL,NULL,13676,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0111 validada','Autor: gdealba\nFactura FA2208-0111 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,119,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1332,1332,NULL,1,'2022-08-23 00:11:09','2022-08-23 00:11:09',40,'AC_BILL_VALIDATE','2022-08-23 00:11:09','2022-08-22 12:11:09',11,NULL,NULL,10913,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0112 validada','Autor: gdealba\nFactura FA2208-0112 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,120,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1333,1333,NULL,1,'2022-08-23 00:12:47','2022-08-23 00:12:47',40,'AC_BILL_VALIDATE','2022-08-23 00:12:47','2022-08-22 12:12:47',11,NULL,NULL,10915,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0113 validada','Autor: gdealba\nFactura FA2208-0113 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,121,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1334,1334,NULL,1,'2022-08-23 00:14:46','2022-08-23 00:14:46',40,'AC_BILL_VALIDATE','2022-08-23 00:14:46','2022-08-22 12:14:46',11,NULL,NULL,11148,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0114 validada','Autor: gdealba\nFactura FA2208-0114 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,122,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1335,1335,NULL,1,'2022-08-23 00:15:48','2022-08-23 00:15:48',40,'AC_BILL_VALIDATE','2022-08-23 00:15:48','2022-08-22 12:15:48',11,NULL,NULL,11149,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0115 validada','Autor: gdealba\nFactura FA2208-0115 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,123,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1336,1336,NULL,1,'2022-08-23 00:18:16','2022-08-23 00:18:16',40,'AC_BILL_VALIDATE','2022-08-23 00:18:16','2022-08-22 12:18:16',11,NULL,NULL,12084,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0116 validada','Autor: gdealba\nFactura FA2208-0116 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,124,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1337,1337,NULL,1,'2022-08-23 00:19:20','2022-08-23 00:19:20',40,'AC_BILL_VALIDATE','2022-08-23 00:19:20','2022-08-22 12:19:20',11,NULL,NULL,12304,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0117 validada','Autor: gdealba\nFactura FA2208-0117 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,125,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1338,1338,NULL,1,'2022-08-23 00:20:58','2022-08-23 00:20:58',40,'AC_BILL_VALIDATE','2022-08-23 00:20:58','2022-08-22 12:20:58',11,NULL,NULL,12429,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0118 validada','Autor: gdealba\nFactura FA2208-0118 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,126,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1339,1339,NULL,1,'2022-08-23 00:23:00','2022-08-23 00:23:00',40,'AC_BILL_VALIDATE','2022-08-23 00:23:00','2022-08-22 12:23:00',11,NULL,NULL,12439,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0119 validada','Autor: gdealba\nFactura FA2208-0119 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,127,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1340,1340,NULL,1,'2022-08-23 00:23:54','2022-08-23 00:23:54',40,'AC_BILL_VALIDATE','2022-08-23 00:23:54','2022-08-22 12:23:54',11,NULL,NULL,12496,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0120 validada','Autor: gdealba\nFactura FA2208-0120 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,128,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1341,1341,NULL,1,'2022-08-23 00:25:20','2022-08-23 00:25:20',40,'AC_BILL_VALIDATE','2022-08-23 00:25:20','2022-08-22 12:25:20',11,NULL,NULL,12504,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0121 validada','Autor: gdealba\nFactura FA2208-0121 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,129,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1342,1342,NULL,1,'2022-08-23 00:26:47','2022-08-23 00:26:47',40,'AC_BILL_VALIDATE','2022-08-23 00:26:47','2022-08-22 12:26:47',11,NULL,NULL,12620,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0122 validada','Autor: gdealba\nFactura FA2208-0122 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,130,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1343,1343,NULL,1,'2022-08-23 00:27:57','2022-08-23 00:27:57',40,'AC_BILL_VALIDATE','2022-08-23 00:27:57','2022-08-22 12:27:57',11,NULL,NULL,12636,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0123 validada','Autor: gdealba\nFactura FA2208-0123 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,131,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1344,1344,NULL,1,'2022-08-23 00:29:29','2022-08-23 00:29:29',40,'AC_BILL_VALIDATE','2022-08-23 00:29:29','2022-08-22 12:29:29',11,NULL,NULL,13638,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0124 validada','Autor: gdealba\nFactura FA2208-0124 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,132,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1345,1345,NULL,1,'2022-08-23 00:31:03','2022-08-23 00:31:03',40,'AC_BILL_VALIDATE','2022-08-23 00:31:03','2022-08-22 12:31:03',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0125 validada','Autor: gdealba\nFactura FA2208-0125 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,133,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1346,1346,NULL,1,'2022-08-23 00:31:54','2022-08-23 00:31:54',40,'AC_BILL_VALIDATE','2022-08-23 00:31:54','2022-08-22 12:31:54',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0126 validada','Autor: gdealba\nFactura FA2208-0126 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,134,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1347,1347,NULL,1,'2022-08-23 01:02:35','2022-08-23 01:02:35',40,'AC_BILL_VALIDATE','2022-08-23 01:02:35','2022-08-22 13:02:35',11,NULL,NULL,10863,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0127 validada','Autor: gdealba\nFactura FA2208-0127 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,135,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1348,1348,NULL,1,'2022-08-23 01:03:35','2022-08-23 01:03:35',40,'AC_BILL_VALIDATE','2022-08-23 01:03:35','2022-08-22 13:03:35',11,NULL,NULL,10864,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0128 validada','Autor: gdealba\nFactura FA2208-0128 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,136,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1349,1349,NULL,1,'2022-08-23 01:04:55','2022-08-23 01:04:55',40,'AC_BILL_VALIDATE','2022-08-23 01:04:55','2022-08-22 13:04:55',11,NULL,NULL,11745,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0129 validada','Autor: gdealba\nFactura FA2208-0129 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,137,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1350,1350,NULL,1,'2022-08-23 01:06:06','2022-08-23 01:06:06',40,'AC_BILL_VALIDATE','2022-08-23 01:06:06','2022-08-22 13:06:06',11,NULL,NULL,11746,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0130 validada','Autor: gdealba\nFactura FA2208-0130 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,138,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1351,1351,NULL,1,'2022-08-23 01:07:06','2022-08-23 01:07:06',40,'AC_BILL_VALIDATE','2022-08-23 01:07:06','2022-08-22 13:07:06',11,NULL,NULL,11748,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0131 validada','Autor: gdealba\nFactura FA2208-0131 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,139,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1352,1352,NULL,1,'2022-08-23 01:07:48','2022-08-23 01:07:48',40,'AC_BILL_VALIDATE','2022-08-23 01:07:48','2022-08-22 13:07:48',11,NULL,NULL,12117,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0132 validada','Autor: gdealba\nFactura FA2208-0132 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,140,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1353,1353,NULL,1,'2022-08-23 01:09:15','2022-08-23 01:09:15',40,'AC_BILL_VALIDATE','2022-08-23 01:09:15','2022-08-22 13:09:15',11,NULL,NULL,13139,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0133 validada','Autor: gdealba\nFactura FA2208-0133 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,141,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1354,1354,NULL,1,'2022-08-23 01:11:09','2022-08-23 01:11:09',40,'AC_BILL_VALIDATE','2022-08-23 01:11:09','2022-08-22 13:11:09',11,NULL,NULL,13707,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0134 validada','Autor: gdealba\nFactura FA2208-0134 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,142,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1355,1355,NULL,1,'2022-08-23 01:16:14','2022-08-23 01:16:14',40,'AC_BILL_VALIDATE','2022-08-23 01:16:14','2022-08-22 13:16:14',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0135 validada','Autor: gdealba\nFactura FA2208-0135 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,143,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1356,1356,NULL,1,'2022-08-23 01:17:00','2022-08-23 01:17:00',40,'AC_BILL_VALIDATE','2022-08-23 01:17:00','2022-08-22 13:17:00',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0136 validada','Autor: gdealba\nFactura FA2208-0136 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,144,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1357,1357,NULL,1,'2022-08-23 01:19:28','2022-08-23 01:19:28',40,'AC_COMPANY_DELETE','2022-08-23 01:19:28','2022-08-22 13:19:28',11,NULL,NULL,NULL,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Tercero 14102 eliminado','Autor: gdealba\nTercero 14102 eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1358,1358,NULL,1,'2022-08-23 01:23:49','2022-08-23 01:23:49',40,'AC_BILL_VALIDATE','2022-08-23 01:23:49','2022-08-22 13:23:49',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0137 validada','Autor: egarcia\nFactura FA2208-0137 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,145,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1360,1360,NULL,1,'2022-08-23 01:26:30','2022-08-23 01:26:30',40,'AC_COMPANY_DELETE','2022-08-23 01:26:30','2022-08-22 13:26:30',11,NULL,NULL,NULL,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Tercero 14002 eliminado','Autor: gdealba\nTercero 14002 eliminado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1361,1361,NULL,1,'2022-08-23 01:30:11','2022-08-23 01:30:11',40,'AC_BILL_VALIDATE','2022-08-23 01:30:11','2022-08-22 13:30:11',11,NULL,NULL,13822,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0138 validada','Autor: gdealba\nFactura FA2208-0138 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,147,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1362,1362,NULL,1,'2022-08-23 01:33:15','2022-08-23 01:33:15',40,'AC_BILL_VALIDATE','2022-08-23 01:33:15','2022-08-22 13:33:15',11,NULL,NULL,10893,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0139 validada','Autor: gdealba\nFactura FA2208-0139 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,148,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1363,1363,NULL,1,'2022-08-23 01:33:50','2022-08-23 01:33:50',40,'AC_BILL_VALIDATE','2022-08-23 01:33:50','2022-08-22 13:33:50',11,NULL,NULL,10893,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0140 validada','Autor: gdealba\nFactura FA2208-0140 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,149,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1364,1364,NULL,1,'2022-08-23 01:35:01','2022-08-23 01:35:01',40,'AC_BILL_VALIDATE','2022-08-23 01:35:01','2022-08-22 13:35:01',11,NULL,NULL,11018,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0141 validada','Autor: gdealba\nFactura FA2208-0141 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,150,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1365,1365,NULL,1,'2022-08-23 01:38:18','2022-08-23 01:38:18',40,'AC_BILL_VALIDATE','2022-08-23 01:38:18','2022-08-22 13:38:18',11,NULL,NULL,11061,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0142 validada','Autor: gdealba\nFactura FA2208-0142 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,151,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1366,1366,NULL,1,'2022-08-23 01:39:22','2022-08-23 01:39:22',40,'AC_BILL_VALIDATE','2022-08-23 01:39:22','2022-08-22 13:39:22',11,NULL,NULL,11062,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0143 validada','Autor: gdealba\nFactura FA2208-0143 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,152,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1367,1367,NULL,1,'2022-08-23 01:41:01','2022-08-23 01:41:01',40,'AC_BILL_VALIDATE','2022-08-23 01:41:01','2022-08-22 13:41:01',11,NULL,NULL,11910,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0144 validada','Autor: gdealba\nFactura FA2208-0144 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,153,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1368,1368,NULL,1,'2022-08-23 01:41:58','2022-08-23 01:41:58',40,'AC_BILL_VALIDATE','2022-08-23 01:41:58','2022-08-22 13:41:58',11,NULL,NULL,12024,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0145 validada','Autor: gdealba\nFactura FA2208-0145 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,154,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1369,1369,NULL,1,'2022-08-23 01:43:29','2022-08-23 01:43:29',40,'AC_BILL_VALIDATE','2022-08-23 01:43:29','2022-08-22 13:43:29',11,NULL,NULL,12224,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0146 validada','Autor: gdealba\nFactura FA2208-0146 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,155,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1370,1370,NULL,1,'2022-08-23 01:45:08','2022-08-23 01:45:08',40,'AC_BILL_VALIDATE','2022-08-23 01:45:08','2022-08-22 13:45:08',11,NULL,NULL,12264,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0147 validada','Autor: gdealba\nFactura FA2208-0147 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,156,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1371,1371,NULL,1,'2022-08-23 01:46:46','2022-08-23 01:46:46',40,'AC_BILL_VALIDATE','2022-08-23 01:46:46','2022-08-22 13:46:46',11,NULL,NULL,12493,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0148 validada','Autor: gdealba\nFactura FA2208-0148 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,157,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1372,1372,NULL,1,'2022-08-23 01:48:19','2022-08-23 01:48:19',40,'AC_BILL_VALIDATE','2022-08-23 01:48:19','2022-08-22 13:48:19',11,NULL,NULL,12885,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0149 validada','Autor: gdealba\nFactura FA2208-0149 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,158,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1373,1373,NULL,1,'2022-08-23 01:49:27','2022-08-23 01:49:27',40,'AC_BILL_VALIDATE','2022-08-23 01:49:27','2022-08-22 13:49:27',11,NULL,NULL,12978,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0150 validada','Autor: gdealba\nFactura FA2208-0150 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,159,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1374,1374,NULL,1,'2022-08-23 01:49:56','2022-08-23 01:49:56',40,'AC_BILL_DELETE','2022-08-23 01:49:56','2022-08-22 13:49:56',11,NULL,NULL,14049,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura eliminada','Autor: gdealba\nFactura eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,160,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1375,1375,NULL,1,'2022-08-23 01:51:56','2022-08-23 01:51:56',40,'AC_BILL_VALIDATE','2022-08-23 01:51:56','2022-08-22 13:51:56',11,NULL,NULL,14049,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0151 validada','Autor: gdealba\nFactura FA2208-0151 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,161,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1376,1376,NULL,1,'2022-08-23 01:54:16','2022-08-23 01:54:16',40,'AC_BILL_UNVALIDATE','2022-08-23 01:54:16','2022-08-22 13:54:16',11,NULL,NULL,14049,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura FA2208-0151 al estado de borrador','Autor: gdealba\nRegresar factura FA2208-0151 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,161,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1377,1377,NULL,1,'2022-08-23 01:55:06','2022-08-23 01:55:06',40,'AC_BILL_VALIDATE','2022-08-23 01:55:06','2022-08-22 13:55:06',11,NULL,NULL,14049,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0151 validada','Autor: gdealba\nFactura FA2208-0151 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,161,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1378,1378,NULL,1,'2022-08-23 01:56:47','2022-08-23 01:56:47',40,'AC_BILL_VALIDATE','2022-08-23 01:56:47','2022-08-22 13:56:47',11,NULL,NULL,14093,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0152 validada','Autor: gdealba\nFactura FA2208-0152 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,162,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1379,1379,NULL,1,'2022-08-23 12:10:33','2022-08-23 12:10:33',40,'AC_PRODUCT_MODIFY','2022-08-23 12:10:33','2022-08-23 00:10:33',4,NULL,NULL,NULL,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Producto BTCFSCH90G modificado','Autor: yrodriguez\nProducto BTCFSCH90G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,223,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1380,1380,NULL,1,'2022-08-23 12:11:13','2022-08-23 12:11:13',40,'AC_PRODUCT_MODIFY','2022-08-23 12:11:13','2022-08-23 00:11:13',4,NULL,NULL,NULL,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Producto BTCFC90G modificado','Autor: yrodriguez\nProducto BTCFC90G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,224,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1381,1381,NULL,1,'2022-08-23 12:51:37','2022-08-23 12:51:37',40,'AC_BILL_UNVALIDATE','2022-08-23 12:51:37','2022-08-23 00:51:37',4,NULL,NULL,13746,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura FA2208-0106 al estado de borrador','Autor: yrodriguez\nRegresar factura FA2208-0106 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,114,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1382,1382,NULL,1,'2022-08-23 12:52:19','2022-08-23 12:52:19',40,'AC_BILL_VALIDATE','2022-08-23 12:52:19','2022-08-23 00:52:19',4,NULL,NULL,13746,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0106 validada','Autor: yrodriguez\nFactura FA2208-0106 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,114,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1383,1383,NULL,1,'2022-08-23 13:00:25','2022-08-23 13:00:25',40,'AC_BILL_VALIDATE','2022-08-23 13:00:25','2022-08-23 01:00:25',4,NULL,NULL,13746,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0153 validada','Autor: yrodriguez\nFactura FA2208-0153 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,163,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1384,1384,NULL,1,'2022-08-23 13:00:53','2022-08-23 13:00:53',40,'AC_BILL_UNVALIDATE','2022-08-23 13:00:53','2022-08-23 01:00:53',4,NULL,NULL,13746,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura FA2208-0153 al estado de borrador','Autor: yrodriguez\nRegresar factura FA2208-0153 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,163,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1385,1385,NULL,1,'2022-08-23 13:02:22','2022-08-23 13:02:22',40,'AC_BILL_VALIDATE','2022-08-23 13:02:22','2022-08-23 01:02:22',4,NULL,NULL,13746,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0153 validada','Autor: yrodriguez\nFactura FA2208-0153 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,163,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1386,1386,NULL,1,'2022-08-23 14:40:24','2022-08-23 14:40:24',40,'AC_BOM_VALIDATE','2022-08-23 14:40:24','2022-08-23 02:40:24',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,91,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1387,1387,NULL,1,'2022-08-23 14:50:52','2022-08-23 14:50:52',40,'AC_BOM_VALIDATE','2022-08-23 14:50:52','2022-08-23 02:50:52',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,92,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1388,1388,NULL,1,'2022-08-23 14:58:39','2022-08-23 14:58:39',40,'AC_BOM_VALIDATE','2022-08-23 14:58:39','2022-08-23 02:58:39',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,93,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1389,1389,NULL,1,'2022-08-23 15:00:12','2022-08-23 15:00:12',40,'AC_BOM_VALIDATE','2022-08-23 15:00:12','2022-08-23 03:00:12',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,37,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1390,1390,NULL,1,'2022-08-23 15:28:20','2022-08-23 15:28:20',40,'AC_BOM_UNVALIDATE','2022-08-23 15:28:20','2022-08-23 03:28:20',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,37,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1391,1391,NULL,1,'2022-08-23 15:29:43','2022-08-23 15:29:43',40,'AC_BOM_VALIDATE','2022-08-23 15:29:43','2022-08-23 03:29:43',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,37,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1392,1392,NULL,1,'2022-08-23 15:40:18','2022-08-23 15:40:18',40,'AC_BOM_VALIDATE','2022-08-23 15:40:18','2022-08-23 03:40:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,94,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1393,1393,NULL,1,'2022-08-23 15:45:30','2022-08-23 15:45:30',40,'AC_BOM_VALIDATE','2022-08-23 15:45:30','2022-08-23 03:45:30',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,95,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1394,1394,NULL,1,'2022-08-23 15:49:49','2022-08-23 15:49:49',40,'AC_BOM_VALIDATE','2022-08-23 15:49:49','2022-08-23 03:49:49',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,96,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1395,1395,NULL,1,'2022-08-23 15:56:16','2022-08-23 15:56:16',40,'AC_BOM_VALIDATE','2022-08-23 15:56:16','2022-08-23 03:56:16',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,97,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1396,1396,NULL,1,'2022-08-23 15:58:21','2022-08-23 15:58:21',40,'AC_BOM_VALIDATE','2022-08-23 15:58:21','2022-08-23 03:58:21',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,98,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1397,1397,NULL,1,'2022-08-23 15:59:52','2022-08-23 15:59:52',40,'AC_BOM_VALIDATE','2022-08-23 15:59:52','2022-08-23 03:59:52',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,99,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1398,1398,NULL,1,'2022-08-23 16:10:06','2022-08-23 16:10:06',40,'AC_BOM_VALIDATE','2022-08-23 16:10:06','2022-08-23 04:10:06',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,100,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1399,1399,NULL,1,'2022-08-23 16:36:57','2022-08-23 16:36:57',40,'AC_BOM_VALIDATE','2022-08-23 16:36:57','2022-08-23 04:36:57',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,101,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1400,1400,NULL,1,'2022-08-23 16:38:56','2022-08-23 16:38:56',40,'AC_BOM_VALIDATE','2022-08-23 16:38:56','2022-08-23 04:38:56',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,102,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1401,1401,NULL,1,'2022-08-23 16:41:18','2022-08-23 16:41:18',40,'AC_BOM_VALIDATE','2022-08-23 16:41:18','2022-08-23 04:41:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,103,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1402,1402,NULL,1,'2022-08-23 16:42:55','2022-08-23 16:42:55',40,'AC_BOM_VALIDATE','2022-08-23 16:42:55','2022-08-23 04:42:55',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,104,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1403,1403,NULL,1,'2022-08-23 18:05:18','2022-08-23 18:05:18',40,'AC_PRODUCT_MODIFY','2022-08-23 18:05:18','2022-08-23 06:05:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR500G modificado','Autor: admin\nProducto BPGR500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,205,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1404,1404,NULL,1,'2022-08-23 19:03:47','2022-08-23 19:03:47',40,'AC_BILL_VALIDATE','2022-08-23 19:03:47','2022-08-23 07:03:47',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0154 validada','Autor: egarcia\nFactura FA2208-0154 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,164,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1405,1405,NULL,1,'2022-08-23 19:06:23','2022-08-23 19:06:23',40,'AC_BOM_VALIDATE','2022-08-23 19:06:23','2022-08-23 07:06:23',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,28,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1406,1406,NULL,1,'2022-08-23 19:07:09','2022-08-23 19:07:09',40,'AC_BOM_VALIDATE','2022-08-23 19:07:09','2022-08-23 07:07:09',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,60,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1407,1407,NULL,1,'2022-08-23 19:07:43','2022-08-23 19:07:43',40,'AC_BOM_VALIDATE','2022-08-23 19:07:43','2022-08-23 07:07:43',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,67,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1408,1408,NULL,1,'2022-08-23 19:07:53','2022-08-23 19:07:53',40,'AC_BOM_VALIDATE','2022-08-23 19:07:53','2022-08-23 07:07:53',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,73,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1409,1409,NULL,1,'2022-08-23 19:08:01','2022-08-23 19:08:01',40,'AC_BOM_VALIDATE','2022-08-23 19:08:01','2022-08-23 07:08:01',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,78,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1410,1410,NULL,1,'2022-08-23 19:08:08','2022-08-23 19:08:08',40,'AC_BOM_VALIDATE','2022-08-23 19:08:08','2022-08-23 07:08:08',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,79,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1411,1411,NULL,1,'2022-08-23 19:08:15','2022-08-23 19:08:15',40,'AC_BOM_VALIDATE','2022-08-23 19:08:15','2022-08-23 07:08:15',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,80,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1412,1412,NULL,1,'2022-08-23 19:08:28','2022-08-23 19:08:28',40,'AC_BOM_VALIDATE','2022-08-23 19:08:28','2022-08-23 07:08:28',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,81,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1413,1413,NULL,1,'2022-08-23 19:12:02','2022-08-23 19:12:02',40,'AC_BILL_VALIDATE','2022-08-23 19:12:02','2022-08-23 07:12:02',6,NULL,NULL,12201,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0155 validada','Autor: egarcia\nFactura FA2208-0155 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,165,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1414,1414,NULL,1,'2022-08-23 19:15:04','2022-08-23 19:15:04',40,'AC_BILL_VALIDATE','2022-08-23 19:15:04','2022-08-23 07:15:04',6,NULL,NULL,12033,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0156 validada','Autor: egarcia\nFactura FA2208-0156 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,166,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1415,1415,NULL,1,'2022-08-23 19:18:34','2022-08-23 19:18:34',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-23 19:18:34','2022-08-23 07:18:34',6,NULL,NULL,3,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0067 validada','Autor: egarcia\nFactura SI2208-0067 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,91,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1416,1416,NULL,1,'2022-08-23 19:25:02','2022-08-23 19:25:02',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-23 19:25:02','2022-08-23 07:25:02',6,NULL,NULL,1,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0068 validada','Autor: egarcia\nFactura SI2208-0068 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,92,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1417,1417,NULL,1,'2022-08-23 19:32:13','2022-08-23 19:32:13',40,'AC_BILL_VALIDATE','2022-08-23 19:32:13','2022-08-23 07:32:13',11,NULL,NULL,13867,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0157 validada','Autor: gdealba\nFactura FA2208-0157 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,167,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1418,1418,NULL,1,'2022-08-23 19:44:19','2022-08-23 19:44:19',40,'AC_BILL_VALIDATE','2022-08-23 19:44:19','2022-08-23 07:44:19',11,NULL,NULL,14056,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0158 validada','Autor: gdealba\nFactura FA2208-0158 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,168,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1419,1419,NULL,1,'2022-08-23 19:46:15','2022-08-23 19:46:15',40,'AC_BILL_VALIDATE','2022-08-23 19:46:15','2022-08-23 07:46:15',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0159 validada','Autor: gdealba\nFactura FA2208-0159 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,169,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1420,1420,NULL,1,'2022-08-23 20:28:33','2022-08-23 20:28:33',40,'AC_BILL_VALIDATE','2022-08-23 20:28:33','2022-08-23 08:28:33',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0160 validada','Autor: gdealba\nFactura FA2208-0160 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,170,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1421,1421,NULL,1,'2022-08-23 20:29:40','2022-08-23 20:29:40',40,'AC_BILL_VALIDATE','2022-08-23 20:29:40','2022-08-23 08:29:40',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0161 validada','Autor: gdealba\nFactura FA2208-0161 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,171,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1422,1422,NULL,1,'2022-08-23 20:32:11','2022-08-23 20:32:11',40,'AC_BILL_VALIDATE','2022-08-23 20:32:11','2022-08-23 08:32:11',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0162 validada','Autor: gdealba\nFactura FA2208-0162 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,172,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1423,1423,NULL,1,'2022-08-23 20:33:59','2022-08-23 20:33:59',40,'AC_BILL_VALIDATE','2022-08-23 20:33:59','2022-08-23 08:33:59',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0163 validada','Autor: gdealba\nFactura FA2208-0163 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,174,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1424,1424,NULL,1,'2022-08-23 20:35:00','2022-08-23 20:35:00',40,'AC_BILL_VALIDATE','2022-08-23 20:35:00','2022-08-23 08:35:00',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0164 validada','Autor: gdealba\nFactura FA2208-0164 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,175,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1425,1425,NULL,1,'2022-08-23 20:36:09','2022-08-23 20:36:09',40,'AC_BILL_VALIDATE','2022-08-23 20:36:09','2022-08-23 08:36:09',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0165 validada','Autor: gdealba\nFactura FA2208-0165 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,176,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1426,1426,NULL,1,'2022-08-23 20:37:44','2022-08-23 20:37:44',40,'AC_BILL_VALIDATE','2022-08-23 20:37:44','2022-08-23 08:37:44',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0166 validada','Autor: gdealba\nFactura FA2208-0166 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,177,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1427,1427,NULL,1,'2022-08-23 20:39:05','2022-08-23 20:39:05',40,'AC_BILL_VALIDATE','2022-08-23 20:39:05','2022-08-23 08:39:05',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0167 validada','Autor: gdealba\nFactura FA2208-0167 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,178,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1428,1428,NULL,1,'2022-08-23 20:39:47','2022-08-23 20:39:47',40,'AC_BILL_VALIDATE','2022-08-23 20:39:47','2022-08-23 08:39:47',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0168 validada','Autor: gdealba\nFactura FA2208-0168 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,179,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1429,1429,NULL,1,'2022-08-23 20:41:09','2022-08-23 20:41:09',40,'AC_BILL_VALIDATE','2022-08-23 20:41:09','2022-08-23 08:41:09',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0169 validada','Autor: gdealba\nFactura FA2208-0169 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,180,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1430,1430,NULL,1,'2022-08-23 20:42:23','2022-08-23 20:42:23',40,'AC_BILL_VALIDATE','2022-08-23 20:42:23','2022-08-23 08:42:23',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0170 validada','Autor: gdealba\nFactura FA2208-0170 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,181,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1431,1431,NULL,1,'2022-08-23 20:43:24','2022-08-23 20:43:24',40,'AC_BILL_VALIDATE','2022-08-23 20:43:24','2022-08-23 08:43:24',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0171 validada','Autor: gdealba\nFactura FA2208-0171 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,182,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1432,1432,NULL,1,'2022-08-23 20:44:21','2022-08-23 20:44:21',40,'AC_BILL_VALIDATE','2022-08-23 20:44:21','2022-08-23 08:44:21',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0172 validada','Autor: gdealba\nFactura FA2208-0172 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,183,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1433,1433,NULL,1,'2022-08-23 20:45:55','2022-08-23 20:45:55',40,'AC_BILL_VALIDATE','2022-08-23 20:45:55','2022-08-23 08:45:55',11,NULL,NULL,13686,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0173 validada','Autor: gdealba\nFactura FA2208-0173 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,184,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1434,1434,NULL,1,'2022-08-23 20:46:47','2022-08-23 20:46:47',40,'AC_BILL_VALIDATE','2022-08-23 20:46:47','2022-08-23 08:46:47',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0174 validada','Autor: gdealba\nFactura FA2208-0174 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,185,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1435,1435,NULL,1,'2022-08-23 20:48:06','2022-08-23 20:48:06',40,'AC_BILL_VALIDATE','2022-08-23 20:48:06','2022-08-23 08:48:06',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0175 validada','Autor: gdealba\nFactura FA2208-0175 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,186,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1436,1436,NULL,1,'2022-08-23 20:50:31','2022-08-23 20:50:31',40,'AC_BILL_VALIDATE','2022-08-23 20:50:31','2022-08-23 08:50:31',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0176 validada','Autor: gdealba\nFactura FA2208-0176 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,187,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1437,1437,NULL,1,'2022-08-23 20:51:14','2022-08-23 20:51:14',40,'AC_BILL_VALIDATE','2022-08-23 20:51:14','2022-08-23 08:51:14',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0177 validada','Autor: gdealba\nFactura FA2208-0177 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,188,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1438,1438,NULL,1,'2022-08-23 20:52:14','2022-08-23 20:52:14',40,'AC_BILL_VALIDATE','2022-08-23 20:52:14','2022-08-23 08:52:14',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0178 validada','Autor: gdealba\nFactura FA2208-0178 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,189,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1439,1439,NULL,1,'2022-08-23 20:55:03','2022-08-23 20:55:03',40,'AC_BILL_VALIDATE','2022-08-23 20:55:03','2022-08-23 08:55:03',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0179 validada','Autor: gdealba\nFactura FA2208-0179 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,190,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1440,1440,NULL,1,'2022-08-23 21:21:00','2022-08-23 21:21:00',40,'AC_BILL_VALIDATE','2022-08-23 21:21:00','2022-08-23 09:21:00',11,NULL,NULL,11351,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0180 validada','Autor: gdealba\nFactura FA2208-0180 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,191,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1441,1441,NULL,1,'2022-08-23 21:24:50','2022-08-23 21:24:50',40,'AC_BILL_VALIDATE','2022-08-23 21:24:50','2022-08-23 09:24:50',11,NULL,NULL,11872,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0181 validada','Autor: gdealba\nFactura FA2208-0181 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,192,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1442,1442,NULL,1,'2022-08-23 21:32:59','2022-08-23 21:32:59',40,'AC_BILL_VALIDATE','2022-08-23 21:32:59','2022-08-23 09:32:59',11,NULL,NULL,12066,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0182 validada','Autor: gdealba\nFactura FA2208-0182 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,193,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1443,1443,NULL,1,'2022-08-23 21:36:24','2022-08-23 21:36:24',40,'AC_BILL_VALIDATE','2022-08-23 21:36:24','2022-08-23 09:36:24',11,NULL,NULL,12755,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0183 validada','Autor: gdealba\nFactura FA2208-0183 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,194,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1444,1444,NULL,1,'2022-08-23 21:47:57','2022-08-23 21:47:57',40,'AC_BILL_VALIDATE','2022-08-23 21:47:57','2022-08-23 09:47:57',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0184 validada','Autor: gdealba\nFactura FA2208-0184 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,195,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1445,1445,NULL,1,'2022-08-23 21:58:37','2022-08-23 21:58:37',40,'AC_BILL_VALIDATE','2022-08-23 21:58:37','2022-08-23 09:58:37',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0185 validada','Autor: gdealba\nFactura FA2208-0185 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,196,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1446,1446,NULL,1,'2022-08-23 22:02:56','2022-08-23 22:02:56',40,'AC_BILL_VALIDATE','2022-08-23 22:02:56','2022-08-23 10:02:56',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0186 validada','Autor: gdealba\nFactura FA2208-0186 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,197,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1447,1447,NULL,1,'2022-08-23 22:06:31','2022-08-23 22:06:31',40,'AC_BILL_VALIDATE','2022-08-23 22:06:31','2022-08-23 10:06:31',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0187 validada','Autor: gdealba\nFactura FA2208-0187 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,198,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1448,1448,NULL,1,'2022-08-23 22:08:39','2022-08-23 22:08:39',40,'AC_BILL_VALIDATE','2022-08-23 22:08:39','2022-08-23 10:08:39',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0188 validada','Autor: gdealba\nFactura FA2208-0188 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,199,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1449,1449,NULL,1,'2022-08-23 22:10:07','2022-08-23 22:10:07',40,'AC_BILL_VALIDATE','2022-08-23 22:10:07','2022-08-23 10:10:07',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0189 validada','Autor: gdealba\nFactura FA2208-0189 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,200,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1450,1450,NULL,1,'2022-08-23 22:11:35','2022-08-23 22:11:35',40,'AC_BILL_VALIDATE','2022-08-23 22:11:35','2022-08-23 10:11:35',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0190 validada','Autor: gdealba\nFactura FA2208-0190 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,201,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1451,1451,NULL,1,'2022-08-23 22:16:17','2022-08-23 22:16:17',40,'AC_BILL_VALIDATE','2022-08-23 22:16:17','2022-08-23 10:16:17',11,NULL,NULL,13986,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0191 validada','Autor: gdealba\nFactura FA2208-0191 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,202,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1452,1452,NULL,1,'2022-08-23 22:47:06','2022-08-23 22:47:06',40,'AC_BILL_VALIDATE','2022-08-23 22:47:06','2022-08-23 10:47:06',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0192 validada','Autor: egarcia\nFactura FA2208-0192 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,203,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1453,1453,NULL,1,'2022-08-23 22:53:22','2022-08-23 22:53:22',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-23 22:53:22','2022-08-23 10:53:22',6,NULL,NULL,3,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0069 validada','Autor: egarcia\nFactura SI2208-0069 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,94,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1454,1454,NULL,1,'2022-08-23 22:59:13','2022-08-23 22:59:13',40,'AC_BILL_VALIDATE','2022-08-23 22:59:13','2022-08-23 10:59:13',11,NULL,NULL,13786,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0193 validada','Autor: gdealba\nFactura FA2208-0193 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,204,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1455,1455,NULL,1,'2022-08-23 23:02:04','2022-08-23 23:02:04',40,'AC_BILL_VALIDATE','2022-08-23 23:02:04','2022-08-23 11:02:04',11,NULL,NULL,13983,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0194 validada','Autor: gdealba\nFactura FA2208-0194 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,205,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1456,1456,NULL,1,'2022-08-23 23:06:57','2022-08-23 23:06:57',40,'AC_BILL_VALIDATE','2022-08-23 23:06:57','2022-08-23 11:06:57',11,NULL,NULL,14095,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0195 validada','Autor: gdealba\nFactura FA2208-0195 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,206,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1457,1457,NULL,1,'2022-08-23 23:08:15','2022-08-23 23:08:15',40,'AC_BILL_VALIDATE','2022-08-23 23:08:15','2022-08-23 11:08:15',11,NULL,NULL,13981,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0196 validada','Autor: gdealba\nFactura FA2208-0196 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,207,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1458,1458,NULL,1,'2022-08-23 23:11:20','2022-08-23 23:11:20',40,'AC_BILL_VALIDATE','2022-08-23 23:11:20','2022-08-23 11:11:20',11,NULL,NULL,10790,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0197 validada','Autor: gdealba\nFactura FA2208-0197 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,208,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1459,1459,NULL,1,'2022-08-23 23:12:15','2022-08-23 23:12:15',40,'AC_BILL_VALIDATE','2022-08-23 23:12:15','2022-08-23 11:12:15',11,NULL,NULL,10985,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0198 validada','Autor: gdealba\nFactura FA2208-0198 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,209,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1460,1460,NULL,1,'2022-08-23 23:13:08','2022-08-23 23:13:08',40,'AC_BILL_VALIDATE','2022-08-23 23:13:08','2022-08-23 11:13:08',11,NULL,NULL,10986,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0199 validada','Autor: gdealba\nFactura FA2208-0199 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,210,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1461,1461,NULL,1,'2022-08-23 23:15:18','2022-08-23 23:15:18',40,'AC_BILL_VALIDATE','2022-08-23 23:15:18','2022-08-23 11:15:18',11,NULL,NULL,10987,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0200 validada','Autor: gdealba\nFactura FA2208-0200 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,211,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1462,1462,NULL,1,'2022-08-23 23:16:33','2022-08-23 23:16:33',40,'AC_BILL_VALIDATE','2022-08-23 23:16:33','2022-08-23 11:16:33',11,NULL,NULL,10988,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0201 validada','Autor: gdealba\nFactura FA2208-0201 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,212,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1463,1463,NULL,1,'2022-08-23 23:17:08','2022-08-23 23:17:08',40,'AC_BILL_VALIDATE','2022-08-23 23:17:08','2022-08-23 11:17:08',11,NULL,NULL,10994,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0202 validada','Autor: gdealba\nFactura FA2208-0202 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,213,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1464,1464,NULL,1,'2022-08-23 23:18:10','2022-08-23 23:18:10',40,'AC_BILL_VALIDATE','2022-08-23 23:18:10','2022-08-23 11:18:10',11,NULL,NULL,11123,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0203 validada','Autor: gdealba\nFactura FA2208-0203 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,214,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1465,1465,NULL,1,'2022-08-23 23:19:07','2022-08-23 23:19:07',40,'AC_BILL_VALIDATE','2022-08-23 23:19:07','2022-08-23 11:19:07',11,NULL,NULL,11124,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0204 validada','Autor: gdealba\nFactura FA2208-0204 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,215,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1466,1466,NULL,1,'2022-08-23 23:20:06','2022-08-23 23:20:06',40,'AC_BILL_VALIDATE','2022-08-23 23:20:06','2022-08-23 11:20:06',11,NULL,NULL,11125,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0205 validada','Autor: gdealba\nFactura FA2208-0205 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,216,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1467,1467,NULL,1,'2022-08-23 23:22:04','2022-08-23 23:22:04',40,'AC_BILL_VALIDATE','2022-08-23 23:22:04','2022-08-23 11:22:04',11,NULL,NULL,11134,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0206 validada','Autor: gdealba\nFactura FA2208-0206 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,217,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1468,1468,NULL,1,'2022-08-23 23:57:38','2022-08-23 23:57:38',40,'AC_COMPANY_CREATE','2022-08-23 23:57:38','2022-08-23 11:57:38',11,NULL,NULL,14362,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Tercero FARMACIAS GUADALAJARA S.A. DE C.V creado','Autor: gdealba\nTercero FARMACIAS GUADALAJARA S.A. DE C.V creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1469,1469,NULL,1,'2022-08-24 00:01:05','2022-08-24 00:01:05',40,'AC_BILL_VALIDATE','2022-08-24 00:01:05','2022-08-23 12:01:05',11,NULL,NULL,14362,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0207 validada','Autor: gdealba\nFactura FA2208-0207 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,218,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1470,1470,NULL,1,'2022-08-24 00:03:22','2022-08-24 00:03:22',40,'AC_BILL_VALIDATE','2022-08-24 00:03:22','2022-08-23 12:03:22',11,NULL,NULL,11777,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0208 validada','Autor: gdealba\nFactura FA2208-0208 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,219,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1471,1471,NULL,1,'2022-08-24 00:04:51','2022-08-24 00:04:51',40,'AC_BILL_VALIDATE','2022-08-24 00:04:51','2022-08-23 12:04:51',11,NULL,NULL,12005,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0209 validada','Autor: gdealba\nFactura FA2208-0209 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,220,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1472,1472,NULL,1,'2022-08-24 00:05:30','2022-08-24 00:05:30',40,'AC_BILL_VALIDATE','2022-08-24 00:05:30','2022-08-23 12:05:30',11,NULL,NULL,12219,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0210 validada','Autor: gdealba\nFactura FA2208-0210 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,221,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1473,1473,NULL,1,'2022-08-24 00:06:59','2022-08-24 00:06:59',40,'AC_BILL_VALIDATE','2022-08-24 00:06:59','2022-08-23 12:06:59',11,NULL,NULL,12672,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0211 validada','Autor: gdealba\nFactura FA2208-0211 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,222,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1474,1474,NULL,1,'2022-08-24 00:08:13','2022-08-24 00:08:13',40,'AC_BILL_VALIDATE','2022-08-24 00:08:13','2022-08-23 12:08:13',11,NULL,NULL,12674,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0212 validada','Autor: gdealba\nFactura FA2208-0212 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,223,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1475,1475,NULL,1,'2022-08-24 00:09:33','2022-08-24 00:09:33',40,'AC_BILL_VALIDATE','2022-08-24 00:09:33','2022-08-23 12:09:33',11,NULL,NULL,13141,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0213 validada','Autor: gdealba\nFactura FA2208-0213 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,224,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1476,1476,NULL,1,'2022-08-24 00:10:46','2022-08-24 00:10:46',40,'AC_BILL_VALIDATE','2022-08-24 00:10:46','2022-08-23 12:10:46',11,NULL,NULL,13357,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0214 validada','Autor: gdealba\nFactura FA2208-0214 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,225,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1477,1477,NULL,1,'2022-08-24 00:12:08','2022-08-24 00:12:08',40,'AC_BILL_VALIDATE','2022-08-24 00:12:08','2022-08-23 12:12:08',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0215 validada','Autor: gdealba\nFactura FA2208-0215 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,226,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1478,1478,NULL,1,'2022-08-24 00:56:33','2022-08-24 00:56:33',40,'AC_BILL_VALIDATE','2022-08-24 00:56:33','2022-08-23 12:56:33',11,NULL,NULL,13950,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0216 validada','Autor: gdealba\nFactura FA2208-0216 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,227,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1479,1479,NULL,1,'2022-08-24 01:05:37','2022-08-24 01:05:37',40,'AC_BILL_VALIDATE','2022-08-24 01:05:37','2022-08-23 13:05:37',11,NULL,NULL,14105,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0217 validada','Autor: gdealba\nFactura FA2208-0217 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,228,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1480,1480,NULL,1,'2022-08-24 01:09:52','2022-08-24 01:09:52',40,'AC_BILL_VALIDATE','2022-08-24 01:09:52','2022-08-23 13:09:52',11,NULL,NULL,13869,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0218 validada','Autor: gdealba\nFactura FA2208-0218 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,229,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1481,1481,NULL,1,'2022-08-24 01:15:32','2022-08-24 01:15:32',40,'AC_BILL_DELETE','2022-08-24 01:15:32','2022-08-23 13:15:32',11,NULL,NULL,12201,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura eliminada','Autor: gdealba\nFactura eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,30,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1482,1482,NULL,1,'2022-08-24 01:16:12','2022-08-24 01:16:12',40,'AC_BILL_VALIDATE','2022-08-24 01:16:12','2022-08-23 13:16:12',11,NULL,NULL,10920,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0219 validada','Autor: gdealba\nFactura FA2208-0219 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,230,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1483,1483,NULL,1,'2022-08-24 01:17:10','2022-08-24 01:17:10',40,'AC_BILL_VALIDATE','2022-08-24 01:17:10','2022-08-23 13:17:10',11,NULL,NULL,10941,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0220 validada','Autor: gdealba\nFactura FA2208-0220 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,231,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1484,1484,NULL,1,'2022-08-24 01:18:02','2022-08-24 01:18:02',40,'AC_BILL_VALIDATE','2022-08-24 01:18:02','2022-08-23 13:18:02',11,NULL,NULL,11152,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0221 validada','Autor: gdealba\nFactura FA2208-0221 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,232,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1485,1485,NULL,1,'2022-08-24 01:18:47','2022-08-24 01:18:47',40,'AC_BILL_UNVALIDATE','2022-08-24 01:18:47','2022-08-23 13:18:47',11,NULL,NULL,11152,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura FA2208-0221 al estado de borrador','Autor: gdealba\nRegresar factura FA2208-0221 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,232,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1486,1486,NULL,1,'2022-08-24 01:19:09','2022-08-24 01:19:09',40,'AC_BILL_VALIDATE','2022-08-24 01:19:09','2022-08-23 13:19:09',11,NULL,NULL,11152,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0221 validada','Autor: gdealba\nFactura FA2208-0221 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,232,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1487,1487,NULL,1,'2022-08-24 01:19:33','2022-08-24 01:19:33',40,'AC_BILL_DELETE','2022-08-24 01:19:33','2022-08-23 13:19:33',11,NULL,NULL,11152,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura eliminada','Autor: gdealba\nFactura eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,232,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1488,1488,NULL,1,'2022-08-24 01:20:06','2022-08-24 01:20:06',40,'AC_BILL_VALIDATE','2022-08-24 01:20:06','2022-08-23 13:20:06',11,NULL,NULL,10952,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0221 validada','Autor: gdealba\nFactura FA2208-0221 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,233,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1489,1489,NULL,1,'2022-08-24 01:20:51','2022-08-24 01:20:51',40,'AC_BILL_VALIDATE','2022-08-24 01:20:51','2022-08-23 13:20:51',11,NULL,NULL,11152,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0222 validada','Autor: gdealba\nFactura FA2208-0222 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,234,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1490,1490,NULL,1,'2022-08-24 01:21:36','2022-08-24 01:21:36',40,'AC_BILL_VALIDATE','2022-08-24 01:21:36','2022-08-23 13:21:36',11,NULL,NULL,12433,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0223 validada','Autor: gdealba\nFactura FA2208-0223 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,235,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1491,1491,NULL,1,'2022-08-24 01:23:15','2022-08-24 01:23:15',40,'AC_BILL_VALIDATE','2022-08-24 01:23:15','2022-08-23 13:23:15',11,NULL,NULL,12441,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0224 validada','Autor: gdealba\nFactura FA2208-0224 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,236,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1492,1492,NULL,1,'2022-08-24 01:24:38','2022-08-24 01:24:38',40,'AC_BILL_VALIDATE','2022-08-24 01:24:38','2022-08-23 13:24:38',11,NULL,NULL,12700,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0225 validada','Autor: gdealba\nFactura FA2208-0225 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,237,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1493,1493,NULL,1,'2022-08-24 01:26:10','2022-08-24 01:26:10',40,'AC_BILL_VALIDATE','2022-08-24 01:26:10','2022-08-23 13:26:10',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0226 validada','Autor: egarcia\nFactura FA2208-0226 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,239,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1494,1494,NULL,1,'2022-08-24 01:26:46','2022-08-24 01:26:46',40,'AC_BILL_VALIDATE','2022-08-24 01:26:46','2022-08-23 13:26:46',11,NULL,NULL,13140,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0227 validada','Autor: gdealba\nFactura FA2208-0227 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,238,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1495,1495,NULL,1,'2022-08-24 01:27:52','2022-08-24 01:27:52',40,'AC_BILL_VALIDATE','2022-08-24 01:27:52','2022-08-23 13:27:52',11,NULL,NULL,13637,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0228 validada','Autor: gdealba\nFactura FA2208-0228 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,240,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1496,1496,NULL,1,'2022-08-24 01:28:28','2022-08-24 01:28:28',40,'AC_BILL_VALIDATE','2022-08-24 01:28:28','2022-08-23 13:28:28',11,NULL,NULL,13637,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0229 validada','Autor: gdealba\nFactura FA2208-0229 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,241,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1497,1497,NULL,1,'2022-08-24 01:30:20','2022-08-24 01:30:20',40,'AC_BILL_VALIDATE','2022-08-24 01:30:20','2022-08-23 13:30:20',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0230 validada','Autor: gdealba\nFactura FA2208-0230 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,242,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1498,1498,NULL,1,'2022-08-24 01:32:29','2022-08-24 01:32:29',40,'AC_BILL_VALIDATE','2022-08-24 01:32:29','2022-08-23 13:32:29',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0231 validada','Autor: gdealba\nFactura FA2208-0231 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,243,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1499,1499,NULL,1,'2022-08-24 01:33:36','2022-08-24 01:33:36',40,'AC_BILL_VALIDATE','2022-08-24 01:33:36','2022-08-23 13:33:36',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0232 validada','Autor: gdealba\nFactura FA2208-0232 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,244,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1500,1500,NULL,1,'2022-08-24 01:35:58','2022-08-24 01:35:58',40,'AC_BILL_VALIDATE','2022-08-24 01:35:58','2022-08-23 13:35:58',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0233 validada','Autor: gdealba\nFactura FA2208-0233 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,245,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1501,1501,NULL,1,'2022-08-24 01:37:03','2022-08-24 01:37:03',40,'AC_BILL_VALIDATE','2022-08-24 01:37:03','2022-08-23 13:37:03',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0234 validada','Autor: gdealba\nFactura FA2208-0234 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,246,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1502,1502,NULL,1,'2022-08-24 01:39:14','2022-08-24 01:39:14',40,'AC_BILL_VALIDATE','2022-08-24 01:39:14','2022-08-23 13:39:14',11,NULL,NULL,12960,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0235 validada','Autor: gdealba\nFactura FA2208-0235 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,247,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1503,1503,NULL,1,'2022-08-24 01:43:45','2022-08-24 01:43:45',40,'AC_COMPANY_CREATE','2022-08-24 01:43:45','2022-08-23 13:43:45',11,NULL,NULL,14363,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Tercero ABORRETERA DEL DUERO creado','Autor: gdealba\nTercero ABORRETERA DEL DUERO creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1504,1504,NULL,1,'2022-08-24 01:46:14','2022-08-24 01:46:14',40,'AC_BILL_DELETE','2022-08-24 01:46:14','2022-08-23 13:46:14',11,NULL,NULL,14363,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura eliminada','Autor: gdealba\nFactura eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,248,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1505,1505,NULL,1,'2022-08-24 01:47:30','2022-08-24 01:47:30',40,'AC_BILL_VALIDATE','2022-08-24 01:47:30','2022-08-23 13:47:30',11,NULL,NULL,14363,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0236 validada','Autor: gdealba\nFactura FA2208-0236 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,249,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1506,1506,NULL,1,'2022-08-24 01:49:39','2022-08-24 01:49:39',40,'AC_BILL_VALIDATE','2022-08-24 01:49:39','2022-08-23 13:49:39',11,NULL,NULL,14122,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0237 validada','Autor: gdealba\nFactura FA2208-0237 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,250,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1507,1507,NULL,1,'2022-08-24 13:42:54','2022-08-24 13:42:54',40,'AC_BILL_VALIDATE','2022-08-24 13:42:54','2022-08-24 01:42:54',11,NULL,NULL,13987,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0238 validada','Autor: gdealba\nFactura FA2208-0238 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,251,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1508,1508,NULL,1,'2022-08-24 13:47:25','2022-08-24 13:47:25',40,'AC_BILL_VALIDATE','2022-08-24 13:47:25','2022-08-24 01:47:25',11,NULL,NULL,13972,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0239 validada','Autor: gdealba\nFactura FA2208-0239 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,252,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1509,1509,NULL,1,'2022-08-24 13:53:16','2022-08-24 13:53:16',40,'AC_BILL_VALIDATE','2022-08-24 13:53:16','2022-08-24 01:53:16',11,NULL,NULL,13791,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0240 validada','Autor: gdealba\nFactura FA2208-0240 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,253,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1510,1510,NULL,1,'2022-08-24 14:13:55','2022-08-24 14:13:55',40,'AC_BILL_VALIDATE','2022-08-24 14:13:55','2022-08-24 02:13:55',11,NULL,NULL,11004,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0241 validada','Autor: gdealba\nFactura FA2208-0241 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,254,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1511,1511,NULL,1,'2022-08-24 14:19:12','2022-08-24 14:19:12',40,'AC_BILL_VALIDATE','2022-08-24 14:19:12','2022-08-24 02:19:12',11,NULL,NULL,11003,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0242 validada','Autor: gdealba\nFactura FA2208-0242 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,255,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1512,1512,NULL,1,'2022-08-24 14:22:05','2022-08-24 14:22:05',40,'AC_BILL_VALIDATE','2022-08-24 14:22:05','2022-08-24 02:22:05',11,NULL,NULL,11213,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0243 validada','Autor: gdealba\nFactura FA2208-0243 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,256,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1513,1513,NULL,1,'2022-08-24 14:23:51','2022-08-24 14:23:51',40,'AC_USER_NEW_PASSWORD','2022-08-24 14:23:51','2022-08-24 02:23:51',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'PASSWORDInDolibarr','Autor: admin\nPASSWORDInDolibarr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,10,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1514,1514,NULL,1,'2022-08-24 14:23:51','2022-08-24 14:23:51',40,'AC_USER_MODIFY','2022-08-24 14:23:51','2022-08-24 02:23:51',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 10 modificado','Autor: admin\nRegistro 10 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,10,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1515,1515,NULL,1,'2022-08-24 14:25:07','2022-08-24 14:25:07',40,'AC_BILL_VALIDATE','2022-08-24 14:25:07','2022-08-24 02:25:07',11,NULL,NULL,11629,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0244 validada','Autor: gdealba\nFactura FA2208-0244 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,257,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1516,1516,NULL,1,'2022-08-24 14:28:13','2022-08-24 14:28:13',40,'AC_BILL_VALIDATE','2022-08-24 14:28:13','2022-08-24 02:28:13',11,NULL,NULL,11719,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0245 validada','Autor: gdealba\nFactura FA2208-0245 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,258,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1517,1517,NULL,1,'2022-08-24 14:30:27','2022-08-24 14:30:27',40,'AC_BILL_VALIDATE','2022-08-24 14:30:27','2022-08-24 02:30:27',11,NULL,NULL,12129,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0246 validada','Autor: gdealba\nFactura FA2208-0246 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,259,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1518,1518,NULL,1,'2022-08-24 14:33:34','2022-08-24 14:33:34',40,'AC_BILL_VALIDATE','2022-08-24 14:33:34','2022-08-24 02:33:34',11,NULL,NULL,12497,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0247 validada','Autor: gdealba\nFactura FA2208-0247 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,260,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1519,1519,NULL,1,'2022-08-24 14:35:50','2022-08-24 14:35:50',40,'AC_BILL_VALIDATE','2022-08-24 14:35:50','2022-08-24 02:35:50',11,NULL,NULL,12678,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0248 validada','Autor: gdealba\nFactura FA2208-0248 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,261,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1520,1520,NULL,1,'2022-08-24 14:37:39','2022-08-24 14:37:39',40,'AC_BILL_VALIDATE','2022-08-24 14:37:39','2022-08-24 02:37:39',11,NULL,NULL,13112,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0249 validada','Autor: gdealba\nFactura FA2208-0249 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,262,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1521,1521,NULL,1,'2022-08-24 14:45:58','2022-08-24 14:45:58',40,'AC_BILL_VALIDATE','2022-08-24 14:45:58','2022-08-24 02:45:58',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0250 validada','Autor: gdealba\nFactura FA2208-0250 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,263,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1522,1522,NULL,1,'2022-08-24 14:48:18','2022-08-24 14:48:18',40,'AC_BILL_VALIDATE','2022-08-24 14:48:18','2022-08-24 02:48:18',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0251 validada','Autor: gdealba\nFactura FA2208-0251 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,264,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1523,1523,NULL,1,'2022-08-24 14:50:43','2022-08-24 14:50:43',40,'AC_BILL_VALIDATE','2022-08-24 14:50:43','2022-08-24 02:50:43',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0252 validada','Autor: gdealba\nFactura FA2208-0252 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,265,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1524,1524,NULL,1,'2022-08-24 14:55:02','2022-08-24 14:55:02',40,'AC_BILL_VALIDATE','2022-08-24 14:55:02','2022-08-24 02:55:02',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0253 validada','Autor: gdealba\nFactura FA2208-0253 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,266,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1525,1525,NULL,1,'2022-08-24 14:55:58','2022-08-24 14:55:58',40,'AC_BILL_VALIDATE','2022-08-24 14:55:58','2022-08-24 02:55:58',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0254 validada','Autor: gdealba\nFactura FA2208-0254 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,267,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1526,1526,NULL,1,'2022-08-24 14:58:04','2022-08-24 14:58:04',40,'AC_BILL_VALIDATE','2022-08-24 14:58:04','2022-08-24 02:58:04',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0255 validada','Autor: gdealba\nFactura FA2208-0255 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,268,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1527,1527,NULL,1,'2022-08-24 14:59:29','2022-08-24 14:59:29',40,'AC_BILL_VALIDATE','2022-08-24 14:59:29','2022-08-24 02:59:29',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0256 validada','Autor: gdealba\nFactura FA2208-0256 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,269,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1528,1528,NULL,1,'2022-08-24 15:05:53','2022-08-24 15:05:53',40,'AC_BILL_VALIDATE','2022-08-24 15:05:53','2022-08-24 03:05:53',11,NULL,NULL,13863,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0257 validada','Autor: gdealba\nFactura FA2208-0257 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,270,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1529,1529,NULL,1,'2022-08-24 15:07:29','2022-08-24 15:07:29',40,'AC_USER_MODIFY','2022-08-24 15:07:29','2022-08-24 03:07:29',10,NULL,NULL,NULL,NULL,0,10,NULL,0,0,'default',0,-1,'',NULL,'Registro 9 modificado','Autor: ebonilla\nRegistro 9 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,9,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1530,1530,NULL,1,'2022-08-24 15:09:06','2022-08-24 15:09:06',40,'AC_USER_NEW_PASSWORD','2022-08-24 15:09:06','2022-08-24 03:09:06',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'PASSWORDInDolibarr','Autor: admin\nPASSWORDInDolibarr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,9,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1531,1531,NULL,1,'2022-08-24 15:09:06','2022-08-24 15:09:06',40,'AC_USER_MODIFY','2022-08-24 15:09:06','2022-08-24 03:09:06',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 9 modificado','Autor: admin\nRegistro 9 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,9,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1532,1532,NULL,1,'2022-08-24 15:11:17','2022-08-24 15:11:17',40,'AC_BILL_VALIDATE','2022-08-24 15:11:17','2022-08-24 03:11:17',11,NULL,NULL,13793,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0258 validada','Autor: gdealba\nFactura FA2208-0258 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,271,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1533,1533,NULL,1,'2022-08-24 15:13:11','2022-08-24 15:13:11',40,'AC_BILL_VALIDATE','2022-08-24 15:13:11','2022-08-24 03:13:11',11,NULL,NULL,10803,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0259 validada','Autor: gdealba\nFactura FA2208-0259 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,272,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1534,1534,NULL,1,'2022-08-24 15:14:56','2022-08-24 15:14:56',40,'AC_BILL_VALIDATE','2022-08-24 15:14:56','2022-08-24 03:14:56',11,NULL,NULL,10814,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0260 validada','Autor: gdealba\nFactura FA2208-0260 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,273,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1535,1535,NULL,1,'2022-08-24 15:17:05','2022-08-24 15:17:05',40,'AC_BILL_VALIDATE','2022-08-24 15:17:05','2022-08-24 03:17:05',11,NULL,NULL,11076,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0261 validada','Autor: gdealba\nFactura FA2208-0261 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,274,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1536,1536,NULL,1,'2022-08-24 15:20:31','2022-08-24 15:20:31',40,'AC_BILL_VALIDATE','2022-08-24 15:20:31','2022-08-24 03:20:31',11,NULL,NULL,11876,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0262 validada','Autor: gdealba\nFactura FA2208-0262 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,275,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1537,1537,NULL,1,'2022-08-24 15:25:22','2022-08-24 15:25:22',40,'AC_BILL_VALIDATE','2022-08-24 15:25:22','2022-08-24 03:25:22',11,NULL,NULL,12101,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0263 validada','Autor: gdealba\nFactura FA2208-0263 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,276,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1538,1538,NULL,1,'2022-08-24 15:26:17','2022-08-24 15:26:17',40,'AC_BILL_VALIDATE','2022-08-24 15:26:17','2022-08-24 03:26:17',11,NULL,NULL,12184,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0264 validada','Autor: gdealba\nFactura FA2208-0264 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,277,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1539,1539,NULL,1,'2022-08-24 15:28:47','2022-08-24 15:28:47',40,'AC_BILL_VALIDATE','2022-08-24 15:28:47','2022-08-24 03:28:47',11,NULL,NULL,12687,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0265 validada','Autor: gdealba\nFactura FA2208-0265 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,278,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1540,1540,NULL,1,'2022-08-24 15:32:14','2022-08-24 15:32:14',40,'AC_BILL_VALIDATE','2022-08-24 15:32:14','2022-08-24 03:32:14',11,NULL,NULL,13562,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0266 validada','Autor: gdealba\nFactura FA2208-0266 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,279,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1541,1541,NULL,1,'2022-08-24 15:34:58','2022-08-24 15:34:58',40,'AC_BILL_UNVALIDATE','2022-08-24 15:34:58','2022-08-24 03:34:58',11,NULL,NULL,13863,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura FA2208-0257 al estado de borrador','Autor: gdealba\nRegresar factura FA2208-0257 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,270,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1542,1542,NULL,1,'2022-08-24 15:35:21','2022-08-24 15:35:21',40,'AC_BILL_VALIDATE','2022-08-24 15:35:21','2022-08-24 03:35:21',11,NULL,NULL,13863,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0257 validada','Autor: gdealba\nFactura FA2208-0257 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,270,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1543,1543,NULL,1,'2022-08-24 15:40:15','2022-08-24 15:40:15',40,'AC_BILL_VALIDATE','2022-08-24 15:40:15','2022-08-24 03:40:15',11,NULL,NULL,14049,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0267 validada','Autor: gdealba\nFactura FA2208-0267 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,280,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1544,1544,NULL,1,'2022-08-24 15:43:38','2022-08-24 15:43:38',40,'AC_BILL_VALIDATE','2022-08-24 15:43:38','2022-08-24 03:43:38',11,NULL,NULL,14085,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0268 validada','Autor: gdealba\nFactura FA2208-0268 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,281,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1545,1545,NULL,1,'2022-08-24 15:45:31','2022-08-24 15:45:31',40,'AC_BILL_VALIDATE','2022-08-24 15:45:31','2022-08-24 03:45:31',11,NULL,NULL,13994,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0269 validada','Autor: gdealba\nFactura FA2208-0269 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,282,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1546,1546,NULL,1,'2022-08-24 15:47:53','2022-08-24 15:47:53',40,'AC_BILL_VALIDATE','2022-08-24 15:47:53','2022-08-24 03:47:53',11,NULL,NULL,11655,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0270 validada','Autor: gdealba\nFactura FA2208-0270 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,283,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1547,1547,NULL,1,'2022-08-24 15:49:09','2022-08-24 15:49:09',40,'AC_BILL_VALIDATE','2022-08-24 15:49:09','2022-08-24 03:49:09',11,NULL,NULL,12131,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0271 validada','Autor: gdealba\nFactura FA2208-0271 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,284,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1548,1548,NULL,1,'2022-08-24 15:50:50','2022-08-24 15:50:50',40,'AC_BILL_VALIDATE','2022-08-24 15:50:50','2022-08-24 03:50:50',11,NULL,NULL,12641,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0272 validada','Autor: gdealba\nFactura FA2208-0272 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,285,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1549,1549,NULL,1,'2022-08-24 15:51:48','2022-08-24 15:51:48',40,'AC_BILL_VALIDATE','2022-08-24 15:51:48','2022-08-24 03:51:48',11,NULL,NULL,13543,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0273 validada','Autor: gdealba\nFactura FA2208-0273 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,286,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1550,1550,NULL,1,'2022-08-24 15:53:42','2022-08-24 15:53:42',40,'AC_BILL_VALIDATE','2022-08-24 15:53:42','2022-08-24 03:53:42',11,NULL,NULL,13670,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0274 validada','Autor: gdealba\nFactura FA2208-0274 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,287,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1551,1551,NULL,1,'2022-08-24 15:55:48','2022-08-24 15:55:48',40,'AC_BILL_VALIDATE','2022-08-24 15:55:48','2022-08-24 03:55:48',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0275 validada','Autor: gdealba\nFactura FA2208-0275 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,288,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1552,1552,NULL,1,'2022-08-24 15:58:55','2022-08-24 15:58:55',40,'AC_BILL_VALIDATE','2022-08-24 15:58:55','2022-08-24 03:58:55',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0276 validada','Autor: gdealba\nFactura FA2208-0276 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,289,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1553,1553,NULL,1,'2022-08-24 16:01:27','2022-08-24 16:01:27',40,'AC_BILL_VALIDATE','2022-08-24 16:01:27','2022-08-24 04:01:27',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0277 validada','Autor: gdealba\nFactura FA2208-0277 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,290,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1554,1554,NULL,1,'2022-08-24 16:03:32','2022-08-24 16:03:32',40,'AC_BILL_VALIDATE','2022-08-24 16:03:32','2022-08-24 04:03:32',11,NULL,NULL,14022,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0278 validada','Autor: gdealba\nFactura FA2208-0278 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,291,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1555,1555,NULL,1,'2022-08-24 16:05:41','2022-08-24 16:05:41',40,'AC_BILL_VALIDATE','2022-08-24 16:05:41','2022-08-24 04:05:41',11,NULL,NULL,14363,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0279 validada','Autor: gdealba\nFactura FA2208-0279 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,292,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1556,1556,NULL,1,'2022-08-24 16:08:41','2022-08-24 16:08:41',40,'AC_BILL_VALIDATE','2022-08-24 16:08:41','2022-08-24 04:08:41',11,NULL,NULL,10828,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0280 validada','Autor: gdealba\nFactura FA2208-0280 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,293,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1557,1557,NULL,1,'2022-08-24 16:09:39','2022-08-24 16:09:39',40,'AC_BILL_VALIDATE','2022-08-24 16:09:39','2022-08-24 04:09:39',11,NULL,NULL,11094,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0281 validada','Autor: gdealba\nFactura FA2208-0281 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,294,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1558,1558,NULL,1,'2022-08-24 16:11:06','2022-08-24 16:11:06',40,'AC_BILL_VALIDATE','2022-08-24 16:11:06','2022-08-24 04:11:06',11,NULL,NULL,11141,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0282 validada','Autor: gdealba\nFactura FA2208-0282 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,295,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1559,1559,NULL,1,'2022-08-24 16:16:24','2022-08-24 16:16:24',40,'AC_BILL_VALIDATE','2022-08-24 16:16:24','2022-08-24 04:16:24',11,NULL,NULL,11142,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0283 validada','Autor: gdealba\nFactura FA2208-0283 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,296,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1560,1560,NULL,1,'2022-08-24 16:17:39','2022-08-24 16:17:39',40,'AC_BILL_VALIDATE','2022-08-24 16:17:39','2022-08-24 04:17:39',11,NULL,NULL,11144,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0284 validada','Autor: gdealba\nFactura FA2208-0284 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,297,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1561,1561,NULL,1,'2022-08-24 16:19:36','2022-08-24 16:19:36',40,'AC_BILL_VALIDATE','2022-08-24 16:19:36','2022-08-24 04:19:36',11,NULL,NULL,11145,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0285 validada','Autor: gdealba\nFactura FA2208-0285 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,298,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1562,1562,NULL,1,'2022-08-24 16:20:46','2022-08-24 16:20:46',40,'AC_BILL_VALIDATE','2022-08-24 16:20:46','2022-08-24 04:20:46',11,NULL,NULL,12884,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0286 validada','Autor: gdealba\nFactura FA2208-0286 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,299,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1563,1563,NULL,1,'2022-08-24 16:23:29','2022-08-24 16:23:29',40,'AC_BILL_VALIDATE','2022-08-24 16:23:29','2022-08-24 04:23:29',11,NULL,NULL,13054,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0287 validada','Autor: gdealba\nFactura FA2208-0287 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,300,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1564,1564,NULL,1,'2022-08-24 16:26:37','2022-08-24 16:26:37',40,'AC_BILL_VALIDATE','2022-08-24 16:26:37','2022-08-24 04:26:37',11,NULL,NULL,13715,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0288 validada','Autor: gdealba\nFactura FA2208-0288 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,301,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1565,1565,NULL,1,'2022-08-24 16:28:20','2022-08-24 16:28:20',40,'AC_BILL_VALIDATE','2022-08-24 16:28:20','2022-08-24 04:28:20',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0289 validada','Autor: gdealba\nFactura FA2208-0289 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,302,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1566,1566,NULL,1,'2022-08-24 18:40:20','2022-08-24 18:40:20',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-24 18:40:20','2022-08-24 06:40:20',6,NULL,NULL,3,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0070 validada','Autor: egarcia\nFactura SI2208-0070 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,95,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1567,1567,NULL,1,'2022-08-24 18:44:14','2022-08-24 18:44:14',40,'AC_BILL_VALIDATE','2022-08-24 18:44:14','2022-08-24 06:44:14',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0290 validada','Autor: egarcia\nFactura FA2208-0290 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,303,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1568,1568,NULL,1,'2022-08-24 18:58:25','2022-08-24 18:58:25',40,'AC_BILL_VALIDATE','2022-08-24 18:58:25','2022-08-24 06:58:25',6,NULL,NULL,12959,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0291 validada','Autor: egarcia\nFactura FA2208-0291 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,304,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1569,1569,NULL,1,'2022-08-24 20:01:26','2022-08-24 20:01:26',40,'AC_BILL_VALIDATE','2022-08-24 20:01:26','2022-08-24 08:01:26',11,NULL,NULL,13828,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0292 validada','Autor: gdealba\nFactura FA2208-0292 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,305,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1570,1570,NULL,1,'2022-08-24 20:02:39','2022-08-24 20:02:39',40,'AC_BILL_VALIDATE','2022-08-24 20:02:39','2022-08-24 08:02:39',11,NULL,NULL,10846,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0293 validada','Autor: gdealba\nFactura FA2208-0293 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,306,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1571,1571,NULL,1,'2022-08-24 20:04:50','2022-08-24 20:04:50',40,'AC_BILL_VALIDATE','2022-08-24 20:04:50','2022-08-24 08:04:50',11,NULL,NULL,11961,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0294 validada','Autor: gdealba\nFactura FA2208-0294 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,307,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1572,1572,NULL,1,'2022-08-24 20:06:32','2022-08-24 20:06:32',40,'AC_BILL_VALIDATE','2022-08-24 20:06:32','2022-08-24 08:06:32',11,NULL,NULL,12333,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0295 validada','Autor: gdealba\nFactura FA2208-0295 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,308,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1573,1573,NULL,1,'2022-08-24 20:13:51','2022-08-24 20:13:51',40,'AC_PRODUCT_MODIFY','2022-08-24 20:13:51','2022-08-24 08:13:51',4,NULL,NULL,NULL,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Producto AVENA_GRANEL modificado','Autor: yrodriguez\nProducto AVENA_GRANEL modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,186,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1574,1574,NULL,1,'2022-08-24 20:15:48','2022-08-24 20:15:48',40,'AC_BILL_DELETE','2022-08-24 20:15:48','2022-08-24 08:15:48',11,NULL,NULL,12736,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura eliminada','Autor: gdealba\nFactura eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,309,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1575,1575,NULL,1,'2022-08-24 20:23:45','2022-08-24 20:23:45',40,'AC_BILL_VALIDATE','2022-08-24 20:23:45','2022-08-24 08:23:45',11,NULL,NULL,12736,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0296 validada','Autor: gdealba\nFactura FA2208-0296 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,310,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1576,1576,NULL,1,'2022-08-24 20:26:33','2022-08-24 20:26:33',40,'AC_BILL_VALIDATE','2022-08-24 20:26:33','2022-08-24 08:26:33',11,NULL,NULL,12770,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0297 validada','Autor: gdealba\nFactura FA2208-0297 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,311,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1577,1577,NULL,1,'2022-08-24 20:28:24','2022-08-24 20:28:24',40,'AC_BILL_VALIDATE','2022-08-24 20:28:24','2022-08-24 08:28:24',11,NULL,NULL,13587,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0298 validada','Autor: gdealba\nFactura FA2208-0298 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,312,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1578,1578,NULL,1,'2022-08-24 20:31:00','2022-08-24 20:31:00',40,'AC_BILL_VALIDATE','2022-08-24 20:31:00','2022-08-24 08:31:00',11,NULL,NULL,11692,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0299 validada','Autor: gdealba\nFactura FA2208-0299 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,313,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1579,1579,NULL,1,'2022-08-24 20:33:17','2022-08-24 20:33:17',40,'AC_BILL_VALIDATE','2022-08-24 20:33:17','2022-08-24 08:33:17',11,NULL,NULL,11718,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0300 validada','Autor: gdealba\nFactura FA2208-0300 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,314,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1580,1580,NULL,1,'2022-08-24 20:38:49','2022-08-24 20:38:49',40,'AC_BILL_UNVALIDATE','2022-08-24 20:38:49','2022-08-24 08:38:49',11,NULL,NULL,11692,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura FA2208-0299 al estado de borrador','Autor: gdealba\nRegresar factura FA2208-0299 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,313,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1581,1581,NULL,1,'2022-08-24 20:40:07','2022-08-24 20:40:07',40,'AC_BILL_VALIDATE','2022-08-24 20:40:07','2022-08-24 08:40:07',11,NULL,NULL,11692,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0299 validada','Autor: gdealba\nFactura FA2208-0299 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,313,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1582,1582,NULL,1,'2022-08-24 20:41:40','2022-08-24 20:41:40',40,'AC_BILL_VALIDATE','2022-08-24 20:41:40','2022-08-24 08:41:40',11,NULL,NULL,13032,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0301 validada','Autor: gdealba\nFactura FA2208-0301 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,315,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1583,1583,NULL,1,'2022-08-24 20:45:57','2022-08-24 20:45:57',40,'AC_BILL_VALIDATE','2022-08-24 20:45:57','2022-08-24 08:45:57',11,NULL,NULL,13369,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0302 validada','Autor: gdealba\nFactura FA2208-0302 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,316,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1584,1584,NULL,1,'2022-08-24 20:47:30','2022-08-24 20:47:30',40,'AC_BILL_VALIDATE','2022-08-24 20:47:30','2022-08-24 08:47:30',11,NULL,NULL,13371,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0303 validada','Autor: gdealba\nFactura FA2208-0303 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,317,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1585,1585,NULL,1,'2022-08-24 20:49:12','2022-08-24 20:49:12',40,'AC_BILL_VALIDATE','2022-08-24 20:49:12','2022-08-24 08:49:12',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0304 validada','Autor: gdealba\nFactura FA2208-0304 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,318,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1586,1586,NULL,1,'2022-08-24 20:53:01','2022-08-24 20:53:01',40,'AC_BILL_VALIDATE','2022-08-24 20:53:01','2022-08-24 08:53:01',11,NULL,NULL,13856,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0305 validada','Autor: gdealba\nFactura FA2208-0305 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,320,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1587,1587,NULL,1,'2022-08-24 20:54:23','2022-08-24 20:54:23',40,'AC_BILL_VALIDATE','2022-08-24 20:54:23','2022-08-24 08:54:23',11,NULL,NULL,13884,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0306 validada','Autor: gdealba\nFactura FA2208-0306 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,321,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1588,1588,NULL,1,'2022-08-24 21:06:14','2022-08-24 21:06:14',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-24 21:06:14','2022-08-24 09:06:14',6,NULL,NULL,3,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0071 validada','Autor: egarcia\nFactura SI2208-0071 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,96,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1589,1589,NULL,1,'2022-08-24 21:16:58','2022-08-24 21:16:58',40,'AC_BILL_VALIDATE','2022-08-24 21:16:58','2022-08-24 09:16:58',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0307 validada','Autor: egarcia\nFactura FA2208-0307 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,322,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1590,1590,NULL,1,'2022-08-24 22:14:58','2022-08-24 22:14:58',40,'AC_BILL_VALIDATE','2022-08-24 22:14:58','2022-08-24 10:14:58',11,NULL,NULL,13876,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0308 validada','Autor: gdealba\nFactura FA2208-0308 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,323,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1591,1591,NULL,1,'2022-08-24 22:16:13','2022-08-24 22:16:13',40,'AC_BILL_VALIDATE','2022-08-24 22:16:13','2022-08-24 10:16:13',11,NULL,NULL,10908,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0309 validada','Autor: gdealba\nFactura FA2208-0309 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,324,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1592,1592,NULL,1,'2022-08-24 22:17:44','2022-08-24 22:17:44',40,'AC_BILL_DELETE','2022-08-24 22:17:44','2022-08-24 10:17:44',11,NULL,NULL,10909,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura eliminada','Autor: gdealba\nFactura eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,325,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1593,1593,NULL,1,'2022-08-24 22:19:06','2022-08-24 22:19:06',40,'AC_BILL_VALIDATE','2022-08-24 22:19:06','2022-08-24 10:19:06',11,NULL,NULL,10909,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0310 validada','Autor: gdealba\nFactura FA2208-0310 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,326,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1594,1594,NULL,1,'2022-08-24 22:20:02','2022-08-24 22:20:02',40,'AC_BILL_VALIDATE','2022-08-24 22:20:02','2022-08-24 10:20:02',11,NULL,NULL,10944,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0311 validada','Autor: gdealba\nFactura FA2208-0311 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,327,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1595,1595,NULL,1,'2022-08-24 22:20:47','2022-08-24 22:20:47',40,'AC_BILL_VALIDATE','2022-08-24 22:20:47','2022-08-24 10:20:47',11,NULL,NULL,10944,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0312 validada','Autor: gdealba\nFactura FA2208-0312 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,328,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1596,1596,NULL,1,'2022-08-24 22:21:24','2022-08-24 22:21:24',40,'AC_BILL_VALIDATE','2022-08-24 22:21:24','2022-08-24 10:21:24',11,NULL,NULL,11045,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0313 validada','Autor: gdealba\nFactura FA2208-0313 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,329,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1597,1597,NULL,1,'2022-08-24 22:21:56','2022-08-24 22:21:56',40,'AC_BILL_VALIDATE','2022-08-24 22:21:56','2022-08-24 10:21:56',11,NULL,NULL,11045,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0314 validada','Autor: gdealba\nFactura FA2208-0314 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,330,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1598,1598,NULL,1,'2022-08-24 22:23:09','2022-08-24 22:23:09',40,'AC_BILL_VALIDATE','2022-08-24 22:23:09','2022-08-24 10:23:09',11,NULL,NULL,11046,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0315 validada','Autor: gdealba\nFactura FA2208-0315 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,331,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1599,1599,NULL,1,'2022-08-24 22:24:09','2022-08-24 22:24:09',40,'AC_BILL_VALIDATE','2022-08-24 22:24:09','2022-08-24 10:24:09',11,NULL,NULL,11054,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0316 validada','Autor: gdealba\nFactura FA2208-0316 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,332,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1600,1600,NULL,1,'2022-08-24 22:24:49','2022-08-24 22:24:49',40,'AC_BILL_VALIDATE','2022-08-24 22:24:49','2022-08-24 10:24:49',11,NULL,NULL,11722,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0317 validada','Autor: gdealba\nFactura FA2208-0317 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,333,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1601,1601,NULL,1,'2022-08-24 22:26:18','2022-08-24 22:26:18',40,'AC_BILL_VALIDATE','2022-08-24 22:26:18','2022-08-24 10:26:18',11,NULL,NULL,11723,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0318 validada','Autor: gdealba\nFactura FA2208-0318 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,334,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1602,1602,NULL,1,'2022-08-24 22:27:26','2022-08-24 22:27:26',40,'AC_BILL_VALIDATE','2022-08-24 22:27:26','2022-08-24 10:27:26',11,NULL,NULL,11724,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0319 validada','Autor: gdealba\nFactura FA2208-0319 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,335,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1603,1603,NULL,1,'2022-08-24 22:28:36','2022-08-24 22:28:36',40,'AC_BILL_VALIDATE','2022-08-24 22:28:36','2022-08-24 10:28:36',11,NULL,NULL,11756,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0320 validada','Autor: gdealba\nFactura FA2208-0320 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,336,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1604,1604,NULL,1,'2022-08-24 22:30:48','2022-08-24 22:30:48',40,'AC_BILL_VALIDATE','2022-08-24 22:30:48','2022-08-24 10:30:48',11,NULL,NULL,12190,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0321 validada','Autor: gdealba\nFactura FA2208-0321 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,337,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1605,1605,NULL,1,'2022-08-24 22:31:34','2022-08-24 22:31:34',40,'AC_BILL_VALIDATE','2022-08-24 22:31:34','2022-08-24 10:31:34',11,NULL,NULL,12227,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0322 validada','Autor: gdealba\nFactura FA2208-0322 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,338,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1606,1606,NULL,1,'2022-08-24 22:32:41','2022-08-24 22:32:41',40,'AC_BILL_VALIDATE','2022-08-24 22:32:41','2022-08-24 10:32:41',11,NULL,NULL,12300,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0323 validada','Autor: gdealba\nFactura FA2208-0323 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,339,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1607,1607,NULL,1,'2022-08-24 22:33:40','2022-08-24 22:33:40',40,'AC_BILL_VALIDATE','2022-08-24 22:33:40','2022-08-24 10:33:40',11,NULL,NULL,12453,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0324 validada','Autor: gdealba\nFactura FA2208-0324 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,340,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1608,1608,NULL,1,'2022-08-24 22:34:36','2022-08-24 22:34:36',40,'AC_BILL_VALIDATE','2022-08-24 22:34:36','2022-08-24 10:34:36',11,NULL,NULL,12460,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0325 validada','Autor: gdealba\nFactura FA2208-0325 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,341,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1609,1609,NULL,1,'2022-08-24 22:35:36','2022-08-24 22:35:36',40,'AC_BILL_VALIDATE','2022-08-24 22:35:36','2022-08-24 10:35:36',11,NULL,NULL,12485,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0326 validada','Autor: gdealba\nFactura FA2208-0326 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,342,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1610,1610,NULL,1,'2022-08-24 22:36:36','2022-08-24 22:36:36',40,'AC_BILL_VALIDATE','2022-08-24 22:36:36','2022-08-24 10:36:36',11,NULL,NULL,12518,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0327 validada','Autor: gdealba\nFactura FA2208-0327 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,343,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1611,1611,NULL,1,'2022-08-24 22:37:24','2022-08-24 22:37:24',40,'AC_BILL_VALIDATE','2022-08-24 22:37:24','2022-08-24 10:37:24',11,NULL,NULL,12624,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0328 validada','Autor: gdealba\nFactura FA2208-0328 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,344,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1612,1612,NULL,1,'2022-08-24 22:37:56','2022-08-24 22:37:56',40,'AC_BILL_VALIDATE','2022-08-24 22:37:56','2022-08-24 10:37:56',11,NULL,NULL,12963,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0329 validada','Autor: gdealba\nFactura FA2208-0329 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,345,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1613,1613,NULL,1,'2022-08-24 22:39:06','2022-08-24 22:39:06',40,'AC_BILL_VALIDATE','2022-08-24 22:39:06','2022-08-24 10:39:06',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0330 validada','Autor: gdealba\nFactura FA2208-0330 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,346,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1614,1614,NULL,1,'2022-08-24 22:40:16','2022-08-24 22:40:16',40,'AC_BILL_VALIDATE','2022-08-24 22:40:16','2022-08-24 10:40:16',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0331 validada','Autor: gdealba\nFactura FA2208-0331 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,347,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1615,1615,NULL,1,'2022-08-24 22:41:14','2022-08-24 22:41:14',40,'AC_BILL_VALIDATE','2022-08-24 22:41:14','2022-08-24 10:41:14',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0332 validada','Autor: gdealba\nFactura FA2208-0332 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,348,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1616,1616,NULL,1,'2022-08-24 22:42:02','2022-08-24 22:42:02',40,'AC_BILL_VALIDATE','2022-08-24 22:42:02','2022-08-24 10:42:02',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0333 validada','Autor: gdealba\nFactura FA2208-0333 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,349,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1617,1617,NULL,1,'2022-08-24 22:43:03','2022-08-24 22:43:03',40,'AC_BILL_VALIDATE','2022-08-24 22:43:03','2022-08-24 10:43:03',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0334 validada','Autor: gdealba\nFactura FA2208-0334 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,350,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1618,1618,NULL,1,'2022-08-24 22:44:02','2022-08-24 22:44:02',40,'AC_BILL_VALIDATE','2022-08-24 22:44:02','2022-08-24 10:44:02',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0335 validada','Autor: gdealba\nFactura FA2208-0335 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,351,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1619,1619,NULL,1,'2022-08-25 01:09:00','2022-08-25 01:09:00',40,'AC_BILL_VALIDATE','2022-08-25 01:09:00','2022-08-24 13:09:00',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0336 validada','Autor: egarcia\nFactura FA2208-0336 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,352,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1620,1620,NULL,1,'2022-08-25 02:22:40','2022-08-25 02:22:40',40,'AC_BILL_VALIDATE','2022-08-25 02:22:40','2022-08-24 14:22:40',11,NULL,NULL,11950,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0337 validada','Autor: gdealba\nFactura FA2208-0337 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,353,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1621,1621,NULL,1,'2022-08-25 02:23:52','2022-08-25 02:23:52',40,'AC_BILL_VALIDATE','2022-08-25 02:23:52','2022-08-24 14:23:52',11,NULL,NULL,12782,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0338 validada','Autor: gdealba\nFactura FA2208-0338 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,354,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1622,1622,NULL,1,'2022-08-25 02:24:22','2022-08-25 02:24:22',40,'AC_BILL_VALIDATE','2022-08-25 02:24:22','2022-08-24 14:24:22',11,NULL,NULL,14336,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0339 validada','Autor: gdealba\nFactura FA2208-0339 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,355,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1623,1623,NULL,1,'2022-08-25 02:27:10','2022-08-25 02:27:10',40,'AC_BILL_VALIDATE','2022-08-25 02:27:10','2022-08-24 14:27:10',11,NULL,NULL,11789,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0340 validada','Autor: gdealba\nFactura FA2208-0340 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,356,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1624,1624,NULL,1,'2022-08-25 02:28:19','2022-08-25 02:28:19',40,'AC_BILL_DELETE','2022-08-25 02:28:19','2022-08-24 14:28:19',11,NULL,NULL,12416,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura eliminada','Autor: gdealba\nFactura eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,357,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1625,1625,NULL,1,'2022-08-25 02:29:40','2022-08-25 02:29:40',40,'AC_BILL_VALIDATE','2022-08-25 02:29:40','2022-08-24 14:29:40',11,NULL,NULL,12416,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0341 validada','Autor: gdealba\nFactura FA2208-0341 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,358,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1626,1626,NULL,1,'2022-08-25 02:31:22','2022-08-25 02:31:22',40,'AC_BILL_VALIDATE','2022-08-25 02:31:22','2022-08-24 14:31:22',11,NULL,NULL,10921,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0342 validada','Autor: gdealba\nFactura FA2208-0342 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,359,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1627,1627,NULL,1,'2022-08-25 02:33:12','2022-08-25 02:33:12',40,'AC_BILL_VALIDATE','2022-08-25 02:33:12','2022-08-24 14:33:12',11,NULL,NULL,13849,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0343 validada','Autor: gdealba\nFactura FA2208-0343 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,360,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1628,1628,NULL,1,'2022-08-25 02:34:59','2022-08-25 02:34:59',40,'AC_BILL_VALIDATE','2022-08-25 02:34:59','2022-08-24 14:34:59',11,NULL,NULL,13864,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0344 validada','Autor: gdealba\nFactura FA2208-0344 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,361,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1629,1629,NULL,1,'2022-08-25 02:36:27','2022-08-25 02:36:27',40,'AC_BILL_VALIDATE','2022-08-25 02:36:27','2022-08-24 14:36:27',11,NULL,NULL,13886,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0345 validada','Autor: gdealba\nFactura FA2208-0345 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,362,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1630,1630,NULL,1,'2022-08-25 12:10:23','2022-08-25 12:10:23',40,'AC_BILL_VALIDATE','2022-08-25 12:10:23','2022-08-25 00:10:23',4,NULL,NULL,13746,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0346 validada','Autor: yrodriguez\nFactura FA2208-0346 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,363,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1631,1631,NULL,1,'2022-08-25 12:14:21','2022-08-25 12:14:21',40,'AC_BILL_UNVALIDATE','2022-08-25 12:14:21','2022-08-25 00:14:21',4,NULL,NULL,13746,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura FA2208-0346 al estado de borrador','Autor: yrodriguez\nRegresar factura FA2208-0346 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,363,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1632,1632,NULL,1,'2022-08-25 12:14:38','2022-08-25 12:14:38',40,'AC_BILL_VALIDATE','2022-08-25 12:14:38','2022-08-25 00:14:38',4,NULL,NULL,13746,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0346 validada','Autor: yrodriguez\nFactura FA2208-0346 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,363,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1633,1633,NULL,1,'2022-08-25 18:25:35','2022-08-25 18:25:35',40,'AC_PRODUCT_MODIFY','2022-08-25 18:25:35','2022-08-25 06:25:35',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPARROZ900G modificado','Autor: admin\nProducto BPARROZ900G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,282,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1634,1634,NULL,1,'2022-08-25 18:34:51','2022-08-25 18:34:51',40,'AC_PRODUCT_MODIFY','2022-08-25 18:34:51','2022-08-25 06:34:51',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR500G modificado','Autor: admin\nProducto BPGR500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,205,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1635,1635,NULL,1,'2022-08-25 18:35:36','2022-08-25 18:35:36',40,'AC_PRODUCT_MODIFY','2022-08-25 18:35:36','2022-08-25 06:35:36',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR100G modificado','Autor: admin\nProducto BPGR100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,279,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1636,1636,NULL,1,'2022-08-25 18:36:45','2022-08-25 18:36:45',40,'AC_PRODUCT_MODIFY','2022-08-25 18:36:45','2022-08-25 06:36:45',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPAVE500G modificado','Autor: admin\nProducto BPAVE500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,203,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1637,1637,NULL,1,'2022-08-25 18:37:16','2022-08-25 18:37:16',40,'AC_PRODUCT_MODIFY','2022-08-25 18:37:16','2022-08-25 06:37:16',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPOR200G modificado','Autor: admin\nProducto BPOR200G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,213,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1638,1638,NULL,1,'2022-08-25 18:38:08','2022-08-25 18:38:08',40,'AC_PRODUCT_MODIFY','2022-08-25 18:38:08','2022-08-25 06:38:08',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPAA350G modificado','Autor: admin\nProducto BPAA350G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,209,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1639,1639,NULL,1,'2022-08-25 18:40:14','2022-08-25 18:40:14',40,'AC_PRODUCT_MODIFY','2022-08-25 18:40:14','2022-08-25 06:40:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto PIZCA_DE_CHOCOLATE_Granel modificado','Autor: admin\nProducto PIZCA_DE_CHOCOLATE_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,199,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1640,1640,NULL,1,'2022-08-25 19:19:17','2022-08-25 19:19:17',40,'AC_BILL_VALIDATE','2022-08-25 19:19:17','2022-08-25 07:19:17',6,NULL,NULL,12420,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0347 validada','Autor: egarcia\nFactura FA2208-0347 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,364,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1641,1641,NULL,1,'2022-08-25 19:23:27','2022-08-25 19:23:27',40,'AC_BILL_VALIDATE','2022-08-25 19:23:27','2022-08-25 07:23:27',6,NULL,NULL,12420,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0348 validada','Autor: egarcia\nFactura FA2208-0348 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,365,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1642,1642,NULL,1,'2022-08-25 19:25:08','2022-08-25 19:25:08',40,'AC_BILL_VALIDATE','2022-08-25 19:25:08','2022-08-25 07:25:08',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0349 validada','Autor: egarcia\nFactura FA2208-0349 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,366,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1643,1643,NULL,1,'2022-08-25 19:44:14','2022-08-25 19:44:14',40,'AC_BILL_VALIDATE','2022-08-25 19:44:14','2022-08-25 07:44:14',6,NULL,NULL,13126,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0350 validada','Autor: egarcia\nFactura FA2208-0350 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,367,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1644,1644,NULL,1,'2022-08-25 20:43:07','2022-08-25 20:43:07',40,'AC_BILL_VALIDATE','2022-08-25 20:43:07','2022-08-25 08:43:07',11,NULL,NULL,13803,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0351 validada','Autor: gdealba\nFactura FA2208-0351 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,368,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1645,1645,NULL,1,'2022-08-25 21:25:17','2022-08-25 21:25:17',40,'AC_BILL_VALIDATE','2022-08-25 21:25:17','2022-08-25 09:25:17',11,NULL,NULL,10876,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0352 validada','Autor: gdealba\nFactura FA2208-0352 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,369,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1646,1646,NULL,1,'2022-08-25 23:59:18','2022-08-25 23:59:18',40,'AC_BILL_UNVALIDATE','2022-08-25 23:59:18','2022-08-25 11:59:18',11,NULL,NULL,13369,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura FA2208-0302 al estado de borrador','Autor: gdealba\nRegresar factura FA2208-0302 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,316,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1647,1647,NULL,1,'2022-08-25 23:59:34','2022-08-25 23:59:34',40,'AC_BILL_VALIDATE','2022-08-25 23:59:34','2022-08-25 11:59:34',11,NULL,NULL,13369,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0302 validada','Autor: gdealba\nFactura FA2208-0302 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,316,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1648,1648,NULL,1,'2022-08-26 00:27:06','2022-08-26 00:27:06',40,'AC_BILL_VALIDATE','2022-08-26 00:27:06','2022-08-25 12:27:06',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0353 validada','Autor: egarcia\nFactura FA2208-0353 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,370,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1649,1649,NULL,1,'2022-08-26 00:30:46','2022-08-26 00:30:46',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-26 00:30:46','2022-08-25 12:30:46',6,NULL,NULL,3,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0072 validada','Autor: egarcia\nFactura SI2208-0072 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,97,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1650,1650,NULL,1,'2022-08-26 13:27:21','2022-08-26 13:27:21',40,'AC_BILL_VALIDATE','2022-08-26 13:27:21','2022-08-26 01:27:21',11,NULL,NULL,12673,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0354 validada','Autor: gdealba\nFactura FA2208-0354 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,371,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1651,1651,NULL,1,'2022-08-26 13:30:52','2022-08-26 13:30:52',40,'AC_BILL_VALIDATE','2022-08-26 13:30:52','2022-08-26 01:30:52',11,NULL,NULL,13968,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0355 validada','Autor: gdealba\nFactura FA2208-0355 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,372,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1652,1652,NULL,1,'2022-08-26 13:33:03','2022-08-26 13:33:03',40,'AC_BILL_VALIDATE','2022-08-26 13:33:03','2022-08-26 01:33:03',11,NULL,NULL,13782,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0356 validada','Autor: gdealba\nFactura FA2208-0356 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,373,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1653,1653,NULL,1,'2022-08-26 13:34:25','2022-08-26 13:34:25',40,'AC_BILL_VALIDATE','2022-08-26 13:34:25','2022-08-26 01:34:25',11,NULL,NULL,13825,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0357 validada','Autor: gdealba\nFactura FA2208-0357 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,374,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1654,1654,NULL,1,'2022-08-26 13:35:33','2022-08-26 13:35:33',40,'AC_BILL_VALIDATE','2022-08-26 13:35:33','2022-08-26 01:35:33',11,NULL,NULL,10975,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0358 validada','Autor: gdealba\nFactura FA2208-0358 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,375,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1655,1655,NULL,1,'2022-08-26 13:40:00','2022-08-26 13:40:00',40,'AC_BILL_VALIDATE','2022-08-26 13:40:00','2022-08-26 01:40:00',11,NULL,NULL,10989,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0359 validada','Autor: gdealba\nFactura FA2208-0359 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,376,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1656,1656,NULL,1,'2022-08-26 13:40:47','2022-08-26 13:40:47',40,'AC_BILL_VALIDATE','2022-08-26 13:40:47','2022-08-26 01:40:47',11,NULL,NULL,10990,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0360 validada','Autor: gdealba\nFactura FA2208-0360 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,377,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1657,1657,NULL,1,'2022-08-26 13:42:03','2022-08-26 13:42:03',40,'AC_BILL_VALIDATE','2022-08-26 13:42:03','2022-08-26 01:42:03',11,NULL,NULL,10991,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0361 validada','Autor: gdealba\nFactura FA2208-0361 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,378,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1658,1658,NULL,1,'2022-08-26 13:43:23','2022-08-26 13:43:23',40,'AC_BILL_VALIDATE','2022-08-26 13:43:23','2022-08-26 01:43:23',11,NULL,NULL,11130,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0362 validada','Autor: gdealba\nFactura FA2208-0362 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,379,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1659,1659,NULL,1,'2022-08-26 13:45:21','2022-08-26 13:45:21',40,'AC_BILL_VALIDATE','2022-08-26 13:45:21','2022-08-26 01:45:21',11,NULL,NULL,11131,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0363 validada','Autor: gdealba\nFactura FA2208-0363 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,380,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1660,1660,NULL,1,'2022-08-26 13:46:19','2022-08-26 13:46:19',40,'AC_BILL_VALIDATE','2022-08-26 13:46:19','2022-08-26 01:46:19',11,NULL,NULL,11132,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0364 validada','Autor: gdealba\nFactura FA2208-0364 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,381,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1661,1661,NULL,1,'2022-08-26 13:47:30','2022-08-26 13:47:30',40,'AC_BILL_VALIDATE','2022-08-26 13:47:30','2022-08-26 01:47:30',11,NULL,NULL,11590,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0365 validada','Autor: gdealba\nFactura FA2208-0365 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,382,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1662,1662,NULL,1,'2022-08-26 13:48:51','2022-08-26 13:48:51',40,'AC_BILL_VALIDATE','2022-08-26 13:48:51','2022-08-26 01:48:51',11,NULL,NULL,12092,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0366 validada','Autor: gdealba\nFactura FA2208-0366 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,383,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1663,1663,NULL,1,'2022-08-26 13:50:18','2022-08-26 13:50:18',40,'AC_BILL_VALIDATE','2022-08-26 13:50:18','2022-08-26 01:50:18',11,NULL,NULL,12260,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0367 validada','Autor: gdealba\nFactura FA2208-0367 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,384,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1664,1664,NULL,1,'2022-08-26 13:52:28','2022-08-26 13:52:28',40,'AC_BILL_VALIDATE','2022-08-26 13:52:28','2022-08-26 01:52:28',11,NULL,NULL,12345,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0368 validada','Autor: gdealba\nFactura FA2208-0368 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,385,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1665,1665,NULL,1,'2022-08-26 13:54:26','2022-08-26 13:54:26',40,'AC_BILL_VALIDATE','2022-08-26 13:54:26','2022-08-26 01:54:26',11,NULL,NULL,12388,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0369 validada','Autor: gdealba\nFactura FA2208-0369 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,386,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1666,1666,NULL,1,'2022-08-26 13:58:26','2022-08-26 13:58:26',40,'AC_BILL_VALIDATE','2022-08-26 13:58:26','2022-08-26 01:58:26',11,NULL,NULL,12587,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0370 validada','Autor: gdealba\nFactura FA2208-0370 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,387,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1667,1667,NULL,1,'2022-08-26 14:00:49','2022-08-26 14:00:49',40,'AC_BILL_VALIDATE','2022-08-26 14:00:49','2022-08-26 02:00:49',11,NULL,NULL,12691,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0371 validada','Autor: gdealba\nFactura FA2208-0371 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,388,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1668,1668,NULL,1,'2022-08-26 14:02:03','2022-08-26 14:02:03',40,'AC_BILL_VALIDATE','2022-08-26 14:02:03','2022-08-26 02:02:03',11,NULL,NULL,12731,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0372 validada','Autor: gdealba\nFactura FA2208-0372 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,389,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1669,1669,NULL,1,'2022-08-26 14:03:55','2022-08-26 14:03:55',40,'AC_BILL_VALIDATE','2022-08-26 14:03:55','2022-08-26 02:03:55',11,NULL,NULL,12883,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0373 validada','Autor: gdealba\nFactura FA2208-0373 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,390,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1670,1670,NULL,1,'2022-08-26 14:05:46','2022-08-26 14:05:46',40,'AC_BILL_VALIDATE','2022-08-26 14:05:46','2022-08-26 02:05:46',11,NULL,NULL,13145,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0374 validada','Autor: gdealba\nFactura FA2208-0374 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,391,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1671,1671,NULL,1,'2022-08-26 14:08:05','2022-08-26 14:08:05',40,'AC_BILL_VALIDATE','2022-08-26 14:08:05','2022-08-26 02:08:05',11,NULL,NULL,13556,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0375 validada','Autor: gdealba\nFactura FA2208-0375 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,393,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1672,1672,NULL,1,'2022-08-26 14:09:07','2022-08-26 14:09:07',40,'AC_BILL_VALIDATE','2022-08-26 14:09:07','2022-08-26 02:09:07',11,NULL,NULL,13557,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0376 validada','Autor: gdealba\nFactura FA2208-0376 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,394,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1673,1673,NULL,1,'2022-08-26 14:13:48','2022-08-26 14:13:48',40,'AC_BILL_VALIDATE','2022-08-26 14:13:48','2022-08-26 02:13:48',11,NULL,NULL,14100,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0377 validada','Autor: gdealba\nFactura FA2208-0377 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,395,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1674,1674,NULL,1,'2022-08-26 14:16:16','2022-08-26 14:16:16',40,'AC_BILL_VALIDATE','2022-08-26 14:16:16','2022-08-26 02:16:16',11,NULL,NULL,13778,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0378 validada','Autor: gdealba\nFactura FA2208-0378 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,396,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1675,1675,NULL,1,'2022-08-26 14:17:39','2022-08-26 14:17:39',40,'AC_BILL_VALIDATE','2022-08-26 14:17:39','2022-08-26 02:17:39',11,NULL,NULL,13784,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0379 validada','Autor: gdealba\nFactura FA2208-0379 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,397,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1676,1676,NULL,1,'2022-08-26 14:21:52','2022-08-26 14:21:52',40,'AC_BILL_VALIDATE','2022-08-26 14:21:52','2022-08-26 02:21:52',11,NULL,NULL,10825,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0380 validada','Autor: gdealba\nFactura FA2208-0380 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,398,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1677,1677,NULL,1,'2022-08-26 14:23:13','2022-08-26 14:23:13',40,'AC_BILL_VALIDATE','2022-08-26 14:23:13','2022-08-26 02:23:13',11,NULL,NULL,13412,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0381 validada','Autor: gdealba\nFactura FA2208-0381 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,399,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1678,1678,NULL,1,'2022-08-26 14:29:31','2022-08-26 14:29:31',40,'AC_COMPANY_CREATE','2022-08-26 14:29:31','2022-08-26 02:29:31',11,NULL,NULL,14364,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Tercero PUBLICO EN GENERAL R61 creado','Autor: gdealba\nTercero PUBLICO EN GENERAL R61 creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1679,1679,NULL,1,'2022-08-26 14:30:03','2022-08-26 14:30:03',40,'AC_COMPANY_CREATE','2022-08-26 14:30:03','2022-08-26 02:30:03',11,NULL,NULL,14365,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Tercero PUBLICO EN GENERAL R62 creado','Autor: gdealba\nTercero PUBLICO EN GENERAL R62 creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1680,1680,NULL,1,'2022-08-26 14:36:48','2022-08-26 14:36:48',40,'AC_BILL_VALIDATE','2022-08-26 14:36:48','2022-08-26 02:36:48',11,NULL,NULL,10998,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0382 validada','Autor: gdealba\nFactura FA2208-0382 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,400,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1681,1681,NULL,1,'2022-08-26 14:40:41','2022-08-26 14:40:41',40,'AC_BILL_VALIDATE','2022-08-26 14:40:41','2022-08-26 02:40:41',11,NULL,NULL,11001,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0383 validada','Autor: gdealba\nFactura FA2208-0383 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,401,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1682,1682,NULL,1,'2022-08-26 14:41:41','2022-08-26 14:41:41',40,'AC_BILL_VALIDATE','2022-08-26 14:41:41','2022-08-26 02:41:41',11,NULL,NULL,11002,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0384 validada','Autor: gdealba\nFactura FA2208-0384 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,402,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1683,1683,NULL,1,'2022-08-26 14:43:38','2022-08-26 14:43:38',40,'AC_BILL_VALIDATE','2022-08-26 14:43:38','2022-08-26 02:43:38',11,NULL,NULL,11139,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0385 validada','Autor: gdealba\nFactura FA2208-0385 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,403,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1684,1684,NULL,1,'2022-08-26 14:44:42','2022-08-26 14:44:42',40,'AC_BILL_VALIDATE','2022-08-26 14:44:42','2022-08-26 02:44:42',11,NULL,NULL,12104,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0386 validada','Autor: gdealba\nFactura FA2208-0386 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,404,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1685,1685,NULL,1,'2022-08-26 14:45:40','2022-08-26 14:45:40',40,'AC_BILL_VALIDATE','2022-08-26 14:45:40','2022-08-26 02:45:40',11,NULL,NULL,12288,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0387 validada','Autor: gdealba\nFactura FA2208-0387 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,405,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1686,1686,NULL,1,'2022-08-26 14:49:06','2022-08-26 14:49:06',40,'AC_BILL_VALIDATE','2022-08-26 14:49:06','2022-08-26 02:49:06',11,NULL,NULL,13033,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0388 validada','Autor: gdealba\nFactura FA2208-0388 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,406,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1687,1687,NULL,1,'2022-08-26 14:50:43','2022-08-26 14:50:43',40,'AC_BILL_VALIDATE','2022-08-26 14:50:43','2022-08-26 02:50:43',11,NULL,NULL,13611,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0389 validada','Autor: gdealba\nFactura FA2208-0389 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,407,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1688,1688,NULL,1,'2022-08-26 14:53:01','2022-08-26 14:53:01',40,'AC_BILL_VALIDATE','2022-08-26 14:53:01','2022-08-26 02:53:01',11,NULL,NULL,13612,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0390 validada','Autor: gdealba\nFactura FA2208-0390 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,408,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1689,1689,NULL,1,'2022-08-26 14:54:03','2022-08-26 14:54:03',40,'AC_BILL_VALIDATE','2022-08-26 14:54:03','2022-08-26 02:54:03',11,NULL,NULL,13613,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0391 validada','Autor: gdealba\nFactura FA2208-0391 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,409,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1690,1690,NULL,1,'2022-08-26 14:55:20','2022-08-26 14:55:20',40,'AC_BILL_VALIDATE','2022-08-26 14:55:20','2022-08-26 02:55:20',11,NULL,NULL,13700,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0392 validada','Autor: gdealba\nFactura FA2208-0392 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,410,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1691,1691,NULL,1,'2022-08-26 14:57:53','2022-08-26 14:57:53',40,'AC_COMPANY_CREATE','2022-08-26 14:57:53','2022-08-26 02:57:53',11,NULL,NULL,14366,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Tercero PUBLICO GENERAL R66 creado','Autor: gdealba\nTercero PUBLICO GENERAL R66 creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1692,1692,NULL,1,'2022-08-26 15:01:50','2022-08-26 15:01:50',40,'AC_BILL_DELETE','2022-08-26 15:01:50','2022-08-26 03:01:50',11,NULL,NULL,14366,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura eliminada','Autor: gdealba\nFactura eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,412,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1693,1693,NULL,1,'2022-08-26 15:03:18','2022-08-26 15:03:18',40,'AC_BILL_DELETE','2022-08-26 15:03:18','2022-08-26 03:03:18',11,NULL,NULL,14364,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura eliminada','Autor: gdealba\nFactura eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,413,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1694,1694,NULL,1,'2022-08-26 15:06:18','2022-08-26 15:06:18',40,'AC_COMPANY_MODIFY','2022-08-26 15:06:18','2022-08-26 03:06:18',11,NULL,NULL,14364,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Tercero PUBLICO EN GENERAL R61 modificado','Autor: gdealba\nTercero PUBLICO EN GENERAL R61 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1695,1695,NULL,1,'2022-08-26 15:07:08','2022-08-26 15:07:08',40,'AC_COMPANY_MODIFY','2022-08-26 15:07:08','2022-08-26 03:07:08',11,NULL,NULL,14364,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Tercero PUBLICO EN GENERAL R61 modificado','Autor: gdealba\nTercero PUBLICO EN GENERAL R61 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1696,1696,NULL,1,'2022-08-26 15:09:42','2022-08-26 15:09:42',40,'AC_BILL_DELETE','2022-08-26 15:09:42','2022-08-26 03:09:42',11,NULL,NULL,14364,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura eliminada','Autor: gdealba\nFactura eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,414,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1697,1697,NULL,1,'2022-08-26 15:13:40','2022-08-26 15:13:40',40,'AC_BILL_VALIDATE','2022-08-26 15:13:40','2022-08-26 03:13:40',11,NULL,NULL,14366,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0393 validada','Autor: gdealba\nFactura FA2208-0393 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,415,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1698,1698,NULL,1,'2022-08-26 15:15:09','2022-08-26 15:15:09',40,'AC_BILL_VALIDATE','2022-08-26 15:15:09','2022-08-26 03:15:09',11,NULL,NULL,14366,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0394 validada','Autor: gdealba\nFactura FA2208-0394 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,416,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1699,1699,NULL,1,'2022-08-26 15:16:21','2022-08-26 15:16:21',40,'AC_BILL_VALIDATE','2022-08-26 15:16:21','2022-08-26 03:16:21',11,NULL,NULL,14366,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0395 validada','Autor: gdealba\nFactura FA2208-0395 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,417,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1700,1700,NULL,1,'2022-08-26 15:17:16','2022-08-26 15:17:16',40,'AC_BILL_VALIDATE','2022-08-26 15:17:16','2022-08-26 03:17:16',11,NULL,NULL,14366,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0396 validada','Autor: gdealba\nFactura FA2208-0396 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,418,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1701,1701,NULL,1,'2022-08-26 15:24:26','2022-08-26 15:24:26',40,'AC_BILL_VALIDATE','2022-08-26 15:24:26','2022-08-26 03:24:26',11,NULL,NULL,10879,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0397 validada','Autor: gdealba\nFactura FA2208-0397 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,419,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1702,1702,NULL,1,'2022-08-26 15:25:40','2022-08-26 15:25:40',40,'AC_BILL_VALIDATE','2022-08-26 15:25:40','2022-08-26 03:25:40',11,NULL,NULL,10879,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0398 validada','Autor: gdealba\nFactura FA2208-0398 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,420,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1703,1703,NULL,1,'2022-08-26 15:26:30','2022-08-26 15:26:30',40,'AC_BILL_VALIDATE','2022-08-26 15:26:30','2022-08-26 03:26:30',11,NULL,NULL,10872,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0399 validada','Autor: gdealba\nFactura FA2208-0399 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,421,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1704,1704,NULL,1,'2022-08-26 15:29:41','2022-08-26 15:29:41',40,'AC_BILL_VALIDATE','2022-08-26 15:29:41','2022-08-26 03:29:41',11,NULL,NULL,13958,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0400 validada','Autor: gdealba\nFactura FA2208-0400 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,422,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1705,1705,NULL,1,'2022-08-26 15:31:58','2022-08-26 15:31:58',40,'AC_BILL_VALIDATE','2022-08-26 15:31:58','2022-08-26 03:31:58',11,NULL,NULL,13943,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0401 validada','Autor: gdealba\nFactura FA2208-0401 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,423,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1706,1706,NULL,1,'2022-08-26 15:33:32','2022-08-26 15:33:32',40,'AC_BILL_VALIDATE','2022-08-26 15:33:32','2022-08-26 03:33:32',11,NULL,NULL,13853,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0402 validada','Autor: gdealba\nFactura FA2208-0402 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,424,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1707,1707,NULL,1,'2022-08-26 15:34:40','2022-08-26 15:34:40',40,'AC_BILL_VALIDATE','2022-08-26 15:34:40','2022-08-26 03:34:40',11,NULL,NULL,14053,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0403 validada','Autor: gdealba\nFactura FA2208-0403 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,425,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1708,1708,NULL,1,'2022-08-26 15:35:39','2022-08-26 15:35:39',40,'AC_BILL_VALIDATE','2022-08-26 15:35:39','2022-08-26 03:35:39',11,NULL,NULL,13883,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0404 validada','Autor: gdealba\nFactura FA2208-0404 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,426,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1709,1709,NULL,1,'2022-08-26 15:36:42','2022-08-26 15:36:42',40,'AC_BILL_VALIDATE','2022-08-26 15:36:42','2022-08-26 03:36:42',4,NULL,NULL,13746,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0405 validada','Autor: yrodriguez\nFactura FA2208-0405 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,427,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1710,1710,NULL,1,'2022-08-26 15:36:57','2022-08-26 15:36:57',40,'AC_BILL_VALIDATE','2022-08-26 15:36:57','2022-08-26 03:36:57',11,NULL,NULL,13862,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0406 validada','Autor: gdealba\nFactura FA2208-0406 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,428,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1711,1711,NULL,1,'2022-08-26 15:38:45','2022-08-26 15:38:45',40,'AC_BILL_VALIDATE','2022-08-26 15:38:45','2022-08-26 03:38:45',11,NULL,NULL,13884,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0407 validada','Autor: gdealba\nFactura FA2208-0407 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,429,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1712,1712,NULL,1,'2022-08-26 15:40:29','2022-08-26 15:40:29',40,'AC_BILL_VALIDATE','2022-08-26 15:40:29','2022-08-26 03:40:29',11,NULL,NULL,13852,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0408 validada','Autor: gdealba\nFactura FA2208-0408 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,430,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1713,1713,NULL,1,'2022-08-26 15:41:17','2022-08-26 15:41:17',40,'AC_BILL_VALIDATE','2022-08-26 15:41:17','2022-08-26 03:41:17',11,NULL,NULL,13896,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0409 validada','Autor: gdealba\nFactura FA2208-0409 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,431,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1714,1714,NULL,1,'2022-08-26 15:45:29','2022-08-26 15:45:29',40,'AC_BILL_VALIDATE','2022-08-26 15:45:29','2022-08-26 03:45:29',11,NULL,NULL,10885,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0410 validada','Autor: gdealba\nFactura FA2208-0410 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,432,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1715,1715,NULL,1,'2022-08-26 15:46:32','2022-08-26 15:46:32',40,'AC_BILL_VALIDATE','2022-08-26 15:46:32','2022-08-26 03:46:32',11,NULL,NULL,11068,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0411 validada','Autor: gdealba\nFactura FA2208-0411 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,433,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1716,1716,NULL,1,'2022-08-26 15:47:29','2022-08-26 15:47:29',40,'AC_BILL_VALIDATE','2022-08-26 15:47:29','2022-08-26 03:47:29',11,NULL,NULL,11927,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0412 validada','Autor: gdealba\nFactura FA2208-0412 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,434,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1717,1717,NULL,1,'2022-08-26 15:49:31','2022-08-26 15:49:31',40,'AC_BILL_VALIDATE','2022-08-26 15:49:31','2022-08-26 03:49:31',11,NULL,NULL,14365,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0413 validada','Autor: gdealba\nFactura FA2208-0413 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,435,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1718,1718,NULL,1,'2022-08-26 15:50:30','2022-08-26 15:50:30',40,'AC_BILL_UNVALIDATE','2022-08-26 15:50:30','2022-08-26 03:50:30',11,NULL,NULL,14365,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura FA2208-0413 al estado de borrador','Autor: gdealba\nRegresar factura FA2208-0413 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,435,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1719,1719,NULL,1,'2022-08-26 15:51:13','2022-08-26 15:51:13',40,'AC_BILL_VALIDATE','2022-08-26 15:51:13','2022-08-26 03:51:13',11,NULL,NULL,14365,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0413 validada','Autor: gdealba\nFactura FA2208-0413 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,435,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1720,1720,NULL,1,'2022-08-26 15:53:49','2022-08-26 15:53:49',40,'AC_BILL_VALIDATE','2022-08-26 15:53:49','2022-08-26 03:53:49',11,NULL,NULL,13495,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0414 validada','Autor: gdealba\nFactura FA2208-0414 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,436,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1721,1721,NULL,1,'2022-08-26 16:21:55','2022-08-26 16:21:55',40,'AC_BILL_VALIDATE','2022-08-26 16:21:55','2022-08-26 04:21:55',11,NULL,NULL,13785,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0415 validada','Autor: gdealba\nFactura FA2208-0415 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,437,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1722,1722,NULL,1,'2022-08-26 16:26:14','2022-08-26 16:26:14',40,'AC_BILL_VALIDATE','2022-08-26 16:26:14','2022-08-26 04:26:14',11,NULL,NULL,14174,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0416 validada','Autor: gdealba\nFactura FA2208-0416 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,438,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1723,1723,NULL,1,'2022-08-26 16:32:35','2022-08-26 16:32:35',40,'AC_BILL_VALIDATE','2022-08-26 16:32:35','2022-08-26 04:32:35',11,NULL,NULL,14163,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0417 validada','Autor: gdealba\nFactura FA2208-0417 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,439,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1724,1724,NULL,1,'2022-08-26 16:34:13','2022-08-26 16:34:13',40,'AC_BILL_VALIDATE','2022-08-26 16:34:13','2022-08-26 04:34:13',11,NULL,NULL,10894,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0418 validada','Autor: gdealba\nFactura FA2208-0418 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,440,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1725,1725,NULL,1,'2022-08-26 16:36:09','2022-08-26 16:36:09',40,'AC_BILL_VALIDATE','2022-08-26 16:36:09','2022-08-26 04:36:09',11,NULL,NULL,10897,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0419 validada','Autor: gdealba\nFactura FA2208-0419 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,441,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1726,1726,NULL,1,'2022-08-26 16:37:17','2022-08-26 16:37:17',40,'AC_BILL_VALIDATE','2022-08-26 16:37:17','2022-08-26 04:37:17',11,NULL,NULL,10898,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0420 validada','Autor: gdealba\nFactura FA2208-0420 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,442,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1727,1727,NULL,1,'2022-08-26 16:38:32','2022-08-26 16:38:32',40,'AC_BILL_VALIDATE','2022-08-26 16:38:32','2022-08-26 04:38:32',11,NULL,NULL,10900,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0421 validada','Autor: gdealba\nFactura FA2208-0421 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,443,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1728,1728,NULL,1,'2022-08-26 16:41:56','2022-08-26 16:41:56',40,'AC_BILL_VALIDATE','2022-08-26 16:41:56','2022-08-26 04:41:56',11,NULL,NULL,10930,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0422 validada','Autor: gdealba\nFactura FA2208-0422 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,444,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1729,1729,NULL,1,'2022-08-26 16:46:58','2022-08-26 16:46:58',40,'AC_BILL_VALIDATE','2022-08-26 16:46:58','2022-08-26 04:46:58',11,NULL,NULL,11392,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0423 validada','Autor: gdealba\nFactura FA2208-0423 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,445,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1730,1730,NULL,1,'2022-08-26 16:49:16','2022-08-26 16:49:16',40,'AC_BILL_VALIDATE','2022-08-26 16:49:16','2022-08-26 04:49:16',11,NULL,NULL,11753,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0424 validada','Autor: gdealba\nFactura FA2208-0424 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,446,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1731,1731,NULL,1,'2022-08-26 16:52:08','2022-08-26 16:52:08',40,'AC_BILL_VALIDATE','2022-08-26 16:52:08','2022-08-26 04:52:08',11,NULL,NULL,12026,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0425 validada','Autor: gdealba\nFactura FA2208-0425 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,447,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1732,1732,NULL,1,'2022-08-26 16:59:34','2022-08-26 16:59:34',40,'AC_BILL_VALIDATE','2022-08-26 16:59:34','2022-08-26 04:59:34',11,NULL,NULL,14088,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0426 validada','Autor: gdealba\nFactura FA2208-0426 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,448,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1733,1733,NULL,1,'2022-08-26 17:04:01','2022-08-26 17:04:01',40,'AC_BILL_VALIDATE','2022-08-26 17:04:01','2022-08-26 05:04:01',11,NULL,NULL,14006,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0427 validada','Autor: gdealba\nFactura FA2208-0427 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,449,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1734,1734,NULL,1,'2022-08-26 17:05:48','2022-08-26 17:05:48',40,'AC_BILL_VALIDATE','2022-08-26 17:05:48','2022-08-26 05:05:48',11,NULL,NULL,13804,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0428 validada','Autor: gdealba\nFactura FA2208-0428 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,450,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1735,1735,NULL,1,'2022-08-26 17:08:07','2022-08-26 17:08:07',40,'AC_BILL_VALIDATE','2022-08-26 17:08:07','2022-08-26 05:08:07',11,NULL,NULL,10791,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0429 validada','Autor: gdealba\nFactura FA2208-0429 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,451,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1736,1736,NULL,1,'2022-08-26 17:09:38','2022-08-26 17:09:38',40,'AC_BILL_VALIDATE','2022-08-26 17:09:38','2022-08-26 05:09:38',11,NULL,NULL,10792,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0430 validada','Autor: gdealba\nFactura FA2208-0430 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,452,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1737,1737,NULL,1,'2022-08-26 17:10:49','2022-08-26 17:10:49',40,'AC_BILL_VALIDATE','2022-08-26 17:10:49','2022-08-26 05:10:49',11,NULL,NULL,10813,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0431 validada','Autor: gdealba\nFactura FA2208-0431 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,453,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1738,1738,NULL,1,'2022-08-26 17:12:20','2022-08-26 17:12:20',40,'AC_BILL_VALIDATE','2022-08-26 17:12:20','2022-08-26 05:12:20',11,NULL,NULL,10910,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0432 validada','Autor: gdealba\nFactura FA2208-0432 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,454,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1739,1739,NULL,1,'2022-08-26 17:13:20','2022-08-26 17:13:20',40,'AC_BILL_VALIDATE','2022-08-26 17:13:20','2022-08-26 05:13:20',11,NULL,NULL,10911,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0433 validada','Autor: gdealba\nFactura FA2208-0433 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,455,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1740,1740,NULL,1,'2022-08-26 17:14:39','2022-08-26 17:14:39',40,'AC_BILL_VALIDATE','2022-08-26 17:14:39','2022-08-26 05:14:39',11,NULL,NULL,10919,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0434 validada','Autor: gdealba\nFactura FA2208-0434 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,456,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1741,1741,NULL,1,'2022-08-26 17:15:13','2022-08-26 17:15:13',40,'AC_BILL_VALIDATE','2022-08-26 17:15:13','2022-08-26 05:15:13',11,NULL,NULL,11047,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0435 validada','Autor: gdealba\nFactura FA2208-0435 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,457,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1742,1742,NULL,1,'2022-08-26 17:17:38','2022-08-26 17:17:38',40,'AC_BILL_VALIDATE','2022-08-26 17:17:38','2022-08-26 05:17:38',11,NULL,NULL,11048,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0436 validada','Autor: gdealba\nFactura FA2208-0436 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,458,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1743,1743,NULL,1,'2022-08-26 17:19:37','2022-08-26 17:19:37',40,'AC_BILL_VALIDATE','2022-08-26 17:19:37','2022-08-26 05:19:37',11,NULL,NULL,11725,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0437 validada','Autor: gdealba\nFactura FA2208-0437 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,459,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1744,1744,NULL,1,'2022-08-26 17:20:43','2022-08-26 17:20:43',40,'AC_BILL_VALIDATE','2022-08-26 17:20:43','2022-08-26 05:20:43',11,NULL,NULL,11726,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0438 validada','Autor: gdealba\nFactura FA2208-0438 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,460,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1745,1745,NULL,1,'2022-08-26 17:22:03','2022-08-26 17:22:03',40,'AC_BILL_VALIDATE','2022-08-26 17:22:03','2022-08-26 05:22:03',11,NULL,NULL,12038,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0439 validada','Autor: gdealba\nFactura FA2208-0439 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,461,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1746,1746,NULL,1,'2022-08-26 17:23:11','2022-08-26 17:23:11',40,'AC_BILL_VALIDATE','2022-08-26 17:23:11','2022-08-26 05:23:11',11,NULL,NULL,12319,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0440 validada','Autor: gdealba\nFactura FA2208-0440 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,462,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1747,1747,NULL,1,'2022-08-26 17:24:47','2022-08-26 17:24:47',40,'AC_BILL_VALIDATE','2022-08-26 17:24:47','2022-08-26 05:24:47',11,NULL,NULL,12432,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0441 validada','Autor: gdealba\nFactura FA2208-0441 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,463,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1748,1748,NULL,1,'2022-08-26 17:25:55','2022-08-26 17:25:55',40,'AC_BILL_VALIDATE','2022-08-26 17:25:55','2022-08-26 05:25:55',11,NULL,NULL,13640,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0442 validada','Autor: gdealba\nFactura FA2208-0442 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,464,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1749,1749,NULL,1,'2022-08-26 17:37:03','2022-08-26 17:37:03',40,'AC_COMPANY_CREATE','2022-08-26 17:37:03','2022-08-26 05:37:03',11,NULL,NULL,14367,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Tercero PUBLICO EN GENERAL R63 creado','Autor: gdealba\nTercero PUBLICO EN GENERAL R63 creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1750,1750,NULL,1,'2022-08-26 17:39:45','2022-08-26 17:39:45',40,'AC_BILL_VALIDATE','2022-08-26 17:39:45','2022-08-26 05:39:45',11,NULL,NULL,14367,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0443 validada','Autor: gdealba\nFactura FA2208-0443 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,465,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1751,1751,NULL,1,'2022-08-26 17:43:49','2022-08-26 17:43:49',40,'AC_BILL_DELETE','2022-08-26 17:43:49','2022-08-26 05:43:49',11,NULL,NULL,13803,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura eliminada','Autor: gdealba\nFactura eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,466,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1752,1752,NULL,1,'2022-08-26 17:47:58','2022-08-26 17:47:58',40,'AC_BILL_VALIDATE','2022-08-26 17:47:58','2022-08-26 05:47:58',11,NULL,NULL,10776,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0444 validada','Autor: gdealba\nFactura FA2208-0444 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,467,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1753,1753,NULL,1,'2022-08-26 17:50:21','2022-08-26 17:50:21',40,'AC_BILL_VALIDATE','2022-08-26 17:50:21','2022-08-26 05:50:21',11,NULL,NULL,10777,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0445 validada','Autor: gdealba\nFactura FA2208-0445 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,468,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1754,1754,NULL,1,'2022-08-26 17:51:44','2022-08-26 17:51:44',40,'AC_BILL_VALIDATE','2022-08-26 17:51:44','2022-08-26 05:51:44',11,NULL,NULL,10778,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0446 validada','Autor: gdealba\nFactura FA2208-0446 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,469,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1755,1755,NULL,1,'2022-08-26 17:54:07','2022-08-26 17:54:07',40,'AC_BILL_VALIDATE','2022-08-26 17:54:07','2022-08-26 05:54:07',11,NULL,NULL,10831,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0447 validada','Autor: gdealba\nFactura FA2208-0447 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,470,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1756,1756,NULL,1,'2022-08-26 17:55:35','2022-08-26 17:55:35',40,'AC_BILL_VALIDATE','2022-08-26 17:55:35','2022-08-26 05:55:35',11,NULL,NULL,10834,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0448 validada','Autor: gdealba\nFactura FA2208-0448 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,471,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1757,1757,NULL,1,'2022-08-26 17:57:49','2022-08-26 17:57:49',40,'AC_BILL_VALIDATE','2022-08-26 17:57:49','2022-08-26 05:57:49',11,NULL,NULL,11596,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0449 validada','Autor: gdealba\nFactura FA2208-0449 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,472,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1758,1758,NULL,1,'2022-08-26 17:59:29','2022-08-26 17:59:29',40,'AC_BILL_VALIDATE','2022-08-26 17:59:29','2022-08-26 05:59:29',11,NULL,NULL,12625,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0450 validada','Autor: gdealba\nFactura FA2208-0450 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,473,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1759,1759,NULL,1,'2022-08-26 18:00:32','2022-08-26 18:00:32',40,'AC_BILL_VALIDATE','2022-08-26 18:00:32','2022-08-26 06:00:32',11,NULL,NULL,12663,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0451 validada','Autor: gdealba\nFactura FA2208-0451 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,474,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1760,1760,NULL,1,'2022-08-26 18:02:28','2022-08-26 18:02:28',40,'AC_BILL_VALIDATE','2022-08-26 18:02:28','2022-08-26 06:02:28',11,NULL,NULL,13508,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0452 validada','Autor: gdealba\nFactura FA2208-0452 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,475,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1761,1761,NULL,1,'2022-08-27 14:15:32','2022-08-27 14:15:32',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-27 14:15:32','2022-08-27 02:15:32',6,NULL,NULL,3,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0073 validada','Autor: egarcia\nFactura SI2208-0073 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,98,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1762,1762,NULL,1,'2022-08-27 14:40:34','2022-08-27 14:40:34',40,'AC_BILL_VALIDATE','2022-08-27 14:40:34','2022-08-27 02:40:34',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0453 validada','Autor: egarcia\nFactura FA2208-0453 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,476,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1763,1763,NULL,1,'2022-08-27 14:42:54','2022-08-27 14:42:54',40,'AC_BILL_VALIDATE','2022-08-27 14:42:54','2022-08-27 02:42:54',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0454 validada','Autor: egarcia\nFactura FA2208-0454 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,477,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1764,1764,NULL,1,'2022-08-27 15:38:45','2022-08-27 15:38:45',40,'AC_BILL_SUPPLIER_DELETE','2022-08-27 15:38:45','2022-08-27 03:38:45',6,NULL,NULL,1,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura de proveedor eliminada','Autor: egarcia\nFactura de proveedor eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,99,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1765,1765,NULL,1,'2022-08-27 15:41:02','2022-08-27 15:41:02',40,'AC_BILL_VALIDATE','2022-08-27 15:41:02','2022-08-27 03:41:02',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0455 validada','Autor: egarcia\nFactura FA2208-0455 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,478,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1766,1766,NULL,1,'2022-08-27 15:44:12','2022-08-27 15:44:12',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-27 15:44:12','2022-08-27 03:44:12',6,NULL,NULL,3,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0074 validada','Autor: egarcia\nFactura SI2208-0074 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,100,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1767,1767,NULL,1,'2022-08-27 18:02:12','2022-08-27 18:02:12',40,'AC_BILL_VALIDATE','2022-08-27 18:02:12','2022-08-27 06:02:12',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0456 validada','Autor: egarcia\nFactura FA2208-0456 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,479,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1768,1768,NULL,1,'2022-08-27 18:03:43','2022-08-27 18:03:43',40,'AC_BILL_VALIDATE','2022-08-27 18:03:43','2022-08-27 06:03:43',6,NULL,NULL,12959,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0457 validada','Autor: egarcia\nFactura FA2208-0457 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,480,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1769,1769,NULL,1,'2022-08-27 18:42:08','2022-08-27 18:42:08',40,'AC_BILL_VALIDATE','2022-08-27 18:42:08','2022-08-27 06:42:08',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0458 validada','Autor: egarcia\nFactura FA2208-0458 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,481,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1770,1770,NULL,1,'2022-08-27 18:43:20','2022-08-27 18:43:20',40,'AC_BILL_VALIDATE','2022-08-27 18:43:20','2022-08-27 06:43:20',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0459 validada','Autor: egarcia\nFactura FA2208-0459 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,482,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1771,1771,NULL,1,'2022-08-27 18:47:43','2022-08-27 18:47:43',40,'AC_BILL_VALIDATE','2022-08-27 18:47:43','2022-08-27 06:47:43',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0460 validada','Autor: egarcia\nFactura FA2208-0460 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,483,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1772,1772,NULL,1,'2022-08-27 18:49:26','2022-08-27 18:49:26',40,'AC_BILL_DELETE','2022-08-27 18:49:26','2022-08-27 06:49:26',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura eliminada','Autor: egarcia\nFactura eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,483,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1773,1773,NULL,1,'2022-08-27 18:50:24','2022-08-27 18:50:24',40,'AC_BILL_VALIDATE','2022-08-27 18:50:24','2022-08-27 06:50:24',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0460 validada','Autor: egarcia\nFactura FA2208-0460 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,484,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1774,1774,NULL,1,'2022-08-27 18:52:04','2022-08-27 18:52:04',40,'AC_BILL_VALIDATE','2022-08-27 18:52:04','2022-08-27 06:52:04',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0461 validada','Autor: egarcia\nFactura FA2208-0461 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,485,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1775,1775,NULL,1,'2022-08-27 20:47:40','2022-08-27 20:47:40',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-27 20:47:40','2022-08-27 08:47:40',6,NULL,NULL,3,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0075 validada','Autor: egarcia\nFactura SI2208-0075 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,103,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1776,1776,NULL,1,'2022-08-27 20:48:41','2022-08-27 20:48:41',40,'AC_BILL_VALIDATE','2022-08-27 20:48:41','2022-08-27 08:48:41',11,NULL,NULL,12314,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0462 validada','Autor: gdealba\nFactura FA2208-0462 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,486,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1777,1777,NULL,1,'2022-08-27 20:50:28','2022-08-27 20:50:28',40,'AC_BILL_VALIDATE','2022-08-27 20:50:28','2022-08-27 08:50:28',11,NULL,NULL,10931,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0463 validada','Autor: gdealba\nFactura FA2208-0463 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,488,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1778,1778,NULL,1,'2022-08-27 20:50:45','2022-08-27 20:50:45',40,'AC_BILL_VALIDATE','2022-08-27 20:50:45','2022-08-27 08:50:45',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0464 validada','Autor: egarcia\nFactura FA2208-0464 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,487,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1779,1779,NULL,1,'2022-08-27 20:51:54','2022-08-27 20:51:54',40,'AC_BILL_VALIDATE','2022-08-27 20:51:54','2022-08-27 08:51:55',11,NULL,NULL,10932,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0465 validada','Autor: gdealba\nFactura FA2208-0465 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,489,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1780,1780,NULL,1,'2022-08-27 20:53:43','2022-08-27 20:53:43',40,'AC_BILL_VALIDATE','2022-08-27 20:53:43','2022-08-27 08:53:43',11,NULL,NULL,10937,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0466 validada','Autor: gdealba\nFactura FA2208-0466 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,490,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1781,1781,NULL,1,'2022-08-27 20:55:54','2022-08-27 20:55:54',40,'AC_BILL_VALIDATE','2022-08-27 20:55:54','2022-08-27 08:55:54',11,NULL,NULL,11717,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0467 validada','Autor: gdealba\nFactura FA2208-0467 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,491,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1782,1782,NULL,1,'2022-08-27 21:32:14','2022-08-27 21:32:14',40,'AC_BILL_VALIDATE','2022-08-27 21:32:14','2022-08-27 09:32:14',11,NULL,NULL,12490,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0468 validada','Autor: gdealba\nFactura FA2208-0468 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,492,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1783,1783,NULL,1,'2022-08-27 21:32:14','2022-08-27 21:32:14',40,'AC_BILL_UNVALIDATE','2022-08-27 21:32:14','2022-08-27 09:32:14',4,NULL,NULL,14336,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura FA2208-0460 al estado de borrador','Autor: yrodriguez\nRegresar factura FA2208-0460 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,484,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1784,1784,NULL,1,'2022-08-27 21:34:53','2022-08-27 21:34:53',40,'AC_BILL_VALIDATE','2022-08-27 21:34:53','2022-08-27 09:34:53',11,NULL,NULL,13122,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0469 validada','Autor: gdealba\nFactura FA2208-0469 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,493,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1785,1785,NULL,1,'2022-08-27 21:36:44','2022-08-27 21:36:44',40,'AC_BILL_VALIDATE','2022-08-27 21:36:44','2022-08-27 09:36:44',11,NULL,NULL,13366,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0470 validada','Autor: gdealba\nFactura FA2208-0470 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,494,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1786,1786,NULL,1,'2022-08-27 21:43:01','2022-08-27 21:43:01',40,'AC_COMPANY_CREATE','2022-08-27 21:43:01','2022-08-27 09:43:01',11,NULL,NULL,14368,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Tercero RUTA 67 PUBLICO GENERAL creado','Autor: gdealba\nTercero RUTA 67 PUBLICO GENERAL creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1787,1787,NULL,1,'2022-08-27 21:46:33','2022-08-27 21:46:33',40,'AC_COMPANY_MODIFY','2022-08-27 21:46:33','2022-08-27 09:46:33',11,NULL,NULL,14368,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Tercero RUTA 67 PUBLICO GENERAL modificado','Autor: gdealba\nTercero RUTA 67 PUBLICO GENERAL modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1788,1788,NULL,1,'2022-08-27 21:47:19','2022-08-27 21:47:19',40,'AC_BILL_DELETE','2022-08-27 21:47:19','2022-08-27 09:47:19',11,NULL,NULL,14368,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura eliminada','Autor: gdealba\nFactura eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,495,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1789,1789,NULL,1,'2022-08-27 21:55:53','2022-08-27 21:55:53',40,'AC_BILL_VALIDATE','2022-08-27 21:55:53','2022-08-27 09:55:53',11,NULL,NULL,14368,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0471 validada','Autor: gdealba\nFactura FA2208-0471 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,496,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1790,1790,NULL,1,'2022-08-27 22:02:47','2022-08-27 22:02:47',40,'AC_BILL_VALIDATE','2022-08-27 22:02:47','2022-08-27 10:02:47',11,NULL,NULL,13970,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0472 validada','Autor: gdealba\nFactura FA2208-0472 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,497,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1791,1791,NULL,1,'2022-08-27 22:03:42','2022-08-27 22:03:42',40,'AC_BILL_VALIDATE','2022-08-27 22:03:42','2022-08-27 10:03:42',11,NULL,NULL,10957,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0473 validada','Autor: gdealba\nFactura FA2208-0473 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,498,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1792,1792,NULL,1,'2022-08-27 22:04:41','2022-08-27 22:04:41',40,'AC_BILL_VALIDATE','2022-08-27 22:04:41','2022-08-27 10:04:41',11,NULL,NULL,10966,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0474 validada','Autor: gdealba\nFactura FA2208-0474 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,499,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1793,1793,NULL,1,'2022-08-27 22:05:15','2022-08-27 22:05:15',40,'AC_BILL_VALIDATE','2022-08-27 22:05:15','2022-08-27 10:05:15',11,NULL,NULL,10968,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0475 validada','Autor: gdealba\nFactura FA2208-0475 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,500,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1794,1794,NULL,1,'2022-08-27 22:06:15','2022-08-27 22:06:15',40,'AC_BILL_VALIDATE','2022-08-27 22:06:15','2022-08-27 10:06:15',11,NULL,NULL,11095,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0476 validada','Autor: gdealba\nFactura FA2208-0476 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,501,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1795,1795,NULL,1,'2022-08-27 22:07:47','2022-08-27 22:07:47',40,'AC_BILL_VALIDATE','2022-08-27 22:07:47','2022-08-27 10:07:47',11,NULL,NULL,12799,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0477 validada','Autor: gdealba\nFactura FA2208-0477 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,502,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1796,1796,NULL,1,'2022-08-27 22:08:16','2022-08-27 22:08:16',40,'AC_BILL_VALIDATE','2022-08-27 22:08:16','2022-08-27 10:08:16',11,NULL,NULL,13058,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0478 validada','Autor: gdealba\nFactura FA2208-0478 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,503,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1797,1797,NULL,1,'2022-08-27 22:09:03','2022-08-27 22:09:03',40,'AC_BILL_VALIDATE','2022-08-27 22:09:03','2022-08-27 10:09:03',11,NULL,NULL,13577,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0479 validada','Autor: gdealba\nFactura FA2208-0479 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,504,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1798,1798,NULL,1,'2022-08-27 22:10:24','2022-08-27 22:10:24',40,'AC_BILL_VALIDATE','2022-08-27 22:10:24','2022-08-27 10:10:24',11,NULL,NULL,13582,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0480 validada','Autor: gdealba\nFactura FA2208-0480 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,505,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1799,1799,NULL,1,'2022-08-27 22:11:50','2022-08-27 22:11:50',40,'AC_BILL_VALIDATE','2022-08-27 22:11:50','2022-08-27 10:11:50',11,NULL,NULL,13622,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0481 validada','Autor: gdealba\nFactura FA2208-0481 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,506,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1800,1800,NULL,1,'2022-08-27 22:12:55','2022-08-27 22:12:55',40,'AC_BILL_VALIDATE','2022-08-27 22:12:55','2022-08-27 10:12:55',11,NULL,NULL,13684,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0482 validada','Autor: gdealba\nFactura FA2208-0482 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,507,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1801,1801,NULL,1,'2022-08-27 22:19:21','2022-08-27 22:19:21',40,'AC_COMPANY_MODIFY','2022-08-27 22:19:21','2022-08-27 10:19:21',11,NULL,NULL,14368,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Tercero PUBLICO GENERAL RUTA 67 modificado','Autor: gdealba\nTercero PUBLICO GENERAL RUTA 67 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1802,1802,NULL,1,'2022-08-27 22:26:10','2022-08-27 22:26:10',40,'AC_BILL_VALIDATE','2022-08-27 22:26:10','2022-08-27 10:26:10',11,NULL,NULL,14366,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0483 validada','Autor: gdealba\nFactura FA2208-0483 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,508,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1803,1803,NULL,1,'2022-08-27 22:28:03','2022-08-27 22:28:03',40,'AC_BILL_VALIDATE','2022-08-27 22:28:03','2022-08-27 10:28:03',11,NULL,NULL,14366,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0484 validada','Autor: gdealba\nFactura FA2208-0484 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,509,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1804,1804,NULL,1,'2022-08-27 22:29:45','2022-08-27 22:29:45',40,'AC_BILL_VALIDATE','2022-08-27 22:29:45','2022-08-27 10:29:45',11,NULL,NULL,14366,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0485 validada','Autor: gdealba\nFactura FA2208-0485 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,510,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1805,1805,NULL,1,'2022-08-27 22:30:50','2022-08-27 22:30:50',40,'AC_BILL_VALIDATE','2022-08-27 22:30:50','2022-08-27 10:30:50',11,NULL,NULL,14366,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0486 validada','Autor: gdealba\nFactura FA2208-0486 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,511,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1806,1806,NULL,1,'2022-08-27 22:32:39','2022-08-27 22:32:39',40,'AC_BILL_VALIDATE','2022-08-27 22:32:39','2022-08-27 10:32:39',11,NULL,NULL,14048,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0487 validada','Autor: gdealba\nFactura FA2208-0487 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,512,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1807,1807,NULL,1,'2022-08-27 22:43:07','2022-08-27 22:43:07',40,'AC_COMPANY_CREATE','2022-08-27 22:43:07','2022-08-27 10:43:07',11,NULL,NULL,14369,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Tercero FARMACIA GUADALAJARA S.A. DE C.V. creado','Autor: gdealba\nTercero FARMACIA GUADALAJARA S.A. DE C.V. creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1808,1808,NULL,1,'2022-08-27 22:54:46','2022-08-27 22:54:46',40,'AC_BILL_VALIDATE','2022-08-27 22:54:46','2022-08-27 10:54:46',11,NULL,NULL,14369,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0488 validada','Autor: gdealba\nFactura FA2208-0488 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,513,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1809,1809,NULL,1,'2022-08-27 22:56:56','2022-08-27 22:56:56',40,'AC_BILL_VALIDATE','2022-08-27 22:56:56','2022-08-27 10:56:56',11,NULL,NULL,14014,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0489 validada','Autor: gdealba\nFactura FA2208-0489 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,514,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1810,1810,NULL,1,'2022-08-27 22:58:32','2022-08-27 22:58:32',40,'AC_BILL_VALIDATE','2022-08-27 22:58:32','2022-08-27 10:58:32',11,NULL,NULL,13998,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0490 validada','Autor: gdealba\nFactura FA2208-0490 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,515,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1811,1811,NULL,1,'2022-08-27 23:00:04','2022-08-27 23:00:04',40,'AC_BILL_VALIDATE','2022-08-27 23:00:04','2022-08-27 11:00:04',11,NULL,NULL,13988,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0491 validada','Autor: gdealba\nFactura FA2208-0491 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,516,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1812,1812,NULL,1,'2022-08-27 23:04:27','2022-08-27 23:04:27',40,'AC_BILL_VALIDATE','2022-08-27 23:04:27','2022-08-27 11:04:27',11,NULL,NULL,13903,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0492 validada','Autor: gdealba\nFactura FA2208-0492 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,517,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1813,1813,NULL,1,'2022-08-27 23:05:28','2022-08-27 23:05:28',40,'AC_BILL_VALIDATE','2022-08-27 23:05:28','2022-08-27 11:05:28',11,NULL,NULL,13846,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0493 validada','Autor: gdealba\nFactura FA2208-0493 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,518,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1814,1814,NULL,1,'2022-08-27 23:06:39','2022-08-27 23:06:39',40,'AC_BILL_VALIDATE','2022-08-27 23:06:39','2022-08-27 11:06:39',11,NULL,NULL,12879,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0494 validada','Autor: gdealba\nFactura FA2208-0494 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,519,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1815,1815,NULL,1,'2022-08-27 23:17:04','2022-08-27 23:17:04',40,'AC_BILL_VALIDATE','2022-08-27 23:17:04','2022-08-27 11:17:04',11,NULL,NULL,10861,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0495 validada','Autor: gdealba\nFactura FA2208-0495 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,520,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1816,1816,NULL,1,'2022-08-27 23:18:54','2022-08-27 23:18:54',40,'AC_BILL_VALIDATE','2022-08-27 23:18:54','2022-08-27 11:18:54',11,NULL,NULL,10869,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0496 validada','Autor: gdealba\nFactura FA2208-0496 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,521,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1817,1817,NULL,1,'2022-08-27 23:20:33','2022-08-27 23:20:33',40,'AC_BILL_VALIDATE','2022-08-27 23:20:33','2022-08-27 11:20:33',11,NULL,NULL,11727,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0497 validada','Autor: gdealba\nFactura FA2208-0497 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,522,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1818,1818,NULL,1,'2022-08-27 23:23:40','2022-08-27 23:23:40',40,'AC_BILL_VALIDATE','2022-08-27 23:23:40','2022-08-27 11:23:40',11,NULL,NULL,11857,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0498 validada','Autor: gdealba\nFactura FA2208-0498 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,523,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1819,1819,NULL,1,'2022-08-27 23:24:33','2022-08-27 23:24:33',40,'AC_BILL_VALIDATE','2022-08-27 23:24:33','2022-08-27 11:24:33',11,NULL,NULL,11858,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0499 validada','Autor: gdealba\nFactura FA2208-0499 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,524,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1820,1820,NULL,1,'2022-08-27 23:25:25','2022-08-27 23:25:25',40,'AC_BILL_VALIDATE','2022-08-27 23:25:25','2022-08-27 11:25:25',11,NULL,NULL,12093,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0500 validada','Autor: gdealba\nFactura FA2208-0500 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,525,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1821,1821,NULL,1,'2022-08-27 23:27:00','2022-08-27 23:27:00',40,'AC_BILL_VALIDATE','2022-08-27 23:27:00','2022-08-27 11:27:00',11,NULL,NULL,14365,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0501 validada','Autor: gdealba\nFactura FA2208-0501 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,526,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1822,1822,NULL,1,'2022-08-27 23:28:32','2022-08-27 23:28:32',40,'AC_BILL_VALIDATE','2022-08-27 23:28:32','2022-08-27 11:28:32',11,NULL,NULL,14366,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0502 validada','Autor: gdealba\nFactura FA2208-0502 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,527,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1823,1823,NULL,1,'2022-08-27 23:31:04','2022-08-27 23:31:04',40,'AC_BILL_VALIDATE','2022-08-27 23:31:04','2022-08-27 11:31:04',11,NULL,NULL,14365,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0503 validada','Autor: gdealba\nFactura FA2208-0503 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,528,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1824,1824,NULL,1,'2022-08-27 23:45:17','2022-08-27 23:45:17',40,'AC_BILL_VALIDATE','2022-08-27 23:45:17','2022-08-27 11:45:17',11,NULL,NULL,13797,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0504 validada','Autor: gdealba\nFactura FA2208-0504 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,529,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1825,1825,NULL,1,'2022-08-27 23:47:26','2022-08-27 23:47:26',40,'AC_BILL_VALIDATE','2022-08-27 23:47:26','2022-08-27 11:47:26',11,NULL,NULL,10782,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0505 validada','Autor: gdealba\nFactura FA2208-0505 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,530,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1826,1826,NULL,1,'2022-08-27 23:49:08','2022-08-27 23:49:08',40,'AC_BILL_VALIDATE','2022-08-27 23:49:08','2022-08-27 11:49:08',11,NULL,NULL,10815,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0506 validada','Autor: gdealba\nFactura FA2208-0506 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,531,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1827,1827,NULL,1,'2022-08-27 23:49:51','2022-08-27 23:49:51',40,'AC_BILL_VALIDATE','2022-08-27 23:49:51','2022-08-27 11:49:51',11,NULL,NULL,10970,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0507 validada','Autor: gdealba\nFactura FA2208-0507 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,532,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1828,1828,NULL,1,'2022-08-27 23:50:36','2022-08-27 23:50:36',40,'AC_BILL_VALIDATE','2022-08-27 23:50:36','2022-08-27 11:50:36',11,NULL,NULL,11147,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0508 validada','Autor: gdealba\nFactura FA2208-0508 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,533,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1829,1829,NULL,1,'2022-08-27 23:51:41','2022-08-27 23:51:41',40,'AC_BILL_VALIDATE','2022-08-27 23:51:41','2022-08-27 11:51:41',11,NULL,NULL,11329,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0509 validada','Autor: gdealba\nFactura FA2208-0509 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,534,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1830,1830,NULL,1,'2022-08-27 23:52:26','2022-08-27 23:52:26',40,'AC_BILL_VALIDATE','2022-08-27 23:52:26','2022-08-27 11:52:26',11,NULL,NULL,11738,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0510 validada','Autor: gdealba\nFactura FA2208-0510 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,535,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1831,1831,NULL,1,'2022-08-27 23:54:40','2022-08-27 23:54:40',40,'AC_BILL_VALIDATE','2022-08-27 23:54:40','2022-08-27 11:54:40',11,NULL,NULL,11904,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0511 validada','Autor: gdealba\nFactura FA2208-0511 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,536,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1832,1832,NULL,1,'2022-08-27 23:56:04','2022-08-27 23:56:04',40,'AC_BILL_VALIDATE','2022-08-27 23:56:04','2022-08-27 11:56:04',11,NULL,NULL,11905,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0512 validada','Autor: gdealba\nFactura FA2208-0512 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,537,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1833,1833,NULL,1,'2022-08-27 23:56:56','2022-08-27 23:56:56',40,'AC_BILL_VALIDATE','2022-08-27 23:56:56','2022-08-27 11:56:56',11,NULL,NULL,12318,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0513 validada','Autor: gdealba\nFactura FA2208-0513 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,538,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1834,1834,NULL,1,'2022-08-27 23:58:39','2022-08-27 23:58:39',40,'AC_BILL_VALIDATE','2022-08-27 23:58:39','2022-08-27 11:58:39',11,NULL,NULL,12444,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0514 validada','Autor: gdealba\nFactura FA2208-0514 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,539,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1835,1835,NULL,1,'2022-08-27 23:59:32','2022-08-27 23:59:32',40,'AC_BILL_VALIDATE','2022-08-27 23:59:32','2022-08-27 11:59:32',11,NULL,NULL,12844,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0515 validada','Autor: gdealba\nFactura FA2208-0515 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,540,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1836,1836,NULL,1,'2022-08-28 00:00:41','2022-08-28 00:00:41',40,'AC_BILL_VALIDATE','2022-08-28 00:00:41','2022-08-27 12:00:41',11,NULL,NULL,12972,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0516 validada','Autor: gdealba\nFactura FA2208-0516 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,541,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1837,1837,NULL,1,'2022-08-28 00:02:31','2022-08-28 00:02:31',40,'AC_BILL_VALIDATE','2022-08-28 00:02:31','2022-08-27 12:02:31',11,NULL,NULL,13165,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0517 validada','Autor: gdealba\nFactura FA2208-0517 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,542,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1838,1838,NULL,1,'2022-08-28 00:04:00','2022-08-28 00:04:00',40,'AC_BILL_VALIDATE','2022-08-28 00:04:00','2022-08-27 12:04:00',11,NULL,NULL,13202,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0518 validada','Autor: gdealba\nFactura FA2208-0518 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,543,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1839,1839,NULL,1,'2022-08-28 00:05:05','2022-08-28 00:05:05',40,'AC_BILL_VALIDATE','2022-08-28 00:05:05','2022-08-27 12:05:05',11,NULL,NULL,13138,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0519 validada','Autor: gdealba\nFactura FA2208-0519 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,544,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1840,1840,NULL,1,'2022-08-28 00:40:17','2022-08-28 00:40:17',40,'AC_BILL_UNVALIDATE','2022-08-28 00:40:17','2022-08-27 12:40:17',11,NULL,NULL,13138,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura FA2208-0519 al estado de borrador','Autor: gdealba\nRegresar factura FA2208-0519 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,544,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1841,1841,NULL,1,'2022-08-28 00:40:28','2022-08-28 00:40:28',40,'AC_BILL_VALIDATE','2022-08-28 00:40:28','2022-08-27 12:40:28',11,NULL,NULL,13138,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0519 validada','Autor: gdealba\nFactura FA2208-0519 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,544,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1842,1842,NULL,1,'2022-08-29 13:04:44','2022-08-29 13:04:44',40,'AC_BILL_VALIDATE','2022-08-29 13:04:44','2022-08-29 01:04:44',11,NULL,NULL,10812,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0520 validada','Autor: gdealba\nFactura FA2208-0520 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,545,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1843,1843,NULL,1,'2022-08-29 13:09:46','2022-08-29 13:09:46',40,'AC_BILL_VALIDATE','2022-08-29 13:09:46','2022-08-29 01:09:46',11,NULL,NULL,14103,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0521 validada','Autor: gdealba\nFactura FA2208-0521 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,546,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1844,1844,NULL,1,'2022-08-29 13:12:25','2022-08-29 13:12:25',40,'AC_BILL_VALIDATE','2022-08-29 13:12:25','2022-08-29 01:12:25',11,NULL,NULL,14157,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0522 validada','Autor: gdealba\nFactura FA2208-0522 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,547,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1845,1845,NULL,1,'2022-08-29 13:14:35','2022-08-29 13:14:35',40,'AC_BILL_VALIDATE','2022-08-29 13:14:35','2022-08-29 01:14:35',11,NULL,NULL,11628,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0523 validada','Autor: gdealba\nFactura FA2208-0523 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,548,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1846,1846,NULL,1,'2022-08-29 13:17:15','2022-08-29 13:17:15',40,'AC_BILL_VALIDATE','2022-08-29 13:17:15','2022-08-29 01:17:15',11,NULL,NULL,11801,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0524 validada','Autor: gdealba\nFactura FA2208-0524 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,549,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1847,1847,NULL,1,'2022-08-29 13:18:04','2022-08-29 13:18:04',40,'AC_BILL_VALIDATE','2022-08-29 13:18:04','2022-08-29 01:18:04',11,NULL,NULL,11826,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0525 validada','Autor: gdealba\nFactura FA2208-0525 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,550,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1848,1848,NULL,1,'2022-08-29 13:19:18','2022-08-29 13:19:18',40,'AC_BILL_VALIDATE','2022-08-29 13:19:18','2022-08-29 01:19:18',11,NULL,NULL,11827,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0526 validada','Autor: gdealba\nFactura FA2208-0526 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,551,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1849,1849,NULL,1,'2022-08-29 13:20:20','2022-08-29 13:20:20',40,'AC_BILL_VALIDATE','2022-08-29 13:20:20','2022-08-29 01:20:20',11,NULL,NULL,11839,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0527 validada','Autor: gdealba\nFactura FA2208-0527 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,552,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1850,1850,NULL,1,'2022-08-29 13:24:22','2022-08-29 13:24:22',40,'AC_BILL_VALIDATE','2022-08-29 13:24:22','2022-08-29 01:24:22',11,NULL,NULL,11945,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0528 validada','Autor: gdealba\nFactura FA2208-0528 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,553,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1851,1851,NULL,1,'2022-08-29 13:25:44','2022-08-29 13:25:44',40,'AC_BILL_VALIDATE','2022-08-29 13:25:44','2022-08-29 01:25:44',11,NULL,NULL,12097,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0529 validada','Autor: gdealba\nFactura FA2208-0529 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,554,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1852,1852,NULL,1,'2022-08-29 13:27:07','2022-08-29 13:27:07',40,'AC_BILL_VALIDATE','2022-08-29 13:27:07','2022-08-29 01:27:07',11,NULL,NULL,12273,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0530 validada','Autor: gdealba\nFactura FA2208-0530 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,555,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1853,1853,NULL,1,'2022-08-29 13:28:13','2022-08-29 13:28:13',40,'AC_BILL_VALIDATE','2022-08-29 13:28:13','2022-08-29 01:28:13',11,NULL,NULL,12449,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0531 validada','Autor: gdealba\nFactura FA2208-0531 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,556,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1854,1854,NULL,1,'2022-08-29 13:29:12','2022-08-29 13:29:12',40,'AC_BILL_VALIDATE','2022-08-29 13:29:12','2022-08-29 01:29:12',11,NULL,NULL,12765,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0532 validada','Autor: gdealba\nFactura FA2208-0532 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,557,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1855,1855,NULL,1,'2022-08-29 13:30:33','2022-08-29 13:30:33',40,'AC_BILL_VALIDATE','2022-08-29 13:30:33','2022-08-29 01:30:33',11,NULL,NULL,13477,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0533 validada','Autor: gdealba\nFactura FA2208-0533 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,558,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1856,1856,NULL,1,'2022-08-29 13:34:19','2022-08-29 13:34:19',40,'AC_BILL_VALIDATE','2022-08-29 13:34:19','2022-08-29 01:34:19',11,NULL,NULL,13646,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0534 validada','Autor: gdealba\nFactura FA2208-0534 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,559,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1857,1857,NULL,1,'2022-08-29 13:36:38','2022-08-29 13:36:38',40,'AC_BILL_VALIDATE','2022-08-29 13:36:38','2022-08-29 01:36:38',11,NULL,NULL,14367,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0535 validada','Autor: gdealba\nFactura FA2208-0535 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,560,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1858,1858,NULL,1,'2022-08-29 13:38:43','2022-08-29 13:38:43',40,'AC_BILL_VALIDATE','2022-08-29 13:38:43','2022-08-29 01:38:43',11,NULL,NULL,14367,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0536 validada','Autor: gdealba\nFactura FA2208-0536 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,561,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1859,1859,NULL,1,'2022-08-29 13:39:54','2022-08-29 13:39:54',40,'AC_BILL_VALIDATE','2022-08-29 13:39:54','2022-08-29 01:39:54',11,NULL,NULL,14367,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0537 validada','Autor: gdealba\nFactura FA2208-0537 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,562,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1860,1860,NULL,1,'2022-08-29 13:42:44','2022-08-29 13:42:44',40,'AC_BILL_VALIDATE','2022-08-29 13:42:44','2022-08-29 01:42:44',11,NULL,NULL,13839,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0538 validada','Autor: gdealba\nFactura FA2208-0538 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,563,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1861,1861,NULL,1,'2022-08-29 13:43:51','2022-08-29 13:43:51',40,'AC_BILL_VALIDATE','2022-08-29 13:43:51','2022-08-29 01:43:51',11,NULL,NULL,13847,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0539 validada','Autor: gdealba\nFactura FA2208-0539 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,564,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1862,1862,NULL,1,'2022-08-29 13:45:47','2022-08-29 13:45:47',40,'AC_BILL_VALIDATE','2022-08-29 13:45:47','2022-08-29 01:45:47',11,NULL,NULL,13876,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0540 validada','Autor: gdealba\nFactura FA2208-0540 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,565,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1863,1863,NULL,1,'2022-08-29 13:46:45','2022-08-29 13:46:45',40,'AC_BILL_VALIDATE','2022-08-29 13:46:45','2022-08-29 01:46:46',11,NULL,NULL,10978,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0541 validada','Autor: gdealba\nFactura FA2208-0541 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,566,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1864,1864,NULL,1,'2022-08-29 13:49:07','2022-08-29 13:49:07',40,'AC_BILL_VALIDATE','2022-08-29 13:49:07','2022-08-29 01:49:07',11,NULL,NULL,10979,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0542 validada','Autor: gdealba\nFactura FA2208-0542 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,567,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1865,1865,NULL,1,'2022-08-29 13:50:42','2022-08-29 13:50:42',40,'AC_BILL_VALIDATE','2022-08-29 13:50:42','2022-08-29 01:50:42',11,NULL,NULL,11688,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0543 validada','Autor: gdealba\nFactura FA2208-0543 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,568,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1866,1866,NULL,1,'2022-08-29 13:53:25','2022-08-29 13:53:25',40,'AC_BILL_VALIDATE','2022-08-29 13:53:25','2022-08-29 01:53:25',11,NULL,NULL,11735,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0544 validada','Autor: gdealba\nFactura FA2208-0544 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,569,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1867,1867,NULL,1,'2022-08-29 13:54:12','2022-08-29 13:54:12',40,'AC_BILL_VALIDATE','2022-08-29 13:54:12','2022-08-29 01:54:12',11,NULL,NULL,11823,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0545 validada','Autor: gdealba\nFactura FA2208-0545 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,570,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1868,1868,NULL,1,'2022-08-29 13:54:59','2022-08-29 13:54:59',40,'AC_BILL_VALIDATE','2022-08-29 13:54:59','2022-08-29 01:54:59',11,NULL,NULL,11853,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0546 validada','Autor: gdealba\nFactura FA2208-0546 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,571,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1869,1869,NULL,1,'2022-08-29 13:56:09','2022-08-29 13:56:09',40,'AC_BILL_VALIDATE','2022-08-29 13:56:09','2022-08-29 01:56:09',11,NULL,NULL,12098,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0547 validada','Autor: gdealba\nFactura FA2208-0547 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,572,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1870,1870,NULL,1,'2022-08-29 14:01:03','2022-08-29 14:01:03',40,'AC_BILL_VALIDATE','2022-08-29 14:01:03','2022-08-29 02:01:03',11,NULL,NULL,13871,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0548 validada','Autor: gdealba\nFactura FA2208-0548 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,573,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1871,1871,NULL,1,'2022-08-29 14:02:34','2022-08-29 14:02:34',40,'AC_BILL_VALIDATE','2022-08-29 14:02:34','2022-08-29 02:02:34',11,NULL,NULL,13858,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0549 validada','Autor: gdealba\nFactura FA2208-0549 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,574,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1872,1872,NULL,1,'2022-08-29 14:03:40','2022-08-29 14:03:40',40,'AC_BILL_VALIDATE','2022-08-29 14:03:40','2022-08-29 02:03:40',11,NULL,NULL,14131,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0550 validada','Autor: gdealba\nFactura FA2208-0550 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,575,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1873,1873,NULL,1,'2022-08-29 14:05:32','2022-08-29 14:05:32',40,'AC_BILL_VALIDATE','2022-08-29 14:05:32','2022-08-29 02:05:32',11,NULL,NULL,13892,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0551 validada','Autor: gdealba\nFactura FA2208-0551 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,576,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1874,1874,NULL,1,'2022-08-29 14:06:37','2022-08-29 14:06:37',40,'AC_BILL_VALIDATE','2022-08-29 14:06:37','2022-08-29 02:06:37',11,NULL,NULL,14107,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0552 validada','Autor: gdealba\nFactura FA2208-0552 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,577,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1875,1875,NULL,1,'2022-08-29 14:08:27','2022-08-29 14:08:27',40,'AC_BILL_VALIDATE','2022-08-29 14:08:27','2022-08-29 02:08:27',11,NULL,NULL,14012,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0553 validada','Autor: gdealba\nFactura FA2208-0553 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,578,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1876,1876,NULL,1,'2022-08-29 14:09:10','2022-08-29 14:09:10',40,'AC_COMPANY_CREATE','2022-08-29 14:09:10','2022-08-29 02:09:10',11,NULL,NULL,14370,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Tercero PUBLICO EN GENERAL R64 creado','Autor: gdealba\nTercero PUBLICO EN GENERAL R64 creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1877,1877,NULL,1,'2022-08-29 14:10:14','2022-08-29 14:10:14',40,'AC_BILL_VALIDATE','2022-08-29 14:10:14','2022-08-29 02:10:14',11,NULL,NULL,14370,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0554 validada','Autor: gdealba\nFactura FA2208-0554 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,579,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1878,1878,NULL,1,'2022-08-29 14:11:48','2022-08-29 14:11:48',40,'AC_BILL_VALIDATE','2022-08-29 14:11:48','2022-08-29 02:11:48',11,NULL,NULL,10806,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0555 validada','Autor: gdealba\nFactura FA2208-0555 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,580,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1879,1879,NULL,1,'2022-08-29 14:12:31','2022-08-29 14:12:31',40,'AC_BILL_VALIDATE','2022-08-29 14:12:31','2022-08-29 02:12:31',11,NULL,NULL,10807,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0556 validada','Autor: gdealba\nFactura FA2208-0556 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,581,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1880,1880,NULL,1,'2022-08-29 14:13:22','2022-08-29 14:13:22',40,'AC_BILL_VALIDATE','2022-08-29 14:13:22','2022-08-29 02:13:22',11,NULL,NULL,10808,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0557 validada','Autor: gdealba\nFactura FA2208-0557 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,582,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1881,1881,NULL,1,'2022-08-29 14:14:34','2022-08-29 14:14:34',40,'AC_BILL_VALIDATE','2022-08-29 14:14:34','2022-08-29 02:14:34',11,NULL,NULL,10809,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0558 validada','Autor: gdealba\nFactura FA2208-0558 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,583,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1882,1882,NULL,1,'2022-08-29 14:15:33','2022-08-29 14:15:33',40,'AC_BILL_VALIDATE','2022-08-29 14:15:33','2022-08-29 02:15:33',11,NULL,NULL,11053,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0559 validada','Autor: gdealba\nFactura FA2208-0559 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,584,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1883,1883,NULL,1,'2022-08-29 14:16:21','2022-08-29 14:16:21',40,'AC_BILL_VALIDATE','2022-08-29 14:16:21','2022-08-29 02:16:21',11,NULL,NULL,11875,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0560 validada','Autor: gdealba\nFactura FA2208-0560 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,585,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1884,1884,NULL,1,'2022-08-29 14:17:33','2022-08-29 14:17:33',40,'AC_BILL_VALIDATE','2022-08-29 14:17:33','2022-08-29 02:17:33',11,NULL,NULL,11985,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0561 validada','Autor: gdealba\nFactura FA2208-0561 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,586,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1885,1885,NULL,1,'2022-08-29 14:18:49','2022-08-29 14:18:49',40,'AC_BILL_VALIDATE','2022-08-29 14:18:49','2022-08-29 02:18:49',11,NULL,NULL,11993,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0562 validada','Autor: gdealba\nFactura FA2208-0562 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,587,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1886,1886,NULL,1,'2022-08-29 14:19:57','2022-08-29 14:19:57',40,'AC_BILL_VALIDATE','2022-08-29 14:19:57','2022-08-29 02:19:57',11,NULL,NULL,12297,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0563 validada','Autor: gdealba\nFactura FA2208-0563 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,588,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1887,1887,NULL,1,'2022-08-29 14:20:57','2022-08-29 14:20:57',40,'AC_BILL_VALIDATE','2022-08-29 14:20:57','2022-08-29 02:20:57',11,NULL,NULL,12677,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0564 validada','Autor: gdealba\nFactura FA2208-0564 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,589,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1888,1888,NULL,1,'2022-08-29 14:22:20','2022-08-29 14:22:20',40,'AC_BILL_VALIDATE','2022-08-29 14:22:20','2022-08-29 02:22:20',11,NULL,NULL,12682,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0565 validada','Autor: gdealba\nFactura FA2208-0565 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,590,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1889,1889,NULL,1,'2022-08-29 14:23:08','2022-08-29 14:23:08',40,'AC_BILL_VALIDATE','2022-08-29 14:23:08','2022-08-29 02:23:08',11,NULL,NULL,13065,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0566 validada','Autor: gdealba\nFactura FA2208-0566 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,591,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1890,1890,NULL,1,'2022-08-29 14:24:09','2022-08-29 14:24:09',40,'AC_BILL_VALIDATE','2022-08-29 14:24:09','2022-08-29 02:24:09',11,NULL,NULL,13590,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0567 validada','Autor: gdealba\nFactura FA2208-0567 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,592,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1891,1891,NULL,1,'2022-08-29 14:25:28','2022-08-29 14:25:28',40,'AC_BILL_VALIDATE','2022-08-29 14:25:28','2022-08-29 02:25:28',11,NULL,NULL,10785,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0568 validada','Autor: gdealba\nFactura FA2208-0568 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,593,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1892,1892,NULL,1,'2022-08-29 14:29:39','2022-08-29 14:29:39',40,'AC_BILL_VALIDATE','2022-08-29 14:29:39','2022-08-29 02:29:39',11,NULL,NULL,11135,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0569 validada','Autor: gdealba\nFactura FA2208-0569 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,594,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1893,1893,NULL,1,'2022-08-29 14:30:54','2022-08-29 14:30:54',40,'AC_BILL_VALIDATE','2022-08-29 14:30:54','2022-08-29 02:30:54',11,NULL,NULL,11765,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0570 validada','Autor: gdealba\nFactura FA2208-0570 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,595,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1894,1894,NULL,1,'2022-08-29 14:31:52','2022-08-29 14:31:52',40,'AC_BILL_VALIDATE','2022-08-29 14:31:52','2022-08-29 02:31:52',11,NULL,NULL,11773,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0571 validada','Autor: gdealba\nFactura FA2208-0571 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,596,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1895,1895,NULL,1,'2022-08-29 14:34:08','2022-08-29 14:34:08',40,'AC_BILL_VALIDATE','2022-08-29 14:34:08','2022-08-29 02:34:08',11,NULL,NULL,12410,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0572 validada','Autor: gdealba\nFactura FA2208-0572 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,597,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1896,1896,NULL,1,'2022-08-29 14:35:32','2022-08-29 14:35:32',40,'AC_BILL_VALIDATE','2022-08-29 14:35:32','2022-08-29 02:35:32',11,NULL,NULL,12651,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0573 validada','Autor: gdealba\nFactura FA2208-0573 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,598,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1897,1897,NULL,1,'2022-08-29 14:37:47','2022-08-29 14:37:47',40,'AC_BILL_VALIDATE','2022-08-29 14:37:47','2022-08-29 02:37:47',11,NULL,NULL,12695,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0574 validada','Autor: gdealba\nFactura FA2208-0574 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,599,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1898,1898,NULL,1,'2022-08-29 14:42:10','2022-08-29 14:42:10',40,'AC_BILL_VALIDATE','2022-08-29 14:42:10','2022-08-29 02:42:10',11,NULL,NULL,13075,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0575 validada','Autor: gdealba\nFactura FA2208-0575 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,600,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1899,1899,NULL,1,'2022-08-29 14:43:13','2022-08-29 14:43:13',40,'AC_BILL_VALIDATE','2022-08-29 14:43:13','2022-08-29 02:43:13',11,NULL,NULL,13583,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0576 validada','Autor: gdealba\nFactura FA2208-0576 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,601,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1900,1900,NULL,1,'2022-08-29 14:44:47','2022-08-29 14:44:47',40,'AC_BILL_VALIDATE','2022-08-29 14:44:47','2022-08-29 02:44:47',11,NULL,NULL,14366,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0577 validada','Autor: gdealba\nFactura FA2208-0577 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,602,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1901,1901,NULL,1,'2022-08-29 14:46:16','2022-08-29 14:46:16',40,'AC_BILL_VALIDATE','2022-08-29 14:46:16','2022-08-29 02:46:17',11,NULL,NULL,14366,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0578 validada','Autor: gdealba\nFactura FA2208-0578 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,603,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1902,1902,NULL,1,'2022-08-29 14:46:58','2022-08-29 14:46:58',40,'AC_BILL_VALIDATE','2022-08-29 14:46:58','2022-08-29 02:46:58',11,NULL,NULL,14366,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0579 validada','Autor: gdealba\nFactura FA2208-0579 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,604,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1903,1903,NULL,1,'2022-08-29 14:52:23','2022-08-29 14:52:23',40,'AC_BILL_VALIDATE','2022-08-29 14:52:23','2022-08-29 02:52:23',11,NULL,NULL,13943,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0580 validada','Autor: gdealba\nFactura FA2208-0580 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,605,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1904,1904,NULL,1,'2022-08-29 14:53:52','2022-08-29 14:53:52',40,'AC_BILL_VALIDATE','2022-08-29 14:53:52','2022-08-29 02:53:52',11,NULL,NULL,13775,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0581 validada','Autor: gdealba\nFactura FA2208-0581 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,606,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1905,1905,NULL,1,'2022-08-29 14:54:30','2022-08-29 14:54:30',40,'AC_BILL_UNVALIDATE','2022-08-29 14:54:30','2022-08-29 02:54:30',11,NULL,NULL,13943,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura FA2208-0580 al estado de borrador','Autor: gdealba\nRegresar factura FA2208-0580 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,605,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1906,1906,NULL,1,'2022-08-29 14:54:41','2022-08-29 14:54:41',40,'AC_BILL_VALIDATE','2022-08-29 14:54:41','2022-08-29 02:54:41',11,NULL,NULL,13943,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0580 validada','Autor: gdealba\nFactura FA2208-0580 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,605,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1907,1907,NULL,1,'2022-08-29 14:56:13','2022-08-29 14:56:13',40,'AC_BILL_VALIDATE','2022-08-29 14:56:13','2022-08-29 02:56:13',11,NULL,NULL,13779,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0582 validada','Autor: gdealba\nFactura FA2208-0582 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,607,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1908,1908,NULL,1,'2022-08-29 14:58:39','2022-08-29 14:58:39',40,'AC_BILL_VALIDATE','2022-08-29 14:58:39','2022-08-29 02:58:39',11,NULL,NULL,10863,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0583 validada','Autor: gdealba\nFactura FA2208-0583 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,608,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1909,1909,NULL,1,'2022-08-29 14:59:30','2022-08-29 14:59:30',40,'AC_BILL_VALIDATE','2022-08-29 14:59:30','2022-08-29 02:59:30',11,NULL,NULL,10864,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0584 validada','Autor: gdealba\nFactura FA2208-0584 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,609,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1910,1910,NULL,1,'2022-08-29 15:00:46','2022-08-29 15:00:46',40,'AC_BILL_VALIDATE','2022-08-29 15:00:46','2022-08-29 03:00:46',11,NULL,NULL,10996,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0585 validada','Autor: gdealba\nFactura FA2208-0585 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,610,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1911,1911,NULL,1,'2022-08-29 15:02:19','2022-08-29 15:02:19',40,'AC_BILL_VALIDATE','2022-08-29 15:02:19','2022-08-29 03:02:19',11,NULL,NULL,11071,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0586 validada','Autor: gdealba\nFactura FA2208-0586 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,611,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1912,1912,NULL,1,'2022-08-29 15:03:44','2022-08-29 15:03:44',40,'AC_BILL_VALIDATE','2022-08-29 15:03:44','2022-08-29 03:03:44',11,NULL,NULL,11117,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0587 validada','Autor: gdealba\nFactura FA2208-0587 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,612,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1913,1913,NULL,1,'2022-08-29 15:04:28','2022-08-29 15:04:28',40,'AC_BILL_VALIDATE','2022-08-29 15:04:28','2022-08-29 03:04:28',11,NULL,NULL,11744,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0588 validada','Autor: gdealba\nFactura FA2208-0588 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,613,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1914,1914,NULL,1,'2022-08-29 15:05:45','2022-08-29 15:05:45',40,'AC_BILL_VALIDATE','2022-08-29 15:05:45','2022-08-29 03:05:45',11,NULL,NULL,11746,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0589 validada','Autor: gdealba\nFactura FA2208-0589 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,614,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1915,1915,NULL,1,'2022-08-29 15:08:14','2022-08-29 15:08:14',40,'AC_BILL_VALIDATE','2022-08-29 15:08:14','2022-08-29 03:08:14',11,NULL,NULL,11748,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0590 validada','Autor: gdealba\nFactura FA2208-0590 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,615,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1916,1916,NULL,1,'2022-08-29 15:09:24','2022-08-29 15:09:24',40,'AC_BILL_VALIDATE','2022-08-29 15:09:24','2022-08-29 03:09:24',11,NULL,NULL,12216,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0591 validada','Autor: gdealba\nFactura FA2208-0591 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,616,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1917,1917,NULL,1,'2022-08-29 15:10:25','2022-08-29 15:10:25',40,'AC_BILL_VALIDATE','2022-08-29 15:10:25','2022-08-29 03:10:25',11,NULL,NULL,13139,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0592 validada','Autor: gdealba\nFactura FA2208-0592 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,617,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1918,1918,NULL,1,'2022-08-29 15:12:19','2022-08-29 15:12:19',40,'AC_BILL_VALIDATE','2022-08-29 15:12:19','2022-08-29 03:12:19',11,NULL,NULL,14365,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0593 validada','Autor: gdealba\nFactura FA2208-0593 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,618,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1919,1919,NULL,1,'2022-08-29 15:16:05','2022-08-29 15:16:05',40,'AC_BILL_VALIDATE','2022-08-29 15:16:05','2022-08-29 03:16:05',11,NULL,NULL,14365,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0594 validada','Autor: gdealba\nFactura FA2208-0594 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,619,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1920,1920,NULL,1,'2022-08-29 15:17:01','2022-08-29 15:17:01',40,'AC_BILL_VALIDATE','2022-08-29 15:17:01','2022-08-29 03:17:01',11,NULL,NULL,14365,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0595 validada','Autor: gdealba\nFactura FA2208-0595 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,620,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1921,1921,NULL,1,'2022-08-29 15:21:39','2022-08-29 15:21:39',40,'AC_BILL_VALIDATE','2022-08-29 15:21:39','2022-08-29 03:21:39',11,NULL,NULL,13958,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0596 validada','Autor: gdealba\nFactura FA2208-0596 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,621,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1922,1922,NULL,1,'2022-08-29 15:24:36','2022-08-29 15:24:36',40,'AC_BILL_VALIDATE','2022-08-29 15:24:36','2022-08-29 03:24:36',11,NULL,NULL,13872,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0597 validada','Autor: gdealba\nFactura FA2208-0597 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,622,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1923,1923,NULL,1,'2022-08-29 15:26:09','2022-08-29 15:26:09',40,'AC_BILL_VALIDATE','2022-08-29 15:26:09','2022-08-29 03:26:09',11,NULL,NULL,14058,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0598 validada','Autor: gdealba\nFactura FA2208-0598 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,623,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1924,1924,NULL,1,'2022-08-29 15:27:44','2022-08-29 15:27:44',40,'AC_BILL_VALIDATE','2022-08-29 15:27:44','2022-08-29 03:27:44',11,NULL,NULL,13919,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0599 validada','Autor: gdealba\nFactura FA2208-0599 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,624,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1925,1925,NULL,1,'2022-08-29 15:30:04','2022-08-29 15:30:04',40,'AC_BILL_VALIDATE','2022-08-29 15:30:04','2022-08-29 03:30:04',11,NULL,NULL,14175,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0600 validada','Autor: gdealba\nFactura FA2208-0600 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,625,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1926,1926,NULL,1,'2022-08-29 15:31:01','2022-08-29 15:31:01',40,'AC_BILL_VALIDATE','2022-08-29 15:31:01','2022-08-29 03:31:01',11,NULL,NULL,13826,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0601 validada','Autor: gdealba\nFactura FA2208-0601 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,626,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1927,1927,NULL,1,'2022-08-29 15:32:10','2022-08-29 15:32:10',40,'AC_BILL_VALIDATE','2022-08-29 15:32:10','2022-08-29 03:32:10',11,NULL,NULL,13824,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0602 validada','Autor: gdealba\nFactura FA2208-0602 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,627,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1928,1928,NULL,1,'2022-08-29 15:33:31','2022-08-29 15:33:31',40,'AC_BILL_VALIDATE','2022-08-29 15:33:31','2022-08-29 03:33:31',11,NULL,NULL,10873,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0603 validada','Autor: gdealba\nFactura FA2208-0603 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,628,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1929,1929,NULL,1,'2022-08-29 15:34:10','2022-08-29 15:34:10',40,'AC_BILL_VALIDATE','2022-08-29 15:34:10','2022-08-29 03:34:10',11,NULL,NULL,10972,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0604 validada','Autor: gdealba\nFactura FA2208-0604 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,629,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1930,1930,NULL,1,'2022-08-29 15:34:56','2022-08-29 15:34:56',40,'AC_BILL_VALIDATE','2022-08-29 15:34:56','2022-08-29 03:34:56',11,NULL,NULL,10973,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0605 validada','Autor: gdealba\nFactura FA2208-0605 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,630,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1931,1931,NULL,1,'2022-08-29 15:35:49','2022-08-29 15:35:49',40,'AC_BILL_VALIDATE','2022-08-29 15:35:49','2022-08-29 03:35:49',11,NULL,NULL,10976,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0606 validada','Autor: gdealba\nFactura FA2208-0606 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,631,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1932,1932,NULL,1,'2022-08-29 15:36:58','2022-08-29 15:36:58',40,'AC_BILL_VALIDATE','2022-08-29 15:36:58','2022-08-29 03:36:58',11,NULL,NULL,11112,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0607 validada','Autor: gdealba\nFactura FA2208-0607 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,632,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1933,1933,NULL,1,'2022-08-29 15:38:05','2022-08-29 15:38:05',40,'AC_BILL_VALIDATE','2022-08-29 15:38:05','2022-08-29 03:38:05',11,NULL,NULL,11113,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0608 validada','Autor: gdealba\nFactura FA2208-0608 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,633,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1934,1934,NULL,1,'2022-08-29 15:38:49','2022-08-29 15:38:49',40,'AC_BILL_VALIDATE','2022-08-29 15:38:49','2022-08-29 03:38:49',11,NULL,NULL,11115,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0609 validada','Autor: gdealba\nFactura FA2208-0609 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,634,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1935,1935,NULL,1,'2022-08-29 15:39:49','2022-08-29 15:39:49',40,'AC_BILL_VALIDATE','2022-08-29 15:39:49','2022-08-29 03:39:49',11,NULL,NULL,11211,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0610 validada','Autor: gdealba\nFactura FA2208-0610 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,635,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1936,1936,NULL,1,'2022-08-29 15:40:38','2022-08-29 15:40:38',40,'AC_BILL_VALIDATE','2022-08-29 15:40:38','2022-08-29 03:40:38',11,NULL,NULL,12282,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0611 validada','Autor: gdealba\nFactura FA2208-0611 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,636,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1937,1937,NULL,1,'2022-08-29 15:41:41','2022-08-29 15:41:41',40,'AC_BILL_VALIDATE','2022-08-29 15:41:41','2022-08-29 03:41:41',11,NULL,NULL,12982,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0612 validada','Autor: gdealba\nFactura FA2208-0612 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,637,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1938,1938,NULL,1,'2022-08-29 15:43:04','2022-08-29 15:43:04',40,'AC_BILL_VALIDATE','2022-08-29 15:43:04','2022-08-29 03:43:04',11,NULL,NULL,13120,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0613 validada','Autor: gdealba\nFactura FA2208-0613 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,638,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1939,1939,NULL,1,'2022-08-29 15:44:12','2022-08-29 15:44:12',40,'AC_BILL_VALIDATE','2022-08-29 15:44:12','2022-08-29 03:44:12',11,NULL,NULL,13142,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0614 validada','Autor: gdealba\nFactura FA2208-0614 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,639,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1940,1940,NULL,1,'2022-08-29 15:45:10','2022-08-29 15:45:10',40,'AC_BILL_VALIDATE','2022-08-29 15:45:10','2022-08-29 03:45:10',11,NULL,NULL,13380,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0615 validada','Autor: gdealba\nFactura FA2208-0615 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,640,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1941,1941,NULL,1,'2022-08-29 15:45:58','2022-08-29 15:45:58',40,'AC_BILL_VALIDATE','2022-08-29 15:45:58','2022-08-29 03:45:58',11,NULL,NULL,13589,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0616 validada','Autor: gdealba\nFactura FA2208-0616 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,641,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1942,1942,NULL,1,'2022-08-29 15:49:27','2022-08-29 15:49:27',40,'AC_BILL_VALIDATE','2022-08-29 15:49:27','2022-08-29 03:49:27',11,NULL,NULL,14370,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0617 validada','Autor: gdealba\nFactura FA2208-0617 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,642,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1943,1943,NULL,1,'2022-08-29 15:51:05','2022-08-29 15:51:05',40,'AC_COMPANY_CREATE','2022-08-29 15:51:05','2022-08-29 03:51:05',11,NULL,NULL,14371,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Tercero PUBLICO EN GENERAL R68 creado','Autor: gdealba\nTercero PUBLICO EN GENERAL R68 creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1944,1944,NULL,1,'2022-08-29 15:51:52','2022-08-29 15:51:52',40,'AC_BILL_VALIDATE','2022-08-29 15:51:52','2022-08-29 03:51:52',11,NULL,NULL,14371,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0618 validada','Autor: gdealba\nFactura FA2208-0618 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,643,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1945,1945,NULL,1,'2022-08-29 17:16:54','2022-08-29 17:16:54',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-29 17:16:54','2022-08-29 05:16:54',6,NULL,NULL,3,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0076 validada','Autor: egarcia\nFactura SI2208-0076 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,104,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1946,1946,NULL,1,'2022-08-29 17:30:30','2022-08-29 17:30:30',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-29 17:30:30','2022-08-29 05:30:30',6,NULL,NULL,4,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0077 validada','Autor: egarcia\nFactura SI2208-0077 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,105,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1947,1947,NULL,1,'2022-08-29 19:15:26','2022-08-29 19:15:26',40,'AC_BILL_VALIDATE','2022-08-29 19:15:26','2022-08-29 07:15:26',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0619 validada','Autor: egarcia\nFactura FA2208-0619 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,644,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1948,1948,NULL,1,'2022-08-29 19:31:21','2022-08-29 19:31:21',40,'AC_PRODUCT_MODIFY','2022-08-29 19:31:21','2022-08-29 07:31:21',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BISUR700G modificado','Autor: admin\nProducto BISUR700G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,216,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1949,1949,NULL,1,'2022-08-29 20:37:12','2022-08-29 20:37:12',40,'AC_PRODUCT_MODIFY','2022-08-29 20:37:12','2022-08-29 08:37:12',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR100G modificado','Autor: admin\nProducto BPGR100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,279,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1950,1950,NULL,1,'2022-08-29 20:46:26','2022-08-29 20:46:26',40,'AC_PRODUCT_MODIFY','2022-08-29 20:46:26','2022-08-29 08:46:26',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPARROZ500G modificado','Autor: admin\nProducto BPARROZ500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,281,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1951,1951,NULL,1,'2022-08-29 20:47:09','2022-08-29 20:47:09',40,'AC_PRODUCT_MODIFY','2022-08-29 20:47:09','2022-08-29 08:47:09',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPARROZ500G modificado','Autor: admin\nProducto BPARROZ500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,281,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1952,1952,NULL,1,'2022-08-29 20:47:53','2022-08-29 20:47:53',40,'AC_PRODUCT_MODIFY','2022-08-29 20:47:53','2022-08-29 08:47:53',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPARROZ900G modificado','Autor: admin\nProducto BPARROZ900G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,282,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1953,1953,NULL,1,'2022-08-29 20:48:01','2022-08-29 20:48:01',40,'AC_PRODUCT_MODIFY','2022-08-29 20:48:01','2022-08-29 08:48:01',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPARROZ900G modificado','Autor: admin\nProducto BPARROZ900G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,282,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1954,1954,NULL,1,'2022-08-29 20:50:05','2022-08-29 20:50:05',40,'AC_PRODUCT_MODIFY','2022-08-29 20:50:05','2022-08-29 08:50:05',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BISUR700G modificado','Autor: admin\nProducto BISUR700G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,216,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1955,1955,NULL,1,'2022-08-29 20:50:17','2022-08-29 20:50:17',40,'AC_PRODUCT_MODIFY','2022-08-29 20:50:17','2022-08-29 08:50:17',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BISUR700G modificado','Autor: admin\nProducto BISUR700G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,216,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1956,1956,NULL,1,'2022-08-29 20:54:52','2022-08-29 20:54:52',40,'AC_PRODUCT_MODIFY','2022-08-29 20:54:52','2022-08-29 08:54:52',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BISUS600G modificado','Autor: admin\nProducto BISUS600G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,217,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1957,1957,NULL,1,'2022-08-29 20:55:18','2022-08-29 20:55:18',40,'AC_BILL_DELETE','2022-08-29 20:55:18','2022-08-29 08:55:18',1,NULL,NULL,14362,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Factura eliminada','Autor: admin\nFactura eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,645,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1958,1958,NULL,1,'2022-08-29 20:55:43','2022-08-29 20:55:43',40,'AC_PRODUCT_MODIFY','2022-08-29 20:55:43','2022-08-29 08:55:43',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPMA400G modificado','Autor: admin\nProducto BPMA400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,210,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1959,1959,NULL,1,'2022-08-29 20:56:26','2022-08-29 20:56:26',40,'AC_PRODUCT_MODIFY','2022-08-29 20:56:26','2022-08-29 08:56:26',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPFL336G modificado','Autor: admin\nProducto BPFL336G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,212,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1960,1960,NULL,1,'2022-08-29 20:57:06','2022-08-29 20:57:06',40,'AC_PRODUCT_MODIFY','2022-08-29 20:57:06','2022-08-29 08:57:06',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR500G modificado','Autor: admin\nProducto BPGR500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,205,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1961,1961,NULL,1,'2022-08-29 20:57:55','2022-08-29 20:57:55',40,'AC_PRODUCT_MODIFY','2022-08-29 20:57:55','2022-08-29 08:57:55',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CECINAL40G modificado','Autor: admin\nProducto CECINAL40G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,231,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1962,1962,NULL,1,'2022-08-29 20:58:30','2022-08-29 20:58:30',40,'AC_BILL_VALIDATE','2022-08-29 20:58:30','2022-08-29 08:58:30',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0620 validada','Autor: egarcia\nFactura FA2208-0620 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,646,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1963,1963,NULL,1,'2022-08-29 20:59:06','2022-08-29 20:59:06',40,'AC_PRODUCT_MODIFY','2022-08-29 20:59:06','2022-08-29 08:59:06',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPNU400G modificado','Autor: admin\nProducto BPNU400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,211,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1964,1964,NULL,1,'2022-08-29 20:59:39','2022-08-29 20:59:39',40,'AC_BILL_VALIDATE','2022-08-29 20:59:39','2022-08-29 08:59:39',6,NULL,NULL,13745,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0621 validada','Autor: egarcia\nFactura FA2208-0621 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,647,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1965,1965,NULL,1,'2022-08-29 20:59:52','2022-08-29 20:59:52',40,'AC_PRODUCT_MODIFY','2022-08-29 20:59:52','2022-08-29 08:59:52',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPMI500G modificado','Autor: admin\nProducto BPMI500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,206,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1966,1966,NULL,1,'2022-08-29 21:00:48','2022-08-29 21:00:48',40,'AC_PRODUCT_MODIFY','2022-08-29 21:00:48','2022-08-29 09:00:48',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR100G modificado','Autor: admin\nProducto BPGR100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,279,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1967,1967,NULL,1,'2022-08-29 21:01:28','2022-08-29 21:01:28',40,'AC_PRODUCT_MODIFY','2022-08-29 21:01:28','2022-08-29 09:01:28',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPPIZ100G modificado','Autor: admin\nProducto BPPIZ100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,278,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1968,1968,NULL,1,'2022-08-29 21:03:18','2022-08-29 21:03:18',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-29 21:03:18','2022-08-29 09:03:18',6,NULL,NULL,3,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0078 validada','Autor: egarcia\nFactura SI2208-0078 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,106,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1969,1969,NULL,1,'2022-08-29 21:03:35','2022-08-29 21:03:35',40,'AC_PRODUCT_MODIFY','2022-08-29 21:03:35','2022-08-29 09:03:35',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPAVE500G modificado','Autor: admin\nProducto BPAVE500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,203,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1970,1970,NULL,1,'2022-08-29 21:04:51','2022-08-29 21:04:51',40,'AC_BILL_VALIDATE','2022-08-29 21:04:51','2022-08-29 09:04:51',11,NULL,NULL,10865,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0622 validada','Autor: gdealba\nFactura FA2208-0622 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,648,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1971,1971,NULL,1,'2022-08-29 21:04:52','2022-08-29 21:04:52',40,'AC_PRODUCT_MODIFY','2022-08-29 21:04:52','2022-08-29 09:04:52',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPLYA400G modificado','Autor: admin\nProducto BPLYA400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,208,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1972,1972,NULL,1,'2022-08-29 21:06:04','2022-08-29 21:06:04',40,'AC_PRODUCT_MODIFY','2022-08-29 21:06:04','2022-08-29 09:06:04',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BP_BARRA_DE_COCO_400g modificado','Autor: admin\nProducto BP_BARRA_DE_COCO_400g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,214,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1973,1973,NULL,1,'2022-08-29 21:07:09','2022-08-29 21:07:09',40,'AC_PRODUCT_MODIFY','2022-08-29 21:07:09','2022-08-29 09:07:09',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BNPPIZ336G modificado','Autor: admin\nProducto BNPPIZ336G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,215,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1974,1974,NULL,1,'2022-08-29 21:09:12','2022-08-29 21:09:12',40,'AC_BILL_VALIDATE','2022-08-29 21:09:12','2022-08-29 09:09:12',11,NULL,NULL,10866,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0623 validada','Autor: gdealba\nFactura FA2208-0623 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,649,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1975,1975,NULL,1,'2022-08-29 21:09:45','2022-08-29 21:09:45',40,'AC_PRODUCT_MODIFY','2022-08-29 21:09:45','2022-08-29 09:09:45',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CECINA modificado','Autor: admin\nProducto CECINA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,336,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1976,1976,NULL,1,'2022-08-29 21:09:53','2022-08-29 21:09:53',40,'AC_BILL_VALIDATE','2022-08-29 21:09:53','2022-08-29 09:09:53',11,NULL,NULL,10870,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0624 validada','Autor: gdealba\nFactura FA2208-0624 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,650,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1977,1977,NULL,1,'2022-08-29 21:10:01','2022-08-29 21:10:01',40,'AC_PRODUCT_MODIFY','2022-08-29 21:10:01','2022-08-29 09:10:01',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CECINA modificado','Autor: admin\nProducto CECINA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,336,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1978,1978,NULL,1,'2022-08-29 21:10:47','2022-08-29 21:10:47',40,'AC_PRODUCT_MODIFY','2022-08-29 21:10:47','2022-08-29 09:10:47',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGCH400G modificado','Autor: admin\nProducto BPGCH400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,280,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1979,1979,NULL,1,'2022-08-29 21:10:53','2022-08-29 21:10:53',40,'AC_PRODUCT_MODIFY','2022-08-29 21:10:53','2022-08-29 09:10:53',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGCH400G modificado','Autor: admin\nProducto BPGCH400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,280,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1980,1980,NULL,1,'2022-08-29 21:10:57','2022-08-29 21:10:57',40,'AC_BILL_VALIDATE','2022-08-29 21:10:57','2022-08-29 09:10:57',11,NULL,NULL,10874,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0625 validada','Autor: gdealba\nFactura FA2208-0625 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,651,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1981,1981,NULL,1,'2022-08-29 21:11:41','2022-08-29 21:11:41',40,'AC_PRODUCT_MODIFY','2022-08-29 21:11:41','2022-08-29 09:11:41',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CECINAA40G modificado','Autor: admin\nProducto CECINAA40G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,232,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1982,1982,NULL,1,'2022-08-29 21:18:54','2022-08-29 21:18:54',40,'AC_BILL_VALIDATE','2022-08-29 21:18:54','2022-08-29 09:18:54',11,NULL,NULL,10977,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0626 validada','Autor: gdealba\nFactura FA2208-0626 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,652,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1983,1983,NULL,1,'2022-08-29 21:23:23','2022-08-29 21:23:23',40,'AC_BILL_VALIDATE','2022-08-29 21:23:23','2022-08-29 09:23:23',11,NULL,NULL,11116,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0627 validada','Autor: gdealba\nFactura FA2208-0627 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,653,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1984,1984,NULL,1,'2022-08-29 21:24:17','2022-08-29 21:24:17',40,'AC_BILL_VALIDATE','2022-08-29 21:24:17','2022-08-29 09:24:17',11,NULL,NULL,12374,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0628 validada','Autor: gdealba\nFactura FA2208-0628 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,654,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1985,1985,NULL,1,'2022-08-29 21:24:52','2022-08-29 21:24:52',40,'AC_BILL_VALIDATE','2022-08-29 21:24:52','2022-08-29 09:24:52',11,NULL,NULL,12608,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0629 validada','Autor: gdealba\nFactura FA2208-0629 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,655,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1986,1986,NULL,1,'2022-08-29 21:25:34','2022-08-29 21:25:34',40,'AC_BILL_VALIDATE','2022-08-29 21:25:34','2022-08-29 09:25:34',11,NULL,NULL,12725,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0630 validada','Autor: gdealba\nFactura FA2208-0630 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,656,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1987,1987,NULL,1,'2022-08-29 21:26:28','2022-08-29 21:26:28',40,'AC_BILL_VALIDATE','2022-08-29 21:26:28','2022-08-29 09:26:28',11,NULL,NULL,12899,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0631 validada','Autor: gdealba\nFactura FA2208-0631 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,657,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1988,1988,NULL,1,'2022-08-29 21:27:31','2022-08-29 21:27:31',40,'AC_BILL_VALIDATE','2022-08-29 21:27:31','2022-08-29 09:27:31',11,NULL,NULL,12995,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0632 validada','Autor: gdealba\nFactura FA2208-0632 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,658,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1989,1989,NULL,1,'2022-08-29 21:28:35','2022-08-29 21:28:35',40,'AC_BILL_VALIDATE','2022-08-29 21:28:35','2022-08-29 09:28:35',11,NULL,NULL,13133,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0633 validada','Autor: gdealba\nFactura FA2208-0633 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,659,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1990,1990,NULL,1,'2022-08-29 21:28:54','2022-08-29 21:28:54',40,'AC_PRODUCT_MODIFY','2022-08-29 21:28:54','2022-08-29 09:28:54',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CECINAH40G modificado','Autor: admin\nProducto CECINAH40G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,233,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1991,1991,NULL,1,'2022-08-29 21:33:18','2022-08-29 21:33:18',40,'AC_PRODUCT_MODIFY','2022-08-29 21:33:18','2022-08-29 09:33:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPOR200G modificado','Autor: admin\nProducto BPOR200G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,213,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1992,1992,NULL,1,'2022-08-29 21:33:46','2022-08-29 21:33:46',40,'AC_PRODUCT_MODIFY','2022-08-29 21:33:46','2022-08-29 09:33:46',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPAVE100G modificado','Autor: admin\nProducto BPAVE100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,219,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1993,1993,NULL,1,'2022-08-29 21:34:10','2022-08-29 21:34:10',40,'AC_PRODUCT_MODIFY','2022-08-29 21:34:10','2022-08-29 09:34:10',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPAA350G modificado','Autor: admin\nProducto BPAA350G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,209,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1994,1994,NULL,1,'2022-08-29 21:36:31','2022-08-29 21:36:31',40,'AC_PRODUCT_MODIFY','2022-08-29 21:36:31','2022-08-29 09:36:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto PIZCA_DE_CHOCOLATE_Granel modificado','Autor: admin\nProducto PIZCA_DE_CHOCOLATE_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,199,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1995,1995,NULL,1,'2022-08-29 21:38:34','2022-08-29 21:38:34',40,'AC_PRODUCT_MODIFY','2022-08-29 21:38:34','2022-08-29 09:38:34',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTPF100G modificado','Autor: admin\nProducto BTPF100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,337,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1996,1996,NULL,1,'2022-08-29 21:40:21','2022-08-29 21:40:21',40,'AC_BILL_VALIDATE','2022-08-29 21:40:21','2022-08-29 09:40:21',11,NULL,NULL,13134,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0634 validada','Autor: gdealba\nFactura FA2208-0634 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,660,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1997,1997,NULL,1,'2022-08-29 21:40:59','2022-08-29 21:40:59',40,'AC_BILL_VALIDATE','2022-08-29 21:40:59','2022-08-29 09:40:59',11,NULL,NULL,13134,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0635 validada','Autor: gdealba\nFactura FA2208-0635 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,661,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1998,1998,NULL,1,'2022-08-29 21:41:40','2022-08-29 21:41:40',40,'AC_BILL_VALIDATE','2022-08-29 21:41:40','2022-08-29 09:41:40',11,NULL,NULL,14370,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0636 validada','Autor: gdealba\nFactura FA2208-0636 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,662,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (1999,1999,NULL,1,'2022-08-29 21:47:51','2022-08-29 21:47:51',40,'AC_PRODUCT_MODIFY','2022-08-29 21:47:51','2022-08-29 09:47:51',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTBM80G modificado','Autor: admin\nProducto BTBM80G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,225,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2000,2000,NULL,1,'2022-08-29 21:47:56','2022-08-29 21:47:56',40,'AC_PRODUCT_MODIFY','2022-08-29 21:47:56','2022-08-29 09:47:56',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTCFC90G modificado','Autor: admin\nProducto BTCFC90G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,224,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2001,2001,NULL,1,'2022-08-29 21:48:03','2022-08-29 21:48:03',40,'AC_PRODUCT_MODIFY','2022-08-29 21:48:03','2022-08-29 09:48:03',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTCHM100G modificado','Autor: admin\nProducto BTCHM100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,222,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2002,2002,NULL,1,'2022-08-29 21:48:09','2022-08-29 21:48:09',40,'AC_PRODUCT_MODIFY','2022-08-29 21:48:09','2022-08-29 09:48:09',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTCHB100G modificado','Autor: admin\nProducto BTCHB100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,221,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2003,2003,NULL,1,'2022-08-29 21:49:58','2022-08-29 21:49:58',40,'AC_PRODUCT_MODIFY','2022-08-29 21:49:58','2022-08-29 09:49:58',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BTCT80G modificado','Autor: admin\nProducto BTCT80G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,227,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2004,2004,NULL,1,'2022-08-29 21:51:19','2022-08-29 21:51:19',40,'AC_PRODUCT_MODIFY','2022-08-29 21:51:19','2022-08-29 09:51:19',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPTDF84G modificado','Autor: admin\nProducto BPTDF84G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,230,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2005,2005,NULL,1,'2022-08-29 21:51:25','2022-08-29 21:51:25',40,'AC_PRODUCT_MODIFY','2022-08-29 21:51:25','2022-08-29 09:51:25',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPTDP84G modificado','Autor: admin\nProducto BPTDP84G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,229,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2006,2006,NULL,1,'2022-08-29 21:51:30','2022-08-29 21:51:30',40,'AC_PRODUCT_MODIFY','2022-08-29 21:51:30','2022-08-29 09:51:30',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR400G modificado','Autor: admin\nProducto BPGR400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,338,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2007,2007,NULL,1,'2022-08-29 22:29:23','2022-08-29 22:29:23',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-29 22:29:23','2022-08-29 10:29:23',4,NULL,NULL,4,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0079 validada','Autor: yrodriguez\nFactura SI2208-0079 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,107,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2008,2008,NULL,1,'2022-08-29 23:08:21','2022-08-29 23:08:21',40,'AC_BILL_UNVALIDATE','2022-08-29 23:08:21','2022-08-29 11:08:21',11,NULL,NULL,13138,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura FA2208-0519 al estado de borrador','Autor: gdealba\nRegresar factura FA2208-0519 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,544,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2009,2009,NULL,1,'2022-08-29 23:18:59','2022-08-29 23:18:59',40,'AC_BILL_VALIDATE','2022-08-29 23:18:59','2022-08-29 11:18:59',11,NULL,NULL,13138,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0519 validada','Autor: gdealba\nFactura FA2208-0519 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,544,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2010,2010,NULL,1,'2022-08-30 01:23:14','2022-08-30 01:23:14',40,'AC_BILL_VALIDATE','2022-08-30 01:23:14','2022-08-29 13:23:14',4,NULL,NULL,13745,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0637 validada','Autor: yrodriguez\nFactura FA2208-0637 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,663,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2011,2011,NULL,1,'2022-08-30 02:07:30','2022-08-30 02:07:30',40,'AC_BILL_VALIDATE','2022-08-30 02:07:30','2022-08-29 14:07:30',4,NULL,NULL,13746,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0638 validada','Autor: yrodriguez\nFactura FA2208-0638 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,664,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2012,2012,NULL,1,'2022-08-30 02:09:32','2022-08-30 02:09:32',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-30 02:09:32','2022-08-29 14:09:32',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0080 validada','Autor: yrodriguez\nFactura SI2208-0080 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,108,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2013,2013,NULL,1,'2022-08-30 02:10:00','2022-08-30 02:10:00',40,'AC_BILL_VALIDATE','2022-08-30 02:10:00','2022-08-29 14:10:00',4,NULL,NULL,13746,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0639 validada','Autor: yrodriguez\nFactura FA2208-0639 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,665,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2014,2014,NULL,1,'2022-08-30 02:17:26','2022-08-30 02:17:26',40,'AC_BILL_UNVALIDATE','2022-08-30 02:17:26','2022-08-29 14:17:26',11,NULL,NULL,13138,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura FA2208-0519 al estado de borrador','Autor: gdealba\nRegresar factura FA2208-0519 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,544,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2015,2015,NULL,1,'2022-08-30 02:18:21','2022-08-30 02:18:21',40,'AC_BILL_VALIDATE','2022-08-30 02:18:21','2022-08-29 14:18:21',11,NULL,NULL,10780,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0640 validada','Autor: gdealba\nFactura FA2208-0640 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,666,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2016,2016,NULL,1,'2022-08-30 02:22:54','2022-08-30 02:22:54',40,'AC_BILL_VALIDATE','2022-08-30 02:22:54','2022-08-29 14:22:54',11,NULL,NULL,14160,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0641 validada','Autor: gdealba\nFactura FA2208-0641 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,667,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2017,2017,NULL,1,'2022-08-30 02:24:44','2022-08-30 02:24:44',40,'AC_BILL_VALIDATE','2022-08-30 02:24:44','2022-08-29 14:24:44',11,NULL,NULL,14167,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0642 validada','Autor: gdealba\nFactura FA2208-0642 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,668,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2018,2018,NULL,1,'2022-08-30 02:25:57','2022-08-30 02:25:57',40,'AC_BILL_VALIDATE','2022-08-30 02:25:57','2022-08-29 14:25:57',11,NULL,NULL,11055,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0643 validada','Autor: gdealba\nFactura FA2208-0643 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,669,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2019,2019,NULL,1,'2022-08-30 02:26:59','2022-08-30 02:26:59',40,'AC_BILL_VALIDATE','2022-08-30 02:26:59','2022-08-29 14:26:59',11,NULL,NULL,11689,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0644 validada','Autor: gdealba\nFactura FA2208-0644 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,670,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2020,2020,NULL,1,'2022-08-30 02:28:10','2022-08-30 02:28:10',40,'AC_BILL_VALIDATE','2022-08-30 02:28:10','2022-08-29 14:28:10',11,NULL,NULL,12267,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0645 validada','Autor: gdealba\nFactura FA2208-0645 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,671,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2021,2021,NULL,1,'2022-08-30 02:28:59','2022-08-30 02:28:59',40,'AC_BILL_VALIDATE','2022-08-30 02:28:59','2022-08-29 14:28:59',11,NULL,NULL,12267,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0646 validada','Autor: gdealba\nFactura FA2208-0646 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,672,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2022,2022,NULL,1,'2022-08-30 02:29:32','2022-08-30 02:29:32',40,'AC_BILL_VALIDATE','2022-08-30 02:29:32','2022-08-29 14:29:32',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0647 validada','Autor: egarcia\nFactura FA2208-0647 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,673,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2023,2023,NULL,1,'2022-08-30 02:29:46','2022-08-30 02:29:46',40,'AC_BILL_VALIDATE','2022-08-30 02:29:46','2022-08-29 14:29:46',11,NULL,NULL,12549,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0648 validada','Autor: gdealba\nFactura FA2208-0648 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,674,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2024,2024,NULL,1,'2022-08-30 02:30:54','2022-08-30 02:30:54',40,'AC_BILL_VALIDATE','2022-08-30 02:30:54','2022-08-29 14:30:54',11,NULL,NULL,12750,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0649 validada','Autor: gdealba\nFactura FA2208-0649 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,675,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2025,2025,NULL,1,'2022-08-30 02:37:05','2022-08-30 02:37:05',40,'AC_BILL_VALIDATE','2022-08-30 02:37:05','2022-08-29 14:37:05',11,NULL,NULL,12980,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0650 validada','Autor: gdealba\nFactura FA2208-0650 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,676,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2026,2026,NULL,1,'2022-08-30 03:36:37','2022-08-30 03:36:37',40,'AC_BILL_VALIDATE','2022-08-30 03:36:37','2022-08-29 15:36:37',4,NULL,NULL,12033,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0651 validada','Autor: yrodriguez\nFactura FA2208-0651 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,677,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2027,2027,NULL,1,'2022-08-30 12:24:15','2022-08-30 12:24:15',40,'AC_BILL_UNVALIDATE','2022-08-30 12:24:15','2022-08-30 00:24:15',4,NULL,NULL,13745,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura FA2208-0637 al estado de borrador','Autor: yrodriguez\nRegresar factura FA2208-0637 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,663,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2028,2028,NULL,1,'2022-08-30 12:29:31','2022-08-30 12:29:31',40,'AC_BILL_VALIDATE','2022-08-30 12:29:31','2022-08-30 00:29:31',4,NULL,NULL,13745,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0637 validada','Autor: yrodriguez\nFactura FA2208-0637 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,663,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2029,2029,NULL,1,'2022-08-30 12:33:30','2022-08-30 12:33:30',40,'AC_BILL_SUPPLIER_UNVALIDATE','2022-08-30 12:33:30','2022-08-30 00:33:30',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura SI2208-0075 al estado de borrador','Autor: yrodriguez\nRegresar factura SI2208-0075 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,103,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2030,2030,NULL,1,'2022-08-30 12:34:59','2022-08-30 12:34:59',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-30 12:34:59','2022-08-30 00:34:59',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0075 validada','Autor: yrodriguez\nFactura SI2208-0075 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,103,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2031,2031,NULL,1,'2022-08-30 12:40:36','2022-08-30 12:40:36',40,'AC_BILL_UNVALIDATE','2022-08-30 12:40:36','2022-08-30 00:40:36',4,NULL,NULL,13746,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura FA2208-0456 al estado de borrador','Autor: yrodriguez\nRegresar factura FA2208-0456 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,479,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2032,2032,NULL,1,'2022-08-30 12:41:20','2022-08-30 12:41:20',40,'AC_BILL_VALIDATE','2022-08-30 12:41:20','2022-08-30 00:41:20',4,NULL,NULL,13746,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0456 validada','Autor: yrodriguez\nFactura FA2208-0456 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,479,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2033,2033,NULL,1,'2022-08-30 12:48:56','2022-08-30 12:48:56',40,'AC_BILL_SUPPLIER_UNVALIDATE','2022-08-30 12:48:56','2022-08-30 00:48:56',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura SI2208-0075 al estado de borrador','Autor: yrodriguez\nRegresar factura SI2208-0075 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,103,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2034,2034,NULL,1,'2022-08-30 12:49:27','2022-08-30 12:49:27',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-30 12:49:27','2022-08-30 00:49:27',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0075 validada','Autor: yrodriguez\nFactura SI2208-0075 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,103,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2035,2035,NULL,1,'2022-08-30 12:49:55','2022-08-30 12:49:55',40,'AC_BILL_UNVALIDATE','2022-08-30 12:49:55','2022-08-30 00:49:55',4,NULL,NULL,13745,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura FA2208-0637 al estado de borrador','Autor: yrodriguez\nRegresar factura FA2208-0637 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,663,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2036,2036,NULL,1,'2022-08-30 12:50:07','2022-08-30 12:50:07',40,'AC_BILL_VALIDATE','2022-08-30 12:50:07','2022-08-30 00:50:07',4,NULL,NULL,13745,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0637 validada','Autor: yrodriguez\nFactura FA2208-0637 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,663,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2037,2037,NULL,1,'2022-08-30 12:51:21','2022-08-30 12:51:21',40,'AC_BILL_SUPPLIER_UNVALIDATE','2022-08-30 12:51:21','2022-08-30 00:51:21',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Regresar factura SI2208-0075 al estado de borrador','Autor: yrodriguez\nRegresar factura SI2208-0075 al estado de borrador',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,103,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2038,2038,NULL,1,'2022-08-30 12:51:41','2022-08-30 12:51:41',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-30 12:51:41','2022-08-30 00:51:41',4,NULL,NULL,3,NULL,0,4,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0075 validada','Autor: yrodriguez\nFactura SI2208-0075 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,103,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2039,2039,NULL,1,'2022-08-30 14:44:44','2022-08-30 14:44:44',40,'AC_BILL_VALIDATE','2022-08-30 14:44:44','2022-08-30 02:44:44',11,NULL,NULL,13972,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0652 validada','Autor: gdealba\nFactura FA2208-0652 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,678,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2040,2040,NULL,1,'2022-08-30 14:46:40','2022-08-30 14:46:40',40,'AC_BILL_VALIDATE','2022-08-30 14:46:40','2022-08-30 02:46:40',11,NULL,NULL,14005,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0653 validada','Autor: gdealba\nFactura FA2208-0653 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,679,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2041,2041,NULL,1,'2022-08-30 14:47:44','2022-08-30 14:47:44',40,'AC_BILL_VALIDATE','2022-08-30 14:47:44','2022-08-30 02:47:44',11,NULL,NULL,13829,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0654 validada','Autor: gdealba\nFactura FA2208-0654 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,680,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2042,2042,NULL,1,'2022-08-30 14:48:48','2022-08-30 14:48:48',40,'AC_BILL_VALIDATE','2022-08-30 14:48:48','2022-08-30 02:48:48',11,NULL,NULL,11004,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0655 validada','Autor: gdealba\nFactura FA2208-0655 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,681,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2043,2043,NULL,1,'2022-08-30 14:49:45','2022-08-30 14:49:45',40,'AC_BILL_VALIDATE','2022-08-30 14:49:45','2022-08-30 02:49:45',11,NULL,NULL,11039,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0656 validada','Autor: gdealba\nFactura FA2208-0656 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,682,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2044,2044,NULL,1,'2022-08-30 14:50:49','2022-08-30 14:50:49',40,'AC_BILL_VALIDATE','2022-08-30 14:50:49','2022-08-30 02:50:49',11,NULL,NULL,11213,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0657 validada','Autor: gdealba\nFactura FA2208-0657 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,683,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2045,2045,NULL,1,'2022-08-30 14:52:02','2022-08-30 14:52:02',40,'AC_BILL_VALIDATE','2022-08-30 14:52:02','2022-08-30 02:52:02',11,NULL,NULL,11214,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0658 validada','Autor: gdealba\nFactura FA2208-0658 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,684,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2046,2046,NULL,1,'2022-08-30 14:53:43','2022-08-30 14:53:43',40,'AC_BILL_VALIDATE','2022-08-30 14:53:43','2022-08-30 02:53:43',11,NULL,NULL,11629,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0659 validada','Autor: gdealba\nFactura FA2208-0659 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,685,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2047,2047,NULL,1,'2022-08-30 14:55:03','2022-08-30 14:55:03',40,'AC_BILL_VALIDATE','2022-08-30 14:55:03','2022-08-30 02:55:03',11,NULL,NULL,12710,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0660 validada','Autor: gdealba\nFactura FA2208-0660 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,686,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2048,2048,NULL,1,'2022-08-30 14:55:57','2022-08-30 14:55:57',40,'AC_BILL_VALIDATE','2022-08-30 14:55:57','2022-08-30 02:55:57',11,NULL,NULL,12724,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0661 validada','Autor: gdealba\nFactura FA2208-0661 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,687,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2049,2049,NULL,1,'2022-08-30 14:56:41','2022-08-30 14:56:41',40,'AC_BILL_VALIDATE','2022-08-30 14:56:41','2022-08-30 02:56:41',11,NULL,NULL,13489,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0662 validada','Autor: gdealba\nFactura FA2208-0662 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,688,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2050,2050,NULL,1,'2022-08-30 14:58:22','2022-08-30 14:58:22',40,'AC_BILL_VALIDATE','2022-08-30 14:58:22','2022-08-30 02:58:22',11,NULL,NULL,13584,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0663 validada','Autor: gdealba\nFactura FA2208-0663 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,689,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2051,2051,NULL,1,'2022-08-30 15:00:05','2022-08-30 15:00:05',40,'AC_BILL_VALIDATE','2022-08-30 15:00:05','2022-08-30 03:00:05',11,NULL,NULL,13610,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0664 validada','Autor: gdealba\nFactura FA2208-0664 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,690,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2052,2052,NULL,1,'2022-08-30 15:00:59','2022-08-30 15:00:59',40,'AC_BILL_VALIDATE','2022-08-30 15:00:59','2022-08-30 03:00:59',11,NULL,NULL,14366,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0665 validada','Autor: gdealba\nFactura FA2208-0665 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,691,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2053,2053,NULL,1,'2022-08-30 15:01:34','2022-08-30 15:01:34',40,'AC_BILL_VALIDATE','2022-08-30 15:01:34','2022-08-30 03:01:34',11,NULL,NULL,14366,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0666 validada','Autor: gdealba\nFactura FA2208-0666 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,692,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2054,2054,NULL,1,'2022-08-30 15:02:27','2022-08-30 15:02:27',40,'AC_BILL_VALIDATE','2022-08-30 15:02:27','2022-08-30 03:02:27',11,NULL,NULL,14366,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0667 validada','Autor: gdealba\nFactura FA2208-0667 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,693,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2055,2055,NULL,1,'2022-08-30 15:05:32','2022-08-30 15:05:32',40,'AC_BILL_VALIDATE','2022-08-30 15:05:32','2022-08-30 03:05:32',11,NULL,NULL,13936,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0668 validada','Autor: gdealba\nFactura FA2208-0668 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,694,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2056,2056,NULL,1,'2022-08-30 15:06:37','2022-08-30 15:06:37',40,'AC_BILL_VALIDATE','2022-08-30 15:06:37','2022-08-30 03:06:37',11,NULL,NULL,14018,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0669 validada','Autor: gdealba\nFactura FA2208-0669 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,695,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2057,2057,NULL,1,'2022-08-30 15:08:02','2022-08-30 15:08:02',40,'AC_BILL_VALIDATE','2022-08-30 15:08:02','2022-08-30 03:08:02',11,NULL,NULL,13838,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0670 validada','Autor: gdealba\nFactura FA2208-0670 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,696,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2058,2058,NULL,1,'2022-08-30 15:09:54','2022-08-30 15:09:54',40,'AC_BILL_VALIDATE','2022-08-30 15:09:54','2022-08-30 03:09:54',11,NULL,NULL,13838,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0671 validada','Autor: gdealba\nFactura FA2208-0671 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,697,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2059,2059,NULL,1,'2022-08-30 15:15:00','2022-08-30 15:15:00',40,'AC_BILL_VALIDATE','2022-08-30 15:15:00','2022-08-30 03:15:00',11,NULL,NULL,13717,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0672 validada','Autor: gdealba\nFactura FA2208-0672 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,698,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2060,2060,NULL,1,'2022-08-30 15:18:16','2022-08-30 15:18:16',40,'AC_BILL_VALIDATE','2022-08-30 15:18:16','2022-08-30 03:18:16',11,NULL,NULL,14332,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0673 validada','Autor: gdealba\nFactura FA2208-0673 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,699,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2061,2061,NULL,1,'2022-08-30 15:23:14','2022-08-30 15:23:14',40,'AC_BILL_VALIDATE','2022-08-30 15:23:14','2022-08-30 03:23:14',11,NULL,NULL,11151,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0674 validada','Autor: gdealba\nFactura FA2208-0674 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,700,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2062,2062,NULL,1,'2022-08-30 15:24:34','2022-08-30 15:24:34',40,'AC_BILL_VALIDATE','2022-08-30 15:24:34','2022-08-30 03:24:34',11,NULL,NULL,11791,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0675 validada','Autor: gdealba\nFactura FA2208-0675 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,701,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2063,2063,NULL,1,'2022-08-30 15:27:27','2022-08-30 15:27:27',40,'AC_BILL_VALIDATE','2022-08-30 15:27:27','2022-08-30 03:27:27',11,NULL,NULL,11616,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0676 validada','Autor: gdealba\nFactura FA2208-0676 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,702,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2064,2064,NULL,1,'2022-08-30 15:28:27','2022-08-30 15:28:27',40,'AC_BILL_VALIDATE','2022-08-30 15:28:27','2022-08-30 03:28:27',11,NULL,NULL,11792,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0677 validada','Autor: gdealba\nFactura FA2208-0677 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,703,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2065,2065,NULL,1,'2022-08-30 15:29:22','2022-08-30 15:29:22',40,'AC_BILL_VALIDATE','2022-08-30 15:29:22','2022-08-30 03:29:22',11,NULL,NULL,12109,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0678 validada','Autor: gdealba\nFactura FA2208-0678 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,704,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2066,2066,NULL,1,'2022-08-30 15:30:44','2022-08-30 15:30:44',40,'AC_BILL_VALIDATE','2022-08-30 15:30:44','2022-08-30 03:30:44',11,NULL,NULL,12115,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0679 validada','Autor: gdealba\nFactura FA2208-0679 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,705,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2067,2067,NULL,1,'2022-08-30 15:31:56','2022-08-30 15:31:56',40,'AC_BILL_VALIDATE','2022-08-30 15:31:56','2022-08-30 03:31:56',11,NULL,NULL,14371,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0680 validada','Autor: gdealba\nFactura FA2208-0680 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,706,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2068,2068,NULL,1,'2022-08-30 15:33:31','2022-08-30 15:33:31',40,'AC_BILL_VALIDATE','2022-08-30 15:33:31','2022-08-30 03:33:31',11,NULL,NULL,14371,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0681 validada','Autor: gdealba\nFactura FA2208-0681 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,707,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2069,2069,NULL,1,'2022-08-30 15:37:58','2022-08-30 15:37:58',40,'AC_BILL_VALIDATE','2022-08-30 15:37:58','2022-08-30 03:37:58',11,NULL,NULL,13781,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0682 validada','Autor: gdealba\nFactura FA2208-0682 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,708,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2070,2070,NULL,1,'2022-08-30 15:39:55','2022-08-30 15:39:55',40,'AC_BILL_VALIDATE','2022-08-30 15:39:55','2022-08-30 03:39:55',11,NULL,NULL,14153,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0683 validada','Autor: gdealba\nFactura FA2208-0683 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,709,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2071,2071,NULL,1,'2022-08-30 15:41:23','2022-08-30 15:41:23',40,'AC_BILL_VALIDATE','2022-08-30 15:41:23','2022-08-30 03:41:23',11,NULL,NULL,14155,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0684 validada','Autor: gdealba\nFactura FA2208-0684 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,710,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2072,2072,NULL,1,'2022-08-30 15:42:39','2022-08-30 15:42:39',40,'AC_BILL_VALIDATE','2022-08-30 15:42:39','2022-08-30 03:42:39',11,NULL,NULL,10912,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0685 validada','Autor: gdealba\nFactura FA2208-0685 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,711,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2073,2073,NULL,1,'2022-08-30 15:44:25','2022-08-30 15:44:25',40,'AC_BILL_VALIDATE','2022-08-30 15:44:25','2022-08-30 03:44:25',11,NULL,NULL,10915,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0686 validada','Autor: gdealba\nFactura FA2208-0686 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,712,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2074,2074,NULL,1,'2022-08-30 15:45:35','2022-08-30 15:45:35',40,'AC_BILL_VALIDATE','2022-08-30 15:45:35','2022-08-30 03:45:35',11,NULL,NULL,10917,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0687 validada','Autor: gdealba\nFactura FA2208-0687 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,713,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2075,2075,NULL,1,'2022-08-30 15:47:23','2022-08-30 15:47:23',40,'AC_BILL_VALIDATE','2022-08-30 15:47:23','2022-08-30 03:47:23',11,NULL,NULL,11148,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0688 validada','Autor: gdealba\nFactura FA2208-0688 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,714,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2076,2076,NULL,1,'2022-08-30 15:48:12','2022-08-30 15:48:12',40,'AC_BILL_VALIDATE','2022-08-30 15:48:12','2022-08-30 03:48:12',11,NULL,NULL,12042,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0689 validada','Autor: gdealba\nFactura FA2208-0689 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,715,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2077,2077,NULL,1,'2022-08-30 15:50:02','2022-08-30 15:50:02',40,'AC_BILL_VALIDATE','2022-08-30 15:50:02','2022-08-30 03:50:02',11,NULL,NULL,12084,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0690 validada','Autor: gdealba\nFactura FA2208-0690 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,716,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2078,2078,NULL,1,'2022-08-30 15:51:14','2022-08-30 15:51:14',40,'AC_BILL_VALIDATE','2022-08-30 15:51:14','2022-08-30 03:51:14',11,NULL,NULL,12091,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0691 validada','Autor: gdealba\nFactura FA2208-0691 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,717,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2079,2079,NULL,1,'2022-08-30 15:52:32','2022-08-30 15:52:32',40,'AC_BILL_VALIDATE','2022-08-30 15:52:32','2022-08-30 03:52:32',11,NULL,NULL,12439,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0692 validada','Autor: gdealba\nFactura FA2208-0692 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,718,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2080,2080,NULL,1,'2022-08-30 15:53:17','2022-08-30 15:53:17',40,'AC_BILL_VALIDATE','2022-08-30 15:53:17','2022-08-30 03:53:17',11,NULL,NULL,12496,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0693 validada','Autor: gdealba\nFactura FA2208-0693 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,719,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2081,2081,NULL,1,'2022-08-30 15:54:35','2022-08-30 15:54:35',40,'AC_BILL_VALIDATE','2022-08-30 15:54:35','2022-08-30 03:54:35',11,NULL,NULL,12620,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0694 validada','Autor: gdealba\nFactura FA2208-0694 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,720,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2082,2082,NULL,1,'2022-08-30 15:56:02','2022-08-30 15:56:02',40,'AC_BILL_VALIDATE','2022-08-30 15:56:02','2022-08-30 03:56:02',11,NULL,NULL,13638,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0695 validada','Autor: gdealba\nFactura FA2208-0695 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,721,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2083,2083,NULL,1,'2022-08-30 15:57:00','2022-08-30 15:57:00',40,'AC_COMPANY_CREATE','2022-08-30 15:57:00','2022-08-30 03:57:00',11,NULL,NULL,14372,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Tercero PUBLICO EN GENERAL R65 creado','Autor: gdealba\nTercero PUBLICO EN GENERAL R65 creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2084,2084,NULL,1,'2022-08-30 16:04:50','2022-08-30 16:04:50',40,'AC_BILL_VALIDATE','2022-08-30 16:04:50','2022-08-30 04:04:50',11,NULL,NULL,14372,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0696 validada','Autor: gdealba\nFactura FA2208-0696 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,722,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2085,2085,NULL,1,'2022-08-30 16:09:07','2022-08-30 16:09:07',40,'AC_PRODUCT_MODIFY','2022-08-30 16:09:07','2022-08-30 04:09:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPARROZ500G modificado','Autor: admin\nProducto BPARROZ500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,281,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2086,2086,NULL,1,'2022-08-30 16:10:59','2022-08-30 16:10:59',40,'AC_PRODUCT_MODIFY','2022-08-30 16:10:59','2022-08-30 04:10:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPARROZ900G modificado','Autor: admin\nProducto BPARROZ900G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,282,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2087,2087,NULL,1,'2022-08-30 16:11:52','2022-08-30 16:11:52',40,'AC_PRODUCT_MODIFY','2022-08-30 16:11:52','2022-08-30 04:11:52',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BISUR700G modificado','Autor: admin\nProducto BISUR700G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,216,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2088,2088,NULL,1,'2022-08-30 16:12:41','2022-08-30 16:12:41',40,'AC_BILL_VALIDATE','2022-08-30 16:12:41','2022-08-30 04:12:41',11,NULL,NULL,14117,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0697 validada','Autor: gdealba\nFactura FA2208-0697 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,723,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2089,2089,NULL,1,'2022-08-30 16:13:18','2022-08-30 16:13:18',40,'AC_PRODUCT_MODIFY','2022-08-30 16:13:18','2022-08-30 04:13:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BISUS600G modificado','Autor: admin\nProducto BISUS600G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,217,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2090,2090,NULL,1,'2022-08-30 16:14:29','2022-08-30 16:14:29',40,'AC_BILL_VALIDATE','2022-08-30 16:14:29','2022-08-30 04:14:29',11,NULL,NULL,13856,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0698 validada','Autor: gdealba\nFactura FA2208-0698 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,724,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2091,2091,NULL,1,'2022-08-30 16:15:11','2022-08-30 16:15:11',40,'AC_PRODUCT_MODIFY','2022-08-30 16:15:11','2022-08-30 04:15:11',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPMA400G modificado','Autor: admin\nProducto BPMA400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,210,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2092,2092,NULL,1,'2022-08-30 16:15:51','2022-08-30 16:15:51',40,'AC_BILL_VALIDATE','2022-08-30 16:15:51','2022-08-30 04:15:51',11,NULL,NULL,13905,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0699 validada','Autor: gdealba\nFactura FA2208-0699 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,725,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2093,2093,NULL,1,'2022-08-30 16:16:03','2022-08-30 16:16:03',40,'AC_PRODUCT_MODIFY','2022-08-30 16:16:03','2022-08-30 04:16:03',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPMA400G modificado','Autor: admin\nProducto BPMA400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,210,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2094,2094,NULL,1,'2022-08-30 16:16:45','2022-08-30 16:16:45',40,'AC_BILL_VALIDATE','2022-08-30 16:16:45','2022-08-30 04:16:45',11,NULL,NULL,13938,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0700 validada','Autor: gdealba\nFactura FA2208-0700 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,726,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2095,2095,NULL,1,'2022-08-30 16:17:59','2022-08-30 16:17:59',40,'AC_BILL_VALIDATE','2022-08-30 16:17:59','2022-08-30 04:17:59',11,NULL,NULL,13984,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0701 validada','Autor: gdealba\nFactura FA2208-0701 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,727,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2096,2096,NULL,1,'2022-08-30 16:18:17','2022-08-30 16:18:17',40,'AC_PRODUCT_MODIFY','2022-08-30 16:18:17','2022-08-30 04:18:17',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPFL336G modificado','Autor: admin\nProducto BPFL336G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,212,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2097,2097,NULL,1,'2022-08-30 16:18:51','2022-08-30 16:18:51',40,'AC_BILL_VALIDATE','2022-08-30 16:18:51','2022-08-30 04:18:51',11,NULL,NULL,11018,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0702 validada','Autor: gdealba\nFactura FA2208-0702 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,728,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2098,2098,NULL,1,'2022-08-30 16:18:57','2022-08-30 16:18:57',40,'AC_PRODUCT_MODIFY','2022-08-30 16:18:57','2022-08-30 04:18:57',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPFL336G modificado','Autor: admin\nProducto BPFL336G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,212,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2099,2099,NULL,1,'2022-08-30 16:19:54','2022-08-30 16:19:54',40,'AC_BILL_VALIDATE','2022-08-30 16:19:54','2022-08-30 04:19:54',11,NULL,NULL,11790,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0703 validada','Autor: gdealba\nFactura FA2208-0703 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,729,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2100,2100,NULL,1,'2022-08-30 16:20:52','2022-08-30 16:20:52',40,'AC_PRODUCT_MODIFY','2022-08-30 16:20:52','2022-08-30 04:20:52',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR500G modificado','Autor: admin\nProducto BPGR500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,205,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2101,2101,NULL,1,'2022-08-30 16:21:06','2022-08-30 16:21:06',40,'AC_PRODUCT_MODIFY','2022-08-30 16:21:06','2022-08-30 04:21:06',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR500G modificado','Autor: admin\nProducto BPGR500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,205,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2102,2102,NULL,1,'2022-08-30 16:21:54','2022-08-30 16:21:54',40,'AC_BILL_VALIDATE','2022-08-30 16:21:54','2022-08-30 04:21:54',11,NULL,NULL,12113,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0704 validada','Autor: gdealba\nFactura FA2208-0704 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,730,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2103,2103,NULL,1,'2022-08-30 16:22:37','2022-08-30 16:22:37',40,'AC_PRODUCT_MODIFY','2022-08-30 16:22:37','2022-08-30 04:22:37',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CECINAL40G modificado','Autor: admin\nProducto CECINAL40G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,231,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2104,2104,NULL,1,'2022-08-30 16:22:51','2022-08-30 16:22:51',40,'AC_BILL_VALIDATE','2022-08-30 16:22:51','2022-08-30 04:22:51',11,NULL,NULL,12492,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0705 validada','Autor: gdealba\nFactura FA2208-0705 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,731,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2105,2105,NULL,1,'2022-08-30 16:23:39','2022-08-30 16:23:39',40,'AC_PRODUCT_MODIFY','2022-08-30 16:23:39','2022-08-30 04:23:39',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPNU400G modificado','Autor: admin\nProducto BPNU400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,211,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2106,2106,NULL,1,'2022-08-30 16:25:57','2022-08-30 16:25:57',40,'AC_BILL_VALIDATE','2022-08-30 16:25:57','2022-08-30 04:25:57',11,NULL,NULL,12493,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0706 validada','Autor: gdealba\nFactura FA2208-0706 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,732,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2107,2107,NULL,1,'2022-08-30 16:26:48','2022-08-30 16:26:48',40,'AC_PRODUCT_MODIFY','2022-08-30 16:26:48','2022-08-30 04:26:48',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPMI500G modificado','Autor: admin\nProducto BPMI500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,206,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2108,2108,NULL,1,'2022-08-30 16:29:36','2022-08-30 16:29:36',40,'AC_PRODUCT_MODIFY','2022-08-30 16:29:36','2022-08-30 04:29:36',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR100G modificado','Autor: admin\nProducto BPGR100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,279,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2109,2109,NULL,1,'2022-08-30 16:32:15','2022-08-30 16:32:15',40,'AC_BILL_VALIDATE','2022-08-30 16:32:15','2022-08-30 04:32:15',11,NULL,NULL,14365,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0707 validada','Autor: gdealba\nFactura FA2208-0707 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,733,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2110,2110,NULL,1,'2022-08-30 16:32:23','2022-08-30 16:32:23',40,'AC_PRODUCT_MODIFY','2022-08-30 16:32:23','2022-08-30 04:32:23',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPPIZ100G modificado','Autor: admin\nProducto BPPIZ100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,278,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2111,2111,NULL,1,'2022-08-30 16:34:03','2022-08-30 16:34:03',40,'AC_BILL_VALIDATE','2022-08-30 16:34:03','2022-08-30 04:34:03',11,NULL,NULL,14365,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0708 validada','Autor: gdealba\nFactura FA2208-0708 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,734,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2112,2112,NULL,1,'2022-08-30 16:34:47','2022-08-30 16:34:47',40,'AC_BILL_VALIDATE','2022-08-30 16:34:47','2022-08-30 04:34:47',11,NULL,NULL,14365,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0709 validada','Autor: gdealba\nFactura FA2208-0709 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,735,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2113,2113,NULL,1,'2022-08-30 16:36:14','2022-08-30 16:36:14',40,'AC_BILL_VALIDATE','2022-08-30 16:36:14','2022-08-30 04:36:14',11,NULL,NULL,14365,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0710 validada','Autor: gdealba\nFactura FA2208-0710 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,736,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2114,2114,NULL,1,'2022-08-30 16:37:01','2022-08-30 16:37:01',40,'AC_PRODUCT_MODIFY','2022-08-30 16:37:01','2022-08-30 04:37:01',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPAVE500G modificado','Autor: admin\nProducto BPAVE500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,203,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2115,2115,NULL,1,'2022-08-30 16:37:32','2022-08-30 16:37:32',40,'AC_BILL_VALIDATE','2022-08-30 16:37:32','2022-08-30 04:37:32',11,NULL,NULL,14365,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0711 validada','Autor: gdealba\nFactura FA2208-0711 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,737,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2116,2116,NULL,1,'2022-08-30 16:38:52','2022-08-30 16:38:52',40,'AC_BILL_VALIDATE','2022-08-30 16:38:52','2022-08-30 04:38:52',11,NULL,NULL,14365,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0712 validada','Autor: gdealba\nFactura FA2208-0712 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,738,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2117,2117,NULL,1,'2022-08-30 16:38:57','2022-08-30 16:38:57',40,'AC_PRODUCT_MODIFY','2022-08-30 16:38:57','2022-08-30 04:38:57',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPLYA400G modificado','Autor: admin\nProducto BPLYA400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,208,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2118,2118,NULL,1,'2022-08-30 16:39:33','2022-08-30 16:39:33',40,'AC_BILL_VALIDATE','2022-08-30 16:39:33','2022-08-30 04:39:33',11,NULL,NULL,14365,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0713 validada','Autor: gdealba\nFactura FA2208-0713 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,739,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2119,2119,NULL,1,'2022-08-30 16:40:43','2022-08-30 16:40:43',40,'AC_BILL_VALIDATE','2022-08-30 16:40:43','2022-08-30 04:40:43',11,NULL,NULL,14365,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0714 validada','Autor: gdealba\nFactura FA2208-0714 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,740,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2120,2120,NULL,1,'2022-08-30 16:41:12','2022-08-30 16:41:12',40,'AC_PRODUCT_MODIFY','2022-08-30 16:41:12','2022-08-30 04:41:12',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BP_BARRA_DE_COCO_400g modificado','Autor: admin\nProducto BP_BARRA_DE_COCO_400g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,214,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2121,2121,NULL,1,'2022-08-30 16:42:05','2022-08-30 16:42:05',40,'AC_BILL_VALIDATE','2022-08-30 16:42:05','2022-08-30 04:42:05',11,NULL,NULL,14365,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0715 validada','Autor: gdealba\nFactura FA2208-0715 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,741,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2122,2122,NULL,1,'2022-08-30 16:43:20','2022-08-30 16:43:20',40,'AC_PRODUCT_MODIFY','2022-08-30 16:43:20','2022-08-30 04:43:20',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BNPPIZ336G modificado','Autor: admin\nProducto BNPPIZ336G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,215,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2123,2123,NULL,1,'2022-08-30 16:44:26','2022-08-30 16:44:26',40,'AC_PRODUCT_MODIFY','2022-08-30 16:44:26','2022-08-30 04:44:26',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CECINA modificado','Autor: admin\nProducto CECINA modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,336,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2124,2124,NULL,1,'2022-08-30 16:44:32','2022-08-30 16:44:32',40,'AC_BILL_VALIDATE','2022-08-30 16:44:32','2022-08-30 04:44:32',11,NULL,NULL,14365,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0716 validada','Autor: gdealba\nFactura FA2208-0716 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,742,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2125,2125,NULL,1,'2022-08-30 16:46:24','2022-08-30 16:46:24',40,'AC_BILL_VALIDATE','2022-08-30 16:46:24','2022-08-30 04:46:24',11,NULL,NULL,14365,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0717 validada','Autor: gdealba\nFactura FA2208-0717 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,743,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2126,2126,NULL,1,'2022-08-30 16:47:23','2022-08-30 16:47:23',40,'AC_PRODUCT_MODIFY','2022-08-30 16:47:23','2022-08-30 04:47:23',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGCH400G modificado','Autor: admin\nProducto BPGCH400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,280,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2127,2127,NULL,1,'2022-08-30 16:48:13','2022-08-30 16:48:13',40,'AC_PRODUCT_MODIFY','2022-08-30 16:48:13','2022-08-30 04:48:13',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CECINAA40G modificado','Autor: admin\nProducto CECINAA40G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,232,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2128,2128,NULL,1,'2022-08-30 16:48:37','2022-08-30 16:48:37',40,'AC_BILL_VALIDATE','2022-08-30 16:48:37','2022-08-30 04:48:37',11,NULL,NULL,14365,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0718 validada','Autor: gdealba\nFactura FA2208-0718 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,744,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2129,2129,NULL,1,'2022-08-30 16:48:57','2022-08-30 16:48:57',40,'AC_PRODUCT_MODIFY','2022-08-30 16:48:57','2022-08-30 04:48:57',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CECINAH40G modificado','Autor: admin\nProducto CECINAH40G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,233,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2130,2130,NULL,1,'2022-08-30 16:52:23','2022-08-30 16:52:23',40,'AC_PRODUCT_MODIFY','2022-08-30 16:52:23','2022-08-30 04:52:23',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPOR200G modificado','Autor: admin\nProducto BPOR200G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,213,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2131,2131,NULL,1,'2022-08-30 17:30:04','2022-08-30 17:30:04',40,'AC_BILL_VALIDATE','2022-08-30 17:30:04','2022-08-30 05:30:04',11,NULL,NULL,14365,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0719 validada','Autor: gdealba\nFactura FA2208-0719 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,745,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2132,2132,NULL,1,'2022-08-30 17:31:31','2022-08-30 17:31:31',40,'AC_BILL_VALIDATE','2022-08-30 17:31:31','2022-08-30 05:31:31',11,NULL,NULL,14365,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0720 validada','Autor: gdealba\nFactura FA2208-0720 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,746,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2133,2133,NULL,1,'2022-08-30 17:32:49','2022-08-30 17:32:49',40,'AC_BILL_VALIDATE','2022-08-30 17:32:49','2022-08-30 05:32:49',11,NULL,NULL,14365,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0721 validada','Autor: gdealba\nFactura FA2208-0721 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,747,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2134,2134,NULL,1,'2022-08-30 17:36:45','2022-08-30 17:36:45',40,'AC_BILL_VALIDATE','2022-08-30 17:36:45','2022-08-30 05:36:45',11,NULL,NULL,14069,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0722 validada','Autor: gdealba\nFactura FA2208-0722 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,748,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2135,2135,NULL,1,'2022-08-30 17:37:38','2022-08-30 17:37:38',40,'AC_BILL_VALIDATE','2022-08-30 17:37:38','2022-08-30 05:37:38',11,NULL,NULL,13790,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0723 validada','Autor: gdealba\nFactura FA2208-0723 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,749,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2136,2136,NULL,1,'2022-08-30 17:38:30','2022-08-30 17:38:30',40,'AC_PRODUCT_MODIFY','2022-08-30 17:38:30','2022-08-30 05:38:30',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPAA350G modificado','Autor: admin\nProducto BPAA350G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,209,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2137,2137,NULL,1,'2022-08-30 17:38:40','2022-08-30 17:38:40',40,'AC_BILL_VALIDATE','2022-08-30 17:38:40','2022-08-30 05:38:40',11,NULL,NULL,10793,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0724 validada','Autor: gdealba\nFactura FA2208-0724 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,750,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2138,2138,NULL,1,'2022-08-30 17:39:24','2022-08-30 17:39:24',40,'AC_PRODUCT_MODIFY','2022-08-30 17:39:24','2022-08-30 05:39:24',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPAVE100G modificado','Autor: admin\nProducto BPAVE100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,219,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2139,2139,NULL,1,'2022-08-30 17:39:33','2022-08-30 17:39:33',40,'AC_BILL_VALIDATE','2022-08-30 17:39:33','2022-08-30 05:39:33',11,NULL,NULL,10794,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0725 validada','Autor: gdealba\nFactura FA2208-0725 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,751,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2140,2140,NULL,1,'2022-08-30 17:41:01','2022-08-30 17:41:01',40,'AC_BILL_VALIDATE','2022-08-30 17:41:01','2022-08-30 05:41:01',11,NULL,NULL,10795,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0726 validada','Autor: gdealba\nFactura FA2208-0726 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,752,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2141,2141,NULL,1,'2022-08-30 17:42:12','2022-08-30 17:42:12',40,'AC_BILL_VALIDATE','2022-08-30 17:42:12','2022-08-30 05:42:12',11,NULL,NULL,10817,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0727 validada','Autor: gdealba\nFactura FA2208-0727 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,753,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2142,2142,NULL,1,'2022-08-30 17:43:10','2022-08-30 17:43:10',40,'AC_BILL_VALIDATE','2022-08-30 17:43:10','2022-08-30 05:43:10',11,NULL,NULL,11665,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0728 validada','Autor: gdealba\nFactura FA2208-0728 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,754,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2143,2143,NULL,1,'2022-08-30 17:44:13','2022-08-30 17:44:13',40,'AC_BILL_VALIDATE','2022-08-30 17:44:13','2022-08-30 05:44:13',11,NULL,NULL,11811,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0729 validada','Autor: gdealba\nFactura FA2208-0729 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,755,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2144,2144,NULL,1,'2022-08-30 17:44:47','2022-08-30 17:44:47',40,'AC_BILL_VALIDATE','2022-08-30 17:44:47','2022-08-30 05:44:47',11,NULL,NULL,11852,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0730 validada','Autor: gdealba\nFactura FA2208-0730 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,756,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2145,2145,NULL,1,'2022-08-30 17:45:45','2022-08-30 17:45:45',40,'AC_BILL_VALIDATE','2022-08-30 17:45:45','2022-08-30 05:45:45',11,NULL,NULL,11860,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0731 validada','Autor: gdealba\nFactura FA2208-0731 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,757,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2146,2146,NULL,1,'2022-08-30 17:46:27','2022-08-30 17:46:27',40,'AC_BILL_VALIDATE','2022-08-30 17:46:27','2022-08-30 05:46:27',11,NULL,NULL,11902,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0732 validada','Autor: gdealba\nFactura FA2208-0732 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,758,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2147,2147,NULL,1,'2022-08-30 17:47:48','2022-08-30 17:47:48',40,'AC_PRODUCT_MODIFY','2022-08-30 17:47:48','2022-08-30 05:47:48',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPELO11GR modificado','Autor: admin\nProducto BPELO11GR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,236,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2148,2148,NULL,1,'2022-08-30 17:48:07','2022-08-30 17:48:07',40,'AC_BILL_VALIDATE','2022-08-30 17:48:07','2022-08-30 05:48:07',11,NULL,NULL,12613,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0733 validada','Autor: gdealba\nFactura FA2208-0733 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,759,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2149,2149,NULL,1,'2022-08-30 17:48:25','2022-08-30 17:48:25',40,'AC_PRODUCT_MODIFY','2022-08-30 17:48:25','2022-08-30 05:48:25',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPMAN11GR modificado','Autor: admin\nProducto BPMAN11GR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,234,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2150,2150,NULL,1,'2022-08-30 17:48:56','2022-08-30 17:48:56',40,'AC_PRODUCT_MODIFY','2022-08-30 17:48:56','2022-08-30 05:48:56',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPSAN11GR modificado','Autor: admin\nProducto BPSAN11GR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,237,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2151,2151,NULL,1,'2022-08-30 17:49:01','2022-08-30 17:49:01',40,'AC_BILL_VALIDATE','2022-08-30 17:49:01','2022-08-30 05:49:01',11,NULL,NULL,12668,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0734 validada','Autor: gdealba\nFactura FA2208-0734 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,760,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2152,2152,NULL,1,'2022-08-30 17:50:01','2022-08-30 17:50:01',40,'AC_BILL_VALIDATE','2022-08-30 17:50:01','2022-08-30 05:50:01',11,NULL,NULL,12681,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0735 validada','Autor: gdealba\nFactura FA2208-0735 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,761,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2153,2153,NULL,1,'2022-08-30 17:50:31','2022-08-30 17:50:31',40,'AC_PRODUCT_MODIFY','2022-08-30 17:50:31','2022-08-30 05:50:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MI40G modificado','Autor: admin\nProducto MI40G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,228,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2154,2154,NULL,1,'2022-08-30 17:51:44','2022-08-30 17:51:44',40,'AC_BILL_VALIDATE','2022-08-30 17:51:44','2022-08-30 05:51:44',11,NULL,NULL,12819,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0736 validada','Autor: gdealba\nFactura FA2208-0736 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,762,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2155,2155,NULL,1,'2022-08-30 17:52:31','2022-08-30 17:52:31',40,'AC_BILL_VALIDATE','2022-08-30 17:52:31','2022-08-30 05:52:31',11,NULL,NULL,13203,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0737 validada','Autor: gdealba\nFactura FA2208-0737 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,763,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2156,2156,NULL,1,'2022-08-30 17:53:55','2022-08-30 17:53:55',40,'AC_PRODUCT_MODIFY','2022-08-30 17:53:55','2022-08-30 05:53:55',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BISAGRA_SEVILLANO modificado','Autor: admin\nProducto BISAGRA_SEVILLANO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,218,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2157,2157,NULL,1,'2022-08-30 17:54:07','2022-08-30 17:54:07',40,'AC_BILL_VALIDATE','2022-08-30 17:54:07','2022-08-30 05:54:07',11,NULL,NULL,13205,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0738 validada','Autor: gdealba\nFactura FA2208-0738 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,764,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2158,2158,NULL,1,'2022-08-30 17:56:03','2022-08-30 17:56:03',40,'AC_BILL_VALIDATE','2022-08-30 17:56:03','2022-08-30 05:56:03',11,NULL,NULL,13563,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0739 validada','Autor: gdealba\nFactura FA2208-0739 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,765,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2159,2159,NULL,1,'2022-08-30 17:56:25','2022-08-30 17:56:25',40,'AC_PRODUCT_MODIFY','2022-08-30 17:56:25','2022-08-30 05:56:25',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BP_EMILIAS modificado','Autor: admin\nProducto BP_EMILIAS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,204,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2160,2160,NULL,1,'2022-08-30 17:59:46','2022-08-30 17:59:46',40,'AC_PRODUCT_MODIFY','2022-08-30 17:59:46','2022-08-30 05:59:46',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BARRA_DE_COCO_Granel modificado','Autor: admin\nProducto BARRA_DE_COCO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,197,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2161,2161,NULL,1,'2022-08-30 18:01:25','2022-08-30 18:01:25',40,'AC_PRODUCT_MODIFY','2022-08-30 18:01:25','2022-08-30 06:01:25',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto VAINILLA_FLOR_DE_CAYRO_Granel modificado','Autor: admin\nProducto VAINILLA_FLOR_DE_CAYRO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,190,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2162,2162,NULL,1,'2022-08-30 18:02:45','2022-08-30 18:02:45',40,'AC_PRODUCT_MODIFY','2022-08-30 18:02:45','2022-08-30 06:02:45',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEAGRANEL modificado','Autor: admin\nProducto GRAGEAGRANEL modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,187,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2163,2163,NULL,1,'2022-08-30 18:02:50','2022-08-30 18:02:50',40,'AC_BILL_VALIDATE','2022-08-30 18:02:50','2022-08-30 06:02:50',11,NULL,NULL,13624,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0740 validada','Autor: gdealba\nFactura FA2208-0740 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,766,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2164,2164,NULL,1,'2022-08-30 18:04:17','2022-08-30 18:04:17',40,'AC_PRODUCT_MODIFY','2022-08-30 18:04:17','2022-08-30 06:04:17',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MARMOLEADAS_AZUCARADAS_Granel modificado','Autor: admin\nProducto MARMOLEADAS_AZUCARADAS_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,189,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2165,2165,NULL,1,'2022-08-30 18:04:25','2022-08-30 18:04:25',40,'AC_BILL_VALIDATE','2022-08-30 18:04:25','2022-08-30 06:04:25',11,NULL,NULL,14364,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0741 validada','Autor: gdealba\nFactura FA2208-0741 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,767,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2166,2166,NULL,1,'2022-08-30 18:05:07','2022-08-30 18:05:07',40,'AC_PRODUCT_MODIFY','2022-08-30 18:05:07','2022-08-30 06:05:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MINI_COCO_Granel modificado','Autor: admin\nProducto MINI_COCO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,195,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2167,2167,NULL,1,'2022-08-30 18:06:37','2022-08-30 18:06:37',40,'AC_PRODUCT_MODIFY','2022-08-30 18:06:37','2022-08-30 06:06:37',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GTAS._NUEZ_CON_GLAS_Granel modificado','Autor: admin\nProducto GTAS._NUEZ_CON_GLAS_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,188,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2168,2168,NULL,1,'2022-08-30 18:07:14','2022-08-30 18:07:14',40,'AC_PRODUCT_MODIFY','2022-08-30 18:07:14','2022-08-30 06:07:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto OREJAS_Granel modificado','Autor: admin\nProducto OREJAS_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,194,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2169,2169,NULL,1,'2022-08-30 18:08:14','2022-08-30 18:08:14',40,'AC_PRODUCT_MODIFY','2022-08-30 18:08:14','2022-08-30 06:08:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto PIZCA_DE_CHOCOLATE_Granel modificado','Autor: admin\nProducto PIZCA_DE_CHOCOLATE_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,199,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2170,2170,NULL,1,'2022-08-30 18:08:53','2022-08-30 18:08:53',40,'AC_PRODUCT_MODIFY','2022-08-30 18:08:53','2022-08-30 06:08:53',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto SEVILLANO_Granel modificado','Autor: admin\nProducto SEVILLANO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,198,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2171,2171,NULL,1,'2022-08-30 18:09:32','2022-08-30 18:09:32',40,'AC_PRODUCT_MODIFY','2022-08-30 18:09:32','2022-08-30 06:09:32',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto SUSPIRO_Granel modificado','Autor: admin\nProducto SUSPIRO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,191,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2172,2172,NULL,1,'2022-08-30 18:10:31','2022-08-30 18:10:31',40,'AC_PRODUCT_MODIFY','2022-08-30 18:10:31','2022-08-30 06:10:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto TIMBRE_DE_FRESA_Granel modificado','Autor: admin\nProducto TIMBRE_DE_FRESA_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,200,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2173,2173,NULL,1,'2022-08-30 18:25:51','2022-08-30 18:25:51',40,'AC_USER_CREATE','2022-08-30 18:25:51','2022-08-30 06:25:51',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro  creado','Autor: admin\nRegistro  creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,12,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2174,2174,NULL,1,'2022-08-30 18:25:51','2022-08-30 18:25:51',40,'AC_USER_NEW_PASSWORD','2022-08-30 18:25:51','2022-08-30 06:25:51',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'PASSWORDInDolibarr','Autor: admin\nPASSWORDInDolibarr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,12,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2175,2175,NULL,1,'2022-08-30 18:25:58','2022-08-30 18:25:58',40,'AC_USER_MODIFY','2022-08-30 18:25:58','2022-08-30 06:25:58',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 12 modificado','Autor: admin\nRegistro 12 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,12,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2176,2176,NULL,1,'2022-08-30 18:26:03','2022-08-30 18:26:03',40,'AC_USER_MODIFY','2022-08-30 18:26:03','2022-08-30 06:26:03',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 12 modificado','Autor: admin\nRegistro 12 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,12,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2177,2177,NULL,1,'2022-08-30 18:26:15','2022-08-30 18:26:15',40,'AC_USER_MODIFY','2022-08-30 18:26:15','2022-08-30 06:26:15',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 12 modificado','Autor: admin\nRegistro 12 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,12,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2178,2178,NULL,1,'2022-08-30 18:26:27','2022-08-30 18:26:27',40,'AC_USER_MODIFY','2022-08-30 18:26:27','2022-08-30 06:26:27',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 12 modificado','Autor: admin\nRegistro 12 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,12,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2179,2179,NULL,1,'2022-08-30 18:26:30','2022-08-30 18:26:30',40,'AC_USER_MODIFY','2022-08-30 18:26:30','2022-08-30 06:26:30',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 12 modificado','Autor: admin\nRegistro 12 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,12,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2180,2180,NULL,1,'2022-08-30 18:26:32','2022-08-30 18:26:32',40,'AC_USER_MODIFY','2022-08-30 18:26:32','2022-08-30 06:26:32',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 12 modificado','Autor: admin\nRegistro 12 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,12,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2181,2181,NULL,1,'2022-08-30 18:27:08','2022-08-30 18:27:08',40,'AC_USER_MODIFY','2022-08-30 18:27:08','2022-08-30 06:27:08',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 12 modificado','Autor: admin\nRegistro 12 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,12,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2182,2182,NULL,1,'2022-08-30 18:27:48','2022-08-30 18:27:48',40,'AC_USER_MODIFY','2022-08-30 18:27:48','2022-08-30 06:27:48',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 11 modificado','Autor: admin\nRegistro 11 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,11,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2183,2183,NULL,1,'2022-08-30 20:04:04','2022-08-30 20:04:04',40,'AC_BOM_UNVALIDATE','2022-08-30 20:04:04','2022-08-30 08:04:04',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,31,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2184,2184,NULL,1,'2022-08-30 20:04:20','2022-08-30 20:04:20',40,'AC_BOM_VALIDATE','2022-08-30 20:04:20','2022-08-30 08:04:20',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,31,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2185,2185,NULL,1,'2022-08-30 20:16:42','2022-08-30 20:16:42',40,'AC_BOM_VALIDATE','2022-08-30 20:16:42','2022-08-30 08:16:42',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,40,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2186,2186,NULL,1,'2022-08-30 20:18:20','2022-08-30 20:18:20',40,'AC_BOM_VALIDATE','2022-08-30 20:18:20','2022-08-30 08:18:20',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,41,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2187,2187,NULL,1,'2022-08-30 21:34:02','2022-08-30 21:34:02',40,'AC_BOM_UNVALIDATE','2022-08-30 21:34:02','2022-08-30 09:34:02',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,44,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2188,2188,NULL,1,'2022-08-30 22:10:53','2022-08-30 22:10:53',40,'AC_BOM_UNVALIDATE','2022-08-30 22:10:53','2022-08-30 10:10:53',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales devalidada','Autor: admin\nLista de materiales devalidada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,67,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2189,2189,NULL,1,'2022-08-30 22:30:56','2022-08-30 22:30:56',40,'AC_BOM_VALIDATE','2022-08-30 22:30:56','2022-08-30 10:30:56',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Lista de materiales validada','Autor: admin\nLista de materiales validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,68,'bom',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2190,2190,NULL,1,'2022-08-31 00:02:43','2022-08-31 00:02:43',40,'AC_BILL_VALIDATE','2022-08-31 00:02:43','2022-08-30 12:02:43',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0742 validada','Autor: egarcia\nFactura FA2208-0742 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,768,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2191,2191,NULL,1,'2022-08-31 00:06:46','2022-08-31 00:06:46',40,'AC_BILL_VALIDATE','2022-08-31 00:06:46','2022-08-30 12:06:46',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0743 validada','Autor: egarcia\nFactura FA2208-0743 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,769,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2192,2192,NULL,1,'2022-08-31 00:11:24','2022-08-31 00:11:24',40,'AC_BILL_VALIDATE','2022-08-31 00:11:24','2022-08-30 12:11:24',6,NULL,NULL,14336,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0744 validada','Autor: egarcia\nFactura FA2208-0744 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,770,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2193,2193,NULL,1,'2022-08-31 00:16:00','2022-08-31 00:16:00',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-31 00:16:00','2022-08-30 12:16:00',6,NULL,NULL,3,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0081 validada','Autor: egarcia\nFactura SI2208-0081 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,109,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2194,2194,NULL,1,'2022-08-31 00:17:22','2022-08-31 00:17:22',40,'AC_BILL_VALIDATE','2022-08-31 00:17:22','2022-08-30 12:17:22',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0745 validada','Autor: egarcia\nFactura FA2208-0745 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,771,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2195,2195,NULL,1,'2022-08-31 00:18:10','2022-08-31 00:18:10',40,'AC_BILL_VALIDATE','2022-08-31 00:18:10','2022-08-30 12:18:10',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0746 validada','Autor: egarcia\nFactura FA2208-0746 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,772,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2196,2196,NULL,1,'2022-08-31 00:19:21','2022-08-31 00:19:21',40,'AC_BILL_VALIDATE','2022-08-31 00:19:21','2022-08-30 12:19:21',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0747 validada','Autor: egarcia\nFactura FA2208-0747 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,773,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2197,2197,NULL,1,'2022-08-31 00:20:08','2022-08-31 00:20:08',40,'AC_BILL_VALIDATE','2022-08-31 00:20:08','2022-08-30 12:20:08',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0748 validada','Autor: egarcia\nFactura FA2208-0748 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,774,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2198,2198,NULL,1,'2022-08-31 00:21:04','2022-08-31 00:21:04',40,'AC_BILL_VALIDATE','2022-08-31 00:21:04','2022-08-30 12:21:04',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0749 validada','Autor: egarcia\nFactura FA2208-0749 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,775,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2199,2199,NULL,1,'2022-08-31 00:22:26','2022-08-31 00:22:26',40,'AC_BILL_VALIDATE','2022-08-31 00:22:26','2022-08-30 12:22:26',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0750 validada','Autor: egarcia\nFactura FA2208-0750 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,776,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2200,2200,NULL,1,'2022-08-31 00:23:34','2022-08-31 00:23:34',40,'AC_BILL_VALIDATE','2022-08-31 00:23:34','2022-08-30 12:23:34',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0751 validada','Autor: egarcia\nFactura FA2208-0751 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,777,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2201,2201,NULL,1,'2022-08-31 00:24:21','2022-08-31 00:24:21',40,'AC_BILL_VALIDATE','2022-08-31 00:24:21','2022-08-30 12:24:21',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0752 validada','Autor: egarcia\nFactura FA2208-0752 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,778,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2202,2202,NULL,1,'2022-08-31 00:42:03','2022-08-31 00:42:03',40,'AC_BILL_VALIDATE','2022-08-31 00:42:03','2022-08-30 12:42:03',11,NULL,NULL,13950,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0753 validada','Autor: gdealba\nFactura FA2208-0753 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,779,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2203,2203,NULL,1,'2022-08-31 00:46:03','2022-08-31 00:46:03',40,'AC_BILL_VALIDATE','2022-08-31 00:46:03','2022-08-30 12:46:03',11,NULL,NULL,13842,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0754 validada','Autor: gdealba\nFactura FA2208-0754 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,780,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2204,2204,NULL,1,'2022-08-31 00:50:35','2022-08-31 00:50:35',40,'AC_BILL_DELETE','2022-08-31 00:50:35','2022-08-30 12:50:35',11,NULL,NULL,10941,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura eliminada','Autor: gdealba\nFactura eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,781,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2205,2205,NULL,1,'2022-08-31 01:10:49','2022-08-31 01:10:49',40,'AC_BILL_VALIDATE','2022-08-31 01:10:49','2022-08-30 13:10:49',11,NULL,NULL,13921,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0755 validada','Autor: gdealba\nFactura FA2208-0755 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,782,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2206,2206,NULL,1,'2022-08-31 01:11:45','2022-08-31 01:11:45',40,'AC_BILL_VALIDATE','2022-08-31 01:11:45','2022-08-30 13:11:45',11,NULL,NULL,10941,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0756 validada','Autor: gdealba\nFactura FA2208-0756 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,783,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2207,2207,NULL,1,'2022-08-31 01:13:44','2022-08-31 01:13:44',40,'AC_BILL_VALIDATE','2022-08-31 01:13:44','2022-08-30 13:13:44',11,NULL,NULL,11043,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0757 validada','Autor: gdealba\nFactura FA2208-0757 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,784,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2208,2208,NULL,1,'2022-08-31 01:15:24','2022-08-31 01:15:24',40,'AC_BILL_VALIDATE','2022-08-31 01:15:24','2022-08-30 13:15:24',11,NULL,NULL,11592,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0758 validada','Autor: gdealba\nFactura FA2208-0758 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,785,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2209,2209,NULL,1,'2022-08-31 01:16:33','2022-08-31 01:16:33',40,'AC_BILL_VALIDATE','2022-08-31 01:16:33','2022-08-30 13:16:33',11,NULL,NULL,12351,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0759 validada','Autor: gdealba\nFactura FA2208-0759 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,786,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2210,2210,NULL,1,'2022-08-31 01:17:45','2022-08-31 01:17:45',40,'AC_BILL_VALIDATE','2022-08-31 01:17:45','2022-08-30 13:17:45',11,NULL,NULL,12441,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0760 validada','Autor: gdealba\nFactura FA2208-0760 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,787,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2211,2211,NULL,1,'2022-08-31 01:18:43','2022-08-31 01:18:43',40,'AC_BILL_VALIDATE','2022-08-31 01:18:43','2022-08-30 13:18:43',11,NULL,NULL,12446,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0761 validada','Autor: gdealba\nFactura FA2208-0761 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,788,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2212,2212,NULL,1,'2022-08-31 01:19:57','2022-08-31 01:19:57',40,'AC_BILL_VALIDATE','2022-08-31 01:19:57','2022-08-30 13:19:57',11,NULL,NULL,12667,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0762 validada','Autor: gdealba\nFactura FA2208-0762 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,789,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2213,2213,NULL,1,'2022-08-31 01:21:12','2022-08-31 01:21:12',40,'AC_BILL_VALIDATE','2022-08-31 01:21:12','2022-08-30 13:21:12',11,NULL,NULL,13140,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0763 validada','Autor: gdealba\nFactura FA2208-0763 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,790,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2214,2214,NULL,1,'2022-08-31 01:22:37','2022-08-31 01:22:37',40,'AC_BILL_VALIDATE','2022-08-31 01:22:37','2022-08-30 13:22:37',11,NULL,NULL,13653,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0764 validada','Autor: gdealba\nFactura FA2208-0764 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,791,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2215,2215,NULL,1,'2022-08-31 01:23:19','2022-08-31 01:23:19',40,'AC_BILL_VALIDATE','2022-08-31 01:23:19','2022-08-30 13:23:19',11,NULL,NULL,14367,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0765 validada','Autor: gdealba\nFactura FA2208-0765 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,792,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2216,2216,NULL,1,'2022-08-31 01:25:18','2022-08-31 01:25:18',40,'AC_BILL_VALIDATE','2022-08-31 01:25:18','2022-08-30 13:25:18',11,NULL,NULL,12700,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0766 validada','Autor: gdealba\nFactura FA2208-0766 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,793,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2217,2217,NULL,1,'2022-08-31 01:34:01','2022-08-31 01:34:01',40,'AC_BILL_VALIDATE','2022-08-31 01:34:01','2022-08-30 13:34:01',11,NULL,NULL,13117,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0767 validada','Autor: gdealba\nFactura FA2208-0767 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,794,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2218,2218,NULL,1,'2022-08-31 01:36:31','2022-08-31 01:36:31',40,'AC_BILL_VALIDATE','2022-08-31 01:36:31','2022-08-30 13:36:31',11,NULL,NULL,14368,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0768 validada','Autor: gdealba\nFactura FA2208-0768 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,795,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2219,2219,NULL,1,'2022-08-31 01:38:24','2022-08-31 01:38:24',40,'AC_BILL_VALIDATE','2022-08-31 01:38:24','2022-08-30 13:38:24',11,NULL,NULL,14090,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0769 validada','Autor: gdealba\nFactura FA2208-0769 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,796,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2220,2220,NULL,1,'2022-08-31 02:24:08','2022-08-31 02:24:08',40,'AC_BILL_VALIDATE','2022-08-31 02:24:08','2022-08-30 14:24:08',11,NULL,NULL,13994,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0770 validada','Autor: gdealba\nFactura FA2208-0770 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,797,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2221,2221,NULL,1,'2022-08-31 02:24:52','2022-08-31 02:24:52',40,'AC_BILL_VALIDATE','2022-08-31 02:24:52','2022-08-30 14:24:52',11,NULL,NULL,14085,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0771 validada','Autor: gdealba\nFactura FA2208-0771 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,798,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2222,2222,NULL,1,'2022-08-31 02:26:02','2022-08-31 02:26:02',40,'AC_BILL_VALIDATE','2022-08-31 02:26:02','2022-08-30 14:26:02',11,NULL,NULL,13777,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0772 validada','Autor: gdealba\nFactura FA2208-0772 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,799,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2223,2223,NULL,1,'2022-08-31 02:26:52','2022-08-31 02:26:52',40,'AC_BILL_VALIDATE','2022-08-31 02:26:52','2022-08-30 14:26:52',11,NULL,NULL,14162,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0773 validada','Autor: gdealba\nFactura FA2208-0773 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,800,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2224,2224,NULL,1,'2022-08-31 02:28:17','2022-08-31 02:28:17',40,'AC_BILL_VALIDATE','2022-08-31 02:28:17','2022-08-30 14:28:17',11,NULL,NULL,12717,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0774 validada','Autor: gdealba\nFactura FA2208-0774 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,801,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2225,2225,NULL,1,'2022-08-31 02:30:04','2022-08-31 02:30:04',40,'AC_BILL_VALIDATE','2022-08-31 02:30:04','2022-08-30 14:30:04',11,NULL,NULL,12131,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0775 validada','Autor: gdealba\nFactura FA2208-0775 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,802,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2226,2226,NULL,1,'2022-08-31 02:31:17','2022-08-31 02:31:17',40,'AC_BILL_VALIDATE','2022-08-31 02:31:17','2022-08-30 14:31:17',11,NULL,NULL,13543,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0776 validada','Autor: gdealba\nFactura FA2208-0776 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,803,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2227,2227,NULL,1,'2022-08-31 02:33:08','2022-08-31 02:33:08',40,'AC_BILL_VALIDATE','2022-08-31 02:33:08','2022-08-30 14:33:08',11,NULL,NULL,13670,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0777 validada','Autor: gdealba\nFactura FA2208-0777 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,804,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2228,2228,NULL,1,'2022-08-31 02:34:35','2022-08-31 02:34:35',40,'AC_BILL_VALIDATE','2022-08-31 02:34:35','2022-08-30 14:34:35',11,NULL,NULL,14365,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0778 validada','Autor: gdealba\nFactura FA2208-0778 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,805,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2229,2229,NULL,1,'2022-08-31 02:35:51','2022-08-31 02:35:51',40,'AC_BILL_VALIDATE','2022-08-31 02:35:51','2022-08-30 14:35:51',11,NULL,NULL,14365,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0779 validada','Autor: gdealba\nFactura FA2208-0779 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,806,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2230,2230,NULL,1,'2022-08-31 13:56:57','2022-08-31 13:56:57',40,'AC_BILL_VALIDATE','2022-08-31 13:56:57','2022-08-31 01:56:57',11,NULL,NULL,13997,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0780 validada','Autor: gdealba\nFactura FA2208-0780 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,807,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2231,2231,NULL,1,'2022-08-31 13:58:48','2022-08-31 13:58:48',40,'AC_BILL_VALIDATE','2022-08-31 13:58:48','2022-08-31 01:58:48',11,NULL,NULL,13875,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0781 validada','Autor: gdealba\nFactura FA2208-0781 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,808,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2232,2232,NULL,1,'2022-08-31 13:59:31','2022-08-31 13:59:31',40,'AC_BILL_VALIDATE','2022-08-31 13:59:31','2022-08-31 01:59:31',11,NULL,NULL,13810,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0782 validada','Autor: gdealba\nFactura FA2208-0782 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,809,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2233,2233,NULL,1,'2022-08-31 14:00:53','2022-08-31 14:00:53',40,'AC_BILL_VALIDATE','2022-08-31 14:00:53','2022-08-31 02:00:53',11,NULL,NULL,13811,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0783 validada','Autor: gdealba\nFactura FA2208-0783 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,810,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2234,2234,NULL,1,'2022-08-31 14:02:56','2022-08-31 14:02:56',40,'AC_BILL_VALIDATE','2022-08-31 14:02:56','2022-08-31 02:02:56',11,NULL,NULL,14166,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0784 validada','Autor: gdealba\nFactura FA2208-0784 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,811,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2235,2235,NULL,1,'2022-08-31 14:03:38','2022-08-31 14:03:38',40,'AC_BILL_VALIDATE','2022-08-31 14:03:38','2022-08-31 02:03:38',11,NULL,NULL,10803,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0785 validada','Autor: gdealba\nFactura FA2208-0785 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,812,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2236,2236,NULL,1,'2022-08-31 14:05:18','2022-08-31 14:05:18',40,'AC_BILL_VALIDATE','2022-08-31 14:05:18','2022-08-31 02:05:18',11,NULL,NULL,11074,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0786 validada','Autor: gdealba\nFactura FA2208-0786 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,813,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2237,2237,NULL,1,'2022-08-31 14:06:28','2022-08-31 14:06:28',40,'AC_BILL_VALIDATE','2022-08-31 14:06:28','2022-08-31 02:06:28',11,NULL,NULL,11076,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0787 validada','Autor: gdealba\nFactura FA2208-0787 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,814,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2238,2238,NULL,1,'2022-08-31 14:07:59','2022-08-31 14:07:59',40,'AC_BILL_VALIDATE','2022-08-31 14:07:59','2022-08-31 02:07:59',11,NULL,NULL,11625,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0788 validada','Autor: gdealba\nFactura FA2208-0788 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,815,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2239,2239,NULL,1,'2022-08-31 14:09:04','2022-08-31 14:09:04',40,'AC_BILL_VALIDATE','2022-08-31 14:09:04','2022-08-31 02:09:04',11,NULL,NULL,12246,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0789 validada','Autor: gdealba\nFactura FA2208-0789 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,816,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2240,2240,NULL,1,'2022-08-31 14:11:54','2022-08-31 14:11:54',40,'AC_BILL_VALIDATE','2022-08-31 14:11:54','2022-08-31 02:11:54',11,NULL,NULL,13539,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0790 validada','Autor: gdealba\nFactura FA2208-0790 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,817,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2241,2241,NULL,1,'2022-08-31 14:13:23','2022-08-31 14:13:23',40,'AC_BILL_VALIDATE','2022-08-31 14:13:23','2022-08-31 02:13:23',11,NULL,NULL,13902,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0791 validada','Autor: gdealba\nFactura FA2208-0791 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,818,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2242,2242,NULL,1,'2022-08-31 14:14:57','2022-08-31 14:14:57',40,'AC_BILL_VALIDATE','2022-08-31 14:14:57','2022-08-31 02:14:57',11,NULL,NULL,13928,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0792 validada','Autor: gdealba\nFactura FA2208-0792 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,819,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2243,2243,NULL,1,'2022-08-31 14:16:14','2022-08-31 14:16:14',40,'AC_BILL_VALIDATE','2022-08-31 14:16:14','2022-08-31 02:16:14',11,NULL,NULL,14362,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0793 validada','Autor: gdealba\nFactura FA2208-0793 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,820,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2244,2244,NULL,1,'2022-08-31 14:18:51','2022-08-31 14:18:51',40,'AC_BILL_VALIDATE','2022-08-31 14:18:51','2022-08-31 02:18:52',11,NULL,NULL,14049,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0794 validada','Autor: gdealba\nFactura FA2208-0794 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,821,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2245,2245,NULL,1,'2022-08-31 14:23:40','2022-08-31 14:23:40',40,'AC_BILL_VALIDATE','2022-08-31 14:23:40','2022-08-31 02:23:40',11,NULL,NULL,14094,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0795 validada','Autor: gdealba\nFactura FA2208-0795 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,822,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2246,2246,NULL,1,'2022-08-31 14:25:34','2022-08-31 14:25:34',40,'AC_BILL_VALIDATE','2022-08-31 14:25:34','2022-08-31 02:25:34',11,NULL,NULL,10790,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0796 validada','Autor: gdealba\nFactura FA2208-0796 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,823,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2247,2247,NULL,1,'2022-08-31 14:26:24','2022-08-31 14:26:24',40,'AC_BILL_VALIDATE','2022-08-31 14:26:24','2022-08-31 02:26:24',11,NULL,NULL,10984,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0797 validada','Autor: gdealba\nFactura FA2208-0797 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,824,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2248,2248,NULL,1,'2022-08-31 14:27:24','2022-08-31 14:27:24',40,'AC_BILL_VALIDATE','2022-08-31 14:27:24','2022-08-31 02:27:24',11,NULL,NULL,10985,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0798 validada','Autor: gdealba\nFactura FA2208-0798 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,825,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2249,2249,NULL,1,'2022-08-31 14:30:20','2022-08-31 14:30:20',40,'AC_BILL_VALIDATE','2022-08-31 14:30:20','2022-08-31 02:30:20',11,NULL,NULL,10994,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0799 validada','Autor: gdealba\nFactura FA2208-0799 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,826,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2250,2250,NULL,1,'2022-08-31 14:31:27','2022-08-31 14:31:27',40,'AC_BILL_VALIDATE','2022-08-31 14:31:27','2022-08-31 02:31:27',11,NULL,NULL,11000,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0800 validada','Autor: gdealba\nFactura FA2208-0800 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,827,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2251,2251,NULL,1,'2022-08-31 14:33:07','2022-08-31 14:33:07',40,'AC_BILL_VALIDATE','2022-08-31 14:33:07','2022-08-31 02:33:07',11,NULL,NULL,11124,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0801 validada','Autor: gdealba\nFactura FA2208-0801 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,828,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2252,2252,NULL,1,'2022-08-31 14:34:53','2022-08-31 14:34:53',40,'AC_BILL_VALIDATE','2022-08-31 14:34:53','2022-08-31 02:34:53',11,NULL,NULL,11776,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0802 validada','Autor: gdealba\nFactura FA2208-0802 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,829,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2253,2253,NULL,1,'2022-08-31 14:35:35','2022-08-31 14:35:35',40,'AC_BILL_VALIDATE','2022-08-31 14:35:35','2022-08-31 02:35:35',11,NULL,NULL,12175,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0803 validada','Autor: gdealba\nFactura FA2208-0803 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,830,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2254,2254,NULL,1,'2022-08-31 14:36:14','2022-08-31 14:36:14',40,'AC_BILL_VALIDATE','2022-08-31 14:36:14','2022-08-31 02:36:14',11,NULL,NULL,12219,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0804 validada','Autor: gdealba\nFactura FA2208-0804 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,831,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2255,2255,NULL,1,'2022-08-31 14:38:05','2022-08-31 14:38:05',40,'AC_BILL_VALIDATE','2022-08-31 14:38:05','2022-08-31 02:38:05',11,NULL,NULL,13990,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0805 validada','Autor: gdealba\nFactura FA2208-0805 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,832,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2256,2256,NULL,1,'2022-08-31 14:39:30','2022-08-31 14:39:30',40,'AC_BILL_VALIDATE','2022-08-31 14:39:30','2022-08-31 02:39:30',11,NULL,NULL,13865,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0806 validada','Autor: gdealba\nFactura FA2208-0806 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,833,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2257,2257,NULL,1,'2022-08-31 14:43:49','2022-08-31 14:43:49',40,'AC_BILL_VALIDATE','2022-08-31 14:43:49','2022-08-31 02:43:49',11,NULL,NULL,10946,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0807 validada','Autor: gdealba\nFactura FA2208-0807 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,834,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2258,2258,NULL,1,'2022-08-31 14:45:16','2022-08-31 14:45:16',40,'AC_BILL_VALIDATE','2022-08-31 14:45:16','2022-08-31 02:45:16',11,NULL,NULL,10958,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0808 validada','Autor: gdealba\nFactura FA2208-0808 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,835,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2259,2259,NULL,1,'2022-08-31 14:46:05','2022-08-31 14:46:05',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-31 14:46:05','2022-08-31 02:46:05',6,NULL,NULL,3,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0082 validada','Autor: egarcia\nFactura SI2208-0082 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,110,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2260,2260,NULL,1,'2022-08-31 14:46:15','2022-08-31 14:46:15',40,'AC_BILL_VALIDATE','2022-08-31 14:46:15','2022-08-31 02:46:15',11,NULL,NULL,10960,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0809 validada','Autor: gdealba\nFactura FA2208-0809 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,836,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2261,2261,NULL,1,'2022-08-31 14:47:54','2022-08-31 14:47:54',40,'AC_BILL_VALIDATE','2022-08-31 14:47:54','2022-08-31 02:47:54',11,NULL,NULL,10962,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0810 validada','Autor: gdealba\nFactura FA2208-0810 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,837,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2262,2262,NULL,1,'2022-08-31 14:48:46','2022-08-31 14:48:46',40,'AC_BILL_VALIDATE','2022-08-31 14:48:46','2022-08-31 02:48:46',11,NULL,NULL,10963,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0811 validada','Autor: gdealba\nFactura FA2208-0811 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,838,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2263,2263,NULL,1,'2022-08-31 14:50:32','2022-08-31 14:50:32',40,'AC_BILL_VALIDATE','2022-08-31 14:50:32','2022-08-31 02:50:32',11,NULL,NULL,11006,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0812 validada','Autor: gdealba\nFactura FA2208-0812 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,839,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2264,2264,NULL,1,'2022-08-31 14:51:39','2022-08-31 14:51:39',40,'AC_BILL_VALIDATE','2022-08-31 14:51:39','2022-08-31 02:51:39',11,NULL,NULL,11104,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0813 validada','Autor: gdealba\nFactura FA2208-0813 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,840,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2265,2265,NULL,1,'2022-08-31 14:53:42','2022-08-31 14:53:42',40,'AC_BILL_VALIDATE','2022-08-31 14:53:42','2022-08-31 02:53:42',11,NULL,NULL,12078,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0814 validada','Autor: gdealba\nFactura FA2208-0814 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,841,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2266,2266,NULL,1,'2022-08-31 14:54:31','2022-08-31 14:54:31',40,'AC_BILL_VALIDATE','2022-08-31 14:54:31','2022-08-31 02:54:31',11,NULL,NULL,12132,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0815 validada','Autor: gdealba\nFactura FA2208-0815 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,842,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2267,2267,NULL,1,'2022-08-31 14:55:31','2022-08-31 14:55:31',40,'AC_BILL_VALIDATE','2022-08-31 14:55:31','2022-08-31 02:55:31',11,NULL,NULL,12939,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0816 validada','Autor: gdealba\nFactura FA2208-0816 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,843,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2268,2268,NULL,1,'2022-08-31 14:58:32','2022-08-31 14:58:32',40,'AC_BILL_VALIDATE','2022-08-31 14:58:32','2022-08-31 02:58:32',11,NULL,NULL,12993,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0817 validada','Autor: gdealba\nFactura FA2208-0817 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,844,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2269,2269,NULL,1,'2022-08-31 14:59:25','2022-08-31 14:59:25',40,'AC_BILL_VALIDATE','2022-08-31 14:59:25','2022-08-31 02:59:25',11,NULL,NULL,13620,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0818 validada','Autor: gdealba\nFactura FA2208-0818 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,845,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2270,2270,NULL,1,'2022-08-31 15:00:36','2022-08-31 15:00:36',40,'AC_BILL_VALIDATE','2022-08-31 15:00:36','2022-08-31 03:00:36',11,NULL,NULL,13681,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0819 validada','Autor: gdealba\nFactura FA2208-0819 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,846,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2271,2271,NULL,1,'2022-08-31 15:01:46','2022-08-31 15:01:46',40,'AC_BILL_VALIDATE','2022-08-31 15:01:46','2022-08-31 03:01:46',11,NULL,NULL,14366,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0820 validada','Autor: gdealba\nFactura FA2208-0820 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,847,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2272,2272,NULL,1,'2022-08-31 15:02:38','2022-08-31 15:02:38',40,'AC_BILL_VALIDATE','2022-08-31 15:02:38','2022-08-31 03:02:38',11,NULL,NULL,14366,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0821 validada','Autor: gdealba\nFactura FA2208-0821 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,848,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2273,2273,NULL,1,'2022-08-31 15:03:48','2022-08-31 15:03:48',40,'AC_BILL_VALIDATE','2022-08-31 15:03:48','2022-08-31 03:03:48',11,NULL,NULL,14366,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0822 validada','Autor: gdealba\nFactura FA2208-0822 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,849,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2274,2274,NULL,1,'2022-08-31 15:09:02','2022-08-31 15:09:02',40,'AC_BILL_VALIDATE','2022-08-31 15:09:02','2022-08-31 03:09:02',11,NULL,NULL,14366,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0823 validada','Autor: gdealba\nFactura FA2208-0823 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,850,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2275,2275,NULL,1,'2022-08-31 15:11:02','2022-08-31 15:11:02',40,'AC_BILL_VALIDATE','2022-08-31 15:11:02','2022-08-31 03:11:02',11,NULL,NULL,14366,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0824 validada','Autor: gdealba\nFactura FA2208-0824 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,851,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2276,2276,NULL,1,'2022-08-31 15:19:33','2022-08-31 15:19:33',40,'AC_BILL_VALIDATE','2022-08-31 15:19:33','2022-08-31 03:19:33',11,NULL,NULL,14372,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0825 validada','Autor: gdealba\nFactura FA2208-0825 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,852,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2277,2277,NULL,1,'2022-08-31 15:24:12','2022-08-31 15:24:12',40,'AC_BILL_VALIDATE','2022-08-31 15:24:12','2022-08-31 03:24:12',11,NULL,NULL,13873,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0826 validada','Autor: gdealba\nFactura FA2208-0826 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,853,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2278,2278,NULL,1,'2022-08-31 15:26:06','2022-08-31 15:26:06',40,'AC_BILL_VALIDATE','2022-08-31 15:26:06','2022-08-31 03:26:06',11,NULL,NULL,12061,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0827 validada','Autor: gdealba\nFactura FA2208-0827 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,854,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2279,2279,NULL,1,'2022-08-31 15:27:30','2022-08-31 15:27:30',40,'AC_BILL_VALIDATE','2022-08-31 15:27:30','2022-08-31 03:27:30',11,NULL,NULL,13818,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0828 validada','Autor: gdealba\nFactura FA2208-0828 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,855,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2280,2280,NULL,1,'2022-08-31 15:28:50','2022-08-31 15:28:50',40,'AC_BILL_VALIDATE','2022-08-31 15:28:50','2022-08-31 03:28:50',11,NULL,NULL,11799,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0829 validada','Autor: gdealba\nFactura FA2208-0829 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,856,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2281,2281,NULL,1,'2022-08-31 15:29:46','2022-08-31 15:29:46',40,'AC_BILL_VALIDATE','2022-08-31 15:29:46','2022-08-31 03:29:46',11,NULL,NULL,11805,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0830 validada','Autor: gdealba\nFactura FA2208-0830 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,857,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2282,2282,NULL,1,'2022-08-31 15:30:48','2022-08-31 15:30:48',40,'AC_BILL_VALIDATE','2022-08-31 15:30:48','2022-08-31 03:30:48',11,NULL,NULL,11807,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0831 validada','Autor: gdealba\nFactura FA2208-0831 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,858,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2283,2283,NULL,1,'2022-08-31 15:35:59','2022-08-31 15:35:59',40,'AC_BILL_VALIDATE','2022-08-31 15:35:59','2022-08-31 03:35:59',11,NULL,NULL,12713,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0832 validada','Autor: gdealba\nFactura FA2208-0832 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,859,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2284,2284,NULL,1,'2022-08-31 15:37:59','2022-08-31 15:37:59',40,'AC_BILL_VALIDATE','2022-08-31 15:37:59','2022-08-31 03:37:59',11,NULL,NULL,12749,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0833 validada','Autor: gdealba\nFactura FA2208-0833 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,860,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2285,2285,NULL,1,'2022-08-31 15:38:53','2022-08-31 15:38:53',40,'AC_BILL_VALIDATE','2022-08-31 15:38:53','2022-08-31 03:38:53',11,NULL,NULL,12783,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0834 validada','Autor: gdealba\nFactura FA2208-0834 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,861,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2286,2286,NULL,1,'2022-08-31 15:40:58','2022-08-31 15:40:58',40,'AC_BILL_VALIDATE','2022-08-31 15:40:58','2022-08-31 03:40:58',11,NULL,NULL,13419,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0835 validada','Autor: gdealba\nFactura FA2208-0835 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,862,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2287,2287,NULL,1,'2022-08-31 15:42:33','2022-08-31 15:42:33',40,'AC_BILL_VALIDATE','2022-08-31 15:42:33','2022-08-31 03:42:33',11,NULL,NULL,13437,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0836 validada','Autor: gdealba\nFactura FA2208-0836 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,863,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2288,2288,NULL,1,'2022-08-31 15:44:44','2022-08-31 15:44:44',40,'AC_BILL_VALIDATE','2022-08-31 15:44:44','2022-08-31 03:44:44',11,NULL,NULL,13516,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0837 validada','Autor: gdealba\nFactura FA2208-0837 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,864,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2289,2289,NULL,1,'2022-08-31 15:46:40','2022-08-31 15:46:40',40,'AC_BILL_VALIDATE','2022-08-31 15:46:40','2022-08-31 03:46:40',11,NULL,NULL,14371,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0838 validada','Autor: gdealba\nFactura FA2208-0838 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,865,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2290,2290,NULL,1,'2022-08-31 15:49:26','2022-08-31 15:49:26',40,'AC_BILL_VALIDATE','2022-08-31 15:49:26','2022-08-31 03:49:26',11,NULL,NULL,14032,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0839 validada','Autor: gdealba\nFactura FA2208-0839 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,866,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2291,2291,NULL,1,'2022-08-31 15:50:22','2022-08-31 15:50:22',40,'AC_BILL_VALIDATE','2022-08-31 15:50:22','2022-08-31 03:50:22',11,NULL,NULL,14125,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0840 validada','Autor: gdealba\nFactura FA2208-0840 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,867,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2292,2292,NULL,1,'2022-08-31 15:51:36','2022-08-31 15:51:36',40,'AC_BILL_VALIDATE','2022-08-31 15:51:36','2022-08-31 03:51:36',11,NULL,NULL,13941,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0841 validada','Autor: gdealba\nFactura FA2208-0841 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,868,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2293,2293,NULL,1,'2022-08-31 15:53:44','2022-08-31 15:53:44',40,'AC_BILL_VALIDATE','2022-08-31 15:53:44','2022-08-31 03:53:44',11,NULL,NULL,10948,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0842 validada','Autor: gdealba\nFactura FA2208-0842 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,869,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2294,2294,NULL,1,'2022-08-31 15:55:03','2022-08-31 15:55:03',40,'AC_BILL_VALIDATE','2022-08-31 15:55:03','2022-08-31 03:55:03',11,NULL,NULL,14169,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0843 validada','Autor: gdealba\nFactura FA2208-0843 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,870,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2295,2295,NULL,1,'2022-08-31 15:56:36','2022-08-31 15:56:36',40,'AC_BILL_VALIDATE','2022-08-31 15:56:36','2022-08-31 03:56:36',11,NULL,NULL,10935,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0844 validada','Autor: gdealba\nFactura FA2208-0844 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,871,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2296,2296,NULL,1,'2022-08-31 15:58:27','2022-08-31 15:58:27',40,'AC_BILL_VALIDATE','2022-08-31 15:58:27','2022-08-31 03:58:27',11,NULL,NULL,10938,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0845 validada','Autor: gdealba\nFactura FA2208-0845 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,872,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2297,2297,NULL,1,'2022-08-31 15:59:17','2022-08-31 15:59:17',40,'AC_BILL_VALIDATE','2022-08-31 15:59:17','2022-08-31 03:59:17',11,NULL,NULL,10947,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0846 validada','Autor: gdealba\nFactura FA2208-0846 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,873,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2298,2298,NULL,1,'2022-08-31 16:00:51','2022-08-31 16:00:51',40,'AC_BILL_VALIDATE','2022-08-31 16:00:51','2022-08-31 04:00:51',11,NULL,NULL,11680,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0847 validada','Autor: gdealba\nFactura FA2208-0847 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,874,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2299,2299,NULL,1,'2022-08-31 16:02:21','2022-08-31 16:02:21',40,'AC_BILL_VALIDATE','2022-08-31 16:02:21','2022-08-31 04:02:21',11,NULL,NULL,12265,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0848 validada','Autor: gdealba\nFactura FA2208-0848 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,875,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2300,2300,NULL,1,'2022-08-31 16:05:22','2022-08-31 16:05:22',40,'AC_BILL_VALIDATE','2022-08-31 16:05:22','2022-08-31 04:05:22',11,NULL,NULL,14368,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0849 validada','Autor: gdealba\nFactura FA2208-0849 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,876,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2301,2301,NULL,1,'2022-08-31 17:26:14','2022-08-31 17:26:14',40,'AC_PRODUCT_MODIFY','2022-08-31 17:26:14','2022-08-31 05:26:14',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR500G modificado','Autor: admin\nProducto BPGR500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,205,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2302,2302,NULL,1,'2022-08-31 17:28:30','2022-08-31 17:28:30',40,'AC_PRODUCT_MODIFY','2022-08-31 17:28:30','2022-08-31 05:28:30',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPAVE500G modificado','Autor: admin\nProducto BPAVE500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,203,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2303,2303,NULL,1,'2022-08-31 17:29:38','2022-08-31 17:29:38',40,'AC_PRODUCT_MODIFY','2022-08-31 17:29:38','2022-08-31 05:29:38',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPMI500G modificado','Autor: admin\nProducto BPMI500G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,206,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2304,2304,NULL,1,'2022-08-31 17:30:38','2022-08-31 17:30:38',40,'AC_PRODUCT_MODIFY','2022-08-31 17:30:38','2022-08-31 05:30:38',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGCH400G modificado','Autor: admin\nProducto BPGCH400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,280,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2305,2305,NULL,1,'2022-08-31 17:31:17','2022-08-31 17:31:17',40,'AC_PRODUCT_MODIFY','2022-08-31 17:31:17','2022-08-31 05:31:17',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BP_BARRA_DE_COCO_400g modificado','Autor: admin\nProducto BP_BARRA_DE_COCO_400g modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,214,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2306,2306,NULL,1,'2022-08-31 17:32:11','2022-08-31 17:32:11',40,'AC_PRODUCT_MODIFY','2022-08-31 17:32:11','2022-08-31 05:32:11',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPLYA400G modificado','Autor: admin\nProducto BPLYA400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,208,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2307,2307,NULL,1,'2022-08-31 17:32:36','2022-08-31 17:32:36',40,'AC_PRODUCT_MODIFY','2022-08-31 17:32:36','2022-08-31 05:32:36',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPMA400G modificado','Autor: admin\nProducto BPMA400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,210,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2308,2308,NULL,1,'2022-08-31 17:33:40','2022-08-31 17:33:40',40,'AC_PRODUCT_MODIFY','2022-08-31 17:33:40','2022-08-31 05:33:40',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPNU400G modificado','Autor: admin\nProducto BPNU400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,211,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2309,2309,NULL,1,'2022-08-31 17:34:22','2022-08-31 17:34:22',40,'AC_PRODUCT_MODIFY','2022-08-31 17:34:22','2022-08-31 05:34:22',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPAA350G modificado','Autor: admin\nProducto BPAA350G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,209,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2310,2310,NULL,1,'2022-08-31 17:35:01','2022-08-31 17:35:01',40,'AC_PRODUCT_MODIFY','2022-08-31 17:35:01','2022-08-31 05:35:01',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPFL336G modificado','Autor: admin\nProducto BPFL336G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,212,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2311,2311,NULL,1,'2022-08-31 17:35:31','2022-08-31 17:35:31',40,'AC_PRODUCT_MODIFY','2022-08-31 17:35:31','2022-08-31 05:35:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BNPPIZ336G modificado','Autor: admin\nProducto BNPPIZ336G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,215,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2312,2312,NULL,1,'2022-08-31 17:35:54','2022-08-31 17:35:54',40,'AC_PRODUCT_MODIFY','2022-08-31 17:35:54','2022-08-31 05:35:54',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPOR200G modificado','Autor: admin\nProducto BPOR200G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,213,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2313,2313,NULL,1,'2022-08-31 17:36:26','2022-08-31 17:36:26',40,'AC_PRODUCT_MODIFY','2022-08-31 17:36:26','2022-08-31 05:36:26',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPGR100G modificado','Autor: admin\nProducto BPGR100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,279,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2314,2314,NULL,1,'2022-08-31 17:37:10','2022-08-31 17:37:10',40,'AC_PRODUCT_MODIFY','2022-08-31 17:37:10','2022-08-31 05:37:10',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPAVE100G modificado','Autor: admin\nProducto BPAVE100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,219,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2315,2315,NULL,1,'2022-08-31 17:37:42','2022-08-31 17:37:42',40,'AC_PRODUCT_MODIFY','2022-08-31 17:37:42','2022-08-31 05:37:42',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPPIZ100G modificado','Autor: admin\nProducto BPPIZ100G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,278,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2316,2316,NULL,1,'2022-08-31 17:44:26','2022-08-31 17:44:26',40,'AC_PRODUCT_MODIFY','2022-08-31 17:44:26','2022-08-31 05:44:26',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BP_EMILIAS modificado','Autor: admin\nProducto BP_EMILIAS modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,204,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2317,2317,NULL,1,'2022-08-31 17:44:58','2022-08-31 17:44:58',40,'AC_PRODUCT_MODIFY','2022-08-31 17:44:58','2022-08-31 05:44:58',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BISUR700G modificado','Autor: admin\nProducto BISUR700G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,216,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2318,2318,NULL,1,'2022-08-31 17:45:25','2022-08-31 17:45:25',40,'AC_PRODUCT_MODIFY','2022-08-31 17:45:25','2022-08-31 05:45:25',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BISUR700G modificado','Autor: admin\nProducto BISUR700G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,216,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2319,2319,NULL,1,'2022-08-31 17:46:58','2022-08-31 17:46:58',40,'AC_PRODUCT_MODIFY','2022-08-31 17:46:58','2022-08-31 05:46:58',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BISUS600G modificado','Autor: admin\nProducto BISUS600G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,217,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2320,2320,NULL,1,'2022-08-31 17:48:09','2022-08-31 17:48:09',40,'AC_PRODUCT_MODIFY','2022-08-31 17:48:09','2022-08-31 05:48:09',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BISAGRA_SEVILLANO modificado','Autor: admin\nProducto BISAGRA_SEVILLANO modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,218,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2321,2321,NULL,1,'2022-08-31 17:55:18','2022-08-31 17:55:18',40,'AC_PRODUCT_MODIFY','2022-08-31 17:55:18','2022-08-31 05:55:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MI40G modificado','Autor: admin\nProducto MI40G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,228,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2322,2322,NULL,1,'2022-08-31 17:58:00','2022-08-31 17:58:00',40,'AC_PRODUCT_MODIFY','2022-08-31 17:58:00','2022-08-31 05:58:00',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPSAN11GR modificado','Autor: admin\nProducto BPSAN11GR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,237,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2323,2323,NULL,1,'2022-08-31 17:58:36','2022-08-31 17:58:36',40,'AC_PRODUCT_MODIFY','2022-08-31 17:58:36','2022-08-31 05:58:36',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPMAN11GR modificado','Autor: admin\nProducto BPMAN11GR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,234,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2324,2324,NULL,1,'2022-08-31 18:00:19','2022-08-31 18:00:19',40,'AC_PRODUCT_MODIFY','2022-08-31 18:00:19','2022-08-31 06:00:19',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPELO11GR modificado','Autor: admin\nProducto BPELO11GR modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,236,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2325,2325,NULL,1,'2022-08-31 18:40:06','2022-08-31 18:40:06',40,'AC_BILL_DELETE','2022-08-31 18:40:06','2022-08-31 06:40:06',11,NULL,NULL,12561,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura eliminada','Autor: gdealba\nFactura eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,877,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2326,2326,NULL,1,'2022-08-31 18:46:37','2022-08-31 18:46:37',40,'AC_PRODUCT_MODIFY','2022-08-31 18:46:37','2022-08-31 06:46:37',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEAGRANEL modificado','Autor: admin\nProducto GRAGEAGRANEL modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,187,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2327,2327,NULL,1,'2022-08-31 18:46:57','2022-08-31 18:46:57',40,'AC_PRODUCT_MODIFY','2022-08-31 18:46:57','2022-08-31 06:46:57',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEAGRANEL modificado','Autor: admin\nProducto GRAGEAGRANEL modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,187,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2328,2328,NULL,1,'2022-08-31 18:50:00','2022-08-31 18:50:00',40,'AC_PRODUCT_MODIFY','2022-08-31 18:50:00','2022-08-31 06:50:00',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MINI_COCO_Granel modificado','Autor: admin\nProducto MINI_COCO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,195,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2329,2329,NULL,1,'2022-08-31 18:50:05','2022-08-31 18:50:05',40,'AC_BILL_SUPPLIER_VALIDATE','2022-08-31 18:50:05','2022-08-31 06:50:05',6,NULL,NULL,3,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura SI2208-0083 validada','Autor: egarcia\nFactura SI2208-0083 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,111,'invoice_supplier',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2330,2330,NULL,1,'2022-08-31 18:51:12','2022-08-31 18:51:12',40,'AC_PRODUCT_MODIFY','2022-08-31 18:51:12','2022-08-31 06:51:12',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GRAGEA_CHOCOLATE_Granel modificado','Autor: admin\nProducto GRAGEA_CHOCOLATE_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,193,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2331,2331,NULL,1,'2022-08-31 18:52:00','2022-08-31 18:52:00',40,'AC_PRODUCT_MODIFY','2022-08-31 18:52:00','2022-08-31 06:52:00',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BARRA_DE_COCO_Granel modificado','Autor: admin\nProducto BARRA_DE_COCO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,197,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2332,2332,NULL,1,'2022-08-31 18:53:03','2022-08-31 18:53:03',40,'AC_BILL_VALIDATE','2022-08-31 18:53:03','2022-08-31 06:53:03',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0850 validada','Autor: egarcia\nFactura FA2208-0850 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,879,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2333,2333,NULL,1,'2022-08-31 18:53:44','2022-08-31 18:53:44',40,'AC_PRODUCT_MODIFY','2022-08-31 18:53:44','2022-08-31 06:53:44',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPLYA400G modificado','Autor: admin\nProducto BPLYA400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,208,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2334,2334,NULL,1,'2022-08-31 18:54:09','2022-08-31 18:54:09',40,'AC_BILL_VALIDATE','2022-08-31 18:54:09','2022-08-31 06:54:09',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0851 validada','Autor: egarcia\nFactura FA2208-0851 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,880,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2335,2335,NULL,1,'2022-08-31 18:54:52','2022-08-31 18:54:52',40,'AC_PRODUCT_MODIFY','2022-08-31 18:54:52','2022-08-31 06:54:52',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto MARMOLEADAS_AZUCARADAS_Granel modificado','Autor: admin\nProducto MARMOLEADAS_AZUCARADAS_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,189,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2336,2336,NULL,1,'2022-08-31 18:55:19','2022-08-31 18:55:19',40,'AC_BILL_VALIDATE','2022-08-31 18:55:19','2022-08-31 06:55:19',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0852 validada','Autor: egarcia\nFactura FA2208-0852 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,881,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2337,2337,NULL,1,'2022-08-31 18:55:53','2022-08-31 18:55:53',40,'AC_BILL_VALIDATE','2022-08-31 18:55:53','2022-08-31 06:55:53',6,NULL,NULL,13746,NULL,0,6,NULL,0,0,'default',0,-1,'',NULL,'Factura FA2208-0853 validada','Autor: egarcia\nFactura FA2208-0853 validada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,882,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2338,2338,NULL,1,'2022-08-31 18:56:05','2022-08-31 18:56:05',40,'AC_PRODUCT_MODIFY','2022-08-31 18:56:05','2022-08-31 06:56:05',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto GTAS._NUEZ_CON_GLAS_Granel modificado','Autor: admin\nProducto GTAS._NUEZ_CON_GLAS_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,188,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2339,2339,NULL,1,'2022-08-31 18:57:54','2022-08-31 18:57:54',40,'AC_PRODUCT_MODIFY','2022-08-31 18:57:54','2022-08-31 06:57:54',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto VAINILLA_FLOR_DE_CAYRO_Granel modificado','Autor: admin\nProducto VAINILLA_FLOR_DE_CAYRO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,190,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2340,2340,NULL,1,'2022-08-31 18:57:59','2022-08-31 18:57:59',40,'AC_BILL_DELETE','2022-08-31 18:57:59','2022-08-31 06:57:59',11,NULL,NULL,12835,NULL,0,11,NULL,0,0,'default',0,-1,'',NULL,'Factura eliminada','Autor: gdealba\nFactura eliminada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,878,'invoice',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2341,2341,NULL,1,'2022-08-31 19:01:24','2022-08-31 19:01:24',40,'AC_PRODUCT_MODIFY','2022-08-31 19:01:24','2022-08-31 07:01:24',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto BPLYA400G modificado','Autor: admin\nProducto BPLYA400G modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,208,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2342,2342,NULL,1,'2022-08-31 19:04:16','2022-08-31 19:04:16',40,'AC_PRODUCT_MODIFY','2022-08-31 19:04:16','2022-08-31 07:04:16',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto PIZCA_DE_CHOCOLATE_Granel modificado','Autor: admin\nProducto PIZCA_DE_CHOCOLATE_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,199,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2343,2343,NULL,1,'2022-08-31 19:05:29','2022-08-31 19:05:29',40,'AC_PRODUCT_MODIFY','2022-08-31 19:05:29','2022-08-31 07:05:29',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto OREJAS_Granel modificado','Autor: admin\nProducto OREJAS_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,194,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2344,2344,NULL,1,'2022-08-31 19:06:23','2022-08-31 19:06:23',40,'AC_PRODUCT_MODIFY','2022-08-31 19:06:23','2022-08-31 07:06:23',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto SUSPIRO_Granel modificado','Autor: admin\nProducto SUSPIRO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,191,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2345,2345,NULL,1,'2022-08-31 19:07:51','2022-08-31 19:07:51',40,'AC_PRODUCT_MODIFY','2022-08-31 19:07:51','2022-08-31 07:07:51',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto SEVILLANO_Granel modificado','Autor: admin\nProducto SEVILLANO_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,198,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2346,2346,NULL,1,'2022-08-31 19:08:51','2022-08-31 19:08:51',40,'AC_PRODUCT_MODIFY','2022-08-31 19:08:51','2022-08-31 07:08:51',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto CACAHUATE_DE_FRESA_Granel modificado','Autor: admin\nProducto CACAHUATE_DE_FRESA_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,192,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2347,2347,NULL,1,'2022-08-31 19:10:28','2022-08-31 19:10:28',40,'AC_PRODUCT_MODIFY','2022-08-31 19:10:28','2022-08-31 07:10:28',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Producto TIMBRE_DE_FRESA_Granel modificado','Autor: admin\nProducto TIMBRE_DE_FRESA_Granel modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,200,'product',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2348,2348,NULL,1,'2022-08-31 19:24:43','2022-08-31 19:24:43',40,'AC_USER_CREATE','2022-08-31 19:24:43','2022-08-31 07:24:43',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro  creado','Autor: admin\nRegistro  creado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2349,2349,NULL,1,'2022-08-31 19:24:44','2022-08-31 19:24:44',40,'AC_USER_NEW_PASSWORD','2022-08-31 19:24:44','2022-08-31 07:24:44',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'PASSWORDInDolibarr','Autor: admin\nPASSWORDInDolibarr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2350,2350,NULL,1,'2022-08-31 19:25:32','2022-08-31 19:25:32',40,'AC_USER_MODIFY','2022-08-31 19:25:32','2022-08-31 07:25:32',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 10 modificado','Autor: admin\nRegistro 10 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,10,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2351,2351,NULL,1,'2022-08-31 19:25:35','2022-08-31 19:25:35',40,'AC_USER_MODIFY','2022-08-31 19:25:35','2022-08-31 07:25:35',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 10 modificado','Autor: admin\nRegistro 10 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,10,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2352,2352,NULL,1,'2022-08-31 19:25:45','2022-08-31 19:25:45',40,'AC_USER_MODIFY','2022-08-31 19:25:45','2022-08-31 07:25:45',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 10 modificado','Autor: admin\nRegistro 10 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,10,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2353,2353,NULL,1,'2022-08-31 19:25:47','2022-08-31 19:25:47',40,'AC_USER_MODIFY','2022-08-31 19:25:47','2022-08-31 07:25:47',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 10 modificado','Autor: admin\nRegistro 10 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,10,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2354,2354,NULL,1,'2022-08-31 19:25:49','2022-08-31 19:25:49',40,'AC_USER_MODIFY','2022-08-31 19:25:49','2022-08-31 07:25:49',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 10 modificado','Autor: admin\nRegistro 10 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,10,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2355,2355,NULL,1,'2022-08-31 19:25:51','2022-08-31 19:25:51',40,'AC_USER_MODIFY','2022-08-31 19:25:51','2022-08-31 07:25:51',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 10 modificado','Autor: admin\nRegistro 10 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,10,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2356,2356,NULL,1,'2022-08-31 19:27:50','2022-08-31 19:27:50',40,'AC_USER_MODIFY','2022-08-31 19:27:50','2022-08-31 07:27:50',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2357,2357,NULL,1,'2022-08-31 19:27:52','2022-08-31 19:27:52',40,'AC_USER_MODIFY','2022-08-31 19:27:52','2022-08-31 07:27:52',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2358,2358,NULL,1,'2022-08-31 19:27:53','2022-08-31 19:27:53',40,'AC_USER_MODIFY','2022-08-31 19:27:53','2022-08-31 07:27:53',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2359,2359,NULL,1,'2022-08-31 19:27:54','2022-08-31 19:27:54',40,'AC_USER_MODIFY','2022-08-31 19:27:54','2022-08-31 07:27:54',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2360,2360,NULL,1,'2022-08-31 19:27:56','2022-08-31 19:27:56',40,'AC_USER_MODIFY','2022-08-31 19:27:56','2022-08-31 07:27:56',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2361,2361,NULL,1,'2022-08-31 19:27:57','2022-08-31 19:27:57',40,'AC_USER_MODIFY','2022-08-31 19:27:57','2022-08-31 07:27:57',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2362,2362,NULL,1,'2022-08-31 19:27:59','2022-08-31 19:27:59',40,'AC_USER_MODIFY','2022-08-31 19:27:59','2022-08-31 07:27:59',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2363,2363,NULL,1,'2022-08-31 19:28:01','2022-08-31 19:28:01',40,'AC_USER_MODIFY','2022-08-31 19:28:01','2022-08-31 07:28:01',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2364,2364,NULL,1,'2022-08-31 19:28:02','2022-08-31 19:28:02',40,'AC_USER_MODIFY','2022-08-31 19:28:02','2022-08-31 07:28:02',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2365,2365,NULL,1,'2022-08-31 19:28:05','2022-08-31 19:28:05',40,'AC_USER_MODIFY','2022-08-31 19:28:05','2022-08-31 07:28:05',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2366,2366,NULL,1,'2022-08-31 19:28:06','2022-08-31 19:28:06',40,'AC_USER_MODIFY','2022-08-31 19:28:06','2022-08-31 07:28:06',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2367,2367,NULL,1,'2022-08-31 19:28:07','2022-08-31 19:28:07',40,'AC_USER_MODIFY','2022-08-31 19:28:07','2022-08-31 07:28:07',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2368,2368,NULL,1,'2022-08-31 19:28:08','2022-08-31 19:28:08',40,'AC_USER_MODIFY','2022-08-31 19:28:08','2022-08-31 07:28:08',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2369,2369,NULL,1,'2022-08-31 19:28:11','2022-08-31 19:28:11',40,'AC_USER_MODIFY','2022-08-31 19:28:11','2022-08-31 07:28:11',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2370,2370,NULL,1,'2022-08-31 19:28:12','2022-08-31 19:28:12',40,'AC_USER_MODIFY','2022-08-31 19:28:12','2022-08-31 07:28:12',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2371,2371,NULL,1,'2022-08-31 19:28:13','2022-08-31 19:28:13',40,'AC_USER_MODIFY','2022-08-31 19:28:13','2022-08-31 07:28:13',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2372,2372,NULL,1,'2022-08-31 19:28:15','2022-08-31 19:28:15',40,'AC_USER_MODIFY','2022-08-31 19:28:15','2022-08-31 07:28:15',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2373,2373,NULL,1,'2022-08-31 19:28:17','2022-08-31 19:28:17',40,'AC_USER_MODIFY','2022-08-31 19:28:17','2022-08-31 07:28:17',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2374,2374,NULL,1,'2022-08-31 19:28:18','2022-08-31 19:28:18',40,'AC_USER_MODIFY','2022-08-31 19:28:18','2022-08-31 07:28:18',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2375,2375,NULL,1,'2022-08-31 19:28:21','2022-08-31 19:28:21',40,'AC_USER_MODIFY','2022-08-31 19:28:21','2022-08-31 07:28:21',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2376,2376,NULL,1,'2022-08-31 19:28:22','2022-08-31 19:28:22',40,'AC_USER_MODIFY','2022-08-31 19:28:22','2022-08-31 07:28:22',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2377,2377,NULL,1,'2022-08-31 19:28:23','2022-08-31 19:28:23',40,'AC_USER_MODIFY','2022-08-31 19:28:23','2022-08-31 07:28:23',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2378,2378,NULL,1,'2022-08-31 19:28:25','2022-08-31 19:28:25',40,'AC_USER_MODIFY','2022-08-31 19:28:25','2022-08-31 07:28:25',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2379,2379,NULL,1,'2022-08-31 19:28:26','2022-08-31 19:28:26',40,'AC_USER_MODIFY','2022-08-31 19:28:26','2022-08-31 07:28:26',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2380,2380,NULL,1,'2022-08-31 19:28:29','2022-08-31 19:28:29',40,'AC_USER_MODIFY','2022-08-31 19:28:29','2022-08-31 07:28:29',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2381,2381,NULL,1,'2022-08-31 19:28:31','2022-08-31 19:28:31',40,'AC_USER_MODIFY','2022-08-31 19:28:31','2022-08-31 07:28:31',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2382,2382,NULL,1,'2022-08-31 19:28:32','2022-08-31 19:28:32',40,'AC_USER_MODIFY','2022-08-31 19:28:32','2022-08-31 07:28:32',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2383,2383,NULL,1,'2022-08-31 19:28:33','2022-08-31 19:28:33',40,'AC_USER_MODIFY','2022-08-31 19:28:33','2022-08-31 07:28:33',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2384,2384,NULL,1,'2022-08-31 19:28:35','2022-08-31 19:28:35',40,'AC_USER_MODIFY','2022-08-31 19:28:35','2022-08-31 07:28:35',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,13,'user',NULL,NULL,NULL,NULL);
INSERT INTO llx_actioncomm VALUES (2385,2385,NULL,1,'2022-08-31 19:28:37','2022-08-31 19:28:37',40,'AC_USER_MODIFY','2022-08-31 19:28:37','2022-08-31 07:28:37',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,'default',0,-1,'',NULL,'Registro 13 modificado','Autor: admin\nRegistro 13 modificado',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL