<!DOCTYPE html>
<html lang="es">

<head>
  <meta http-equiv="Content-type" content="text/html; charset=utf-8" />
  <!--<meta http-equiv="Content-type" content="text/html; charset=utf8mb4_general_ci" />-->
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
  <title>
    Cartera Vencida
  </title>
  <meta content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0, shrink-to-fit=no' name='viewport' />
  <link rel="stylesheet" type="text/css" href="https://fonts.googleapis.com/css?family=Roboto:300,400,500,700|Roboto+Slab:400,700|Material+Icons" />
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/latest/css/font-awesome.min.css">
  <link href="material-dashboard.css?v=2.0.2" rel="stylesheet" />
</head>

<body class="">
  <div class="wrapper ">

    <div class="main-panel">
      <div class="content">
        <div class="container-fluid">

          <div class="row">

            <?php

            if (isset($_GET['fecha1']) ) {
              $fecha1 = $_GET['fecha1'];
            } else {
              $fecha1=date("Y-m-d");
            }
            ?>

            <!------------------------------------------------------------------------------->

            <div class="row">
              <div class="col-md-12">
                <div class="card">
                  <div class="card-body">
                    <h2>Cartera Vencida</h2>
                    <form method="GET" action="carteravencida.php">
                      <div class="card-body ">
                        <div class="form-group">

                        </div>
                      </div>

                      <input type="date" name="fecha1" class="form-control" value="" placeholder="Fecha Corte" required>
                      <br>
                      <input type="submit" class="btn btn-primary" value="calcular">
                    </form>

                    <div class="table-responsive">
                      <table class="table table-striped">
                        <thead class=" text-primary">
                          <tr class="info">
                            <th>Codigo</th>
                            <th>Nombre(Cliente)</th>
                            <th>Ruta</th>
                            <th>Recorrido</th>
                            <th>Vendedor</th>
                            <th>Días Credito</th>
                            <th>Linea Credito</th>
                            <th>RFC</th>
                            <th>Correo</th>
                            <th>Telefono</th>
                            <th>Total Vencido</th>
                            <th>0-15 Días</th>
                            <th>16-30 Días</th>
                            <th>31-45 Días</th>
                            <th>46 o más Días</th>
                            <th>Comentarios</th>
                         </tr>
                        </thead>
                        <?php
                        require_once "config.php";
                        $i = 0;

                        //consulta para recuperar datos de clientes con deuda
                        $sql="SELECT 
                        a.rowid,
                        a.nom,
                        b.codigoalterno,
                        b.clasificacion1,
                        b.clasificacion2,
                        b.clasificacion3,
                        b.clasificacion5,
                        b.diascredito,
                        b.limitecredito,
                        a.siren,
	                      a.email,
	                      a.phone
                      FROM 
                        llx_societe a
                        LEFT JOIN llx_facture c ON c.fk_soc=a.rowid,
                        llx_societe_extrafields b
                      WHERE
                        a.rowid=b.fk_object AND
                        a.rowid=c.fk_soc AND
                        c.fk_statut=1 AND
                        b.diascredito IS NOT NULL AND
                        c.datef <= '".$fecha1."'
                      GROUP BY a.rowid
                      ORDER BY a.rowid";

                        $resultado = mysqli_query($con, $sql);
                          //echo "SQL: ".$sql."<br>";         
                          
                          while ($row = mysqli_fetch_assoc($resultado)) {
                            
                            $fk_socio=$row['rowid'];
                            $cliente=$row['nom'];
                            $codigoalterno=$row['codigoalterno'];
                            $clasificacion1=$row['clasificacion1'];
                            $clasificacion2=$row['clasificacion2'];
                            $clasificacion3=$row['clasificacion3'];
                            $clasificacion5=$row['clasificacion5'];
                            $dias_credito=$row['diascredito'];
                            $limitecredito=$row['limitecredito'];
                            $rfc=$row['siren'];
                            $email=$row['email'];
                            $telefono=$row['phone'];


                            //consulta para sacar las facturas que debe el cliente a la fecha seleccionada
                            $sql2="SELECT 
                            c.rowid,
                            c.datef,
                            c.total_ttc,
                            c.date_lim_reglement
                          FROM 
                            llx_societe a
                            LEFT JOIN llx_facture c ON c.fk_soc=a.rowid
                          WHERE
                            a.rowid=c.fk_soc AND
                            c.fk_statut=1 AND
                            c.datef <= '".$fecha1."' AND
                            a.rowid=".$fk_socio;

                            $resultado2 = mysqli_query($con, $sql2);
                              //echo "SQL: ".$sql2."<br>";         
                          
                              while ($row = mysqli_fetch_assoc($resultado2)) {

                                $fk_factura=$row['rowid'];
                                $fecha_factura=$row['datef'];
                                $total_factura=$row['total_ttc'];
                                $vence_factura=$row['date_lim_reglement'];


                                  //variable para restar pagos
                                  $gran_total=$total_factura;
                                    
                                  //dias a restar
                                  $dias_fin=date("Y-m-d");
                                 // $diferencia=$fecha_factura->diff ($dias_fin);
                                 // $dias_vencido=$diferencia->days;

                                    //se verifican los pagos realizados con margen de la fecha
                                    $sql3="SELECT 
                                    a.rowid,
                                    a.fk_facture,
                                    a.amount,
                                    DATE_FORMAT(b.datep,'%Y-%m-%d'),
                                    DATEDIFF (b.datep,c.datef) AS dias_vencido
                                  FROM
                                    llx_paiement_facture a,
                                    llx_paiement b,
                                    llx_facture c
                                  WHERE
                                    a.fk_paiement=b.rowid AND
                                    a.fk_facture=c.rowid AND
                                    b.datep <= '".$fecha1."' AND
                                    a.fk_facture=".$fk_factura."
                                  ORDER BY datep";
                                    $resultado3 = mysqli_query($con, $sql3);
                                    //echo "SQL: ".$sql3."<br>"; 
                                    
                                    while ($row = mysqli_fetch_assoc($resultado3)) {

                                      $fk_pago=$row['rowid'];
                                      $cantidad_pago=$row['amount'];
                                      $fecha_pago=$row['datep'];
                                      $dias_vencido= $row['dias_vencido'];

                                        //se clasifica 

                                      $gran_total=$gran_total-$cantidad_pago;

                                    } //pagos
                                      
                                        //total global facturado
                                        $suma = $suma + $gran_total;
                                        //echo "</br>El total a facturar es:".$suma."</br>";
                                      
                                        /*se determina cuanto tiempo lleva vencida
                                        y el monto en ese periodo*/
                                        //echo "Dias vencidos: ".$dias_vencido."</br>";
                                        echo "Dias vencidos: ".$dias_vencido."</br> Dias de credito".$dias_credito."</br>";

                                        /*0 a 15*/if($dias_vencido<=15){

                                          $monto_menor15=$monto_menor15+$gran_total;

                                        /*16 a 30*/}elseif($dias_vencido>=16 && $dias_vencido<=30){

                                          $monto_menor30=$monto_menor30+$gran_total;

                                        /*31 a 45*/}elseif($dias_vencido>=31 && $dias_vencido<=45){

                                          $monto_menor45=$monto_menor45+$gran_total;

                                        /*46 o mas */}elseif($dias_vencido>=46){

                                          $monto_mayor46=$monto_mayor46+$gran_total;

                                        }

                              } //facturas
 

                      if($suma >= floatval($limitecredito)){

                        echo "</br>El total a facturar es:".$suma."</br>El limite de credito es:".floatval($limitecredito)."</br>";

                          echo "<tbody>";
                          echo "<tr>";
                          echo "<td>".$codigoalterno."</td>";
                          echo "<td>".$cliente."</td>";
                          echo "<td>".$clasificacion1."</td>";
                          echo "<td>".$clasificacion3."</td>";
                          echo "<td></td>";
                          echo "<td>".$dias_credito."</td>";
                          echo "<td>$".number_format($limitecredito,2)."</td>";
                          echo "<td>".$rfc."</td>";
                          echo "<td>".$email."</td>";
                          echo "<td>".$telefono."</td>";
                          echo "<td>$".number_format($suma,2)."</td>";
                          echo "<td>$".number_format($monto_menor15,2)."</td>";
                          echo "<td>$".number_format($monto_menor30,2)."</td>";
                          echo "<td>$".number_format($monto_menor45,2)."</td>";
                          echo "<td>$".number_format($monto_mayor46,2)."</td>"; 
                          echo "<tr>";

                      }  
                          } //clientes

                        ?>
                      </table>

                      <?php
                      if (isset($_GET['fecha1']) ) {
  
                        echo '
                        <div class="btn-group pull-right">
                        
                        <a href ="generarExcel_carteravencida.php?fecha1='.$fecha1.'"class="btn btn-primary btn-round">
                        
                             <i class="material-icons">get_app</i> Exportar Excel
                                 <div class="ripple-container"></div></a>
                         </div>
                        
                        
                         </br>
                         </br>
                         </br>
                        
                        ';
                      }
                      ?>
                      
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <script src="jquery.min.js"></script>
  </div>
  <script src="assets/js/core/jquery.min.js"></script>
  <script src="assets/js/plugins/perfect-scrollbar.min.js"></script>
  <script src="assets/js/plugins/moment.min.js"></script>
  <script src="assets/js/plugins/bootstrap-datetimepicker.min.js"></script>

  <script src="assets/js/material-dashboard.js?v=2.2.2" type="text/javascript"></script>

</body>
</html>